//
// Copyright 2024 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

#include "pxr/pxr.h"
#include "pxr/base/tf/registryManager.h"
#include "pxr/base/tf/scriptModuleLoader.h"
#include "pxr/base/tf/token.h"

#include <vector>

PXR_NAMESPACE_OPEN_SCOPE

TF_REGISTRY_FUNCTION(TfScriptModuleLoader) {
    // List of direct dependencies for this library.
    const std::vector<TfToken> reqs = {
		TfToken("gf"),
		TfToken("tf"),
		TfToken("plug"),
		TfToken("trace"),
		TfToken("vt"),
		TfToken("work"),
		TfToken("hio"),
		TfToken("garch"),
		TfToken("glf"),
		TfToken("hd"),
		TfToken("hdsi"),
		TfToken("hdx"),
		TfToken("pxOsd"),
		TfToken("sdf"),
		TfToken("sdr"),
		TfToken("usd"),
		TfToken("usdGeom"),
		TfToken("usdHydra"),
		TfToken("usdShade"),
		TfToken("usdImaging"),
		TfToken("ar")
    };
    TfScriptModuleLoader::GetInstance().
        RegisterLibrary(TfToken("usdImagingGL"), TfToken("pxr.UsdImagingGL"), reqs);
}

PXR_NAMESPACE_CLOSE_SCOPE