// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-op'; DO NOT EDIT

package iaas

import (
	"context"

	"github.com/sacloud/iaas-api-go/types"
	"github.com/sacloud/packages-go/mutexkv"
)

var apiLocker = mutexkv.NewMutexKV()

func init() {

	SetClientFactoryFunc("Archive", func(caller APICaller) interface{} {
		return &ArchiveOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "archive",
		}
	})

	SetClientFactoryFunc("AuthStatus", func(caller APICaller) interface{} {
		return &AuthStatusOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "auth-status",
		}
	})

	SetClientFactoryFunc("AutoBackup", func(caller APICaller) interface{} {
		return &AutoBackupOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("AutoScale", func(caller APICaller) interface{} {
		return &AutoScaleOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("Bill", func(caller APICaller) interface{} {
		return &BillOp{
			Client:     caller,
			PathSuffix: "api/system/1.0",
			PathName:   "bill",
		}
	})

	SetClientFactoryFunc("Bridge", func(caller APICaller) interface{} {
		return &BridgeOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "bridge",
		}
	})

	SetClientFactoryFunc("CDROM", func(caller APICaller) interface{} {
		return &CDROMOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "cdrom",
		}
	})

	SetClientFactoryFunc("CertificateAuthority", func(caller APICaller) interface{} {
		return &CertificateAuthorityOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("ContainerRegistry", func(caller APICaller) interface{} {
		return &ContainerRegistryOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("Coupon", func(caller APICaller) interface{} {
		return &CouponOp{
			Client:     caller,
			PathSuffix: "api/system/1.0",
			PathName:   "coupon",
		}
	})

	SetClientFactoryFunc("Database", func(caller APICaller) interface{} {
		return &DatabaseOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "appliance",
		}
	})

	SetClientFactoryFunc("Disk", func(caller APICaller) interface{} {
		return &DiskOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "disk",
		}
	})

	SetClientFactoryFunc("DiskPlan", func(caller APICaller) interface{} {
		return &DiskPlanOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "product/disk",
		}
	})

	SetClientFactoryFunc("DNS", func(caller APICaller) interface{} {
		return &DNSOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("EnhancedDB", func(caller APICaller) interface{} {
		return &EnhancedDBOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("ESME", func(caller APICaller) interface{} {
		return &ESMEOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("GSLB", func(caller APICaller) interface{} {
		return &GSLBOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("Icon", func(caller APICaller) interface{} {
		return &IconOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "icon",
		}
	})

	SetClientFactoryFunc("Interface", func(caller APICaller) interface{} {
		return &InterfaceOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "interface",
		}
	})

	SetClientFactoryFunc("Internet", func(caller APICaller) interface{} {
		return &InternetOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "internet",
		}
	})

	SetClientFactoryFunc("InternetPlan", func(caller APICaller) interface{} {
		return &InternetPlanOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "product/internet",
		}
	})

	SetClientFactoryFunc("IPAddress", func(caller APICaller) interface{} {
		return &IPAddressOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "ipaddress",
		}
	})

	SetClientFactoryFunc("IPv6Net", func(caller APICaller) interface{} {
		return &IPv6NetOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "ipv6net",
		}
	})

	SetClientFactoryFunc("IPv6Addr", func(caller APICaller) interface{} {
		return &IPv6AddrOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "ipv6addr",
		}
	})

	SetClientFactoryFunc("License", func(caller APICaller) interface{} {
		return &LicenseOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "license",
		}
	})

	SetClientFactoryFunc("LicenseInfo", func(caller APICaller) interface{} {
		return &LicenseInfoOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "product/license",
		}
	})

	SetClientFactoryFunc("LoadBalancer", func(caller APICaller) interface{} {
		return &LoadBalancerOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "appliance",
		}
	})

	SetClientFactoryFunc("LocalRouter", func(caller APICaller) interface{} {
		return &LocalRouterOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("MobileGateway", func(caller APICaller) interface{} {
		return &MobileGatewayOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "appliance",
		}
	})

	SetClientFactoryFunc("NFS", func(caller APICaller) interface{} {
		return &NFSOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "appliance",
		}
	})

	SetClientFactoryFunc("Note", func(caller APICaller) interface{} {
		return &NoteOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "note",
		}
	})

	SetClientFactoryFunc("PacketFilter", func(caller APICaller) interface{} {
		return &PacketFilterOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "packetfilter",
		}
	})

	SetClientFactoryFunc("PrivateHost", func(caller APICaller) interface{} {
		return &PrivateHostOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "privatehost",
		}
	})

	SetClientFactoryFunc("PrivateHostPlan", func(caller APICaller) interface{} {
		return &PrivateHostPlanOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "product/privatehost",
		}
	})

	SetClientFactoryFunc("ProxyLB", func(caller APICaller) interface{} {
		return &ProxyLBOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("Region", func(caller APICaller) interface{} {
		return &RegionOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "region",
		}
	})

	SetClientFactoryFunc("Server", func(caller APICaller) interface{} {
		return &ServerOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "server",
		}
	})

	SetClientFactoryFunc("ServerPlan", func(caller APICaller) interface{} {
		return &ServerPlanOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "product/server",
		}
	})

	SetClientFactoryFunc("ServiceClass", func(caller APICaller) interface{} {
		return &ServiceClassOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "public/price",
		}
	})

	SetClientFactoryFunc("SIM", func(caller APICaller) interface{} {
		return &SIMOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("SimpleMonitor", func(caller APICaller) interface{} {
		return &SimpleMonitorOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("SimpleNotificationDestination", func(caller APICaller) interface{} {
		return &SimpleNotificationDestinationOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("SimpleNotificationGroup", func(caller APICaller) interface{} {
		return &SimpleNotificationGroupOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "commonserviceitem",
		}
	})

	SetClientFactoryFunc("SSHKey", func(caller APICaller) interface{} {
		return &SSHKeyOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "sshkey",
		}
	})

	SetClientFactoryFunc("Subnet", func(caller APICaller) interface{} {
		return &SubnetOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "subnet",
		}
	})

	SetClientFactoryFunc("Switch", func(caller APICaller) interface{} {
		return &SwitchOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "switch",
		}
	})

	SetClientFactoryFunc("VPCRouter", func(caller APICaller) interface{} {
		return &VPCRouterOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "appliance",
		}
	})

	SetClientFactoryFunc("Zone", func(caller APICaller) interface{} {
		return &ZoneOp{
			Client:     caller,
			PathSuffix: "api/cloud/1.1",
			PathName:   "zone",
		}
	})
}

/*************************************************
* ArchiveOp
*************************************************/

// ArchiveOp implements ArchiveAPI interface
type ArchiveOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewArchiveOp creates new ArchiveOp instance
func NewArchiveOp(caller APICaller) ArchiveAPI {
	return GetClientFactoryFunc("Archive")(caller).(ArchiveAPI)
}

// Find is API call
func (o *ArchiveOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*ArchiveFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *ArchiveOp) Create(ctx context.Context, zone string, param *ArchiveCreateRequest) (*Archive, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Archive, nil
}

// CreateBlank is API call
func (o *ArchiveOp) CreateBlank(ctx context.Context, zone string, param *ArchiveCreateBlankRequest) (*Archive, *FTPServer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateBlankArgs(param)
	if err != nil {
		return nil, nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, nil, err
	}

	// build results
	results, err := o.transformCreateBlankResults(data)
	if err != nil {
		return nil, nil, err
	}
	return results.Archive, results.FTPServer, nil
}

// Read is API call
func (o *ArchiveOp) Read(ctx context.Context, zone string, id types.ID) (*Archive, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Archive, nil
}

// Update is API call
func (o *ArchiveOp) Update(ctx context.Context, zone string, id types.ID, param *ArchiveUpdateRequest) (*Archive, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Archive, nil
}

// Delete is API call
func (o *ArchiveOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// OpenFTP is API call
func (o *ArchiveOp) OpenFTP(ctx context.Context, zone string, id types.ID, openOption *OpenFTPRequest) (*FTPServer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"openOption": openOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/ftp", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformOpenFTPArgs(id, openOption)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformOpenFTPResults(data)
	if err != nil {
		return nil, err
	}
	return results.FTPServer, nil
}

// CloseFTP is API call
func (o *ArchiveOp) CloseFTP(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/ftp", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Share is API call
func (o *ArchiveOp) Share(ctx context.Context, zone string, id types.ID) (*ArchiveShareInfo, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/ftp", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformShareArgs(id)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformShareResults(data)
	if err != nil {
		return nil, err
	}
	return results.ArchiveShareInfo, nil
}

// CreateFromShared is API call
func (o *ArchiveOp) CreateFromShared(ctx context.Context, zone string, sourceArchiveID types.ID, destZoneID types.ID, param *ArchiveCreateRequestFromShared) (*Archive, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":         SakuraCloudAPIRoot,
		"pathSuffix":      o.PathSuffix,
		"pathName":        o.PathName,
		"zone":            zone,
		"sourceArchiveID": sourceArchiveID,
		"destZoneID":      destZoneID,
		"param":           param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.sourceArchiveID}}/to/zone/{{.destZoneID}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateFromSharedArgs(sourceArchiveID, destZoneID, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateFromSharedResults(data)
	if err != nil {
		return nil, err
	}
	return results.Archive, nil
}

// Transfer is API call
func (o *ArchiveOp) Transfer(ctx context.Context, zone string, sourceArchiveID types.ID, destZoneID types.ID, param *ArchiveTransferRequest) (*Archive, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":         SakuraCloudAPIRoot,
		"pathSuffix":      o.PathSuffix,
		"pathName":        o.PathName,
		"zone":            zone,
		"sourceArchiveID": sourceArchiveID,
		"destZoneID":      destZoneID,
		"param":           param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.sourceArchiveID}}/to/zone/{{.destZoneID}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformTransferArgs(sourceArchiveID, destZoneID, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformTransferResults(data)
	if err != nil {
		return nil, err
	}
	return results.Archive, nil
}

/*************************************************
* AuthStatusOp
*************************************************/

// AuthStatusOp implements AuthStatusAPI interface
type AuthStatusOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewAuthStatusOp creates new AuthStatusOp instance
func NewAuthStatusOp(caller APICaller) AuthStatusAPI {
	return GetClientFactoryFunc("AuthStatus")(caller).(AuthStatusAPI)
}

// Read is API call
func (o *AuthStatusOp) Read(ctx context.Context) (*AuthStatus, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.AuthStatus, nil
}

/*************************************************
* AutoBackupOp
*************************************************/

// AutoBackupOp implements AutoBackupAPI interface
type AutoBackupOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewAutoBackupOp creates new AutoBackupOp instance
func NewAutoBackupOp(caller APICaller) AutoBackupAPI {
	return GetClientFactoryFunc("AutoBackup")(caller).(AutoBackupAPI)
}

// Find is API call
func (o *AutoBackupOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*AutoBackupFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *AutoBackupOp) Create(ctx context.Context, zone string, param *AutoBackupCreateRequest) (*AutoBackup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoBackup, nil
}

// Read is API call
func (o *AutoBackupOp) Read(ctx context.Context, zone string, id types.ID) (*AutoBackup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoBackup, nil
}

// Update is API call
func (o *AutoBackupOp) Update(ctx context.Context, zone string, id types.ID, param *AutoBackupUpdateRequest) (*AutoBackup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoBackup, nil
}

// UpdateSettings is API call
func (o *AutoBackupOp) UpdateSettings(ctx context.Context, zone string, id types.ID, param *AutoBackupUpdateSettingsRequest) (*AutoBackup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoBackup, nil
}

// Delete is API call
func (o *AutoBackupOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* AutoScaleOp
*************************************************/

// AutoScaleOp implements AutoScaleAPI interface
type AutoScaleOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewAutoScaleOp creates new AutoScaleOp instance
func NewAutoScaleOp(caller APICaller) AutoScaleAPI {
	return GetClientFactoryFunc("AutoScale")(caller).(AutoScaleAPI)
}

// Find is API call
func (o *AutoScaleOp) Find(ctx context.Context, conditions *FindCondition) (*AutoScaleFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *AutoScaleOp) Create(ctx context.Context, param *AutoScaleCreateRequest) (*AutoScale, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoScale, nil
}

// Read is API call
func (o *AutoScaleOp) Read(ctx context.Context, id types.ID) (*AutoScale, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoScale, nil
}

// Update is API call
func (o *AutoScaleOp) Update(ctx context.Context, id types.ID, param *AutoScaleUpdateRequest) (*AutoScale, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoScale, nil
}

// UpdateSettings is API call
func (o *AutoScaleOp) UpdateSettings(ctx context.Context, id types.ID, param *AutoScaleUpdateSettingsRequest) (*AutoScale, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoScale, nil
}

// Delete is API call
func (o *AutoScaleOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Status is API call
func (o *AutoScaleOp) Status(ctx context.Context, id types.ID) (*AutoScaleStatus, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/autoscale/status", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.AutoScaleStatus, nil
}

// ScaleUp is API call
func (o *AutoScaleOp) ScaleUp(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/autoscale/up", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ScaleDown is API call
func (o *AutoScaleOp) ScaleDown(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/autoscale/down", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* BillOp
*************************************************/

// BillOp implements BillAPI interface
type BillOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewBillOp creates new BillOp instance
func NewBillOp(caller APICaller) BillAPI {
	return GetClientFactoryFunc("Bill")(caller).(BillAPI)
}

// ByContract is API call
func (o *BillOp) ByContract(ctx context.Context, accountID types.ID) (*BillByContractResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"accountID":  accountID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/by-contract/{{.accountID}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformByContractResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// ByContractYear is API call
func (o *BillOp) ByContractYear(ctx context.Context, accountID types.ID, year int) (*BillByContractYearResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"accountID":  accountID,
		"year":       year,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/by-contract/{{.accountID}}/{{.year}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformByContractYearResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// ByContractYearMonth is API call
func (o *BillOp) ByContractYearMonth(ctx context.Context, accountID types.ID, year int, month int) (*BillByContractYearMonthResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"accountID":  accountID,
		"year":       year,
		"month":      month,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/by-contract/{{.accountID}}/{{.year}}/{{.month}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformByContractYearMonthResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *BillOp) Read(ctx context.Context, id types.ID) (*BillReadResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/id/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Details is API call
func (o *BillOp) Details(ctx context.Context, MemberCode string, id types.ID) (*BillDetailsResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"MemberCode": MemberCode,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}detail/{{.MemberCode}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformDetailsResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// DetailsCSV is API call
func (o *BillOp) DetailsCSV(ctx context.Context, MemberCode string, id types.ID) (*BillDetailCSV, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"MemberCode": MemberCode,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}detail/{{.MemberCode}}/{{.id}}/csv", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformDetailsCSVResults(data)
	if err != nil {
		return nil, err
	}
	return results.BillDetailCSV, nil
}

/*************************************************
* BridgeOp
*************************************************/

// BridgeOp implements BridgeAPI interface
type BridgeOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewBridgeOp creates new BridgeOp instance
func NewBridgeOp(caller APICaller) BridgeAPI {
	return GetClientFactoryFunc("Bridge")(caller).(BridgeAPI)
}

// Find is API call
func (o *BridgeOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*BridgeFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *BridgeOp) Create(ctx context.Context, zone string, param *BridgeCreateRequest) (*Bridge, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Bridge, nil
}

// Read is API call
func (o *BridgeOp) Read(ctx context.Context, zone string, id types.ID) (*Bridge, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Bridge, nil
}

// Update is API call
func (o *BridgeOp) Update(ctx context.Context, zone string, id types.ID, param *BridgeUpdateRequest) (*Bridge, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Bridge, nil
}

// Delete is API call
func (o *BridgeOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* CDROMOp
*************************************************/

// CDROMOp implements CDROMAPI interface
type CDROMOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewCDROMOp creates new CDROMOp instance
func NewCDROMOp(caller APICaller) CDROMAPI {
	return GetClientFactoryFunc("CDROM")(caller).(CDROMAPI)
}

// Find is API call
func (o *CDROMOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*CDROMFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *CDROMOp) Create(ctx context.Context, zone string, param *CDROMCreateRequest) (*CDROM, *FTPServer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, nil, err
	}
	return results.CDROM, results.FTPServer, nil
}

// Read is API call
func (o *CDROMOp) Read(ctx context.Context, zone string, id types.ID) (*CDROM, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.CDROM, nil
}

// Update is API call
func (o *CDROMOp) Update(ctx context.Context, zone string, id types.ID, param *CDROMUpdateRequest) (*CDROM, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.CDROM, nil
}

// Delete is API call
func (o *CDROMOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// OpenFTP is API call
func (o *CDROMOp) OpenFTP(ctx context.Context, zone string, id types.ID, openOption *OpenFTPRequest) (*FTPServer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"openOption": openOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/ftp", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformOpenFTPArgs(id, openOption)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformOpenFTPResults(data)
	if err != nil {
		return nil, err
	}
	return results.FTPServer, nil
}

// CloseFTP is API call
func (o *CDROMOp) CloseFTP(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/ftp", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* CertificateAuthorityOp
*************************************************/

// CertificateAuthorityOp implements CertificateAuthorityAPI interface
type CertificateAuthorityOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewCertificateAuthorityOp creates new CertificateAuthorityOp instance
func NewCertificateAuthorityOp(caller APICaller) CertificateAuthorityAPI {
	return GetClientFactoryFunc("CertificateAuthority")(caller).(CertificateAuthorityAPI)
}

// Find is API call
func (o *CertificateAuthorityOp) Find(ctx context.Context, conditions *FindCondition) (*CertificateAuthorityFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *CertificateAuthorityOp) Create(ctx context.Context, param *CertificateAuthorityCreateRequest) (*CertificateAuthority, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// Read is API call
func (o *CertificateAuthorityOp) Read(ctx context.Context, id types.ID) (*CertificateAuthority, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// Update is API call
func (o *CertificateAuthorityOp) Update(ctx context.Context, id types.ID, param *CertificateAuthorityUpdateRequest) (*CertificateAuthority, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// Delete is API call
func (o *CertificateAuthorityOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Detail is API call
func (o *CertificateAuthorityOp) Detail(ctx context.Context, id types.ID) (*CertificateAuthorityDetail, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformDetailResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// AddClient is API call
func (o *CertificateAuthorityOp) AddClient(ctx context.Context, id types.ID, param *CertificateAuthorityAddClientParam) (*CertificateAuthorityAddClientOrServerResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/clients", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformAddClientArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformAddClientResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// ListClients is API call
func (o *CertificateAuthorityOp) ListClients(ctx context.Context, id types.ID) (*CertificateAuthorityListClientsResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/clients", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformListClientsResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// ReadClient is API call
func (o *CertificateAuthorityOp) ReadClient(ctx context.Context, id types.ID, clientID string) (*CertificateAuthorityClient, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"clientID":   clientID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/clients/{{.clientID}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadClientResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// RevokeClient is API call
func (o *CertificateAuthorityOp) RevokeClient(ctx context.Context, id types.ID, clientID string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"clientID":   clientID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/clients/{{.clientID}}/revoke", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// HoldClient is API call
func (o *CertificateAuthorityOp) HoldClient(ctx context.Context, id types.ID, clientID string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"clientID":   clientID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/clients/{{.clientID}}/hold", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ResumeClient is API call
func (o *CertificateAuthorityOp) ResumeClient(ctx context.Context, id types.ID, clientID string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"clientID":   clientID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/clients/{{.clientID}}/resume", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DenyClient is API call
func (o *CertificateAuthorityOp) DenyClient(ctx context.Context, id types.ID, clientID string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"clientID":   clientID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/clients/{{.clientID}}/deny", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// AddServer is API call
func (o *CertificateAuthorityOp) AddServer(ctx context.Context, id types.ID, param *CertificateAuthorityAddServerParam) (*CertificateAuthorityAddClientOrServerResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/servers", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformAddServerArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformAddServerResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// ListServers is API call
func (o *CertificateAuthorityOp) ListServers(ctx context.Context, id types.ID) (*CertificateAuthorityListServersResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/servers", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformListServersResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// ReadServer is API call
func (o *CertificateAuthorityOp) ReadServer(ctx context.Context, id types.ID, serverID string) (*CertificateAuthorityServer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"serverID":   serverID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/servers/{{.serverID}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadServerResults(data)
	if err != nil {
		return nil, err
	}
	return results.CertificateAuthority, nil
}

// RevokeServer is API call
func (o *CertificateAuthorityOp) RevokeServer(ctx context.Context, id types.ID, serverID string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"serverID":   serverID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/servers/{{.serverID}}/revoke", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// HoldServer is API call
func (o *CertificateAuthorityOp) HoldServer(ctx context.Context, id types.ID, serverID string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"serverID":   serverID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/servers/{{.serverID}}/hold", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ResumeServer is API call
func (o *CertificateAuthorityOp) ResumeServer(ctx context.Context, id types.ID, serverID string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"serverID":   serverID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/certificateauthority/servers/{{.serverID}}/resume", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* ContainerRegistryOp
*************************************************/

// ContainerRegistryOp implements ContainerRegistryAPI interface
type ContainerRegistryOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewContainerRegistryOp creates new ContainerRegistryOp instance
func NewContainerRegistryOp(caller APICaller) ContainerRegistryAPI {
	return GetClientFactoryFunc("ContainerRegistry")(caller).(ContainerRegistryAPI)
}

// Find is API call
func (o *ContainerRegistryOp) Find(ctx context.Context, conditions *FindCondition) (*ContainerRegistryFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *ContainerRegistryOp) Create(ctx context.Context, param *ContainerRegistryCreateRequest) (*ContainerRegistry, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.ContainerRegistry, nil
}

// Read is API call
func (o *ContainerRegistryOp) Read(ctx context.Context, id types.ID) (*ContainerRegistry, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.ContainerRegistry, nil
}

// Update is API call
func (o *ContainerRegistryOp) Update(ctx context.Context, id types.ID, param *ContainerRegistryUpdateRequest) (*ContainerRegistry, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.ContainerRegistry, nil
}

// UpdateSettings is API call
func (o *ContainerRegistryOp) UpdateSettings(ctx context.Context, id types.ID, param *ContainerRegistryUpdateSettingsRequest) (*ContainerRegistry, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.ContainerRegistry, nil
}

// Delete is API call
func (o *ContainerRegistryOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ListUsers is API call
func (o *ContainerRegistryOp) ListUsers(ctx context.Context, id types.ID) (*ContainerRegistryUsers, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/containerregistry/users", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformListUsersResults(data)
	if err != nil {
		return nil, err
	}
	return results.ContainerRegistryUsers, nil
}

// AddUser is API call
func (o *ContainerRegistryOp) AddUser(ctx context.Context, id types.ID, param *ContainerRegistryUserCreateRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/containerregistry/users", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformAddUserArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// UpdateUser is API call
func (o *ContainerRegistryOp) UpdateUser(ctx context.Context, id types.ID, username string, param *ContainerRegistryUserUpdateRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"username":   username,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/containerregistry/users/{{.username}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateUserArgs(id, username, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DeleteUser is API call
func (o *ContainerRegistryOp) DeleteUser(ctx context.Context, id types.ID, username string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"username":   username,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/containerregistry/users/{{.username}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* CouponOp
*************************************************/

// CouponOp implements CouponAPI interface
type CouponOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewCouponOp creates new CouponOp instance
func NewCouponOp(caller APICaller) CouponAPI {
	return GetClientFactoryFunc("Coupon")(caller).(CouponAPI)
}

// Find is API call
func (o *CouponOp) Find(ctx context.Context, accountID types.ID) (*CouponFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"accountID":  accountID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.accountID}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

/*************************************************
* DatabaseOp
*************************************************/

// DatabaseOp implements DatabaseAPI interface
type DatabaseOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewDatabaseOp creates new DatabaseOp instance
func NewDatabaseOp(caller APICaller) DatabaseAPI {
	return GetClientFactoryFunc("Database")(caller).(DatabaseAPI)
}

// Find is API call
func (o *DatabaseOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*DatabaseFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *DatabaseOp) Create(ctx context.Context, zone string, param *DatabaseCreateRequest) (*Database, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Database, nil
}

// Read is API call
func (o *DatabaseOp) Read(ctx context.Context, zone string, id types.ID) (*Database, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Database, nil
}

// Update is API call
func (o *DatabaseOp) Update(ctx context.Context, zone string, id types.ID, param *DatabaseUpdateRequest) (*Database, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Database, nil
}

// UpdateSettings is API call
func (o *DatabaseOp) UpdateSettings(ctx context.Context, zone string, id types.ID, param *DatabaseUpdateSettingsRequest) (*Database, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.Database, nil
}

// Delete is API call
func (o *DatabaseOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Config is API call
func (o *DatabaseOp) Config(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/config", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Boot is API call
func (o *DatabaseOp) Boot(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Shutdown is API call
func (o *DatabaseOp) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *ShutdownOption) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":        SakuraCloudAPIRoot,
		"pathSuffix":     o.PathSuffix,
		"pathName":       o.PathName,
		"zone":           zone,
		"id":             id,
		"shutdownOption": shutdownOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}
	v, err := o.transformShutdownArgs(id, shutdownOption)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Reset is API call
func (o *DatabaseOp) Reset(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/reset", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// MonitorCPU is API call
func (o *DatabaseOp) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*CPUTimeActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/cpu/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorCPUArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorCPUResults(data)
	if err != nil {
		return nil, err
	}
	return results.CPUTimeActivity, nil
}

// MonitorDisk is API call
func (o *DatabaseOp) MonitorDisk(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*DiskActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/disk/0/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorDiskArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorDiskResults(data)
	if err != nil {
		return nil, err
	}
	return results.DiskActivity, nil
}

// MonitorInterface is API call
func (o *DatabaseOp) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*InterfaceActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorInterfaceArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorInterfaceResults(data)
	if err != nil {
		return nil, err
	}
	return results.InterfaceActivity, nil
}

// MonitorDatabase is API call
func (o *DatabaseOp) MonitorDatabase(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*DatabaseActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/database/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorDatabaseArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorDatabaseResults(data)
	if err != nil {
		return nil, err
	}
	return results.DatabaseActivity, nil
}

// Status is API call
func (o *DatabaseOp) Status(ctx context.Context, zone string, id types.ID) (*DatabaseStatus, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/status", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.DatabaseStatus, nil
}

// GetParameter is API call
func (o *DatabaseOp) GetParameter(ctx context.Context, zone string, id types.ID) (*DatabaseParameter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/database/parameter", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetParameterResults(data)
	if err != nil {
		return nil, err
	}
	return results.DatabaseParameter, nil
}

// SetParameter is API call
func (o *DatabaseOp) SetParameter(ctx context.Context, zone string, id types.ID, param map[string]interface{}) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/database/parameter", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetParameterArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* DiskOp
*************************************************/

// DiskOp implements DiskAPI interface
type DiskOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewDiskOp creates new DiskOp instance
func NewDiskOp(caller APICaller) DiskAPI {
	return GetClientFactoryFunc("Disk")(caller).(DiskAPI)
}

// Find is API call
func (o *DiskOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*DiskFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *DiskOp) Create(ctx context.Context, zone string, createParam *DiskCreateRequest, distantFrom []types.ID) (*Disk, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":     SakuraCloudAPIRoot,
		"pathSuffix":  o.PathSuffix,
		"pathName":    o.PathName,
		"zone":        zone,
		"createParam": createParam,
		"distantFrom": distantFrom,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(createParam, distantFrom)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Disk, nil
}

// Config is API call
func (o *DiskOp) Config(ctx context.Context, zone string, id types.ID, edit *DiskEditRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"edit":       edit,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/config", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformConfigArgs(id, edit)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// CreateWithConfig is API call
func (o *DiskOp) CreateWithConfig(ctx context.Context, zone string, createParam *DiskCreateRequest, editParam *DiskEditRequest, bootAtAvailable bool, distantFrom []types.ID) (*Disk, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":         SakuraCloudAPIRoot,
		"pathSuffix":      o.PathSuffix,
		"pathName":        o.PathName,
		"zone":            zone,
		"createParam":     createParam,
		"editParam":       editParam,
		"bootAtAvailable": bootAtAvailable,
		"distantFrom":     distantFrom,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateWithConfigArgs(createParam, editParam, bootAtAvailable, distantFrom)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateWithConfigResults(data)
	if err != nil {
		return nil, err
	}
	return results.Disk, nil
}

// ResizePartition is API call
func (o *DiskOp) ResizePartition(ctx context.Context, zone string, id types.ID, param *DiskResizePartitionRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/resize-partition", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformResizePartitionArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ConnectToServer is API call
func (o *DiskOp) ConnectToServer(ctx context.Context, zone string, id types.ID, serverID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"serverID":   serverID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/server/{{.serverID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DisconnectFromServer is API call
func (o *DiskOp) DisconnectFromServer(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/server", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Read is API call
func (o *DiskOp) Read(ctx context.Context, zone string, id types.ID) (*Disk, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Disk, nil
}

// Update is API call
func (o *DiskOp) Update(ctx context.Context, zone string, id types.ID, param *DiskUpdateRequest) (*Disk, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Disk, nil
}

// Delete is API call
func (o *DiskOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Monitor is API call
func (o *DiskOp) Monitor(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*DiskActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorResults(data)
	if err != nil {
		return nil, err
	}
	return results.DiskActivity, nil
}

// MonitorDisk is API call
func (o *DiskOp) MonitorDisk(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*DiskActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorDiskArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorDiskResults(data)
	if err != nil {
		return nil, err
	}
	return results.DiskActivity, nil
}

/*************************************************
* DiskPlanOp
*************************************************/

// DiskPlanOp implements DiskPlanAPI interface
type DiskPlanOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewDiskPlanOp creates new DiskPlanOp instance
func NewDiskPlanOp(caller APICaller) DiskPlanAPI {
	return GetClientFactoryFunc("DiskPlan")(caller).(DiskPlanAPI)
}

// Find is API call
func (o *DiskPlanOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*DiskPlanFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *DiskPlanOp) Read(ctx context.Context, zone string, id types.ID) (*DiskPlan, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.DiskPlan, nil
}

/*************************************************
* DNSOp
*************************************************/

// DNSOp implements DNSAPI interface
type DNSOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewDNSOp creates new DNSOp instance
func NewDNSOp(caller APICaller) DNSAPI {
	return GetClientFactoryFunc("DNS")(caller).(DNSAPI)
}

// Find is API call
func (o *DNSOp) Find(ctx context.Context, conditions *FindCondition) (*DNSFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *DNSOp) Create(ctx context.Context, param *DNSCreateRequest) (*DNS, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.DNS, nil
}

// Read is API call
func (o *DNSOp) Read(ctx context.Context, id types.ID) (*DNS, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.DNS, nil
}

// Update is API call
func (o *DNSOp) Update(ctx context.Context, id types.ID, param *DNSUpdateRequest) (*DNS, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.DNS, nil
}

// UpdateSettings is API call
func (o *DNSOp) UpdateSettings(ctx context.Context, id types.ID, param *DNSUpdateSettingsRequest) (*DNS, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.DNS, nil
}

// Delete is API call
func (o *DNSOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* EnhancedDBOp
*************************************************/

// EnhancedDBOp implements EnhancedDBAPI interface
type EnhancedDBOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewEnhancedDBOp creates new EnhancedDBOp instance
func NewEnhancedDBOp(caller APICaller) EnhancedDBAPI {
	return GetClientFactoryFunc("EnhancedDB")(caller).(EnhancedDBAPI)
}

// Find is API call
func (o *EnhancedDBOp) Find(ctx context.Context, conditions *FindCondition) (*EnhancedDBFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *EnhancedDBOp) Create(ctx context.Context, param *EnhancedDBCreateRequest) (*EnhancedDB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.EnhancedDB, nil
}

// Read is API call
func (o *EnhancedDBOp) Read(ctx context.Context, id types.ID) (*EnhancedDB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.EnhancedDB, nil
}

// Update is API call
func (o *EnhancedDBOp) Update(ctx context.Context, id types.ID, param *EnhancedDBUpdateRequest) (*EnhancedDB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.EnhancedDB, nil
}

// Delete is API call
func (o *EnhancedDBOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// SetPassword is API call
func (o *EnhancedDBOp) SetPassword(ctx context.Context, id types.ID, param *EnhancedDBSetPasswordRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/enhanceddb/set-password", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetPasswordArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// GetConfig is API call
func (o *EnhancedDBOp) GetConfig(ctx context.Context, id types.ID) (*EnhancedDBConfig, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/enhanceddb/config", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetConfigResults(data)
	if err != nil {
		return nil, err
	}
	return results.EnhancedDBConfig, nil
}

// SetConfig is API call
func (o *EnhancedDBOp) SetConfig(ctx context.Context, id types.ID, param *EnhancedDBSetConfigRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/enhanceddb/config", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetConfigArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* ESMEOp
*************************************************/

// ESMEOp implements ESMEAPI interface
type ESMEOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewESMEOp creates new ESMEOp instance
func NewESMEOp(caller APICaller) ESMEAPI {
	return GetClientFactoryFunc("ESME")(caller).(ESMEAPI)
}

// Find is API call
func (o *ESMEOp) Find(ctx context.Context, conditions *FindCondition) (*ESMEFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *ESMEOp) Create(ctx context.Context, param *ESMECreateRequest) (*ESME, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.ESME, nil
}

// Read is API call
func (o *ESMEOp) Read(ctx context.Context, id types.ID) (*ESME, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.ESME, nil
}

// Update is API call
func (o *ESMEOp) Update(ctx context.Context, id types.ID, param *ESMEUpdateRequest) (*ESME, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.ESME, nil
}

// Delete is API call
func (o *ESMEOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// SendMessageWithGeneratedOTP is API call
func (o *ESMEOp) SendMessageWithGeneratedOTP(ctx context.Context, id types.ID, param *ESMESendMessageWithGeneratedOTPRequest) (*ESMESendMessageResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/esme/2fa/otp", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformSendMessageWithGeneratedOTPArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformSendMessageWithGeneratedOTPResults(data)
	if err != nil {
		return nil, err
	}
	return results.ESMESendMessageResult, nil
}

// SendMessageWithInputtedOTP is API call
func (o *ESMEOp) SendMessageWithInputtedOTP(ctx context.Context, id types.ID, param *ESMESendMessageWithInputtedOTPRequest) (*ESMESendMessageResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/esme/2fa", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformSendMessageWithInputtedOTPArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformSendMessageWithInputtedOTPResults(data)
	if err != nil {
		return nil, err
	}
	return results.ESMESendMessageResult, nil
}

// Logs is API call
func (o *ESMEOp) Logs(ctx context.Context, id types.ID) ([]*ESMELogs, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/esme/logs", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformLogsResults(data)
	if err != nil {
		return nil, err
	}
	return results.Logs, nil
}

/*************************************************
* GSLBOp
*************************************************/

// GSLBOp implements GSLBAPI interface
type GSLBOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewGSLBOp creates new GSLBOp instance
func NewGSLBOp(caller APICaller) GSLBAPI {
	return GetClientFactoryFunc("GSLB")(caller).(GSLBAPI)
}

// Find is API call
func (o *GSLBOp) Find(ctx context.Context, conditions *FindCondition) (*GSLBFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *GSLBOp) Create(ctx context.Context, param *GSLBCreateRequest) (*GSLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.GSLB, nil
}

// Read is API call
func (o *GSLBOp) Read(ctx context.Context, id types.ID) (*GSLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.GSLB, nil
}

// Update is API call
func (o *GSLBOp) Update(ctx context.Context, id types.ID, param *GSLBUpdateRequest) (*GSLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.GSLB, nil
}

// UpdateSettings is API call
func (o *GSLBOp) UpdateSettings(ctx context.Context, id types.ID, param *GSLBUpdateSettingsRequest) (*GSLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.GSLB, nil
}

// Delete is API call
func (o *GSLBOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* IconOp
*************************************************/

// IconOp implements IconAPI interface
type IconOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewIconOp creates new IconOp instance
func NewIconOp(caller APICaller) IconAPI {
	return GetClientFactoryFunc("Icon")(caller).(IconAPI)
}

// Find is API call
func (o *IconOp) Find(ctx context.Context, conditions *FindCondition) (*IconFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *IconOp) Create(ctx context.Context, param *IconCreateRequest) (*Icon, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Icon, nil
}

// Read is API call
func (o *IconOp) Read(ctx context.Context, id types.ID) (*Icon, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Icon, nil
}

// Update is API call
func (o *IconOp) Update(ctx context.Context, id types.ID, param *IconUpdateRequest) (*Icon, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Icon, nil
}

// Delete is API call
func (o *IconOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* InterfaceOp
*************************************************/

// InterfaceOp implements InterfaceAPI interface
type InterfaceOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewInterfaceOp creates new InterfaceOp instance
func NewInterfaceOp(caller APICaller) InterfaceAPI {
	return GetClientFactoryFunc("Interface")(caller).(InterfaceAPI)
}

// Find is API call
func (o *InterfaceOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*InterfaceFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *InterfaceOp) Create(ctx context.Context, zone string, param *InterfaceCreateRequest) (*Interface, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Interface, nil
}

// Read is API call
func (o *InterfaceOp) Read(ctx context.Context, zone string, id types.ID) (*Interface, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Interface, nil
}

// Update is API call
func (o *InterfaceOp) Update(ctx context.Context, zone string, id types.ID, param *InterfaceUpdateRequest) (*Interface, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Interface, nil
}

// Delete is API call
func (o *InterfaceOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Monitor is API call
func (o *InterfaceOp) Monitor(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*InterfaceActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorResults(data)
	if err != nil {
		return nil, err
	}
	return results.InterfaceActivity, nil
}

// ConnectToSharedSegment is API call
func (o *InterfaceOp) ConnectToSharedSegment(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/switch/shared", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ConnectToSwitch is API call
func (o *InterfaceOp) ConnectToSwitch(ctx context.Context, zone string, id types.ID, switchID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"switchID":   switchID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/switch/{{.switchID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DisconnectFromSwitch is API call
func (o *InterfaceOp) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/switch", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ConnectToPacketFilter is API call
func (o *InterfaceOp) ConnectToPacketFilter(ctx context.Context, zone string, id types.ID, packetFilterID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":        SakuraCloudAPIRoot,
		"pathSuffix":     o.PathSuffix,
		"pathName":       o.PathName,
		"zone":           zone,
		"id":             id,
		"packetFilterID": packetFilterID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/packetfilter/{{.packetFilterID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DisconnectFromPacketFilter is API call
func (o *InterfaceOp) DisconnectFromPacketFilter(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/packetfilter", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* InternetOp
*************************************************/

// InternetOp implements InternetAPI interface
type InternetOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewInternetOp creates new InternetOp instance
func NewInternetOp(caller APICaller) InternetAPI {
	return GetClientFactoryFunc("Internet")(caller).(InternetAPI)
}

// Find is API call
func (o *InternetOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*InternetFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *InternetOp) Create(ctx context.Context, zone string, param *InternetCreateRequest) (*Internet, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Internet, nil
}

// Read is API call
func (o *InternetOp) Read(ctx context.Context, zone string, id types.ID) (*Internet, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Internet, nil
}

// Update is API call
func (o *InternetOp) Update(ctx context.Context, zone string, id types.ID, param *InternetUpdateRequest) (*Internet, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Internet, nil
}

// Delete is API call
func (o *InternetOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// UpdateBandWidth is API call
func (o *InternetOp) UpdateBandWidth(ctx context.Context, zone string, id types.ID, param *InternetUpdateBandWidthRequest) (*Internet, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/bandwidth", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateBandWidthArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateBandWidthResults(data)
	if err != nil {
		return nil, err
	}
	return results.Internet, nil
}

// AddSubnet is API call
func (o *InternetOp) AddSubnet(ctx context.Context, zone string, id types.ID, param *InternetAddSubnetRequest) (*InternetSubnetOperationResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/subnet", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformAddSubnetArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformAddSubnetResults(data)
	if err != nil {
		return nil, err
	}
	return results.Subnet, nil
}

// UpdateSubnet is API call
func (o *InternetOp) UpdateSubnet(ctx context.Context, zone string, id types.ID, subnetID types.ID, param *InternetUpdateSubnetRequest) (*InternetSubnetOperationResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"subnetID":   subnetID,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/subnet/{{.subnetID}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSubnetArgs(id, subnetID, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSubnetResults(data)
	if err != nil {
		return nil, err
	}
	return results.Subnet, nil
}

// DeleteSubnet is API call
func (o *InternetOp) DeleteSubnet(ctx context.Context, zone string, id types.ID, subnetID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"subnetID":   subnetID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/subnet/{{.subnetID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Monitor is API call
func (o *InternetOp) Monitor(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*RouterActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorResults(data)
	if err != nil {
		return nil, err
	}
	return results.RouterActivity, nil
}

// MonitorRouter is API call
func (o *InternetOp) MonitorRouter(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*RouterActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorRouterArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorRouterResults(data)
	if err != nil {
		return nil, err
	}
	return results.RouterActivity, nil
}

// EnableIPv6 is API call
func (o *InternetOp) EnableIPv6(ctx context.Context, zone string, id types.ID) (*IPv6NetInfo, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/ipv6net", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformEnableIPv6Results(data)
	if err != nil {
		return nil, err
	}
	return results.IPv6Net, nil
}

// DisableIPv6 is API call
func (o *InternetOp) DisableIPv6(ctx context.Context, zone string, id types.ID, ipv6netID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"ipv6netID":  ipv6netID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/ipv6net/{{.ipv6netID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* InternetPlanOp
*************************************************/

// InternetPlanOp implements InternetPlanAPI interface
type InternetPlanOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewInternetPlanOp creates new InternetPlanOp instance
func NewInternetPlanOp(caller APICaller) InternetPlanAPI {
	return GetClientFactoryFunc("InternetPlan")(caller).(InternetPlanAPI)
}

// Find is API call
func (o *InternetPlanOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*InternetPlanFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *InternetPlanOp) Read(ctx context.Context, zone string, id types.ID) (*InternetPlan, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.InternetPlan, nil
}

/*************************************************
* IPAddressOp
*************************************************/

// IPAddressOp implements IPAddressAPI interface
type IPAddressOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewIPAddressOp creates new IPAddressOp instance
func NewIPAddressOp(caller APICaller) IPAddressAPI {
	return GetClientFactoryFunc("IPAddress")(caller).(IPAddressAPI)
}

// List is API call
func (o *IPAddressOp) List(ctx context.Context, zone string) (*IPAddressListResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformListResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *IPAddressOp) Read(ctx context.Context, zone string, ipAddress string) (*IPAddress, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"ipAddress":  ipAddress,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.ipAddress}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.IPAddress, nil
}

// UpdateHostName is API call
func (o *IPAddressOp) UpdateHostName(ctx context.Context, zone string, ipAddress string, hostName string) (*IPAddress, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"ipAddress":  ipAddress,
		"hostName":   hostName,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.ipAddress}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateHostNameArgs(ipAddress, hostName)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateHostNameResults(data)
	if err != nil {
		return nil, err
	}
	return results.IPAddress, nil
}

/*************************************************
* IPv6NetOp
*************************************************/

// IPv6NetOp implements IPv6NetAPI interface
type IPv6NetOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewIPv6NetOp creates new IPv6NetOp instance
func NewIPv6NetOp(caller APICaller) IPv6NetAPI {
	return GetClientFactoryFunc("IPv6Net")(caller).(IPv6NetAPI)
}

// List is API call
func (o *IPv6NetOp) List(ctx context.Context, zone string) (*IPv6NetListResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformListResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Find is API call
func (o *IPv6NetOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*IPv6NetFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *IPv6NetOp) Read(ctx context.Context, zone string, id types.ID) (*IPv6Net, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.IPv6Net, nil
}

/*************************************************
* IPv6AddrOp
*************************************************/

// IPv6AddrOp implements IPv6AddrAPI interface
type IPv6AddrOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewIPv6AddrOp creates new IPv6AddrOp instance
func NewIPv6AddrOp(caller APICaller) IPv6AddrAPI {
	return GetClientFactoryFunc("IPv6Addr")(caller).(IPv6AddrAPI)
}

// Find is API call
func (o *IPv6AddrOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*IPv6AddrFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *IPv6AddrOp) Create(ctx context.Context, zone string, param *IPv6AddrCreateRequest) (*IPv6Addr, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.IPv6Addr, nil
}

// Read is API call
func (o *IPv6AddrOp) Read(ctx context.Context, zone string, ipv6addr string) (*IPv6Addr, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         ipv6addr,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.IPv6Addr, nil
}

// Update is API call
func (o *IPv6AddrOp) Update(ctx context.Context, zone string, ipv6addr string, param *IPv6AddrUpdateRequest) (*IPv6Addr, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         ipv6addr,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(ipv6addr, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.IPv6Addr, nil
}

// Delete is API call
func (o *IPv6AddrOp) Delete(ctx context.Context, zone string, ipv6addr string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         ipv6addr,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* LicenseOp
*************************************************/

// LicenseOp implements LicenseAPI interface
type LicenseOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewLicenseOp creates new LicenseOp instance
func NewLicenseOp(caller APICaller) LicenseAPI {
	return GetClientFactoryFunc("License")(caller).(LicenseAPI)
}

// Find is API call
func (o *LicenseOp) Find(ctx context.Context, conditions *FindCondition) (*LicenseFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *LicenseOp) Create(ctx context.Context, param *LicenseCreateRequest) (*License, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.License, nil
}

// Read is API call
func (o *LicenseOp) Read(ctx context.Context, id types.ID) (*License, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.License, nil
}

// Update is API call
func (o *LicenseOp) Update(ctx context.Context, id types.ID, param *LicenseUpdateRequest) (*License, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.License, nil
}

// Delete is API call
func (o *LicenseOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* LicenseInfoOp
*************************************************/

// LicenseInfoOp implements LicenseInfoAPI interface
type LicenseInfoOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewLicenseInfoOp creates new LicenseInfoOp instance
func NewLicenseInfoOp(caller APICaller) LicenseInfoAPI {
	return GetClientFactoryFunc("LicenseInfo")(caller).(LicenseInfoAPI)
}

// Find is API call
func (o *LicenseInfoOp) Find(ctx context.Context, conditions *FindCondition) (*LicenseInfoFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *LicenseInfoOp) Read(ctx context.Context, id types.ID) (*LicenseInfo, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.LicenseInfo, nil
}

/*************************************************
* LoadBalancerOp
*************************************************/

// LoadBalancerOp implements LoadBalancerAPI interface
type LoadBalancerOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewLoadBalancerOp creates new LoadBalancerOp instance
func NewLoadBalancerOp(caller APICaller) LoadBalancerAPI {
	return GetClientFactoryFunc("LoadBalancer")(caller).(LoadBalancerAPI)
}

// Find is API call
func (o *LoadBalancerOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*LoadBalancerFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *LoadBalancerOp) Create(ctx context.Context, zone string, param *LoadBalancerCreateRequest) (*LoadBalancer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.LoadBalancer, nil
}

// Read is API call
func (o *LoadBalancerOp) Read(ctx context.Context, zone string, id types.ID) (*LoadBalancer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.LoadBalancer, nil
}

// Update is API call
func (o *LoadBalancerOp) Update(ctx context.Context, zone string, id types.ID, param *LoadBalancerUpdateRequest) (*LoadBalancer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.LoadBalancer, nil
}

// UpdateSettings is API call
func (o *LoadBalancerOp) UpdateSettings(ctx context.Context, zone string, id types.ID, param *LoadBalancerUpdateSettingsRequest) (*LoadBalancer, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.LoadBalancer, nil
}

// Delete is API call
func (o *LoadBalancerOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Config is API call
func (o *LoadBalancerOp) Config(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/config", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Boot is API call
func (o *LoadBalancerOp) Boot(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Shutdown is API call
func (o *LoadBalancerOp) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *ShutdownOption) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":        SakuraCloudAPIRoot,
		"pathSuffix":     o.PathSuffix,
		"pathName":       o.PathName,
		"zone":           zone,
		"id":             id,
		"shutdownOption": shutdownOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}
	v, err := o.transformShutdownArgs(id, shutdownOption)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Reset is API call
func (o *LoadBalancerOp) Reset(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/reset", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// MonitorCPU is API call
func (o *LoadBalancerOp) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*CPUTimeActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/cpu/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorCPUArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorCPUResults(data)
	if err != nil {
		return nil, err
	}
	return results.CPUTimeActivity, nil
}

// MonitorInterface is API call
func (o *LoadBalancerOp) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*InterfaceActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorInterfaceArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorInterfaceResults(data)
	if err != nil {
		return nil, err
	}
	return results.InterfaceActivity, nil
}

// Status is API call
func (o *LoadBalancerOp) Status(ctx context.Context, zone string, id types.ID) (*LoadBalancerStatusResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/status", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

/*************************************************
* LocalRouterOp
*************************************************/

// LocalRouterOp implements LocalRouterAPI interface
type LocalRouterOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewLocalRouterOp creates new LocalRouterOp instance
func NewLocalRouterOp(caller APICaller) LocalRouterAPI {
	return GetClientFactoryFunc("LocalRouter")(caller).(LocalRouterAPI)
}

// Find is API call
func (o *LocalRouterOp) Find(ctx context.Context, conditions *FindCondition) (*LocalRouterFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *LocalRouterOp) Create(ctx context.Context, param *LocalRouterCreateRequest) (*LocalRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.LocalRouter, nil
}

// Read is API call
func (o *LocalRouterOp) Read(ctx context.Context, id types.ID) (*LocalRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.LocalRouter, nil
}

// Update is API call
func (o *LocalRouterOp) Update(ctx context.Context, id types.ID, param *LocalRouterUpdateRequest) (*LocalRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.LocalRouter, nil
}

// UpdateSettings is API call
func (o *LocalRouterOp) UpdateSettings(ctx context.Context, id types.ID, param *LocalRouterUpdateSettingsRequest) (*LocalRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.LocalRouter, nil
}

// Delete is API call
func (o *LocalRouterOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// HealthStatus is API call
func (o *LocalRouterOp) HealthStatus(ctx context.Context, id types.ID) (*LocalRouterHealth, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/health", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformHealthStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.LocalRouterHealth, nil
}

// MonitorLocalRouter is API call
func (o *LocalRouterOp) MonitorLocalRouter(ctx context.Context, id types.ID, condition *MonitorCondition) (*LocalRouterActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/activity/localrouter/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorLocalRouterArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorLocalRouterResults(data)
	if err != nil {
		return nil, err
	}
	return results.LocalRouterActivity, nil
}

/*************************************************
* MobileGatewayOp
*************************************************/

// MobileGatewayOp implements MobileGatewayAPI interface
type MobileGatewayOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewMobileGatewayOp creates new MobileGatewayOp instance
func NewMobileGatewayOp(caller APICaller) MobileGatewayAPI {
	return GetClientFactoryFunc("MobileGateway")(caller).(MobileGatewayAPI)
}

// Find is API call
func (o *MobileGatewayOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*MobileGatewayFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *MobileGatewayOp) Create(ctx context.Context, zone string, param *MobileGatewayCreateRequest) (*MobileGateway, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.MobileGateway, nil
}

// Read is API call
func (o *MobileGatewayOp) Read(ctx context.Context, zone string, id types.ID) (*MobileGateway, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.MobileGateway, nil
}

// Update is API call
func (o *MobileGatewayOp) Update(ctx context.Context, zone string, id types.ID, param *MobileGatewayUpdateRequest) (*MobileGateway, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.MobileGateway, nil
}

// UpdateSettings is API call
func (o *MobileGatewayOp) UpdateSettings(ctx context.Context, zone string, id types.ID, param *MobileGatewayUpdateSettingsRequest) (*MobileGateway, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.MobileGateway, nil
}

// Delete is API call
func (o *MobileGatewayOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Config is API call
func (o *MobileGatewayOp) Config(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/config", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Boot is API call
func (o *MobileGatewayOp) Boot(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Shutdown is API call
func (o *MobileGatewayOp) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *ShutdownOption) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":        SakuraCloudAPIRoot,
		"pathSuffix":     o.PathSuffix,
		"pathName":       o.PathName,
		"zone":           zone,
		"id":             id,
		"shutdownOption": shutdownOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}
	v, err := o.transformShutdownArgs(id, shutdownOption)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Reset is API call
func (o *MobileGatewayOp) Reset(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/reset", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ConnectToSwitch is API call
func (o *MobileGatewayOp) ConnectToSwitch(ctx context.Context, zone string, id types.ID, switchID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"switchID":   switchID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface/1/to/switch/{{.switchID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DisconnectFromSwitch is API call
func (o *MobileGatewayOp) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface/1/to/switch", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// GetDNS is API call
func (o *MobileGatewayOp) GetDNS(ctx context.Context, zone string, id types.ID) (*MobileGatewayDNSSetting, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/dnsresolver", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetDNSResults(data)
	if err != nil {
		return nil, err
	}
	return results.SIMGroup, nil
}

// SetDNS is API call
func (o *MobileGatewayOp) SetDNS(ctx context.Context, zone string, id types.ID, param *MobileGatewayDNSSetting) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/dnsresolver", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetDNSArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// GetSIMRoutes is API call
func (o *MobileGatewayOp) GetSIMRoutes(ctx context.Context, zone string, id types.ID) (MobileGatewaySIMRoutes, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/simroutes", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetSIMRoutesResults(data)
	if err != nil {
		return nil, err
	}
	return results.SIMRoutes, nil
}

// SetSIMRoutes is API call
func (o *MobileGatewayOp) SetSIMRoutes(ctx context.Context, zone string, id types.ID, param []*MobileGatewaySIMRouteParam) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/simroutes", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetSIMRoutesArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ListSIM is API call
func (o *MobileGatewayOp) ListSIM(ctx context.Context, zone string, id types.ID) (MobileGatewaySIMs, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/sims", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformListSIMResults(data)
	if err != nil {
		return nil, err
	}
	return results.SIM, nil
}

// AddSIM is API call
func (o *MobileGatewayOp) AddSIM(ctx context.Context, zone string, id types.ID, param *MobileGatewayAddSIMRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/sims", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformAddSIMArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DeleteSIM is API call
func (o *MobileGatewayOp) DeleteSIM(ctx context.Context, zone string, id types.ID, simID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"simID":      simID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/sims/{{.simID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Logs is API call
func (o *MobileGatewayOp) Logs(ctx context.Context, zone string, id types.ID) ([]*MobileGatewaySIMLogs, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/sessionlog", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformLogsResults(data)
	if err != nil {
		return nil, err
	}
	return results.Logs, nil
}

// GetTrafficConfig is API call
func (o *MobileGatewayOp) GetTrafficConfig(ctx context.Context, zone string, id types.ID) (*MobileGatewayTrafficControl, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/traffic_monitoring", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetTrafficConfigResults(data)
	if err != nil {
		return nil, err
	}
	return results.TrafficMonitoring, nil
}

// SetTrafficConfig is API call
func (o *MobileGatewayOp) SetTrafficConfig(ctx context.Context, zone string, id types.ID, param *MobileGatewayTrafficControl) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/traffic_monitoring", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetTrafficConfigArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DeleteTrafficConfig is API call
func (o *MobileGatewayOp) DeleteTrafficConfig(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/traffic_monitoring", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// TrafficStatus is API call
func (o *MobileGatewayOp) TrafficStatus(ctx context.Context, zone string, id types.ID) (*MobileGatewayTrafficStatus, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/mobilegateway/traffic_status", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformTrafficStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.TrafficStatus, nil
}

// MonitorInterface is API call
func (o *MobileGatewayOp) MonitorInterface(ctx context.Context, zone string, id types.ID, index int, condition *MonitorCondition) (*InterfaceActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"index":      index,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface{{if ne .index 0}}/{{.index}}{{end}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorInterfaceArgs(id, index, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorInterfaceResults(data)
	if err != nil {
		return nil, err
	}
	return results.InterfaceActivity, nil
}

/*************************************************
* NFSOp
*************************************************/

// NFSOp implements NFSAPI interface
type NFSOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewNFSOp creates new NFSOp instance
func NewNFSOp(caller APICaller) NFSAPI {
	return GetClientFactoryFunc("NFS")(caller).(NFSAPI)
}

// Find is API call
func (o *NFSOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*NFSFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *NFSOp) Create(ctx context.Context, zone string, param *NFSCreateRequest) (*NFS, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.NFS, nil
}

// Read is API call
func (o *NFSOp) Read(ctx context.Context, zone string, id types.ID) (*NFS, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.NFS, nil
}

// Update is API call
func (o *NFSOp) Update(ctx context.Context, zone string, id types.ID, param *NFSUpdateRequest) (*NFS, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.NFS, nil
}

// Delete is API call
func (o *NFSOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Boot is API call
func (o *NFSOp) Boot(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Shutdown is API call
func (o *NFSOp) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *ShutdownOption) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":        SakuraCloudAPIRoot,
		"pathSuffix":     o.PathSuffix,
		"pathName":       o.PathName,
		"zone":           zone,
		"id":             id,
		"shutdownOption": shutdownOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}
	v, err := o.transformShutdownArgs(id, shutdownOption)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Reset is API call
func (o *NFSOp) Reset(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/reset", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// MonitorCPU is API call
func (o *NFSOp) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*CPUTimeActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/cpu/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorCPUArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorCPUResults(data)
	if err != nil {
		return nil, err
	}
	return results.CPUTimeActivity, nil
}

// MonitorFreeDiskSize is API call
func (o *NFSOp) MonitorFreeDiskSize(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*FreeDiskSizeActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/database/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorFreeDiskSizeArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorFreeDiskSizeResults(data)
	if err != nil {
		return nil, err
	}
	return results.FreeDiskSizeActivity, nil
}

// MonitorInterface is API call
func (o *NFSOp) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*InterfaceActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorInterfaceArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorInterfaceResults(data)
	if err != nil {
		return nil, err
	}
	return results.InterfaceActivity, nil
}

/*************************************************
* NoteOp
*************************************************/

// NoteOp implements NoteAPI interface
type NoteOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewNoteOp creates new NoteOp instance
func NewNoteOp(caller APICaller) NoteAPI {
	return GetClientFactoryFunc("Note")(caller).(NoteAPI)
}

// Find is API call
func (o *NoteOp) Find(ctx context.Context, conditions *FindCondition) (*NoteFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *NoteOp) Create(ctx context.Context, param *NoteCreateRequest) (*Note, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Note, nil
}

// Read is API call
func (o *NoteOp) Read(ctx context.Context, id types.ID) (*Note, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Note, nil
}

// Update is API call
func (o *NoteOp) Update(ctx context.Context, id types.ID, param *NoteUpdateRequest) (*Note, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Note, nil
}

// Delete is API call
func (o *NoteOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* PacketFilterOp
*************************************************/

// PacketFilterOp implements PacketFilterAPI interface
type PacketFilterOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewPacketFilterOp creates new PacketFilterOp instance
func NewPacketFilterOp(caller APICaller) PacketFilterAPI {
	return GetClientFactoryFunc("PacketFilter")(caller).(PacketFilterAPI)
}

// Find is API call
func (o *PacketFilterOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*PacketFilterFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *PacketFilterOp) Create(ctx context.Context, zone string, param *PacketFilterCreateRequest) (*PacketFilter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.PacketFilter, nil
}

// Read is API call
func (o *PacketFilterOp) Read(ctx context.Context, zone string, id types.ID) (*PacketFilter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.PacketFilter, nil
}

// Update is API call
func (o *PacketFilterOp) Update(ctx context.Context, zone string, id types.ID, updateParam *PacketFilterUpdateRequest, originalExpressionHash string) (*PacketFilter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":                SakuraCloudAPIRoot,
		"pathSuffix":             o.PathSuffix,
		"pathName":               o.PathName,
		"zone":                   zone,
		"id":                     id,
		"updateParam":            updateParam,
		"originalExpressionHash": originalExpressionHash,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, updateParam, originalExpressionHash)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.PacketFilter, nil
}

// Delete is API call
func (o *PacketFilterOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* PrivateHostOp
*************************************************/

// PrivateHostOp implements PrivateHostAPI interface
type PrivateHostOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewPrivateHostOp creates new PrivateHostOp instance
func NewPrivateHostOp(caller APICaller) PrivateHostAPI {
	return GetClientFactoryFunc("PrivateHost")(caller).(PrivateHostAPI)
}

// Find is API call
func (o *PrivateHostOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*PrivateHostFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *PrivateHostOp) Create(ctx context.Context, zone string, param *PrivateHostCreateRequest) (*PrivateHost, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.PrivateHost, nil
}

// Read is API call
func (o *PrivateHostOp) Read(ctx context.Context, zone string, id types.ID) (*PrivateHost, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.PrivateHost, nil
}

// Update is API call
func (o *PrivateHostOp) Update(ctx context.Context, zone string, id types.ID, param *PrivateHostUpdateRequest) (*PrivateHost, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.PrivateHost, nil
}

// Delete is API call
func (o *PrivateHostOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* PrivateHostPlanOp
*************************************************/

// PrivateHostPlanOp implements PrivateHostPlanAPI interface
type PrivateHostPlanOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewPrivateHostPlanOp creates new PrivateHostPlanOp instance
func NewPrivateHostPlanOp(caller APICaller) PrivateHostPlanAPI {
	return GetClientFactoryFunc("PrivateHostPlan")(caller).(PrivateHostPlanAPI)
}

// Find is API call
func (o *PrivateHostPlanOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*PrivateHostPlanFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *PrivateHostPlanOp) Read(ctx context.Context, zone string, id types.ID) (*PrivateHostPlan, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.PrivateHostPlan, nil
}

/*************************************************
* ProxyLBOp
*************************************************/

// ProxyLBOp implements ProxyLBAPI interface
type ProxyLBOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewProxyLBOp creates new ProxyLBOp instance
func NewProxyLBOp(caller APICaller) ProxyLBAPI {
	return GetClientFactoryFunc("ProxyLB")(caller).(ProxyLBAPI)
}

// Find is API call
func (o *ProxyLBOp) Find(ctx context.Context, conditions *FindCondition) (*ProxyLBFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *ProxyLBOp) Create(ctx context.Context, param *ProxyLBCreateRequest) (*ProxyLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLB, nil
}

// Read is API call
func (o *ProxyLBOp) Read(ctx context.Context, id types.ID) (*ProxyLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLB, nil
}

// Update is API call
func (o *ProxyLBOp) Update(ctx context.Context, id types.ID, param *ProxyLBUpdateRequest) (*ProxyLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLB, nil
}

// UpdateSettings is API call
func (o *ProxyLBOp) UpdateSettings(ctx context.Context, id types.ID, param *ProxyLBUpdateSettingsRequest) (*ProxyLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLB, nil
}

// Delete is API call
func (o *ProxyLBOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ChangePlan is API call
func (o *ProxyLBOp) ChangePlan(ctx context.Context, id types.ID, param *ProxyLBChangePlanRequest) (*ProxyLB, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/plan", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformChangePlanArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformChangePlanResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLB, nil
}

// GetCertificates is API call
func (o *ProxyLBOp) GetCertificates(ctx context.Context, id types.ID) (*ProxyLBCertificates, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/proxylb/sslcertificate", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetCertificatesResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLBCertificates, nil
}

// SetCertificates is API call
func (o *ProxyLBOp) SetCertificates(ctx context.Context, id types.ID, param *ProxyLBSetCertificatesRequest) (*ProxyLBCertificates, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/proxylb/sslcertificate", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetCertificatesArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformSetCertificatesResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLBCertificates, nil
}

// DeleteCertificates is API call
func (o *ProxyLBOp) DeleteCertificates(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/proxylb/sslcertificate", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// RenewLetsEncryptCert is API call
func (o *ProxyLBOp) RenewLetsEncryptCert(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/proxylb/letsencryptrenew", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// HealthStatus is API call
func (o *ProxyLBOp) HealthStatus(ctx context.Context, id types.ID) (*ProxyLBHealth, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/health", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformHealthStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.ProxyLBHealth, nil
}

// MonitorConnection is API call
func (o *ProxyLBOp) MonitorConnection(ctx context.Context, id types.ID, condition *MonitorCondition) (*ConnectionActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/activity/proxylb/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorConnectionArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorConnectionResults(data)
	if err != nil {
		return nil, err
	}
	return results.ConnectionActivity, nil
}

/*************************************************
* RegionOp
*************************************************/

// RegionOp implements RegionAPI interface
type RegionOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewRegionOp creates new RegionOp instance
func NewRegionOp(caller APICaller) RegionAPI {
	return GetClientFactoryFunc("Region")(caller).(RegionAPI)
}

// Find is API call
func (o *RegionOp) Find(ctx context.Context, conditions *FindCondition) (*RegionFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *RegionOp) Read(ctx context.Context, id types.ID) (*Region, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Region, nil
}

/*************************************************
* ServerOp
*************************************************/

// ServerOp implements ServerAPI interface
type ServerOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewServerOp creates new ServerOp instance
func NewServerOp(caller APICaller) ServerAPI {
	return GetClientFactoryFunc("Server")(caller).(ServerAPI)
}

// Find is API call
func (o *ServerOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*ServerFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *ServerOp) Create(ctx context.Context, zone string, param *ServerCreateRequest) (*Server, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Server, nil
}

// Read is API call
func (o *ServerOp) Read(ctx context.Context, zone string, id types.ID) (*Server, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Server, nil
}

// Update is API call
func (o *ServerOp) Update(ctx context.Context, zone string, id types.ID, param *ServerUpdateRequest) (*Server, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Server, nil
}

// Delete is API call
func (o *ServerOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DeleteWithDisks is API call
func (o *ServerOp) DeleteWithDisks(ctx context.Context, zone string, id types.ID, disks *ServerDeleteWithDisksRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"disks":      disks,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformDeleteWithDisksArgs(id, disks)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ChangePlan is API call
func (o *ServerOp) ChangePlan(ctx context.Context, zone string, id types.ID, plan *ServerChangePlanRequest) (*Server, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"plan":       plan,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/plan", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformChangePlanArgs(id, plan)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformChangePlanResults(data)
	if err != nil {
		return nil, err
	}
	return results.Server, nil
}

// InsertCDROM is API call
func (o *ServerOp) InsertCDROM(ctx context.Context, zone string, id types.ID, insertParam *InsertCDROMRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":     SakuraCloudAPIRoot,
		"pathSuffix":  o.PathSuffix,
		"pathName":    o.PathName,
		"zone":        zone,
		"id":          id,
		"insertParam": insertParam,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/cdrom", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformInsertCDROMArgs(id, insertParam)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// EjectCDROM is API call
func (o *ServerOp) EjectCDROM(ctx context.Context, zone string, id types.ID, ejectParam *EjectCDROMRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"ejectParam": ejectParam,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/cdrom", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformEjectCDROMArgs(id, ejectParam)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Boot is API call
func (o *ServerOp) Boot(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Shutdown is API call
func (o *ServerOp) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *ShutdownOption) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":        SakuraCloudAPIRoot,
		"pathSuffix":     o.PathSuffix,
		"pathName":       o.PathName,
		"zone":           zone,
		"id":             id,
		"shutdownOption": shutdownOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}
	v, err := o.transformShutdownArgs(id, shutdownOption)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Reset is API call
func (o *ServerOp) Reset(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/reset", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// BootWithVariables is API call
func (o *ServerOp) BootWithVariables(ctx context.Context, zone string, id types.ID, param *ServerBootVariables) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}
	v, err := o.transformBootWithVariablesArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// SendKey is API call
func (o *ServerOp) SendKey(ctx context.Context, zone string, id types.ID, keyboardParam *SendKeyRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":       SakuraCloudAPIRoot,
		"pathSuffix":    o.PathSuffix,
		"pathName":      o.PathName,
		"zone":          zone,
		"id":            id,
		"keyboardParam": keyboardParam,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/keyboard", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSendKeyArgs(id, keyboardParam)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// SendNMI is API call
func (o *ServerOp) SendNMI(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/qemu/nmi", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// GetVNCProxy is API call
func (o *ServerOp) GetVNCProxy(ctx context.Context, zone string, id types.ID) (*VNCProxyInfo, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/vnc/proxy", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetVNCProxyResults(data)
	if err != nil {
		return nil, err
	}
	return results.VNCProxyInfo, nil
}

// Monitor is API call
func (o *ServerOp) Monitor(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*CPUTimeActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorResults(data)
	if err != nil {
		return nil, err
	}
	return results.CPUTimeActivity, nil
}

// MonitorCPU is API call
func (o *ServerOp) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*CPUTimeActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorCPUArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorCPUResults(data)
	if err != nil {
		return nil, err
	}
	return results.CPUTimeActivity, nil
}

/*************************************************
* ServerPlanOp
*************************************************/

// ServerPlanOp implements ServerPlanAPI interface
type ServerPlanOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewServerPlanOp creates new ServerPlanOp instance
func NewServerPlanOp(caller APICaller) ServerPlanAPI {
	return GetClientFactoryFunc("ServerPlan")(caller).(ServerPlanAPI)
}

// Find is API call
func (o *ServerPlanOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*ServerPlanFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *ServerPlanOp) Read(ctx context.Context, zone string, id types.ID) (*ServerPlan, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.ServerPlan, nil
}

/*************************************************
* ServiceClassOp
*************************************************/

// ServiceClassOp implements ServiceClassAPI interface
type ServiceClassOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewServiceClassOp creates new ServiceClassOp instance
func NewServiceClassOp(caller APICaller) ServiceClassAPI {
	return GetClientFactoryFunc("ServiceClass")(caller).(ServiceClassAPI)
}

// Find is API call
func (o *ServiceClassOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*ServiceClassFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

/*************************************************
* SIMOp
*************************************************/

// SIMOp implements SIMAPI interface
type SIMOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewSIMOp creates new SIMOp instance
func NewSIMOp(caller APICaller) SIMAPI {
	return GetClientFactoryFunc("SIM")(caller).(SIMAPI)
}

// Find is API call
func (o *SIMOp) Find(ctx context.Context, conditions *FindCondition) (*SIMFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *SIMOp) Create(ctx context.Context, param *SIMCreateRequest) (*SIM, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SIM, nil
}

// Read is API call
func (o *SIMOp) Read(ctx context.Context, id types.ID) (*SIM, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.SIM, nil
}

// Update is API call
func (o *SIMOp) Update(ctx context.Context, id types.ID, param *SIMUpdateRequest) (*SIM, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SIM, nil
}

// Delete is API call
func (o *SIMOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Activate is API call
func (o *SIMOp) Activate(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/activate", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Deactivate is API call
func (o *SIMOp) Deactivate(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/deactivate", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// AssignIP is API call
func (o *SIMOp) AssignIP(ctx context.Context, id types.ID, param *SIMAssignIPRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/ip", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformAssignIPArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ClearIP is API call
func (o *SIMOp) ClearIP(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/ip", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// IMEILock is API call
func (o *SIMOp) IMEILock(ctx context.Context, id types.ID, param *SIMIMEILockRequest) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/imeilock", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformIMEILockArgs(id, param)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// IMEIUnlock is API call
func (o *SIMOp) IMEIUnlock(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/imeilock", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Logs is API call
func (o *SIMOp) Logs(ctx context.Context, id types.ID) (*SIMLogsResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/sessionlog", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformLogsResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// GetNetworkOperator is API call
func (o *SIMOp) GetNetworkOperator(ctx context.Context, id types.ID) ([]*SIMNetworkOperatorConfig, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/network_operator_config", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetNetworkOperatorResults(data)
	if err != nil {
		return nil, err
	}
	return results.Configs, nil
}

// SetNetworkOperator is API call
func (o *SIMOp) SetNetworkOperator(ctx context.Context, id types.ID, configs []*SIMNetworkOperatorConfig) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"configs":    configs,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/network_operator_config", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformSetNetworkOperatorArgs(id, configs)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// MonitorSIM is API call
func (o *SIMOp) MonitorSIM(ctx context.Context, id types.ID, condition *MonitorCondition) (*LinkActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/metrics/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorSIMArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorSIMResults(data)
	if err != nil {
		return nil, err
	}
	return results.LinkActivity, nil
}

// Status is API call
func (o *SIMOp) Status(ctx context.Context, id types.ID) (*SIMInfo, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/sim/status", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.SIM, nil
}

/*************************************************
* SimpleMonitorOp
*************************************************/

// SimpleMonitorOp implements SimpleMonitorAPI interface
type SimpleMonitorOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewSimpleMonitorOp creates new SimpleMonitorOp instance
func NewSimpleMonitorOp(caller APICaller) SimpleMonitorAPI {
	return GetClientFactoryFunc("SimpleMonitor")(caller).(SimpleMonitorAPI)
}

// Find is API call
func (o *SimpleMonitorOp) Find(ctx context.Context, conditions *FindCondition) (*SimpleMonitorFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *SimpleMonitorOp) Create(ctx context.Context, param *SimpleMonitorCreateRequest) (*SimpleMonitor, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleMonitor, nil
}

// Read is API call
func (o *SimpleMonitorOp) Read(ctx context.Context, id types.ID) (*SimpleMonitor, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleMonitor, nil
}

// Update is API call
func (o *SimpleMonitorOp) Update(ctx context.Context, id types.ID, param *SimpleMonitorUpdateRequest) (*SimpleMonitor, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleMonitor, nil
}

// UpdateSettings is API call
func (o *SimpleMonitorOp) UpdateSettings(ctx context.Context, id types.ID, param *SimpleMonitorUpdateSettingsRequest) (*SimpleMonitor, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleMonitor, nil
}

// Delete is API call
func (o *SimpleMonitorOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// MonitorResponseTime is API call
func (o *SimpleMonitorOp) MonitorResponseTime(ctx context.Context, id types.ID, condition *MonitorCondition) (*ResponseTimeSecActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}//activity/responsetimesec/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorResponseTimeArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorResponseTimeResults(data)
	if err != nil {
		return nil, err
	}
	return results.ResponseTimeSecActivity, nil
}

// HealthStatus is API call
func (o *SimpleMonitorOp) HealthStatus(ctx context.Context, id types.ID) (*SimpleMonitorHealthStatus, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/health", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformHealthStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleMonitorHealthStatus, nil
}

/*************************************************
* SimpleNotificationDestinationOp
*************************************************/

// SimpleNotificationDestinationOp implements SimpleNotificationDestinationAPI interface
type SimpleNotificationDestinationOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewSimpleNotificationDestinationOp creates new SimpleNotificationDestinationOp instance
func NewSimpleNotificationDestinationOp(caller APICaller) SimpleNotificationDestinationAPI {
	return GetClientFactoryFunc("SimpleNotificationDestination")(caller).(SimpleNotificationDestinationAPI)
}

// Find is API call
func (o *SimpleNotificationDestinationOp) Find(ctx context.Context, conditions *FindCondition) (*SimpleNotificationDestinationFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *SimpleNotificationDestinationOp) Create(ctx context.Context, param *SimpleNotificationDestinationCreateRequest) (*SimpleNotificationDestination, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationDestination, nil
}

// Read is API call
func (o *SimpleNotificationDestinationOp) Read(ctx context.Context, id types.ID) (*SimpleNotificationDestination, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationDestination, nil
}

// Update is API call
func (o *SimpleNotificationDestinationOp) Update(ctx context.Context, id types.ID, param *SimpleNotificationDestinationUpdateRequest) (*SimpleNotificationDestination, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationDestination, nil
}

// UpdateSettings is API call
func (o *SimpleNotificationDestinationOp) UpdateSettings(ctx context.Context, id types.ID, param *SimpleNotificationDestinationUpdateSettingsRequest) (*SimpleNotificationDestination, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationDestination, nil
}

// Delete is API call
func (o *SimpleNotificationDestinationOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Status is API call
func (o *SimpleNotificationDestinationOp) Status(ctx context.Context, id types.ID) (*SimpleNotificationDestinationStatus, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/simplenotification/status", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationDestinationStatus, nil
}

/*************************************************
* SimpleNotificationGroupOp
*************************************************/

// SimpleNotificationGroupOp implements SimpleNotificationGroupAPI interface
type SimpleNotificationGroupOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewSimpleNotificationGroupOp creates new SimpleNotificationGroupOp instance
func NewSimpleNotificationGroupOp(caller APICaller) SimpleNotificationGroupAPI {
	return GetClientFactoryFunc("SimpleNotificationGroup")(caller).(SimpleNotificationGroupAPI)
}

// Find is API call
func (o *SimpleNotificationGroupOp) Find(ctx context.Context, conditions *FindCondition) (*SimpleNotificationGroupFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *SimpleNotificationGroupOp) Create(ctx context.Context, param *SimpleNotificationGroupCreateRequest) (*SimpleNotificationGroup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationGroup, nil
}

// Read is API call
func (o *SimpleNotificationGroupOp) Read(ctx context.Context, id types.ID) (*SimpleNotificationGroup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationGroup, nil
}

// Update is API call
func (o *SimpleNotificationGroupOp) Update(ctx context.Context, id types.ID, param *SimpleNotificationGroupUpdateRequest) (*SimpleNotificationGroup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationGroup, nil
}

// UpdateSettings is API call
func (o *SimpleNotificationGroupOp) UpdateSettings(ctx context.Context, id types.ID, param *SimpleNotificationGroupUpdateSettingsRequest) (*SimpleNotificationGroup, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationGroup, nil
}

// Delete is API call
func (o *SimpleNotificationGroupOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// PostMessage is API call
func (o *SimpleNotificationGroupOp) PostMessage(ctx context.Context, id types.ID, message string) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"message":    message,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/simplenotification/message", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}
	v, err := o.transformPostMessageArgs(id, message)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// History is API call
func (o *SimpleNotificationGroupOp) History(ctx context.Context) (*SimpleNotificationHistories, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/simplenotification/history", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformHistoryResults(data)
	if err != nil {
		return nil, err
	}
	return results.SimpleNotificationHistories, nil
}

/*************************************************
* SSHKeyOp
*************************************************/

// SSHKeyOp implements SSHKeyAPI interface
type SSHKeyOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewSSHKeyOp creates new SSHKeyOp instance
func NewSSHKeyOp(caller APICaller) SSHKeyAPI {
	return GetClientFactoryFunc("SSHKey")(caller).(SSHKeyAPI)
}

// Find is API call
func (o *SSHKeyOp) Find(ctx context.Context, conditions *FindCondition) (*SSHKeyFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *SSHKeyOp) Create(ctx context.Context, param *SSHKeyCreateRequest) (*SSHKey, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SSHKey, nil
}

// Read is API call
func (o *SSHKeyOp) Read(ctx context.Context, id types.ID) (*SSHKey, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.SSHKey, nil
}

// Update is API call
func (o *SSHKeyOp) Update(ctx context.Context, id types.ID, param *SSHKeyUpdateRequest) (*SSHKey, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.SSHKey, nil
}

// Delete is API call
func (o *SSHKeyOp) Delete(ctx context.Context, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

/*************************************************
* SubnetOp
*************************************************/

// SubnetOp implements SubnetAPI interface
type SubnetOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewSubnetOp creates new SubnetOp instance
func NewSubnetOp(caller APICaller) SubnetAPI {
	return GetClientFactoryFunc("Subnet")(caller).(SubnetAPI)
}

// Find is API call
func (o *SubnetOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*SubnetFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *SubnetOp) Read(ctx context.Context, zone string, id types.ID) (*Subnet, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Subnet, nil
}

/*************************************************
* SwitchOp
*************************************************/

// SwitchOp implements SwitchAPI interface
type SwitchOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewSwitchOp creates new SwitchOp instance
func NewSwitchOp(caller APICaller) SwitchAPI {
	return GetClientFactoryFunc("Switch")(caller).(SwitchAPI)
}

// Find is API call
func (o *SwitchOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*SwitchFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *SwitchOp) Create(ctx context.Context, zone string, param *SwitchCreateRequest) (*Switch, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Switch, nil
}

// Read is API call
func (o *SwitchOp) Read(ctx context.Context, zone string, id types.ID) (*Switch, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Switch, nil
}

// Update is API call
func (o *SwitchOp) Update(ctx context.Context, zone string, id types.ID, param *SwitchUpdateRequest) (*Switch, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.Switch, nil
}

// Delete is API call
func (o *SwitchOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ConnectToBridge is API call
func (o *SwitchOp) ConnectToBridge(ctx context.Context, zone string, id types.ID, bridgeID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"bridgeID":   bridgeID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/bridge/{{.bridgeID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DisconnectFromBridge is API call
func (o *SwitchOp) DisconnectFromBridge(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/to/bridge/", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// GetServers is API call
func (o *SwitchOp) GetServers(ctx context.Context, zone string, id types.ID) (*SwitchGetServersResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/server", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformGetServersResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

/*************************************************
* VPCRouterOp
*************************************************/

// VPCRouterOp implements VPCRouterAPI interface
type VPCRouterOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewVPCRouterOp creates new VPCRouterOp instance
func NewVPCRouterOp(caller APICaller) VPCRouterAPI {
	return GetClientFactoryFunc("VPCRouter")(caller).(VPCRouterAPI)
}

// Find is API call
func (o *VPCRouterOp) Find(ctx context.Context, zone string, conditions *FindCondition) (*VPCRouterFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Create is API call
func (o *VPCRouterOp) Create(ctx context.Context, zone string, param *VPCRouterCreateRequest) (*VPCRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformCreateArgs(param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformCreateResults(data)
	if err != nil {
		return nil, err
	}
	return results.VPCRouter, nil
}

// Read is API call
func (o *VPCRouterOp) Read(ctx context.Context, zone string, id types.ID) (*VPCRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.VPCRouter, nil
}

// Update is API call
func (o *VPCRouterOp) Update(ctx context.Context, zone string, id types.ID, param *VPCRouterUpdateRequest) (*VPCRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateResults(data)
	if err != nil {
		return nil, err
	}
	return results.VPCRouter, nil
}

// UpdateSettings is API call
func (o *VPCRouterOp) UpdateSettings(ctx context.Context, zone string, id types.ID, param *VPCRouterUpdateSettingsRequest) (*VPCRouter, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"param":      param,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformUpdateSettingsArgs(id, param)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformUpdateSettingsResults(data)
	if err != nil {
		return nil, err
	}
	return results.VPCRouter, nil
}

// Delete is API call
func (o *VPCRouterOp) Delete(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Config is API call
func (o *VPCRouterOp) Config(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/config", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Boot is API call
func (o *VPCRouterOp) Boot(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Shutdown is API call
func (o *VPCRouterOp) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *ShutdownOption) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":        SakuraCloudAPIRoot,
		"pathSuffix":     o.PathSuffix,
		"pathName":       o.PathName,
		"zone":           zone,
		"id":             id,
		"shutdownOption": shutdownOption,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/power", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}
	v, err := o.transformShutdownArgs(id, shutdownOption)
	if err != nil {
		return err
	}
	body = v

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// Reset is API call
func (o *VPCRouterOp) Reset(ctx context.Context, zone string, id types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/reset", pathBuildParameter)
	if err != nil {
		return err
	}
	lockKey, err := buildURL("GlobalLock", pathBuildParameter)
	if err != nil {
		return err
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// ConnectToSwitch is API call
func (o *VPCRouterOp) ConnectToSwitch(ctx context.Context, zone string, id types.ID, nicIndex int, switchID types.ID) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"nicIndex":   nicIndex,
		"switchID":   switchID,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface/{{.nicIndex}}/to/switch/{{.switchID}}", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "PUT", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// DisconnectFromSwitch is API call
func (o *VPCRouterOp) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID, nicIndex int) error {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"nicIndex":   nicIndex,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface/{{.nicIndex}}/to/switch", pathBuildParameter)
	if err != nil {
		return err
	}
	// build request body
	var body interface{}

	// do request
	_, err = o.Client.Do(ctx, "DELETE", url, body)
	if err != nil {
		return err
	}

	// build results

	return nil
}

// MonitorCPU is API call
func (o *VPCRouterOp) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *MonitorCondition) (*CPUTimeActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/cpu/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorCPUArgs(id, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorCPUResults(data)
	if err != nil {
		return nil, err
	}
	return results.CPUTimeActivity, nil
}

// MonitorInterface is API call
func (o *VPCRouterOp) MonitorInterface(ctx context.Context, zone string, id types.ID, index int, condition *MonitorCondition) (*InterfaceActivity, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
		"index":      index,
		"condition":  condition,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/interface{{if ne .index 0}}/{{.index}}{{end}}/monitor", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformMonitorInterfaceArgs(id, index, condition)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformMonitorInterfaceResults(data)
	if err != nil {
		return nil, err
	}
	return results.InterfaceActivity, nil
}

// Status is API call
func (o *VPCRouterOp) Status(ctx context.Context, zone string, id types.ID) (*VPCRouterStatus, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/status", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformStatusResults(data)
	if err != nil {
		return nil, err
	}
	return results.VPCRouterStatus, nil
}

// Logs is API call
func (o *VPCRouterOp) Logs(ctx context.Context, zone string, id types.ID) (*VPCRouterLog, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       zone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/download/log/VPNLogs", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformLogsResults(data)
	if err != nil {
		return nil, err
	}
	return results.VPCRouterLog, nil
}

// Ping is API call
func (o *VPCRouterOp) Ping(ctx context.Context, zone string, id types.ID, destination string) (*VPCRouterPingResults, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":     SakuraCloudAPIRoot,
		"pathSuffix":  o.PathSuffix,
		"pathName":    o.PathName,
		"zone":        zone,
		"id":          id,
		"destination": destination,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}/vpcrouter/ping/{{.destination}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "POST", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformPingResults(data)
	if err != nil {
		return nil, err
	}
	return results.VPCRouterPingResults, nil
}

/*************************************************
* ZoneOp
*************************************************/

// ZoneOp implements ZoneAPI interface
type ZoneOp struct {
	// Client APICaller
	Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// NewZoneOp creates new ZoneOp instance
func NewZoneOp(caller APICaller) ZoneAPI {
	return GetClientFactoryFunc("Zone")(caller).(ZoneAPI)
}

// Find is API call
func (o *ZoneOp) Find(ctx context.Context, conditions *FindCondition) (*ZoneFindResult, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"conditions": conditions,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}
	v, err := o.transformFindArgs(conditions)
	if err != nil {
		return nil, err
	}
	body = v

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformFindResults(data)
	if err != nil {
		return nil, err
	}
	return results, err
}

// Read is API call
func (o *ZoneOp) Read(ctx context.Context, id types.ID) (*Zone, error) {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL":    SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName":   o.PathName,
		"zone":       APIDefaultZone,
		"id":         id,
	}

	url, err := buildURL("{{.rootURL}}/{{.zone}}/{{.pathSuffix}}/{{.pathName}}/{{.id}}", pathBuildParameter)
	if err != nil {
		return nil, err
	}
	// build request body
	var body interface{}

	// do request
	data, err := o.Client.Do(ctx, "GET", url, body)
	if err != nil {
		return nil, err
	}

	// build results
	results, err := o.transformReadResults(data)
	if err != nil {
		return nil, err
	}
	return results.Zone, nil
}
