/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ResourceStatusApplyConfiguration represents a declarative configuration of the ResourceStatus type for use
// with apply.
//
// ResourceStatus represents the status of a single resource allocated to a Pod.
type ResourceStatusApplyConfiguration struct {
	// Name of the resource. Must be unique within the pod and in case of non-DRA resource, match one of the resources from the pod spec.
	// For DRA resources, the value must be "claim:<claim_name>/<request>".
	// When this status is reported about a container, the "claim_name" and "request" must match one of the claims of this container.
	Name *corev1.ResourceName `json:"name,omitempty"`
	// List of unique resources health. Each element in the list contains an unique resource ID and its health.
	// At a minimum, for the lifetime of a Pod, resource ID must uniquely identify the resource allocated to the Pod on the Node.
	// If other Pod on the same Node reports the status with the same resource ID, it must be the same resource they share.
	// See ResourceID type definition for a specific format it has in various use cases.
	Resources []ResourceHealthApplyConfiguration `json:"resources,omitempty"`
}

// ResourceStatusApplyConfiguration constructs a declarative configuration of the ResourceStatus type for use with
// apply.
func ResourceStatus() *ResourceStatusApplyConfiguration {
	return &ResourceStatusApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ResourceStatusApplyConfiguration) WithName(value corev1.ResourceName) *ResourceStatusApplyConfiguration {
	b.Name = &value
	return b
}

// WithResources adds the given value to the Resources field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Resources field.
func (b *ResourceStatusApplyConfiguration) WithResources(values ...*ResourceHealthApplyConfiguration) *ResourceStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithResources")
		}
		b.Resources = append(b.Resources, *values[i])
	}
	return b
}
