// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by "deep-copy -type AffiliateSpec -type ConfigSpec -type IdentitySpec -type MemberSpec -type InfoSpec -header-file ../../../../hack/boilerplate.txt -o deep_copy.generated.go ."; DO NOT EDIT.

package cluster

import (
	"net/netip"
)

// DeepCopy generates a deep copy of AffiliateSpec.
func (o AffiliateSpec) DeepCopy() AffiliateSpec {
	var cp AffiliateSpec = o
	if o.Addresses != nil {
		cp.Addresses = make([]netip.Addr, len(o.Addresses))
		copy(cp.Addresses, o.Addresses)
	}
	if o.KubeSpan.AdditionalAddresses != nil {
		cp.KubeSpan.AdditionalAddresses = make([]netip.Prefix, len(o.KubeSpan.AdditionalAddresses))
		copy(cp.KubeSpan.AdditionalAddresses, o.KubeSpan.AdditionalAddresses)
	}
	if o.KubeSpan.Endpoints != nil {
		cp.KubeSpan.Endpoints = make([]netip.AddrPort, len(o.KubeSpan.Endpoints))
		copy(cp.KubeSpan.Endpoints, o.KubeSpan.Endpoints)
	}
	if o.ControlPlane != nil {
		cp.ControlPlane = new(ControlPlane)
		*cp.ControlPlane = *o.ControlPlane
	}
	return cp
}

// DeepCopy generates a deep copy of ConfigSpec.
func (o ConfigSpec) DeepCopy() ConfigSpec {
	var cp ConfigSpec = o
	if o.ServiceEncryptionKey != nil {
		cp.ServiceEncryptionKey = make([]byte, len(o.ServiceEncryptionKey))
		copy(cp.ServiceEncryptionKey, o.ServiceEncryptionKey)
	}
	return cp
}

// DeepCopy generates a deep copy of IdentitySpec.
func (o IdentitySpec) DeepCopy() IdentitySpec {
	var cp IdentitySpec = o
	return cp
}

// DeepCopy generates a deep copy of MemberSpec.
func (o MemberSpec) DeepCopy() MemberSpec {
	var cp MemberSpec = o
	if o.Addresses != nil {
		cp.Addresses = make([]netip.Addr, len(o.Addresses))
		copy(cp.Addresses, o.Addresses)
	}
	if o.ControlPlane != nil {
		cp.ControlPlane = new(ControlPlane)
		*cp.ControlPlane = *o.ControlPlane
	}
	return cp
}

// DeepCopy generates a deep copy of InfoSpec.
func (o InfoSpec) DeepCopy() InfoSpec {
	var cp InfoSpec = o
	return cp
}
