// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package runtime

import (
	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
)

func (KmsgLogV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KmsgLogConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KmsgLogConfig is a event sink config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KmsgLogConfig is a event sink config document.",
		Fields: []encoder.Doc{
			{},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the config document.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "url",
				Type:        "URL",
				Note:        "",
				Description: "The URL encodes the log destination.\nThe scheme must be tcp:// or udp://.\nThe path must be empty.\nThe port is required.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The URL encodes the log destination." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleKmsgLogV1Alpha1())

	doc.Fields[2].AddExample("", "udp://10.3.7.3:2810")

	return doc
}

func (EventSinkV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EventSinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EventSinkConfig is a event sink config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EventSinkConfig is a event sink config document.",
		Fields: []encoder.Doc{
			{}, {
				Name:        "endpoint",
				Type:        "string",
				Note:        "",
				Description: "The endpoint for the event sink as 'host:port'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The endpoint for the event sink as 'host:port'." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleEventSinkV1Alpha1())

	doc.Fields[1].AddExample("", "10.3.7.3:2810")

	return doc
}

func (WatchdogTimerV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "WatchdogTimerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "WatchdogTimerConfig is a watchdog timer config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "WatchdogTimerConfig is a watchdog timer config document.",
		Fields: []encoder.Doc{
			{},
			{
				Name:        "device",
				Type:        "string",
				Note:        "",
				Description: "Path to the watchdog device.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Path to the watchdog device." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "timeout",
				Type:        "Duration",
				Note:        "",
				Description: "Timeout for the watchdog.\n\nIf Talos is unresponsive for this duration, the watchdog will reset the system.\n\nDefault value is 1 minute, minimum value is 10 seconds.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Timeout for the watchdog." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleWatchdogTimerV1Alpha1())

	doc.Fields[1].AddExample("", "/dev/watchdog0")

	return doc
}

// GetFileDoc returns documentation for the file runtime_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "runtime",
		Description: "Package runtime provides runtime machine configuration documents.\n",
		Structs: []*encoder.Doc{
			KmsgLogV1Alpha1{}.Doc(),
			EventSinkV1Alpha1{}.Doc(),
			WatchdogTimerV1Alpha1{}.Doc(),
		},
	}
}
