// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by "deep-copy -type DefaultActionConfigV1Alpha1 -type DHCPv4ConfigV1Alpha1 -type DHCPv6ConfigV1Alpha1 -type DummyLinkConfigV1Alpha1 -type EthernetConfigV1Alpha1 -type HCloudVIPConfigV1Alpha1 -type HostnameConfigV1Alpha1 -type KubespanEndpointsConfigV1Alpha1 -type Layer2VIPConfigV1Alpha1 -type LinkConfigV1Alpha1 -type LinkAliasConfigV1Alpha1 -type RuleConfigV1Alpha1 -type StaticHostConfigV1Alpha1 -pointer-receiver -header-file ../../../../../hack/boilerplate.txt -o deep_copy.generated.go ."; DO NOT EDIT.

package network

import (
	"net/netip"

	"github.com/siderolabs/talos/pkg/machinery/nethelpers"
)

// DeepCopy generates a deep copy of *DefaultActionConfigV1Alpha1.
func (o *DefaultActionConfigV1Alpha1) DeepCopy() *DefaultActionConfigV1Alpha1 {
	var cp DefaultActionConfigV1Alpha1 = *o
	return &cp
}

// DeepCopy generates a deep copy of *DHCPv4ConfigV1Alpha1.
func (o *DHCPv4ConfigV1Alpha1) DeepCopy() *DHCPv4ConfigV1Alpha1 {
	var cp DHCPv4ConfigV1Alpha1 = *o
	if o.ConfigIgnoreHostname != nil {
		cp.ConfigIgnoreHostname = new(bool)
		*cp.ConfigIgnoreHostname = *o.ConfigIgnoreHostname
	}
	if o.ConfigClientIdentifier != nil {
		cp.ConfigClientIdentifier = new(nethelpers.ClientIdentifier)
		*cp.ConfigClientIdentifier = *o.ConfigClientIdentifier
	}
	if o.ConfigDUIDRaw != nil {
		cp.ConfigDUIDRaw = make([]byte, len(o.ConfigDUIDRaw))
		copy(cp.ConfigDUIDRaw, o.ConfigDUIDRaw)
	}
	return &cp
}

// DeepCopy generates a deep copy of *DHCPv6ConfigV1Alpha1.
func (o *DHCPv6ConfigV1Alpha1) DeepCopy() *DHCPv6ConfigV1Alpha1 {
	var cp DHCPv6ConfigV1Alpha1 = *o
	if o.ConfigIgnoreHostname != nil {
		cp.ConfigIgnoreHostname = new(bool)
		*cp.ConfigIgnoreHostname = *o.ConfigIgnoreHostname
	}
	if o.ConfigClientIdentifier != nil {
		cp.ConfigClientIdentifier = new(nethelpers.ClientIdentifier)
		*cp.ConfigClientIdentifier = *o.ConfigClientIdentifier
	}
	if o.ConfigDUIDRaw != nil {
		cp.ConfigDUIDRaw = make([]byte, len(o.ConfigDUIDRaw))
		copy(cp.ConfigDUIDRaw, o.ConfigDUIDRaw)
	}
	return &cp
}

// DeepCopy generates a deep copy of *DummyLinkConfigV1Alpha1.
func (o *DummyLinkConfigV1Alpha1) DeepCopy() *DummyLinkConfigV1Alpha1 {
	var cp DummyLinkConfigV1Alpha1 = *o
	if o.HardwareAddressConfig != nil {
		cp.HardwareAddressConfig = make([]byte, len(o.HardwareAddressConfig))
		copy(cp.HardwareAddressConfig, o.HardwareAddressConfig)
	}
	if o.CommonLinkConfig.LinkUp != nil {
		cp.CommonLinkConfig.LinkUp = new(bool)
		*cp.CommonLinkConfig.LinkUp = *o.CommonLinkConfig.LinkUp
	}
	if o.CommonLinkConfig.LinkAddresses != nil {
		cp.CommonLinkConfig.LinkAddresses = make([]AddressConfig, len(o.CommonLinkConfig.LinkAddresses))
		copy(cp.CommonLinkConfig.LinkAddresses, o.CommonLinkConfig.LinkAddresses)
		for i3 := range o.CommonLinkConfig.LinkAddresses {
			if o.CommonLinkConfig.LinkAddresses[i3].AddressPriority != nil {
				cp.CommonLinkConfig.LinkAddresses[i3].AddressPriority = new(uint32)
				*cp.CommonLinkConfig.LinkAddresses[i3].AddressPriority = *o.CommonLinkConfig.LinkAddresses[i3].AddressPriority
			}
		}
	}
	if o.CommonLinkConfig.LinkRoutes != nil {
		cp.CommonLinkConfig.LinkRoutes = make([]RouteConfig, len(o.CommonLinkConfig.LinkRoutes))
		copy(cp.CommonLinkConfig.LinkRoutes, o.CommonLinkConfig.LinkRoutes)
	}
	return &cp
}

// DeepCopy generates a deep copy of *EthernetConfigV1Alpha1.
func (o *EthernetConfigV1Alpha1) DeepCopy() *EthernetConfigV1Alpha1 {
	var cp EthernetConfigV1Alpha1 = *o
	if o.FeaturesConfig != nil {
		cp.FeaturesConfig = make(map[string]bool, len(o.FeaturesConfig))
		for k2, v2 := range o.FeaturesConfig {
			cp.FeaturesConfig[k2] = v2
		}
	}
	if o.RingsConfig != nil {
		cp.RingsConfig = new(EthernetRingsConfig)
		*cp.RingsConfig = *o.RingsConfig
		if o.RingsConfig.RX != nil {
			cp.RingsConfig.RX = new(uint32)
			*cp.RingsConfig.RX = *o.RingsConfig.RX
		}
		if o.RingsConfig.TX != nil {
			cp.RingsConfig.TX = new(uint32)
			*cp.RingsConfig.TX = *o.RingsConfig.TX
		}
		if o.RingsConfig.RXMini != nil {
			cp.RingsConfig.RXMini = new(uint32)
			*cp.RingsConfig.RXMini = *o.RingsConfig.RXMini
		}
		if o.RingsConfig.RXJumbo != nil {
			cp.RingsConfig.RXJumbo = new(uint32)
			*cp.RingsConfig.RXJumbo = *o.RingsConfig.RXJumbo
		}
		if o.RingsConfig.RXBufLen != nil {
			cp.RingsConfig.RXBufLen = new(uint32)
			*cp.RingsConfig.RXBufLen = *o.RingsConfig.RXBufLen
		}
		if o.RingsConfig.CQESize != nil {
			cp.RingsConfig.CQESize = new(uint32)
			*cp.RingsConfig.CQESize = *o.RingsConfig.CQESize
		}
		if o.RingsConfig.TXPush != nil {
			cp.RingsConfig.TXPush = new(bool)
			*cp.RingsConfig.TXPush = *o.RingsConfig.TXPush
		}
		if o.RingsConfig.RXPush != nil {
			cp.RingsConfig.RXPush = new(bool)
			*cp.RingsConfig.RXPush = *o.RingsConfig.RXPush
		}
		if o.RingsConfig.TXPushBufLen != nil {
			cp.RingsConfig.TXPushBufLen = new(uint32)
			*cp.RingsConfig.TXPushBufLen = *o.RingsConfig.TXPushBufLen
		}
		if o.RingsConfig.TCPDataSplit != nil {
			cp.RingsConfig.TCPDataSplit = new(bool)
			*cp.RingsConfig.TCPDataSplit = *o.RingsConfig.TCPDataSplit
		}
	}
	if o.ChannelsConfig != nil {
		cp.ChannelsConfig = new(EthernetChannelsConfig)
		*cp.ChannelsConfig = *o.ChannelsConfig
		if o.ChannelsConfig.RX != nil {
			cp.ChannelsConfig.RX = new(uint32)
			*cp.ChannelsConfig.RX = *o.ChannelsConfig.RX
		}
		if o.ChannelsConfig.TX != nil {
			cp.ChannelsConfig.TX = new(uint32)
			*cp.ChannelsConfig.TX = *o.ChannelsConfig.TX
		}
		if o.ChannelsConfig.Other != nil {
			cp.ChannelsConfig.Other = new(uint32)
			*cp.ChannelsConfig.Other = *o.ChannelsConfig.Other
		}
		if o.ChannelsConfig.Combined != nil {
			cp.ChannelsConfig.Combined = new(uint32)
			*cp.ChannelsConfig.Combined = *o.ChannelsConfig.Combined
		}
	}
	if o.WakeOnLANConfig != nil {
		cp.WakeOnLANConfig = make([]nethelpers.WOLMode, len(o.WakeOnLANConfig))
		copy(cp.WakeOnLANConfig, o.WakeOnLANConfig)
	}
	return &cp
}

// DeepCopy generates a deep copy of *HCloudVIPConfigV1Alpha1.
func (o *HCloudVIPConfigV1Alpha1) DeepCopy() *HCloudVIPConfigV1Alpha1 {
	var cp HCloudVIPConfigV1Alpha1 = *o
	return &cp
}

// DeepCopy generates a deep copy of *HostnameConfigV1Alpha1.
func (o *HostnameConfigV1Alpha1) DeepCopy() *HostnameConfigV1Alpha1 {
	var cp HostnameConfigV1Alpha1 = *o
	if o.ConfigAuto != nil {
		cp.ConfigAuto = new(nethelpers.AutoHostnameKind)
		*cp.ConfigAuto = *o.ConfigAuto
	}
	return &cp
}

// DeepCopy generates a deep copy of *KubespanEndpointsConfigV1Alpha1.
func (o *KubespanEndpointsConfigV1Alpha1) DeepCopy() *KubespanEndpointsConfigV1Alpha1 {
	var cp KubespanEndpointsConfigV1Alpha1 = *o
	if o.ExtraAnnouncedEndpointsConfig != nil {
		cp.ExtraAnnouncedEndpointsConfig = make([]netip.AddrPort, len(o.ExtraAnnouncedEndpointsConfig))
		copy(cp.ExtraAnnouncedEndpointsConfig, o.ExtraAnnouncedEndpointsConfig)
	}
	return &cp
}

// DeepCopy generates a deep copy of *Layer2VIPConfigV1Alpha1.
func (o *Layer2VIPConfigV1Alpha1) DeepCopy() *Layer2VIPConfigV1Alpha1 {
	var cp Layer2VIPConfigV1Alpha1 = *o
	return &cp
}

// DeepCopy generates a deep copy of *LinkConfigV1Alpha1.
func (o *LinkConfigV1Alpha1) DeepCopy() *LinkConfigV1Alpha1 {
	var cp LinkConfigV1Alpha1 = *o
	if o.CommonLinkConfig.LinkUp != nil {
		cp.CommonLinkConfig.LinkUp = new(bool)
		*cp.CommonLinkConfig.LinkUp = *o.CommonLinkConfig.LinkUp
	}
	if o.CommonLinkConfig.LinkAddresses != nil {
		cp.CommonLinkConfig.LinkAddresses = make([]AddressConfig, len(o.CommonLinkConfig.LinkAddresses))
		copy(cp.CommonLinkConfig.LinkAddresses, o.CommonLinkConfig.LinkAddresses)
		for i3 := range o.CommonLinkConfig.LinkAddresses {
			if o.CommonLinkConfig.LinkAddresses[i3].AddressPriority != nil {
				cp.CommonLinkConfig.LinkAddresses[i3].AddressPriority = new(uint32)
				*cp.CommonLinkConfig.LinkAddresses[i3].AddressPriority = *o.CommonLinkConfig.LinkAddresses[i3].AddressPriority
			}
		}
	}
	if o.CommonLinkConfig.LinkRoutes != nil {
		cp.CommonLinkConfig.LinkRoutes = make([]RouteConfig, len(o.CommonLinkConfig.LinkRoutes))
		copy(cp.CommonLinkConfig.LinkRoutes, o.CommonLinkConfig.LinkRoutes)
	}
	return &cp
}

// DeepCopy generates a deep copy of *LinkAliasConfigV1Alpha1.
func (o *LinkAliasConfigV1Alpha1) DeepCopy() *LinkAliasConfigV1Alpha1 {
	var cp LinkAliasConfigV1Alpha1 = *o
	return &cp
}

// DeepCopy generates a deep copy of *RuleConfigV1Alpha1.
func (o *RuleConfigV1Alpha1) DeepCopy() *RuleConfigV1Alpha1 {
	var cp RuleConfigV1Alpha1 = *o
	if o.PortSelector.Ports != nil {
		cp.PortSelector.Ports = make([]PortRange, len(o.PortSelector.Ports))
		copy(cp.PortSelector.Ports, o.PortSelector.Ports)
	}
	if o.Ingress != nil {
		cp.Ingress = make([]IngressRule, len(o.Ingress))
		copy(cp.Ingress, o.Ingress)
	}
	return &cp
}

// DeepCopy generates a deep copy of *StaticHostConfigV1Alpha1.
func (o *StaticHostConfigV1Alpha1) DeepCopy() *StaticHostConfigV1Alpha1 {
	var cp StaticHostConfigV1Alpha1 = *o
	if o.Hostnames != nil {
		cp.Hostnames = make([]string, len(o.Hostnames))
		copy(cp.Hostnames, o.Hostnames)
	}
	return &cp
}
