/* page-texture.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from page-texture.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Bartłomiej Maryńczak <marynczakbartlomiej@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <graphene-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PAGE_TO_PIXBUF (page_to_pixbuf_get_type ())
#define PAGE_TO_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_TO_PIXBUF, PageToPixbuf))
#define PAGE_TO_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_TO_PIXBUF, PageToPixbufClass))
#define IS_PAGE_TO_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_TO_PIXBUF))
#define IS_PAGE_TO_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_TO_PIXBUF))
#define PAGE_TO_PIXBUF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_TO_PIXBUF, PageToPixbufClass))

typedef struct _PageToPixbuf PageToPixbuf;
typedef struct _PageToPixbufClass PageToPixbufClass;
typedef struct _PageToPixbufPrivate PageToPixbufPrivate;
typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
enum  {
	PAGE_TO_PIXBUF_0_PROPERTY,
	PAGE_TO_PIXBUF_PIXBUF_PROPERTY,
	PAGE_TO_PIXBUF_NUM_PROPERTIES
};
static GParamSpec* page_to_pixbuf_properties[PAGE_TO_PIXBUF_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_TEXTURE_UPDATE_TASK (texture_update_task_get_type ())
#define TEXTURE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXTURE_UPDATE_TASK, TextureUpdateTask))
#define TEXTURE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXTURE_UPDATE_TASK, TextureUpdateTaskClass))
#define IS_TEXTURE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXTURE_UPDATE_TASK))
#define IS_TEXTURE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXTURE_UPDATE_TASK))
#define TEXTURE_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXTURE_UPDATE_TASK, TextureUpdateTaskClass))

typedef struct _TextureUpdateTask TextureUpdateTask;
typedef struct _TextureUpdateTaskClass TextureUpdateTaskClass;
typedef struct _TextureUpdateTaskPrivate TextureUpdateTaskPrivate;
typedef struct _ParamSpecTextureUpdateTask ParamSpecTextureUpdateTask;

#define TYPE_TEXTURE_RESIZE_TASK (texture_resize_task_get_type ())
#define TEXTURE_RESIZE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXTURE_RESIZE_TASK, TextureResizeTask))
#define TEXTURE_RESIZE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXTURE_RESIZE_TASK, TextureResizeTaskClass))
#define IS_TEXTURE_RESIZE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXTURE_RESIZE_TASK))
#define IS_TEXTURE_RESIZE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXTURE_RESIZE_TASK))
#define TEXTURE_RESIZE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXTURE_RESIZE_TASK, TextureResizeTaskClass))

typedef struct _TextureResizeTask TextureResizeTask;
typedef struct _TextureResizeTaskClass TextureResizeTaskClass;
typedef struct _TextureResizeTaskPrivate TextureResizeTaskPrivate;

#define TYPE_PAGE_VIEW_TEXTURE (page_view_texture_get_type ())
#define PAGE_VIEW_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW_TEXTURE, PageViewTexture))
#define PAGE_VIEW_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW_TEXTURE, PageViewTextureClass))
#define IS_PAGE_VIEW_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW_TEXTURE))
#define IS_PAGE_VIEW_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW_TEXTURE))
#define PAGE_VIEW_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW_TEXTURE, PageViewTextureClass))

typedef struct _PageViewTexture PageViewTexture;
typedef struct _PageViewTextureClass PageViewTextureClass;
typedef struct _PageViewTexturePrivate PageViewTexturePrivate;
enum  {
	PAGE_VIEW_TEXTURE_0_PROPERTY,
	PAGE_VIEW_TEXTURE_PIXBUF_PROPERTY,
	PAGE_VIEW_TEXTURE_NUM_PROPERTIES
};
static GParamSpec* page_view_texture_properties[PAGE_VIEW_TEXTURE_NUM_PROPERTIES];
#define _texture_update_task_unref0(var) ((var == NULL) ? NULL : (var = (texture_update_task_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _Block10Data Block10Data;
enum  {
	PAGE_VIEW_TEXTURE_NEW_BUFFER_SIGNAL,
	PAGE_VIEW_TEXTURE_NUM_SIGNALS
};
static guint page_view_texture_signals[PAGE_VIEW_TEXTURE_NUM_SIGNALS] = {0};

#define TYPE_PAGE_PAINTABLE (page_paintable_get_type ())
#define PAGE_PAINTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_PAINTABLE, PagePaintable))
#define PAGE_PAINTABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_PAINTABLE, PagePaintableClass))
#define IS_PAGE_PAINTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_PAINTABLE))
#define IS_PAGE_PAINTABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_PAINTABLE))
#define PAGE_PAINTABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_PAINTABLE, PagePaintableClass))

typedef struct _PagePaintable PagePaintable;
typedef struct _PagePaintableClass PagePaintableClass;
typedef struct _PagePaintablePrivate PagePaintablePrivate;
enum  {
	PAGE_PAINTABLE_0_PROPERTY,
	PAGE_PAINTABLE_NUM_PROPERTIES
};
static GParamSpec* page_paintable_properties[PAGE_PAINTABLE_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PageToPixbuf {
	GObject parent_instance;
	PageToPixbufPrivate * priv;
	gint width;
	gint height;
};

struct _PageToPixbufClass {
	GObjectClass parent_class;
};

struct _PageToPixbufPrivate {
	GdkPixbuf* pixbuf_;
	ScanDirection scan_direction;
	gint scan_line;
};

struct _TextureUpdateTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextureUpdateTaskPrivate * priv;
	Page* page;
};

struct _TextureUpdateTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TextureUpdateTask *self);
};

struct _ParamSpecTextureUpdateTask {
	GParamSpec parent_instance;
};

struct _TextureResizeTask {
	TextureUpdateTask parent_instance;
	TextureResizeTaskPrivate * priv;
};

struct _TextureResizeTaskClass {
	TextureUpdateTaskClass parent_class;
};

struct _TextureResizeTaskPrivate {
	gint _width;
	gint _height;
};

struct _PageViewTexture {
	GObject parent_instance;
	PageViewTexturePrivate * priv;
};

struct _PageViewTextureClass {
	GObjectClass parent_class;
};

struct _PageViewTexturePrivate {
	GdkPixbuf* _pixbuf;
	gint requested_width;
	gint requested_height;
	TextureUpdateTask* queued;
	gboolean in_proggres;
	GThreadPool* resize_pool;
	Page* page;
	PageToPixbuf* page_view;
};

struct _Block10Data {
	int _ref_count_;
	PageViewTexture* self;
	GdkPixbuf* new_pixbuf;
};

struct _PagePaintable {
	GObject parent_instance;
	PagePaintablePrivate * priv;
};

struct _PagePaintableClass {
	GObjectClass parent_class;
};

struct _PagePaintablePrivate {
	Page* page;
	PageViewTexture* page_texture;
	GdkTexture* texture;
};

static gint PageToPixbuf_private_offset;
static gpointer page_to_pixbuf_parent_class = NULL;
static gpointer texture_update_task_parent_class = NULL;
static gint TextureResizeTask_private_offset;
static gpointer texture_resize_task_parent_class = NULL;
static gint PageViewTexture_private_offset;
static gpointer page_view_texture_parent_class = NULL;
static gint PagePaintable_private_offset;
static gpointer page_paintable_parent_class = NULL;
static GdkPaintableInterface * page_paintable_gdk_paintable_parent_iface = NULL;

VALA_EXTERN GType page_to_pixbuf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageToPixbuf, g_object_unref)
VALA_EXTERN GType scan_direction_get_type (void) G_GNUC_CONST ;
static guchar page_to_pixbuf_get_sample (guchar* pixels,
                                  gint pixels_length1,
                                  gint offset,
                                  gint x,
                                  gint depth,
                                  gint sample);
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
static void page_to_pixbuf_get_pixel (Page* page,
                               gint x,
                               gint y,
                               guchar* pixel,
                               gint pixel_length1);
VALA_EXTERN ScanDirection page_get_scan_direction (Page* self);
VALA_EXTERN gint page_get_scan_width (Page* self);
VALA_EXTERN gint page_get_scan_height (Page* self);
VALA_EXTERN gint page_get_depth (Page* self);
VALA_EXTERN gint page_get_n_channels (Page* self);
VALA_EXTERN guchar* page_get_pixels (Page* self,
                         gint* result_length1);
VALA_EXTERN gint page_get_rowstride (Page* self);
static void page_to_pixbuf_set_pixel (Page* page,
                               gdouble l,
                               gdouble r,
                               gdouble t,
                               gdouble b,
                               guchar* output,
                               gint output_length1,
                               gint offset);
VALA_EXTERN void page_to_pixbuf_update_preview (Page* page,
                                    GdkPixbuf** output_image,
                                    gint output_width,
                                    gint output_height,
                                    ScanDirection scan_direction,
                                    gint old_scan_line,
                                    gint scan_line);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN gboolean page_get_has_data (Page* self);
VALA_EXTERN void page_to_pixbuf_update (PageToPixbuf* self,
                            Page* page);
VALA_EXTERN gint page_get_scan_line (Page* self);
VALA_EXTERN PageToPixbuf* page_to_pixbuf_new (void);
VALA_EXTERN PageToPixbuf* page_to_pixbuf_construct (GType object_type);
VALA_EXTERN GdkPixbuf* page_to_pixbuf_get_pixbuf (PageToPixbuf* self);
static void page_to_pixbuf_finalize (GObject * obj);
static GType page_to_pixbuf_get_type_once (void);
static void _vala_page_to_pixbuf_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
VALA_EXTERN gpointer texture_update_task_ref (gpointer instance);
VALA_EXTERN void texture_update_task_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_texture_update_task (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_texture_update_task (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_texture_update_task (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_texture_update_task (const GValue* value);
VALA_EXTERN GType texture_update_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextureUpdateTask, texture_update_task_unref)
VALA_EXTERN TextureUpdateTask* texture_update_task_new (void);
VALA_EXTERN TextureUpdateTask* texture_update_task_construct (GType object_type);
static void texture_update_task_finalize (TextureUpdateTask * obj);
static GType texture_update_task_get_type_once (void);
VALA_EXTERN GType texture_resize_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextureResizeTask, texture_update_task_unref)
VALA_EXTERN TextureResizeTask* texture_resize_task_new (gint width,
                                            gint height);
VALA_EXTERN TextureResizeTask* texture_resize_task_construct (GType object_type,
                                                  gint width,
                                                  gint height);
static void texture_resize_task_set_width (TextureResizeTask* self,
                                    gint value);
static void texture_resize_task_set_height (TextureResizeTask* self,
                                     gint value);
VALA_EXTERN gint texture_resize_task_get_width (TextureResizeTask* self);
VALA_EXTERN gint texture_resize_task_get_height (TextureResizeTask* self);
static void texture_resize_task_finalize (TextureUpdateTask * obj);
static GType texture_resize_task_get_type_once (void);
VALA_EXTERN GType page_view_texture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageViewTexture, g_object_unref)
VALA_EXTERN PageViewTexture* page_view_texture_new (Page* page);
VALA_EXTERN PageViewTexture* page_view_texture_construct (GType object_type,
                                              Page* page);
static void page_view_texture_thread_func (PageViewTexture* self,
                                    TextureUpdateTask* task);
static void _page_view_texture_thread_func_gfunc (gpointer data,
                                           gpointer self);
VALA_EXTERN void page_view_texture_request_update (PageViewTexture* self);
VALA_EXTERN void page_view_texture_request_resize (PageViewTexture* self,
                                       gint width,
                                       gint height);
VALA_EXTERN void page_view_texture_queue_update (PageViewTexture* self,
                                     GError** error);
VALA_EXTERN Page* page_copy (Page* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean __lambda9_ (Block10Data* _data10_);
static void page_view_texture_new_pixbuf_cb (PageViewTexture* self,
                                      GdkPixbuf* pixbuf);
static gboolean ___lambda9__gsource_func (gpointer self);
static void page_view_texture_set_pixbuf (PageViewTexture* self,
                                   GdkPixbuf* value);
VALA_EXTERN GdkPixbuf* page_view_texture_get_pixbuf (PageViewTexture* self);
static void page_view_texture_finalize (GObject * obj);
static GType page_view_texture_get_type_once (void);
static void _vala_page_view_texture_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_page_view_texture_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
VALA_EXTERN GType page_paintable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PagePaintable, g_object_unref)
static void page_paintable_pixels_changed (PagePaintable* self);
static void _page_paintable_pixels_changed_page_pixels_changed (Page* _sender,
                                                         gpointer self);
static void _page_paintable_pixels_changed_page_size_changed (Page* _sender,
                                                       gpointer self);
static void _page_paintable_pixels_changed_page_scan_direction_changed (Page* _sender,
                                                                 gpointer self);
static void page_paintable_texture_updated (PagePaintable* self);
static void _page_paintable_texture_updated_page_view_texture_new_buffer (PageViewTexture* _sender,
                                                                   gpointer self);
VALA_EXTERN PagePaintable* page_paintable_new (Page* page);
VALA_EXTERN PagePaintable* page_paintable_construct (GType object_type,
                                         Page* page);
static gdouble page_paintable_real_get_intrinsic_aspect_ratio (GdkPaintable* base);
static void page_paintable_real_snapshot (GdkPaintable* base,
                                   GdkSnapshot* gdk_snapshot,
                                   gdouble width,
                                   gdouble height);
static void page_paintable_finalize (GObject * obj);
static GType page_paintable_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
page_to_pixbuf_get_instance_private (PageToPixbuf* self)
{
	return G_STRUCT_MEMBER_P (self, PageToPixbuf_private_offset);
}

static guchar
page_to_pixbuf_get_sample (guchar* pixels,
                           gint pixels_length1,
                           gint offset,
                           gint x,
                           gint depth,
                           gint sample)
{
	guchar result;
	result = (guchar) 0xFF;
	return result;
}

static void
page_to_pixbuf_get_pixel (Page* page,
                          gint x,
                          gint y,
                          guchar* pixel,
                          gint pixel_length1)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	gint depth = 0;
	gint _tmp10_;
	gint _tmp11_;
	gint n_channels = 0;
	gint _tmp12_;
	gint _tmp13_;
	guchar* pixels = NULL;
	gint _tmp14_ = 0;
	guchar* _tmp15_;
	gint pixels_length1;
	gint _pixels_size_;
	gint offset = 0;
	gint _tmp16_;
	gint _tmp17_;
	gboolean _tmp18_ = FALSE;
	guchar* _tmp37_;
	gint _tmp37__length1;
	guchar* _tmp38_;
	gint _tmp38__length1;
	guchar* _tmp39_;
	gint _tmp39__length1;
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_scan_direction (page);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp2_ = page_get_scan_width (page);
			_tmp3_ = _tmp2_;
			x = (_tmp3_ - x) - 1;
			_tmp4_ = page_get_scan_height (page);
			_tmp5_ = _tmp4_;
			y = (_tmp5_ - y) - 1;
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			gint t = 0;
			gint _tmp6_;
			gint _tmp7_;
			t = x;
			_tmp6_ = page_get_scan_width (page);
			_tmp7_ = _tmp6_;
			x = (_tmp7_ - y) - 1;
			y = t;
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			gint t = 0;
			gint _tmp8_;
			gint _tmp9_;
			t = x;
			x = y;
			_tmp8_ = page_get_scan_height (page);
			_tmp9_ = _tmp8_;
			y = (_tmp9_ - t) - 1;
			break;
		}
		default:
		break;
	}
	_tmp10_ = page_get_depth (page);
	_tmp11_ = _tmp10_;
	depth = _tmp11_;
	_tmp12_ = page_get_n_channels (page);
	_tmp13_ = _tmp12_;
	n_channels = _tmp13_;
	_tmp15_ = page_get_pixels (page, &_tmp14_);
	pixels = _tmp15_;
	pixels_length1 = _tmp14_;
	_pixels_size_ = pixels_length1;
	_tmp16_ = page_get_rowstride (page);
	_tmp17_ = _tmp16_;
	offset = _tmp17_ * y;
	if (depth == 8) {
		_tmp18_ = n_channels == 3;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gint o = 0;
		guchar* _tmp19_;
		gint _tmp19__length1;
		guchar _tmp20_;
		guchar* _tmp21_;
		gint _tmp21__length1;
		guchar _tmp22_;
		guchar* _tmp23_;
		gint _tmp23__length1;
		guchar _tmp24_;
		o = offset + (x * n_channels);
		_tmp19_ = pixels;
		_tmp19__length1 = pixels_length1;
		_tmp20_ = _tmp19_[o];
		pixel[0] = _tmp20_;
		_tmp21_ = pixels;
		_tmp21__length1 = pixels_length1;
		_tmp22_ = _tmp21_[o + 1];
		pixel[1] = _tmp22_;
		_tmp23_ = pixels;
		_tmp23__length1 = pixels_length1;
		_tmp24_ = _tmp23_[o + 2];
		pixel[2] = _tmp24_;
		return;
	} else {
		gboolean _tmp25_ = FALSE;
		if (depth == 8) {
			_tmp25_ = n_channels == 1;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			guchar* _tmp26_;
			gint _tmp26__length1;
			guchar _tmp27_;
			_tmp26_ = pixels;
			_tmp26__length1 = pixels_length1;
			_tmp27_ = _tmp26_[offset + x];
			pixel[2] = _tmp27_;
			pixel[1] = pixel[2];
			pixel[0] = pixel[1];
			return;
		} else {
			gboolean _tmp28_ = FALSE;
			if (depth == 1) {
				_tmp28_ = n_channels == 1;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gint o = 0;
				gint _tmp29_ = 0;
				guchar* _tmp30_;
				gint _tmp30__length1;
				guchar _tmp31_;
				o = offset + (x / 8);
				_tmp30_ = pixels;
				_tmp30__length1 = pixels_length1;
				_tmp31_ = _tmp30_[o];
				if (((gint) (_tmp31_ & (0x80 >> (x % 8)))) != 0) {
					_tmp29_ = 0x00;
				} else {
					_tmp29_ = 0xFF;
				}
				pixel[2] = (guchar) _tmp29_;
				pixel[1] = pixel[2];
				pixel[0] = pixel[1];
				return;
			} else {
				gboolean _tmp32_ = FALSE;
				if (depth == 2) {
					_tmp32_ = n_channels == 1;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					gint block_shift[4] = {0};
					gint _tmp33_[4] = {0};
					gint o = 0;
					gint sample = 0;
					guchar* _tmp34_;
					gint _tmp34__length1;
					guchar _tmp35_;
					gint _tmp36_;
					_tmp33_[0] = 6;
					_tmp33_[1] = 4;
					_tmp33_[2] = 2;
					_tmp33_[3] = 0;
					memcpy (block_shift, _tmp33_, 4 * sizeof (gint));
					o = offset + (x / 4);
					_tmp34_ = pixels;
					_tmp34__length1 = pixels_length1;
					_tmp35_ = _tmp34_[o];
					_tmp36_ = block_shift[x % 4];
					sample = (_tmp35_ >> _tmp36_) & 0x3;
					sample = (sample * 255) / 3;
					pixel[2] = (guchar) sample;
					pixel[1] = pixel[2];
					pixel[0] = pixel[1];
					return;
				}
			}
		}
	}
	_tmp37_ = pixels;
	_tmp37__length1 = pixels_length1;
	pixel[0] = page_to_pixbuf_get_sample (_tmp37_, (gint) _tmp37__length1, offset, x, depth, x * n_channels);
	_tmp38_ = pixels;
	_tmp38__length1 = pixels_length1;
	pixel[1] = page_to_pixbuf_get_sample (_tmp38_, (gint) _tmp38__length1, offset, x, depth, (x * n_channels) + 1);
	_tmp39_ = pixels;
	_tmp39__length1 = pixels_length1;
	pixel[2] = page_to_pixbuf_get_sample (_tmp39_, (gint) _tmp39__length1, offset, x, depth, (x * n_channels) + 2);
}

static void
page_to_pixbuf_set_pixel (Page* page,
                          gdouble l,
                          gdouble r,
                          gdouble t,
                          gdouble b,
                          guchar* output,
                          gint output_length1,
                          gint offset)
{
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp66_ = FALSE;
	gdouble scale = 0.0;
	g_return_if_fail (page != NULL);
	L = (gint) l;
	if (((gdouble) L) != l) {
		gint _tmp0_;
		_tmp0_ = L;
		L = _tmp0_ + 1;
	}
	R = (gint) r;
	T = (gint) t;
	if (((gdouble) T) != t) {
		gint _tmp1_;
		_tmp1_ = T;
		T = _tmp1_ + 1;
	}
	B = (gint) b;
	red = 0.0;
	green = 0.0;
	blue = 0.0;
	if ((r - l) <= 1.0) {
		_tmp3_ = ((gint) r) == ((gint) l);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if ((b - t) <= 1.0) {
			_tmp4_ = ((gint) b) == ((gint) t);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		gdouble scale = 0.0;
		if (((gint) l) == ((gint) r)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = ((gint) t) == ((gint) b);
		}
		if (_tmp5_) {
			guchar p[3] = {0};
			guchar _tmp6_;
			guchar _tmp7_;
			guchar _tmp8_;
			page_to_pixbuf_get_pixel (page, (gint) l, (gint) t, p, (gint) 3);
			_tmp6_ = p[0];
			output[offset] = _tmp6_;
			_tmp7_ = p[1];
			output[offset + 1] = _tmp7_;
			_tmp8_ = p[2];
			output[offset + 2] = _tmp8_;
			return;
		}
		if (L > R) {
			guchar p[3] = {0};
			guchar _tmp9_;
			guchar _tmp10_;
			guchar _tmp11_;
			guchar _tmp17_;
			guchar _tmp18_;
			guchar _tmp19_;
			page_to_pixbuf_get_pixel (page, R, T - 1, p, (gint) 3);
			_tmp9_ = p[0];
			red += (_tmp9_ * (r - l)) * (T - t);
			_tmp10_ = p[1];
			green += (_tmp10_ * (r - l)) * (T - t);
			_tmp11_ = p[2];
			blue += (_tmp11_ * (r - l)) * (T - t);
			{
				gint y = 0;
				y = T;
				{
					gboolean _tmp12_ = FALSE;
					_tmp12_ = TRUE;
					while (TRUE) {
						guchar _tmp14_;
						guchar _tmp15_;
						guchar _tmp16_;
						if (!_tmp12_) {
							gint _tmp13_;
							_tmp13_ = y;
							y = _tmp13_ + 1;
						}
						_tmp12_ = FALSE;
						if (!(y < B)) {
							break;
						}
						page_to_pixbuf_get_pixel (page, R, y, p, (gint) 3);
						_tmp14_ = p[0];
						red += _tmp14_ * (r - l);
						_tmp15_ = p[1];
						green += _tmp15_ * (r - l);
						_tmp16_ = p[2];
						blue += _tmp16_ * (r - l);
					}
				}
			}
			page_to_pixbuf_get_pixel (page, R, B, p, (gint) 3);
			_tmp17_ = p[0];
			red += (_tmp17_ * (r - l)) * (b - B);
			_tmp18_ = p[1];
			green += (_tmp18_ * (r - l)) * (b - B);
			_tmp19_ = p[2];
			blue += (_tmp19_ * (r - l)) * (b - B);
		} else {
			guchar p[3] = {0};
			guchar _tmp20_;
			guchar _tmp21_;
			guchar _tmp22_;
			guchar _tmp28_;
			guchar _tmp29_;
			guchar _tmp30_;
			page_to_pixbuf_get_pixel (page, L - 1, B, p, (gint) 3);
			_tmp20_ = p[0];
			red += (_tmp20_ * (b - t)) * (L - l);
			_tmp21_ = p[1];
			green += (_tmp21_ * (b - t)) * (L - l);
			_tmp22_ = p[2];
			blue += (_tmp22_ * (b - t)) * (L - l);
			{
				gint x = 0;
				x = L;
				{
					gboolean _tmp23_ = FALSE;
					_tmp23_ = TRUE;
					while (TRUE) {
						guchar _tmp25_;
						guchar _tmp26_;
						guchar _tmp27_;
						if (!_tmp23_) {
							gint _tmp24_;
							_tmp24_ = x;
							x = _tmp24_ + 1;
						}
						_tmp23_ = FALSE;
						if (!(x < R)) {
							break;
						}
						page_to_pixbuf_get_pixel (page, x, B, p, (gint) 3);
						_tmp25_ = p[0];
						red += _tmp25_ * (b - t);
						_tmp26_ = p[1];
						green += _tmp26_ * (b - t);
						_tmp27_ = p[2];
						blue += _tmp27_ * (b - t);
					}
				}
			}
			page_to_pixbuf_get_pixel (page, R, B, p, (gint) 3);
			_tmp28_ = p[0];
			red += (_tmp28_ * (b - t)) * (r - R);
			_tmp29_ = p[1];
			green += (_tmp29_ * (b - t)) * (r - R);
			_tmp30_ = p[2];
			blue += (_tmp30_ * (b - t)) * (r - R);
		}
		scale = 1.0 / ((r - l) * (b - t));
		output[offset] = (guchar) ((red * scale) + 0.5);
		output[offset + 1] = (guchar) ((green * scale) + 0.5);
		output[offset + 2] = (guchar) ((blue * scale) + 0.5);
		return;
	}
	{
		gint x = 0;
		x = L;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = x;
					x = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				if (!(x < R)) {
					break;
				}
				{
					gint y = 0;
					y = T;
					{
						gboolean _tmp33_ = FALSE;
						_tmp33_ = TRUE;
						while (TRUE) {
							guchar p[3] = {0};
							guchar _tmp35_;
							guchar _tmp36_;
							guchar _tmp37_;
							if (!_tmp33_) {
								gint _tmp34_;
								_tmp34_ = y;
								y = _tmp34_ + 1;
							}
							_tmp33_ = FALSE;
							if (!(y < B)) {
								break;
							}
							page_to_pixbuf_get_pixel (page, x, y, p, (gint) 3);
							_tmp35_ = p[0];
							red += (gdouble) _tmp35_;
							_tmp36_ = p[1];
							green += (gdouble) _tmp36_;
							_tmp37_ = p[2];
							blue += (gdouble) _tmp37_;
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		x = L;
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = TRUE;
			while (TRUE) {
				if (!_tmp38_) {
					gint _tmp39_;
					_tmp39_ = x;
					x = _tmp39_ + 1;
				}
				_tmp38_ = FALSE;
				if (!(x < R)) {
					break;
				}
				if (t != ((gdouble) T)) {
					guchar p[3] = {0};
					guchar _tmp40_;
					guchar _tmp41_;
					guchar _tmp42_;
					page_to_pixbuf_get_pixel (page, x, T - 1, p, (gint) 3);
					_tmp40_ = p[0];
					red += _tmp40_ * (T - t);
					_tmp41_ = p[1];
					green += _tmp41_ * (T - t);
					_tmp42_ = p[2];
					blue += _tmp42_ * (T - t);
				}
				if (b != ((gdouble) B)) {
					guchar p[3] = {0};
					guchar _tmp43_;
					guchar _tmp44_;
					guchar _tmp45_;
					page_to_pixbuf_get_pixel (page, x, B, p, (gint) 3);
					_tmp43_ = p[0];
					red += _tmp43_ * (b - B);
					_tmp44_ = p[1];
					green += _tmp44_ * (b - B);
					_tmp45_ = p[2];
					blue += _tmp45_ * (b - B);
				}
			}
		}
	}
	{
		gint y = 0;
		y = T;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = y;
					y = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				if (!(y < B)) {
					break;
				}
				if (l != ((gdouble) L)) {
					guchar p[3] = {0};
					guchar _tmp48_;
					guchar _tmp49_;
					guchar _tmp50_;
					page_to_pixbuf_get_pixel (page, L - 1, y, p, (gint) 3);
					_tmp48_ = p[0];
					red += _tmp48_ * (L - l);
					_tmp49_ = p[1];
					green += _tmp49_ * (L - l);
					_tmp50_ = p[2];
					blue += _tmp50_ * (L - l);
				}
				if (r != ((gdouble) R)) {
					guchar p[3] = {0};
					guchar _tmp51_;
					guchar _tmp52_;
					guchar _tmp53_;
					page_to_pixbuf_get_pixel (page, R, y, p, (gint) 3);
					_tmp51_ = p[0];
					red += _tmp51_ * (r - R);
					_tmp52_ = p[1];
					green += _tmp52_ * (r - R);
					_tmp53_ = p[2];
					blue += _tmp53_ * (r - R);
				}
			}
		}
	}
	if (l != ((gdouble) L)) {
		_tmp54_ = t != ((gdouble) T);
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		guchar p[3] = {0};
		guchar _tmp55_;
		guchar _tmp56_;
		guchar _tmp57_;
		page_to_pixbuf_get_pixel (page, L - 1, T - 1, p, (gint) 3);
		_tmp55_ = p[0];
		red += (_tmp55_ * (L - l)) * (T - t);
		_tmp56_ = p[1];
		green += (_tmp56_ * (L - l)) * (T - t);
		_tmp57_ = p[2];
		blue += (_tmp57_ * (L - l)) * (T - t);
	}
	if (r != ((gdouble) R)) {
		_tmp58_ = t != ((gdouble) T);
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		guchar p[3] = {0};
		guchar _tmp59_;
		guchar _tmp60_;
		guchar _tmp61_;
		page_to_pixbuf_get_pixel (page, R, T - 1, p, (gint) 3);
		_tmp59_ = p[0];
		red += (_tmp59_ * (r - R)) * (T - t);
		_tmp60_ = p[1];
		green += (_tmp60_ * (r - R)) * (T - t);
		_tmp61_ = p[2];
		blue += (_tmp61_ * (r - R)) * (T - t);
	}
	if (r != ((gdouble) R)) {
		_tmp62_ = b != ((gdouble) B);
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		guchar p[3] = {0};
		guchar _tmp63_;
		guchar _tmp64_;
		guchar _tmp65_;
		page_to_pixbuf_get_pixel (page, R, B, p, (gint) 3);
		_tmp63_ = p[0];
		red += (_tmp63_ * (r - R)) * (b - B);
		_tmp64_ = p[1];
		green += (_tmp64_ * (r - R)) * (b - B);
		_tmp65_ = p[2];
		blue += (_tmp65_ * (r - R)) * (b - B);
	}
	if (l != ((gdouble) L)) {
		_tmp66_ = b != ((gdouble) B);
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		guchar p[3] = {0};
		guchar _tmp67_;
		guchar _tmp68_;
		guchar _tmp69_;
		page_to_pixbuf_get_pixel (page, L - 1, B, p, (gint) 3);
		_tmp67_ = p[0];
		red += (_tmp67_ * (L - l)) * (b - B);
		_tmp68_ = p[1];
		green += (_tmp68_ * (L - l)) * (b - B);
		_tmp69_ = p[2];
		blue += (_tmp69_ * (L - l)) * (b - B);
	}
	scale = 1.0 / ((r - l) * (b - t));
	output[offset] = (guchar) ((red * scale) + 0.5);
	output[offset + 1] = (guchar) ((green * scale) + 0.5);
	output[offset + 2] = (guchar) ((blue * scale) + 0.5);
}

void
page_to_pixbuf_update_preview (Page* page,
                               GdkPixbuf** output_image,
                               gint output_width,
                               gint output_height,
                               ScanDirection scan_direction,
                               gint old_scan_line,
                               gint scan_line)
{
	gint input_width = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint input_height = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	guchar* output = NULL;
	guint8* _tmp11_;
	gint output_length1;
	gint _output_size_;
	gint output_rowstride = 0;
	gint _tmp12_;
	gint _tmp13_;
	gint output_n_channels = 0;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_width (page);
	_tmp1_ = _tmp0_;
	input_width = _tmp1_;
	_tmp2_ = page_get_height (page);
	_tmp3_ = _tmp2_;
	input_height = _tmp3_;
	if ((*output_image) == NULL) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = gdk_pixbuf_get_width (*output_image);
		_tmp7_ = _tmp6_;
		_tmp5_ = _tmp7_ != output_width;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = gdk_pixbuf_get_height (*output_image);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_ != output_height;
	}
	if (_tmp4_) {
		GdkPixbuf* _tmp10_;
		_tmp10_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, output_width, output_height);
		_g_object_unref0 (*output_image);
		*output_image = _tmp10_;
		L = 0;
		R = output_width - 1;
		T = 0;
		B = output_height - 1;
	} else {
		switch (scan_direction) {
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
			{
				L = 0;
				R = output_width - 1;
				T = (gint) ((((gdouble) old_scan_line) * output_height) / input_height);
				B = (gint) (((((gdouble) scan_line) * output_height) / input_height) + 0.5);
				break;
			}
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
			{
				L = (gint) ((((gdouble) old_scan_line) * output_width) / input_width);
				R = (gint) (((((gdouble) scan_line) * output_width) / input_width) + 0.5);
				T = 0;
				B = output_height - 1;
				break;
			}
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
			{
				L = 0;
				R = output_width - 1;
				T = (gint) ((((gdouble) (input_height - scan_line)) * output_height) / input_height);
				B = (gint) (((((gdouble) (input_height - old_scan_line)) * output_height) / input_height) + 0.5);
				break;
			}
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
			{
				L = (gint) ((((gdouble) (input_width - scan_line)) * output_width) / input_width);
				R = (gint) (((((gdouble) (input_width - old_scan_line)) * output_width) / input_width) + 0.5);
				T = 0;
				B = output_height - 1;
				break;
			}
			default:
			{
				T = 0;
				B = T;
				R = B;
				L = R;
				break;
			}
		}
	}
	if (R >= output_width) {
		R = output_width - 1;
	}
	if (B >= output_height) {
		B = output_height - 1;
	}
	g_return_if_fail (L >= 0);
	g_return_if_fail (R < output_width);
	g_return_if_fail (T >= 0);
	g_return_if_fail (B < output_height);
	g_return_if_fail ((*output_image) != NULL);
	_tmp11_ = gdk_pixbuf_get_pixels (*output_image);
	output = _tmp11_;
	output_length1 = -1;
	_output_size_ = output_length1;
	_tmp12_ = gdk_pixbuf_get_rowstride (*output_image);
	_tmp13_ = _tmp12_;
	output_rowstride = _tmp13_;
	_tmp14_ = gdk_pixbuf_get_n_channels (*output_image);
	_tmp15_ = _tmp14_;
	output_n_channels = _tmp15_;
	_tmp16_ = page_get_has_data (page);
	_tmp17_ = _tmp16_;
	if (!_tmp17_) {
		{
			gint x = 0;
			x = L;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = x;
						x = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(x <= R)) {
						break;
					}
					{
						gint y = 0;
						y = T;
						{
							gboolean _tmp20_ = FALSE;
							_tmp20_ = TRUE;
							while (TRUE) {
								gint o = 0;
								guchar* _tmp22_;
								gint _tmp22__length1;
								guchar* _tmp23_;
								gint _tmp23__length1;
								guchar* _tmp24_;
								gint _tmp24__length1;
								if (!_tmp20_) {
									gint _tmp21_;
									_tmp21_ = y;
									y = _tmp21_ + 1;
								}
								_tmp20_ = FALSE;
								if (!(y <= B)) {
									break;
								}
								o = (output_rowstride * y) + (x * output_n_channels);
								_tmp22_ = output;
								_tmp22__length1 = output_length1;
								_tmp23_ = output;
								_tmp23__length1 = output_length1;
								_tmp24_ = output;
								_tmp24__length1 = output_length1;
								_tmp24_[o + 2] = (guchar) 0xFF;
								_tmp23_[o + 1] = _tmp24_[o + 2];
								_tmp22_[o] = _tmp23_[o + 1];
							}
						}
					}
				}
			}
		}
		return;
	}
	{
		gint x = 0;
		x = L;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gdouble l = 0.0;
				gdouble r = 0.0;
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = x;
					x = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				if (!(x <= R)) {
					break;
				}
				l = (((gdouble) x) * input_width) / output_width;
				r = (((gdouble) (x + 1)) * input_width) / output_width;
				{
					gint y = 0;
					y = T;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							gdouble t = 0.0;
							gdouble b = 0.0;
							guchar* _tmp29_;
							gint _tmp29__length1;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = y;
								y = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							if (!(y <= B)) {
								break;
							}
							t = (((gdouble) y) * input_height) / output_height;
							b = (((gdouble) (y + 1)) * input_height) / output_height;
							_tmp29_ = output;
							_tmp29__length1 = output_length1;
							page_to_pixbuf_set_pixel (page, l, r, t, b, _tmp29_, (gint) _tmp29__length1, (output_rowstride * y) + (x * output_n_channels));
						}
					}
				}
			}
		}
	}
}

void
page_to_pixbuf_update (PageToPixbuf* self,
                       Page* page)
{
	gint old_scan_line = 0;
	gint _tmp0_;
	gint _tmp1_;
	ScanDirection left_steps = 0;
	ScanDirection _tmp2_;
	ScanDirection _tmp3_;
	gboolean _tmp4_ = FALSE;
	ScanDirection _tmp6_;
	ScanDirection _tmp7_;
	ScanDirection _tmp8_;
	ScanDirection _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	old_scan_line = self->priv->scan_line;
	_tmp0_ = page_get_scan_line (page);
	_tmp1_ = _tmp0_;
	self->priv->scan_line = _tmp1_;
	_tmp2_ = page_get_scan_direction (page);
	_tmp3_ = _tmp2_;
	left_steps = self->priv->scan_direction - _tmp3_;
	if (left_steps != 0) {
		GdkPixbuf* _tmp5_;
		_tmp5_ = self->priv->pixbuf_;
		_tmp4_ = _tmp5_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_g_object_unref0 (self->priv->pixbuf_);
		self->priv->pixbuf_ = NULL;
	}
	_tmp6_ = page_get_scan_direction (page);
	_tmp7_ = _tmp6_;
	self->priv->scan_direction = _tmp7_;
	_tmp8_ = page_get_scan_direction (page);
	_tmp9_ = _tmp8_;
	page_to_pixbuf_update_preview (page, &self->priv->pixbuf_, self->width, self->height, _tmp9_, old_scan_line, self->priv->scan_line);
}

PageToPixbuf*
page_to_pixbuf_construct (GType object_type)
{
	PageToPixbuf * self = NULL;
	self = (PageToPixbuf*) g_object_new (object_type, NULL);
	return self;
}

PageToPixbuf*
page_to_pixbuf_new (void)
{
	return page_to_pixbuf_construct (TYPE_PAGE_TO_PIXBUF);
}

GdkPixbuf*
page_to_pixbuf_get_pixbuf (PageToPixbuf* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixbuf_;
	result = _tmp0_;
	return result;
}

static void
page_to_pixbuf_class_init (PageToPixbufClass * klass,
                           gpointer klass_data)
{
	page_to_pixbuf_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageToPixbuf_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_page_to_pixbuf_get_property;
	G_OBJECT_CLASS (klass)->finalize = page_to_pixbuf_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_TO_PIXBUF_PIXBUF_PROPERTY, page_to_pixbuf_properties[PAGE_TO_PIXBUF_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
page_to_pixbuf_instance_init (PageToPixbuf * self,
                              gpointer klass)
{
	self->priv = page_to_pixbuf_get_instance_private (self);
	self->priv->pixbuf_ = NULL;
}

static void
page_to_pixbuf_finalize (GObject * obj)
{
	PageToPixbuf * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_TO_PIXBUF, PageToPixbuf);
	_g_object_unref0 (self->priv->pixbuf_);
	G_OBJECT_CLASS (page_to_pixbuf_parent_class)->finalize (obj);
}

static GType
page_to_pixbuf_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageToPixbufClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_to_pixbuf_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageToPixbuf), 0, (GInstanceInitFunc) page_to_pixbuf_instance_init, NULL };
	GType page_to_pixbuf_type_id;
	page_to_pixbuf_type_id = g_type_register_static (G_TYPE_OBJECT, "PageToPixbuf", &g_define_type_info, 0);
	PageToPixbuf_private_offset = g_type_add_instance_private (page_to_pixbuf_type_id, sizeof (PageToPixbufPrivate));
	return page_to_pixbuf_type_id;
}

GType
page_to_pixbuf_get_type (void)
{
	static volatile gsize page_to_pixbuf_type_id__once = 0;
	if (g_once_init_enter (&page_to_pixbuf_type_id__once)) {
		GType page_to_pixbuf_type_id;
		page_to_pixbuf_type_id = page_to_pixbuf_get_type_once ();
		g_once_init_leave (&page_to_pixbuf_type_id__once, page_to_pixbuf_type_id);
	}
	return page_to_pixbuf_type_id__once;
}

static void
_vala_page_to_pixbuf_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	PageToPixbuf * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE_TO_PIXBUF, PageToPixbuf);
	switch (property_id) {
		case PAGE_TO_PIXBUF_PIXBUF_PROPERTY:
		g_value_set_object (value, page_to_pixbuf_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

TextureUpdateTask*
texture_update_task_construct (GType object_type)
{
	TextureUpdateTask* self = NULL;
	self = (TextureUpdateTask*) g_type_create_instance (object_type);
	return self;
}

TextureUpdateTask*
texture_update_task_new (void)
{
	return texture_update_task_construct (TYPE_TEXTURE_UPDATE_TASK);
}

static void
value_texture_update_task_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_texture_update_task_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		texture_update_task_unref (value->data[0].v_pointer);
	}
}

static void
value_texture_update_task_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = texture_update_task_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_texture_update_task_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_texture_update_task_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TextureUpdateTask * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = texture_update_task_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_texture_update_task_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	TextureUpdateTask ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = texture_update_task_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_texture_update_task (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecTextureUpdateTask* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXTURE_UPDATE_TASK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_texture_update_task (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXTURE_UPDATE_TASK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_texture_update_task (GValue* value,
                               gpointer v_object)
{
	TextureUpdateTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXTURE_UPDATE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXTURE_UPDATE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		texture_update_task_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		texture_update_task_unref (old);
	}
}

void
value_take_texture_update_task (GValue* value,
                                gpointer v_object)
{
	TextureUpdateTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXTURE_UPDATE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXTURE_UPDATE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		texture_update_task_unref (old);
	}
}

static void
texture_update_task_class_init (TextureUpdateTaskClass * klass,
                                gpointer klass_data)
{
	texture_update_task_parent_class = g_type_class_peek_parent (klass);
	((TextureUpdateTaskClass *) klass)->finalize = texture_update_task_finalize;
}

static void
texture_update_task_instance_init (TextureUpdateTask * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
texture_update_task_finalize (TextureUpdateTask * obj)
{
	TextureUpdateTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXTURE_UPDATE_TASK, TextureUpdateTask);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->page);
}

/**
 * Just update texture contents
 */
static GType
texture_update_task_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_texture_update_task_init, value_texture_update_task_free_value, value_texture_update_task_copy_value, value_texture_update_task_peek_pointer, "p", value_texture_update_task_collect_value, "p", value_texture_update_task_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TextureUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) texture_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextureUpdateTask), 0, (GInstanceInitFunc) texture_update_task_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType texture_update_task_type_id;
	texture_update_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextureUpdateTask", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return texture_update_task_type_id;
}

GType
texture_update_task_get_type (void)
{
	static volatile gsize texture_update_task_type_id__once = 0;
	if (g_once_init_enter (&texture_update_task_type_id__once)) {
		GType texture_update_task_type_id;
		texture_update_task_type_id = texture_update_task_get_type_once ();
		g_once_init_leave (&texture_update_task_type_id__once, texture_update_task_type_id);
	}
	return texture_update_task_type_id__once;
}

gpointer
texture_update_task_ref (gpointer instance)
{
	TextureUpdateTask * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
texture_update_task_unref (gpointer instance)
{
	TextureUpdateTask * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEXTURE_UPDATE_TASK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
texture_resize_task_get_instance_private (TextureResizeTask* self)
{
	return G_STRUCT_MEMBER_P (self, TextureResizeTask_private_offset);
}

TextureResizeTask*
texture_resize_task_construct (GType object_type,
                               gint width,
                               gint height)
{
	TextureResizeTask* self = NULL;
	self = (TextureResizeTask*) texture_update_task_construct (object_type);
	texture_resize_task_set_width (self, width);
	texture_resize_task_set_height (self, height);
	return self;
}

TextureResizeTask*
texture_resize_task_new (gint width,
                         gint height)
{
	return texture_resize_task_construct (TYPE_TEXTURE_RESIZE_TASK, width, height);
}

gint
texture_resize_task_get_width (TextureResizeTask* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}

static void
texture_resize_task_set_width (TextureResizeTask* self,
                               gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
}

gint
texture_resize_task_get_height (TextureResizeTask* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_height;
	return result;
}

static void
texture_resize_task_set_height (TextureResizeTask* self,
                                gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_height = value;
}

static void
texture_resize_task_class_init (TextureResizeTaskClass * klass,
                                gpointer klass_data)
{
	texture_resize_task_parent_class = g_type_class_peek_parent (klass);
	((TextureUpdateTaskClass *) klass)->finalize = texture_resize_task_finalize;
	g_type_class_adjust_private_offset (klass, &TextureResizeTask_private_offset);
}

static void
texture_resize_task_instance_init (TextureResizeTask * self,
                                   gpointer klass)
{
	self->priv = texture_resize_task_get_instance_private (self);
}

static void
texture_resize_task_finalize (TextureUpdateTask * obj)
{
	TextureResizeTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXTURE_RESIZE_TASK, TextureResizeTask);
	TEXTURE_UPDATE_TASK_CLASS (texture_resize_task_parent_class)->finalize (obj);
}

/**
 * Resize the texture
 */
static GType
texture_resize_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TextureResizeTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) texture_resize_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextureResizeTask), 0, (GInstanceInitFunc) texture_resize_task_instance_init, NULL };
	GType texture_resize_task_type_id;
	texture_resize_task_type_id = g_type_register_static (TYPE_TEXTURE_UPDATE_TASK, "TextureResizeTask", &g_define_type_info, 0);
	TextureResizeTask_private_offset = g_type_add_instance_private (texture_resize_task_type_id, sizeof (TextureResizeTaskPrivate));
	return texture_resize_task_type_id;
}

GType
texture_resize_task_get_type (void)
{
	static volatile gsize texture_resize_task_type_id__once = 0;
	if (g_once_init_enter (&texture_resize_task_type_id__once)) {
		GType texture_resize_task_type_id;
		texture_resize_task_type_id = texture_resize_task_get_type_once ();
		g_once_init_leave (&texture_resize_task_type_id__once, texture_resize_task_type_id);
	}
	return texture_resize_task_type_id__once;
}

static inline gpointer
page_view_texture_get_instance_private (PageViewTexture* self)
{
	return G_STRUCT_MEMBER_P (self, PageViewTexture_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_page_view_texture_thread_func_gfunc (gpointer data,
                                      gpointer self)
{
	page_view_texture_thread_func ((PageViewTexture*) self, (TextureUpdateTask*) data);
}

PageViewTexture*
page_view_texture_construct (GType object_type,
                             Page* page)
{
	PageViewTexture * self = NULL;
	Page* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (page != NULL, NULL);
	self = (PageViewTexture*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->page);
	self->priv->page = _tmp0_;
	{
		GThreadPool* _tmp1_ = NULL;
		GThreadPool* _tmp2_;
		GThreadPool* _tmp3_;
		_tmp2_ = g_thread_pool_new (_page_view_texture_thread_func_gfunc, self, 1, FALSE, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_thread_pool_free0 (self->priv->resize_pool);
		self->priv->resize_pool = _tmp3_;
		_g_thread_pool_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

PageViewTexture*
page_view_texture_new (Page* page)
{
	return page_view_texture_construct (TYPE_PAGE_VIEW_TEXTURE, page);
}

/**
     * Notify that data needs updating (eg. pixels changed during scanning process)
     */
void
page_view_texture_request_update (PageViewTexture* self)
{
	TextureUpdateTask* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = texture_update_task_new ();
	_texture_update_task_unref0 (self->priv->queued);
	self->priv->queued = _tmp0_;
}

/**
     * Set size of the page, ignored if size did not change.
     */
void
page_view_texture_request_resize (PageViewTexture* self,
                                  gint width,
                                  gint height)
{
	gboolean _tmp0_ = FALSE;
	TextureResizeTask* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->requested_width == width) {
		_tmp0_ = self->priv->requested_height == height;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->requested_width = width;
	self->priv->requested_height = height;
	_tmp1_ = texture_resize_task_new (self->priv->requested_width, self->priv->requested_height);
	_texture_update_task_unref0 (self->priv->queued);
	self->priv->queued = (TextureUpdateTask*) _tmp1_;
}

static gpointer
_texture_update_task_ref0 (gpointer self)
{
	return self ? texture_update_task_ref (self) : NULL;
}

void
page_view_texture_queue_update (PageViewTexture* self,
                                GError** error)
{
	gboolean _tmp0_ = FALSE;
	TextureUpdateTask* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	GThreadPool* _tmp5_;
	TextureUpdateTask* _tmp6_;
	TextureUpdateTask* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->in_proggres) {
		_tmp0_ = TRUE;
	} else {
		TextureUpdateTask* _tmp1_;
		_tmp1_ = self->priv->queued;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->in_proggres = TRUE;
	_tmp2_ = self->priv->queued;
	_tmp3_ = self->priv->page;
	_tmp4_ = page_copy (_tmp3_);
	_g_object_unref0 (_tmp2_->page);
	_tmp2_->page = _tmp4_;
	_tmp5_ = self->priv->resize_pool;
	_tmp6_ = self->priv->queued;
	_tmp7_ = _texture_update_task_ref0 (_tmp6_);
	g_thread_pool_push (_tmp5_, _tmp7_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_THREAD_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_texture_update_task_unref0 (self->priv->queued);
	self->priv->queued = NULL;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		PageViewTexture* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->new_pixbuf);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
__lambda9_ (Block10Data* _data10_)
{
	PageViewTexture* self;
	GdkPixbuf* _tmp0_;
	gboolean result;
	self = _data10_->self;
	_tmp0_ = _data10_->new_pixbuf;
	page_view_texture_new_pixbuf_cb (self, _tmp0_);
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ (self);
	return result;
}

static void
page_view_texture_thread_func (PageViewTexture* self,
                               TextureUpdateTask* task)
{
	Block10Data* _data10_;
	PageToPixbuf* _tmp6_;
	Page* _tmp7_;
	PageToPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	if (IS_TEXTURE_RESIZE_TASK (task)) {
		PageToPixbuf* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		PageToPixbuf* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp0_ = self->priv->page_view;
		_tmp1_ = texture_resize_task_get_width ((TextureResizeTask*) task);
		_tmp2_ = _tmp1_;
		_tmp0_->width = _tmp2_;
		_tmp3_ = self->priv->page_view;
		_tmp4_ = texture_resize_task_get_height ((TextureResizeTask*) task);
		_tmp5_ = _tmp4_;
		_tmp3_->height = _tmp5_;
	}
	_tmp6_ = self->priv->page_view;
	_tmp7_ = task->page;
	page_to_pixbuf_update (_tmp6_, _tmp7_);
	_data10_->new_pixbuf = NULL;
	_tmp8_ = self->priv->page_view;
	_tmp9_ = page_to_pixbuf_get_pixbuf (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		PageToPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		_tmp11_ = self->priv->page_view;
		_tmp12_ = page_to_pixbuf_get_pixbuf (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gdk_pixbuf_copy (_tmp13_);
		_g_object_unref0 (_data10_->new_pixbuf);
		_data10_->new_pixbuf = _tmp14_;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda9__gsource_func, block10_data_ref (_data10_), block10_data_unref);
	_texture_update_task_unref0 (task);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
page_view_texture_new_pixbuf_cb (PageViewTexture* self,
                                 GdkPixbuf* pixbuf)
{
	g_return_if_fail (self != NULL);
	self->priv->in_proggres = FALSE;
	page_view_texture_set_pixbuf (self, pixbuf);
	g_signal_emit (self, page_view_texture_signals[PAGE_VIEW_TEXTURE_NEW_BUFFER_SIGNAL], 0);
}

GdkPixbuf*
page_view_texture_get_pixbuf (PageViewTexture* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

static void
page_view_texture_set_pixbuf (PageViewTexture* self,
                              GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_texture_get_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, page_view_texture_properties[PAGE_VIEW_TEXTURE_PIXBUF_PROPERTY]);
	}
}

static void
page_view_texture_class_init (PageViewTextureClass * klass,
                              gpointer klass_data)
{
	page_view_texture_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageViewTexture_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_page_view_texture_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_page_view_texture_set_property;
	G_OBJECT_CLASS (klass)->finalize = page_view_texture_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_TEXTURE_PIXBUF_PROPERTY, page_view_texture_properties[PAGE_VIEW_TEXTURE_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	page_view_texture_signals[PAGE_VIEW_TEXTURE_NEW_BUFFER_SIGNAL] = g_signal_new ("new-buffer", TYPE_PAGE_VIEW_TEXTURE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
page_view_texture_instance_init (PageViewTexture * self,
                                 gpointer klass)
{
	PageToPixbuf* _tmp0_;
	self->priv = page_view_texture_get_instance_private (self);
	self->priv->queued = NULL;
	_tmp0_ = page_to_pixbuf_new ();
	self->priv->page_view = _tmp0_;
}

static void
page_view_texture_finalize (GObject * obj)
{
	PageViewTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW_TEXTURE, PageViewTexture);
	_g_object_unref0 (self->priv->_pixbuf);
	_texture_update_task_unref0 (self->priv->queued);
	_g_thread_pool_free0 (self->priv->resize_pool);
	_g_object_unref0 (self->priv->page);
	_g_object_unref0 (self->priv->page_view);
	G_OBJECT_CLASS (page_view_texture_parent_class)->finalize (obj);
}

static GType
page_view_texture_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageViewTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageViewTexture), 0, (GInstanceInitFunc) page_view_texture_instance_init, NULL };
	GType page_view_texture_type_id;
	page_view_texture_type_id = g_type_register_static (G_TYPE_OBJECT, "PageViewTexture", &g_define_type_info, 0);
	PageViewTexture_private_offset = g_type_add_instance_private (page_view_texture_type_id, sizeof (PageViewTexturePrivate));
	return page_view_texture_type_id;
}

GType
page_view_texture_get_type (void)
{
	static volatile gsize page_view_texture_type_id__once = 0;
	if (g_once_init_enter (&page_view_texture_type_id__once)) {
		GType page_view_texture_type_id;
		page_view_texture_type_id = page_view_texture_get_type_once ();
		g_once_init_leave (&page_view_texture_type_id__once, page_view_texture_type_id);
	}
	return page_view_texture_type_id__once;
}

static void
_vala_page_view_texture_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	PageViewTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE_VIEW_TEXTURE, PageViewTexture);
	switch (property_id) {
		case PAGE_VIEW_TEXTURE_PIXBUF_PROPERTY:
		g_value_set_object (value, page_view_texture_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_page_view_texture_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	PageViewTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE_VIEW_TEXTURE, PageViewTexture);
	switch (property_id) {
		case PAGE_VIEW_TEXTURE_PIXBUF_PROPERTY:
		page_view_texture_set_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
page_paintable_get_instance_private (PagePaintable* self)
{
	return G_STRUCT_MEMBER_P (self, PagePaintable_private_offset);
}

static void
_page_paintable_pixels_changed_page_pixels_changed (Page* _sender,
                                                    gpointer self)
{
	page_paintable_pixels_changed ((PagePaintable*) self);
}

static void
_page_paintable_pixels_changed_page_size_changed (Page* _sender,
                                                  gpointer self)
{
	page_paintable_pixels_changed ((PagePaintable*) self);
}

static void
_page_paintable_pixels_changed_page_scan_direction_changed (Page* _sender,
                                                            gpointer self)
{
	page_paintable_pixels_changed ((PagePaintable*) self);
}

static void
_page_paintable_texture_updated_page_view_texture_new_buffer (PageViewTexture* _sender,
                                                              gpointer self)
{
	page_paintable_texture_updated ((PagePaintable*) self);
}

PagePaintable*
page_paintable_construct (GType object_type,
                          Page* page)
{
	PagePaintable * self = NULL;
	Page* _tmp0_;
	PageViewTexture* _tmp1_;
	PageViewTexture* _tmp2_;
	g_return_val_if_fail (page != NULL, NULL);
	self = (PagePaintable*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->page);
	self->priv->page = _tmp0_;
	g_signal_connect_object (page, "pixels-changed", (GCallback) _page_paintable_pixels_changed_page_pixels_changed, self, 0);
	g_signal_connect_object (page, "size-changed", (GCallback) _page_paintable_pixels_changed_page_size_changed, self, 0);
	g_signal_connect_object (page, "scan-direction-changed", (GCallback) _page_paintable_pixels_changed_page_scan_direction_changed, self, 0);
	_tmp1_ = page_view_texture_new (page);
	_g_object_unref0 (self->priv->page_texture);
	self->priv->page_texture = _tmp1_;
	_tmp2_ = self->priv->page_texture;
	g_signal_connect_object (_tmp2_, "new-buffer", (GCallback) _page_paintable_texture_updated_page_view_texture_new_buffer, self, 0);
	page_paintable_pixels_changed (self);
	return self;
}

PagePaintable*
page_paintable_new (Page* page)
{
	return page_paintable_construct (TYPE_PAGE_PAINTABLE, page);
}

static void
page_paintable_pixels_changed (PagePaintable* self)
{
	PageViewTexture* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_texture;
	page_view_texture_request_update (_tmp0_);
	{
		PageViewTexture* _tmp1_;
		_tmp1_ = self->priv->page_texture;
		page_view_texture_queue_update (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("page-texture.vala:614: Failed to queue_update of the texture: %s", _tmp3_);
		gdk_paintable_invalidate_contents ((GdkPaintable*) self);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
page_paintable_texture_updated (PagePaintable* self)
{
	PageViewTexture* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_texture;
	_tmp1_ = page_view_texture_get_pixbuf (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		PageViewTexture* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkTexture* _tmp6_;
		_tmp3_ = self->priv->page_texture;
		_tmp4_ = page_view_texture_get_pixbuf (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gdk_texture_new_for_pixbuf (_tmp5_);
		_g_object_unref0 (self->priv->texture);
		self->priv->texture = _tmp6_;
	} else {
		_g_object_unref0 (self->priv->texture);
		self->priv->texture = NULL;
	}
	gdk_paintable_invalidate_contents ((GdkPaintable*) self);
}

static gdouble
page_paintable_real_get_intrinsic_aspect_ratio (GdkPaintable* base)
{
	PagePaintable * self;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gdouble result;
	self = (PagePaintable*) base;
	_tmp0_ = self->priv->page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->page;
	_tmp4_ = page_get_height (_tmp3_);
	_tmp5_ = _tmp4_;
	result = ((gdouble) _tmp2_) / ((gdouble) _tmp5_);
	return result;
}

static void
page_paintable_real_snapshot (GdkPaintable* base,
                              GdkSnapshot* gdk_snapshot,
                              gdouble width,
                              gdouble height)
{
	PagePaintable * self;
	GtkSnapshot* snapshot = NULL;
	GtkSnapshot* _tmp0_;
	graphene_rect_t rect = {0};
	PageViewTexture* _tmp1_;
	GdkTexture* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = (PagePaintable*) base;
	g_return_if_fail (gdk_snapshot != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (gdk_snapshot, gtk_snapshot_get_type (), GtkSnapshot));
	snapshot = _tmp0_;
	memset (&rect, 0, sizeof (graphene_rect_t));
	rect.size.width = (gfloat) width;
	rect.size.height = (gfloat) height;
	_tmp1_ = self->priv->page_texture;
	page_view_texture_request_resize (_tmp1_, (gint) width, (gint) height);
	{
		PageViewTexture* _tmp2_;
		_tmp2_ = self->priv->page_texture;
		page_view_texture_queue_update (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("page-texture.vala:648: Failed to queue_update of the texture: %s", _tmp4_);
		gdk_paintable_invalidate_contents ((GdkPaintable*) self);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (snapshot);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = self->priv->texture;
	if (_tmp5_ != NULL) {
		GdkTexture* _tmp6_;
		graphene_rect_t _tmp7_;
		_tmp6_ = self->priv->texture;
		_tmp7_ = rect;
		gtk_snapshot_append_texture (snapshot, _tmp6_, &_tmp7_);
	} else {
		GdkRGBA _tmp8_ = {0};
		graphene_rect_t _tmp9_;
		_tmp8_.red = 1.0f;
		_tmp8_.green = 1.0f;
		_tmp8_.blue = 1.0f;
		_tmp8_.alpha = 1.0f;
		_tmp9_ = rect;
		gtk_snapshot_append_color (snapshot, &_tmp8_, &_tmp9_);
	}
	_g_object_unref0 (snapshot);
}

static void
page_paintable_class_init (PagePaintableClass * klass,
                           gpointer klass_data)
{
	page_paintable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PagePaintable_private_offset);
	G_OBJECT_CLASS (klass)->finalize = page_paintable_finalize;
}

static void
page_paintable_gdk_paintable_interface_init (GdkPaintableInterface * iface,
                                             gpointer iface_data)
{
	page_paintable_gdk_paintable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_intrinsic_aspect_ratio = (gdouble (*) (GdkPaintable*)) page_paintable_real_get_intrinsic_aspect_ratio;
	iface->snapshot = (void (*) (GdkPaintable*, GdkSnapshot*, gdouble, gdouble)) page_paintable_real_snapshot;
}

static void
page_paintable_instance_init (PagePaintable * self,
                              gpointer klass)
{
	self->priv = page_paintable_get_instance_private (self);
}

static void
page_paintable_finalize (GObject * obj)
{
	PagePaintable * self;
	Page* _tmp0_;
	guint _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
	guint _tmp5_;
	PageViewTexture* _tmp6_;
	guint _tmp7_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_PAINTABLE, PagePaintable);
	_tmp0_ = self->priv->page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_paintable_pixels_changed_page_pixels_changed, self);
	_tmp2_ = self->priv->page;
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_paintable_pixels_changed_page_size_changed, self);
	_tmp4_ = self->priv->page;
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_paintable_pixels_changed_page_scan_direction_changed, self);
	_tmp6_ = self->priv->page_texture;
	g_signal_parse_name ("new-buffer", TYPE_PAGE_VIEW_TEXTURE, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_paintable_texture_updated_page_view_texture_new_buffer, self);
	_g_object_unref0 (self->priv->page);
	_g_object_unref0 (self->priv->page_texture);
	_g_object_unref0 (self->priv->texture);
	G_OBJECT_CLASS (page_paintable_parent_class)->finalize (obj);
}

static GType
page_paintable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PagePaintableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_paintable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PagePaintable), 0, (GInstanceInitFunc) page_paintable_instance_init, NULL };
	static const GInterfaceInfo gdk_paintable_info = { (GInterfaceInitFunc) page_paintable_gdk_paintable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType page_paintable_type_id;
	page_paintable_type_id = g_type_register_static (G_TYPE_OBJECT, "PagePaintable", &g_define_type_info, 0);
	g_type_add_interface_static (page_paintable_type_id, gdk_paintable_get_type (), &gdk_paintable_info);
	PagePaintable_private_offset = g_type_add_instance_private (page_paintable_type_id, sizeof (PagePaintablePrivate));
	return page_paintable_type_id;
}

GType
page_paintable_get_type (void)
{
	static volatile gsize page_paintable_type_id__once = 0;
	if (g_once_init_enter (&page_paintable_type_id__once)) {
		GType page_paintable_type_id;
		page_paintable_type_id = page_paintable_get_type_once ();
		g_once_init_leave (&page_paintable_type_id__once, page_paintable_type_id);
	}
	return page_paintable_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

