#ifndef __SOURCE4_LIBCLI_RAW_RAW_PROTO_H__
#define __SOURCE4_LIBCLI_RAW_RAW_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/libcli/raw/rawfile.c  */


/****************************************************************************
 Rename a file - async interface
****************************************************************************/
struct smbcli_request *smb_raw_rename_send(struct smbcli_tree *tree,
					union smb_rename *parms);

/****************************************************************************
 Delete a file - async interface
****************************************************************************/
struct smbcli_request *smb_raw_unlink_send(struct smbcli_tree *tree,
					   union smb_unlink *parms);

/****************************************************************************
 Create a directory - async interface
****************************************************************************/
struct smbcli_request *smb_raw_mkdir_send(struct smbcli_tree *tree,
				       union smb_mkdir *parms);

/****************************************************************************
 Remove a directory - async interface
****************************************************************************/
struct smbcli_request *smb_raw_rmdir_send(struct smbcli_tree *tree,
				       struct smb_rmdir *parms);

/****************************************************************************
 Locking calls - async interface
****************************************************************************/
struct smbcli_request *smb_raw_lock_send(struct smbcli_tree *tree, union smb_lock *parms);

/****************************************************************************
 Check for existence of a dir - async send
****************************************************************************/
struct smbcli_request *smb_raw_chkpath_send(struct smbcli_tree *tree, union smb_chkpath *parms);

/****************************************************************************
 Check for existence of a dir - sync interface
****************************************************************************/
NTSTATUS smb_raw_chkpath(struct smbcli_tree *tree, union smb_chkpath *parms);

/****************************************************************************
 flush a file - async send
 a flush with RAW_FLUSH_ALL will flush all files
****************************************************************************/
struct smbcli_request *smb_raw_flush_send(struct smbcli_tree *tree, union smb_flush *parms);

/****************************************************************************
 seek a file - async send
****************************************************************************/
struct smbcli_request *smb_raw_seek_send(struct smbcli_tree *tree,
					 union smb_seek *parms);

/****************************************************************************
 seek a file - async receive
****************************************************************************/
NTSTATUS smb_raw_seek_recv(struct smbcli_request *req,
			   union smb_seek *parms);

/* The following definitions come from ../../source4/libcli/raw/smb_signing.c  */


/***********************************************************
 SMB signing - Common code before we set a new signing implementation
************************************************************/
bool set_smb_signing_common(struct smb_signing_context *sign_info);
void mark_packet_signed(struct smb_request_buffer *out);
bool signing_good(struct smb_signing_context *sign_info,
			 unsigned int seq, bool good);
void sign_outgoing_message(struct smb_request_buffer *out, DATA_BLOB *mac_key, unsigned int seq_num);
bool check_signed_incoming_message(struct smb_request_buffer *in, DATA_BLOB *mac_key, unsigned int seq_num);

/**
 SMB signing - NULL implementation

 @note Used as an initialisation only - it will not correctly
       shut down a real signing mechanism
*/
bool smbcli_set_signing_off(struct smb_signing_context *sign_info);

/***********************************************************
 SMB signing - Simple implementation - setup the MAC key.
************************************************************/
bool smbcli_simple_set_signing(TALLOC_CTX *mem_ctx,
			       struct smb_signing_context *sign_info,
			       const DATA_BLOB *user_session_key,
			       const DATA_BLOB *response);

/* The following definitions come from ../../source4/libcli/raw/clisocket.c  */

struct composite_context *smbcli_sock_connect_send(TALLOC_CTX *mem_ctx,
						   const char *host_addr,
						   const struct smbcli_options *options,
						   const char *host_name,
						   struct loadparm_context *lp_ctx,
						   struct resolve_context *resolve_ctx,
						   struct tevent_context *event_ctx,
						   const char *socket_options,
						   struct nbt_name *calling,
						   struct nbt_name *called);
NTSTATUS smbcli_sock_connect_recv(struct composite_context *c,
				  TALLOC_CTX *mem_ctx,
				  struct smbcli_socket **result);
NTSTATUS smbcli_sock_connect(TALLOC_CTX *mem_ctx,
			     const char *host_addr,
			     const struct smbcli_options *options,
			     const char *host_name,
			     struct loadparm_context *lp_ctx,
			     struct resolve_context *resolve_ctx,
			     struct tevent_context *event_ctx,
			     const char *socket_options,
			     struct nbt_name *calling,
			     struct nbt_name *called,
			     struct smbcli_socket **result);

/* The following definitions come from ../../source4/libcli/raw/clitransport.c  */

struct smbcli_transport *smbcli_transport_init(struct smbcli_socket *sock,
					       TALLOC_CTX *parent_ctx,
					       bool primary,
					       struct smbcli_options *options);
NTSTATUS smbcli_transport_raw_init(TALLOC_CTX *mem_ctx,
				   struct tevent_context *ev,
				   struct smbXcli_conn **_conn,
				   const struct smbcli_options *options,
				   struct smbcli_transport **_transport);
void smbcli_transport_dead(struct smbcli_transport *transport, NTSTATUS status);
struct tevent_req *smbcli_transport_setup_subreq(struct smbcli_request *req);
void smbcli_transport_send(struct smbcli_request *req);

/****************************************************************************
 raw echo interface (async recv)
****************************************************************************/
NTSTATUS smb_raw_echo_recv(struct smbcli_request *req, TALLOC_CTX *mem_ctx,
			   struct smb_echo *p);

/****************************************************************************
 Send a echo (sync interface)
*****************************************************************************/
NTSTATUS smb_raw_echo(struct smbcli_transport *transport, struct smb_echo *p);

/* The following definitions come from ../../source4/libcli/raw/clisession.c  */


/****************************************************************************
 Initialize the session context
****************************************************************************/
struct smbcli_session *smbcli_session_init(struct smbcli_transport *transport,
					   TALLOC_CTX *parent_ctx, bool primary,
					   struct smbcli_session_options options);

/****************************************************************************
 Perform a session setup (async send)
****************************************************************************/
struct smbcli_request *smb_raw_sesssetup_send(struct smbcli_session *session,
					      union smb_sesssetup *parms);

/****************************************************************************
 Perform a session setup (async recv)
****************************************************************************/
NTSTATUS smb_raw_sesssetup_recv(struct smbcli_request *req,
				TALLOC_CTX *mem_ctx,
				union smb_sesssetup *parms);
NTSTATUS smb_raw_sesssetup(struct smbcli_session *session,
			   TALLOC_CTX *mem_ctx, union smb_sesssetup *parms);

/****************************************************************************
 Send a ulogoff (async send)
*****************************************************************************/
struct smbcli_request *smb_raw_ulogoff_send(struct smbcli_session *session);

/****************************************************************************
 Send a ulogoff (sync interface)
*****************************************************************************/
NTSTATUS smb_raw_ulogoff(struct smbcli_session *session);

/****************************************************************************
 Send a exit (async send)
*****************************************************************************/
struct smbcli_request *smb_raw_exit_send(struct smbcli_session *session);

/* The following definitions come from ../../source4/libcli/raw/clitree.c  */


/****************************************************************************
 Send a tconX (async send)
****************************************************************************/
struct smbcli_request *smb_raw_tcon_send(struct smbcli_tree *tree,
					 union smb_tcon *parms);

/****************************************************************************
 Send a tconX (async recv)
****************************************************************************/
NTSTATUS smb_raw_tcon_recv(struct smbcli_request *req, TALLOC_CTX *mem_ctx,
			   union smb_tcon *parms);
NTSTATUS smbcli_tree_full_connection(TALLOC_CTX *parent_ctx,
				     struct smbcli_tree **ret_tree,
				     const char *dest_host,
				     const char *service, const char *service_type,
					 const char *socket_options,
				     struct cli_credentials *credentials,
				     struct loadparm_context *lp_ctx,
				     struct resolve_context *resolve_ctx,
				     struct tevent_context *ev,
				     struct smbcli_options *options,
				     struct smbcli_session_options *session_options,
					 struct gensec_settings *gensec_settings);

/* The following definitions come from ../../source4/libcli/raw/clierror.c  */

bool smbcli_is_error(struct smbcli_tree *tree);

/* The following definitions come from ../../source4/libcli/raw/rawrequest.c  */

void smb_setup_bufinfo(struct smbcli_request *req);
struct smbcli_request *smbcli_request_setup_transport(struct smbcli_transport *transport,
						      uint8_t command, unsigned int wct, unsigned int buflen);
struct smbcli_request *smbcli_request_setup_session(struct smbcli_session *session,
						    uint8_t command, unsigned int wct, size_t buflen);
struct smbcli_request *smbcli_request_setup(struct smbcli_tree *tree,
					    uint8_t command,
					    unsigned int wct, unsigned int buflen);
NTSTATUS smbcli_chained_request_setup(struct smbcli_request *req,
				      uint8_t command,
				      unsigned int wct, size_t buflen);
NTSTATUS smbcli_chained_advance(struct smbcli_request *req);
bool smbcli_request_send(struct smbcli_request *req);
bool smbcli_request_receive(struct smbcli_request *req);
bool smbcli_request_is_error(struct smbcli_request *req);
size_t smbcli_req_append_string(struct smbcli_request *req, const char *str, unsigned int flags);
size_t smbcli_req_append_string_len(struct smbcli_request *req, const char *str, unsigned int flags, int *len);
size_t smbcli_req_append_ascii4(struct smbcli_request *req, const char *str, unsigned int flags);
size_t smbcli_req_append_blob(struct smbcli_request *req, const DATA_BLOB *blob);
size_t smbcli_req_append_bytes(struct smbcli_request *req, const uint8_t *bytes, size_t byte_len);
size_t smbcli_req_append_var_block(struct smbcli_request *req, const uint8_t *bytes, uint16_t byte_len);
size_t smbcli_req_pull_ascii(struct request_bufinfo *bufinfo, TALLOC_CTX *mem_ctx,
			     char **dest, const uint8_t *src, int byte_len, unsigned int flags);

/**
  pull a string from a request packet, returning a talloced string

  the string length is limited by the 3 things:
   - the data size in the request (end of packet)
   - the passed 'byte_len' if it is not -1
   - the end of string (null termination)

  Note that 'byte_len' is the number of bytes in the packet

  on failure zero is returned and *dest is set to NULL, otherwise the number
  of bytes consumed in the packet is returned
*/
size_t smbcli_req_pull_string(struct request_bufinfo *bufinfo, TALLOC_CTX *mem_ctx,
			   char **dest, const uint8_t *src, int byte_len, unsigned int flags);

/**
  pull a DATA_BLOB from a reply packet, returning a talloced blob
  make sure we don't go past end of packet

  if byte_len is -1 then limit the blob only by packet size
*/
DATA_BLOB smbcli_req_pull_blob(struct request_bufinfo *bufinfo, TALLOC_CTX *mem_ctx, const uint8_t *src, int byte_len);
bool smbcli_raw_pull_data(struct request_bufinfo *bufinfo, const uint8_t *src, int len, uint8_t *dest);
void smbcli_push_nttime(void *base, uint16_t offset, NTTIME t);
NTTIME smbcli_pull_nttime(void *base, uint16_t offset);

/**
  pull a UCS2 string from a blob, returning a talloced unix string

  the string length is limited by the 3 things:
   - the data size in the blob
   - the passed 'byte_len' if it is not -1
   - the end of string (null termination)

  Note that 'byte_len' is the number of bytes in the packet

  on failure zero is returned and *dest is set to NULL, otherwise the number
  of bytes consumed in the blob is returned
*/
size_t smbcli_blob_pull_ucs2(TALLOC_CTX* mem_ctx,
			     const DATA_BLOB *blob, const char **dest,
			     const uint8_t *src, int byte_len, unsigned int flags);

/**
  pull a string from a blob, returning a talloced struct smb_wire_string

  the string length is limited by the 3 things:
   - the data size in the blob
   - length field on the wire
   - the end of string (null termination)

   if STR_LEN8BIT is set in the flags then assume the length field is
   8 bits, instead of 32

  on failure zero is returned and dest->s is set to NULL, otherwise the number
  of bytes consumed in the blob is returned
*/
size_t smbcli_blob_pull_string(struct smbcli_session *session,
			       TALLOC_CTX *mem_ctx,
			       const DATA_BLOB *blob,
			       struct smb_wire_string *dest,
			       uint16_t len_offset, uint16_t str_offset,
			       unsigned int flags);

/**
  pull a string from a blob, returning a talloced char *

  Currently only used by the UNIX search info level.

  the string length is limited by 2 things:
   - the data size in the blob
   - the end of string (null termination)

  on failure zero is returned and dest->s is set to NULL, otherwise the number
  of bytes consumed in the blob is returned
*/
size_t smbcli_blob_pull_unix_string(struct smbcli_session *session,
			    TALLOC_CTX *mem_ctx,
			    DATA_BLOB *blob,
			    const char **dest,
			    uint16_t str_offset,
			    unsigned int flags);
size_t smbcli_blob_append_string(struct smbcli_session *session,
			      TALLOC_CTX *mem_ctx, DATA_BLOB *blob,
			      const char *str, unsigned int flags);
NTSTATUS smbcli_pull_guid(void *base, uint16_t offset,
			  struct GUID *guid);
NTSTATUS smbcli_push_guid(void *base, uint16_t offset, const struct GUID *guid);

/* The following definitions come from ../../source4/libcli/raw/rawreadwrite.c  */


/* The following definitions come from ../../source4/libcli/raw/rawsearch.c  */


/****************************************************************************
 Very raw search first - returns param/data blobs.
 Used in CIFS-on-CIFS NTVFS.
****************************************************************************/
NTSTATUS smb_raw_search_common(TALLOC_CTX *mem_ctx,
			       enum smb_search_data_level level,
			       const DATA_BLOB *blob,
			       union smb_search_data *data,
			       unsigned int *next_ofs,
			       unsigned int str_flags);
NTSTATUS smb_raw_search_next(struct smbcli_tree *tree,
			     TALLOC_CTX *mem_ctx,
			     union smb_search_next *io, void *private_data,
			     smbcli_search_callback callback);
NTSTATUS smb_raw_search_close(struct smbcli_tree *tree,
			      union smb_search_close *io);

/* The following definitions come from ../../source4/libcli/raw/rawsetfileinfo.c  */

bool smb_raw_setfileinfo_passthru(TALLOC_CTX *mem_ctx,
				  enum smb_setfileinfo_level level,
				  union smb_setfileinfo *parms,
				  DATA_BLOB *blob);

/****************************************************************************
 Set file info (async send)
****************************************************************************/
struct smbcli_request *smb_raw_setfileinfo_send(struct smbcli_tree *tree,
					     union smb_setfileinfo *parms);

/* The following definitions come from ../../source4/libcli/raw/raweas.c  */

size_t ea_list_size(unsigned int num_eas, struct ea_struct *eas);
size_t ea_list_size_chained(unsigned int num_eas, struct ea_struct *eas, unsigned alignment);
void ea_put_list(uint8_t *data, unsigned int num_eas, struct ea_struct *eas);
void ea_put_list_chained(uint8_t *data, unsigned int num_eas, struct ea_struct *eas,
			 unsigned alignment);
unsigned int ea_pull_struct(const DATA_BLOB *blob,
		      TALLOC_CTX *mem_ctx,
		      struct ea_struct *ea);
NTSTATUS ea_pull_list(const DATA_BLOB *blob,
		      TALLOC_CTX *mem_ctx,
		      unsigned int *num_eas, struct ea_struct **eas);
NTSTATUS ea_pull_list_chained(const DATA_BLOB *blob,
			      TALLOC_CTX *mem_ctx,
			      unsigned int *num_eas, struct ea_struct **eas);
NTSTATUS ea_pull_name_list(const DATA_BLOB *blob,
			   TALLOC_CTX *mem_ctx,
			   unsigned int *num_names, struct ea_name **ea_names);
bool ea_push_name_list(TALLOC_CTX *mem_ctx,
		       DATA_BLOB *data, unsigned int num_names, struct ea_name *eas);

/* The following definitions come from ../../source4/libcli/raw/rawtrans.c  */

struct smbcli_request *smb_raw_trans2_send(struct smbcli_tree *tree,
				       struct smb_trans2 *parms);
NTSTATUS smb_raw_trans2_recv(struct smbcli_request *req,
			     TALLOC_CTX *mem_ctx,
			     struct smb_trans2 *parms);
NTSTATUS smb_raw_trans2(struct smbcli_tree *tree,
			TALLOC_CTX *mem_ctx,
			struct smb_trans2 *parms);
struct smbcli_request *smb_raw_nttrans_send(struct smbcli_tree *tree,
					    struct smb_nttrans *parms);
NTSTATUS smb_raw_nttrans_recv(struct smbcli_request *req,
			      TALLOC_CTX *mem_ctx,
			      struct smb_nttrans *parms);

/****************************************************************************
  receive a SMB nttrans response allocating the necessary memory
  ****************************************************************************/
NTSTATUS smb_raw_nttrans(struct smbcli_tree *tree,
			 TALLOC_CTX *mem_ctx,
			 struct smb_nttrans *parms);

/* The following definitions come from ../../source4/libcli/raw/clioplock.c  */


/* The following definitions come from ../../source4/libcli/raw/rawnegotiate.c  */

NTSTATUS smb_raw_negotiate_fill_transport(struct smbcli_transport *transport);
struct tevent_req *smb_raw_negotiate_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct smbcli_transport *transport,
					  int minprotocol,
					  int maxprotocol);
NTSTATUS smb_raw_negotiate_recv(struct tevent_req *req);
NTSTATUS smb_raw_negotiate(struct smbcli_transport *transport, bool unicode,
			   int minprotocol, int maxprotocol);

/* The following definitions come from ../../source4/libcli/raw/rawfsinfo.c  */


/****************************************************************************
 Query FSInfo raw interface (async send)
****************************************************************************/
struct smbcli_request *smb_raw_fsinfo_send(struct smbcli_tree *tree,
					TALLOC_CTX *mem_ctx,
					union smb_fsinfo *fsinfo);
NTSTATUS smb_raw_fsinfo_passthru_parse(DATA_BLOB blob, TALLOC_CTX *mem_ctx,
				       enum smb_fsinfo_level level,
				       union smb_fsinfo *fsinfo);

/****************************************************************************
 Query FSInfo raw interface (async recv)
****************************************************************************/
NTSTATUS smb_raw_fsinfo_recv(struct smbcli_request *req,
			     TALLOC_CTX *mem_ctx,
			     union smb_fsinfo *fsinfo);

/* The following definitions come from ../../source4/libcli/raw/rawfileinfo.c  */

NTSTATUS smbcli_parse_stream_info(DATA_BLOB blob, TALLOC_CTX *mem_ctx,
				  struct stream_information *io);
NTSTATUS smb_raw_fileinfo_passthru_parse(const DATA_BLOB *blob, TALLOC_CTX *mem_ctx,
					 enum smb_fileinfo_level level,
					 union smb_fileinfo *parms);

/****************************************************************************
 Query file info (async send)
****************************************************************************/
struct smbcli_request *smb_raw_fileinfo_send(struct smbcli_tree *tree,
					     union smb_fileinfo *parms);

/****************************************************************************
 Query file info (async recv)
****************************************************************************/
NTSTATUS smb_raw_fileinfo_recv(struct smbcli_request *req,
			       TALLOC_CTX *mem_ctx,
			       union smb_fileinfo *parms);

/* The following definitions come from ../../source4/libcli/raw/rawnotify.c  */


/****************************************************************************
 Send a NT Cancel request - used to hurry along a pending request. Usually
 used to cancel a pending change notify request
 note that this request does not expect a response!
****************************************************************************/
NTSTATUS smb_raw_ntcancel(struct smbcli_request *oldreq);

/* The following definitions come from ../../source4/libcli/raw/rawioctl.c  */


/****************************************************************************
NT ioctl (async recv)
****************************************************************************/
struct smbcli_request *smb_raw_ioctl_send(struct smbcli_tree *tree, union smb_ioctl *parms);
NTSTATUS smb_raw_ioctl_recv(struct smbcli_request *req,
			    TALLOC_CTX *mem_ctx, union smb_ioctl *parms);
NTSTATUS smb_raw_ioctl(struct smbcli_tree *tree,
		TALLOC_CTX *mem_ctx, union smb_ioctl *parms);

/* The following definitions come from ../../source4/libcli/raw/rawacl.c  */


/****************************************************************************
fetch file ACL (async send)
****************************************************************************/
struct smbcli_request *smb_raw_query_secdesc_send(struct smbcli_tree *tree,
						  union smb_fileinfo *io);

/****************************************************************************
fetch file ACL (async recv)
****************************************************************************/
NTSTATUS smb_raw_query_secdesc_recv(struct smbcli_request *req,
				    TALLOC_CTX *mem_ctx,
				    union smb_fileinfo *io);

/****************************************************************************
fetch file ACL (sync interface)
****************************************************************************/
NTSTATUS smb_raw_query_secdesc(struct smbcli_tree *tree,
			       TALLOC_CTX *mem_ctx,
			       union smb_fileinfo *io);

/****************************************************************************
set file ACL (async send)
****************************************************************************/
struct smbcli_request *smb_raw_set_secdesc_send(struct smbcli_tree *tree,
						union smb_setfileinfo *io);

/****************************************************************************
set file ACL (sync interface)
****************************************************************************/
NTSTATUS smb_raw_set_secdesc(struct smbcli_tree *tree,
			     union smb_setfileinfo *io);

/* The following definitions come from ../../source4/libcli/raw/rawdate.c  */


/*******************************************************************
put a dos date into a buffer (time/date format)
This takes GMT time and puts local time for zone_offset in the buffer
********************************************************************/
void raw_push_dos_date(struct smbcli_transport *transport,
		      uint8_t *buf, int offset, time_t unixdate);

/*******************************************************************
put a dos date into a buffer (date/time format)
This takes GMT time and puts local time in the buffer
********************************************************************/
void raw_push_dos_date2(struct smbcli_transport *transport,
		       uint8_t *buf, int offset, time_t unixdate);

/*******************************************************************
put a dos 32 bit "unix like" date into a buffer. This routine takes
GMT and converts it to LOCAL time in zone_offset before putting it
********************************************************************/
void raw_push_dos_date3(struct smbcli_transport *transport,
		       uint8_t *buf, int offset, time_t unixdate);

/*******************************************************************
convert a dos date
********************************************************************/
time_t raw_pull_dos_date(struct smbcli_transport *transport,
			 const uint8_t *date_ptr);

/*******************************************************************
like raw_pull_dos_date() but the words are reversed
********************************************************************/
time_t raw_pull_dos_date2(struct smbcli_transport *transport,
			  const uint8_t *date_ptr);

/*******************************************************************
  create a unix GMT date from a dos date in 32 bit "unix like" format
  these arrive in server zone, with corresponding DST
  ******************************************************************/
time_t raw_pull_dos_date3(struct smbcli_transport *transport,
			  const uint8_t *date_ptr);

/* The following definitions come from ../../source4/libcli/raw/rawlpq.c  */


/****************************************************************************
 lpq - async send
****************************************************************************/
struct smbcli_request *smb_raw_lpq_send(struct smbcli_tree *tree,
					union smb_lpq *parms);

/****************************************************************************
 lpq - async receive
****************************************************************************/
NTSTATUS smb_raw_lpq_recv(struct smbcli_request *req, union smb_lpq *parms);
NTSTATUS smb_raw_lpq(struct smbcli_tree *tree, union smb_lpq *parms);

/* The following definitions come from ../../source4/libcli/raw/rawshadow.c  */

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_LIBCLI_RAW_RAW_PROTO_H__ */

