
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_srvsvc.h"
#include "bin/default/librpc/gen_ndr/ndr_srvsvc_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/svcctl.h"
static PyTypeObject srvsvc_NetCharDevInfo0_Type;
static PyTypeObject srvsvc_NetCharDevCtr0_Type;
static PyTypeObject srvsvc_NetCharDevInfo1_Type;
static PyTypeObject srvsvc_NetCharDevCtr1_Type;
static PyTypeObject srvsvc_NetCharDevInfo_Type;
static PyTypeObject srvsvc_NetCharDevCtr_Type;
static PyTypeObject srvsvc_NetCharDevInfoCtr_Type;
static PyTypeObject srvsvc_NetCharDevQInfo0_Type;
static PyTypeObject srvsvc_NetCharDevQCtr0_Type;
static PyTypeObject srvsvc_NetCharDevQInfo1_Type;
static PyTypeObject srvsvc_NetCharDevQCtr1_Type;
static PyTypeObject srvsvc_NetCharDevQInfo_Type;
static PyTypeObject srvsvc_NetCharDevQCtr_Type;
static PyTypeObject srvsvc_NetCharDevQInfoCtr_Type;
static PyTypeObject srvsvc_NetConnInfo0_Type;
static PyTypeObject srvsvc_NetConnCtr0_Type;
static PyTypeObject srvsvc_NetConnInfo1_Type;
static PyTypeObject srvsvc_NetConnCtr1_Type;
static PyTypeObject srvsvc_NetConnCtr_Type;
static PyTypeObject srvsvc_NetConnInfoCtr_Type;
static PyTypeObject srvsvc_NetFileInfo2_Type;
static PyTypeObject srvsvc_NetFileCtr2_Type;
static PyTypeObject srvsvc_NetFileInfo3_Type;
static PyTypeObject srvsvc_NetFileCtr3_Type;
static PyTypeObject srvsvc_NetFileInfo_Type;
static PyTypeObject srvsvc_NetFileCtr_Type;
static PyTypeObject srvsvc_NetFileInfoCtr_Type;
static PyTypeObject srvsvc_NetSessInfo0_Type;
static PyTypeObject srvsvc_NetSessCtr0_Type;
static PyTypeObject srvsvc_NetSessInfo1_Type;
static PyTypeObject srvsvc_NetSessCtr1_Type;
static PyTypeObject srvsvc_NetSessInfo2_Type;
static PyTypeObject srvsvc_NetSessCtr2_Type;
static PyTypeObject srvsvc_NetSessInfo10_Type;
static PyTypeObject srvsvc_NetSessCtr10_Type;
static PyTypeObject srvsvc_NetSessInfo502_Type;
static PyTypeObject srvsvc_NetSessCtr502_Type;
static PyTypeObject srvsvc_NetSessCtr_Type;
static PyTypeObject srvsvc_NetSessInfoCtr_Type;
static PyTypeObject srvsvc_NetShareInfo0_Type;
static PyTypeObject srvsvc_NetShareCtr0_Type;
static PyTypeObject srvsvc_NetShareInfo1_Type;
static PyTypeObject srvsvc_NetShareCtr1_Type;
static PyTypeObject srvsvc_NetShareInfo2_Type;
static PyTypeObject srvsvc_NetShareCtr2_Type;
static PyTypeObject srvsvc_NetShareInfo501_Type;
static PyTypeObject srvsvc_NetShareCtr501_Type;
static PyTypeObject srvsvc_NetShareInfo502_Type;
static PyTypeObject srvsvc_NetShareCtr502_Type;
static PyTypeObject srvsvc_NetShareInfo1004_Type;
static PyTypeObject srvsvc_NetShareCtr1004_Type;
static PyTypeObject srvsvc_NetShareInfo1005_Type;
static PyTypeObject srvsvc_NetShareCtr1005_Type;
static PyTypeObject srvsvc_NetShareInfo1006_Type;
static PyTypeObject srvsvc_NetShareCtr1006_Type;
static PyTypeObject srvsvc_NetShareInfo1007_Type;
static PyTypeObject srvsvc_NetShareCtr1007_Type;
static PyTypeObject srvsvc_NetShareCtr1501_Type;
static PyTypeObject srvsvc_NetShareInfo_Type;
static PyTypeObject srvsvc_NetShareCtr_Type;
static PyTypeObject srvsvc_NetShareInfoCtr_Type;
static PyTypeObject srvsvc_NetSrvInfo100_Type;
static PyTypeObject srvsvc_NetSrvInfo101_Type;
static PyTypeObject srvsvc_NetSrvInfo102_Type;
static PyTypeObject srvsvc_NetSrvInfo402_Type;
static PyTypeObject srvsvc_NetSrvInfo403_Type;
static PyTypeObject srvsvc_NetSrvInfo502_Type;
static PyTypeObject srvsvc_NetSrvInfo503_Type;
static PyTypeObject srvsvc_NetSrvInfo599_Type;
static PyTypeObject srvsvc_NetSrvInfo1005_Type;
static PyTypeObject srvsvc_NetSrvInfo1010_Type;
static PyTypeObject srvsvc_NetSrvInfo1016_Type;
static PyTypeObject srvsvc_NetSrvInfo1017_Type;
static PyTypeObject srvsvc_NetSrvInfo1018_Type;
static PyTypeObject srvsvc_NetSrvInfo1107_Type;
static PyTypeObject srvsvc_NetSrvInfo1501_Type;
static PyTypeObject srvsvc_NetSrvInfo1502_Type;
static PyTypeObject srvsvc_NetSrvInfo1503_Type;
static PyTypeObject srvsvc_NetSrvInfo1506_Type;
static PyTypeObject srvsvc_NetSrvInfo1509_Type;
static PyTypeObject srvsvc_NetSrvInfo1510_Type;
static PyTypeObject srvsvc_NetSrvInfo1511_Type;
static PyTypeObject srvsvc_NetSrvInfo1512_Type;
static PyTypeObject srvsvc_NetSrvInfo1513_Type;
static PyTypeObject srvsvc_NetSrvInfo1514_Type;
static PyTypeObject srvsvc_NetSrvInfo1515_Type;
static PyTypeObject srvsvc_NetSrvInfo1516_Type;
static PyTypeObject srvsvc_NetSrvInfo1518_Type;
static PyTypeObject srvsvc_NetSrvInfo1520_Type;
static PyTypeObject srvsvc_NetSrvInfo1521_Type;
static PyTypeObject srvsvc_NetSrvInfo1522_Type;
static PyTypeObject srvsvc_NetSrvInfo1523_Type;
static PyTypeObject srvsvc_NetSrvInfo1524_Type;
static PyTypeObject srvsvc_NetSrvInfo1525_Type;
static PyTypeObject srvsvc_NetSrvInfo1528_Type;
static PyTypeObject srvsvc_NetSrvInfo1529_Type;
static PyTypeObject srvsvc_NetSrvInfo1530_Type;
static PyTypeObject srvsvc_NetSrvInfo1533_Type;
static PyTypeObject srvsvc_NetSrvInfo1534_Type;
static PyTypeObject srvsvc_NetSrvInfo1535_Type;
static PyTypeObject srvsvc_NetSrvInfo1536_Type;
static PyTypeObject srvsvc_NetSrvInfo1537_Type;
static PyTypeObject srvsvc_NetSrvInfo1538_Type;
static PyTypeObject srvsvc_NetSrvInfo1539_Type;
static PyTypeObject srvsvc_NetSrvInfo1540_Type;
static PyTypeObject srvsvc_NetSrvInfo1541_Type;
static PyTypeObject srvsvc_NetSrvInfo1542_Type;
static PyTypeObject srvsvc_NetSrvInfo1543_Type;
static PyTypeObject srvsvc_NetSrvInfo1544_Type;
static PyTypeObject srvsvc_NetSrvInfo1545_Type;
static PyTypeObject srvsvc_NetSrvInfo1546_Type;
static PyTypeObject srvsvc_NetSrvInfo1547_Type;
static PyTypeObject srvsvc_NetSrvInfo1548_Type;
static PyTypeObject srvsvc_NetSrvInfo1549_Type;
static PyTypeObject srvsvc_NetSrvInfo1550_Type;
static PyTypeObject srvsvc_NetSrvInfo1552_Type;
static PyTypeObject srvsvc_NetSrvInfo1553_Type;
static PyTypeObject srvsvc_NetSrvInfo1554_Type;
static PyTypeObject srvsvc_NetSrvInfo1555_Type;
static PyTypeObject srvsvc_NetSrvInfo1556_Type;
static PyTypeObject srvsvc_NetSrvInfo_Type;
static PyTypeObject srvsvc_NetDiskInfo0_Type;
static PyTypeObject srvsvc_NetDiskInfo_Type;
static PyTypeObject srvsvc_Statistics_Type;
static PyTypeObject srvsvc_NetTransportInfo0_Type;
static PyTypeObject srvsvc_NetTransportCtr0_Type;
static PyTypeObject srvsvc_NetTransportInfo1_Type;
static PyTypeObject srvsvc_NetTransportCtr1_Type;
static PyTypeObject srvsvc_NetTransportInfo2_Type;
static PyTypeObject srvsvc_NetTransportCtr2_Type;
static PyTypeObject srvsvc_NetTransportInfo3_Type;
static PyTypeObject srvsvc_NetTransportCtr3_Type;
static PyTypeObject srvsvc_NetTransportCtr_Type;
static PyTypeObject srvsvc_NetTransportInfoCtr_Type;
static PyTypeObject srvsvc_NetRemoteTODInfo_Type;
static PyTypeObject srvsvc_NetTransportInfo_Type;
static PyTypeObject srvsvc_InterfaceType;
static PyTypeObject srvsvc_NetCharDevEnum_Type;
static PyTypeObject srvsvc_NetCharDevGetInfo_Type;
static PyTypeObject srvsvc_NetCharDevControl_Type;
static PyTypeObject srvsvc_NetCharDevQEnum_Type;
static PyTypeObject srvsvc_NetCharDevQGetInfo_Type;
static PyTypeObject srvsvc_NetCharDevQSetInfo_Type;
static PyTypeObject srvsvc_NetCharDevQPurge_Type;
static PyTypeObject srvsvc_NetCharDevQPurgeSelf_Type;
static PyTypeObject srvsvc_NetConnEnum_Type;
static PyTypeObject srvsvc_NetFileEnum_Type;
static PyTypeObject srvsvc_NetFileGetInfo_Type;
static PyTypeObject srvsvc_NetFileClose_Type;
static PyTypeObject srvsvc_NetSessEnum_Type;
static PyTypeObject srvsvc_NetSessDel_Type;
static PyTypeObject srvsvc_NetShareAdd_Type;
static PyTypeObject srvsvc_NetShareEnumAll_Type;
static PyTypeObject srvsvc_NetShareGetInfo_Type;
static PyTypeObject srvsvc_NetShareSetInfo_Type;
static PyTypeObject srvsvc_NetShareDel_Type;
static PyTypeObject srvsvc_NetShareDelSticky_Type;
static PyTypeObject srvsvc_NetShareCheck_Type;
static PyTypeObject srvsvc_NetSrvGetInfo_Type;
static PyTypeObject srvsvc_NetSrvSetInfo_Type;
static PyTypeObject srvsvc_NetDiskEnum_Type;
static PyTypeObject srvsvc_NetServerStatisticsGet_Type;
static PyTypeObject srvsvc_NetTransportAdd_Type;
static PyTypeObject srvsvc_NetTransportEnum_Type;
static PyTypeObject srvsvc_NetTransportDel_Type;
static PyTypeObject srvsvc_NetRemoteTOD_Type;
static PyTypeObject srvsvc_NetSetServiceBits_Type;
static PyTypeObject srvsvc_NetPathType_Type;
static PyTypeObject srvsvc_NetPathCanonicalize_Type;
static PyTypeObject srvsvc_NetPathCompare_Type;
static PyTypeObject srvsvc_NetNameValidate_Type;
static PyTypeObject srvsvc_NetPRNameCompare_Type;
static PyTypeObject srvsvc_NetShareEnum_Type;
static PyTypeObject srvsvc_NetShareDelStart_Type;
static PyTypeObject srvsvc_NetShareDelCommit_Type;
static PyTypeObject srvsvc_NetGetFileSecurity_Type;
static PyTypeObject srvsvc_NetSetFileSecurity_Type;
static PyTypeObject srvsvc_NetServerTransportAddEx_Type;
static PyTypeObject srvsvc_NetServerSetServiceBitsEx_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_srvsvc_NetCharDevInfo0_get_device(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_device;
	if (object->device == NULL) {
		Py_RETURN_NONE;
	}
	if (object->device == NULL) {
		py_device = Py_None;
		Py_INCREF(py_device);
	} else {
		if (object->device == NULL) {
			py_device = Py_None;
			Py_INCREF(py_device);
		} else {
			py_device = PyUnicode_Decode(object->device, strlen(object->device), "utf-8", "ignore");
		}
	}
	return py_device;
}

static int py_srvsvc_NetCharDevInfo0_set_device(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->device");
		return -1;
	}
	if (value == Py_None) {
		object->device = NULL;
	} else {
		object->device = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->device = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "device"),
		.get = py_srvsvc_NetCharDevInfo0_get_device,
		.set = py_srvsvc_NetCharDevInfo0_set_device,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevInfo0, type);
}


static PyTypeObject srvsvc_NetCharDevInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevInfo0",
	.tp_getset = py_srvsvc_NetCharDevInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevInfo0_new,
};


static PyObject *py_srvsvc_NetCharDevCtr0_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetCharDevCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevCtr0_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetCharDevInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetCharDevCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetCharDevInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetCharDevInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetCharDevCtr0_get_count,
		.set = py_srvsvc_NetCharDevCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetCharDevCtr0_get_array,
		.set = py_srvsvc_NetCharDevCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevCtr0, type);
}


static PyTypeObject srvsvc_NetCharDevCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevCtr0",
	.tp_getset = py_srvsvc_NetCharDevCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevCtr0_new,
};


static PyObject *py_srvsvc_NetCharDevInfo1_get_device(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_device;
	if (object->device == NULL) {
		Py_RETURN_NONE;
	}
	if (object->device == NULL) {
		py_device = Py_None;
		Py_INCREF(py_device);
	} else {
		if (object->device == NULL) {
			py_device = Py_None;
			Py_INCREF(py_device);
		} else {
			py_device = PyUnicode_Decode(object->device, strlen(object->device), "utf-8", "ignore");
		}
	}
	return py_device;
}

static int py_srvsvc_NetCharDevInfo1_set_device(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->device");
		return -1;
	}
	if (value == Py_None) {
		object->device = NULL;
	} else {
		object->device = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->device = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevInfo1_get_status(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(object->status));
	return py_status;
}

static int py_srvsvc_NetCharDevInfo1_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevInfo1_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->user, strlen(object->user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetCharDevInfo1_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user");
		return -1;
	}
	if (value == Py_None) {
		object->user = NULL;
	} else {
		object->user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevInfo1_get_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong((uint32_t)(object->time));
	return py_time;
}

static int py_srvsvc_NetCharDevInfo1_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "device"),
		.get = py_srvsvc_NetCharDevInfo1_get_device,
		.set = py_srvsvc_NetCharDevInfo1_set_device,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_srvsvc_NetCharDevInfo1_get_status,
		.set = py_srvsvc_NetCharDevInfo1_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user"),
		.get = py_srvsvc_NetCharDevInfo1_get_user,
		.set = py_srvsvc_NetCharDevInfo1_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_srvsvc_NetCharDevInfo1_get_time,
		.set = py_srvsvc_NetCharDevInfo1_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevInfo1, type);
}


static PyTypeObject srvsvc_NetCharDevInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevInfo1",
	.tp_getset = py_srvsvc_NetCharDevInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevInfo1_new,
};


static PyObject *py_srvsvc_NetCharDevCtr1_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetCharDevCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevCtr1_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetCharDevInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetCharDevCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetCharDevInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetCharDevInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetCharDevCtr1_get_count,
		.set = py_srvsvc_NetCharDevCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetCharDevCtr1_get_array,
		.set = py_srvsvc_NetCharDevCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevCtr1, type);
}


static PyTypeObject srvsvc_NetCharDevCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevCtr1",
	.tp_getset = py_srvsvc_NetCharDevCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevCtr1_new,
};

static PyObject *py_import_srvsvc_NetCharDevInfo(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetCharDevInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevInfo0_Type, in->info0, in->info0);
			}
			return ret;

		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevInfo1_Type, in->info1, in->info1);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetCharDevInfo *py_export_srvsvc_NetCharDevInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetCharDevInfo *ret = talloc_zero(mem_ctx, union srvsvc_NetCharDevInfo);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevInfo0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct srvsvc_NetCharDevInfo0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevInfo1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1 = (struct srvsvc_NetCharDevInfo1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetCharDevInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetCharDevInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetCharDevInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetCharDevInfo!");
		return NULL;
	}

	return py_import_srvsvc_NetCharDevInfo(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetCharDevInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetCharDevInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetCharDevInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetCharDevInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetCharDevInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetCharDevInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevInfo",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetCharDevInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevInfo_new,
};

static PyObject *py_import_srvsvc_NetCharDevCtr(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetCharDevCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetCharDevCtr *py_export_srvsvc_NetCharDevCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetCharDevCtr *ret = talloc_zero(mem_ctx, union srvsvc_NetCharDevCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct srvsvc_NetCharDevCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct srvsvc_NetCharDevCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetCharDevCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetCharDevCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetCharDevCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetCharDevCtr!");
		return NULL;
	}

	return py_import_srvsvc_NetCharDevCtr(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetCharDevCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetCharDevCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetCharDevCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetCharDevCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetCharDevCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetCharDevCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevCtr",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetCharDevCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevCtr_new,
};


static PyObject *py_srvsvc_NetCharDevInfoCtr_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_srvsvc_NetCharDevInfoCtr_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevInfoCtr_get_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&srvsvc_NetCharDevCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union srvsvc_NetCharDevCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_srvsvc_NetCharDevInfoCtr_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union srvsvc_NetCharDevCtr *ctr_switch_0;
		ctr_switch_0 = (union srvsvc_NetCharDevCtr *)pyrpc_export_union(&srvsvc_NetCharDevCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union srvsvc_NetCharDevCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_srvsvc_NetCharDevInfoCtr_get_level,
		.set = py_srvsvc_NetCharDevInfoCtr_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_srvsvc_NetCharDevInfoCtr_get_ctr,
		.set = py_srvsvc_NetCharDevInfoCtr_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevCtr")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevInfoCtr, type);
}


static PyTypeObject srvsvc_NetCharDevInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevInfoCtr",
	.tp_getset = py_srvsvc_NetCharDevInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevInfoCtr_new,
};


static PyObject *py_srvsvc_NetCharDevQInfo0_get_device(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_device;
	if (object->device == NULL) {
		Py_RETURN_NONE;
	}
	if (object->device == NULL) {
		py_device = Py_None;
		Py_INCREF(py_device);
	} else {
		if (object->device == NULL) {
			py_device = Py_None;
			Py_INCREF(py_device);
		} else {
			py_device = PyUnicode_Decode(object->device, strlen(object->device), "utf-8", "ignore");
		}
	}
	return py_device;
}

static int py_srvsvc_NetCharDevQInfo0_set_device(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->device");
		return -1;
	}
	if (value == Py_None) {
		object->device = NULL;
	} else {
		object->device = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->device = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevQInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "device"),
		.get = py_srvsvc_NetCharDevQInfo0_get_device,
		.set = py_srvsvc_NetCharDevQInfo0_set_device,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevQInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevQInfo0, type);
}


static PyTypeObject srvsvc_NetCharDevQInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevQInfo0",
	.tp_getset = py_srvsvc_NetCharDevQInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevQInfo0_new,
};


static PyObject *py_srvsvc_NetCharDevQCtr0_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetCharDevQCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQCtr0_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetCharDevQInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetCharDevQCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetCharDevQInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetCharDevQInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevQCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetCharDevQCtr0_get_count,
		.set = py_srvsvc_NetCharDevQCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetCharDevQCtr0_get_array,
		.set = py_srvsvc_NetCharDevQCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevQInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevQCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevQCtr0, type);
}


static PyTypeObject srvsvc_NetCharDevQCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevQCtr0",
	.tp_getset = py_srvsvc_NetCharDevQCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevQCtr0_new,
};


static PyObject *py_srvsvc_NetCharDevQInfo1_get_device(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_device;
	if (object->device == NULL) {
		Py_RETURN_NONE;
	}
	if (object->device == NULL) {
		py_device = Py_None;
		Py_INCREF(py_device);
	} else {
		if (object->device == NULL) {
			py_device = Py_None;
			Py_INCREF(py_device);
		} else {
			py_device = PyUnicode_Decode(object->device, strlen(object->device), "utf-8", "ignore");
		}
	}
	return py_device;
}

static int py_srvsvc_NetCharDevQInfo1_set_device(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->device");
		return -1;
	}
	if (value == Py_None) {
		object->device = NULL;
	} else {
		object->device = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->device = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQInfo1_get_priority(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyLong_FromUnsignedLongLong((uint32_t)(object->priority));
	return py_priority;
}

static int py_srvsvc_NetCharDevQInfo1_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->priority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->priority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->priority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQInfo1_get_devices(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_devices;
	if (object->devices == NULL) {
		Py_RETURN_NONE;
	}
	if (object->devices == NULL) {
		py_devices = Py_None;
		Py_INCREF(py_devices);
	} else {
		if (object->devices == NULL) {
			py_devices = Py_None;
			Py_INCREF(py_devices);
		} else {
			py_devices = PyUnicode_Decode(object->devices, strlen(object->devices), "utf-8", "ignore");
		}
	}
	return py_devices;
}

static int py_srvsvc_NetCharDevQInfo1_set_devices(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->devices");
		return -1;
	}
	if (value == Py_None) {
		object->devices = NULL;
	} else {
		object->devices = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->devices = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQInfo1_get_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_users;
	py_users = PyLong_FromUnsignedLongLong((uint32_t)(object->users));
	return py_users;
}

static int py_srvsvc_NetCharDevQInfo1_set_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQInfo1_get_num_ahead(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_ahead;
	py_num_ahead = PyLong_FromUnsignedLongLong((uint32_t)(object->num_ahead));
	return py_num_ahead;
}

static int py_srvsvc_NetCharDevQInfo1_set_num_ahead(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_ahead");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_ahead));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_ahead = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevQInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "device"),
		.get = py_srvsvc_NetCharDevQInfo1_get_device,
		.set = py_srvsvc_NetCharDevQInfo1_set_device,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "priority"),
		.get = py_srvsvc_NetCharDevQInfo1_get_priority,
		.set = py_srvsvc_NetCharDevQInfo1_set_priority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "devices"),
		.get = py_srvsvc_NetCharDevQInfo1_get_devices,
		.set = py_srvsvc_NetCharDevQInfo1_set_devices,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "users"),
		.get = py_srvsvc_NetCharDevQInfo1_get_users,
		.set = py_srvsvc_NetCharDevQInfo1_set_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_ahead"),
		.get = py_srvsvc_NetCharDevQInfo1_get_num_ahead,
		.set = py_srvsvc_NetCharDevQInfo1_set_num_ahead,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevQInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevQInfo1, type);
}


static PyTypeObject srvsvc_NetCharDevQInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevQInfo1",
	.tp_getset = py_srvsvc_NetCharDevQInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevQInfo1_new,
};


static PyObject *py_srvsvc_NetCharDevQCtr1_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetCharDevQCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQCtr1_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetCharDevQInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetCharDevQCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetCharDevQInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetCharDevQInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevQCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetCharDevQCtr1_get_count,
		.set = py_srvsvc_NetCharDevQCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetCharDevQCtr1_get_array,
		.set = py_srvsvc_NetCharDevQCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevQInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevQCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevQCtr1, type);
}


static PyTypeObject srvsvc_NetCharDevQCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevQCtr1",
	.tp_getset = py_srvsvc_NetCharDevQCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevQCtr1_new,
};

static PyObject *py_import_srvsvc_NetCharDevQInfo(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetCharDevQInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevQInfo0_Type, in->info0, in->info0);
			}
			return ret;

		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevQInfo1_Type, in->info1, in->info1);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetCharDevQInfo *py_export_srvsvc_NetCharDevQInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetCharDevQInfo *ret = talloc_zero(mem_ctx, union srvsvc_NetCharDevQInfo);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevQInfo0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct srvsvc_NetCharDevQInfo0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevQInfo1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1 = (struct srvsvc_NetCharDevQInfo1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetCharDevQInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetCharDevQInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetCharDevQInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetCharDevQInfo!");
		return NULL;
	}

	return py_import_srvsvc_NetCharDevQInfo(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetCharDevQInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetCharDevQInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetCharDevQInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetCharDevQInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevQInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevQInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetCharDevQInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetCharDevQInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevQInfo",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetCharDevQInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevQInfo_new,
};

static PyObject *py_import_srvsvc_NetCharDevQCtr(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetCharDevQCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevQCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetCharDevQCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetCharDevQCtr *py_export_srvsvc_NetCharDevQCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetCharDevQCtr *ret = talloc_zero(mem_ctx, union srvsvc_NetCharDevQCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevQCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct srvsvc_NetCharDevQCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetCharDevQCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct srvsvc_NetCharDevQCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetCharDevQCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetCharDevQCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetCharDevQCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetCharDevQCtr!");
		return NULL;
	}

	return py_import_srvsvc_NetCharDevQCtr(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetCharDevQCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetCharDevQCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetCharDevQCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetCharDevQCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevQCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevQCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetCharDevQCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetCharDevQCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevQCtr",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetCharDevQCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevQCtr_new,
};


static PyObject *py_srvsvc_NetCharDevQInfoCtr_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_srvsvc_NetCharDevQInfoCtr_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQInfoCtr_get_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&srvsvc_NetCharDevQCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union srvsvc_NetCharDevQCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_srvsvc_NetCharDevQInfoCtr_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union srvsvc_NetCharDevQCtr *ctr_switch_0;
		ctr_switch_0 = (union srvsvc_NetCharDevQCtr *)pyrpc_export_union(&srvsvc_NetCharDevQCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union srvsvc_NetCharDevQCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevQInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_srvsvc_NetCharDevQInfoCtr_get_level,
		.set = py_srvsvc_NetCharDevQInfoCtr_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_srvsvc_NetCharDevQInfoCtr_get_ctr,
		.set = py_srvsvc_NetCharDevQInfoCtr_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevQCtr")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevQInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetCharDevQInfoCtr, type);
}


static PyTypeObject srvsvc_NetCharDevQInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevQInfoCtr",
	.tp_getset = py_srvsvc_NetCharDevQInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevQInfoCtr_new,
};


static PyObject *py_srvsvc_NetConnInfo0_get_conn_id(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_conn_id;
	py_conn_id = PyLong_FromUnsignedLongLong((uint32_t)(object->conn_id));
	return py_conn_id;
}

static int py_srvsvc_NetConnInfo0_set_conn_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->conn_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->conn_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->conn_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetConnInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "conn_id"),
		.get = py_srvsvc_NetConnInfo0_get_conn_id,
		.set = py_srvsvc_NetConnInfo0_set_conn_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetConnInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetConnInfo0, type);
}


static PyTypeObject srvsvc_NetConnInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetConnInfo0",
	.tp_getset = py_srvsvc_NetConnInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetConnInfo0_new,
};


static PyObject *py_srvsvc_NetConnCtr0_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetConnCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnCtr0_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetConnInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetConnCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetConnInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetConnInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetConnCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetConnCtr0_get_count,
		.set = py_srvsvc_NetConnCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetConnCtr0_get_array,
		.set = py_srvsvc_NetConnCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetConnInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetConnCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetConnCtr0, type);
}


static PyTypeObject srvsvc_NetConnCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetConnCtr0",
	.tp_getset = py_srvsvc_NetConnCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetConnCtr0_new,
};


static PyObject *py_srvsvc_NetConnInfo1_get_conn_id(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_conn_id;
	py_conn_id = PyLong_FromUnsignedLongLong((uint32_t)(object->conn_id));
	return py_conn_id;
}

static int py_srvsvc_NetConnInfo1_set_conn_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->conn_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->conn_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->conn_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnInfo1_get_conn_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_conn_type;
	py_conn_type = PyLong_FromUnsignedLongLong((uint32_t)(object->conn_type));
	return py_conn_type;
}

static int py_srvsvc_NetConnInfo1_set_conn_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->conn_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->conn_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->conn_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnInfo1_get_num_open(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_open;
	py_num_open = PyLong_FromUnsignedLongLong((uint32_t)(object->num_open));
	return py_num_open;
}

static int py_srvsvc_NetConnInfo1_set_num_open(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_open");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_open));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_open = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnInfo1_get_num_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_users;
	py_num_users = PyLong_FromUnsignedLongLong((uint32_t)(object->num_users));
	return py_num_users;
}

static int py_srvsvc_NetConnInfo1_set_num_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnInfo1_get_conn_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_conn_time;
	py_conn_time = PyLong_FromUnsignedLongLong((uint32_t)(object->conn_time));
	return py_conn_time;
}

static int py_srvsvc_NetConnInfo1_set_conn_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->conn_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->conn_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->conn_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnInfo1_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->user, strlen(object->user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetConnInfo1_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user");
		return -1;
	}
	if (value == Py_None) {
		object->user = NULL;
	} else {
		object->user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnInfo1_get_share(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_share;
	if (object->share == NULL) {
		Py_RETURN_NONE;
	}
	if (object->share == NULL) {
		py_share = Py_None;
		Py_INCREF(py_share);
	} else {
		if (object->share == NULL) {
			py_share = Py_None;
			Py_INCREF(py_share);
		} else {
			py_share = PyUnicode_Decode(object->share, strlen(object->share), "utf-8", "ignore");
		}
	}
	return py_share;
}

static int py_srvsvc_NetConnInfo1_set_share(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->share");
		return -1;
	}
	if (value == Py_None) {
		object->share = NULL;
	} else {
		object->share = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->share = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetConnInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "conn_id"),
		.get = py_srvsvc_NetConnInfo1_get_conn_id,
		.set = py_srvsvc_NetConnInfo1_set_conn_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "conn_type"),
		.get = py_srvsvc_NetConnInfo1_get_conn_type,
		.set = py_srvsvc_NetConnInfo1_set_conn_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_open"),
		.get = py_srvsvc_NetConnInfo1_get_num_open,
		.set = py_srvsvc_NetConnInfo1_set_num_open,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_users"),
		.get = py_srvsvc_NetConnInfo1_get_num_users,
		.set = py_srvsvc_NetConnInfo1_set_num_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "conn_time"),
		.get = py_srvsvc_NetConnInfo1_get_conn_time,
		.set = py_srvsvc_NetConnInfo1_set_conn_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user"),
		.get = py_srvsvc_NetConnInfo1_get_user,
		.set = py_srvsvc_NetConnInfo1_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "share"),
		.get = py_srvsvc_NetConnInfo1_get_share,
		.set = py_srvsvc_NetConnInfo1_set_share,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetConnInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetConnInfo1, type);
}


static PyTypeObject srvsvc_NetConnInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetConnInfo1",
	.tp_getset = py_srvsvc_NetConnInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetConnInfo1_new,
};


static PyObject *py_srvsvc_NetConnCtr1_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetConnCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnCtr1_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetConnInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetConnCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetConnInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetConnInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetConnCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetConnCtr1_get_count,
		.set = py_srvsvc_NetConnCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetConnCtr1_get_array,
		.set = py_srvsvc_NetConnCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetConnInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetConnCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetConnCtr1, type);
}


static PyTypeObject srvsvc_NetConnCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetConnCtr1",
	.tp_getset = py_srvsvc_NetConnCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetConnCtr1_new,
};

static PyObject *py_import_srvsvc_NetConnCtr(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetConnCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetConnCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetConnCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetConnCtr *py_export_srvsvc_NetConnCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetConnCtr *ret = talloc_zero(mem_ctx, union srvsvc_NetConnCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetConnCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct srvsvc_NetConnCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetConnCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct srvsvc_NetConnCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetConnCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetConnCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetConnCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetConnCtr!");
		return NULL;
	}

	return py_import_srvsvc_NetConnCtr(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetConnCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetConnCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetConnCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetConnCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetConnCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetConnCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetConnCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetConnCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetConnCtr",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetConnCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetConnCtr_new,
};


static PyObject *py_srvsvc_NetConnInfoCtr_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_srvsvc_NetConnInfoCtr_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetConnInfoCtr_get_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetConnInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&srvsvc_NetConnCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union srvsvc_NetConnCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_srvsvc_NetConnInfoCtr_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetConnInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union srvsvc_NetConnCtr *ctr_switch_0;
		ctr_switch_0 = (union srvsvc_NetConnCtr *)pyrpc_export_union(&srvsvc_NetConnCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union srvsvc_NetConnCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetConnInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_srvsvc_NetConnInfoCtr_get_level,
		.set = py_srvsvc_NetConnInfoCtr_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_srvsvc_NetConnInfoCtr_get_ctr,
		.set = py_srvsvc_NetConnInfoCtr_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetConnCtr")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetConnInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetConnInfoCtr, type);
}


static PyTypeObject srvsvc_NetConnInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetConnInfoCtr",
	.tp_getset = py_srvsvc_NetConnInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetConnInfoCtr_new,
};


static PyObject *py_srvsvc_NetFileInfo2_get_fid(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_fid;
	py_fid = PyLong_FromUnsignedLongLong((uint32_t)(object->fid));
	return py_fid;
}

static int py_srvsvc_NetFileInfo2_set_fid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetFileInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "fid"),
		.get = py_srvsvc_NetFileInfo2_get_fid,
		.set = py_srvsvc_NetFileInfo2_set_fid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetFileInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetFileInfo2, type);
}


static PyTypeObject srvsvc_NetFileInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetFileInfo2",
	.tp_getset = py_srvsvc_NetFileInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetFileInfo2_new,
};


static PyObject *py_srvsvc_NetFileCtr2_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetFileCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetFileCtr2_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetFileInfo2_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetFileCtr2_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetFileInfo2_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetFileInfo2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetFileCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetFileCtr2_get_count,
		.set = py_srvsvc_NetFileCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetFileCtr2_get_array,
		.set = py_srvsvc_NetFileCtr2_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetFileInfo2")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetFileCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetFileCtr2, type);
}


static PyTypeObject srvsvc_NetFileCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetFileCtr2",
	.tp_getset = py_srvsvc_NetFileCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetFileCtr2_new,
};


static PyObject *py_srvsvc_NetFileInfo3_get_fid(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_fid;
	py_fid = PyLong_FromUnsignedLongLong((uint32_t)(object->fid));
	return py_fid;
}

static int py_srvsvc_NetFileInfo3_set_fid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetFileInfo3_get_permissions(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_permissions;
	py_permissions = PyLong_FromUnsignedLongLong((uint32_t)(object->permissions));
	return py_permissions;
}

static int py_srvsvc_NetFileInfo3_set_permissions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->permissions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->permissions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->permissions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetFileInfo3_get_num_locks(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_locks;
	py_num_locks = PyLong_FromUnsignedLongLong((uint32_t)(object->num_locks));
	return py_num_locks;
}

static int py_srvsvc_NetFileInfo3_set_num_locks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_locks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_locks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_locks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetFileInfo3_get_path(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_path;
	if (object->path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->path == NULL) {
		py_path = Py_None;
		Py_INCREF(py_path);
	} else {
		if (object->path == NULL) {
			py_path = Py_None;
			Py_INCREF(py_path);
		} else {
			py_path = PyUnicode_Decode(object->path, strlen(object->path), "utf-8", "ignore");
		}
	}
	return py_path;
}

static int py_srvsvc_NetFileInfo3_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->path");
		return -1;
	}
	if (value == Py_None) {
		object->path = NULL;
	} else {
		object->path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetFileInfo3_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->user, strlen(object->user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetFileInfo3_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user");
		return -1;
	}
	if (value == Py_None) {
		object->user = NULL;
	} else {
		object->user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetFileInfo3_getsetters[] = {
	{
		.name = discard_const_p(char, "fid"),
		.get = py_srvsvc_NetFileInfo3_get_fid,
		.set = py_srvsvc_NetFileInfo3_set_fid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "permissions"),
		.get = py_srvsvc_NetFileInfo3_get_permissions,
		.set = py_srvsvc_NetFileInfo3_set_permissions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_locks"),
		.get = py_srvsvc_NetFileInfo3_get_num_locks,
		.set = py_srvsvc_NetFileInfo3_set_num_locks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "path"),
		.get = py_srvsvc_NetFileInfo3_get_path,
		.set = py_srvsvc_NetFileInfo3_set_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "user"),
		.get = py_srvsvc_NetFileInfo3_get_user,
		.set = py_srvsvc_NetFileInfo3_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetFileInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetFileInfo3, type);
}


static PyTypeObject srvsvc_NetFileInfo3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetFileInfo3",
	.tp_getset = py_srvsvc_NetFileInfo3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetFileInfo3_new,
};


static PyObject *py_srvsvc_NetFileCtr3_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetFileCtr3_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetFileCtr3_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetFileInfo3_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetFileCtr3_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileCtr3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetFileInfo3_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetFileInfo3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetFileCtr3_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetFileCtr3_get_count,
		.set = py_srvsvc_NetFileCtr3_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetFileCtr3_get_array,
		.set = py_srvsvc_NetFileCtr3_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetFileInfo3")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetFileCtr3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetFileCtr3, type);
}


static PyTypeObject srvsvc_NetFileCtr3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetFileCtr3",
	.tp_getset = py_srvsvc_NetFileCtr3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetFileCtr3_new,
};

static PyObject *py_import_srvsvc_NetFileInfo(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetFileInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 2:
			if (in->info2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetFileInfo2_Type, in->info2, in->info2);
			}
			return ret;

		case 3:
			if (in->info3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetFileInfo3_Type, in->info3, in->info3);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetFileInfo *py_export_srvsvc_NetFileInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetFileInfo *ret = talloc_zero(mem_ctx, union srvsvc_NetFileInfo);
	switch (level) {
		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info2 = NULL;
			} else {
				ret->info2 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetFileInfo2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info2 = (struct srvsvc_NetFileInfo2 *)pytalloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info3");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info3 = NULL;
			} else {
				ret->info3 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetFileInfo3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info3 = (struct srvsvc_NetFileInfo3 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetFileInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetFileInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetFileInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetFileInfo!");
		return NULL;
	}

	return py_import_srvsvc_NetFileInfo(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetFileInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetFileInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetFileInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetFileInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetFileInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetFileInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetFileInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetFileInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetFileInfo",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetFileInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetFileInfo_new,
};

static PyObject *py_import_srvsvc_NetFileCtr(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetFileCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 2:
			if (in->ctr2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetFileCtr2_Type, in->ctr2, in->ctr2);
			}
			return ret;

		case 3:
			if (in->ctr3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetFileCtr3_Type, in->ctr3, in->ctr3);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetFileCtr *py_export_srvsvc_NetFileCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetFileCtr *ret = talloc_zero(mem_ctx, union srvsvc_NetFileCtr);
	switch (level) {
		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr2 = NULL;
			} else {
				ret->ctr2 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetFileCtr2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr2 = (struct srvsvc_NetFileCtr2 *)pytalloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr3");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr3 = NULL;
			} else {
				ret->ctr3 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetFileCtr3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr3 = (struct srvsvc_NetFileCtr3 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetFileCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetFileCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetFileCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetFileCtr!");
		return NULL;
	}

	return py_import_srvsvc_NetFileCtr(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetFileCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetFileCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetFileCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetFileCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetFileCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetFileCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetFileCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetFileCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetFileCtr",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetFileCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetFileCtr_new,
};


static PyObject *py_srvsvc_NetFileInfoCtr_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_srvsvc_NetFileInfoCtr_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetFileInfoCtr_get_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetFileInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&srvsvc_NetFileCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union srvsvc_NetFileCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_srvsvc_NetFileInfoCtr_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetFileInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union srvsvc_NetFileCtr *ctr_switch_0;
		ctr_switch_0 = (union srvsvc_NetFileCtr *)pyrpc_export_union(&srvsvc_NetFileCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union srvsvc_NetFileCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetFileInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_srvsvc_NetFileInfoCtr_get_level,
		.set = py_srvsvc_NetFileInfoCtr_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_srvsvc_NetFileInfoCtr_get_ctr,
		.set = py_srvsvc_NetFileInfoCtr_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetFileCtr")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetFileInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetFileInfoCtr, type);
}


static PyTypeObject srvsvc_NetFileInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetFileInfoCtr",
	.tp_getset = py_srvsvc_NetFileInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetFileInfoCtr_new,
};


static PyObject *py_srvsvc_NetSessInfo0_get_client(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	if (object->client == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client == NULL) {
		py_client = Py_None;
		Py_INCREF(py_client);
	} else {
		if (object->client == NULL) {
			py_client = Py_None;
			Py_INCREF(py_client);
		} else {
			py_client = PyUnicode_Decode(object->client, strlen(object->client), "utf-8", "ignore");
		}
	}
	return py_client;
}

static int py_srvsvc_NetSessInfo0_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client");
		return -1;
	}
	if (value == Py_None) {
		object->client = NULL;
	} else {
		object->client = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "client"),
		.get = py_srvsvc_NetSessInfo0_get_client,
		.set = py_srvsvc_NetSessInfo0_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessInfo0, type);
}


static PyTypeObject srvsvc_NetSessInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessInfo0",
	.tp_getset = py_srvsvc_NetSessInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessInfo0_new,
};


static PyObject *py_srvsvc_NetSessCtr0_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetSessCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessCtr0_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetSessInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetSessCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetSessInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetSessInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetSessCtr0_get_count,
		.set = py_srvsvc_NetSessCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetSessCtr0_get_array,
		.set = py_srvsvc_NetSessCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetSessInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessCtr0, type);
}


static PyTypeObject srvsvc_NetSessCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessCtr0",
	.tp_getset = py_srvsvc_NetSessCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessCtr0_new,
};


static PyObject *py_srvsvc_NetSessInfo1_get_client(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	if (object->client == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client == NULL) {
		py_client = Py_None;
		Py_INCREF(py_client);
	} else {
		if (object->client == NULL) {
			py_client = Py_None;
			Py_INCREF(py_client);
		} else {
			py_client = PyUnicode_Decode(object->client, strlen(object->client), "utf-8", "ignore");
		}
	}
	return py_client;
}

static int py_srvsvc_NetSessInfo1_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client");
		return -1;
	}
	if (value == Py_None) {
		object->client = NULL;
	} else {
		object->client = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo1_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->user, strlen(object->user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetSessInfo1_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user");
		return -1;
	}
	if (value == Py_None) {
		object->user = NULL;
	} else {
		object->user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo1_get_num_open(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_open;
	py_num_open = PyLong_FromUnsignedLongLong((uint32_t)(object->num_open));
	return py_num_open;
}

static int py_srvsvc_NetSessInfo1_set_num_open(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_open");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_open));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_open = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo1_get_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong((uint32_t)(object->time));
	return py_time;
}

static int py_srvsvc_NetSessInfo1_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo1_get_idle_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong((uint32_t)(object->idle_time));
	return py_idle_time;
}

static int py_srvsvc_NetSessInfo1_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo1_get_user_flags(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_user_flags;
	py_user_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->user_flags));
	return py_user_flags;
}

static int py_srvsvc_NetSessInfo1_set_user_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "client"),
		.get = py_srvsvc_NetSessInfo1_get_client,
		.set = py_srvsvc_NetSessInfo1_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "user"),
		.get = py_srvsvc_NetSessInfo1_get_user,
		.set = py_srvsvc_NetSessInfo1_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_open"),
		.get = py_srvsvc_NetSessInfo1_get_num_open,
		.set = py_srvsvc_NetSessInfo1_set_num_open,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_srvsvc_NetSessInfo1_get_time,
		.set = py_srvsvc_NetSessInfo1_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_srvsvc_NetSessInfo1_get_idle_time,
		.set = py_srvsvc_NetSessInfo1_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user_flags"),
		.get = py_srvsvc_NetSessInfo1_get_user_flags,
		.set = py_srvsvc_NetSessInfo1_set_user_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessInfo1, type);
}


static PyTypeObject srvsvc_NetSessInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessInfo1",
	.tp_getset = py_srvsvc_NetSessInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessInfo1_new,
};


static PyObject *py_srvsvc_NetSessCtr1_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetSessCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessCtr1_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetSessInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetSessCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetSessInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetSessInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetSessCtr1_get_count,
		.set = py_srvsvc_NetSessCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetSessCtr1_get_array,
		.set = py_srvsvc_NetSessCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetSessInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessCtr1, type);
}


static PyTypeObject srvsvc_NetSessCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessCtr1",
	.tp_getset = py_srvsvc_NetSessCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessCtr1_new,
};


static PyObject *py_srvsvc_NetSessInfo2_get_client(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	if (object->client == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client == NULL) {
		py_client = Py_None;
		Py_INCREF(py_client);
	} else {
		if (object->client == NULL) {
			py_client = Py_None;
			Py_INCREF(py_client);
		} else {
			py_client = PyUnicode_Decode(object->client, strlen(object->client), "utf-8", "ignore");
		}
	}
	return py_client;
}

static int py_srvsvc_NetSessInfo2_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client");
		return -1;
	}
	if (value == Py_None) {
		object->client = NULL;
	} else {
		object->client = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo2_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->user, strlen(object->user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetSessInfo2_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user");
		return -1;
	}
	if (value == Py_None) {
		object->user = NULL;
	} else {
		object->user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo2_get_num_open(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_open;
	py_num_open = PyLong_FromUnsignedLongLong((uint32_t)(object->num_open));
	return py_num_open;
}

static int py_srvsvc_NetSessInfo2_set_num_open(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_open");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_open));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_open = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo2_get_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong((uint32_t)(object->time));
	return py_time;
}

static int py_srvsvc_NetSessInfo2_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo2_get_idle_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong((uint32_t)(object->idle_time));
	return py_idle_time;
}

static int py_srvsvc_NetSessInfo2_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo2_get_user_flags(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_user_flags;
	py_user_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->user_flags));
	return py_user_flags;
}

static int py_srvsvc_NetSessInfo2_set_user_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo2_get_client_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_type;
	if (object->client_type == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client_type == NULL) {
		py_client_type = Py_None;
		Py_INCREF(py_client_type);
	} else {
		if (object->client_type == NULL) {
			py_client_type = Py_None;
			Py_INCREF(py_client_type);
		} else {
			py_client_type = PyUnicode_Decode(object->client_type, strlen(object->client_type), "utf-8", "ignore");
		}
	}
	return py_client_type;
}

static int py_srvsvc_NetSessInfo2_set_client_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_type");
		return -1;
	}
	if (value == Py_None) {
		object->client_type = NULL;
	} else {
		object->client_type = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client_type = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "client"),
		.get = py_srvsvc_NetSessInfo2_get_client,
		.set = py_srvsvc_NetSessInfo2_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "user"),
		.get = py_srvsvc_NetSessInfo2_get_user,
		.set = py_srvsvc_NetSessInfo2_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_open"),
		.get = py_srvsvc_NetSessInfo2_get_num_open,
		.set = py_srvsvc_NetSessInfo2_set_num_open,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_srvsvc_NetSessInfo2_get_time,
		.set = py_srvsvc_NetSessInfo2_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_srvsvc_NetSessInfo2_get_idle_time,
		.set = py_srvsvc_NetSessInfo2_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user_flags"),
		.get = py_srvsvc_NetSessInfo2_get_user_flags,
		.set = py_srvsvc_NetSessInfo2_set_user_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "client_type"),
		.get = py_srvsvc_NetSessInfo2_get_client_type,
		.set = py_srvsvc_NetSessInfo2_set_client_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessInfo2, type);
}


static PyTypeObject srvsvc_NetSessInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessInfo2",
	.tp_getset = py_srvsvc_NetSessInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessInfo2_new,
};


static PyObject *py_srvsvc_NetSessCtr2_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetSessCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessCtr2_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetSessInfo2_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetSessCtr2_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetSessInfo2_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetSessInfo2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetSessCtr2_get_count,
		.set = py_srvsvc_NetSessCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetSessCtr2_get_array,
		.set = py_srvsvc_NetSessCtr2_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetSessInfo2")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessCtr2, type);
}


static PyTypeObject srvsvc_NetSessCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessCtr2",
	.tp_getset = py_srvsvc_NetSessCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessCtr2_new,
};


static PyObject *py_srvsvc_NetSessInfo10_get_client(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	if (object->client == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client == NULL) {
		py_client = Py_None;
		Py_INCREF(py_client);
	} else {
		if (object->client == NULL) {
			py_client = Py_None;
			Py_INCREF(py_client);
		} else {
			py_client = PyUnicode_Decode(object->client, strlen(object->client), "utf-8", "ignore");
		}
	}
	return py_client;
}

static int py_srvsvc_NetSessInfo10_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client");
		return -1;
	}
	if (value == Py_None) {
		object->client = NULL;
	} else {
		object->client = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo10_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->user, strlen(object->user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetSessInfo10_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user");
		return -1;
	}
	if (value == Py_None) {
		object->user = NULL;
	} else {
		object->user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo10_get_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong((uint32_t)(object->time));
	return py_time;
}

static int py_srvsvc_NetSessInfo10_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo10_get_idle_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong((uint32_t)(object->idle_time));
	return py_idle_time;
}

static int py_srvsvc_NetSessInfo10_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessInfo10_getsetters[] = {
	{
		.name = discard_const_p(char, "client"),
		.get = py_srvsvc_NetSessInfo10_get_client,
		.set = py_srvsvc_NetSessInfo10_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "user"),
		.get = py_srvsvc_NetSessInfo10_get_user,
		.set = py_srvsvc_NetSessInfo10_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_srvsvc_NetSessInfo10_get_time,
		.set = py_srvsvc_NetSessInfo10_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_srvsvc_NetSessInfo10_get_idle_time,
		.set = py_srvsvc_NetSessInfo10_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessInfo10_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessInfo10, type);
}


static PyTypeObject srvsvc_NetSessInfo10_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessInfo10",
	.tp_getset = py_srvsvc_NetSessInfo10_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessInfo10_new,
};


static PyObject *py_srvsvc_NetSessCtr10_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr10 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetSessCtr10_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessCtr10_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr10 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetSessInfo10_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetSessCtr10_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr10 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetSessInfo10_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetSessInfo10 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessCtr10_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetSessCtr10_get_count,
		.set = py_srvsvc_NetSessCtr10_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetSessCtr10_get_array,
		.set = py_srvsvc_NetSessCtr10_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetSessInfo10")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessCtr10_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessCtr10, type);
}


static PyTypeObject srvsvc_NetSessCtr10_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessCtr10",
	.tp_getset = py_srvsvc_NetSessCtr10_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessCtr10_new,
};


static PyObject *py_srvsvc_NetSessInfo502_get_client(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	if (object->client == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client == NULL) {
		py_client = Py_None;
		Py_INCREF(py_client);
	} else {
		if (object->client == NULL) {
			py_client = Py_None;
			Py_INCREF(py_client);
		} else {
			py_client = PyUnicode_Decode(object->client, strlen(object->client), "utf-8", "ignore");
		}
	}
	return py_client;
}

static int py_srvsvc_NetSessInfo502_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client");
		return -1;
	}
	if (value == Py_None) {
		object->client = NULL;
	} else {
		object->client = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo502_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->user, strlen(object->user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetSessInfo502_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user");
		return -1;
	}
	if (value == Py_None) {
		object->user = NULL;
	} else {
		object->user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo502_get_num_open(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_num_open;
	py_num_open = PyLong_FromUnsignedLongLong((uint32_t)(object->num_open));
	return py_num_open;
}

static int py_srvsvc_NetSessInfo502_set_num_open(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_open");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_open));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_open = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo502_get_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong((uint32_t)(object->time));
	return py_time;
}

static int py_srvsvc_NetSessInfo502_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo502_get_idle_time(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_idle_time;
	py_idle_time = PyLong_FromUnsignedLongLong((uint32_t)(object->idle_time));
	return py_idle_time;
}

static int py_srvsvc_NetSessInfo502_set_idle_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idle_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idle_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idle_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo502_get_user_flags(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_user_flags;
	py_user_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->user_flags));
	return py_user_flags;
}

static int py_srvsvc_NetSessInfo502_set_user_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo502_get_client_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_type;
	if (object->client_type == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client_type == NULL) {
		py_client_type = Py_None;
		Py_INCREF(py_client_type);
	} else {
		if (object->client_type == NULL) {
			py_client_type = Py_None;
			Py_INCREF(py_client_type);
		} else {
			py_client_type = PyUnicode_Decode(object->client_type, strlen(object->client_type), "utf-8", "ignore");
		}
	}
	return py_client_type;
}

static int py_srvsvc_NetSessInfo502_set_client_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_type");
		return -1;
	}
	if (value == Py_None) {
		object->client_type = NULL;
	} else {
		object->client_type = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client_type = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfo502_get_transport(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_transport;
	if (object->transport == NULL) {
		Py_RETURN_NONE;
	}
	if (object->transport == NULL) {
		py_transport = Py_None;
		Py_INCREF(py_transport);
	} else {
		if (object->transport == NULL) {
			py_transport = Py_None;
			Py_INCREF(py_transport);
		} else {
			py_transport = PyUnicode_Decode(object->transport, strlen(object->transport), "utf-8", "ignore");
		}
	}
	return py_transport;
}

static int py_srvsvc_NetSessInfo502_set_transport(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transport");
		return -1;
	}
	if (value == Py_None) {
		object->transport = NULL;
	} else {
		object->transport = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->transport = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessInfo502_getsetters[] = {
	{
		.name = discard_const_p(char, "client"),
		.get = py_srvsvc_NetSessInfo502_get_client,
		.set = py_srvsvc_NetSessInfo502_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "user"),
		.get = py_srvsvc_NetSessInfo502_get_user,
		.set = py_srvsvc_NetSessInfo502_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_open"),
		.get = py_srvsvc_NetSessInfo502_get_num_open,
		.set = py_srvsvc_NetSessInfo502_set_num_open,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_srvsvc_NetSessInfo502_get_time,
		.set = py_srvsvc_NetSessInfo502_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "idle_time"),
		.get = py_srvsvc_NetSessInfo502_get_idle_time,
		.set = py_srvsvc_NetSessInfo502_set_idle_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user_flags"),
		.get = py_srvsvc_NetSessInfo502_get_user_flags,
		.set = py_srvsvc_NetSessInfo502_set_user_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "client_type"),
		.get = py_srvsvc_NetSessInfo502_get_client_type,
		.set = py_srvsvc_NetSessInfo502_set_client_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "transport"),
		.get = py_srvsvc_NetSessInfo502_get_transport,
		.set = py_srvsvc_NetSessInfo502_set_transport,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessInfo502_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessInfo502, type);
}


static PyTypeObject srvsvc_NetSessInfo502_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessInfo502",
	.tp_getset = py_srvsvc_NetSessInfo502_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessInfo502_new,
};


static PyObject *py_srvsvc_NetSessCtr502_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr502 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetSessCtr502_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessCtr502_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessCtr502 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetSessInfo502_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetSessCtr502_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessCtr502 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetSessInfo502_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetSessInfo502 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessCtr502_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetSessCtr502_get_count,
		.set = py_srvsvc_NetSessCtr502_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetSessCtr502_get_array,
		.set = py_srvsvc_NetSessCtr502_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetSessInfo502")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessCtr502_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessCtr502, type);
}


static PyTypeObject srvsvc_NetSessCtr502_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessCtr502",
	.tp_getset = py_srvsvc_NetSessCtr502_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessCtr502_new,
};

static PyObject *py_import_srvsvc_NetSessCtr(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetSessCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSessCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSessCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

		case 2:
			if (in->ctr2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSessCtr2_Type, in->ctr2, in->ctr2);
			}
			return ret;

		case 10:
			if (in->ctr10 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSessCtr10_Type, in->ctr10, in->ctr10);
			}
			return ret;

		case 502:
			if (in->ctr502 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSessCtr502_Type, in->ctr502, in->ctr502);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetSessCtr *py_export_srvsvc_NetSessCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetSessCtr *ret = talloc_zero(mem_ctx, union srvsvc_NetSessCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSessCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct srvsvc_NetSessCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSessCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct srvsvc_NetSessCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr2 = NULL;
			} else {
				ret->ctr2 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSessCtr2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr2 = (struct srvsvc_NetSessCtr2 *)pytalloc_get_ptr(in);
			}
			break;

		case 10:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr10");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr10 = NULL;
			} else {
				ret->ctr10 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSessCtr10_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr10 = (struct srvsvc_NetSessCtr10 *)pytalloc_get_ptr(in);
			}
			break;

		case 502:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr502");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr502 = NULL;
			} else {
				ret->ctr502 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSessCtr502_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr502 = (struct srvsvc_NetSessCtr502 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetSessCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetSessCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetSessCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetSessCtr!");
		return NULL;
	}

	return py_import_srvsvc_NetSessCtr(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetSessCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetSessCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetSessCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetSessCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSessCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSessCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetSessCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetSessCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessCtr",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetSessCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessCtr_new,
};


static PyObject *py_srvsvc_NetSessInfoCtr_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_srvsvc_NetSessInfoCtr_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSessInfoCtr_get_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetSessInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&srvsvc_NetSessCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union srvsvc_NetSessCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_srvsvc_NetSessInfoCtr_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSessInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union srvsvc_NetSessCtr *ctr_switch_0;
		ctr_switch_0 = (union srvsvc_NetSessCtr *)pyrpc_export_union(&srvsvc_NetSessCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union srvsvc_NetSessCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSessInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_srvsvc_NetSessInfoCtr_get_level,
		.set = py_srvsvc_NetSessInfoCtr_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_srvsvc_NetSessInfoCtr_get_ctr,
		.set = py_srvsvc_NetSessInfoCtr_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetSessCtr")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSessInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSessInfoCtr, type);
}


static PyTypeObject srvsvc_NetSessInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSessInfoCtr",
	.tp_getset = py_srvsvc_NetSessInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSessInfoCtr_new,
};


static PyObject *py_srvsvc_NetShareInfo0_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetShareInfo0_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetShareInfo0_get_name,
		.set = py_srvsvc_NetShareInfo0_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo0, type);
}


static PyTypeObject srvsvc_NetShareInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo0",
	.tp_getset = py_srvsvc_NetShareInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo0_new,
};


static PyObject *py_srvsvc_NetShareCtr0_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr0_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr0_get_count,
		.set = py_srvsvc_NetShareCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr0_get_array,
		.set = py_srvsvc_NetShareCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr0, type);
}


static PyTypeObject srvsvc_NetShareCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr0",
	.tp_getset = py_srvsvc_NetShareCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr0_new,
};


static PyObject *py_srvsvc_NetShareInfo1_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetShareInfo1_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo1_get_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_srvsvc_NetShareInfo1_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo1_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetShareInfo1_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetShareInfo1_get_name,
		.set = py_srvsvc_NetShareInfo1_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_srvsvc_NetShareInfo1_get_type,
		.set = py_srvsvc_NetShareInfo1_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_ShareType")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetShareInfo1_get_comment,
		.set = py_srvsvc_NetShareInfo1_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo1, type);
}


static PyTypeObject srvsvc_NetShareInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo1",
	.tp_getset = py_srvsvc_NetShareInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo1_new,
};


static PyObject *py_srvsvc_NetShareCtr1_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr1_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr1_get_count,
		.set = py_srvsvc_NetShareCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr1_get_array,
		.set = py_srvsvc_NetShareCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr1, type);
}


static PyTypeObject srvsvc_NetShareCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr1",
	.tp_getset = py_srvsvc_NetShareCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr1_new,
};


static PyObject *py_srvsvc_NetShareInfo2_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetShareInfo2_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo2_get_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_srvsvc_NetShareInfo2_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo2_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetShareInfo2_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo2_get_permissions(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_permissions;
	py_permissions = PyLong_FromUnsignedLongLong((uint32_t)(object->permissions));
	return py_permissions;
}

static int py_srvsvc_NetShareInfo2_set_permissions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->permissions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->permissions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->permissions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo2_get_max_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_users;
	py_max_users = PyLong_FromUnsignedLongLong((uint32_t)(object->max_users));
	return py_max_users;
}

static int py_srvsvc_NetShareInfo2_set_max_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo2_get_current_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_current_users;
	py_current_users = PyLong_FromUnsignedLongLong((uint32_t)(object->current_users));
	return py_current_users;
}

static int py_srvsvc_NetShareInfo2_set_current_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->current_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->current_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->current_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo2_get_path(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_path;
	if (object->path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->path == NULL) {
		py_path = Py_None;
		Py_INCREF(py_path);
	} else {
		if (object->path == NULL) {
			py_path = Py_None;
			Py_INCREF(py_path);
		} else {
			py_path = PyUnicode_Decode(object->path, strlen(object->path), "utf-8", "ignore");
		}
	}
	return py_path;
}

static int py_srvsvc_NetShareInfo2_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->path");
		return -1;
	}
	if (value == Py_None) {
		object->path = NULL;
	} else {
		object->path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo2_get_password(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->password, strlen(object->password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_srvsvc_NetShareInfo2_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	if (value == Py_None) {
		object->password = NULL;
	} else {
		object->password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->password = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetShareInfo2_get_name,
		.set = py_srvsvc_NetShareInfo2_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_srvsvc_NetShareInfo2_get_type,
		.set = py_srvsvc_NetShareInfo2_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_ShareType")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetShareInfo2_get_comment,
		.set = py_srvsvc_NetShareInfo2_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "permissions"),
		.get = py_srvsvc_NetShareInfo2_get_permissions,
		.set = py_srvsvc_NetShareInfo2_set_permissions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_users"),
		.get = py_srvsvc_NetShareInfo2_get_max_users,
		.set = py_srvsvc_NetShareInfo2_set_max_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "current_users"),
		.get = py_srvsvc_NetShareInfo2_get_current_users,
		.set = py_srvsvc_NetShareInfo2_set_current_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "path"),
		.get = py_srvsvc_NetShareInfo2_get_path,
		.set = py_srvsvc_NetShareInfo2_set_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_srvsvc_NetShareInfo2_get_password,
		.set = py_srvsvc_NetShareInfo2_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo2, type);
}


static PyTypeObject srvsvc_NetShareInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo2",
	.tp_getset = py_srvsvc_NetShareInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo2_new,
};


static PyObject *py_srvsvc_NetShareCtr2_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr2_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo2_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr2_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo2_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr2_get_count,
		.set = py_srvsvc_NetShareCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr2_get_array,
		.set = py_srvsvc_NetShareCtr2_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo2")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr2, type);
}


static PyTypeObject srvsvc_NetShareCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr2",
	.tp_getset = py_srvsvc_NetShareCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr2_new,
};


static PyObject *py_srvsvc_NetShareInfo501_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetShareInfo501_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo501_get_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_srvsvc_NetShareInfo501_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo501_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetShareInfo501_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo501_get_csc_policy(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(obj);
	PyObject *py_csc_policy;
	py_csc_policy = PyLong_FromUnsignedLongLong((uint32_t)(object->csc_policy));
	return py_csc_policy;
}

static int py_srvsvc_NetShareInfo501_set_csc_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo501 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->csc_policy");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->csc_policy));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->csc_policy = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo501_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetShareInfo501_get_name,
		.set = py_srvsvc_NetShareInfo501_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_srvsvc_NetShareInfo501_get_type,
		.set = py_srvsvc_NetShareInfo501_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_ShareType")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetShareInfo501_get_comment,
		.set = py_srvsvc_NetShareInfo501_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "csc_policy"),
		.get = py_srvsvc_NetShareInfo501_get_csc_policy,
		.set = py_srvsvc_NetShareInfo501_set_csc_policy,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo501_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo501, type);
}


static PyTypeObject srvsvc_NetShareInfo501_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo501",
	.tp_getset = py_srvsvc_NetShareInfo501_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo501_new,
};


static PyObject *py_srvsvc_NetShareCtr501_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr501 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr501_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr501 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr501_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr501 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo501_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr501_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr501 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo501_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo501 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr501_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr501_get_count,
		.set = py_srvsvc_NetShareCtr501_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr501_get_array,
		.set = py_srvsvc_NetShareCtr501_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo501")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr501_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr501, type);
}


static PyTypeObject srvsvc_NetShareCtr501_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr501",
	.tp_getset = py_srvsvc_NetShareCtr501_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr501_new,
};


static PyObject *py_srvsvc_NetShareInfo502_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetShareInfo502_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_srvsvc_NetShareInfo502_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetShareInfo502_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_permissions(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_permissions;
	py_permissions = PyLong_FromUnsignedLongLong((uint32_t)(object->permissions));
	return py_permissions;
}

static int py_srvsvc_NetShareInfo502_set_permissions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->permissions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->permissions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->permissions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_max_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_users;
	py_max_users = PyLong_FromUnsignedLongLong((uint32_t)(object->max_users));
	return py_max_users;
}

static int py_srvsvc_NetShareInfo502_set_max_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_current_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_current_users;
	py_current_users = PyLong_FromUnsignedLongLong((uint32_t)(object->current_users));
	return py_current_users;
}

static int py_srvsvc_NetShareInfo502_set_current_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->current_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->current_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->current_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_path(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_path;
	if (object->path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->path == NULL) {
		py_path = Py_None;
		Py_INCREF(py_path);
	} else {
		if (object->path == NULL) {
			py_path = Py_None;
			Py_INCREF(py_path);
		} else {
			py_path = PyUnicode_Decode(object->path, strlen(object->path), "utf-8", "ignore");
		}
	}
	return py_path;
}

static int py_srvsvc_NetShareInfo502_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->path");
		return -1;
	}
	if (value == Py_None) {
		object->path = NULL;
	} else {
		object->path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_password(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->password == NULL) {
		Py_RETURN_NONE;
	}
	if (object->password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		if (object->password == NULL) {
			py_password = Py_None;
			Py_INCREF(py_password);
		} else {
			py_password = PyUnicode_Decode(object->password, strlen(object->password), "utf-8", "ignore");
		}
	}
	return py_password;
}

static int py_srvsvc_NetShareInfo502_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	if (value == Py_None) {
		object->password = NULL;
	} else {
		object->password = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->password = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo502_get_sd_buf(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_sd_buf;
	py_sd_buf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sd_buf);
	return py_sd_buf;
}

static int py_srvsvc_NetShareInfo502_set_sd_buf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sd_buf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sd_buf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo502_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetShareInfo502_get_name,
		.set = py_srvsvc_NetShareInfo502_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_srvsvc_NetShareInfo502_get_type,
		.set = py_srvsvc_NetShareInfo502_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_ShareType")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetShareInfo502_get_comment,
		.set = py_srvsvc_NetShareInfo502_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "permissions"),
		.get = py_srvsvc_NetShareInfo502_get_permissions,
		.set = py_srvsvc_NetShareInfo502_set_permissions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_users"),
		.get = py_srvsvc_NetShareInfo502_get_max_users,
		.set = py_srvsvc_NetShareInfo502_set_max_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "current_users"),
		.get = py_srvsvc_NetShareInfo502_get_current_users,
		.set = py_srvsvc_NetShareInfo502_set_current_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "path"),
		.get = py_srvsvc_NetShareInfo502_get_path,
		.set = py_srvsvc_NetShareInfo502_set_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_srvsvc_NetShareInfo502_get_password,
		.set = py_srvsvc_NetShareInfo502_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "sd_buf"),
		.get = py_srvsvc_NetShareInfo502_get_sd_buf,
		.set = py_srvsvc_NetShareInfo502_set_sd_buf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo502_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo502, type);
}


static PyTypeObject srvsvc_NetShareInfo502_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo502",
	.tp_getset = py_srvsvc_NetShareInfo502_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo502_new,
};


static PyObject *py_srvsvc_NetShareCtr502_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr502 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr502_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr502_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr502 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo502_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr502_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr502 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo502_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo502 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr502_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr502_get_count,
		.set = py_srvsvc_NetShareCtr502_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr502_get_array,
		.set = py_srvsvc_NetShareCtr502_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo502")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr502_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr502, type);
}


static PyTypeObject srvsvc_NetShareCtr502_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr502",
	.tp_getset = py_srvsvc_NetShareCtr502_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr502_new,
};


static PyObject *py_srvsvc_NetShareInfo1004_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1004 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetShareInfo1004_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1004 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo1004_getsetters[] = {
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetShareInfo1004_get_comment,
		.set = py_srvsvc_NetShareInfo1004_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo1004_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo1004, type);
}


static PyTypeObject srvsvc_NetShareInfo1004_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo1004",
	.tp_getset = py_srvsvc_NetShareInfo1004_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo1004_new,
};


static PyObject *py_srvsvc_NetShareCtr1004_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1004 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr1004_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1004 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr1004_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1004 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo1004_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr1004_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1004 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1004_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo1004 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr1004_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr1004_get_count,
		.set = py_srvsvc_NetShareCtr1004_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr1004_get_array,
		.set = py_srvsvc_NetShareCtr1004_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo1004")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr1004_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr1004, type);
}


static PyTypeObject srvsvc_NetShareCtr1004_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr1004",
	.tp_getset = py_srvsvc_NetShareCtr1004_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr1004_new,
};


static PyObject *py_srvsvc_NetShareInfo1005_get_dfs_flags(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1005 *object = pytalloc_get_ptr(obj);
	PyObject *py_dfs_flags;
	py_dfs_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->dfs_flags));
	return py_dfs_flags;
}

static int py_srvsvc_NetShareInfo1005_set_dfs_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1005 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dfs_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dfs_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dfs_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo1005_getsetters[] = {
	{
		.name = discard_const_p(char, "dfs_flags"),
		.get = py_srvsvc_NetShareInfo1005_get_dfs_flags,
		.set = py_srvsvc_NetShareInfo1005_set_dfs_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type NetShareInfo1005Flags")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo1005_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo1005, type);
}


static PyTypeObject srvsvc_NetShareInfo1005_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo1005",
	.tp_getset = py_srvsvc_NetShareInfo1005_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo1005_new,
};


static PyObject *py_srvsvc_NetShareCtr1005_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1005 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr1005_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1005 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr1005_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1005 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo1005_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr1005_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1005 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1005_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo1005 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr1005_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr1005_get_count,
		.set = py_srvsvc_NetShareCtr1005_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr1005_get_array,
		.set = py_srvsvc_NetShareCtr1005_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo1005")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr1005_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr1005, type);
}


static PyTypeObject srvsvc_NetShareCtr1005_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr1005",
	.tp_getset = py_srvsvc_NetShareCtr1005_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr1005_new,
};


static PyObject *py_srvsvc_NetShareInfo1006_get_max_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1006 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_users;
	py_max_users = PyLong_FromUnsignedLongLong((uint32_t)(object->max_users));
	return py_max_users;
}

static int py_srvsvc_NetShareInfo1006_set_max_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1006 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo1006_getsetters[] = {
	{
		.name = discard_const_p(char, "max_users"),
		.get = py_srvsvc_NetShareInfo1006_get_max_users,
		.set = py_srvsvc_NetShareInfo1006_set_max_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo1006_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo1006, type);
}


static PyTypeObject srvsvc_NetShareInfo1006_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo1006",
	.tp_getset = py_srvsvc_NetShareInfo1006_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo1006_new,
};


static PyObject *py_srvsvc_NetShareCtr1006_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1006 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr1006_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1006 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr1006_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1006 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo1006_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr1006_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1006 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1006_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo1006 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr1006_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr1006_get_count,
		.set = py_srvsvc_NetShareCtr1006_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr1006_get_array,
		.set = py_srvsvc_NetShareCtr1006_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo1006")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr1006_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr1006, type);
}


static PyTypeObject srvsvc_NetShareCtr1006_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr1006",
	.tp_getset = py_srvsvc_NetShareCtr1006_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr1006_new,
};


static PyObject *py_srvsvc_NetShareInfo1007_get_flags(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1007 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_srvsvc_NetShareInfo1007_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1007 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfo1007_get_alternate_directory_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfo1007 *object = pytalloc_get_ptr(obj);
	PyObject *py_alternate_directory_name;
	if (object->alternate_directory_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->alternate_directory_name == NULL) {
		py_alternate_directory_name = Py_None;
		Py_INCREF(py_alternate_directory_name);
	} else {
		if (object->alternate_directory_name == NULL) {
			py_alternate_directory_name = Py_None;
			Py_INCREF(py_alternate_directory_name);
		} else {
			py_alternate_directory_name = PyUnicode_Decode(object->alternate_directory_name, strlen(object->alternate_directory_name), "utf-8", "ignore");
		}
	}
	return py_alternate_directory_name;
}

static int py_srvsvc_NetShareInfo1007_set_alternate_directory_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfo1007 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alternate_directory_name");
		return -1;
	}
	if (value == Py_None) {
		object->alternate_directory_name = NULL;
	} else {
		object->alternate_directory_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->alternate_directory_name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfo1007_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_srvsvc_NetShareInfo1007_get_flags,
		.set = py_srvsvc_NetShareInfo1007_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alternate_directory_name"),
		.get = py_srvsvc_NetShareInfo1007_get_alternate_directory_name,
		.set = py_srvsvc_NetShareInfo1007_set_alternate_directory_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfo1007_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfo1007, type);
}


static PyTypeObject srvsvc_NetShareInfo1007_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo1007",
	.tp_getset = py_srvsvc_NetShareInfo1007_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo1007_new,
};


static PyObject *py_srvsvc_NetShareCtr1007_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1007 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr1007_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1007 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr1007_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1007 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetShareInfo1007_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr1007_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1007 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1007_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetShareInfo1007 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr1007_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr1007_get_count,
		.set = py_srvsvc_NetShareCtr1007_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr1007_get_array,
		.set = py_srvsvc_NetShareCtr1007_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareInfo1007")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr1007_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr1007, type);
}


static PyTypeObject srvsvc_NetShareCtr1007_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr1007",
	.tp_getset = py_srvsvc_NetShareCtr1007_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr1007_new,
};


static PyObject *py_srvsvc_NetShareCtr1501_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1501 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetShareCtr1501_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1501 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareCtr1501_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareCtr1501 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(sec_desc_buf_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetShareCtr1501_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareCtr1501 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(sec_desc_buf_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct sec_desc_buf *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareCtr1501_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetShareCtr1501_get_count,
		.set = py_srvsvc_NetShareCtr1501_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetShareCtr1501_get_array,
		.set = py_srvsvc_NetShareCtr1501_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareCtr1501_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareCtr1501, type);
}


static PyTypeObject srvsvc_NetShareCtr1501_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr1501",
	.tp_getset = py_srvsvc_NetShareCtr1501_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr1501_new,
};

static PyObject *py_import_srvsvc_NetShareInfo(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetShareInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->info0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo0_Type, in->info0, in->info0);
			}
			return ret;

		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo1_Type, in->info1, in->info1);
			}
			return ret;

		case 2:
			if (in->info2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo2_Type, in->info2, in->info2);
			}
			return ret;

		case 501:
			if (in->info501 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo501_Type, in->info501, in->info501);
			}
			return ret;

		case 502:
			if (in->info502 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo502_Type, in->info502, in->info502);
			}
			return ret;

		case 1004:
			if (in->info1004 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo1004_Type, in->info1004, in->info1004);
			}
			return ret;

		case 1005:
			if (in->info1005 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo1005_Type, in->info1005, in->info1005);
			}
			return ret;

		case 1006:
			if (in->info1006 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo1006_Type, in->info1006, in->info1006);
			}
			return ret;

		case 1007:
			if (in->info1007 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareInfo1007_Type, in->info1007, in->info1007);
			}
			return ret;

		case 1501:
			if (in->info1501 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(sec_desc_buf_Type, in->info1501, in->info1501);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetShareInfo *py_export_srvsvc_NetShareInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetShareInfo *ret = talloc_zero(mem_ctx, union srvsvc_NetShareInfo);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info0 = NULL;
			} else {
				ret->info0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info0 = (struct srvsvc_NetShareInfo0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1 = (struct srvsvc_NetShareInfo1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info2 = NULL;
			} else {
				ret->info2 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info2 = (struct srvsvc_NetShareInfo2 *)pytalloc_get_ptr(in);
			}
			break;

		case 501:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info501");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info501 = NULL;
			} else {
				ret->info501 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo501_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info501 = (struct srvsvc_NetShareInfo501 *)pytalloc_get_ptr(in);
			}
			break;

		case 502:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info502");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info502 = NULL;
			} else {
				ret->info502 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo502_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info502 = (struct srvsvc_NetShareInfo502 *)pytalloc_get_ptr(in);
			}
			break;

		case 1004:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1004");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1004 = NULL;
			} else {
				ret->info1004 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1004_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1004 = (struct srvsvc_NetShareInfo1004 *)pytalloc_get_ptr(in);
			}
			break;

		case 1005:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1005");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1005 = NULL;
			} else {
				ret->info1005 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1005_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1005 = (struct srvsvc_NetShareInfo1005 *)pytalloc_get_ptr(in);
			}
			break;

		case 1006:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1006");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1006 = NULL;
			} else {
				ret->info1006 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1006_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1006 = (struct srvsvc_NetShareInfo1006 *)pytalloc_get_ptr(in);
			}
			break;

		case 1007:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1007");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1007 = NULL;
			} else {
				ret->info1007 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareInfo1007_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1007 = (struct srvsvc_NetShareInfo1007 *)pytalloc_get_ptr(in);
			}
			break;

		case 1501:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1501");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1501 = NULL;
			} else {
				ret->info1501 = NULL;
				PY_CHECK_TYPE(sec_desc_buf_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1501 = (struct sec_desc_buf *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetShareInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetShareInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetShareInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetShareInfo!");
		return NULL;
	}

	return py_import_srvsvc_NetShareInfo(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetShareInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetShareInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetShareInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetShareInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetShareInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetShareInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetShareInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetShareInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfo",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetShareInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfo_new,
};

static PyObject *py_import_srvsvc_NetShareCtr(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetShareCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

		case 2:
			if (in->ctr2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr2_Type, in->ctr2, in->ctr2);
			}
			return ret;

		case 501:
			if (in->ctr501 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr501_Type, in->ctr501, in->ctr501);
			}
			return ret;

		case 502:
			if (in->ctr502 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr502_Type, in->ctr502, in->ctr502);
			}
			return ret;

		case 1004:
			if (in->ctr1004 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr1004_Type, in->ctr1004, in->ctr1004);
			}
			return ret;

		case 1005:
			if (in->ctr1005 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr1005_Type, in->ctr1005, in->ctr1005);
			}
			return ret;

		case 1006:
			if (in->ctr1006 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr1006_Type, in->ctr1006, in->ctr1006);
			}
			return ret;

		case 1007:
			if (in->ctr1007 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr1007_Type, in->ctr1007, in->ctr1007);
			}
			return ret;

		case 1501:
			if (in->ctr1501 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetShareCtr1501_Type, in->ctr1501, in->ctr1501);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetShareCtr *py_export_srvsvc_NetShareCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetShareCtr *ret = talloc_zero(mem_ctx, union srvsvc_NetShareCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct srvsvc_NetShareCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct srvsvc_NetShareCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr2 = NULL;
			} else {
				ret->ctr2 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr2 = (struct srvsvc_NetShareCtr2 *)pytalloc_get_ptr(in);
			}
			break;

		case 501:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr501");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr501 = NULL;
			} else {
				ret->ctr501 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr501_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr501 = (struct srvsvc_NetShareCtr501 *)pytalloc_get_ptr(in);
			}
			break;

		case 502:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr502");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr502 = NULL;
			} else {
				ret->ctr502 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr502_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr502 = (struct srvsvc_NetShareCtr502 *)pytalloc_get_ptr(in);
			}
			break;

		case 1004:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1004");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1004 = NULL;
			} else {
				ret->ctr1004 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr1004_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1004 = (struct srvsvc_NetShareCtr1004 *)pytalloc_get_ptr(in);
			}
			break;

		case 1005:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1005");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1005 = NULL;
			} else {
				ret->ctr1005 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr1005_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1005 = (struct srvsvc_NetShareCtr1005 *)pytalloc_get_ptr(in);
			}
			break;

		case 1006:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1006");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1006 = NULL;
			} else {
				ret->ctr1006 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr1006_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1006 = (struct srvsvc_NetShareCtr1006 *)pytalloc_get_ptr(in);
			}
			break;

		case 1007:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1007");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1007 = NULL;
			} else {
				ret->ctr1007 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr1007_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1007 = (struct srvsvc_NetShareCtr1007 *)pytalloc_get_ptr(in);
			}
			break;

		case 1501:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1501");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1501 = NULL;
			} else {
				ret->ctr1501 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetShareCtr1501_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1501 = (struct srvsvc_NetShareCtr1501 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetShareCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetShareCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetShareCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetShareCtr!");
		return NULL;
	}

	return py_import_srvsvc_NetShareCtr(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetShareCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetShareCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetShareCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetShareCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetShareCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetShareCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetShareCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetShareCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareCtr",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetShareCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareCtr_new,
};


static PyObject *py_srvsvc_NetShareInfoCtr_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_srvsvc_NetShareInfoCtr_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetShareInfoCtr_get_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetShareInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&srvsvc_NetShareCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union srvsvc_NetShareCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_srvsvc_NetShareInfoCtr_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetShareInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union srvsvc_NetShareCtr *ctr_switch_0;
		ctr_switch_0 = (union srvsvc_NetShareCtr *)pyrpc_export_union(&srvsvc_NetShareCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union srvsvc_NetShareCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetShareInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_srvsvc_NetShareInfoCtr_get_level,
		.set = py_srvsvc_NetShareInfoCtr_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_srvsvc_NetShareInfoCtr_get_ctr,
		.set = py_srvsvc_NetShareInfoCtr_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetShareCtr")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetShareInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetShareInfoCtr, type);
}


static PyTypeObject srvsvc_NetShareInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetShareInfoCtr",
	.tp_getset = py_srvsvc_NetShareInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetShareInfoCtr_new,
};


static PyObject *py_srvsvc_NetSrvInfo100_get_platform_id(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo100 *object = pytalloc_get_ptr(obj);
	PyObject *py_platform_id;
	py_platform_id = PyLong_FromUnsignedLongLong((uint32_t)(object->platform_id));
	return py_platform_id;
}

static int py_srvsvc_NetSrvInfo100_set_platform_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo100 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->platform_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->platform_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->platform_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo100_get_server_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo100 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_srvsvc_NetSrvInfo100_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo100 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_name");
		return -1;
	}
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo100_getsetters[] = {
	{
		.name = discard_const_p(char, "platform_id"),
		.get = py_srvsvc_NetSrvInfo100_get_platform_id,
		.set = py_srvsvc_NetSrvInfo100_set_platform_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_PlatformId")
	},
	{
		.name = discard_const_p(char, "server_name"),
		.get = py_srvsvc_NetSrvInfo100_get_server_name,
		.set = py_srvsvc_NetSrvInfo100_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo100_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo100, type);
}

static PyObject *py_srvsvc_NetSrvInfo100_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct srvsvc_NetSrvInfo100 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_srvsvc_NetSrvInfo100);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_srvsvc_NetSrvInfo100_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct srvsvc_NetSrvInfo100 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srvsvc_NetSrvInfo100);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srvsvc_NetSrvInfo100);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_srvsvc_NetSrvInfo100_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct srvsvc_NetSrvInfo100 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_srvsvc_NetSrvInfo100, "srvsvc_NetSrvInfo100", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_srvsvc_NetSrvInfo100, "srvsvc_NetSrvInfo100", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_srvsvc_NetSrvInfo100_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_srvsvc_NetSrvInfo100_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSrvInfo100_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSrvInfo100_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject srvsvc_NetSrvInfo100_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo100",
	.tp_getset = py_srvsvc_NetSrvInfo100_getsetters,
	.tp_methods = py_srvsvc_NetSrvInfo100_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo100_new,
};


static PyObject *py_srvsvc_NetSrvInfo101_get_platform_id(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_platform_id;
	py_platform_id = PyLong_FromUnsignedLongLong((uint32_t)(object->platform_id));
	return py_platform_id;
}

static int py_srvsvc_NetSrvInfo101_set_platform_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->platform_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->platform_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->platform_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo101_get_server_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_srvsvc_NetSrvInfo101_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_name");
		return -1;
	}
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo101_get_version_major(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_major;
	py_version_major = PyLong_FromUnsignedLongLong((uint32_t)(object->version_major));
	return py_version_major;
}

static int py_srvsvc_NetSrvInfo101_set_version_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version_major");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_major));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_major = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo101_get_version_minor(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_minor;
	py_version_minor = PyLong_FromUnsignedLongLong((uint32_t)(object->version_minor));
	return py_version_minor;
}

static int py_srvsvc_NetSrvInfo101_set_version_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo101_get_server_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyLong_FromUnsignedLongLong((uint32_t)(object->server_type));
	return py_server_type;
}

static int py_srvsvc_NetSrvInfo101_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->server_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->server_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo101_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetSrvInfo101_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo101_getsetters[] = {
	{
		.name = discard_const_p(char, "platform_id"),
		.get = py_srvsvc_NetSrvInfo101_get_platform_id,
		.set = py_srvsvc_NetSrvInfo101_set_platform_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_PlatformId")
	},
	{
		.name = discard_const_p(char, "server_name"),
		.get = py_srvsvc_NetSrvInfo101_get_server_name,
		.set = py_srvsvc_NetSrvInfo101_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "version_major"),
		.get = py_srvsvc_NetSrvInfo101_get_version_major,
		.set = py_srvsvc_NetSrvInfo101_set_version_major,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version_minor"),
		.get = py_srvsvc_NetSrvInfo101_get_version_minor,
		.set = py_srvsvc_NetSrvInfo101_set_version_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "server_type"),
		.get = py_srvsvc_NetSrvInfo101_get_server_type,
		.set = py_srvsvc_NetSrvInfo101_set_server_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServerType")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetSrvInfo101_get_comment,
		.set = py_srvsvc_NetSrvInfo101_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo101_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo101, type);
}

static PyObject *py_srvsvc_NetSrvInfo101_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_srvsvc_NetSrvInfo101);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_srvsvc_NetSrvInfo101_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srvsvc_NetSrvInfo101);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srvsvc_NetSrvInfo101);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_srvsvc_NetSrvInfo101_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct srvsvc_NetSrvInfo101 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_srvsvc_NetSrvInfo101, "srvsvc_NetSrvInfo101", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_srvsvc_NetSrvInfo101, "srvsvc_NetSrvInfo101", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_srvsvc_NetSrvInfo101_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_srvsvc_NetSrvInfo101_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSrvInfo101_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSrvInfo101_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject srvsvc_NetSrvInfo101_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo101",
	.tp_getset = py_srvsvc_NetSrvInfo101_getsetters,
	.tp_methods = py_srvsvc_NetSrvInfo101_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo101_new,
};


static PyObject *py_srvsvc_NetSrvInfo102_get_platform_id(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_platform_id;
	py_platform_id = PyLong_FromUnsignedLongLong((uint32_t)(object->platform_id));
	return py_platform_id;
}

static int py_srvsvc_NetSrvInfo102_set_platform_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->platform_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->platform_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->platform_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_server_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_srvsvc_NetSrvInfo102_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_name");
		return -1;
	}
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_version_major(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_major;
	py_version_major = PyLong_FromUnsignedLongLong((uint32_t)(object->version_major));
	return py_version_major;
}

static int py_srvsvc_NetSrvInfo102_set_version_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version_major");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_major));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_major = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_version_minor(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_version_minor;
	py_version_minor = PyLong_FromUnsignedLongLong((uint32_t)(object->version_minor));
	return py_version_minor;
}

static int py_srvsvc_NetSrvInfo102_set_version_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_server_type(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyLong_FromUnsignedLongLong((uint32_t)(object->server_type));
	return py_server_type;
}

static int py_srvsvc_NetSrvInfo102_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->server_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->server_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetSrvInfo102_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_users;
	py_users = PyLong_FromUnsignedLongLong((uint32_t)(object->users));
	return py_users;
}

static int py_srvsvc_NetSrvInfo102_set_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_disc(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_disc;
	py_disc = PyLong_FromUnsignedLongLong((uint32_t)(object->disc));
	return py_disc;
}

static int py_srvsvc_NetSrvInfo102_set_disc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->disc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->disc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->disc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_hidden(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_hidden;
	py_hidden = PyLong_FromUnsignedLongLong((uint32_t)(object->hidden));
	return py_hidden;
}

static int py_srvsvc_NetSrvInfo102_set_hidden(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hidden");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->hidden));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->hidden = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_announce(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_announce;
	py_announce = PyLong_FromUnsignedLongLong((uint32_t)(object->announce));
	return py_announce;
}

static int py_srvsvc_NetSrvInfo102_set_announce(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->announce");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->announce));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->announce = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_anndelta(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_anndelta;
	py_anndelta = PyLong_FromUnsignedLongLong((uint32_t)(object->anndelta));
	return py_anndelta;
}

static int py_srvsvc_NetSrvInfo102_set_anndelta(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->anndelta");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->anndelta));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->anndelta = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_licenses(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_licenses;
	py_licenses = PyLong_FromUnsignedLongLong((uint32_t)(object->licenses));
	return py_licenses;
}

static int py_srvsvc_NetSrvInfo102_set_licenses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->licenses");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->licenses));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->licenses = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo102_get_userpath(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(obj);
	PyObject *py_userpath;
	if (object->userpath == NULL) {
		Py_RETURN_NONE;
	}
	if (object->userpath == NULL) {
		py_userpath = Py_None;
		Py_INCREF(py_userpath);
	} else {
		if (object->userpath == NULL) {
			py_userpath = Py_None;
			Py_INCREF(py_userpath);
		} else {
			py_userpath = PyUnicode_Decode(object->userpath, strlen(object->userpath), "utf-8", "ignore");
		}
	}
	return py_userpath;
}

static int py_srvsvc_NetSrvInfo102_set_userpath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo102 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->userpath");
		return -1;
	}
	if (value == Py_None) {
		object->userpath = NULL;
	} else {
		object->userpath = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->userpath = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo102_getsetters[] = {
	{
		.name = discard_const_p(char, "platform_id"),
		.get = py_srvsvc_NetSrvInfo102_get_platform_id,
		.set = py_srvsvc_NetSrvInfo102_set_platform_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_PlatformId")
	},
	{
		.name = discard_const_p(char, "server_name"),
		.get = py_srvsvc_NetSrvInfo102_get_server_name,
		.set = py_srvsvc_NetSrvInfo102_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "version_major"),
		.get = py_srvsvc_NetSrvInfo102_get_version_major,
		.set = py_srvsvc_NetSrvInfo102_set_version_major,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version_minor"),
		.get = py_srvsvc_NetSrvInfo102_get_version_minor,
		.set = py_srvsvc_NetSrvInfo102_set_version_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "server_type"),
		.get = py_srvsvc_NetSrvInfo102_get_server_type,
		.set = py_srvsvc_NetSrvInfo102_set_server_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServerType")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetSrvInfo102_get_comment,
		.set = py_srvsvc_NetSrvInfo102_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "users"),
		.get = py_srvsvc_NetSrvInfo102_get_users,
		.set = py_srvsvc_NetSrvInfo102_set_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "disc"),
		.get = py_srvsvc_NetSrvInfo102_get_disc,
		.set = py_srvsvc_NetSrvInfo102_set_disc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "hidden"),
		.get = py_srvsvc_NetSrvInfo102_get_hidden,
		.set = py_srvsvc_NetSrvInfo102_set_hidden,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "announce"),
		.get = py_srvsvc_NetSrvInfo102_get_announce,
		.set = py_srvsvc_NetSrvInfo102_set_announce,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "anndelta"),
		.get = py_srvsvc_NetSrvInfo102_get_anndelta,
		.set = py_srvsvc_NetSrvInfo102_set_anndelta,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "licenses"),
		.get = py_srvsvc_NetSrvInfo102_get_licenses,
		.set = py_srvsvc_NetSrvInfo102_set_licenses,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "userpath"),
		.get = py_srvsvc_NetSrvInfo102_get_userpath,
		.set = py_srvsvc_NetSrvInfo102_set_userpath,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo102_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo102, type);
}


static PyTypeObject srvsvc_NetSrvInfo102_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo102",
	.tp_getset = py_srvsvc_NetSrvInfo102_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo102_new,
};


static PyObject *py_srvsvc_NetSrvInfo402_get_ulist_mtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_ulist_mtime;
	py_ulist_mtime = PyLong_FromUnsignedLongLong((uint32_t)(object->ulist_mtime));
	return py_ulist_mtime;
}

static int py_srvsvc_NetSrvInfo402_set_ulist_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ulist_mtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ulist_mtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ulist_mtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_glist_mtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_glist_mtime;
	py_glist_mtime = PyLong_FromUnsignedLongLong((uint32_t)(object->glist_mtime));
	return py_glist_mtime;
}

static int py_srvsvc_NetSrvInfo402_set_glist_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->glist_mtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->glist_mtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->glist_mtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_alist_mtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_alist_mtime;
	py_alist_mtime = PyLong_FromUnsignedLongLong((uint32_t)(object->alist_mtime));
	return py_alist_mtime;
}

static int py_srvsvc_NetSrvInfo402_set_alist_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alist_mtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alist_mtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alist_mtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_alerts(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_alerts;
	if (object->alerts == NULL) {
		Py_RETURN_NONE;
	}
	if (object->alerts == NULL) {
		py_alerts = Py_None;
		Py_INCREF(py_alerts);
	} else {
		if (object->alerts == NULL) {
			py_alerts = Py_None;
			Py_INCREF(py_alerts);
		} else {
			py_alerts = PyUnicode_Decode(object->alerts, strlen(object->alerts), "utf-8", "ignore");
		}
	}
	return py_alerts;
}

static int py_srvsvc_NetSrvInfo402_set_alerts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alerts");
		return -1;
	}
	if (value == Py_None) {
		object->alerts = NULL;
	} else {
		object->alerts = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->alerts = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_security(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_security;
	py_security = PyLong_FromUnsignedLongLong((uint32_t)(object->security));
	return py_security;
}

static int py_srvsvc_NetSrvInfo402_set_security(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->security");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->security));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->security = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_numadmin(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_numadmin;
	py_numadmin = PyLong_FromUnsignedLongLong((uint32_t)(object->numadmin));
	return py_numadmin;
}

static int py_srvsvc_NetSrvInfo402_set_numadmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numadmin");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numadmin));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numadmin = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_lanmask(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_lanmask;
	py_lanmask = PyLong_FromUnsignedLongLong((uint32_t)(object->lanmask));
	return py_lanmask;
}

static int py_srvsvc_NetSrvInfo402_set_lanmask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lanmask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lanmask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lanmask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_guestaccount(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_guestaccount;
	if (object->guestaccount == NULL) {
		Py_RETURN_NONE;
	}
	if (object->guestaccount == NULL) {
		py_guestaccount = Py_None;
		Py_INCREF(py_guestaccount);
	} else {
		if (object->guestaccount == NULL) {
			py_guestaccount = Py_None;
			Py_INCREF(py_guestaccount);
		} else {
			py_guestaccount = PyUnicode_Decode(object->guestaccount, strlen(object->guestaccount), "utf-8", "ignore");
		}
	}
	return py_guestaccount;
}

static int py_srvsvc_NetSrvInfo402_set_guestaccount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guestaccount");
		return -1;
	}
	if (value == Py_None) {
		object->guestaccount = NULL;
	} else {
		object->guestaccount = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->guestaccount = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_chdevs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_chdevs;
	py_chdevs = PyLong_FromUnsignedLongLong((uint32_t)(object->chdevs));
	return py_chdevs;
}

static int py_srvsvc_NetSrvInfo402_set_chdevs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->chdevs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->chdevs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->chdevs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_chdevqs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_chdevqs;
	py_chdevqs = PyLong_FromUnsignedLongLong((uint32_t)(object->chdevqs));
	return py_chdevqs;
}

static int py_srvsvc_NetSrvInfo402_set_chdevqs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->chdevqs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->chdevqs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->chdevqs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_chdevjobs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_chdevjobs;
	py_chdevjobs = PyLong_FromUnsignedLongLong((uint32_t)(object->chdevjobs));
	return py_chdevjobs;
}

static int py_srvsvc_NetSrvInfo402_set_chdevjobs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->chdevjobs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->chdevjobs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->chdevjobs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_connections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_connections;
	py_connections = PyLong_FromUnsignedLongLong((uint32_t)(object->connections));
	return py_connections;
}

static int py_srvsvc_NetSrvInfo402_set_connections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->connections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->connections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_shares(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_shares;
	py_shares = PyLong_FromUnsignedLongLong((uint32_t)(object->shares));
	return py_shares;
}

static int py_srvsvc_NetSrvInfo402_set_shares(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->shares");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->shares));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->shares = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_openfiles(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_openfiles;
	py_openfiles = PyLong_FromUnsignedLongLong((uint32_t)(object->openfiles));
	return py_openfiles;
}

static int py_srvsvc_NetSrvInfo402_set_openfiles(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->openfiles");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->openfiles));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->openfiles = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_sessopen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessopen;
	py_sessopen = PyLong_FromUnsignedLongLong((uint32_t)(object->sessopen));
	return py_sessopen;
}

static int py_srvsvc_NetSrvInfo402_set_sessopen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessopen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessopen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessopen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_sesssvc(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_sesssvc;
	py_sesssvc = PyLong_FromUnsignedLongLong((uint32_t)(object->sesssvc));
	return py_sesssvc;
}

static int py_srvsvc_NetSrvInfo402_set_sesssvc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sesssvc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sesssvc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sesssvc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_sessreqs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessreqs;
	py_sessreqs = PyLong_FromUnsignedLongLong((uint32_t)(object->sessreqs));
	return py_sessreqs;
}

static int py_srvsvc_NetSrvInfo402_set_sessreqs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessreqs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessreqs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessreqs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_opensearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_opensearch;
	py_opensearch = PyLong_FromUnsignedLongLong((uint32_t)(object->opensearch));
	return py_opensearch;
}

static int py_srvsvc_NetSrvInfo402_set_opensearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opensearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opensearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opensearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_activelocks(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_activelocks;
	py_activelocks = PyLong_FromUnsignedLongLong((uint32_t)(object->activelocks));
	return py_activelocks;
}

static int py_srvsvc_NetSrvInfo402_set_activelocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->activelocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->activelocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->activelocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_numreqbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_numreqbufs;
	py_numreqbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->numreqbufs));
	return py_numreqbufs;
}

static int py_srvsvc_NetSrvInfo402_set_numreqbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numreqbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numreqbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numreqbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_sizereqbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_sizereqbufs;
	py_sizereqbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->sizereqbufs));
	return py_sizereqbufs;
}

static int py_srvsvc_NetSrvInfo402_set_sizereqbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sizereqbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sizereqbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sizereqbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_numbigbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_numbigbufs;
	py_numbigbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->numbigbufs));
	return py_numbigbufs;
}

static int py_srvsvc_NetSrvInfo402_set_numbigbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numbigbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numbigbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numbigbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_numfiletasks(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_numfiletasks;
	py_numfiletasks = PyLong_FromUnsignedLongLong((uint32_t)(object->numfiletasks));
	return py_numfiletasks;
}

static int py_srvsvc_NetSrvInfo402_set_numfiletasks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numfiletasks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numfiletasks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numfiletasks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_alertsched(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_alertsched;
	py_alertsched = PyLong_FromUnsignedLongLong((uint32_t)(object->alertsched));
	return py_alertsched;
}

static int py_srvsvc_NetSrvInfo402_set_alertsched(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alertsched");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alertsched));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alertsched = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_erroralert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_erroralert;
	py_erroralert = PyLong_FromUnsignedLongLong((uint32_t)(object->erroralert));
	return py_erroralert;
}

static int py_srvsvc_NetSrvInfo402_set_erroralert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->erroralert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->erroralert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->erroralert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_logonalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_logonalert;
	py_logonalert = PyLong_FromUnsignedLongLong((uint32_t)(object->logonalert));
	return py_logonalert;
}

static int py_srvsvc_NetSrvInfo402_set_logonalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logonalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logonalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logonalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_accessalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_accessalert;
	py_accessalert = PyLong_FromUnsignedLongLong((uint32_t)(object->accessalert));
	return py_accessalert;
}

static int py_srvsvc_NetSrvInfo402_set_accessalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->accessalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->accessalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->accessalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_diskalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_diskalert;
	py_diskalert = PyLong_FromUnsignedLongLong((uint32_t)(object->diskalert));
	return py_diskalert;
}

static int py_srvsvc_NetSrvInfo402_set_diskalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->diskalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->diskalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->diskalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_netioalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_netioalert;
	py_netioalert = PyLong_FromUnsignedLongLong((uint32_t)(object->netioalert));
	return py_netioalert;
}

static int py_srvsvc_NetSrvInfo402_set_netioalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->netioalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->netioalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->netioalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_maxaudits(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxaudits;
	py_maxaudits = PyLong_FromUnsignedLongLong((uint32_t)(object->maxaudits));
	return py_maxaudits;
}

static int py_srvsvc_NetSrvInfo402_set_maxaudits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxaudits");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxaudits));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxaudits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo402_get_srvheuristics(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(obj);
	PyObject *py_srvheuristics;
	if (object->srvheuristics == NULL) {
		Py_RETURN_NONE;
	}
	if (object->srvheuristics == NULL) {
		py_srvheuristics = Py_None;
		Py_INCREF(py_srvheuristics);
	} else {
		if (object->srvheuristics == NULL) {
			py_srvheuristics = Py_None;
			Py_INCREF(py_srvheuristics);
		} else {
			py_srvheuristics = PyUnicode_Decode(object->srvheuristics, strlen(object->srvheuristics), "utf-8", "ignore");
		}
	}
	return py_srvheuristics;
}

static int py_srvsvc_NetSrvInfo402_set_srvheuristics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo402 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->srvheuristics");
		return -1;
	}
	if (value == Py_None) {
		object->srvheuristics = NULL;
	} else {
		object->srvheuristics = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->srvheuristics = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo402_getsetters[] = {
	{
		.name = discard_const_p(char, "ulist_mtime"),
		.get = py_srvsvc_NetSrvInfo402_get_ulist_mtime,
		.set = py_srvsvc_NetSrvInfo402_set_ulist_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "glist_mtime"),
		.get = py_srvsvc_NetSrvInfo402_get_glist_mtime,
		.set = py_srvsvc_NetSrvInfo402_set_glist_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alist_mtime"),
		.get = py_srvsvc_NetSrvInfo402_get_alist_mtime,
		.set = py_srvsvc_NetSrvInfo402_set_alist_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alerts"),
		.get = py_srvsvc_NetSrvInfo402_get_alerts,
		.set = py_srvsvc_NetSrvInfo402_set_alerts,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "security"),
		.get = py_srvsvc_NetSrvInfo402_get_security,
		.set = py_srvsvc_NetSrvInfo402_set_security,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numadmin"),
		.get = py_srvsvc_NetSrvInfo402_get_numadmin,
		.set = py_srvsvc_NetSrvInfo402_set_numadmin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lanmask"),
		.get = py_srvsvc_NetSrvInfo402_get_lanmask,
		.set = py_srvsvc_NetSrvInfo402_set_lanmask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "guestaccount"),
		.get = py_srvsvc_NetSrvInfo402_get_guestaccount,
		.set = py_srvsvc_NetSrvInfo402_set_guestaccount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "chdevs"),
		.get = py_srvsvc_NetSrvInfo402_get_chdevs,
		.set = py_srvsvc_NetSrvInfo402_set_chdevs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "chdevqs"),
		.get = py_srvsvc_NetSrvInfo402_get_chdevqs,
		.set = py_srvsvc_NetSrvInfo402_set_chdevqs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "chdevjobs"),
		.get = py_srvsvc_NetSrvInfo402_get_chdevjobs,
		.set = py_srvsvc_NetSrvInfo402_set_chdevjobs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "connections"),
		.get = py_srvsvc_NetSrvInfo402_get_connections,
		.set = py_srvsvc_NetSrvInfo402_set_connections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "shares"),
		.get = py_srvsvc_NetSrvInfo402_get_shares,
		.set = py_srvsvc_NetSrvInfo402_set_shares,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "openfiles"),
		.get = py_srvsvc_NetSrvInfo402_get_openfiles,
		.set = py_srvsvc_NetSrvInfo402_set_openfiles,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessopen"),
		.get = py_srvsvc_NetSrvInfo402_get_sessopen,
		.set = py_srvsvc_NetSrvInfo402_set_sessopen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sesssvc"),
		.get = py_srvsvc_NetSrvInfo402_get_sesssvc,
		.set = py_srvsvc_NetSrvInfo402_set_sesssvc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessreqs"),
		.get = py_srvsvc_NetSrvInfo402_get_sessreqs,
		.set = py_srvsvc_NetSrvInfo402_set_sessreqs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "opensearch"),
		.get = py_srvsvc_NetSrvInfo402_get_opensearch,
		.set = py_srvsvc_NetSrvInfo402_set_opensearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "activelocks"),
		.get = py_srvsvc_NetSrvInfo402_get_activelocks,
		.set = py_srvsvc_NetSrvInfo402_set_activelocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numreqbufs"),
		.get = py_srvsvc_NetSrvInfo402_get_numreqbufs,
		.set = py_srvsvc_NetSrvInfo402_set_numreqbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sizereqbufs"),
		.get = py_srvsvc_NetSrvInfo402_get_sizereqbufs,
		.set = py_srvsvc_NetSrvInfo402_set_sizereqbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numbigbufs"),
		.get = py_srvsvc_NetSrvInfo402_get_numbigbufs,
		.set = py_srvsvc_NetSrvInfo402_set_numbigbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numfiletasks"),
		.get = py_srvsvc_NetSrvInfo402_get_numfiletasks,
		.set = py_srvsvc_NetSrvInfo402_set_numfiletasks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alertsched"),
		.get = py_srvsvc_NetSrvInfo402_get_alertsched,
		.set = py_srvsvc_NetSrvInfo402_set_alertsched,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "erroralert"),
		.get = py_srvsvc_NetSrvInfo402_get_erroralert,
		.set = py_srvsvc_NetSrvInfo402_set_erroralert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "logonalert"),
		.get = py_srvsvc_NetSrvInfo402_get_logonalert,
		.set = py_srvsvc_NetSrvInfo402_set_logonalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "accessalert"),
		.get = py_srvsvc_NetSrvInfo402_get_accessalert,
		.set = py_srvsvc_NetSrvInfo402_set_accessalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "diskalert"),
		.get = py_srvsvc_NetSrvInfo402_get_diskalert,
		.set = py_srvsvc_NetSrvInfo402_set_diskalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "netioalert"),
		.get = py_srvsvc_NetSrvInfo402_get_netioalert,
		.set = py_srvsvc_NetSrvInfo402_set_netioalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxaudits"),
		.get = py_srvsvc_NetSrvInfo402_get_maxaudits,
		.set = py_srvsvc_NetSrvInfo402_set_maxaudits,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "srvheuristics"),
		.get = py_srvsvc_NetSrvInfo402_get_srvheuristics,
		.set = py_srvsvc_NetSrvInfo402_set_srvheuristics,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo402_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo402, type);
}


static PyTypeObject srvsvc_NetSrvInfo402_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo402",
	.tp_getset = py_srvsvc_NetSrvInfo402_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo402_new,
};


static PyObject *py_srvsvc_NetSrvInfo403_get_ulist_mtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_ulist_mtime;
	py_ulist_mtime = PyLong_FromUnsignedLongLong((uint32_t)(object->ulist_mtime));
	return py_ulist_mtime;
}

static int py_srvsvc_NetSrvInfo403_set_ulist_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ulist_mtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ulist_mtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ulist_mtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_glist_mtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_glist_mtime;
	py_glist_mtime = PyLong_FromUnsignedLongLong((uint32_t)(object->glist_mtime));
	return py_glist_mtime;
}

static int py_srvsvc_NetSrvInfo403_set_glist_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->glist_mtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->glist_mtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->glist_mtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_alist_mtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_alist_mtime;
	py_alist_mtime = PyLong_FromUnsignedLongLong((uint32_t)(object->alist_mtime));
	return py_alist_mtime;
}

static int py_srvsvc_NetSrvInfo403_set_alist_mtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alist_mtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alist_mtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alist_mtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_alerts(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_alerts;
	if (object->alerts == NULL) {
		Py_RETURN_NONE;
	}
	if (object->alerts == NULL) {
		py_alerts = Py_None;
		Py_INCREF(py_alerts);
	} else {
		if (object->alerts == NULL) {
			py_alerts = Py_None;
			Py_INCREF(py_alerts);
		} else {
			py_alerts = PyUnicode_Decode(object->alerts, strlen(object->alerts), "utf-8", "ignore");
		}
	}
	return py_alerts;
}

static int py_srvsvc_NetSrvInfo403_set_alerts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alerts");
		return -1;
	}
	if (value == Py_None) {
		object->alerts = NULL;
	} else {
		object->alerts = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->alerts = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_security(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_security;
	py_security = PyLong_FromUnsignedLongLong((uint32_t)(object->security));
	return py_security;
}

static int py_srvsvc_NetSrvInfo403_set_security(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->security");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->security));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->security = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_numadmin(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_numadmin;
	py_numadmin = PyLong_FromUnsignedLongLong((uint32_t)(object->numadmin));
	return py_numadmin;
}

static int py_srvsvc_NetSrvInfo403_set_numadmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numadmin");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numadmin));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numadmin = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_lanmask(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_lanmask;
	py_lanmask = PyLong_FromUnsignedLongLong((uint32_t)(object->lanmask));
	return py_lanmask;
}

static int py_srvsvc_NetSrvInfo403_set_lanmask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lanmask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lanmask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lanmask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_guestaccount(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_guestaccount;
	if (object->guestaccount == NULL) {
		Py_RETURN_NONE;
	}
	if (object->guestaccount == NULL) {
		py_guestaccount = Py_None;
		Py_INCREF(py_guestaccount);
	} else {
		if (object->guestaccount == NULL) {
			py_guestaccount = Py_None;
			Py_INCREF(py_guestaccount);
		} else {
			py_guestaccount = PyUnicode_Decode(object->guestaccount, strlen(object->guestaccount), "utf-8", "ignore");
		}
	}
	return py_guestaccount;
}

static int py_srvsvc_NetSrvInfo403_set_guestaccount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guestaccount");
		return -1;
	}
	if (value == Py_None) {
		object->guestaccount = NULL;
	} else {
		object->guestaccount = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->guestaccount = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_chdevs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_chdevs;
	py_chdevs = PyLong_FromUnsignedLongLong((uint32_t)(object->chdevs));
	return py_chdevs;
}

static int py_srvsvc_NetSrvInfo403_set_chdevs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->chdevs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->chdevs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->chdevs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_chdevqs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_chdevqs;
	py_chdevqs = PyLong_FromUnsignedLongLong((uint32_t)(object->chdevqs));
	return py_chdevqs;
}

static int py_srvsvc_NetSrvInfo403_set_chdevqs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->chdevqs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->chdevqs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->chdevqs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_chdevjobs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_chdevjobs;
	py_chdevjobs = PyLong_FromUnsignedLongLong((uint32_t)(object->chdevjobs));
	return py_chdevjobs;
}

static int py_srvsvc_NetSrvInfo403_set_chdevjobs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->chdevjobs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->chdevjobs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->chdevjobs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_connections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_connections;
	py_connections = PyLong_FromUnsignedLongLong((uint32_t)(object->connections));
	return py_connections;
}

static int py_srvsvc_NetSrvInfo403_set_connections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->connections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->connections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_shares(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_shares;
	py_shares = PyLong_FromUnsignedLongLong((uint32_t)(object->shares));
	return py_shares;
}

static int py_srvsvc_NetSrvInfo403_set_shares(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->shares");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->shares));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->shares = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_openfiles(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_openfiles;
	py_openfiles = PyLong_FromUnsignedLongLong((uint32_t)(object->openfiles));
	return py_openfiles;
}

static int py_srvsvc_NetSrvInfo403_set_openfiles(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->openfiles");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->openfiles));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->openfiles = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_sessopen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessopen;
	py_sessopen = PyLong_FromUnsignedLongLong((uint32_t)(object->sessopen));
	return py_sessopen;
}

static int py_srvsvc_NetSrvInfo403_set_sessopen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessopen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessopen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessopen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_sesssvc(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_sesssvc;
	py_sesssvc = PyLong_FromUnsignedLongLong((uint32_t)(object->sesssvc));
	return py_sesssvc;
}

static int py_srvsvc_NetSrvInfo403_set_sesssvc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sesssvc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sesssvc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sesssvc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_sessreqs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessreqs;
	py_sessreqs = PyLong_FromUnsignedLongLong((uint32_t)(object->sessreqs));
	return py_sessreqs;
}

static int py_srvsvc_NetSrvInfo403_set_sessreqs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessreqs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessreqs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessreqs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_opensearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_opensearch;
	py_opensearch = PyLong_FromUnsignedLongLong((uint32_t)(object->opensearch));
	return py_opensearch;
}

static int py_srvsvc_NetSrvInfo403_set_opensearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opensearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opensearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opensearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_activelocks(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_activelocks;
	py_activelocks = PyLong_FromUnsignedLongLong((uint32_t)(object->activelocks));
	return py_activelocks;
}

static int py_srvsvc_NetSrvInfo403_set_activelocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->activelocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->activelocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->activelocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_numreqbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_numreqbufs;
	py_numreqbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->numreqbufs));
	return py_numreqbufs;
}

static int py_srvsvc_NetSrvInfo403_set_numreqbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numreqbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numreqbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numreqbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_sizereqbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_sizereqbufs;
	py_sizereqbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->sizereqbufs));
	return py_sizereqbufs;
}

static int py_srvsvc_NetSrvInfo403_set_sizereqbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sizereqbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sizereqbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sizereqbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_numbigbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_numbigbufs;
	py_numbigbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->numbigbufs));
	return py_numbigbufs;
}

static int py_srvsvc_NetSrvInfo403_set_numbigbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numbigbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numbigbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numbigbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_numfiletasks(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_numfiletasks;
	py_numfiletasks = PyLong_FromUnsignedLongLong((uint32_t)(object->numfiletasks));
	return py_numfiletasks;
}

static int py_srvsvc_NetSrvInfo403_set_numfiletasks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numfiletasks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numfiletasks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numfiletasks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_alertsched(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_alertsched;
	py_alertsched = PyLong_FromUnsignedLongLong((uint32_t)(object->alertsched));
	return py_alertsched;
}

static int py_srvsvc_NetSrvInfo403_set_alertsched(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alertsched");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alertsched));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alertsched = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_erroralert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_erroralert;
	py_erroralert = PyLong_FromUnsignedLongLong((uint32_t)(object->erroralert));
	return py_erroralert;
}

static int py_srvsvc_NetSrvInfo403_set_erroralert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->erroralert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->erroralert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->erroralert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_logonalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_logonalert;
	py_logonalert = PyLong_FromUnsignedLongLong((uint32_t)(object->logonalert));
	return py_logonalert;
}

static int py_srvsvc_NetSrvInfo403_set_logonalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logonalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logonalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logonalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_accessalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_accessalert;
	py_accessalert = PyLong_FromUnsignedLongLong((uint32_t)(object->accessalert));
	return py_accessalert;
}

static int py_srvsvc_NetSrvInfo403_set_accessalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->accessalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->accessalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->accessalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_diskalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_diskalert;
	py_diskalert = PyLong_FromUnsignedLongLong((uint32_t)(object->diskalert));
	return py_diskalert;
}

static int py_srvsvc_NetSrvInfo403_set_diskalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->diskalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->diskalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->diskalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_netioalert(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_netioalert;
	py_netioalert = PyLong_FromUnsignedLongLong((uint32_t)(object->netioalert));
	return py_netioalert;
}

static int py_srvsvc_NetSrvInfo403_set_netioalert(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->netioalert");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->netioalert));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->netioalert = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_maxaudits(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxaudits;
	py_maxaudits = PyLong_FromUnsignedLongLong((uint32_t)(object->maxaudits));
	return py_maxaudits;
}

static int py_srvsvc_NetSrvInfo403_set_maxaudits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxaudits");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxaudits));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxaudits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_srvheuristics(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_srvheuristics;
	if (object->srvheuristics == NULL) {
		Py_RETURN_NONE;
	}
	if (object->srvheuristics == NULL) {
		py_srvheuristics = Py_None;
		Py_INCREF(py_srvheuristics);
	} else {
		if (object->srvheuristics == NULL) {
			py_srvheuristics = Py_None;
			Py_INCREF(py_srvheuristics);
		} else {
			py_srvheuristics = PyUnicode_Decode(object->srvheuristics, strlen(object->srvheuristics), "utf-8", "ignore");
		}
	}
	return py_srvheuristics;
}

static int py_srvsvc_NetSrvInfo403_set_srvheuristics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->srvheuristics");
		return -1;
	}
	if (value == Py_None) {
		object->srvheuristics = NULL;
	} else {
		object->srvheuristics = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->srvheuristics = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_auditedevents(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_auditedevents;
	py_auditedevents = PyLong_FromUnsignedLongLong((uint32_t)(object->auditedevents));
	return py_auditedevents;
}

static int py_srvsvc_NetSrvInfo403_set_auditedevents(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auditedevents");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auditedevents));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auditedevents = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_auditprofile(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_auditprofile;
	py_auditprofile = PyLong_FromUnsignedLongLong((uint32_t)(object->auditprofile));
	return py_auditprofile;
}

static int py_srvsvc_NetSrvInfo403_set_auditprofile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auditprofile");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auditprofile));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auditprofile = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo403_get_autopath(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(obj);
	PyObject *py_autopath;
	if (object->autopath == NULL) {
		Py_RETURN_NONE;
	}
	if (object->autopath == NULL) {
		py_autopath = Py_None;
		Py_INCREF(py_autopath);
	} else {
		if (object->autopath == NULL) {
			py_autopath = Py_None;
			Py_INCREF(py_autopath);
		} else {
			py_autopath = PyUnicode_Decode(object->autopath, strlen(object->autopath), "utf-8", "ignore");
		}
	}
	return py_autopath;
}

static int py_srvsvc_NetSrvInfo403_set_autopath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo403 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->autopath");
		return -1;
	}
	if (value == Py_None) {
		object->autopath = NULL;
	} else {
		object->autopath = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->autopath = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo403_getsetters[] = {
	{
		.name = discard_const_p(char, "ulist_mtime"),
		.get = py_srvsvc_NetSrvInfo403_get_ulist_mtime,
		.set = py_srvsvc_NetSrvInfo403_set_ulist_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "glist_mtime"),
		.get = py_srvsvc_NetSrvInfo403_get_glist_mtime,
		.set = py_srvsvc_NetSrvInfo403_set_glist_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alist_mtime"),
		.get = py_srvsvc_NetSrvInfo403_get_alist_mtime,
		.set = py_srvsvc_NetSrvInfo403_set_alist_mtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alerts"),
		.get = py_srvsvc_NetSrvInfo403_get_alerts,
		.set = py_srvsvc_NetSrvInfo403_set_alerts,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "security"),
		.get = py_srvsvc_NetSrvInfo403_get_security,
		.set = py_srvsvc_NetSrvInfo403_set_security,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numadmin"),
		.get = py_srvsvc_NetSrvInfo403_get_numadmin,
		.set = py_srvsvc_NetSrvInfo403_set_numadmin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lanmask"),
		.get = py_srvsvc_NetSrvInfo403_get_lanmask,
		.set = py_srvsvc_NetSrvInfo403_set_lanmask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "guestaccount"),
		.get = py_srvsvc_NetSrvInfo403_get_guestaccount,
		.set = py_srvsvc_NetSrvInfo403_set_guestaccount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "chdevs"),
		.get = py_srvsvc_NetSrvInfo403_get_chdevs,
		.set = py_srvsvc_NetSrvInfo403_set_chdevs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "chdevqs"),
		.get = py_srvsvc_NetSrvInfo403_get_chdevqs,
		.set = py_srvsvc_NetSrvInfo403_set_chdevqs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "chdevjobs"),
		.get = py_srvsvc_NetSrvInfo403_get_chdevjobs,
		.set = py_srvsvc_NetSrvInfo403_set_chdevjobs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "connections"),
		.get = py_srvsvc_NetSrvInfo403_get_connections,
		.set = py_srvsvc_NetSrvInfo403_set_connections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "shares"),
		.get = py_srvsvc_NetSrvInfo403_get_shares,
		.set = py_srvsvc_NetSrvInfo403_set_shares,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "openfiles"),
		.get = py_srvsvc_NetSrvInfo403_get_openfiles,
		.set = py_srvsvc_NetSrvInfo403_set_openfiles,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessopen"),
		.get = py_srvsvc_NetSrvInfo403_get_sessopen,
		.set = py_srvsvc_NetSrvInfo403_set_sessopen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sesssvc"),
		.get = py_srvsvc_NetSrvInfo403_get_sesssvc,
		.set = py_srvsvc_NetSrvInfo403_set_sesssvc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessreqs"),
		.get = py_srvsvc_NetSrvInfo403_get_sessreqs,
		.set = py_srvsvc_NetSrvInfo403_set_sessreqs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "opensearch"),
		.get = py_srvsvc_NetSrvInfo403_get_opensearch,
		.set = py_srvsvc_NetSrvInfo403_set_opensearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "activelocks"),
		.get = py_srvsvc_NetSrvInfo403_get_activelocks,
		.set = py_srvsvc_NetSrvInfo403_set_activelocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numreqbufs"),
		.get = py_srvsvc_NetSrvInfo403_get_numreqbufs,
		.set = py_srvsvc_NetSrvInfo403_set_numreqbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sizereqbufs"),
		.get = py_srvsvc_NetSrvInfo403_get_sizereqbufs,
		.set = py_srvsvc_NetSrvInfo403_set_sizereqbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numbigbufs"),
		.get = py_srvsvc_NetSrvInfo403_get_numbigbufs,
		.set = py_srvsvc_NetSrvInfo403_set_numbigbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numfiletasks"),
		.get = py_srvsvc_NetSrvInfo403_get_numfiletasks,
		.set = py_srvsvc_NetSrvInfo403_set_numfiletasks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alertsched"),
		.get = py_srvsvc_NetSrvInfo403_get_alertsched,
		.set = py_srvsvc_NetSrvInfo403_set_alertsched,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "erroralert"),
		.get = py_srvsvc_NetSrvInfo403_get_erroralert,
		.set = py_srvsvc_NetSrvInfo403_set_erroralert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "logonalert"),
		.get = py_srvsvc_NetSrvInfo403_get_logonalert,
		.set = py_srvsvc_NetSrvInfo403_set_logonalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "accessalert"),
		.get = py_srvsvc_NetSrvInfo403_get_accessalert,
		.set = py_srvsvc_NetSrvInfo403_set_accessalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "diskalert"),
		.get = py_srvsvc_NetSrvInfo403_get_diskalert,
		.set = py_srvsvc_NetSrvInfo403_set_diskalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "netioalert"),
		.get = py_srvsvc_NetSrvInfo403_get_netioalert,
		.set = py_srvsvc_NetSrvInfo403_set_netioalert,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxaudits"),
		.get = py_srvsvc_NetSrvInfo403_get_maxaudits,
		.set = py_srvsvc_NetSrvInfo403_set_maxaudits,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "srvheuristics"),
		.get = py_srvsvc_NetSrvInfo403_get_srvheuristics,
		.set = py_srvsvc_NetSrvInfo403_set_srvheuristics,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "auditedevents"),
		.get = py_srvsvc_NetSrvInfo403_get_auditedevents,
		.set = py_srvsvc_NetSrvInfo403_set_auditedevents,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "auditprofile"),
		.get = py_srvsvc_NetSrvInfo403_get_auditprofile,
		.set = py_srvsvc_NetSrvInfo403_set_auditprofile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "autopath"),
		.get = py_srvsvc_NetSrvInfo403_get_autopath,
		.set = py_srvsvc_NetSrvInfo403_set_autopath,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo403_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo403, type);
}


static PyTypeObject srvsvc_NetSrvInfo403_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo403",
	.tp_getset = py_srvsvc_NetSrvInfo403_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo403_new,
};


static PyObject *py_srvsvc_NetSrvInfo502_get_sessopen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessopen;
	py_sessopen = PyLong_FromUnsignedLongLong((uint32_t)(object->sessopen));
	return py_sessopen;
}

static int py_srvsvc_NetSrvInfo502_set_sessopen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessopen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessopen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessopen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_sesssvc(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_sesssvc;
	py_sesssvc = PyLong_FromUnsignedLongLong((uint32_t)(object->sesssvc));
	return py_sesssvc;
}

static int py_srvsvc_NetSrvInfo502_set_sesssvc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sesssvc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sesssvc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sesssvc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_opensearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_opensearch;
	py_opensearch = PyLong_FromUnsignedLongLong((uint32_t)(object->opensearch));
	return py_opensearch;
}

static int py_srvsvc_NetSrvInfo502_set_opensearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opensearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opensearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opensearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_sizereqbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_sizereqbufs;
	py_sizereqbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->sizereqbufs));
	return py_sizereqbufs;
}

static int py_srvsvc_NetSrvInfo502_set_sizereqbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sizereqbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sizereqbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sizereqbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_initworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_initworkitems;
	py_initworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->initworkitems));
	return py_initworkitems;
}

static int py_srvsvc_NetSrvInfo502_set_initworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_maxworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxworkitems;
	py_maxworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->maxworkitems));
	return py_maxworkitems;
}

static int py_srvsvc_NetSrvInfo502_set_maxworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_rawworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_rawworkitems;
	py_rawworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->rawworkitems));
	return py_rawworkitems;
}

static int py_srvsvc_NetSrvInfo502_set_rawworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rawworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rawworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rawworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_irpstacksize(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_irpstacksize;
	py_irpstacksize = PyLong_FromUnsignedLongLong((uint32_t)(object->irpstacksize));
	return py_irpstacksize;
}

static int py_srvsvc_NetSrvInfo502_set_irpstacksize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->irpstacksize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->irpstacksize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->irpstacksize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_maxrawbuflen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxrawbuflen;
	py_maxrawbuflen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxrawbuflen));
	return py_maxrawbuflen;
}

static int py_srvsvc_NetSrvInfo502_set_maxrawbuflen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxrawbuflen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxrawbuflen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxrawbuflen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_sessusers(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessusers;
	py_sessusers = PyLong_FromUnsignedLongLong((uint32_t)(object->sessusers));
	return py_sessusers;
}

static int py_srvsvc_NetSrvInfo502_set_sessusers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessusers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessusers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessusers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_sessconns(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessconns;
	py_sessconns = PyLong_FromUnsignedLongLong((uint32_t)(object->sessconns));
	return py_sessconns;
}

static int py_srvsvc_NetSrvInfo502_set_sessconns(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessconns");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessconns));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessconns = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_maxpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxpagedmemoryusage;
	py_maxpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxpagedmemoryusage));
	return py_maxpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo502_set_maxpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_maxnonpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxnonpagedmemoryusage;
	py_maxnonpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxnonpagedmemoryusage));
	return py_maxnonpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo502_set_maxnonpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxnonpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxnonpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxnonpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_enablesoftcompat(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablesoftcompat;
	py_enablesoftcompat = PyLong_FromUnsignedLongLong((uint32_t)(object->enablesoftcompat));
	return py_enablesoftcompat;
}

static int py_srvsvc_NetSrvInfo502_set_enablesoftcompat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablesoftcompat");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablesoftcompat));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablesoftcompat = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_enableforcedlogoff(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableforcedlogoff;
	py_enableforcedlogoff = PyLong_FromUnsignedLongLong((uint32_t)(object->enableforcedlogoff));
	return py_enableforcedlogoff;
}

static int py_srvsvc_NetSrvInfo502_set_enableforcedlogoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableforcedlogoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableforcedlogoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableforcedlogoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_timesource(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_timesource;
	py_timesource = PyLong_FromUnsignedLongLong((uint32_t)(object->timesource));
	return py_timesource;
}

static int py_srvsvc_NetSrvInfo502_set_timesource(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timesource");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timesource));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timesource = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_acceptdownlevelapis(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_acceptdownlevelapis;
	py_acceptdownlevelapis = PyLong_FromUnsignedLongLong((uint32_t)(object->acceptdownlevelapis));
	return py_acceptdownlevelapis;
}

static int py_srvsvc_NetSrvInfo502_set_acceptdownlevelapis(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acceptdownlevelapis");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acceptdownlevelapis));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acceptdownlevelapis = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo502_get_lmannounce(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(obj);
	PyObject *py_lmannounce;
	py_lmannounce = PyLong_FromUnsignedLongLong((uint32_t)(object->lmannounce));
	return py_lmannounce;
}

static int py_srvsvc_NetSrvInfo502_set_lmannounce(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmannounce");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmannounce));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmannounce = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo502_getsetters[] = {
	{
		.name = discard_const_p(char, "sessopen"),
		.get = py_srvsvc_NetSrvInfo502_get_sessopen,
		.set = py_srvsvc_NetSrvInfo502_set_sessopen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sesssvc"),
		.get = py_srvsvc_NetSrvInfo502_get_sesssvc,
		.set = py_srvsvc_NetSrvInfo502_set_sesssvc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "opensearch"),
		.get = py_srvsvc_NetSrvInfo502_get_opensearch,
		.set = py_srvsvc_NetSrvInfo502_set_opensearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sizereqbufs"),
		.get = py_srvsvc_NetSrvInfo502_get_sizereqbufs,
		.set = py_srvsvc_NetSrvInfo502_set_sizereqbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "initworkitems"),
		.get = py_srvsvc_NetSrvInfo502_get_initworkitems,
		.set = py_srvsvc_NetSrvInfo502_set_initworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxworkitems"),
		.get = py_srvsvc_NetSrvInfo502_get_maxworkitems,
		.set = py_srvsvc_NetSrvInfo502_set_maxworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rawworkitems"),
		.get = py_srvsvc_NetSrvInfo502_get_rawworkitems,
		.set = py_srvsvc_NetSrvInfo502_set_rawworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "irpstacksize"),
		.get = py_srvsvc_NetSrvInfo502_get_irpstacksize,
		.set = py_srvsvc_NetSrvInfo502_set_irpstacksize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxrawbuflen"),
		.get = py_srvsvc_NetSrvInfo502_get_maxrawbuflen,
		.set = py_srvsvc_NetSrvInfo502_set_maxrawbuflen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessusers"),
		.get = py_srvsvc_NetSrvInfo502_get_sessusers,
		.set = py_srvsvc_NetSrvInfo502_set_sessusers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessconns"),
		.get = py_srvsvc_NetSrvInfo502_get_sessconns,
		.set = py_srvsvc_NetSrvInfo502_set_sessconns,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo502_get_maxpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo502_set_maxpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxnonpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo502_get_maxnonpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo502_set_maxnonpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enablesoftcompat"),
		.get = py_srvsvc_NetSrvInfo502_get_enablesoftcompat,
		.set = py_srvsvc_NetSrvInfo502_set_enablesoftcompat,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableforcedlogoff"),
		.get = py_srvsvc_NetSrvInfo502_get_enableforcedlogoff,
		.set = py_srvsvc_NetSrvInfo502_set_enableforcedlogoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "timesource"),
		.get = py_srvsvc_NetSrvInfo502_get_timesource,
		.set = py_srvsvc_NetSrvInfo502_set_timesource,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "acceptdownlevelapis"),
		.get = py_srvsvc_NetSrvInfo502_get_acceptdownlevelapis,
		.set = py_srvsvc_NetSrvInfo502_set_acceptdownlevelapis,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lmannounce"),
		.get = py_srvsvc_NetSrvInfo502_get_lmannounce,
		.set = py_srvsvc_NetSrvInfo502_set_lmannounce,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo502_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo502, type);
}


static PyTypeObject srvsvc_NetSrvInfo502_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo502",
	.tp_getset = py_srvsvc_NetSrvInfo502_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo502_new,
};


static PyObject *py_srvsvc_NetSrvInfo503_get_sessopen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessopen;
	py_sessopen = PyLong_FromUnsignedLongLong((uint32_t)(object->sessopen));
	return py_sessopen;
}

static int py_srvsvc_NetSrvInfo503_set_sessopen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessopen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessopen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessopen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_sesssvc(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_sesssvc;
	py_sesssvc = PyLong_FromUnsignedLongLong((uint32_t)(object->sesssvc));
	return py_sesssvc;
}

static int py_srvsvc_NetSrvInfo503_set_sesssvc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sesssvc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sesssvc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sesssvc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_opensearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_opensearch;
	py_opensearch = PyLong_FromUnsignedLongLong((uint32_t)(object->opensearch));
	return py_opensearch;
}

static int py_srvsvc_NetSrvInfo503_set_opensearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opensearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opensearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opensearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_sizereqbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_sizereqbufs;
	py_sizereqbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->sizereqbufs));
	return py_sizereqbufs;
}

static int py_srvsvc_NetSrvInfo503_set_sizereqbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sizereqbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sizereqbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sizereqbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_initworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_initworkitems;
	py_initworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->initworkitems));
	return py_initworkitems;
}

static int py_srvsvc_NetSrvInfo503_set_initworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxworkitems;
	py_maxworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->maxworkitems));
	return py_maxworkitems;
}

static int py_srvsvc_NetSrvInfo503_set_maxworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_rawworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_rawworkitems;
	py_rawworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->rawworkitems));
	return py_rawworkitems;
}

static int py_srvsvc_NetSrvInfo503_set_rawworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rawworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rawworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rawworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_irpstacksize(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_irpstacksize;
	py_irpstacksize = PyLong_FromUnsignedLongLong((uint32_t)(object->irpstacksize));
	return py_irpstacksize;
}

static int py_srvsvc_NetSrvInfo503_set_irpstacksize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->irpstacksize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->irpstacksize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->irpstacksize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxrawbuflen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxrawbuflen;
	py_maxrawbuflen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxrawbuflen));
	return py_maxrawbuflen;
}

static int py_srvsvc_NetSrvInfo503_set_maxrawbuflen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxrawbuflen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxrawbuflen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxrawbuflen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_sessusers(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessusers;
	py_sessusers = PyLong_FromUnsignedLongLong((uint32_t)(object->sessusers));
	return py_sessusers;
}

static int py_srvsvc_NetSrvInfo503_set_sessusers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessusers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessusers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessusers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_sessconns(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessconns;
	py_sessconns = PyLong_FromUnsignedLongLong((uint32_t)(object->sessconns));
	return py_sessconns;
}

static int py_srvsvc_NetSrvInfo503_set_sessconns(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessconns");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessconns));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessconns = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxpagedmemoryusage;
	py_maxpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxpagedmemoryusage));
	return py_maxpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo503_set_maxpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxnonpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxnonpagedmemoryusage;
	py_maxnonpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxnonpagedmemoryusage));
	return py_maxnonpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo503_set_maxnonpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxnonpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxnonpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxnonpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_enablesoftcompat(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablesoftcompat;
	py_enablesoftcompat = PyLong_FromUnsignedLongLong((uint32_t)(object->enablesoftcompat));
	return py_enablesoftcompat;
}

static int py_srvsvc_NetSrvInfo503_set_enablesoftcompat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablesoftcompat");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablesoftcompat));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablesoftcompat = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_enableforcedlogoff(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableforcedlogoff;
	py_enableforcedlogoff = PyLong_FromUnsignedLongLong((uint32_t)(object->enableforcedlogoff));
	return py_enableforcedlogoff;
}

static int py_srvsvc_NetSrvInfo503_set_enableforcedlogoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableforcedlogoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableforcedlogoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableforcedlogoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_timesource(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_timesource;
	py_timesource = PyLong_FromUnsignedLongLong((uint32_t)(object->timesource));
	return py_timesource;
}

static int py_srvsvc_NetSrvInfo503_set_timesource(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timesource");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timesource));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timesource = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_acceptdownlevelapis(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_acceptdownlevelapis;
	py_acceptdownlevelapis = PyLong_FromUnsignedLongLong((uint32_t)(object->acceptdownlevelapis));
	return py_acceptdownlevelapis;
}

static int py_srvsvc_NetSrvInfo503_set_acceptdownlevelapis(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acceptdownlevelapis");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acceptdownlevelapis));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acceptdownlevelapis = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_lmannounce(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_lmannounce;
	py_lmannounce = PyLong_FromUnsignedLongLong((uint32_t)(object->lmannounce));
	return py_lmannounce;
}

static int py_srvsvc_NetSrvInfo503_set_lmannounce(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmannounce");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmannounce));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmannounce = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_domain(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (object->domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_srvsvc_NetSrvInfo503_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxcopyreadlen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxcopyreadlen;
	py_maxcopyreadlen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxcopyreadlen));
	return py_maxcopyreadlen;
}

static int py_srvsvc_NetSrvInfo503_set_maxcopyreadlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxcopyreadlen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxcopyreadlen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxcopyreadlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxcopywritelen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxcopywritelen;
	py_maxcopywritelen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxcopywritelen));
	return py_maxcopywritelen;
}

static int py_srvsvc_NetSrvInfo503_set_maxcopywritelen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxcopywritelen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxcopywritelen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxcopywritelen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_minkeepsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_minkeepsearch;
	py_minkeepsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->minkeepsearch));
	return py_minkeepsearch;
}

static int py_srvsvc_NetSrvInfo503_set_minkeepsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minkeepsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minkeepsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minkeepsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxkeepsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxkeepsearch;
	py_maxkeepsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->maxkeepsearch));
	return py_maxkeepsearch;
}

static int py_srvsvc_NetSrvInfo503_set_maxkeepsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxkeepsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxkeepsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxkeepsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_minkeepcomplsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_minkeepcomplsearch;
	py_minkeepcomplsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->minkeepcomplsearch));
	return py_minkeepcomplsearch;
}

static int py_srvsvc_NetSrvInfo503_set_minkeepcomplsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minkeepcomplsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minkeepcomplsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minkeepcomplsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxkeepcomplsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxkeepcomplsearch;
	py_maxkeepcomplsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->maxkeepcomplsearch));
	return py_maxkeepcomplsearch;
}

static int py_srvsvc_NetSrvInfo503_set_maxkeepcomplsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxkeepcomplsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxkeepcomplsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxkeepcomplsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_threadcountadd(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_threadcountadd;
	py_threadcountadd = PyLong_FromUnsignedLongLong((uint32_t)(object->threadcountadd));
	return py_threadcountadd;
}

static int py_srvsvc_NetSrvInfo503_set_threadcountadd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->threadcountadd");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->threadcountadd));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->threadcountadd = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_numlockthreads(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_numlockthreads;
	py_numlockthreads = PyLong_FromUnsignedLongLong((uint32_t)(object->numlockthreads));
	return py_numlockthreads;
}

static int py_srvsvc_NetSrvInfo503_set_numlockthreads(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numlockthreads");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numlockthreads));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numlockthreads = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_scavtimeout(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_scavtimeout;
	py_scavtimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->scavtimeout));
	return py_scavtimeout;
}

static int py_srvsvc_NetSrvInfo503_set_scavtimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scavtimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->scavtimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->scavtimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_minrcvqueue(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_minrcvqueue;
	py_minrcvqueue = PyLong_FromUnsignedLongLong((uint32_t)(object->minrcvqueue));
	return py_minrcvqueue;
}

static int py_srvsvc_NetSrvInfo503_set_minrcvqueue(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minrcvqueue");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minrcvqueue));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minrcvqueue = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_minfreeworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_minfreeworkitems;
	py_minfreeworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->minfreeworkitems));
	return py_minfreeworkitems;
}

static int py_srvsvc_NetSrvInfo503_set_minfreeworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minfreeworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minfreeworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minfreeworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_xactmemsize(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_xactmemsize;
	py_xactmemsize = PyLong_FromUnsignedLongLong((uint32_t)(object->xactmemsize));
	return py_xactmemsize;
}

static int py_srvsvc_NetSrvInfo503_set_xactmemsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->xactmemsize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->xactmemsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->xactmemsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_threadpriority(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_threadpriority;
	py_threadpriority = PyLong_FromUnsignedLongLong((uint32_t)(object->threadpriority));
	return py_threadpriority;
}

static int py_srvsvc_NetSrvInfo503_set_threadpriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->threadpriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->threadpriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->threadpriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxmpxct(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxmpxct;
	py_maxmpxct = PyLong_FromUnsignedLongLong((uint32_t)(object->maxmpxct));
	return py_maxmpxct;
}

static int py_srvsvc_NetSrvInfo503_set_maxmpxct(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxmpxct");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxmpxct));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxmpxct = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_oplockbreakwait(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_oplockbreakwait;
	py_oplockbreakwait = PyLong_FromUnsignedLongLong((uint32_t)(object->oplockbreakwait));
	return py_oplockbreakwait;
}

static int py_srvsvc_NetSrvInfo503_set_oplockbreakwait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oplockbreakwait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->oplockbreakwait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->oplockbreakwait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_oplockbreakresponsewait(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_oplockbreakresponsewait;
	py_oplockbreakresponsewait = PyLong_FromUnsignedLongLong((uint32_t)(object->oplockbreakresponsewait));
	return py_oplockbreakresponsewait;
}

static int py_srvsvc_NetSrvInfo503_set_oplockbreakresponsewait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oplockbreakresponsewait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->oplockbreakresponsewait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->oplockbreakresponsewait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_enableoplocks(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableoplocks;
	py_enableoplocks = PyLong_FromUnsignedLongLong((uint32_t)(object->enableoplocks));
	return py_enableoplocks;
}

static int py_srvsvc_NetSrvInfo503_set_enableoplocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableoplocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableoplocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableoplocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_enableoplockforceclose(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableoplockforceclose;
	py_enableoplockforceclose = PyLong_FromUnsignedLongLong((uint32_t)(object->enableoplockforceclose));
	return py_enableoplockforceclose;
}

static int py_srvsvc_NetSrvInfo503_set_enableoplockforceclose(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableoplockforceclose");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableoplockforceclose));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableoplockforceclose = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_enablefcbopens(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablefcbopens;
	py_enablefcbopens = PyLong_FromUnsignedLongLong((uint32_t)(object->enablefcbopens));
	return py_enablefcbopens;
}

static int py_srvsvc_NetSrvInfo503_set_enablefcbopens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablefcbopens");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablefcbopens));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablefcbopens = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_enableraw(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableraw;
	py_enableraw = PyLong_FromUnsignedLongLong((uint32_t)(object->enableraw));
	return py_enableraw;
}

static int py_srvsvc_NetSrvInfo503_set_enableraw(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableraw");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableraw));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableraw = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_enablesharednetdrives(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablesharednetdrives;
	py_enablesharednetdrives = PyLong_FromUnsignedLongLong((uint32_t)(object->enablesharednetdrives));
	return py_enablesharednetdrives;
}

static int py_srvsvc_NetSrvInfo503_set_enablesharednetdrives(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablesharednetdrives");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablesharednetdrives));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablesharednetdrives = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_minfreeconnections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_minfreeconnections;
	py_minfreeconnections = PyLong_FromUnsignedLongLong((uint32_t)(object->minfreeconnections));
	return py_minfreeconnections;
}

static int py_srvsvc_NetSrvInfo503_set_minfreeconnections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minfreeconnections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minfreeconnections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minfreeconnections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo503_get_maxfreeconnections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxfreeconnections;
	py_maxfreeconnections = PyLong_FromUnsignedLongLong((uint32_t)(object->maxfreeconnections));
	return py_maxfreeconnections;
}

static int py_srvsvc_NetSrvInfo503_set_maxfreeconnections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxfreeconnections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxfreeconnections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxfreeconnections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo503_getsetters[] = {
	{
		.name = discard_const_p(char, "sessopen"),
		.get = py_srvsvc_NetSrvInfo503_get_sessopen,
		.set = py_srvsvc_NetSrvInfo503_set_sessopen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sesssvc"),
		.get = py_srvsvc_NetSrvInfo503_get_sesssvc,
		.set = py_srvsvc_NetSrvInfo503_set_sesssvc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "opensearch"),
		.get = py_srvsvc_NetSrvInfo503_get_opensearch,
		.set = py_srvsvc_NetSrvInfo503_set_opensearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sizereqbufs"),
		.get = py_srvsvc_NetSrvInfo503_get_sizereqbufs,
		.set = py_srvsvc_NetSrvInfo503_set_sizereqbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "initworkitems"),
		.get = py_srvsvc_NetSrvInfo503_get_initworkitems,
		.set = py_srvsvc_NetSrvInfo503_set_initworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxworkitems"),
		.get = py_srvsvc_NetSrvInfo503_get_maxworkitems,
		.set = py_srvsvc_NetSrvInfo503_set_maxworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rawworkitems"),
		.get = py_srvsvc_NetSrvInfo503_get_rawworkitems,
		.set = py_srvsvc_NetSrvInfo503_set_rawworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "irpstacksize"),
		.get = py_srvsvc_NetSrvInfo503_get_irpstacksize,
		.set = py_srvsvc_NetSrvInfo503_set_irpstacksize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxrawbuflen"),
		.get = py_srvsvc_NetSrvInfo503_get_maxrawbuflen,
		.set = py_srvsvc_NetSrvInfo503_set_maxrawbuflen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessusers"),
		.get = py_srvsvc_NetSrvInfo503_get_sessusers,
		.set = py_srvsvc_NetSrvInfo503_set_sessusers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessconns"),
		.get = py_srvsvc_NetSrvInfo503_get_sessconns,
		.set = py_srvsvc_NetSrvInfo503_set_sessconns,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo503_get_maxpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo503_set_maxpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxnonpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo503_get_maxnonpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo503_set_maxnonpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enablesoftcompat"),
		.get = py_srvsvc_NetSrvInfo503_get_enablesoftcompat,
		.set = py_srvsvc_NetSrvInfo503_set_enablesoftcompat,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableforcedlogoff"),
		.get = py_srvsvc_NetSrvInfo503_get_enableforcedlogoff,
		.set = py_srvsvc_NetSrvInfo503_set_enableforcedlogoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "timesource"),
		.get = py_srvsvc_NetSrvInfo503_get_timesource,
		.set = py_srvsvc_NetSrvInfo503_set_timesource,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "acceptdownlevelapis"),
		.get = py_srvsvc_NetSrvInfo503_get_acceptdownlevelapis,
		.set = py_srvsvc_NetSrvInfo503_set_acceptdownlevelapis,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lmannounce"),
		.get = py_srvsvc_NetSrvInfo503_get_lmannounce,
		.set = py_srvsvc_NetSrvInfo503_set_lmannounce,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_srvsvc_NetSrvInfo503_get_domain,
		.set = py_srvsvc_NetSrvInfo503_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "maxcopyreadlen"),
		.get = py_srvsvc_NetSrvInfo503_get_maxcopyreadlen,
		.set = py_srvsvc_NetSrvInfo503_set_maxcopyreadlen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxcopywritelen"),
		.get = py_srvsvc_NetSrvInfo503_get_maxcopywritelen,
		.set = py_srvsvc_NetSrvInfo503_set_maxcopywritelen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minkeepsearch"),
		.get = py_srvsvc_NetSrvInfo503_get_minkeepsearch,
		.set = py_srvsvc_NetSrvInfo503_set_minkeepsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxkeepsearch"),
		.get = py_srvsvc_NetSrvInfo503_get_maxkeepsearch,
		.set = py_srvsvc_NetSrvInfo503_set_maxkeepsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minkeepcomplsearch"),
		.get = py_srvsvc_NetSrvInfo503_get_minkeepcomplsearch,
		.set = py_srvsvc_NetSrvInfo503_set_minkeepcomplsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxkeepcomplsearch"),
		.get = py_srvsvc_NetSrvInfo503_get_maxkeepcomplsearch,
		.set = py_srvsvc_NetSrvInfo503_set_maxkeepcomplsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "threadcountadd"),
		.get = py_srvsvc_NetSrvInfo503_get_threadcountadd,
		.set = py_srvsvc_NetSrvInfo503_set_threadcountadd,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numlockthreads"),
		.get = py_srvsvc_NetSrvInfo503_get_numlockthreads,
		.set = py_srvsvc_NetSrvInfo503_set_numlockthreads,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "scavtimeout"),
		.get = py_srvsvc_NetSrvInfo503_get_scavtimeout,
		.set = py_srvsvc_NetSrvInfo503_set_scavtimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minrcvqueue"),
		.get = py_srvsvc_NetSrvInfo503_get_minrcvqueue,
		.set = py_srvsvc_NetSrvInfo503_set_minrcvqueue,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minfreeworkitems"),
		.get = py_srvsvc_NetSrvInfo503_get_minfreeworkitems,
		.set = py_srvsvc_NetSrvInfo503_set_minfreeworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "xactmemsize"),
		.get = py_srvsvc_NetSrvInfo503_get_xactmemsize,
		.set = py_srvsvc_NetSrvInfo503_set_xactmemsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "threadpriority"),
		.get = py_srvsvc_NetSrvInfo503_get_threadpriority,
		.set = py_srvsvc_NetSrvInfo503_set_threadpriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxmpxct"),
		.get = py_srvsvc_NetSrvInfo503_get_maxmpxct,
		.set = py_srvsvc_NetSrvInfo503_set_maxmpxct,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "oplockbreakwait"),
		.get = py_srvsvc_NetSrvInfo503_get_oplockbreakwait,
		.set = py_srvsvc_NetSrvInfo503_set_oplockbreakwait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "oplockbreakresponsewait"),
		.get = py_srvsvc_NetSrvInfo503_get_oplockbreakresponsewait,
		.set = py_srvsvc_NetSrvInfo503_set_oplockbreakresponsewait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableoplocks"),
		.get = py_srvsvc_NetSrvInfo503_get_enableoplocks,
		.set = py_srvsvc_NetSrvInfo503_set_enableoplocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableoplockforceclose"),
		.get = py_srvsvc_NetSrvInfo503_get_enableoplockforceclose,
		.set = py_srvsvc_NetSrvInfo503_set_enableoplockforceclose,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enablefcbopens"),
		.get = py_srvsvc_NetSrvInfo503_get_enablefcbopens,
		.set = py_srvsvc_NetSrvInfo503_set_enablefcbopens,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableraw"),
		.get = py_srvsvc_NetSrvInfo503_get_enableraw,
		.set = py_srvsvc_NetSrvInfo503_set_enableraw,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enablesharednetdrives"),
		.get = py_srvsvc_NetSrvInfo503_get_enablesharednetdrives,
		.set = py_srvsvc_NetSrvInfo503_set_enablesharednetdrives,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minfreeconnections"),
		.get = py_srvsvc_NetSrvInfo503_get_minfreeconnections,
		.set = py_srvsvc_NetSrvInfo503_set_minfreeconnections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxfreeconnections"),
		.get = py_srvsvc_NetSrvInfo503_get_maxfreeconnections,
		.set = py_srvsvc_NetSrvInfo503_set_maxfreeconnections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo503_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo503, type);
}


static PyTypeObject srvsvc_NetSrvInfo503_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo503",
	.tp_getset = py_srvsvc_NetSrvInfo503_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo503_new,
};


static PyObject *py_srvsvc_NetSrvInfo599_get_sessopen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessopen;
	py_sessopen = PyLong_FromUnsignedLongLong((uint32_t)(object->sessopen));
	return py_sessopen;
}

static int py_srvsvc_NetSrvInfo599_set_sessopen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessopen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessopen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessopen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_sesssvc(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_sesssvc;
	py_sesssvc = PyLong_FromUnsignedLongLong((uint32_t)(object->sesssvc));
	return py_sesssvc;
}

static int py_srvsvc_NetSrvInfo599_set_sesssvc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sesssvc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sesssvc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sesssvc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_opensearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_opensearch;
	py_opensearch = PyLong_FromUnsignedLongLong((uint32_t)(object->opensearch));
	return py_opensearch;
}

static int py_srvsvc_NetSrvInfo599_set_opensearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opensearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opensearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opensearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_sizereqbufs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_sizereqbufs;
	py_sizereqbufs = PyLong_FromUnsignedLongLong((uint32_t)(object->sizereqbufs));
	return py_sizereqbufs;
}

static int py_srvsvc_NetSrvInfo599_set_sizereqbufs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sizereqbufs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sizereqbufs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sizereqbufs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_initworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_initworkitems;
	py_initworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->initworkitems));
	return py_initworkitems;
}

static int py_srvsvc_NetSrvInfo599_set_initworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxworkitems;
	py_maxworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->maxworkitems));
	return py_maxworkitems;
}

static int py_srvsvc_NetSrvInfo599_set_maxworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_rawworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_rawworkitems;
	py_rawworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->rawworkitems));
	return py_rawworkitems;
}

static int py_srvsvc_NetSrvInfo599_set_rawworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rawworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rawworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rawworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_irpstacksize(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_irpstacksize;
	py_irpstacksize = PyLong_FromUnsignedLongLong((uint32_t)(object->irpstacksize));
	return py_irpstacksize;
}

static int py_srvsvc_NetSrvInfo599_set_irpstacksize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->irpstacksize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->irpstacksize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->irpstacksize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxrawbuflen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxrawbuflen;
	py_maxrawbuflen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxrawbuflen));
	return py_maxrawbuflen;
}

static int py_srvsvc_NetSrvInfo599_set_maxrawbuflen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxrawbuflen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxrawbuflen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxrawbuflen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_sessusers(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessusers;
	py_sessusers = PyLong_FromUnsignedLongLong((uint32_t)(object->sessusers));
	return py_sessusers;
}

static int py_srvsvc_NetSrvInfo599_set_sessusers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessusers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessusers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessusers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_sessconns(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessconns;
	py_sessconns = PyLong_FromUnsignedLongLong((uint32_t)(object->sessconns));
	return py_sessconns;
}

static int py_srvsvc_NetSrvInfo599_set_sessconns(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessconns");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessconns));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessconns = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxpagedmemoryusage;
	py_maxpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxpagedmemoryusage));
	return py_maxpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo599_set_maxpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxnonpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxnonpagedmemoryusage;
	py_maxnonpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxnonpagedmemoryusage));
	return py_maxnonpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo599_set_maxnonpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxnonpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxnonpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxnonpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_enablesoftcompat(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablesoftcompat;
	py_enablesoftcompat = PyLong_FromUnsignedLongLong((uint32_t)(object->enablesoftcompat));
	return py_enablesoftcompat;
}

static int py_srvsvc_NetSrvInfo599_set_enablesoftcompat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablesoftcompat");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablesoftcompat));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablesoftcompat = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_enableforcedlogoff(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableforcedlogoff;
	py_enableforcedlogoff = PyLong_FromUnsignedLongLong((uint32_t)(object->enableforcedlogoff));
	return py_enableforcedlogoff;
}

static int py_srvsvc_NetSrvInfo599_set_enableforcedlogoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableforcedlogoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableforcedlogoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableforcedlogoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_timesource(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_timesource;
	py_timesource = PyLong_FromUnsignedLongLong((uint32_t)(object->timesource));
	return py_timesource;
}

static int py_srvsvc_NetSrvInfo599_set_timesource(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timesource");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timesource));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timesource = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_acceptdownlevelapis(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_acceptdownlevelapis;
	py_acceptdownlevelapis = PyLong_FromUnsignedLongLong((uint32_t)(object->acceptdownlevelapis));
	return py_acceptdownlevelapis;
}

static int py_srvsvc_NetSrvInfo599_set_acceptdownlevelapis(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acceptdownlevelapis");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acceptdownlevelapis));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acceptdownlevelapis = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_lmannounce(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_lmannounce;
	py_lmannounce = PyLong_FromUnsignedLongLong((uint32_t)(object->lmannounce));
	return py_lmannounce;
}

static int py_srvsvc_NetSrvInfo599_set_lmannounce(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmannounce");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmannounce));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmannounce = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_domain(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (object->domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_srvsvc_NetSrvInfo599_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxcopyreadlen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxcopyreadlen;
	py_maxcopyreadlen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxcopyreadlen));
	return py_maxcopyreadlen;
}

static int py_srvsvc_NetSrvInfo599_set_maxcopyreadlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxcopyreadlen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxcopyreadlen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxcopyreadlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxcopywritelen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxcopywritelen;
	py_maxcopywritelen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxcopywritelen));
	return py_maxcopywritelen;
}

static int py_srvsvc_NetSrvInfo599_set_maxcopywritelen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxcopywritelen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxcopywritelen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxcopywritelen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_minkeepsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_minkeepsearch;
	py_minkeepsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->minkeepsearch));
	return py_minkeepsearch;
}

static int py_srvsvc_NetSrvInfo599_set_minkeepsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minkeepsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minkeepsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minkeepsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_minkeepcomplsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_minkeepcomplsearch;
	py_minkeepcomplsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->minkeepcomplsearch));
	return py_minkeepcomplsearch;
}

static int py_srvsvc_NetSrvInfo599_set_minkeepcomplsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minkeepcomplsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minkeepcomplsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minkeepcomplsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxkeepcomplsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxkeepcomplsearch;
	py_maxkeepcomplsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->maxkeepcomplsearch));
	return py_maxkeepcomplsearch;
}

static int py_srvsvc_NetSrvInfo599_set_maxkeepcomplsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxkeepcomplsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxkeepcomplsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxkeepcomplsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_threadcountadd(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_threadcountadd;
	py_threadcountadd = PyLong_FromUnsignedLongLong((uint32_t)(object->threadcountadd));
	return py_threadcountadd;
}

static int py_srvsvc_NetSrvInfo599_set_threadcountadd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->threadcountadd");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->threadcountadd));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->threadcountadd = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_numlockthreads(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_numlockthreads;
	py_numlockthreads = PyLong_FromUnsignedLongLong((uint32_t)(object->numlockthreads));
	return py_numlockthreads;
}

static int py_srvsvc_NetSrvInfo599_set_numlockthreads(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numlockthreads");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numlockthreads));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numlockthreads = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_scavtimeout(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_scavtimeout;
	py_scavtimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->scavtimeout));
	return py_scavtimeout;
}

static int py_srvsvc_NetSrvInfo599_set_scavtimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scavtimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->scavtimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->scavtimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_minrcvqueue(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_minrcvqueue;
	py_minrcvqueue = PyLong_FromUnsignedLongLong((uint32_t)(object->minrcvqueue));
	return py_minrcvqueue;
}

static int py_srvsvc_NetSrvInfo599_set_minrcvqueue(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minrcvqueue");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minrcvqueue));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minrcvqueue = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_minfreeworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_minfreeworkitems;
	py_minfreeworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->minfreeworkitems));
	return py_minfreeworkitems;
}

static int py_srvsvc_NetSrvInfo599_set_minfreeworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minfreeworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minfreeworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minfreeworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_xactmemsize(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_xactmemsize;
	py_xactmemsize = PyLong_FromUnsignedLongLong((uint32_t)(object->xactmemsize));
	return py_xactmemsize;
}

static int py_srvsvc_NetSrvInfo599_set_xactmemsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->xactmemsize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->xactmemsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->xactmemsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_threadpriority(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_threadpriority;
	py_threadpriority = PyLong_FromUnsignedLongLong((uint32_t)(object->threadpriority));
	return py_threadpriority;
}

static int py_srvsvc_NetSrvInfo599_set_threadpriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->threadpriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->threadpriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->threadpriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxmpxct(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxmpxct;
	py_maxmpxct = PyLong_FromUnsignedLongLong((uint32_t)(object->maxmpxct));
	return py_maxmpxct;
}

static int py_srvsvc_NetSrvInfo599_set_maxmpxct(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxmpxct");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxmpxct));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxmpxct = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_oplockbreakwait(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_oplockbreakwait;
	py_oplockbreakwait = PyLong_FromUnsignedLongLong((uint32_t)(object->oplockbreakwait));
	return py_oplockbreakwait;
}

static int py_srvsvc_NetSrvInfo599_set_oplockbreakwait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oplockbreakwait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->oplockbreakwait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->oplockbreakwait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_oplockbreakresponsewait(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_oplockbreakresponsewait;
	py_oplockbreakresponsewait = PyLong_FromUnsignedLongLong((uint32_t)(object->oplockbreakresponsewait));
	return py_oplockbreakresponsewait;
}

static int py_srvsvc_NetSrvInfo599_set_oplockbreakresponsewait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oplockbreakresponsewait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->oplockbreakresponsewait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->oplockbreakresponsewait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_enableoplocks(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableoplocks;
	py_enableoplocks = PyLong_FromUnsignedLongLong((uint32_t)(object->enableoplocks));
	return py_enableoplocks;
}

static int py_srvsvc_NetSrvInfo599_set_enableoplocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableoplocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableoplocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableoplocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_enableoplockforceclose(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableoplockforceclose;
	py_enableoplockforceclose = PyLong_FromUnsignedLongLong((uint32_t)(object->enableoplockforceclose));
	return py_enableoplockforceclose;
}

static int py_srvsvc_NetSrvInfo599_set_enableoplockforceclose(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableoplockforceclose");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableoplockforceclose));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableoplockforceclose = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_enablefcbopens(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablefcbopens;
	py_enablefcbopens = PyLong_FromUnsignedLongLong((uint32_t)(object->enablefcbopens));
	return py_enablefcbopens;
}

static int py_srvsvc_NetSrvInfo599_set_enablefcbopens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablefcbopens");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablefcbopens));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablefcbopens = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_enableraw(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableraw;
	py_enableraw = PyLong_FromUnsignedLongLong((uint32_t)(object->enableraw));
	return py_enableraw;
}

static int py_srvsvc_NetSrvInfo599_set_enableraw(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableraw");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableraw));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableraw = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_enablesharednetdrives(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablesharednetdrives;
	py_enablesharednetdrives = PyLong_FromUnsignedLongLong((uint32_t)(object->enablesharednetdrives));
	return py_enablesharednetdrives;
}

static int py_srvsvc_NetSrvInfo599_set_enablesharednetdrives(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablesharednetdrives");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablesharednetdrives));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablesharednetdrives = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_minfreeconnections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_minfreeconnections;
	py_minfreeconnections = PyLong_FromUnsignedLongLong((uint32_t)(object->minfreeconnections));
	return py_minfreeconnections;
}

static int py_srvsvc_NetSrvInfo599_set_minfreeconnections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minfreeconnections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minfreeconnections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minfreeconnections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxfreeconnections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxfreeconnections;
	py_maxfreeconnections = PyLong_FromUnsignedLongLong((uint32_t)(object->maxfreeconnections));
	return py_maxfreeconnections;
}

static int py_srvsvc_NetSrvInfo599_set_maxfreeconnections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxfreeconnections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxfreeconnections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxfreeconnections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_initsesstable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_initsesstable;
	py_initsesstable = PyLong_FromUnsignedLongLong((uint32_t)(object->initsesstable));
	return py_initsesstable;
}

static int py_srvsvc_NetSrvInfo599_set_initsesstable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initsesstable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initsesstable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initsesstable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_initconntable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_initconntable;
	py_initconntable = PyLong_FromUnsignedLongLong((uint32_t)(object->initconntable));
	return py_initconntable;
}

static int py_srvsvc_NetSrvInfo599_set_initconntable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initconntable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initconntable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initconntable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_initfiletable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_initfiletable;
	py_initfiletable = PyLong_FromUnsignedLongLong((uint32_t)(object->initfiletable));
	return py_initfiletable;
}

static int py_srvsvc_NetSrvInfo599_set_initfiletable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initfiletable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initfiletable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initfiletable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_initsearchtable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_initsearchtable;
	py_initsearchtable = PyLong_FromUnsignedLongLong((uint32_t)(object->initsearchtable));
	return py_initsearchtable;
}

static int py_srvsvc_NetSrvInfo599_set_initsearchtable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initsearchtable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initsearchtable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initsearchtable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_alertsched(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_alertsched;
	py_alertsched = PyLong_FromUnsignedLongLong((uint32_t)(object->alertsched));
	return py_alertsched;
}

static int py_srvsvc_NetSrvInfo599_set_alertsched(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alertsched");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alertsched));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alertsched = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_errortreshold(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_errortreshold;
	py_errortreshold = PyLong_FromUnsignedLongLong((uint32_t)(object->errortreshold));
	return py_errortreshold;
}

static int py_srvsvc_NetSrvInfo599_set_errortreshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->errortreshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->errortreshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->errortreshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_networkerrortreshold(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_networkerrortreshold;
	py_networkerrortreshold = PyLong_FromUnsignedLongLong((uint32_t)(object->networkerrortreshold));
	return py_networkerrortreshold;
}

static int py_srvsvc_NetSrvInfo599_set_networkerrortreshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->networkerrortreshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->networkerrortreshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->networkerrortreshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_diskspacetreshold(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_diskspacetreshold;
	py_diskspacetreshold = PyLong_FromUnsignedLongLong((uint32_t)(object->diskspacetreshold));
	return py_diskspacetreshold;
}

static int py_srvsvc_NetSrvInfo599_set_diskspacetreshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->diskspacetreshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->diskspacetreshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->diskspacetreshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_reserved(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_srvsvc_NetSrvInfo599_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxlinkdelay(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxlinkdelay;
	py_maxlinkdelay = PyLong_FromUnsignedLongLong((uint32_t)(object->maxlinkdelay));
	return py_maxlinkdelay;
}

static int py_srvsvc_NetSrvInfo599_set_maxlinkdelay(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxlinkdelay");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxlinkdelay));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxlinkdelay = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_minlinkthroughput(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_minlinkthroughput;
	py_minlinkthroughput = PyLong_FromUnsignedLongLong((uint32_t)(object->minlinkthroughput));
	return py_minlinkthroughput;
}

static int py_srvsvc_NetSrvInfo599_set_minlinkthroughput(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minlinkthroughput");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minlinkthroughput));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minlinkthroughput = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_linkinfovalidtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_linkinfovalidtime;
	py_linkinfovalidtime = PyLong_FromUnsignedLongLong((uint32_t)(object->linkinfovalidtime));
	return py_linkinfovalidtime;
}

static int py_srvsvc_NetSrvInfo599_set_linkinfovalidtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->linkinfovalidtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->linkinfovalidtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->linkinfovalidtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_scavqosinfoupdatetime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_scavqosinfoupdatetime;
	py_scavqosinfoupdatetime = PyLong_FromUnsignedLongLong((uint32_t)(object->scavqosinfoupdatetime));
	return py_scavqosinfoupdatetime;
}

static int py_srvsvc_NetSrvInfo599_set_scavqosinfoupdatetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scavqosinfoupdatetime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->scavqosinfoupdatetime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->scavqosinfoupdatetime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetSrvInfo599_get_maxworkitemidletime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxworkitemidletime;
	py_maxworkitemidletime = PyLong_FromUnsignedLongLong((uint32_t)(object->maxworkitemidletime));
	return py_maxworkitemidletime;
}

static int py_srvsvc_NetSrvInfo599_set_maxworkitemidletime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo599 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxworkitemidletime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxworkitemidletime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxworkitemidletime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo599_getsetters[] = {
	{
		.name = discard_const_p(char, "sessopen"),
		.get = py_srvsvc_NetSrvInfo599_get_sessopen,
		.set = py_srvsvc_NetSrvInfo599_set_sessopen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sesssvc"),
		.get = py_srvsvc_NetSrvInfo599_get_sesssvc,
		.set = py_srvsvc_NetSrvInfo599_set_sesssvc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "opensearch"),
		.get = py_srvsvc_NetSrvInfo599_get_opensearch,
		.set = py_srvsvc_NetSrvInfo599_set_opensearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sizereqbufs"),
		.get = py_srvsvc_NetSrvInfo599_get_sizereqbufs,
		.set = py_srvsvc_NetSrvInfo599_set_sizereqbufs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "initworkitems"),
		.get = py_srvsvc_NetSrvInfo599_get_initworkitems,
		.set = py_srvsvc_NetSrvInfo599_set_initworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxworkitems"),
		.get = py_srvsvc_NetSrvInfo599_get_maxworkitems,
		.set = py_srvsvc_NetSrvInfo599_set_maxworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rawworkitems"),
		.get = py_srvsvc_NetSrvInfo599_get_rawworkitems,
		.set = py_srvsvc_NetSrvInfo599_set_rawworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "irpstacksize"),
		.get = py_srvsvc_NetSrvInfo599_get_irpstacksize,
		.set = py_srvsvc_NetSrvInfo599_set_irpstacksize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxrawbuflen"),
		.get = py_srvsvc_NetSrvInfo599_get_maxrawbuflen,
		.set = py_srvsvc_NetSrvInfo599_set_maxrawbuflen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessusers"),
		.get = py_srvsvc_NetSrvInfo599_get_sessusers,
		.set = py_srvsvc_NetSrvInfo599_set_sessusers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessconns"),
		.get = py_srvsvc_NetSrvInfo599_get_sessconns,
		.set = py_srvsvc_NetSrvInfo599_set_sessconns,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo599_get_maxpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo599_set_maxpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxnonpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo599_get_maxnonpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo599_set_maxnonpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enablesoftcompat"),
		.get = py_srvsvc_NetSrvInfo599_get_enablesoftcompat,
		.set = py_srvsvc_NetSrvInfo599_set_enablesoftcompat,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableforcedlogoff"),
		.get = py_srvsvc_NetSrvInfo599_get_enableforcedlogoff,
		.set = py_srvsvc_NetSrvInfo599_set_enableforcedlogoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "timesource"),
		.get = py_srvsvc_NetSrvInfo599_get_timesource,
		.set = py_srvsvc_NetSrvInfo599_set_timesource,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "acceptdownlevelapis"),
		.get = py_srvsvc_NetSrvInfo599_get_acceptdownlevelapis,
		.set = py_srvsvc_NetSrvInfo599_set_acceptdownlevelapis,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lmannounce"),
		.get = py_srvsvc_NetSrvInfo599_get_lmannounce,
		.set = py_srvsvc_NetSrvInfo599_set_lmannounce,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_srvsvc_NetSrvInfo599_get_domain,
		.set = py_srvsvc_NetSrvInfo599_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "maxcopyreadlen"),
		.get = py_srvsvc_NetSrvInfo599_get_maxcopyreadlen,
		.set = py_srvsvc_NetSrvInfo599_set_maxcopyreadlen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxcopywritelen"),
		.get = py_srvsvc_NetSrvInfo599_get_maxcopywritelen,
		.set = py_srvsvc_NetSrvInfo599_set_maxcopywritelen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minkeepsearch"),
		.get = py_srvsvc_NetSrvInfo599_get_minkeepsearch,
		.set = py_srvsvc_NetSrvInfo599_set_minkeepsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minkeepcomplsearch"),
		.get = py_srvsvc_NetSrvInfo599_get_minkeepcomplsearch,
		.set = py_srvsvc_NetSrvInfo599_set_minkeepcomplsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxkeepcomplsearch"),
		.get = py_srvsvc_NetSrvInfo599_get_maxkeepcomplsearch,
		.set = py_srvsvc_NetSrvInfo599_set_maxkeepcomplsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "threadcountadd"),
		.get = py_srvsvc_NetSrvInfo599_get_threadcountadd,
		.set = py_srvsvc_NetSrvInfo599_set_threadcountadd,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "numlockthreads"),
		.get = py_srvsvc_NetSrvInfo599_get_numlockthreads,
		.set = py_srvsvc_NetSrvInfo599_set_numlockthreads,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "scavtimeout"),
		.get = py_srvsvc_NetSrvInfo599_get_scavtimeout,
		.set = py_srvsvc_NetSrvInfo599_set_scavtimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minrcvqueue"),
		.get = py_srvsvc_NetSrvInfo599_get_minrcvqueue,
		.set = py_srvsvc_NetSrvInfo599_set_minrcvqueue,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minfreeworkitems"),
		.get = py_srvsvc_NetSrvInfo599_get_minfreeworkitems,
		.set = py_srvsvc_NetSrvInfo599_set_minfreeworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "xactmemsize"),
		.get = py_srvsvc_NetSrvInfo599_get_xactmemsize,
		.set = py_srvsvc_NetSrvInfo599_set_xactmemsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "threadpriority"),
		.get = py_srvsvc_NetSrvInfo599_get_threadpriority,
		.set = py_srvsvc_NetSrvInfo599_set_threadpriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxmpxct"),
		.get = py_srvsvc_NetSrvInfo599_get_maxmpxct,
		.set = py_srvsvc_NetSrvInfo599_set_maxmpxct,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "oplockbreakwait"),
		.get = py_srvsvc_NetSrvInfo599_get_oplockbreakwait,
		.set = py_srvsvc_NetSrvInfo599_set_oplockbreakwait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "oplockbreakresponsewait"),
		.get = py_srvsvc_NetSrvInfo599_get_oplockbreakresponsewait,
		.set = py_srvsvc_NetSrvInfo599_set_oplockbreakresponsewait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableoplocks"),
		.get = py_srvsvc_NetSrvInfo599_get_enableoplocks,
		.set = py_srvsvc_NetSrvInfo599_set_enableoplocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableoplockforceclose"),
		.get = py_srvsvc_NetSrvInfo599_get_enableoplockforceclose,
		.set = py_srvsvc_NetSrvInfo599_set_enableoplockforceclose,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enablefcbopens"),
		.get = py_srvsvc_NetSrvInfo599_get_enablefcbopens,
		.set = py_srvsvc_NetSrvInfo599_set_enablefcbopens,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enableraw"),
		.get = py_srvsvc_NetSrvInfo599_get_enableraw,
		.set = py_srvsvc_NetSrvInfo599_set_enableraw,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "enablesharednetdrives"),
		.get = py_srvsvc_NetSrvInfo599_get_enablesharednetdrives,
		.set = py_srvsvc_NetSrvInfo599_set_enablesharednetdrives,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minfreeconnections"),
		.get = py_srvsvc_NetSrvInfo599_get_minfreeconnections,
		.set = py_srvsvc_NetSrvInfo599_set_minfreeconnections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxfreeconnections"),
		.get = py_srvsvc_NetSrvInfo599_get_maxfreeconnections,
		.set = py_srvsvc_NetSrvInfo599_set_maxfreeconnections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "initsesstable"),
		.get = py_srvsvc_NetSrvInfo599_get_initsesstable,
		.set = py_srvsvc_NetSrvInfo599_set_initsesstable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "initconntable"),
		.get = py_srvsvc_NetSrvInfo599_get_initconntable,
		.set = py_srvsvc_NetSrvInfo599_set_initconntable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "initfiletable"),
		.get = py_srvsvc_NetSrvInfo599_get_initfiletable,
		.set = py_srvsvc_NetSrvInfo599_set_initfiletable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "initsearchtable"),
		.get = py_srvsvc_NetSrvInfo599_get_initsearchtable,
		.set = py_srvsvc_NetSrvInfo599_set_initsearchtable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "alertsched"),
		.get = py_srvsvc_NetSrvInfo599_get_alertsched,
		.set = py_srvsvc_NetSrvInfo599_set_alertsched,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "errortreshold"),
		.get = py_srvsvc_NetSrvInfo599_get_errortreshold,
		.set = py_srvsvc_NetSrvInfo599_set_errortreshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "networkerrortreshold"),
		.get = py_srvsvc_NetSrvInfo599_get_networkerrortreshold,
		.set = py_srvsvc_NetSrvInfo599_set_networkerrortreshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "diskspacetreshold"),
		.get = py_srvsvc_NetSrvInfo599_get_diskspacetreshold,
		.set = py_srvsvc_NetSrvInfo599_set_diskspacetreshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_srvsvc_NetSrvInfo599_get_reserved,
		.set = py_srvsvc_NetSrvInfo599_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxlinkdelay"),
		.get = py_srvsvc_NetSrvInfo599_get_maxlinkdelay,
		.set = py_srvsvc_NetSrvInfo599_set_maxlinkdelay,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minlinkthroughput"),
		.get = py_srvsvc_NetSrvInfo599_get_minlinkthroughput,
		.set = py_srvsvc_NetSrvInfo599_set_minlinkthroughput,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "linkinfovalidtime"),
		.get = py_srvsvc_NetSrvInfo599_get_linkinfovalidtime,
		.set = py_srvsvc_NetSrvInfo599_set_linkinfovalidtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "scavqosinfoupdatetime"),
		.get = py_srvsvc_NetSrvInfo599_get_scavqosinfoupdatetime,
		.set = py_srvsvc_NetSrvInfo599_set_scavqosinfoupdatetime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxworkitemidletime"),
		.get = py_srvsvc_NetSrvInfo599_get_maxworkitemidletime,
		.set = py_srvsvc_NetSrvInfo599_set_maxworkitemidletime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo599_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo599, type);
}


static PyTypeObject srvsvc_NetSrvInfo599_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo599",
	.tp_getset = py_srvsvc_NetSrvInfo599_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo599_new,
};


static PyObject *py_srvsvc_NetSrvInfo1005_get_comment(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1005 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	if (object->comment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->comment == NULL) {
		py_comment = Py_None;
		Py_INCREF(py_comment);
	} else {
		if (object->comment == NULL) {
			py_comment = Py_None;
			Py_INCREF(py_comment);
		} else {
			py_comment = PyUnicode_Decode(object->comment, strlen(object->comment), "utf-8", "ignore");
		}
	}
	return py_comment;
}

static int py_srvsvc_NetSrvInfo1005_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1005 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	if (value == Py_None) {
		object->comment = NULL;
	} else {
		object->comment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->comment = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1005_getsetters[] = {
	{
		.name = discard_const_p(char, "comment"),
		.get = py_srvsvc_NetSrvInfo1005_get_comment,
		.set = py_srvsvc_NetSrvInfo1005_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1005_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1005, type);
}


static PyTypeObject srvsvc_NetSrvInfo1005_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1005",
	.tp_getset = py_srvsvc_NetSrvInfo1005_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1005_new,
};


static PyObject *py_srvsvc_NetSrvInfo1010_get_disc(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1010 *object = pytalloc_get_ptr(obj);
	PyObject *py_disc;
	py_disc = PyLong_FromUnsignedLongLong((uint32_t)(object->disc));
	return py_disc;
}

static int py_srvsvc_NetSrvInfo1010_set_disc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1010 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->disc");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->disc));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->disc = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1010_getsetters[] = {
	{
		.name = discard_const_p(char, "disc"),
		.get = py_srvsvc_NetSrvInfo1010_get_disc,
		.set = py_srvsvc_NetSrvInfo1010_set_disc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1010_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1010, type);
}


static PyTypeObject srvsvc_NetSrvInfo1010_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1010",
	.tp_getset = py_srvsvc_NetSrvInfo1010_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1010_new,
};


static PyObject *py_srvsvc_NetSrvInfo1016_get_hidden(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1016 *object = pytalloc_get_ptr(obj);
	PyObject *py_hidden;
	py_hidden = PyLong_FromUnsignedLongLong((uint32_t)(object->hidden));
	return py_hidden;
}

static int py_srvsvc_NetSrvInfo1016_set_hidden(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1016 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hidden");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->hidden));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->hidden = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1016_getsetters[] = {
	{
		.name = discard_const_p(char, "hidden"),
		.get = py_srvsvc_NetSrvInfo1016_get_hidden,
		.set = py_srvsvc_NetSrvInfo1016_set_hidden,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1016_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1016, type);
}


static PyTypeObject srvsvc_NetSrvInfo1016_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1016",
	.tp_getset = py_srvsvc_NetSrvInfo1016_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1016_new,
};


static PyObject *py_srvsvc_NetSrvInfo1017_get_announce(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1017 *object = pytalloc_get_ptr(obj);
	PyObject *py_announce;
	py_announce = PyLong_FromUnsignedLongLong((uint32_t)(object->announce));
	return py_announce;
}

static int py_srvsvc_NetSrvInfo1017_set_announce(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1017 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->announce");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->announce));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->announce = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1017_getsetters[] = {
	{
		.name = discard_const_p(char, "announce"),
		.get = py_srvsvc_NetSrvInfo1017_get_announce,
		.set = py_srvsvc_NetSrvInfo1017_set_announce,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1017_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1017, type);
}


static PyTypeObject srvsvc_NetSrvInfo1017_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1017",
	.tp_getset = py_srvsvc_NetSrvInfo1017_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1017_new,
};


static PyObject *py_srvsvc_NetSrvInfo1018_get_anndelta(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1018 *object = pytalloc_get_ptr(obj);
	PyObject *py_anndelta;
	py_anndelta = PyLong_FromUnsignedLongLong((uint32_t)(object->anndelta));
	return py_anndelta;
}

static int py_srvsvc_NetSrvInfo1018_set_anndelta(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1018 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->anndelta");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->anndelta));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->anndelta = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1018_getsetters[] = {
	{
		.name = discard_const_p(char, "anndelta"),
		.get = py_srvsvc_NetSrvInfo1018_get_anndelta,
		.set = py_srvsvc_NetSrvInfo1018_set_anndelta,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1018_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1018, type);
}


static PyTypeObject srvsvc_NetSrvInfo1018_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1018",
	.tp_getset = py_srvsvc_NetSrvInfo1018_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1018_new,
};


static PyObject *py_srvsvc_NetSrvInfo1107_get_users(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1107 *object = pytalloc_get_ptr(obj);
	PyObject *py_users;
	py_users = PyLong_FromUnsignedLongLong((uint32_t)(object->users));
	return py_users;
}

static int py_srvsvc_NetSrvInfo1107_set_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1107 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1107_getsetters[] = {
	{
		.name = discard_const_p(char, "users"),
		.get = py_srvsvc_NetSrvInfo1107_get_users,
		.set = py_srvsvc_NetSrvInfo1107_set_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1107_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1107, type);
}


static PyTypeObject srvsvc_NetSrvInfo1107_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1107",
	.tp_getset = py_srvsvc_NetSrvInfo1107_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1107_new,
};


static PyObject *py_srvsvc_NetSrvInfo1501_get_sessopens(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1501 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessopens;
	py_sessopens = PyLong_FromUnsignedLongLong((uint32_t)(object->sessopens));
	return py_sessopens;
}

static int py_srvsvc_NetSrvInfo1501_set_sessopens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1501 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessopens");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessopens));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessopens = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1501_getsetters[] = {
	{
		.name = discard_const_p(char, "sessopens"),
		.get = py_srvsvc_NetSrvInfo1501_get_sessopens,
		.set = py_srvsvc_NetSrvInfo1501_set_sessopens,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1501_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1501, type);
}


static PyTypeObject srvsvc_NetSrvInfo1501_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1501",
	.tp_getset = py_srvsvc_NetSrvInfo1501_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1501_new,
};


static PyObject *py_srvsvc_NetSrvInfo1502_get_sessvcs(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1502 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessvcs;
	py_sessvcs = PyLong_FromUnsignedLongLong((uint32_t)(object->sessvcs));
	return py_sessvcs;
}

static int py_srvsvc_NetSrvInfo1502_set_sessvcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1502 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessvcs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessvcs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessvcs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1502_getsetters[] = {
	{
		.name = discard_const_p(char, "sessvcs"),
		.get = py_srvsvc_NetSrvInfo1502_get_sessvcs,
		.set = py_srvsvc_NetSrvInfo1502_set_sessvcs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1502_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1502, type);
}


static PyTypeObject srvsvc_NetSrvInfo1502_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1502",
	.tp_getset = py_srvsvc_NetSrvInfo1502_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1502_new,
};


static PyObject *py_srvsvc_NetSrvInfo1503_get_opensearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1503 *object = pytalloc_get_ptr(obj);
	PyObject *py_opensearch;
	py_opensearch = PyLong_FromUnsignedLongLong((uint32_t)(object->opensearch));
	return py_opensearch;
}

static int py_srvsvc_NetSrvInfo1503_set_opensearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1503 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opensearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opensearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opensearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1503_getsetters[] = {
	{
		.name = discard_const_p(char, "opensearch"),
		.get = py_srvsvc_NetSrvInfo1503_get_opensearch,
		.set = py_srvsvc_NetSrvInfo1503_set_opensearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1503_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1503, type);
}


static PyTypeObject srvsvc_NetSrvInfo1503_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1503",
	.tp_getset = py_srvsvc_NetSrvInfo1503_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1503_new,
};


static PyObject *py_srvsvc_NetSrvInfo1506_get_maxworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1506 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxworkitems;
	py_maxworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->maxworkitems));
	return py_maxworkitems;
}

static int py_srvsvc_NetSrvInfo1506_set_maxworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1506 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1506_getsetters[] = {
	{
		.name = discard_const_p(char, "maxworkitems"),
		.get = py_srvsvc_NetSrvInfo1506_get_maxworkitems,
		.set = py_srvsvc_NetSrvInfo1506_set_maxworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1506_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1506, type);
}


static PyTypeObject srvsvc_NetSrvInfo1506_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1506",
	.tp_getset = py_srvsvc_NetSrvInfo1506_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1506_new,
};


static PyObject *py_srvsvc_NetSrvInfo1509_get_maxrawbuflen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1509 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxrawbuflen;
	py_maxrawbuflen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxrawbuflen));
	return py_maxrawbuflen;
}

static int py_srvsvc_NetSrvInfo1509_set_maxrawbuflen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1509 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxrawbuflen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxrawbuflen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxrawbuflen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1509_getsetters[] = {
	{
		.name = discard_const_p(char, "maxrawbuflen"),
		.get = py_srvsvc_NetSrvInfo1509_get_maxrawbuflen,
		.set = py_srvsvc_NetSrvInfo1509_set_maxrawbuflen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1509_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1509, type);
}


static PyTypeObject srvsvc_NetSrvInfo1509_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1509",
	.tp_getset = py_srvsvc_NetSrvInfo1509_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1509_new,
};


static PyObject *py_srvsvc_NetSrvInfo1510_get_sessusers(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1510 *object = pytalloc_get_ptr(obj);
	PyObject *py_sessusers;
	py_sessusers = PyLong_FromUnsignedLongLong((uint32_t)(object->sessusers));
	return py_sessusers;
}

static int py_srvsvc_NetSrvInfo1510_set_sessusers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1510 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessusers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sessusers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sessusers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1510_getsetters[] = {
	{
		.name = discard_const_p(char, "sessusers"),
		.get = py_srvsvc_NetSrvInfo1510_get_sessusers,
		.set = py_srvsvc_NetSrvInfo1510_set_sessusers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1510_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1510, type);
}


static PyTypeObject srvsvc_NetSrvInfo1510_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1510",
	.tp_getset = py_srvsvc_NetSrvInfo1510_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1510_new,
};


static PyObject *py_srvsvc_NetSrvInfo1511_get_sesscons(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1511 *object = pytalloc_get_ptr(obj);
	PyObject *py_sesscons;
	py_sesscons = PyLong_FromUnsignedLongLong((uint32_t)(object->sesscons));
	return py_sesscons;
}

static int py_srvsvc_NetSrvInfo1511_set_sesscons(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1511 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sesscons");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sesscons));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sesscons = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1511_getsetters[] = {
	{
		.name = discard_const_p(char, "sesscons"),
		.get = py_srvsvc_NetSrvInfo1511_get_sesscons,
		.set = py_srvsvc_NetSrvInfo1511_set_sesscons,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1511_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1511, type);
}


static PyTypeObject srvsvc_NetSrvInfo1511_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1511",
	.tp_getset = py_srvsvc_NetSrvInfo1511_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1511_new,
};


static PyObject *py_srvsvc_NetSrvInfo1512_get_maxnonpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1512 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxnonpagedmemoryusage;
	py_maxnonpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxnonpagedmemoryusage));
	return py_maxnonpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo1512_set_maxnonpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1512 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxnonpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxnonpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxnonpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1512_getsetters[] = {
	{
		.name = discard_const_p(char, "maxnonpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo1512_get_maxnonpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo1512_set_maxnonpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1512_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1512, type);
}


static PyTypeObject srvsvc_NetSrvInfo1512_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1512",
	.tp_getset = py_srvsvc_NetSrvInfo1512_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1512_new,
};


static PyObject *py_srvsvc_NetSrvInfo1513_get_maxpagedmemoryusage(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1513 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxpagedmemoryusage;
	py_maxpagedmemoryusage = PyLong_FromUnsignedLongLong((uint32_t)(object->maxpagedmemoryusage));
	return py_maxpagedmemoryusage;
}

static int py_srvsvc_NetSrvInfo1513_set_maxpagedmemoryusage(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1513 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxpagedmemoryusage");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxpagedmemoryusage));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxpagedmemoryusage = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1513_getsetters[] = {
	{
		.name = discard_const_p(char, "maxpagedmemoryusage"),
		.get = py_srvsvc_NetSrvInfo1513_get_maxpagedmemoryusage,
		.set = py_srvsvc_NetSrvInfo1513_set_maxpagedmemoryusage,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1513_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1513, type);
}


static PyTypeObject srvsvc_NetSrvInfo1513_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1513",
	.tp_getset = py_srvsvc_NetSrvInfo1513_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1513_new,
};


static PyObject *py_srvsvc_NetSrvInfo1514_get_enablesoftcompat(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1514 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablesoftcompat;
	py_enablesoftcompat = PyLong_FromUnsignedLongLong((uint32_t)(object->enablesoftcompat));
	return py_enablesoftcompat;
}

static int py_srvsvc_NetSrvInfo1514_set_enablesoftcompat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1514 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablesoftcompat");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablesoftcompat));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablesoftcompat = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1514_getsetters[] = {
	{
		.name = discard_const_p(char, "enablesoftcompat"),
		.get = py_srvsvc_NetSrvInfo1514_get_enablesoftcompat,
		.set = py_srvsvc_NetSrvInfo1514_set_enablesoftcompat,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1514_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1514, type);
}


static PyTypeObject srvsvc_NetSrvInfo1514_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1514",
	.tp_getset = py_srvsvc_NetSrvInfo1514_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1514_new,
};


static PyObject *py_srvsvc_NetSrvInfo1515_get_enableforcedlogoff(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1515 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableforcedlogoff;
	py_enableforcedlogoff = PyLong_FromUnsignedLongLong((uint32_t)(object->enableforcedlogoff));
	return py_enableforcedlogoff;
}

static int py_srvsvc_NetSrvInfo1515_set_enableforcedlogoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1515 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableforcedlogoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableforcedlogoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableforcedlogoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1515_getsetters[] = {
	{
		.name = discard_const_p(char, "enableforcedlogoff"),
		.get = py_srvsvc_NetSrvInfo1515_get_enableforcedlogoff,
		.set = py_srvsvc_NetSrvInfo1515_set_enableforcedlogoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1515_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1515, type);
}


static PyTypeObject srvsvc_NetSrvInfo1515_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1515",
	.tp_getset = py_srvsvc_NetSrvInfo1515_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1515_new,
};


static PyObject *py_srvsvc_NetSrvInfo1516_get_timesource(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1516 *object = pytalloc_get_ptr(obj);
	PyObject *py_timesource;
	py_timesource = PyLong_FromUnsignedLongLong((uint32_t)(object->timesource));
	return py_timesource;
}

static int py_srvsvc_NetSrvInfo1516_set_timesource(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1516 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timesource");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timesource));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timesource = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1516_getsetters[] = {
	{
		.name = discard_const_p(char, "timesource"),
		.get = py_srvsvc_NetSrvInfo1516_get_timesource,
		.set = py_srvsvc_NetSrvInfo1516_set_timesource,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1516_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1516, type);
}


static PyTypeObject srvsvc_NetSrvInfo1516_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1516",
	.tp_getset = py_srvsvc_NetSrvInfo1516_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1516_new,
};


static PyObject *py_srvsvc_NetSrvInfo1518_get_lmannounce(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1518 *object = pytalloc_get_ptr(obj);
	PyObject *py_lmannounce;
	py_lmannounce = PyLong_FromUnsignedLongLong((uint32_t)(object->lmannounce));
	return py_lmannounce;
}

static int py_srvsvc_NetSrvInfo1518_set_lmannounce(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1518 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmannounce");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmannounce));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmannounce = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1518_getsetters[] = {
	{
		.name = discard_const_p(char, "lmannounce"),
		.get = py_srvsvc_NetSrvInfo1518_get_lmannounce,
		.set = py_srvsvc_NetSrvInfo1518_set_lmannounce,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1518_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1518, type);
}


static PyTypeObject srvsvc_NetSrvInfo1518_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1518",
	.tp_getset = py_srvsvc_NetSrvInfo1518_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1518_new,
};


static PyObject *py_srvsvc_NetSrvInfo1520_get_maxcopyreadlen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1520 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxcopyreadlen;
	py_maxcopyreadlen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxcopyreadlen));
	return py_maxcopyreadlen;
}

static int py_srvsvc_NetSrvInfo1520_set_maxcopyreadlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1520 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxcopyreadlen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxcopyreadlen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxcopyreadlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1520_getsetters[] = {
	{
		.name = discard_const_p(char, "maxcopyreadlen"),
		.get = py_srvsvc_NetSrvInfo1520_get_maxcopyreadlen,
		.set = py_srvsvc_NetSrvInfo1520_set_maxcopyreadlen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1520_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1520, type);
}


static PyTypeObject srvsvc_NetSrvInfo1520_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1520",
	.tp_getset = py_srvsvc_NetSrvInfo1520_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1520_new,
};


static PyObject *py_srvsvc_NetSrvInfo1521_get_maxcopywritelen(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1521 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxcopywritelen;
	py_maxcopywritelen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxcopywritelen));
	return py_maxcopywritelen;
}

static int py_srvsvc_NetSrvInfo1521_set_maxcopywritelen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1521 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxcopywritelen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxcopywritelen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxcopywritelen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1521_getsetters[] = {
	{
		.name = discard_const_p(char, "maxcopywritelen"),
		.get = py_srvsvc_NetSrvInfo1521_get_maxcopywritelen,
		.set = py_srvsvc_NetSrvInfo1521_set_maxcopywritelen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1521_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1521, type);
}


static PyTypeObject srvsvc_NetSrvInfo1521_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1521",
	.tp_getset = py_srvsvc_NetSrvInfo1521_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1521_new,
};


static PyObject *py_srvsvc_NetSrvInfo1522_get_minkeepsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1522 *object = pytalloc_get_ptr(obj);
	PyObject *py_minkeepsearch;
	py_minkeepsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->minkeepsearch));
	return py_minkeepsearch;
}

static int py_srvsvc_NetSrvInfo1522_set_minkeepsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1522 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minkeepsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minkeepsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minkeepsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1522_getsetters[] = {
	{
		.name = discard_const_p(char, "minkeepsearch"),
		.get = py_srvsvc_NetSrvInfo1522_get_minkeepsearch,
		.set = py_srvsvc_NetSrvInfo1522_set_minkeepsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1522_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1522, type);
}


static PyTypeObject srvsvc_NetSrvInfo1522_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1522",
	.tp_getset = py_srvsvc_NetSrvInfo1522_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1522_new,
};


static PyObject *py_srvsvc_NetSrvInfo1523_get_maxkeepsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1523 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxkeepsearch;
	py_maxkeepsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->maxkeepsearch));
	return py_maxkeepsearch;
}

static int py_srvsvc_NetSrvInfo1523_set_maxkeepsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1523 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxkeepsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxkeepsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxkeepsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1523_getsetters[] = {
	{
		.name = discard_const_p(char, "maxkeepsearch"),
		.get = py_srvsvc_NetSrvInfo1523_get_maxkeepsearch,
		.set = py_srvsvc_NetSrvInfo1523_set_maxkeepsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1523_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1523, type);
}


static PyTypeObject srvsvc_NetSrvInfo1523_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1523",
	.tp_getset = py_srvsvc_NetSrvInfo1523_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1523_new,
};


static PyObject *py_srvsvc_NetSrvInfo1524_get_minkeepcomplsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1524 *object = pytalloc_get_ptr(obj);
	PyObject *py_minkeepcomplsearch;
	py_minkeepcomplsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->minkeepcomplsearch));
	return py_minkeepcomplsearch;
}

static int py_srvsvc_NetSrvInfo1524_set_minkeepcomplsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1524 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minkeepcomplsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minkeepcomplsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minkeepcomplsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1524_getsetters[] = {
	{
		.name = discard_const_p(char, "minkeepcomplsearch"),
		.get = py_srvsvc_NetSrvInfo1524_get_minkeepcomplsearch,
		.set = py_srvsvc_NetSrvInfo1524_set_minkeepcomplsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1524_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1524, type);
}


static PyTypeObject srvsvc_NetSrvInfo1524_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1524",
	.tp_getset = py_srvsvc_NetSrvInfo1524_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1524_new,
};


static PyObject *py_srvsvc_NetSrvInfo1525_get_maxkeepcomplsearch(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1525 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxkeepcomplsearch;
	py_maxkeepcomplsearch = PyLong_FromUnsignedLongLong((uint32_t)(object->maxkeepcomplsearch));
	return py_maxkeepcomplsearch;
}

static int py_srvsvc_NetSrvInfo1525_set_maxkeepcomplsearch(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1525 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxkeepcomplsearch");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxkeepcomplsearch));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxkeepcomplsearch = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1525_getsetters[] = {
	{
		.name = discard_const_p(char, "maxkeepcomplsearch"),
		.get = py_srvsvc_NetSrvInfo1525_get_maxkeepcomplsearch,
		.set = py_srvsvc_NetSrvInfo1525_set_maxkeepcomplsearch,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1525_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1525, type);
}


static PyTypeObject srvsvc_NetSrvInfo1525_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1525",
	.tp_getset = py_srvsvc_NetSrvInfo1525_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1525_new,
};


static PyObject *py_srvsvc_NetSrvInfo1528_get_scavtimeout(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1528 *object = pytalloc_get_ptr(obj);
	PyObject *py_scavtimeout;
	py_scavtimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->scavtimeout));
	return py_scavtimeout;
}

static int py_srvsvc_NetSrvInfo1528_set_scavtimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1528 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scavtimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->scavtimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->scavtimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1528_getsetters[] = {
	{
		.name = discard_const_p(char, "scavtimeout"),
		.get = py_srvsvc_NetSrvInfo1528_get_scavtimeout,
		.set = py_srvsvc_NetSrvInfo1528_set_scavtimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1528_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1528, type);
}


static PyTypeObject srvsvc_NetSrvInfo1528_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1528",
	.tp_getset = py_srvsvc_NetSrvInfo1528_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1528_new,
};


static PyObject *py_srvsvc_NetSrvInfo1529_get_minrcvqueue(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1529 *object = pytalloc_get_ptr(obj);
	PyObject *py_minrcvqueue;
	py_minrcvqueue = PyLong_FromUnsignedLongLong((uint32_t)(object->minrcvqueue));
	return py_minrcvqueue;
}

static int py_srvsvc_NetSrvInfo1529_set_minrcvqueue(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1529 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minrcvqueue");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minrcvqueue));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minrcvqueue = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1529_getsetters[] = {
	{
		.name = discard_const_p(char, "minrcvqueue"),
		.get = py_srvsvc_NetSrvInfo1529_get_minrcvqueue,
		.set = py_srvsvc_NetSrvInfo1529_set_minrcvqueue,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1529_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1529, type);
}


static PyTypeObject srvsvc_NetSrvInfo1529_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1529",
	.tp_getset = py_srvsvc_NetSrvInfo1529_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1529_new,
};


static PyObject *py_srvsvc_NetSrvInfo1530_get_minfreeworkitems(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1530 *object = pytalloc_get_ptr(obj);
	PyObject *py_minfreeworkitems;
	py_minfreeworkitems = PyLong_FromUnsignedLongLong((uint32_t)(object->minfreeworkitems));
	return py_minfreeworkitems;
}

static int py_srvsvc_NetSrvInfo1530_set_minfreeworkitems(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1530 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minfreeworkitems");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minfreeworkitems));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minfreeworkitems = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1530_getsetters[] = {
	{
		.name = discard_const_p(char, "minfreeworkitems"),
		.get = py_srvsvc_NetSrvInfo1530_get_minfreeworkitems,
		.set = py_srvsvc_NetSrvInfo1530_set_minfreeworkitems,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1530_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1530, type);
}


static PyTypeObject srvsvc_NetSrvInfo1530_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1530",
	.tp_getset = py_srvsvc_NetSrvInfo1530_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1530_new,
};


static PyObject *py_srvsvc_NetSrvInfo1533_get_maxmpxct(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1533 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxmpxct;
	py_maxmpxct = PyLong_FromUnsignedLongLong((uint32_t)(object->maxmpxct));
	return py_maxmpxct;
}

static int py_srvsvc_NetSrvInfo1533_set_maxmpxct(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1533 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxmpxct");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxmpxct));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxmpxct = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1533_getsetters[] = {
	{
		.name = discard_const_p(char, "maxmpxct"),
		.get = py_srvsvc_NetSrvInfo1533_get_maxmpxct,
		.set = py_srvsvc_NetSrvInfo1533_set_maxmpxct,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1533_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1533, type);
}


static PyTypeObject srvsvc_NetSrvInfo1533_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1533",
	.tp_getset = py_srvsvc_NetSrvInfo1533_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1533_new,
};


static PyObject *py_srvsvc_NetSrvInfo1534_get_oplockbreakwait(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1534 *object = pytalloc_get_ptr(obj);
	PyObject *py_oplockbreakwait;
	py_oplockbreakwait = PyLong_FromUnsignedLongLong((uint32_t)(object->oplockbreakwait));
	return py_oplockbreakwait;
}

static int py_srvsvc_NetSrvInfo1534_set_oplockbreakwait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1534 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oplockbreakwait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->oplockbreakwait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->oplockbreakwait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1534_getsetters[] = {
	{
		.name = discard_const_p(char, "oplockbreakwait"),
		.get = py_srvsvc_NetSrvInfo1534_get_oplockbreakwait,
		.set = py_srvsvc_NetSrvInfo1534_set_oplockbreakwait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1534_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1534, type);
}


static PyTypeObject srvsvc_NetSrvInfo1534_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1534",
	.tp_getset = py_srvsvc_NetSrvInfo1534_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1534_new,
};


static PyObject *py_srvsvc_NetSrvInfo1535_get_oplockbreakresponsewait(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1535 *object = pytalloc_get_ptr(obj);
	PyObject *py_oplockbreakresponsewait;
	py_oplockbreakresponsewait = PyLong_FromUnsignedLongLong((uint32_t)(object->oplockbreakresponsewait));
	return py_oplockbreakresponsewait;
}

static int py_srvsvc_NetSrvInfo1535_set_oplockbreakresponsewait(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1535 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oplockbreakresponsewait");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->oplockbreakresponsewait));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->oplockbreakresponsewait = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1535_getsetters[] = {
	{
		.name = discard_const_p(char, "oplockbreakresponsewait"),
		.get = py_srvsvc_NetSrvInfo1535_get_oplockbreakresponsewait,
		.set = py_srvsvc_NetSrvInfo1535_set_oplockbreakresponsewait,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1535_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1535, type);
}


static PyTypeObject srvsvc_NetSrvInfo1535_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1535",
	.tp_getset = py_srvsvc_NetSrvInfo1535_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1535_new,
};


static PyObject *py_srvsvc_NetSrvInfo1536_get_enableoplocks(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1536 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableoplocks;
	py_enableoplocks = PyLong_FromUnsignedLongLong((uint32_t)(object->enableoplocks));
	return py_enableoplocks;
}

static int py_srvsvc_NetSrvInfo1536_set_enableoplocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1536 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableoplocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableoplocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableoplocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1536_getsetters[] = {
	{
		.name = discard_const_p(char, "enableoplocks"),
		.get = py_srvsvc_NetSrvInfo1536_get_enableoplocks,
		.set = py_srvsvc_NetSrvInfo1536_set_enableoplocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1536_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1536, type);
}


static PyTypeObject srvsvc_NetSrvInfo1536_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1536",
	.tp_getset = py_srvsvc_NetSrvInfo1536_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1536_new,
};


static PyObject *py_srvsvc_NetSrvInfo1537_get_enableoplockforceclose(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1537 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableoplockforceclose;
	py_enableoplockforceclose = PyLong_FromUnsignedLongLong((uint32_t)(object->enableoplockforceclose));
	return py_enableoplockforceclose;
}

static int py_srvsvc_NetSrvInfo1537_set_enableoplockforceclose(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1537 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableoplockforceclose");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableoplockforceclose));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableoplockforceclose = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1537_getsetters[] = {
	{
		.name = discard_const_p(char, "enableoplockforceclose"),
		.get = py_srvsvc_NetSrvInfo1537_get_enableoplockforceclose,
		.set = py_srvsvc_NetSrvInfo1537_set_enableoplockforceclose,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1537_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1537, type);
}


static PyTypeObject srvsvc_NetSrvInfo1537_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1537",
	.tp_getset = py_srvsvc_NetSrvInfo1537_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1537_new,
};


static PyObject *py_srvsvc_NetSrvInfo1538_get_enablefcbopens(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1538 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablefcbopens;
	py_enablefcbopens = PyLong_FromUnsignedLongLong((uint32_t)(object->enablefcbopens));
	return py_enablefcbopens;
}

static int py_srvsvc_NetSrvInfo1538_set_enablefcbopens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1538 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablefcbopens");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablefcbopens));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablefcbopens = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1538_getsetters[] = {
	{
		.name = discard_const_p(char, "enablefcbopens"),
		.get = py_srvsvc_NetSrvInfo1538_get_enablefcbopens,
		.set = py_srvsvc_NetSrvInfo1538_set_enablefcbopens,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1538_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1538, type);
}


static PyTypeObject srvsvc_NetSrvInfo1538_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1538",
	.tp_getset = py_srvsvc_NetSrvInfo1538_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1538_new,
};


static PyObject *py_srvsvc_NetSrvInfo1539_get_enableraw(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1539 *object = pytalloc_get_ptr(obj);
	PyObject *py_enableraw;
	py_enableraw = PyLong_FromUnsignedLongLong((uint32_t)(object->enableraw));
	return py_enableraw;
}

static int py_srvsvc_NetSrvInfo1539_set_enableraw(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1539 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enableraw");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enableraw));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enableraw = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1539_getsetters[] = {
	{
		.name = discard_const_p(char, "enableraw"),
		.get = py_srvsvc_NetSrvInfo1539_get_enableraw,
		.set = py_srvsvc_NetSrvInfo1539_set_enableraw,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1539_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1539, type);
}


static PyTypeObject srvsvc_NetSrvInfo1539_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1539",
	.tp_getset = py_srvsvc_NetSrvInfo1539_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1539_new,
};


static PyObject *py_srvsvc_NetSrvInfo1540_get_enablesharednetdrives(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1540 *object = pytalloc_get_ptr(obj);
	PyObject *py_enablesharednetdrives;
	py_enablesharednetdrives = PyLong_FromUnsignedLongLong((uint32_t)(object->enablesharednetdrives));
	return py_enablesharednetdrives;
}

static int py_srvsvc_NetSrvInfo1540_set_enablesharednetdrives(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1540 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->enablesharednetdrives");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->enablesharednetdrives));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->enablesharednetdrives = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1540_getsetters[] = {
	{
		.name = discard_const_p(char, "enablesharednetdrives"),
		.get = py_srvsvc_NetSrvInfo1540_get_enablesharednetdrives,
		.set = py_srvsvc_NetSrvInfo1540_set_enablesharednetdrives,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1540_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1540, type);
}


static PyTypeObject srvsvc_NetSrvInfo1540_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1540",
	.tp_getset = py_srvsvc_NetSrvInfo1540_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1540_new,
};


static PyObject *py_srvsvc_NetSrvInfo1541_get_minfreeconnections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1541 *object = pytalloc_get_ptr(obj);
	PyObject *py_minfreeconnections;
	py_minfreeconnections = PyLong_FromUnsignedLongLong((uint32_t)(object->minfreeconnections));
	return py_minfreeconnections;
}

static int py_srvsvc_NetSrvInfo1541_set_minfreeconnections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1541 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minfreeconnections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minfreeconnections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minfreeconnections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1541_getsetters[] = {
	{
		.name = discard_const_p(char, "minfreeconnections"),
		.get = py_srvsvc_NetSrvInfo1541_get_minfreeconnections,
		.set = py_srvsvc_NetSrvInfo1541_set_minfreeconnections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1541_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1541, type);
}


static PyTypeObject srvsvc_NetSrvInfo1541_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1541",
	.tp_getset = py_srvsvc_NetSrvInfo1541_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1541_new,
};


static PyObject *py_srvsvc_NetSrvInfo1542_get_maxfreeconnections(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1542 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxfreeconnections;
	py_maxfreeconnections = PyLong_FromUnsignedLongLong((uint32_t)(object->maxfreeconnections));
	return py_maxfreeconnections;
}

static int py_srvsvc_NetSrvInfo1542_set_maxfreeconnections(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1542 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxfreeconnections");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxfreeconnections));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxfreeconnections = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1542_getsetters[] = {
	{
		.name = discard_const_p(char, "maxfreeconnections"),
		.get = py_srvsvc_NetSrvInfo1542_get_maxfreeconnections,
		.set = py_srvsvc_NetSrvInfo1542_set_maxfreeconnections,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1542_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1542, type);
}


static PyTypeObject srvsvc_NetSrvInfo1542_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1542",
	.tp_getset = py_srvsvc_NetSrvInfo1542_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1542_new,
};


static PyObject *py_srvsvc_NetSrvInfo1543_get_initsesstable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1543 *object = pytalloc_get_ptr(obj);
	PyObject *py_initsesstable;
	py_initsesstable = PyLong_FromUnsignedLongLong((uint32_t)(object->initsesstable));
	return py_initsesstable;
}

static int py_srvsvc_NetSrvInfo1543_set_initsesstable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1543 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initsesstable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initsesstable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initsesstable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1543_getsetters[] = {
	{
		.name = discard_const_p(char, "initsesstable"),
		.get = py_srvsvc_NetSrvInfo1543_get_initsesstable,
		.set = py_srvsvc_NetSrvInfo1543_set_initsesstable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1543_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1543, type);
}


static PyTypeObject srvsvc_NetSrvInfo1543_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1543",
	.tp_getset = py_srvsvc_NetSrvInfo1543_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1543_new,
};


static PyObject *py_srvsvc_NetSrvInfo1544_get_initconntable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1544 *object = pytalloc_get_ptr(obj);
	PyObject *py_initconntable;
	py_initconntable = PyLong_FromUnsignedLongLong((uint32_t)(object->initconntable));
	return py_initconntable;
}

static int py_srvsvc_NetSrvInfo1544_set_initconntable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1544 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initconntable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initconntable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initconntable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1544_getsetters[] = {
	{
		.name = discard_const_p(char, "initconntable"),
		.get = py_srvsvc_NetSrvInfo1544_get_initconntable,
		.set = py_srvsvc_NetSrvInfo1544_set_initconntable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1544_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1544, type);
}


static PyTypeObject srvsvc_NetSrvInfo1544_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1544",
	.tp_getset = py_srvsvc_NetSrvInfo1544_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1544_new,
};


static PyObject *py_srvsvc_NetSrvInfo1545_get_initfiletable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1545 *object = pytalloc_get_ptr(obj);
	PyObject *py_initfiletable;
	py_initfiletable = PyLong_FromUnsignedLongLong((uint32_t)(object->initfiletable));
	return py_initfiletable;
}

static int py_srvsvc_NetSrvInfo1545_set_initfiletable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1545 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initfiletable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initfiletable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initfiletable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1545_getsetters[] = {
	{
		.name = discard_const_p(char, "initfiletable"),
		.get = py_srvsvc_NetSrvInfo1545_get_initfiletable,
		.set = py_srvsvc_NetSrvInfo1545_set_initfiletable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1545_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1545, type);
}


static PyTypeObject srvsvc_NetSrvInfo1545_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1545",
	.tp_getset = py_srvsvc_NetSrvInfo1545_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1545_new,
};


static PyObject *py_srvsvc_NetSrvInfo1546_get_initsearchtable(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1546 *object = pytalloc_get_ptr(obj);
	PyObject *py_initsearchtable;
	py_initsearchtable = PyLong_FromUnsignedLongLong((uint32_t)(object->initsearchtable));
	return py_initsearchtable;
}

static int py_srvsvc_NetSrvInfo1546_set_initsearchtable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1546 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->initsearchtable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->initsearchtable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->initsearchtable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1546_getsetters[] = {
	{
		.name = discard_const_p(char, "initsearchtable"),
		.get = py_srvsvc_NetSrvInfo1546_get_initsearchtable,
		.set = py_srvsvc_NetSrvInfo1546_set_initsearchtable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1546_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1546, type);
}


static PyTypeObject srvsvc_NetSrvInfo1546_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1546",
	.tp_getset = py_srvsvc_NetSrvInfo1546_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1546_new,
};


static PyObject *py_srvsvc_NetSrvInfo1547_get_alertsched(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1547 *object = pytalloc_get_ptr(obj);
	PyObject *py_alertsched;
	py_alertsched = PyLong_FromUnsignedLongLong((uint32_t)(object->alertsched));
	return py_alertsched;
}

static int py_srvsvc_NetSrvInfo1547_set_alertsched(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1547 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alertsched");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alertsched));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alertsched = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1547_getsetters[] = {
	{
		.name = discard_const_p(char, "alertsched"),
		.get = py_srvsvc_NetSrvInfo1547_get_alertsched,
		.set = py_srvsvc_NetSrvInfo1547_set_alertsched,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1547_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1547, type);
}


static PyTypeObject srvsvc_NetSrvInfo1547_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1547",
	.tp_getset = py_srvsvc_NetSrvInfo1547_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1547_new,
};


static PyObject *py_srvsvc_NetSrvInfo1548_get_errortreshold(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1548 *object = pytalloc_get_ptr(obj);
	PyObject *py_errortreshold;
	py_errortreshold = PyLong_FromUnsignedLongLong((uint32_t)(object->errortreshold));
	return py_errortreshold;
}

static int py_srvsvc_NetSrvInfo1548_set_errortreshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1548 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->errortreshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->errortreshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->errortreshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1548_getsetters[] = {
	{
		.name = discard_const_p(char, "errortreshold"),
		.get = py_srvsvc_NetSrvInfo1548_get_errortreshold,
		.set = py_srvsvc_NetSrvInfo1548_set_errortreshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1548_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1548, type);
}


static PyTypeObject srvsvc_NetSrvInfo1548_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1548",
	.tp_getset = py_srvsvc_NetSrvInfo1548_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1548_new,
};


static PyObject *py_srvsvc_NetSrvInfo1549_get_networkerrortreshold(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1549 *object = pytalloc_get_ptr(obj);
	PyObject *py_networkerrortreshold;
	py_networkerrortreshold = PyLong_FromUnsignedLongLong((uint32_t)(object->networkerrortreshold));
	return py_networkerrortreshold;
}

static int py_srvsvc_NetSrvInfo1549_set_networkerrortreshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1549 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->networkerrortreshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->networkerrortreshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->networkerrortreshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1549_getsetters[] = {
	{
		.name = discard_const_p(char, "networkerrortreshold"),
		.get = py_srvsvc_NetSrvInfo1549_get_networkerrortreshold,
		.set = py_srvsvc_NetSrvInfo1549_set_networkerrortreshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1549_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1549, type);
}


static PyTypeObject srvsvc_NetSrvInfo1549_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1549",
	.tp_getset = py_srvsvc_NetSrvInfo1549_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1549_new,
};


static PyObject *py_srvsvc_NetSrvInfo1550_get_diskspacetreshold(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1550 *object = pytalloc_get_ptr(obj);
	PyObject *py_diskspacetreshold;
	py_diskspacetreshold = PyLong_FromUnsignedLongLong((uint32_t)(object->diskspacetreshold));
	return py_diskspacetreshold;
}

static int py_srvsvc_NetSrvInfo1550_set_diskspacetreshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1550 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->diskspacetreshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->diskspacetreshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->diskspacetreshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1550_getsetters[] = {
	{
		.name = discard_const_p(char, "diskspacetreshold"),
		.get = py_srvsvc_NetSrvInfo1550_get_diskspacetreshold,
		.set = py_srvsvc_NetSrvInfo1550_set_diskspacetreshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1550_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1550, type);
}


static PyTypeObject srvsvc_NetSrvInfo1550_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1550",
	.tp_getset = py_srvsvc_NetSrvInfo1550_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1550_new,
};


static PyObject *py_srvsvc_NetSrvInfo1552_get_maxlinkdelay(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1552 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxlinkdelay;
	py_maxlinkdelay = PyLong_FromUnsignedLongLong((uint32_t)(object->maxlinkdelay));
	return py_maxlinkdelay;
}

static int py_srvsvc_NetSrvInfo1552_set_maxlinkdelay(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1552 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxlinkdelay");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxlinkdelay));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxlinkdelay = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1552_getsetters[] = {
	{
		.name = discard_const_p(char, "maxlinkdelay"),
		.get = py_srvsvc_NetSrvInfo1552_get_maxlinkdelay,
		.set = py_srvsvc_NetSrvInfo1552_set_maxlinkdelay,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1552_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1552, type);
}


static PyTypeObject srvsvc_NetSrvInfo1552_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1552",
	.tp_getset = py_srvsvc_NetSrvInfo1552_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1552_new,
};


static PyObject *py_srvsvc_NetSrvInfo1553_get_minlinkthroughput(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1553 *object = pytalloc_get_ptr(obj);
	PyObject *py_minlinkthroughput;
	py_minlinkthroughput = PyLong_FromUnsignedLongLong((uint32_t)(object->minlinkthroughput));
	return py_minlinkthroughput;
}

static int py_srvsvc_NetSrvInfo1553_set_minlinkthroughput(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1553 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minlinkthroughput");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minlinkthroughput));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minlinkthroughput = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1553_getsetters[] = {
	{
		.name = discard_const_p(char, "minlinkthroughput"),
		.get = py_srvsvc_NetSrvInfo1553_get_minlinkthroughput,
		.set = py_srvsvc_NetSrvInfo1553_set_minlinkthroughput,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1553_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1553, type);
}


static PyTypeObject srvsvc_NetSrvInfo1553_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1553",
	.tp_getset = py_srvsvc_NetSrvInfo1553_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1553_new,
};


static PyObject *py_srvsvc_NetSrvInfo1554_get_linkinfovalidtime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1554 *object = pytalloc_get_ptr(obj);
	PyObject *py_linkinfovalidtime;
	py_linkinfovalidtime = PyLong_FromUnsignedLongLong((uint32_t)(object->linkinfovalidtime));
	return py_linkinfovalidtime;
}

static int py_srvsvc_NetSrvInfo1554_set_linkinfovalidtime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1554 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->linkinfovalidtime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->linkinfovalidtime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->linkinfovalidtime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1554_getsetters[] = {
	{
		.name = discard_const_p(char, "linkinfovalidtime"),
		.get = py_srvsvc_NetSrvInfo1554_get_linkinfovalidtime,
		.set = py_srvsvc_NetSrvInfo1554_set_linkinfovalidtime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1554_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1554, type);
}


static PyTypeObject srvsvc_NetSrvInfo1554_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1554",
	.tp_getset = py_srvsvc_NetSrvInfo1554_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1554_new,
};


static PyObject *py_srvsvc_NetSrvInfo1555_get_scavqosinfoupdatetime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1555 *object = pytalloc_get_ptr(obj);
	PyObject *py_scavqosinfoupdatetime;
	py_scavqosinfoupdatetime = PyLong_FromUnsignedLongLong((uint32_t)(object->scavqosinfoupdatetime));
	return py_scavqosinfoupdatetime;
}

static int py_srvsvc_NetSrvInfo1555_set_scavqosinfoupdatetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1555 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scavqosinfoupdatetime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->scavqosinfoupdatetime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->scavqosinfoupdatetime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1555_getsetters[] = {
	{
		.name = discard_const_p(char, "scavqosinfoupdatetime"),
		.get = py_srvsvc_NetSrvInfo1555_get_scavqosinfoupdatetime,
		.set = py_srvsvc_NetSrvInfo1555_set_scavqosinfoupdatetime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1555_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1555, type);
}


static PyTypeObject srvsvc_NetSrvInfo1555_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1555",
	.tp_getset = py_srvsvc_NetSrvInfo1555_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1555_new,
};


static PyObject *py_srvsvc_NetSrvInfo1556_get_maxworkitemidletime(PyObject *obj, void *closure)
{
	struct srvsvc_NetSrvInfo1556 *object = pytalloc_get_ptr(obj);
	PyObject *py_maxworkitemidletime;
	py_maxworkitemidletime = PyLong_FromUnsignedLongLong((uint32_t)(object->maxworkitemidletime));
	return py_maxworkitemidletime;
}

static int py_srvsvc_NetSrvInfo1556_set_maxworkitemidletime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetSrvInfo1556 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxworkitemidletime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxworkitemidletime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxworkitemidletime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetSrvInfo1556_getsetters[] = {
	{
		.name = discard_const_p(char, "maxworkitemidletime"),
		.get = py_srvsvc_NetSrvInfo1556_get_maxworkitemidletime,
		.set = py_srvsvc_NetSrvInfo1556_set_maxworkitemidletime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetSrvInfo1556_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetSrvInfo1556, type);
}


static PyTypeObject srvsvc_NetSrvInfo1556_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo1556",
	.tp_getset = py_srvsvc_NetSrvInfo1556_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo1556_new,
};

static PyObject *py_import_srvsvc_NetSrvInfo(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetSrvInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 100:
			if (in->info100 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo100_Type, in->info100, in->info100);
			}
			return ret;

		case 101:
			if (in->info101 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo101_Type, in->info101, in->info101);
			}
			return ret;

		case 102:
			if (in->info102 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo102_Type, in->info102, in->info102);
			}
			return ret;

		case 402:
			if (in->info402 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo402_Type, in->info402, in->info402);
			}
			return ret;

		case 403:
			if (in->info403 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo403_Type, in->info403, in->info403);
			}
			return ret;

		case 502:
			if (in->info502 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo502_Type, in->info502, in->info502);
			}
			return ret;

		case 503:
			if (in->info503 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo503_Type, in->info503, in->info503);
			}
			return ret;

		case 599:
			if (in->info599 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo599_Type, in->info599, in->info599);
			}
			return ret;

		case 1005:
			if (in->info1005 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1005_Type, in->info1005, in->info1005);
			}
			return ret;

		case 1010:
			if (in->info1010 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1010_Type, in->info1010, in->info1010);
			}
			return ret;

		case 1016:
			if (in->info1016 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1016_Type, in->info1016, in->info1016);
			}
			return ret;

		case 1017:
			if (in->info1017 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1017_Type, in->info1017, in->info1017);
			}
			return ret;

		case 1018:
			if (in->info1018 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1018_Type, in->info1018, in->info1018);
			}
			return ret;

		case 1107:
			if (in->info1107 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1107_Type, in->info1107, in->info1107);
			}
			return ret;

		case 1501:
			if (in->info1501 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1501_Type, in->info1501, in->info1501);
			}
			return ret;

		case 1502:
			if (in->info1502 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1502_Type, in->info1502, in->info1502);
			}
			return ret;

		case 1503:
			if (in->info1503 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1503_Type, in->info1503, in->info1503);
			}
			return ret;

		case 1506:
			if (in->info1506 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1506_Type, in->info1506, in->info1506);
			}
			return ret;

		case 1509:
			if (in->info1509 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1509_Type, in->info1509, in->info1509);
			}
			return ret;

		case 1510:
			if (in->info1510 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1510_Type, in->info1510, in->info1510);
			}
			return ret;

		case 1511:
			if (in->info1511 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1511_Type, in->info1511, in->info1511);
			}
			return ret;

		case 1512:
			if (in->info1512 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1512_Type, in->info1512, in->info1512);
			}
			return ret;

		case 1513:
			if (in->info1513 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1513_Type, in->info1513, in->info1513);
			}
			return ret;

		case 1514:
			if (in->info1514 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1514_Type, in->info1514, in->info1514);
			}
			return ret;

		case 1515:
			if (in->info1515 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1515_Type, in->info1515, in->info1515);
			}
			return ret;

		case 1516:
			if (in->info1516 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1516_Type, in->info1516, in->info1516);
			}
			return ret;

		case 1518:
			if (in->info1518 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1518_Type, in->info1518, in->info1518);
			}
			return ret;

		case 1520:
			if (in->info1520 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1520_Type, in->info1520, in->info1520);
			}
			return ret;

		case 1521:
			if (in->info1521 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1521_Type, in->info1521, in->info1521);
			}
			return ret;

		case 1522:
			if (in->info1522 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1522_Type, in->info1522, in->info1522);
			}
			return ret;

		case 1523:
			if (in->info1523 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1523_Type, in->info1523, in->info1523);
			}
			return ret;

		case 1524:
			if (in->info1524 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1524_Type, in->info1524, in->info1524);
			}
			return ret;

		case 1525:
			if (in->info1525 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1525_Type, in->info1525, in->info1525);
			}
			return ret;

		case 1528:
			if (in->info1528 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1528_Type, in->info1528, in->info1528);
			}
			return ret;

		case 1529:
			if (in->info1529 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1529_Type, in->info1529, in->info1529);
			}
			return ret;

		case 1530:
			if (in->info1530 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1530_Type, in->info1530, in->info1530);
			}
			return ret;

		case 1533:
			if (in->info1533 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1533_Type, in->info1533, in->info1533);
			}
			return ret;

		case 1534:
			if (in->info1534 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1534_Type, in->info1534, in->info1534);
			}
			return ret;

		case 1535:
			if (in->info1535 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1535_Type, in->info1535, in->info1535);
			}
			return ret;

		case 1536:
			if (in->info1536 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1536_Type, in->info1536, in->info1536);
			}
			return ret;

		case 1537:
			if (in->info1537 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1537_Type, in->info1537, in->info1537);
			}
			return ret;

		case 1538:
			if (in->info1538 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1538_Type, in->info1538, in->info1538);
			}
			return ret;

		case 1539:
			if (in->info1539 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1539_Type, in->info1539, in->info1539);
			}
			return ret;

		case 1540:
			if (in->info1540 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1540_Type, in->info1540, in->info1540);
			}
			return ret;

		case 1541:
			if (in->info1541 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1541_Type, in->info1541, in->info1541);
			}
			return ret;

		case 1542:
			if (in->info1542 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1542_Type, in->info1542, in->info1542);
			}
			return ret;

		case 1543:
			if (in->info1543 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1543_Type, in->info1543, in->info1543);
			}
			return ret;

		case 1544:
			if (in->info1544 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1544_Type, in->info1544, in->info1544);
			}
			return ret;

		case 1545:
			if (in->info1545 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1545_Type, in->info1545, in->info1545);
			}
			return ret;

		case 1546:
			if (in->info1546 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1546_Type, in->info1546, in->info1546);
			}
			return ret;

		case 1547:
			if (in->info1547 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1547_Type, in->info1547, in->info1547);
			}
			return ret;

		case 1548:
			if (in->info1548 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1548_Type, in->info1548, in->info1548);
			}
			return ret;

		case 1549:
			if (in->info1549 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1549_Type, in->info1549, in->info1549);
			}
			return ret;

		case 1550:
			if (in->info1550 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1550_Type, in->info1550, in->info1550);
			}
			return ret;

		case 1552:
			if (in->info1552 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1552_Type, in->info1552, in->info1552);
			}
			return ret;

		case 1553:
			if (in->info1553 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1553_Type, in->info1553, in->info1553);
			}
			return ret;

		case 1554:
			if (in->info1554 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1554_Type, in->info1554, in->info1554);
			}
			return ret;

		case 1555:
			if (in->info1555 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1555_Type, in->info1555, in->info1555);
			}
			return ret;

		case 1556:
			if (in->info1556 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetSrvInfo1556_Type, in->info1556, in->info1556);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetSrvInfo *py_export_srvsvc_NetSrvInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetSrvInfo *ret = talloc_zero(mem_ctx, union srvsvc_NetSrvInfo);
	switch (level) {
		case 100:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info100");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info100 = NULL;
			} else {
				ret->info100 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo100_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info100 = (struct srvsvc_NetSrvInfo100 *)pytalloc_get_ptr(in);
			}
			break;

		case 101:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info101");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info101 = NULL;
			} else {
				ret->info101 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo101_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info101 = (struct srvsvc_NetSrvInfo101 *)pytalloc_get_ptr(in);
			}
			break;

		case 102:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info102");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info102 = NULL;
			} else {
				ret->info102 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo102_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info102 = (struct srvsvc_NetSrvInfo102 *)pytalloc_get_ptr(in);
			}
			break;

		case 402:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info402");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info402 = NULL;
			} else {
				ret->info402 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo402_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info402 = (struct srvsvc_NetSrvInfo402 *)pytalloc_get_ptr(in);
			}
			break;

		case 403:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info403");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info403 = NULL;
			} else {
				ret->info403 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo403_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info403 = (struct srvsvc_NetSrvInfo403 *)pytalloc_get_ptr(in);
			}
			break;

		case 502:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info502");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info502 = NULL;
			} else {
				ret->info502 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo502_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info502 = (struct srvsvc_NetSrvInfo502 *)pytalloc_get_ptr(in);
			}
			break;

		case 503:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info503");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info503 = NULL;
			} else {
				ret->info503 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo503_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info503 = (struct srvsvc_NetSrvInfo503 *)pytalloc_get_ptr(in);
			}
			break;

		case 599:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info599");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info599 = NULL;
			} else {
				ret->info599 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo599_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info599 = (struct srvsvc_NetSrvInfo599 *)pytalloc_get_ptr(in);
			}
			break;

		case 1005:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1005");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1005 = NULL;
			} else {
				ret->info1005 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1005_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1005 = (struct srvsvc_NetSrvInfo1005 *)pytalloc_get_ptr(in);
			}
			break;

		case 1010:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1010");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1010 = NULL;
			} else {
				ret->info1010 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1010_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1010 = (struct srvsvc_NetSrvInfo1010 *)pytalloc_get_ptr(in);
			}
			break;

		case 1016:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1016");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1016 = NULL;
			} else {
				ret->info1016 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1016_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1016 = (struct srvsvc_NetSrvInfo1016 *)pytalloc_get_ptr(in);
			}
			break;

		case 1017:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1017");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1017 = NULL;
			} else {
				ret->info1017 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1017_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1017 = (struct srvsvc_NetSrvInfo1017 *)pytalloc_get_ptr(in);
			}
			break;

		case 1018:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1018");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1018 = NULL;
			} else {
				ret->info1018 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1018_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1018 = (struct srvsvc_NetSrvInfo1018 *)pytalloc_get_ptr(in);
			}
			break;

		case 1107:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1107");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1107 = NULL;
			} else {
				ret->info1107 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1107_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1107 = (struct srvsvc_NetSrvInfo1107 *)pytalloc_get_ptr(in);
			}
			break;

		case 1501:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1501");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1501 = NULL;
			} else {
				ret->info1501 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1501_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1501 = (struct srvsvc_NetSrvInfo1501 *)pytalloc_get_ptr(in);
			}
			break;

		case 1502:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1502");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1502 = NULL;
			} else {
				ret->info1502 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1502_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1502 = (struct srvsvc_NetSrvInfo1502 *)pytalloc_get_ptr(in);
			}
			break;

		case 1503:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1503");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1503 = NULL;
			} else {
				ret->info1503 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1503_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1503 = (struct srvsvc_NetSrvInfo1503 *)pytalloc_get_ptr(in);
			}
			break;

		case 1506:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1506");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1506 = NULL;
			} else {
				ret->info1506 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1506_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1506 = (struct srvsvc_NetSrvInfo1506 *)pytalloc_get_ptr(in);
			}
			break;

		case 1509:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1509");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1509 = NULL;
			} else {
				ret->info1509 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1509_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1509 = (struct srvsvc_NetSrvInfo1509 *)pytalloc_get_ptr(in);
			}
			break;

		case 1510:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1510");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1510 = NULL;
			} else {
				ret->info1510 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1510_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1510 = (struct srvsvc_NetSrvInfo1510 *)pytalloc_get_ptr(in);
			}
			break;

		case 1511:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1511");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1511 = NULL;
			} else {
				ret->info1511 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1511_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1511 = (struct srvsvc_NetSrvInfo1511 *)pytalloc_get_ptr(in);
			}
			break;

		case 1512:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1512");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1512 = NULL;
			} else {
				ret->info1512 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1512_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1512 = (struct srvsvc_NetSrvInfo1512 *)pytalloc_get_ptr(in);
			}
			break;

		case 1513:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1513");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1513 = NULL;
			} else {
				ret->info1513 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1513_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1513 = (struct srvsvc_NetSrvInfo1513 *)pytalloc_get_ptr(in);
			}
			break;

		case 1514:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1514");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1514 = NULL;
			} else {
				ret->info1514 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1514_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1514 = (struct srvsvc_NetSrvInfo1514 *)pytalloc_get_ptr(in);
			}
			break;

		case 1515:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1515");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1515 = NULL;
			} else {
				ret->info1515 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1515_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1515 = (struct srvsvc_NetSrvInfo1515 *)pytalloc_get_ptr(in);
			}
			break;

		case 1516:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1516");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1516 = NULL;
			} else {
				ret->info1516 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1516_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1516 = (struct srvsvc_NetSrvInfo1516 *)pytalloc_get_ptr(in);
			}
			break;

		case 1518:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1518");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1518 = NULL;
			} else {
				ret->info1518 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1518_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1518 = (struct srvsvc_NetSrvInfo1518 *)pytalloc_get_ptr(in);
			}
			break;

		case 1520:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1520");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1520 = NULL;
			} else {
				ret->info1520 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1520_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1520 = (struct srvsvc_NetSrvInfo1520 *)pytalloc_get_ptr(in);
			}
			break;

		case 1521:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1521");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1521 = NULL;
			} else {
				ret->info1521 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1521_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1521 = (struct srvsvc_NetSrvInfo1521 *)pytalloc_get_ptr(in);
			}
			break;

		case 1522:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1522");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1522 = NULL;
			} else {
				ret->info1522 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1522_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1522 = (struct srvsvc_NetSrvInfo1522 *)pytalloc_get_ptr(in);
			}
			break;

		case 1523:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1523");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1523 = NULL;
			} else {
				ret->info1523 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1523_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1523 = (struct srvsvc_NetSrvInfo1523 *)pytalloc_get_ptr(in);
			}
			break;

		case 1524:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1524");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1524 = NULL;
			} else {
				ret->info1524 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1524_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1524 = (struct srvsvc_NetSrvInfo1524 *)pytalloc_get_ptr(in);
			}
			break;

		case 1525:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1525");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1525 = NULL;
			} else {
				ret->info1525 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1525_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1525 = (struct srvsvc_NetSrvInfo1525 *)pytalloc_get_ptr(in);
			}
			break;

		case 1528:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1528");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1528 = NULL;
			} else {
				ret->info1528 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1528_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1528 = (struct srvsvc_NetSrvInfo1528 *)pytalloc_get_ptr(in);
			}
			break;

		case 1529:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1529");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1529 = NULL;
			} else {
				ret->info1529 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1529_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1529 = (struct srvsvc_NetSrvInfo1529 *)pytalloc_get_ptr(in);
			}
			break;

		case 1530:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1530");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1530 = NULL;
			} else {
				ret->info1530 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1530_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1530 = (struct srvsvc_NetSrvInfo1530 *)pytalloc_get_ptr(in);
			}
			break;

		case 1533:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1533");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1533 = NULL;
			} else {
				ret->info1533 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1533_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1533 = (struct srvsvc_NetSrvInfo1533 *)pytalloc_get_ptr(in);
			}
			break;

		case 1534:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1534");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1534 = NULL;
			} else {
				ret->info1534 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1534_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1534 = (struct srvsvc_NetSrvInfo1534 *)pytalloc_get_ptr(in);
			}
			break;

		case 1535:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1535");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1535 = NULL;
			} else {
				ret->info1535 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1535_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1535 = (struct srvsvc_NetSrvInfo1535 *)pytalloc_get_ptr(in);
			}
			break;

		case 1536:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1536");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1536 = NULL;
			} else {
				ret->info1536 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1536_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1536 = (struct srvsvc_NetSrvInfo1536 *)pytalloc_get_ptr(in);
			}
			break;

		case 1537:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1537");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1537 = NULL;
			} else {
				ret->info1537 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1537_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1537 = (struct srvsvc_NetSrvInfo1537 *)pytalloc_get_ptr(in);
			}
			break;

		case 1538:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1538");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1538 = NULL;
			} else {
				ret->info1538 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1538_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1538 = (struct srvsvc_NetSrvInfo1538 *)pytalloc_get_ptr(in);
			}
			break;

		case 1539:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1539");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1539 = NULL;
			} else {
				ret->info1539 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1539_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1539 = (struct srvsvc_NetSrvInfo1539 *)pytalloc_get_ptr(in);
			}
			break;

		case 1540:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1540");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1540 = NULL;
			} else {
				ret->info1540 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1540_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1540 = (struct srvsvc_NetSrvInfo1540 *)pytalloc_get_ptr(in);
			}
			break;

		case 1541:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1541");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1541 = NULL;
			} else {
				ret->info1541 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1541_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1541 = (struct srvsvc_NetSrvInfo1541 *)pytalloc_get_ptr(in);
			}
			break;

		case 1542:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1542");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1542 = NULL;
			} else {
				ret->info1542 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1542_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1542 = (struct srvsvc_NetSrvInfo1542 *)pytalloc_get_ptr(in);
			}
			break;

		case 1543:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1543");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1543 = NULL;
			} else {
				ret->info1543 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1543_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1543 = (struct srvsvc_NetSrvInfo1543 *)pytalloc_get_ptr(in);
			}
			break;

		case 1544:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1544");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1544 = NULL;
			} else {
				ret->info1544 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1544_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1544 = (struct srvsvc_NetSrvInfo1544 *)pytalloc_get_ptr(in);
			}
			break;

		case 1545:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1545");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1545 = NULL;
			} else {
				ret->info1545 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1545_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1545 = (struct srvsvc_NetSrvInfo1545 *)pytalloc_get_ptr(in);
			}
			break;

		case 1546:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1546");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1546 = NULL;
			} else {
				ret->info1546 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1546_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1546 = (struct srvsvc_NetSrvInfo1546 *)pytalloc_get_ptr(in);
			}
			break;

		case 1547:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1547");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1547 = NULL;
			} else {
				ret->info1547 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1547_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1547 = (struct srvsvc_NetSrvInfo1547 *)pytalloc_get_ptr(in);
			}
			break;

		case 1548:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1548");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1548 = NULL;
			} else {
				ret->info1548 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1548_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1548 = (struct srvsvc_NetSrvInfo1548 *)pytalloc_get_ptr(in);
			}
			break;

		case 1549:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1549");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1549 = NULL;
			} else {
				ret->info1549 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1549_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1549 = (struct srvsvc_NetSrvInfo1549 *)pytalloc_get_ptr(in);
			}
			break;

		case 1550:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1550");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1550 = NULL;
			} else {
				ret->info1550 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1550_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1550 = (struct srvsvc_NetSrvInfo1550 *)pytalloc_get_ptr(in);
			}
			break;

		case 1552:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1552");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1552 = NULL;
			} else {
				ret->info1552 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1552_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1552 = (struct srvsvc_NetSrvInfo1552 *)pytalloc_get_ptr(in);
			}
			break;

		case 1553:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1553");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1553 = NULL;
			} else {
				ret->info1553 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1553_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1553 = (struct srvsvc_NetSrvInfo1553 *)pytalloc_get_ptr(in);
			}
			break;

		case 1554:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1554");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1554 = NULL;
			} else {
				ret->info1554 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1554_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1554 = (struct srvsvc_NetSrvInfo1554 *)pytalloc_get_ptr(in);
			}
			break;

		case 1555:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1555");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1555 = NULL;
			} else {
				ret->info1555 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1555_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1555 = (struct srvsvc_NetSrvInfo1555 *)pytalloc_get_ptr(in);
			}
			break;

		case 1556:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1556");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1556 = NULL;
			} else {
				ret->info1556 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetSrvInfo1556_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1556 = (struct srvsvc_NetSrvInfo1556 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetSrvInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetSrvInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetSrvInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetSrvInfo!");
		return NULL;
	}

	return py_import_srvsvc_NetSrvInfo(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetSrvInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetSrvInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetSrvInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetSrvInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSrvInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetSrvInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetSrvInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetSrvInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetSrvInfo",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetSrvInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetSrvInfo_new,
};


static PyObject *py_srvsvc_NetDiskInfo0_get___disk_offset(PyObject *obj, void *closure)
{
	struct srvsvc_NetDiskInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py___disk_offset;
	py___disk_offset = PyLong_FromUnsignedLongLong((uint32_t)(object->__disk_offset));
	return py___disk_offset;
}

static int py_srvsvc_NetDiskInfo0_set___disk_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetDiskInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__disk_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__disk_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__disk_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetDiskInfo0_get___disk_length(PyObject *obj, void *closure)
{
	struct srvsvc_NetDiskInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py___disk_length;
	py___disk_length = PyLong_FromUnsignedLongLong((uint32_t)(object->__disk_length));
	return py___disk_length;
}

static int py_srvsvc_NetDiskInfo0_set___disk_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetDiskInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->__disk_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->__disk_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->__disk_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetDiskInfo0_get_disk(PyObject *obj, void *closure)
{
	struct srvsvc_NetDiskInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_disk;
	if (object->disk == NULL) {
		py_disk = Py_None;
		Py_INCREF(py_disk);
	} else {
		py_disk = PyUnicode_Decode(object->disk, strlen(object->disk), "utf-8", "ignore");
	}
	return py_disk;
}

static int py_srvsvc_NetDiskInfo0_set_disk(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetDiskInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->disk");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->disk = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetDiskInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "__disk_offset"),
		.get = py_srvsvc_NetDiskInfo0_get___disk_offset,
		.set = py_srvsvc_NetDiskInfo0_set___disk_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "__disk_length"),
		.get = py_srvsvc_NetDiskInfo0_get___disk_length,
		.set = py_srvsvc_NetDiskInfo0_set___disk_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "disk"),
		.get = py_srvsvc_NetDiskInfo0_get_disk,
		.set = py_srvsvc_NetDiskInfo0_set_disk,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetDiskInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetDiskInfo0, type);
}


static PyTypeObject srvsvc_NetDiskInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetDiskInfo0",
	.tp_getset = py_srvsvc_NetDiskInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetDiskInfo0_new,
};


static PyObject *py_srvsvc_NetDiskInfo_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetDiskInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetDiskInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetDiskInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetDiskInfo_get_disks(PyObject *obj, void *closure)
{
	struct srvsvc_NetDiskInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_disks;
	if (object->disks == NULL) {
		Py_RETURN_NONE;
	}
	if (object->disks == NULL) {
		py_disks = Py_None;
		Py_INCREF(py_disks);
	} else {
		py_disks = PyList_New(object->count);
		if (py_disks == NULL) {
			return NULL;
		}
		{
			int disks_cntr_1;
			for (disks_cntr_1 = 0; disks_cntr_1 < (object->count); disks_cntr_1++) {
				PyObject *py_disks_1;
				py_disks_1 = pytalloc_reference_ex(&srvsvc_NetDiskInfo0_Type, object->disks, &(object->disks)[disks_cntr_1]);
				PyList_SetItem(py_disks, disks_cntr_1, py_disks_1);
			}
		}
	}
	return py_disks;
}

static int py_srvsvc_NetDiskInfo_set_disks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetDiskInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->disks));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->disks");
		return -1;
	}
	if (value == Py_None) {
		object->disks = NULL;
	} else {
		object->disks = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int disks_cntr_1;
			object->disks = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->disks, PyList_GET_SIZE(value));
			if (!object->disks) { return -1; }
			talloc_set_name_const(object->disks, "ARRAY: object->disks");
			for (disks_cntr_1 = 0; disks_cntr_1 < PyList_GET_SIZE(value); disks_cntr_1++) {
				if (PyList_GET_ITEM(value, disks_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->disks)[disks_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetDiskInfo0_Type, PyList_GET_ITEM(value, disks_cntr_1), return -1;);
				if (talloc_reference(object->disks, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, disks_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->disks)[disks_cntr_1] = *(struct srvsvc_NetDiskInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, disks_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetDiskInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetDiskInfo_get_count,
		.set = py_srvsvc_NetDiskInfo_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "disks"),
		.get = py_srvsvc_NetDiskInfo_get_disks,
		.set = py_srvsvc_NetDiskInfo_set_disks,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetDiskInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetDiskInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetDiskInfo, type);
}


static PyTypeObject srvsvc_NetDiskInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetDiskInfo",
	.tp_getset = py_srvsvc_NetDiskInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetDiskInfo_new,
};


static PyObject *py_srvsvc_Statistics_get_start(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_start;
	py_start = PyLong_FromUnsignedLongLong((uint32_t)(object->start));
	return py_start;
}

static int py_srvsvc_Statistics_set_start(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->start");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->start));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->start = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_fopens(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_fopens;
	py_fopens = PyLong_FromUnsignedLongLong((uint32_t)(object->fopens));
	return py_fopens;
}

static int py_srvsvc_Statistics_set_fopens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fopens");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fopens));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fopens = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_devopens(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_devopens;
	py_devopens = PyLong_FromUnsignedLongLong((uint32_t)(object->devopens));
	return py_devopens;
}

static int py_srvsvc_Statistics_set_devopens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->devopens");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->devopens));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->devopens = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_jobsqueued(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_jobsqueued;
	py_jobsqueued = PyLong_FromUnsignedLongLong((uint32_t)(object->jobsqueued));
	return py_jobsqueued;
}

static int py_srvsvc_Statistics_set_jobsqueued(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->jobsqueued");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->jobsqueued));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->jobsqueued = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_sopens(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_sopens;
	py_sopens = PyLong_FromUnsignedLongLong((uint32_t)(object->sopens));
	return py_sopens;
}

static int py_srvsvc_Statistics_set_sopens(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sopens");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sopens));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sopens = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_stimeouts(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_stimeouts;
	py_stimeouts = PyLong_FromUnsignedLongLong((uint32_t)(object->stimeouts));
	return py_stimeouts;
}

static int py_srvsvc_Statistics_set_stimeouts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->stimeouts");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->stimeouts));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->stimeouts = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_serrorout(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_serrorout;
	py_serrorout = PyLong_FromUnsignedLongLong((uint32_t)(object->serrorout));
	return py_serrorout;
}

static int py_srvsvc_Statistics_set_serrorout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serrorout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serrorout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serrorout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_pwerrors(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_pwerrors;
	py_pwerrors = PyLong_FromUnsignedLongLong((uint32_t)(object->pwerrors));
	return py_pwerrors;
}

static int py_srvsvc_Statistics_set_pwerrors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwerrors");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pwerrors));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pwerrors = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_permerrors(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_permerrors;
	py_permerrors = PyLong_FromUnsignedLongLong((uint32_t)(object->permerrors));
	return py_permerrors;
}

static int py_srvsvc_Statistics_set_permerrors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->permerrors");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->permerrors));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->permerrors = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_syserrors(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_syserrors;
	py_syserrors = PyLong_FromUnsignedLongLong((uint32_t)(object->syserrors));
	return py_syserrors;
}

static int py_srvsvc_Statistics_set_syserrors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->syserrors");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->syserrors));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->syserrors = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_bytessent_low(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_bytessent_low;
	py_bytessent_low = PyLong_FromUnsignedLongLong((uint32_t)(object->bytessent_low));
	return py_bytessent_low;
}

static int py_srvsvc_Statistics_set_bytessent_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bytessent_low");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bytessent_low));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bytessent_low = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_bytessent_high(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_bytessent_high;
	py_bytessent_high = PyLong_FromUnsignedLongLong((uint32_t)(object->bytessent_high));
	return py_bytessent_high;
}

static int py_srvsvc_Statistics_set_bytessent_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bytessent_high");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bytessent_high));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bytessent_high = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_bytesrcvd_low(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_bytesrcvd_low;
	py_bytesrcvd_low = PyLong_FromUnsignedLongLong((uint32_t)(object->bytesrcvd_low));
	return py_bytesrcvd_low;
}

static int py_srvsvc_Statistics_set_bytesrcvd_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bytesrcvd_low");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bytesrcvd_low));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bytesrcvd_low = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_bytesrcvd_high(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_bytesrcvd_high;
	py_bytesrcvd_high = PyLong_FromUnsignedLongLong((uint32_t)(object->bytesrcvd_high));
	return py_bytesrcvd_high;
}

static int py_srvsvc_Statistics_set_bytesrcvd_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bytesrcvd_high");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bytesrcvd_high));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bytesrcvd_high = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_avresponse(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_avresponse;
	py_avresponse = PyLong_FromUnsignedLongLong((uint32_t)(object->avresponse));
	return py_avresponse;
}

static int py_srvsvc_Statistics_set_avresponse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->avresponse");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->avresponse));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->avresponse = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_reqbufneed(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_reqbufneed;
	py_reqbufneed = PyLong_FromUnsignedLongLong((uint32_t)(object->reqbufneed));
	return py_reqbufneed;
}

static int py_srvsvc_Statistics_set_reqbufneed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reqbufneed");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reqbufneed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reqbufneed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_Statistics_get_bigbufneed(PyObject *obj, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_bigbufneed;
	py_bigbufneed = PyLong_FromUnsignedLongLong((uint32_t)(object->bigbufneed));
	return py_bigbufneed;
}

static int py_srvsvc_Statistics_set_bigbufneed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_Statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bigbufneed");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bigbufneed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bigbufneed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_Statistics_getsetters[] = {
	{
		.name = discard_const_p(char, "start"),
		.get = py_srvsvc_Statistics_get_start,
		.set = py_srvsvc_Statistics_set_start,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fopens"),
		.get = py_srvsvc_Statistics_get_fopens,
		.set = py_srvsvc_Statistics_set_fopens,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "devopens"),
		.get = py_srvsvc_Statistics_get_devopens,
		.set = py_srvsvc_Statistics_set_devopens,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "jobsqueued"),
		.get = py_srvsvc_Statistics_get_jobsqueued,
		.set = py_srvsvc_Statistics_set_jobsqueued,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sopens"),
		.get = py_srvsvc_Statistics_get_sopens,
		.set = py_srvsvc_Statistics_set_sopens,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "stimeouts"),
		.get = py_srvsvc_Statistics_get_stimeouts,
		.set = py_srvsvc_Statistics_set_stimeouts,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "serrorout"),
		.get = py_srvsvc_Statistics_get_serrorout,
		.set = py_srvsvc_Statistics_set_serrorout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pwerrors"),
		.get = py_srvsvc_Statistics_get_pwerrors,
		.set = py_srvsvc_Statistics_set_pwerrors,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "permerrors"),
		.get = py_srvsvc_Statistics_get_permerrors,
		.set = py_srvsvc_Statistics_set_permerrors,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "syserrors"),
		.get = py_srvsvc_Statistics_get_syserrors,
		.set = py_srvsvc_Statistics_set_syserrors,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bytessent_low"),
		.get = py_srvsvc_Statistics_get_bytessent_low,
		.set = py_srvsvc_Statistics_set_bytessent_low,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bytessent_high"),
		.get = py_srvsvc_Statistics_get_bytessent_high,
		.set = py_srvsvc_Statistics_set_bytessent_high,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bytesrcvd_low"),
		.get = py_srvsvc_Statistics_get_bytesrcvd_low,
		.set = py_srvsvc_Statistics_set_bytesrcvd_low,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bytesrcvd_high"),
		.get = py_srvsvc_Statistics_get_bytesrcvd_high,
		.set = py_srvsvc_Statistics_set_bytesrcvd_high,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "avresponse"),
		.get = py_srvsvc_Statistics_get_avresponse,
		.set = py_srvsvc_Statistics_set_avresponse,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reqbufneed"),
		.get = py_srvsvc_Statistics_get_reqbufneed,
		.set = py_srvsvc_Statistics_set_reqbufneed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bigbufneed"),
		.get = py_srvsvc_Statistics_get_bigbufneed,
		.set = py_srvsvc_Statistics_set_bigbufneed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_Statistics_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_Statistics, type);
}


static PyTypeObject srvsvc_Statistics_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.Statistics",
	.tp_getset = py_srvsvc_Statistics_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_Statistics_new,
};


static PyObject *py_srvsvc_NetTransportInfo0_get_vcs(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_vcs;
	py_vcs = PyLong_FromUnsignedLongLong((uint32_t)(object->vcs));
	return py_vcs;
}

static int py_srvsvc_NetTransportInfo0_set_vcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vcs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vcs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vcs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo0_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetTransportInfo0_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo0_get_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr;
	if (object->addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->addr == NULL) {
		py_addr = Py_None;
		Py_INCREF(py_addr);
	} else {
		py_addr = PyList_New(object->addr_len);
		if (py_addr == NULL) {
			return NULL;
		}
		{
			int addr_cntr_1;
			for (addr_cntr_1 = 0; addr_cntr_1 < (object->addr_len); addr_cntr_1++) {
				PyObject *py_addr_1;
				py_addr_1 = PyLong_FromLong((uint16_t)((object->addr)[addr_cntr_1]));
				PyList_SetItem(py_addr, addr_cntr_1, py_addr_1);
			}
		}
	}
	return py_addr;
}

static int py_srvsvc_NetTransportInfo0_set_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->addr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr");
		return -1;
	}
	if (value == Py_None) {
		object->addr = NULL;
	} else {
		object->addr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int addr_cntr_1;
			object->addr = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addr, PyList_GET_SIZE(value));
			if (!object->addr) { return -1; }
			talloc_set_name_const(object->addr, "ARRAY: object->addr");
			for (addr_cntr_1 = 0; addr_cntr_1 < PyList_GET_SIZE(value); addr_cntr_1++) {
				if (PyList_GET_ITEM(value, addr_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->addr)[addr_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->addr)[addr_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, addr_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, addr_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->addr)[addr_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo0_get_addr_len(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr_len;
	py_addr_len = PyLong_FromUnsignedLongLong((uint32_t)(object->addr_len));
	return py_addr_len;
}

static int py_srvsvc_NetTransportInfo0_set_addr_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->addr_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->addr_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo0_get_net_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(obj);
	PyObject *py_net_addr;
	if (object->net_addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->net_addr == NULL) {
		py_net_addr = Py_None;
		Py_INCREF(py_net_addr);
	} else {
		if (object->net_addr == NULL) {
			py_net_addr = Py_None;
			Py_INCREF(py_net_addr);
		} else {
			py_net_addr = PyUnicode_Decode(object->net_addr, strlen(object->net_addr), "utf-8", "ignore");
		}
	}
	return py_net_addr;
}

static int py_srvsvc_NetTransportInfo0_set_net_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->net_addr");
		return -1;
	}
	if (value == Py_None) {
		object->net_addr = NULL;
	} else {
		object->net_addr = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->net_addr = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportInfo0_getsetters[] = {
	{
		.name = discard_const_p(char, "vcs"),
		.get = py_srvsvc_NetTransportInfo0_get_vcs,
		.set = py_srvsvc_NetTransportInfo0_set_vcs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetTransportInfo0_get_name,
		.set = py_srvsvc_NetTransportInfo0_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "addr"),
		.get = py_srvsvc_NetTransportInfo0_get_addr,
		.set = py_srvsvc_NetTransportInfo0_set_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "addr_len"),
		.get = py_srvsvc_NetTransportInfo0_get_addr_len,
		.set = py_srvsvc_NetTransportInfo0_set_addr_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "net_addr"),
		.get = py_srvsvc_NetTransportInfo0_get_net_addr,
		.set = py_srvsvc_NetTransportInfo0_set_net_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportInfo0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportInfo0, type);
}


static PyTypeObject srvsvc_NetTransportInfo0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportInfo0",
	.tp_getset = py_srvsvc_NetTransportInfo0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportInfo0_new,
};


static PyObject *py_srvsvc_NetTransportCtr0_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetTransportCtr0_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportCtr0_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr0 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetTransportInfo0_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetTransportCtr0_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr0 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetTransportInfo0_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetTransportInfo0 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportCtr0_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetTransportCtr0_get_count,
		.set = py_srvsvc_NetTransportCtr0_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetTransportCtr0_get_array,
		.set = py_srvsvc_NetTransportCtr0_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetTransportInfo0")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportCtr0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportCtr0, type);
}


static PyTypeObject srvsvc_NetTransportCtr0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportCtr0",
	.tp_getset = py_srvsvc_NetTransportCtr0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportCtr0_new,
};


static PyObject *py_srvsvc_NetTransportInfo1_get_vcs(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_vcs;
	py_vcs = PyLong_FromUnsignedLongLong((uint32_t)(object->vcs));
	return py_vcs;
}

static int py_srvsvc_NetTransportInfo1_set_vcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vcs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vcs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vcs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo1_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetTransportInfo1_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo1_get_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr;
	if (object->addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->addr == NULL) {
		py_addr = Py_None;
		Py_INCREF(py_addr);
	} else {
		py_addr = PyList_New(object->addr_len);
		if (py_addr == NULL) {
			return NULL;
		}
		{
			int addr_cntr_1;
			for (addr_cntr_1 = 0; addr_cntr_1 < (object->addr_len); addr_cntr_1++) {
				PyObject *py_addr_1;
				py_addr_1 = PyLong_FromLong((uint16_t)((object->addr)[addr_cntr_1]));
				PyList_SetItem(py_addr, addr_cntr_1, py_addr_1);
			}
		}
	}
	return py_addr;
}

static int py_srvsvc_NetTransportInfo1_set_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->addr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr");
		return -1;
	}
	if (value == Py_None) {
		object->addr = NULL;
	} else {
		object->addr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int addr_cntr_1;
			object->addr = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addr, PyList_GET_SIZE(value));
			if (!object->addr) { return -1; }
			talloc_set_name_const(object->addr, "ARRAY: object->addr");
			for (addr_cntr_1 = 0; addr_cntr_1 < PyList_GET_SIZE(value); addr_cntr_1++) {
				if (PyList_GET_ITEM(value, addr_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->addr)[addr_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->addr)[addr_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, addr_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, addr_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->addr)[addr_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo1_get_addr_len(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr_len;
	py_addr_len = PyLong_FromUnsignedLongLong((uint32_t)(object->addr_len));
	return py_addr_len;
}

static int py_srvsvc_NetTransportInfo1_set_addr_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->addr_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->addr_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo1_get_net_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_net_addr;
	if (object->net_addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->net_addr == NULL) {
		py_net_addr = Py_None;
		Py_INCREF(py_net_addr);
	} else {
		if (object->net_addr == NULL) {
			py_net_addr = Py_None;
			Py_INCREF(py_net_addr);
		} else {
			py_net_addr = PyUnicode_Decode(object->net_addr, strlen(object->net_addr), "utf-8", "ignore");
		}
	}
	return py_net_addr;
}

static int py_srvsvc_NetTransportInfo1_set_net_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->net_addr");
		return -1;
	}
	if (value == Py_None) {
		object->net_addr = NULL;
	} else {
		object->net_addr = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->net_addr = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo1_get_domain(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (object->domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_srvsvc_NetTransportInfo1_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "vcs"),
		.get = py_srvsvc_NetTransportInfo1_get_vcs,
		.set = py_srvsvc_NetTransportInfo1_set_vcs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetTransportInfo1_get_name,
		.set = py_srvsvc_NetTransportInfo1_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "addr"),
		.get = py_srvsvc_NetTransportInfo1_get_addr,
		.set = py_srvsvc_NetTransportInfo1_set_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "addr_len"),
		.get = py_srvsvc_NetTransportInfo1_get_addr_len,
		.set = py_srvsvc_NetTransportInfo1_set_addr_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "net_addr"),
		.get = py_srvsvc_NetTransportInfo1_get_net_addr,
		.set = py_srvsvc_NetTransportInfo1_set_net_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_srvsvc_NetTransportInfo1_get_domain,
		.set = py_srvsvc_NetTransportInfo1_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportInfo1, type);
}


static PyTypeObject srvsvc_NetTransportInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportInfo1",
	.tp_getset = py_srvsvc_NetTransportInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportInfo1_new,
};


static PyObject *py_srvsvc_NetTransportCtr1_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetTransportCtr1_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportCtr1_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr1 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetTransportInfo1_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetTransportCtr1_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr1 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetTransportInfo1_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetTransportInfo1 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportCtr1_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetTransportCtr1_get_count,
		.set = py_srvsvc_NetTransportCtr1_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetTransportCtr1_get_array,
		.set = py_srvsvc_NetTransportCtr1_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetTransportInfo1")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportCtr1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportCtr1, type);
}


static PyTypeObject srvsvc_NetTransportCtr1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportCtr1",
	.tp_getset = py_srvsvc_NetTransportCtr1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportCtr1_new,
};


static PyObject *py_srvsvc_NetTransportInfo2_get_vcs(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_vcs;
	py_vcs = PyLong_FromUnsignedLongLong((uint32_t)(object->vcs));
	return py_vcs;
}

static int py_srvsvc_NetTransportInfo2_set_vcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vcs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vcs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vcs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo2_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetTransportInfo2_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo2_get_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr;
	if (object->addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->addr == NULL) {
		py_addr = Py_None;
		Py_INCREF(py_addr);
	} else {
		py_addr = PyList_New(object->addr_len);
		if (py_addr == NULL) {
			return NULL;
		}
		{
			int addr_cntr_1;
			for (addr_cntr_1 = 0; addr_cntr_1 < (object->addr_len); addr_cntr_1++) {
				PyObject *py_addr_1;
				py_addr_1 = PyLong_FromLong((uint16_t)((object->addr)[addr_cntr_1]));
				PyList_SetItem(py_addr, addr_cntr_1, py_addr_1);
			}
		}
	}
	return py_addr;
}

static int py_srvsvc_NetTransportInfo2_set_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->addr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr");
		return -1;
	}
	if (value == Py_None) {
		object->addr = NULL;
	} else {
		object->addr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int addr_cntr_1;
			object->addr = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addr, PyList_GET_SIZE(value));
			if (!object->addr) { return -1; }
			talloc_set_name_const(object->addr, "ARRAY: object->addr");
			for (addr_cntr_1 = 0; addr_cntr_1 < PyList_GET_SIZE(value); addr_cntr_1++) {
				if (PyList_GET_ITEM(value, addr_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->addr)[addr_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->addr)[addr_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, addr_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, addr_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->addr)[addr_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo2_get_addr_len(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr_len;
	py_addr_len = PyLong_FromUnsignedLongLong((uint32_t)(object->addr_len));
	return py_addr_len;
}

static int py_srvsvc_NetTransportInfo2_set_addr_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->addr_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->addr_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo2_get_net_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_net_addr;
	if (object->net_addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->net_addr == NULL) {
		py_net_addr = Py_None;
		Py_INCREF(py_net_addr);
	} else {
		if (object->net_addr == NULL) {
			py_net_addr = Py_None;
			Py_INCREF(py_net_addr);
		} else {
			py_net_addr = PyUnicode_Decode(object->net_addr, strlen(object->net_addr), "utf-8", "ignore");
		}
	}
	return py_net_addr;
}

static int py_srvsvc_NetTransportInfo2_set_net_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->net_addr");
		return -1;
	}
	if (value == Py_None) {
		object->net_addr = NULL;
	} else {
		object->net_addr = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->net_addr = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo2_get_domain(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (object->domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_srvsvc_NetTransportInfo2_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo2_get_unknown(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown));
	return py_unknown;
}

static int py_srvsvc_NetTransportInfo2_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "vcs"),
		.get = py_srvsvc_NetTransportInfo2_get_vcs,
		.set = py_srvsvc_NetTransportInfo2_set_vcs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetTransportInfo2_get_name,
		.set = py_srvsvc_NetTransportInfo2_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "addr"),
		.get = py_srvsvc_NetTransportInfo2_get_addr,
		.set = py_srvsvc_NetTransportInfo2_set_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "addr_len"),
		.get = py_srvsvc_NetTransportInfo2_get_addr_len,
		.set = py_srvsvc_NetTransportInfo2_set_addr_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "net_addr"),
		.get = py_srvsvc_NetTransportInfo2_get_net_addr,
		.set = py_srvsvc_NetTransportInfo2_set_net_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_srvsvc_NetTransportInfo2_get_domain,
		.set = py_srvsvc_NetTransportInfo2_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "unknown"),
		.get = py_srvsvc_NetTransportInfo2_get_unknown,
		.set = py_srvsvc_NetTransportInfo2_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportInfo2, type);
}


static PyTypeObject srvsvc_NetTransportInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportInfo2",
	.tp_getset = py_srvsvc_NetTransportInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportInfo2_new,
};


static PyObject *py_srvsvc_NetTransportCtr2_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetTransportCtr2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportCtr2_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr2 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetTransportInfo2_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetTransportCtr2_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetTransportInfo2_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetTransportInfo2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportCtr2_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetTransportCtr2_get_count,
		.set = py_srvsvc_NetTransportCtr2_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetTransportCtr2_get_array,
		.set = py_srvsvc_NetTransportCtr2_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetTransportInfo2")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportCtr2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportCtr2, type);
}


static PyTypeObject srvsvc_NetTransportCtr2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportCtr2",
	.tp_getset = py_srvsvc_NetTransportCtr2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportCtr2_new,
};


static PyObject *py_srvsvc_NetTransportInfo3_get_vcs(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_vcs;
	py_vcs = PyLong_FromUnsignedLongLong((uint32_t)(object->vcs));
	return py_vcs;
}

static int py_srvsvc_NetTransportInfo3_set_vcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vcs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vcs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vcs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_srvsvc_NetTransportInfo3_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr;
	if (object->addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->addr == NULL) {
		py_addr = Py_None;
		Py_INCREF(py_addr);
	} else {
		py_addr = PyList_New(object->addr_len);
		if (py_addr == NULL) {
			return NULL;
		}
		{
			int addr_cntr_1;
			for (addr_cntr_1 = 0; addr_cntr_1 < (object->addr_len); addr_cntr_1++) {
				PyObject *py_addr_1;
				py_addr_1 = PyLong_FromLong((uint16_t)((object->addr)[addr_cntr_1]));
				PyList_SetItem(py_addr, addr_cntr_1, py_addr_1);
			}
		}
	}
	return py_addr;
}

static int py_srvsvc_NetTransportInfo3_set_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->addr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr");
		return -1;
	}
	if (value == Py_None) {
		object->addr = NULL;
	} else {
		object->addr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int addr_cntr_1;
			object->addr = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addr, PyList_GET_SIZE(value));
			if (!object->addr) { return -1; }
			talloc_set_name_const(object->addr, "ARRAY: object->addr");
			for (addr_cntr_1 = 0; addr_cntr_1 < PyList_GET_SIZE(value); addr_cntr_1++) {
				if (PyList_GET_ITEM(value, addr_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->addr)[addr_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->addr)[addr_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, addr_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, addr_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->addr)[addr_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_addr_len(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_addr_len;
	py_addr_len = PyLong_FromUnsignedLongLong((uint32_t)(object->addr_len));
	return py_addr_len;
}

static int py_srvsvc_NetTransportInfo3_set_addr_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->addr_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->addr_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_net_addr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_net_addr;
	if (object->net_addr == NULL) {
		Py_RETURN_NONE;
	}
	if (object->net_addr == NULL) {
		py_net_addr = Py_None;
		Py_INCREF(py_net_addr);
	} else {
		if (object->net_addr == NULL) {
			py_net_addr = Py_None;
			Py_INCREF(py_net_addr);
		} else {
			py_net_addr = PyUnicode_Decode(object->net_addr, strlen(object->net_addr), "utf-8", "ignore");
		}
	}
	return py_net_addr;
}

static int py_srvsvc_NetTransportInfo3_set_net_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->net_addr");
		return -1;
	}
	if (value == Py_None) {
		object->net_addr = NULL;
	} else {
		object->net_addr = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->net_addr = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_domain(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (object->domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_srvsvc_NetTransportInfo3_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_unknown1(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown1));
	return py_unknown1;
}

static int py_srvsvc_NetTransportInfo3_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_unknown2(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown2));
	return py_unknown2;
}

static int py_srvsvc_NetTransportInfo3_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfo3_get_unknown3(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyList_New(256);
	if (py_unknown3 == NULL) {
		return NULL;
	}
	{
		int unknown3_cntr_0;
		for (unknown3_cntr_0 = 0; unknown3_cntr_0 < (256); unknown3_cntr_0++) {
			PyObject *py_unknown3_0;
			py_unknown3_0 = PyLong_FromLong((uint16_t)((object->unknown3)[unknown3_cntr_0]));
			PyList_SetItem(py_unknown3, unknown3_cntr_0, py_unknown3_0);
		}
	}
	return py_unknown3;
}

static int py_srvsvc_NetTransportInfo3_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unknown3_cntr_0;
		if (ARRAY_SIZE(object->unknown3) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->unknown3),  PyList_GET_SIZE(value));
			return -1;
		}
		for (unknown3_cntr_0 = 0; unknown3_cntr_0 < PyList_GET_SIZE(value); unknown3_cntr_0++) {
			if (PyList_GET_ITEM(value, unknown3_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->unknown3)[unknown3_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->unknown3)[unknown3_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, unknown3_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, unknown3_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->unknown3)[unknown3_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportInfo3_getsetters[] = {
	{
		.name = discard_const_p(char, "vcs"),
		.get = py_srvsvc_NetTransportInfo3_get_vcs,
		.set = py_srvsvc_NetTransportInfo3_set_vcs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_srvsvc_NetTransportInfo3_get_name,
		.set = py_srvsvc_NetTransportInfo3_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "addr"),
		.get = py_srvsvc_NetTransportInfo3_get_addr,
		.set = py_srvsvc_NetTransportInfo3_set_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "addr_len"),
		.get = py_srvsvc_NetTransportInfo3_get_addr_len,
		.set = py_srvsvc_NetTransportInfo3_set_addr_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "net_addr"),
		.get = py_srvsvc_NetTransportInfo3_get_net_addr,
		.set = py_srvsvc_NetTransportInfo3_set_net_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_srvsvc_NetTransportInfo3_get_domain,
		.set = py_srvsvc_NetTransportInfo3_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_srvsvc_NetTransportInfo3_get_unknown1,
		.set = py_srvsvc_NetTransportInfo3_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_srvsvc_NetTransportInfo3_get_unknown2,
		.set = py_srvsvc_NetTransportInfo3_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_srvsvc_NetTransportInfo3_get_unknown3,
		.set = py_srvsvc_NetTransportInfo3_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportInfo3, type);
}


static PyTypeObject srvsvc_NetTransportInfo3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportInfo3",
	.tp_getset = py_srvsvc_NetTransportInfo3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportInfo3_new,
};


static PyObject *py_srvsvc_NetTransportCtr3_get_count(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_srvsvc_NetTransportCtr3_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportCtr3_get_array(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportCtr3 *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&srvsvc_NetTransportInfo3_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_srvsvc_NetTransportCtr3_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportCtr3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&srvsvc_NetTransportInfo3_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct srvsvc_NetTransportInfo3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportCtr3_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_srvsvc_NetTransportCtr3_get_count,
		.set = py_srvsvc_NetTransportCtr3_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_srvsvc_NetTransportCtr3_get_array,
		.set = py_srvsvc_NetTransportCtr3_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetTransportInfo3")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportCtr3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportCtr3, type);
}


static PyTypeObject srvsvc_NetTransportCtr3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportCtr3",
	.tp_getset = py_srvsvc_NetTransportCtr3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportCtr3_new,
};

static PyObject *py_import_srvsvc_NetTransportCtr(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetTransportCtr *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			if (in->ctr0 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetTransportCtr0_Type, in->ctr0, in->ctr0);
			}
			return ret;

		case 1:
			if (in->ctr1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetTransportCtr1_Type, in->ctr1, in->ctr1);
			}
			return ret;

		case 2:
			if (in->ctr2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetTransportCtr2_Type, in->ctr2, in->ctr2);
			}
			return ret;

		case 3:
			if (in->ctr3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&srvsvc_NetTransportCtr3_Type, in->ctr3, in->ctr3);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetTransportCtr *py_export_srvsvc_NetTransportCtr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetTransportCtr *ret = talloc_zero(mem_ctx, union srvsvc_NetTransportCtr);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr0");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr0 = NULL;
			} else {
				ret->ctr0 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetTransportCtr0_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr0 = (struct srvsvc_NetTransportCtr0 *)pytalloc_get_ptr(in);
			}
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr1 = NULL;
			} else {
				ret->ctr1 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetTransportCtr1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr1 = (struct srvsvc_NetTransportCtr1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr2 = NULL;
			} else {
				ret->ctr2 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetTransportCtr2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr2 = (struct srvsvc_NetTransportCtr2 *)pytalloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr3");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ctr3 = NULL;
			} else {
				ret->ctr3 = NULL;
				PY_CHECK_TYPE(&srvsvc_NetTransportCtr3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ctr3 = (struct srvsvc_NetTransportCtr3 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_srvsvc_NetTransportCtr_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetTransportCtr *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetTransportCtr *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetTransportCtr!");
		return NULL;
	}

	return py_import_srvsvc_NetTransportCtr(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetTransportCtr_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetTransportCtr *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetTransportCtr(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetTransportCtr_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetTransportCtr_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetTransportCtr_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetTransportCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetTransportCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportCtr",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetTransportCtr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportCtr_new,
};


static PyObject *py_srvsvc_NetTransportInfoCtr_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->level));
	return py_level;
}

static int py_srvsvc_NetTransportInfoCtr_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetTransportInfoCtr_get_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetTransportInfoCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pyrpc_import_union(&srvsvc_NetTransportCtr_Type, pytalloc_get_mem_ctx(obj), object->level, &object->ctr, "union srvsvc_NetTransportCtr");
	if (py_ctr == NULL) {
		return NULL;
	}
	return py_ctr;
}

static int py_srvsvc_NetTransportInfoCtr_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetTransportInfoCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	{
		union srvsvc_NetTransportCtr *ctr_switch_0;
		ctr_switch_0 = (union srvsvc_NetTransportCtr *)pyrpc_export_union(&srvsvc_NetTransportCtr_Type, pytalloc_get_mem_ctx(py_obj), object->level, value, "union srvsvc_NetTransportCtr");
		if (ctr_switch_0 == NULL) {
			return -1;
		}
		object->ctr = *ctr_switch_0;
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetTransportInfoCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "level"),
		.get = py_srvsvc_NetTransportInfoCtr_get_level,
		.set = py_srvsvc_NetTransportInfoCtr_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_srvsvc_NetTransportInfoCtr_get_ctr,
		.set = py_srvsvc_NetTransportInfoCtr_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetTransportCtr")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetTransportInfoCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetTransportInfoCtr, type);
}


static PyTypeObject srvsvc_NetTransportInfoCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportInfoCtr",
	.tp_getset = py_srvsvc_NetTransportInfoCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportInfoCtr_new,
};


static PyObject *py_srvsvc_NetRemoteTODInfo_get_elapsed(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_elapsed;
	py_elapsed = PyLong_FromUnsignedLongLong((uint32_t)(object->elapsed));
	return py_elapsed;
}

static int py_srvsvc_NetRemoteTODInfo_set_elapsed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->elapsed");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->elapsed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->elapsed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_msecs(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_msecs;
	py_msecs = PyLong_FromUnsignedLongLong((uint32_t)(object->msecs));
	return py_msecs;
}

static int py_srvsvc_NetRemoteTODInfo_set_msecs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->msecs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->msecs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->msecs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_hours(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_hours;
	py_hours = PyLong_FromUnsignedLongLong((uint32_t)(object->hours));
	return py_hours;
}

static int py_srvsvc_NetRemoteTODInfo_set_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hours");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->hours));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->hours = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_mins(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_mins;
	py_mins = PyLong_FromUnsignedLongLong((uint32_t)(object->mins));
	return py_mins;
}

static int py_srvsvc_NetRemoteTODInfo_set_mins(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mins");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->mins));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->mins = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_secs(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_secs;
	py_secs = PyLong_FromUnsignedLongLong((uint32_t)(object->secs));
	return py_secs;
}

static int py_srvsvc_NetRemoteTODInfo_set_secs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->secs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->secs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->secs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_hunds(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_hunds;
	py_hunds = PyLong_FromUnsignedLongLong((uint32_t)(object->hunds));
	return py_hunds;
}

static int py_srvsvc_NetRemoteTODInfo_set_hunds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hunds");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->hunds));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->hunds = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_timezone(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_timezone;
	py_timezone = PyLong_FromLong(object->timezone);
	return py_timezone;
}

static int py_srvsvc_NetRemoteTODInfo_set_timezone(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timezone");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->timezone));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->timezone = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_tinterval(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_tinterval;
	py_tinterval = PyLong_FromUnsignedLongLong((uint32_t)(object->tinterval));
	return py_tinterval;
}

static int py_srvsvc_NetRemoteTODInfo_set_tinterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tinterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tinterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tinterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_day(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_day;
	py_day = PyLong_FromUnsignedLongLong((uint32_t)(object->day));
	return py_day;
}

static int py_srvsvc_NetRemoteTODInfo_set_day(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->day");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->day));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->day = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_month(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_month;
	py_month = PyLong_FromUnsignedLongLong((uint32_t)(object->month));
	return py_month;
}

static int py_srvsvc_NetRemoteTODInfo_set_month(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->month");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->month));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->month = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_year(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_year;
	py_year = PyLong_FromUnsignedLongLong((uint32_t)(object->year));
	return py_year;
}

static int py_srvsvc_NetRemoteTODInfo_set_year(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->year");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->year));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->year = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetRemoteTODInfo_get_weekday(PyObject *obj, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_weekday;
	py_weekday = PyLong_FromUnsignedLongLong((uint32_t)(object->weekday));
	return py_weekday;
}

static int py_srvsvc_NetRemoteTODInfo_set_weekday(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetRemoteTODInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->weekday");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->weekday));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->weekday = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_srvsvc_NetRemoteTODInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "elapsed"),
		.get = py_srvsvc_NetRemoteTODInfo_get_elapsed,
		.set = py_srvsvc_NetRemoteTODInfo_set_elapsed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "msecs"),
		.get = py_srvsvc_NetRemoteTODInfo_get_msecs,
		.set = py_srvsvc_NetRemoteTODInfo_set_msecs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "hours"),
		.get = py_srvsvc_NetRemoteTODInfo_get_hours,
		.set = py_srvsvc_NetRemoteTODInfo_set_hours,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "mins"),
		.get = py_srvsvc_NetRemoteTODInfo_get_mins,
		.set = py_srvsvc_NetRemoteTODInfo_set_mins,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "secs"),
		.get = py_srvsvc_NetRemoteTODInfo_get_secs,
		.set = py_srvsvc_NetRemoteTODInfo_set_secs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "hunds"),
		.get = py_srvsvc_NetRemoteTODInfo_get_hunds,
		.set = py_srvsvc_NetRemoteTODInfo_set_hunds,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "timezone"),
		.get = py_srvsvc_NetRemoteTODInfo_get_timezone,
		.set = py_srvsvc_NetRemoteTODInfo_set_timezone,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "tinterval"),
		.get = py_srvsvc_NetRemoteTODInfo_get_tinterval,
		.set = py_srvsvc_NetRemoteTODInfo_set_tinterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "day"),
		.get = py_srvsvc_NetRemoteTODInfo_get_day,
		.set = py_srvsvc_NetRemoteTODInfo_set_day,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "month"),
		.get = py_srvsvc_NetRemoteTODInfo_get_month,
		.set = py_srvsvc_NetRemoteTODInfo_set_month,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "year"),
		.get = py_srvsvc_NetRemoteTODInfo_get_year,
		.set = py_srvsvc_NetRemoteTODInfo_set_year,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "weekday"),
		.get = py_srvsvc_NetRemoteTODInfo_get_weekday,
		.set = py_srvsvc_NetRemoteTODInfo_set_weekday,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetRemoteTODInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srvsvc_NetRemoteTODInfo, type);
}


static PyTypeObject srvsvc_NetRemoteTODInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetRemoteTODInfo",
	.tp_getset = py_srvsvc_NetRemoteTODInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetRemoteTODInfo_new,
};

static PyObject *py_import_srvsvc_NetTransportInfo(TALLOC_CTX *mem_ctx, int level, union srvsvc_NetTransportInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = pytalloc_reference_ex(&srvsvc_NetTransportInfo0_Type, mem_ctx, &in->info0);
			return ret;

		case 1:
			ret = pytalloc_reference_ex(&srvsvc_NetTransportInfo1_Type, mem_ctx, &in->info1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&srvsvc_NetTransportInfo2_Type, mem_ctx, &in->info2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&srvsvc_NetTransportInfo3_Type, mem_ctx, &in->info3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union srvsvc_NetTransportInfo *py_export_srvsvc_NetTransportInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union srvsvc_NetTransportInfo *ret = talloc_zero(mem_ctx, union srvsvc_NetTransportInfo);
	switch (level) {
		case 0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info0");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&srvsvc_NetTransportInfo0_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info0 = *(struct srvsvc_NetTransportInfo0 *)pytalloc_get_ptr(in);
			break;

		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&srvsvc_NetTransportInfo1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct srvsvc_NetTransportInfo1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&srvsvc_NetTransportInfo2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info2 = *(struct srvsvc_NetTransportInfo2 *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&srvsvc_NetTransportInfo3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info3 = *(struct srvsvc_NetTransportInfo3 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_srvsvc_NetTransportInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union srvsvc_NetTransportInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union srvsvc_NetTransportInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union srvsvc_NetTransportInfo!");
		return NULL;
	}

	return py_import_srvsvc_NetTransportInfo(mem_ctx, level, in);
}

static PyObject *py_srvsvc_NetTransportInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union srvsvc_NetTransportInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_srvsvc_NetTransportInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_srvsvc_NetTransportInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetTransportInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetTransportInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_srvsvc_NetTransportInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject srvsvc_NetTransportInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetTransportInfo",
	.tp_getset = NULL,
	.tp_methods = py_srvsvc_NetTransportInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetTransportInfo_new,
};



static PyObject *py_srvsvc_NetCharDevEnum_in_get_server_unc(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_server_unc;
	if (object->in.server_unc == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_unc == NULL) {
		py_server_unc = Py_None;
		Py_INCREF(py_server_unc);
	} else {
		if (object->in.server_unc == NULL) {
			py_server_unc = Py_None;
			Py_INCREF(py_server_unc);
		} else {
			py_server_unc = PyUnicode_Decode(object->in.server_unc, strlen(object->in.server_unc), "utf-8", "ignore");
		}
	}
	return py_server_unc;
}

static int py_srvsvc_NetCharDevEnum_in_set_server_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_unc");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_unc = NULL;
	} else {
		object->in.server_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_unc = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevEnum_in_get_info_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ctr;
	if (object->in.info_ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_info_ctr = pytalloc_reference_ex(&srvsvc_NetCharDevInfoCtr_Type, object->in.info_ctr, object->in.info_ctr);
	return py_info_ctr;
}

static int py_srvsvc_NetCharDevEnum_in_set_info_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info_ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.info_ctr");
		return -1;
	}
	object->in.info_ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info_ctr);
	if (object->in.info_ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&srvsvc_NetCharDevInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info_ctr = (struct srvsvc_NetCharDevInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_srvsvc_NetCharDevEnum_out_get_info_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ctr;
	if (object->out.info_ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_info_ctr = pytalloc_reference_ex(&srvsvc_NetCharDevInfoCtr_Type, object->out.info_ctr, object->out.info_ctr);
	return py_info_ctr;
}

static int py_srvsvc_NetCharDevEnum_out_set_info_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info_ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info_ctr");
		return -1;
	}
	object->out.info_ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info_ctr);
	if (object->out.info_ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&srvsvc_NetCharDevInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.info_ctr = (struct srvsvc_NetCharDevInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_srvsvc_NetCharDevEnum_in_get_max_buffer(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_max_buffer;
	py_max_buffer = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_buffer));
	return py_max_buffer;
}

static int py_srvsvc_NetCharDevEnum_in_set_max_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_buffer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_buffer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_buffer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevEnum_out_get_totalentries(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_totalentries;
	if (object->out.totalentries == NULL) {
		Py_RETURN_NONE;
	}
	py_totalentries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.totalentries));
	return py_totalentries;
}

static int py_srvsvc_NetCharDevEnum_out_set_totalentries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.totalentries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.totalentries");
		return -1;
	}
	object->out.totalentries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.totalentries);
	if (object->out.totalentries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.totalentries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.totalentries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevEnum_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_srvsvc_NetCharDevEnum_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevEnum_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_srvsvc_NetCharDevEnum_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevEnum_get_result(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_srvsvc_NetCharDevEnum_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevEnum_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_unc"),
		.get = py_srvsvc_NetCharDevEnum_in_get_server_unc,
		.set = py_srvsvc_NetCharDevEnum_in_set_server_unc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_info_ctr"),
		.get = py_srvsvc_NetCharDevEnum_in_get_info_ctr,
		.set = py_srvsvc_NetCharDevEnum_in_set_info_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevInfoCtr")
	},
	{
		.name = discard_const_p(char, "out_info_ctr"),
		.get = py_srvsvc_NetCharDevEnum_out_get_info_ctr,
		.set = py_srvsvc_NetCharDevEnum_out_set_info_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevInfoCtr")
	},
	{
		.name = discard_const_p(char, "in_max_buffer"),
		.get = py_srvsvc_NetCharDevEnum_in_get_max_buffer,
		.set = py_srvsvc_NetCharDevEnum_in_set_max_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_totalentries"),
		.get = py_srvsvc_NetCharDevEnum_out_get_totalentries,
		.set = py_srvsvc_NetCharDevEnum_out_set_totalentries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_srvsvc_NetCharDevEnum_in_get_resume_handle,
		.set = py_srvsvc_NetCharDevEnum_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_srvsvc_NetCharDevEnum_out_get_resume_handle,
		.set = py_srvsvc_NetCharDevEnum_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_srvsvc_NetCharDevEnum_get_result,
		.set = py_srvsvc_NetCharDevEnum_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct srvsvc_NetCharDevEnum, type);
	struct srvsvc_NetCharDevEnum *_self = (struct srvsvc_NetCharDevEnum *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info_ctr = talloc_zero(mem_ctx, struct srvsvc_NetCharDevInfoCtr);
	_self->out.info_ctr = talloc_zero(mem_ctx, struct srvsvc_NetCharDevInfoCtr);
	_self->out.totalentries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_srvsvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevEnum_ndr_pack");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_srvsvc_NetCharDevEnum_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_srvsvc_NetCharDevEnum_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_srvsvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevEnum_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_srvsvc_NetCharDevEnum_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_srvsvc_NetCharDevEnum_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevEnum *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_srvsvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevEnum_ndr_print");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_srvsvc_NetCharDevEnum_ndr_print(py_obj, args, kwargs, "srvsvc_NetCharDevEnum_in", NDR_IN);
}

static PyObject *py_srvsvc_NetCharDevEnum_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_srvsvc_NetCharDevEnum_ndr_print(py_obj, args, kwargs, "srvsvc_NetCharDevEnum_out", NDR_OUT);
}

static PyMethodDef py_srvsvc_NetCharDevEnum_methods[] = {
	{ "opnum", (PyCFunction)py_srvsvc_NetCharDevEnum_ndr_opnum, METH_NOARGS|METH_CLASS,
		"srvsvc.NetCharDevEnum.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevEnum_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevEnum_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevEnum_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevEnum_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevEnum_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevEnum_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject srvsvc_NetCharDevEnum_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevEnum",
	.tp_getset = py_srvsvc_NetCharDevEnum_getsetters,
	.tp_methods = py_srvsvc_NetCharDevEnum_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevEnum_new,
};

static bool pack_py_srvsvc_NetCharDevEnum_args_in(PyObject *args, PyObject *kwargs, struct srvsvc_NetCharDevEnum *r)
{
	PyObject *py_server_unc;
	PyObject *py_info_ctr;
	PyObject *py_max_buffer;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"server_unc", "info_ctr", "max_buffer", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:srvsvc_NetCharDevEnum", discard_const_p(char *, kwnames), &py_server_unc, &py_info_ctr, &py_max_buffer, &py_resume_handle)) {
		return false;
	}

	if (py_server_unc == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server_unc");
		return false;
	}
	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_unc)) {
				unicode = PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_unc)) {
				test_str = PyBytes_AS_STRING(py_server_unc);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_unc)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_unc = talloc_str;
		}
	}
	if (py_info_ctr == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.info_ctr");
		return false;
	}
	r->in.info_ctr = talloc_ptrtype(r, r->in.info_ctr);
	if (r->in.info_ctr == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&srvsvc_NetCharDevInfoCtr_Type, py_info_ctr, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info_ctr)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info_ctr = (struct srvsvc_NetCharDevInfoCtr *)pytalloc_get_ptr(py_info_ctr);
	if (py_max_buffer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.max_buffer");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_buffer));
		if (PyLong_Check(py_max_buffer)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_buffer);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_buffer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.resume_handle");
		return false;
	}
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		if (r->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
			if (PyLong_Check(py_resume_handle)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_srvsvc_NetCharDevEnum_args_out(struct srvsvc_NetCharDevEnum *r, bool raise_result_exception)
{
	PyObject *py_info_ctr = NULL;
	PyObject *py_totalentries = NULL;
	PyObject *py_resume_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_info_ctr = pytalloc_reference_ex(&srvsvc_NetCharDevInfoCtr_Type, r->out.info_ctr, r->out.info_ctr);
	PyTuple_SetItem(result, 0, py_info_ctr);

	py_totalentries = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.totalentries));
	PyTuple_SetItem(result, 1, py_totalentries);

	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	}
	PyTuple_SetItem(result, 2, py_resume_handle);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_srvsvc_NetCharDevGetInfo_in_get_server_unc(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_server_unc;
	if (object->in.server_unc == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_unc == NULL) {
		py_server_unc = Py_None;
		Py_INCREF(py_server_unc);
	} else {
		if (object->in.server_unc == NULL) {
			py_server_unc = Py_None;
			Py_INCREF(py_server_unc);
		} else {
			py_server_unc = PyUnicode_Decode(object->in.server_unc, strlen(object->in.server_unc), "utf-8", "ignore");
		}
	}
	return py_server_unc;
}

static int py_srvsvc_NetCharDevGetInfo_in_set_server_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_unc");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_unc = NULL;
	} else {
		object->in.server_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_unc = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_in_get_device_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_device_name;
	if (object->in.device_name == NULL) {
		py_device_name = Py_None;
		Py_INCREF(py_device_name);
	} else {
		py_device_name = PyUnicode_Decode(object->in.device_name, strlen(object->in.device_name), "utf-8", "ignore");
	}
	return py_device_name;
}

static int py_srvsvc_NetCharDevGetInfo_in_set_device_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.device_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.device_name = talloc_str;
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_in_get_level(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_srvsvc_NetCharDevGetInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_out_get_info(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&srvsvc_NetCharDevInfo_Type, object->out.info, object->in.level, object->out.info, "union srvsvc_NetCharDevInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_srvsvc_NetCharDevGetInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union srvsvc_NetCharDevInfo *info_switch_1;
		info_switch_1 = (union srvsvc_NetCharDevInfo *)pyrpc_export_union(&srvsvc_NetCharDevInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union srvsvc_NetCharDevInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->out.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_get_result(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_srvsvc_NetCharDevGetInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevGetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_unc"),
		.get = py_srvsvc_NetCharDevGetInfo_in_get_server_unc,
		.set = py_srvsvc_NetCharDevGetInfo_in_set_server_unc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_device_name"),
		.get = py_srvsvc_NetCharDevGetInfo_in_get_device_name,
		.set = py_srvsvc_NetCharDevGetInfo_in_set_device_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_srvsvc_NetCharDevGetInfo_in_get_level,
		.set = py_srvsvc_NetCharDevGetInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_srvsvc_NetCharDevGetInfo_out_get_info,
		.set = py_srvsvc_NetCharDevGetInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_srvsvc_NetCharDevGetInfo_get_result,
		.set = py_srvsvc_NetCharDevGetInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevGetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct srvsvc_NetCharDevGetInfo, type);
	struct srvsvc_NetCharDevGetInfo *_self = (struct srvsvc_NetCharDevGetInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.info = talloc_zero(mem_ctx, union srvsvc_NetCharDevInfo);
	return self;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_srvsvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevGetInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_srvsvc_NetCharDevGetInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_srvsvc_NetCharDevGetInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_srvsvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevGetInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_srvsvc_NetCharDevGetInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_srvsvc_NetCharDevGetInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevGetInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_srvsvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevGetInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_srvsvc_NetCharDevGetInfo_ndr_print(py_obj, args, kwargs, "srvsvc_NetCharDevGetInfo_in", NDR_IN);
}

static PyObject *py_srvsvc_NetCharDevGetInfo_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_srvsvc_NetCharDevGetInfo_ndr_print(py_obj, args, kwargs, "srvsvc_NetCharDevGetInfo_out", NDR_OUT);
}

static PyMethodDef py_srvsvc_NetCharDevGetInfo_methods[] = {
	{ "opnum", (PyCFunction)py_srvsvc_NetCharDevGetInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"srvsvc.NetCharDevGetInfo.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevGetInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevGetInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevGetInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevGetInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevGetInfo_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevGetInfo_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject srvsvc_NetCharDevGetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevGetInfo",
	.tp_getset = py_srvsvc_NetCharDevGetInfo_getsetters,
	.tp_methods = py_srvsvc_NetCharDevGetInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevGetInfo_new,
};

static bool pack_py_srvsvc_NetCharDevGetInfo_args_in(PyObject *args, PyObject *kwargs, struct srvsvc_NetCharDevGetInfo *r)
{
	PyObject *py_server_unc;
	PyObject *py_device_name;
	PyObject *py_level;
	const char *kwnames[] = {
		"server_unc", "device_name", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:srvsvc_NetCharDevGetInfo", discard_const_p(char *, kwnames), &py_server_unc, &py_device_name, &py_level)) {
		return false;
	}

	if (py_server_unc == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server_unc");
		return false;
	}
	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_unc)) {
				unicode = PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_unc)) {
				test_str = PyBytes_AS_STRING(py_server_unc);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_unc)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_unc = talloc_str;
		}
	}
	if (py_device_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.device_name");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_device_name)) {
			unicode = PyUnicode_AsEncodedString(py_device_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_device_name)) {
			test_str = PyBytes_AS_STRING(py_device_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_device_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.device_name = talloc_str;
	}
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_srvsvc_NetCharDevGetInfo_args_out(struct srvsvc_NetCharDevGetInfo *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_info = pyrpc_import_union(&srvsvc_NetCharDevInfo_Type, r->out.info, r->in.level, r->out.info, "union srvsvc_NetCharDevInfo");
	if (py_info == NULL) {
		return NULL;
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_info);
	}
	if (result_size == 1) {
		result = py_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_srvsvc_NetCharDevControl_in_get_server_unc(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(obj);
	PyObject *py_server_unc;
	if (object->in.server_unc == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_unc == NULL) {
		py_server_unc = Py_None;
		Py_INCREF(py_server_unc);
	} else {
		if (object->in.server_unc == NULL) {
			py_server_unc = Py_None;
			Py_INCREF(py_server_unc);
		} else {
			py_server_unc = PyUnicode_Decode(object->in.server_unc, strlen(object->in.server_unc), "utf-8", "ignore");
		}
	}
	return py_server_unc;
}

static int py_srvsvc_NetCharDevControl_in_set_server_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_unc");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_unc = NULL;
	} else {
		object->in.server_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_unc = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevControl_in_get_device_name(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(obj);
	PyObject *py_device_name;
	if (object->in.device_name == NULL) {
		py_device_name = Py_None;
		Py_INCREF(py_device_name);
	} else {
		py_device_name = PyUnicode_Decode(object->in.device_name, strlen(object->in.device_name), "utf-8", "ignore");
	}
	return py_device_name;
}

static int py_srvsvc_NetCharDevControl_in_set_device_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.device_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.device_name = talloc_str;
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevControl_in_get_opcode(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(obj);
	PyObject *py_opcode;
	py_opcode = PyLong_FromUnsignedLongLong((uint32_t)(object->in.opcode));
	return py_opcode;
}

static int py_srvsvc_NetCharDevControl_in_set_opcode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.opcode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.opcode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.opcode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevControl_get_result(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_srvsvc_NetCharDevControl_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevControl_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_unc"),
		.get = py_srvsvc_NetCharDevControl_in_get_server_unc,
		.set = py_srvsvc_NetCharDevControl_in_set_server_unc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_device_name"),
		.get = py_srvsvc_NetCharDevControl_in_get_device_name,
		.set = py_srvsvc_NetCharDevControl_in_set_device_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_opcode"),
		.get = py_srvsvc_NetCharDevControl_in_get_opcode,
		.set = py_srvsvc_NetCharDevControl_in_set_opcode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_srvsvc_NetCharDevControl_get_result,
		.set = py_srvsvc_NetCharDevControl_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevControl_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct srvsvc_NetCharDevControl, type);
	return self;
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_srvsvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevControl_ndr_pack");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_srvsvc_NetCharDevControl_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_srvsvc_NetCharDevControl_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_srvsvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevControl_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_srvsvc_NetCharDevControl_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_srvsvc_NetCharDevControl_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevControl *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_srvsvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevControl_ndr_print");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_srvsvc_NetCharDevControl_ndr_print(py_obj, args, kwargs, "srvsvc_NetCharDevControl_in", NDR_IN);
}

static PyObject *py_srvsvc_NetCharDevControl_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_srvsvc_NetCharDevControl_ndr_print(py_obj, args, kwargs, "srvsvc_NetCharDevControl_out", NDR_OUT);
}

static PyMethodDef py_srvsvc_NetCharDevControl_methods[] = {
	{ "opnum", (PyCFunction)py_srvsvc_NetCharDevControl_ndr_opnum, METH_NOARGS|METH_CLASS,
		"srvsvc.NetCharDevControl.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevControl_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevControl_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevControl_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevControl_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevControl_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_srvsvc_NetCharDevControl_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject srvsvc_NetCharDevControl_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "srvsvc.NetCharDevControl",
	.tp_getset = py_srvsvc_NetCharDevControl_getsetters,
	.tp_methods = py_srvsvc_NetCharDevControl_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_srvsvc_NetCharDevControl_new,
};

static bool pack_py_srvsvc_NetCharDevControl_args_in(PyObject *args, PyObject *kwargs, struct srvsvc_NetCharDevControl *r)
{
	PyObject *py_server_unc;
	PyObject *py_device_name;
	PyObject *py_opcode;
	const char *kwnames[] = {
		"server_unc", "device_name", "opcode", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:srvsvc_NetCharDevControl", discard_const_p(char *, kwnames), &py_server_unc, &py_device_name, &py_opcode)) {
		return false;
	}

	if (py_server_unc == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server_unc");
		return false;
	}
	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_unc)) {
				unicode = PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_unc)) {
				test_str = PyBytes_AS_STRING(py_server_unc);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_unc)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_unc = talloc_str;
		}
	}
	if (py_device_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.device_name");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_device_name)) {
			unicode = PyUnicode_AsEncodedString(py_device_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_device_name)) {
			test_str = PyBytes_AS_STRING(py_device_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_device_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.device_name = talloc_str;
	}
	if (py_opcode == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.opcode");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.opcode));
		if (PyLong_Check(py_opcode)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_opcode);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.opcode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_srvsvc_NetCharDevControl_args_out(struct srvsvc_NetCharDevControl *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_srvsvc_NetCharDevQEnum_in_get_server_unc(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_server_unc;
	if (object->in.server_unc == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_unc == NULL) {
		py_server_unc = Py_None;
		Py_INCREF(py_server_unc);
	} else {
		if (object->in.server_unc == NULL) {
			py_server_unc = Py_None;
			Py_INCREF(py_server_unc);
		} else {
			py_server_unc = PyUnicode_Decode(object->in.server_unc, strlen(object->in.server_unc), "utf-8", "ignore");
		}
	}
	return py_server_unc;
}

static int py_srvsvc_NetCharDevQEnum_in_set_server_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_unc");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_unc = NULL;
	} else {
		object->in.server_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_unc = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_in_get_user(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_user;
	if (object->in.user == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.user == NULL) {
		py_user = Py_None;
		Py_INCREF(py_user);
	} else {
		if (object->in.user == NULL) {
			py_user = Py_None;
			Py_INCREF(py_user);
		} else {
			py_user = PyUnicode_Decode(object->in.user, strlen(object->in.user), "utf-8", "ignore");
		}
	}
	return py_user;
}

static int py_srvsvc_NetCharDevQEnum_in_set_user(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.user");
		return -1;
	}
	if (value == Py_None) {
		object->in.user = NULL;
	} else {
		object->in.user = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.user = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_in_get_info_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ctr;
	if (object->in.info_ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_info_ctr = pytalloc_reference_ex(&srvsvc_NetCharDevQInfoCtr_Type, object->in.info_ctr, object->in.info_ctr);
	return py_info_ctr;
}

static int py_srvsvc_NetCharDevQEnum_in_set_info_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info_ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.info_ctr");
		return -1;
	}
	object->in.info_ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info_ctr);
	if (object->in.info_ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&srvsvc_NetCharDevQInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.info_ctr = (struct srvsvc_NetCharDevQInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_out_get_info_ctr(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_info_ctr;
	if (object->out.info_ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_info_ctr = pytalloc_reference_ex(&srvsvc_NetCharDevQInfoCtr_Type, object->out.info_ctr, object->out.info_ctr);
	return py_info_ctr;
}

static int py_srvsvc_NetCharDevQEnum_out_set_info_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info_ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info_ctr");
		return -1;
	}
	object->out.info_ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info_ctr);
	if (object->out.info_ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&srvsvc_NetCharDevQInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.info_ctr = (struct srvsvc_NetCharDevQInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_in_get_max_buffer(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_max_buffer;
	py_max_buffer = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_buffer));
	return py_max_buffer;
}

static int py_srvsvc_NetCharDevQEnum_in_set_max_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_buffer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_buffer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_buffer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_out_get_totalentries(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_totalentries;
	if (object->out.totalentries == NULL) {
		Py_RETURN_NONE;
	}
	py_totalentries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.totalentries));
	return py_totalentries;
}

static int py_srvsvc_NetCharDevQEnum_out_set_totalentries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.totalentries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.totalentries");
		return -1;
	}
	object->out.totalentries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.totalentries);
	if (object->out.totalentries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.totalentries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.totalentries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_srvsvc_NetCharDevQEnum_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_srvsvc_NetCharDevQEnum_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_srvsvc_NetCharDevQEnum_get_result(PyObject *obj, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_srvsvc_NetCharDevQEnum_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_srvsvc_NetCharDevQEnum_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_unc"),
		.get = py_srvsvc_NetCharDevQEnum_in_get_server_unc,
		.set = py_srvsvc_NetCharDevQEnum_in_set_server_unc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_user"),
		.get = py_srvsvc_NetCharDevQEnum_in_get_user,
		.set = py_srvsvc_NetCharDevQEnum_in_set_user,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_info_ctr"),
		.get = py_srvsvc_NetCharDevQEnum_in_get_info_ctr,
		.set = py_srvsvc_NetCharDevQEnum_in_set_info_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevQInfoCtr")
	},
	{
		.name = discard_const_p(char, "out_info_ctr"),
		.get = py_srvsvc_NetCharDevQEnum_out_get_info_ctr,
		.set = py_srvsvc_NetCharDevQEnum_out_set_info_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type srvsvc_NetCharDevQInfoCtr")
	},
	{
		.name = discard_const_p(char, "in_max_buffer"),
		.get = py_srvsvc_NetCharDevQEnum_in_get_max_buffer,
		.set = py_srvsvc_NetCharDevQEnum_in_set_max_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_totalentries"),
		.get = py_srvsvc_NetCharDevQEnum_out_get_totalentries,
		.set = py_srvsvc_NetCharDevQEnum_out_set_totalentries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_srvsvc_NetCharDevQEnum_in_get_resume_handle,
		.set = py_srvsvc_NetCharDevQEnum_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_srvsvc_NetCharDevQEnum_out_get_resume_handle,
		.set = py_srvsvc_NetCharDevQEnum_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_srvsvc_NetCharDevQEnum_get_result,
		.set = py_srvsvc_NetCharDevQEnum_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_srvsvc_NetCharDevQEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct srvsvc_NetCharDevQEnum, type);
	struct srvsvc_NetCharDevQEnum *_self = (struct srvsvc_NetCharDevQEnum *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.info_ctr = talloc_zero(mem_ctx, struct srvsvc_NetCharDevQInfoCtr);
	_self->out.info_ctr = talloc_zero(mem_ctx, struct srvsvc_NetCharDevQInfoCtr);
	_self->out.totalentries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_srvsvc_NetCharDevQEnum_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_srvsvc_NetCharDevQEnum_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct srvsvc_NetCharDevQEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_srvsvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_srvsvc_NetCharDevQEnum_ndr_pack");
		return NULL;
	}
	call = &ndr_table_srvsvc.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_srvsvc_NetCharDevQEnum_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args,