#ifndef __LIB_PARAM_PARAM_PROTO_H__
#define __LIB_PARAM_PARAM_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../lib/param/loadparm.c  */

struct loadparm_service *lpcfg_default_service(struct loadparm_context *lp_ctx);
int lpcfg_rpc_low_port(struct loadparm_context *lp_ctx);
int lpcfg_rpc_high_port(struct loadparm_context *lp_ctx);
enum samba_weak_crypto lpcfg_weak_crypto(struct loadparm_context *lp_ctx);

/**
 * Convenience routine to grab string parameters into temporary memory
 * and run standard_sub_basic on them.
 *
 * The buffers can be written to by
 * callers without affecting the source string.
 */
struct parmlist_entry *get_parametric_helper(struct loadparm_service *service,
					     const char *type, const char *option,
					     struct parmlist_entry *global_opts);
const char *lpcfg_get_parametric(struct loadparm_context *lp_ctx,
			      struct loadparm_service *service,
			      const char *type, const char *option);

/**
 * convenience routine to return int parameters.
 */
int lp_int(const char *s);

/**
 * convenience routine to return unsigned long parameters.
 */
unsigned long lp_ulong(const char *s);

/**
 * convenience routine to return unsigned long long parameters.
 */
unsigned long long lp_ulonglong(const char *s);

/**
 * convenience routine to return boolean parameters.
 */
bool lp_bool(const char *s);

/**
 * Return parametric option from a given service. Type is a part of option before ':'
 * Parametric option has following syntax: 'Type: option = value'
 * Returned value is allocated in 'lp_talloc' context
 */
const char *lpcfg_parm_string(struct loadparm_context *lp_ctx,
			      struct loadparm_service *service, const char *type,
			      const char *option);

/**
 * Return parametric option from a given service. Type is a part of option before ':'
 * Parametric option has following syntax: 'Type: option = value'
 * Returned value is allocated in 'lp_talloc' context
 */
const char **lpcfg_parm_string_list(TALLOC_CTX *mem_ctx,
				    struct loadparm_context *lp_ctx,
				    struct loadparm_service *service,
				    const char *type,
				    const char *option, const char *separator);

/**
 * Return parametric option from a given service. Type is a part of option before ':'
 * Parametric option has following syntax: 'Type: option = value'
 */
int lpcfg_parm_int(struct loadparm_context *lp_ctx,
		   struct loadparm_service *service, const char *type,
		   const char *option, int default_v);

/**
 * Return parametric option from a given service. Type is a part of
 * option before ':'.
 * Parametric option has following syntax: 'Type: option = value'.
 */
int lpcfg_parm_bytes(struct loadparm_context *lp_ctx,
		  struct loadparm_service *service, const char *type,
		  const char *option, int default_v);

/**
 * Return parametric option from a given service.
 * Type is a part of option before ':'
 * Parametric option has following syntax: 'Type: option = value'
 */
unsigned long lpcfg_parm_ulong(struct loadparm_context *lp_ctx,
			    struct loadparm_service *service, const char *type,
			    const char *option, unsigned long default_v);

/**
 * Return parametric option from a given service.
 * Type is a part of option before ':'
 * Parametric option has following syntax: 'Type: option = value'
 */
unsigned long long lpcfg_parm_ulonglong(struct loadparm_context *lp_ctx,
					struct loadparm_service *service,
					const char *type, const char *option,
					unsigned long long default_v);
long lpcfg_parm_long(struct loadparm_context *lp_ctx,
		     struct loadparm_service *service, const char *type,
		     const char *option, long default_v);
double lpcfg_parm_double(struct loadparm_context *lp_ctx,
		      struct loadparm_service *service, const char *type,
		      const char *option, double default_v);

/**
 * Return parametric option from a given service. Type is a part of option before ':'
 * Parametric option has following syntax: 'Type: option = value'
 */
bool lpcfg_parm_bool(struct loadparm_context *lp_ctx,
		     struct loadparm_service *service, const char *type,
		     const char *option, bool default_v);

/**
 Free a string value.
**/
void lpcfg_string_free(char **s);

/**
 * Set a string value, deallocating any existing space, and allocing the space
 * for the string
 */
bool lpcfg_string_set(TALLOC_CTX *mem_ctx, char **dest, const char *src);

/**
 * Set a string value, deallocating any existing space, and allocing the space
 * for the string
 */
bool lpcfg_string_set_upper(TALLOC_CTX *mem_ctx, char **dest, const char *src);

/**
 * Add a new service to the services array initialising it with the given
 * service.
 */
struct loadparm_service *lpcfg_add_service(struct loadparm_context *lp_ctx,
					   const struct loadparm_service *pservice,
					   const char *name);

/**
 * Map a parameter's string representation to something we can use.
 * Returns False if the parameter string is not recognised, else TRUE.
 */
int lpcfg_map_parameter(const char *pszParmName);

/**
  return the parameter structure for a parameter
*/
struct parm_struct *lpcfg_parm_struct(struct loadparm_context *lp_ctx, const char *name);

/**
  return the parameter pointer for a parameter
*/
void *lpcfg_parm_ptr(struct loadparm_context *lp_ctx,
		  struct loadparm_service *service, struct parm_struct *parm);

/**
  return the parameter pointer for a parameter
*/
bool lpcfg_parm_is_cmdline(struct loadparm_context *lp_ctx, const char *name);
bool lpcfg_parm_is_unspecified(struct loadparm_context *lp_ctx, const char *name);

/**
 * Add a parametric option to a parmlist_entry,
 * replacing old value, if already present.
 */
void set_param_opt(TALLOC_CTX *mem_ctx,
		   struct parmlist_entry **opt_list,
		   const char *opt_name,
		   const char *opt_value,
		   unsigned priority);

/**
 * Copy a service structure to another.
 * If pcopymapDest is NULL then copy all fields
 */
void copy_service(struct loadparm_service *pserviceDest,
		  const struct loadparm_service *pserviceSource,
		  struct bitmap *pcopymapDest);

/**
 * Check a service for consistency. Return False if the service is in any way
 * incomplete or faulty, else True.
 */
bool lpcfg_service_ok(struct loadparm_service *service);

/*******************************************************************
 Keep a linked list of all config files so we know when one has changed
 it's date and needs to be reloaded.
********************************************************************/
void add_to_file_list(TALLOC_CTX *mem_ctx, struct file_lists **list,
			     const char *fname, const char *subfname);
bool lp_set_enum_parm( struct parm_struct *parm, const char *pszParmValue,
                              int *ptr );

/***************************************************************************
 Handle the "realm" parameter
***************************************************************************/
bool handle_realm(struct loadparm_context *lp_ctx, struct loadparm_service *service,
		  const char *pszParmValue, char **ptr);

/***************************************************************************
 Handle the include operation.
***************************************************************************/
bool handle_include(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			   const char *pszParmValue, char **ptr);

/***************************************************************************
 Handle the interpretation of the copy parameter.
***************************************************************************/
bool handle_copy(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			const char *pszParmValue, char **ptr);
bool handle_debug_list(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			const char *pszParmValue, char **ptr);
bool handle_logfile(struct loadparm_context *lp_ctx, struct loadparm_service *service,
		    const char *pszParmValue, char **ptr);
bool handle_charset(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			const char *pszParmValue, char **ptr);
bool handle_dos_charset(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			const char *pszParmValue, char **ptr);
bool handle_printing(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			    const char *pszParmValue, char **ptr);
bool handle_ldap_debug_level(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			     const char *pszParmValue, char **ptr);
bool handle_idmap_backend(struct loadparm_context *lp_ctx, struct loadparm_service *service,
			  const char *pszParmValue, char **ptr);
bool handle_idmap_uid(struct loadparm_context *lp_ctx, struct loadparm_service *service,
		      const char *pszParmValue, char **ptr);
bool handle_idmap_gid(struct loadparm_context *lp_ctx, struct loadparm_service *service,
		      const char *pszParmValue, char **ptr);
bool smb_transport_parse(const char *_value, struct smb_transport *_t);
bool handle_client_smb_transports(struct loadparm_context *lp_ctx,
				  struct loadparm_service *service,
				  const char *pszParmValue,
				  char **ptr);
bool handle_server_smb_transports(struct loadparm_context *lp_ctx,
				  struct loadparm_service *service,
				  const char *pszParmValue,
				  char **ptr);
bool handle_rpc_server_dynamic_port_range(struct loadparm_context *lp_ctx,
					  struct loadparm_service *service,
					  const char *pszParmValue,
					  char **ptr);
bool handle_smb2_max_credits(struct loadparm_context *lp_ctx,
			     struct loadparm_service *service,
			     const char *pszParmValue, char **ptr);
bool handle_cups_encrypt(struct loadparm_context *lp_ctx,
			 struct loadparm_service *service,
			 const char *pszParmValue, char **ptr);

/**
 * Initializes service copymap
 * Note: pservice *must* be valid TALLOC_CTX
 */
void init_copymap(struct loadparm_service *pservice);

/**
 * Process a parametric option
 */
bool handle_name_resolve_order(struct loadparm_context *lp_ctx,
			       struct loadparm_service *service,
			       const char *pszParmValue, char **ptr);
bool handle_kdc_default_domain_supported_enctypes(struct loadparm_context *lp_ctx,
						  struct loadparm_service *service,
						  const char *pszParmValue, char **ptr);
bool handle_kdc_supported_enctypes(struct loadparm_context *lp_ctx,
				   struct loadparm_service *service,
				   const char *pszParmValue, char **ptr);
bool lpcfg_do_global_parameter(struct loadparm_context *lp_ctx,
			       const char *pszParmName, const char *pszParmValue);
bool lpcfg_do_service_parameter(struct loadparm_context *lp_ctx,
				struct loadparm_service *service,
				const char *pszParmName, const char *pszParmValue);

/**
 * Process a parameter.
 */
bool lpcfg_do_parameter(const char *pszParmName, const char *pszParmValue,
			 void *userdata);
bool lpcfg_do_global_parameter_var(struct loadparm_context *lp_ctx,
				const char *pszParmName, const char *fmt, ...);
bool lpcfg_set_cmdline(struct loadparm_context *lp_ctx, const char *pszParmName,
		       const char *pszParmValue);
bool lpcfg_set_option(struct loadparm_context *lp_ctx, const char *option);

/**
 * Print a parameter of the specified type.
 */
void lpcfg_print_parameter(struct parm_struct *p, void *ptr, FILE * f);

/**
 *Display the contents of the global structure.
 */
void lpcfg_dump_globals(struct loadparm_context *lp_ctx, FILE *f,
			 bool show_defaults);

/**
 * Display the contents of a single services record.
 */
void lpcfg_dump_a_service(struct loadparm_service * pService, struct loadparm_service *sDefault, FILE * f,
			  unsigned int *flags, bool show_defaults);
bool lpcfg_dump_a_parameter(struct loadparm_context *lp_ctx,
			    struct loadparm_service *service,
			    const char *parm_name, FILE * f);

/***************************************************************************
 Initialise the sDefault parameter structure for the printer values.
***************************************************************************/
void init_printer_values(struct loadparm_context *lp_ctx, TALLOC_CTX *ctx,
			 struct loadparm_service *pService);

/**
 * Initialise the global parameter structure.
 *
 * Note that most callers should use loadparm_init_global() instead
 */
struct loadparm_context *loadparm_init(TALLOC_CTX *mem_ctx);

/**
 * Initialise the global parameter structure.
 */
struct loadparm_context *loadparm_init_global(bool load_default);

/**
 * @brief Initialise the global parameter structure.
 *
 * This function initialized the globals if needed. Make sure that
 * gfree_loadparm() is called before the application exits.
 *
 * @param mem_ctx   The talloc memory context to allocate lp_ctx on.
 *
 * @param s3_fns    The loadparm helper functions to use
 *
 * @return An initialized lp_ctx pointer or NULL on error.
 */
struct loadparm_context *loadparm_init_s3(TALLOC_CTX *mem_ctx,
					  const struct loadparm_s3_helpers *s3_fns);
const char *lpcfg_configfile(struct loadparm_context *lp_ctx);
const char *lp_default_path(void);

/**
 * Update the internal state of a loadparm context after settings
 * have changed.
 */
bool lpcfg_load_default(struct loadparm_context *lp_ctx);

/**
 * Load the services array from the services file.
 *
 * Return True on success, False on failure.
 */
bool lpcfg_load_no_global(struct loadparm_context *lp_ctx, const char *filename);
bool lpcfg_load(struct loadparm_context *lp_ctx, const char *filename);

/**
 * Return the max number of services.
 */
int lpcfg_numservices(struct loadparm_context *lp_ctx);

/**
 * Display the contents of the services array in human-readable form.
 */
void lpcfg_dump(struct loadparm_context *lp_ctx, FILE *f, bool show_defaults,
	     int maxtoprint);

/**
 * Display the contents of one service in human-readable form.
 */
void lpcfg_dump_one(FILE *f, bool show_defaults, struct loadparm_service *service, struct loadparm_service *sDefault);
struct loadparm_service *lpcfg_servicebynum(struct loadparm_context *lp_ctx,
					    int snum);
struct loadparm_service *lpcfg_service(struct loadparm_context *lp_ctx,
				    const char *service_name);
const char *lpcfg_servicename(const struct loadparm_service *service);
struct smb_iconv_handle *lpcfg_iconv_handle(struct loadparm_context *lp_ctx);
struct gensec_settings *lpcfg_gensec_settings(TALLOC_CTX *mem_ctx, struct loadparm_context *lp_ctx);
int lpcfg_server_role(struct loadparm_context *lp_ctx);
int lpcfg_security(struct loadparm_context *lp_ctx);
int lpcfg_client_max_protocol(struct loadparm_context *lp_ctx);
int lpcfg_client_ipc_min_protocol(struct loadparm_context *lp_ctx);
int lpcfg_client_ipc_max_protocol(struct loadparm_context *lp_ctx);
int lpcfg_client_ipc_signing(struct loadparm_context *lp_ctx);
enum credentials_use_kerberos lpcfg_client_use_kerberos(struct loadparm_context *lp_ctx);
bool lpcfg_server_signing_allowed(struct loadparm_context *lp_ctx, bool *mandatory);
int lpcfg_client_use_krb5_netlogon(struct loadparm_context *lp_ctx);
int lpcfg_tdb_hash_size(struct loadparm_context *lp_ctx, const char *name);
int lpcfg_tdb_flags(struct loadparm_context *lp_ctx, int tdb_flags);
bool lpcfg_lanman_auth(struct loadparm_context *lp_ctx);
const struct loadparm_substitution *lpcfg_noop_substitution(void);
char *lpcfg_substituted_string(TALLOC_CTX *mem_ctx,
			       const struct loadparm_substitution *lp_sub,
			       const char *raw_value);

/**
 * @brief Parse a string value of a given parameter to its integer enum value.
 *
 * @param[in]  param_name    The parameter name (e.g. 'client smb encrypt')
 *
 * @param[in]  param_value   The parameter value (e.g. 'required').
 *
 * @return The integer value of the enum the param_value matches or INT32_MIN
 * on error.
 */
int32_t lpcfg_parse_enum_vals(const char *param_name,
			      const char *param_value);
const char *lpcfg_dns_hostname(struct loadparm_context *lp_ctx);

/* The following definitions come from ../../lib/param/util.c  */


/**
 * @file
 * @brief Misc utility functions
 */
bool lpcfg_is_mydomain(struct loadparm_context *lp_ctx,
			     const char *domain);
bool lpcfg_is_my_domain_or_realm(struct loadparm_context *lp_ctx,
			     const char *domain);

/**
  see if a string matches either our primary or one of our secondary 
  netbios aliases. do a case insensitive match
*/
bool lpcfg_is_myname(struct loadparm_context *lp_ctx, const char *name);

/**
 A useful function for returning a path in the Samba lock directory.
**/
char *lpcfg_lock_path(TALLOC_CTX* mem_ctx, struct loadparm_context *lp_ctx,
			 const char *name);

/**
 A useful function for returning a path in the Samba state directory.
**/
char *lpcfg_state_path(TALLOC_CTX* mem_ctx, struct loadparm_context *lp_ctx,
		       const char *name);

/**
 A useful function for returning a path in the Samba cache directory.
**/
char *lpcfg_cache_path(TALLOC_CTX* mem_ctx, struct loadparm_context *lp_ctx,
		       const char *name);

/**
 * @brief Returns an absolute path to a file in the directory containing the current config file
 *
 * @param name File to find, relative to the config file directory.
 *
 * @retval Pointer to a talloc'ed string containing the full path.
 **/
char *lpcfg_config_path(TALLOC_CTX* mem_ctx, struct loadparm_context *lp_ctx,
			   const char *name);

/**
 * @brief Returns an absolute path to a file in the Samba private directory.
 *
 * @param name File to find, relative to PRIVATEDIR.
 * if name is not relative, then use it as-is
 *
 * @retval Pointer to a talloc'ed string containing the full path.
 **/
char *lpcfg_private_path(TALLOC_CTX* mem_ctx,
			    struct loadparm_context *lp_ctx,
			    const char *name);

/**
 * @brief Returns an absolute path to a NTDB or TDB file in the Samba
 * private directory.
 *
 * @param name File to find, relative to PRIVATEDIR, without .tdb extension.
 *
 * @retval Pointer to a talloc'ed string containing the full path, for
 * use with dbwrap_local_open().
 **/
char *lpcfg_private_db_path(TALLOC_CTX *mem_ctx,
			    struct loadparm_context *lp_ctx,
			    const char *name);

/**
  return a path in the smbd.tmp directory, where all temporary file
  for smbd go. If NULL is passed for name then return the directory 
  path itself
*/
char *smbd_tmp_path(TALLOC_CTX *mem_ctx, 
			     struct loadparm_context *lp_ctx,
			     const char *name);
const char *lpcfg_imessaging_path(TALLOC_CTX *mem_ctx,
				       struct loadparm_context *lp_ctx);
const char *lpcfg_sam_name(struct loadparm_context *lp_ctx);
const char *lpcfg_sam_dnsname(struct loadparm_context *lp_ctx);
void lpcfg_default_kdc_policy(TALLOC_CTX *mem_ctx,
				struct loadparm_context *lp_ctx,
				time_t *svc_tkt_lifetime,
				time_t *usr_tkt_lifetime,
				time_t *renewal_lifetime);

/* The following definitions come from ../../lib/param/param_table.c  */

const char* lpcfg_get_smb_protocol(int type);
int num_parameters(void);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __LIB_PARAM_PARAM_PROTO_H__ */

