
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_netlogon.h"
#include "bin/default/librpc/gen_ndr/ndr_netlogon_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/nbt.h"
static PyTypeObject netr_UasInfo_Type;
static PyTypeObject netr_UasLogoffInfo_Type;
static PyTypeObject netr_AcctLockStr_Type;
static PyTypeObject netr_IdentityInfo_Type;
static PyTypeObject netr_PasswordInfo_Type;
static PyTypeObject netr_ChallengeResponse_Type;
static PyTypeObject netr_NetworkInfo_Type;
static PyTypeObject netr_GenericInfo_Type;
static PyTypeObject netr_TicketLogonInfo_Type;
static PyTypeObject netr_LogonLevel_Type;
static PyTypeObject netr_UserSessionKey_Type;
static PyTypeObject netr_LMSessionKey_Type;
static PyTypeObject netr_SamBaseInfo_Type;
static PyTypeObject netr_SamInfo2_Type;
static PyTypeObject netr_SidAttr_Type;
static PyTypeObject netr_SamInfo3_Type;
static PyTypeObject netr_SamInfo6_Type;
static PyTypeObject netr_PacInfo_Type;
static PyTypeObject netr_GenericInfo2_Type;
static PyTypeObject netr_ValidationTicketLogon_Type;
static PyTypeObject netr_Validation_Type;
static PyTypeObject netr_Credential_Type;
static PyTypeObject netlogon_server_pipe_state_Type;
static PyTypeObject netr_Authenticator_Type;
static PyTypeObject netr_DELTA_DELETE_USER_Type;
static PyTypeObject netr_USER_KEY16_Type;
static PyTypeObject netr_PasswordHistory_Type;
static PyTypeObject netr_USER_KEYS2_Type;
static PyTypeObject netr_USER_KEY_UNION_Type;
static PyTypeObject netr_USER_KEYS_Type;
static PyTypeObject netr_USER_PRIVATE_INFO_Type;
static PyTypeObject netr_DELTA_USER_Type;
static PyTypeObject netr_DELTA_DOMAIN_Type;
static PyTypeObject netr_DELTA_GROUP_Type;
static PyTypeObject netr_DELTA_RENAME_Type;
static PyTypeObject netr_DELTA_GROUP_MEMBER_Type;
static PyTypeObject netr_DELTA_ALIAS_Type;
static PyTypeObject netr_DELTA_ALIAS_MEMBER_Type;
static PyTypeObject netr_QUOTA_LIMITS_Type;
static PyTypeObject netr_DELTA_POLICY_Type;
static PyTypeObject netr_DELTA_TRUSTED_DOMAIN_Type;
static PyTypeObject netr_DELTA_ACCOUNT_Type;
static PyTypeObject netr_CIPHER_VALUE_Type;
static PyTypeObject netr_DELTA_SECRET_Type;
static PyTypeObject netr_DELTA_UNION_Type;
static PyTypeObject netr_DELTA_ID_UNION_Type;
static PyTypeObject netr_DELTA_ENUM_Type;
static PyTypeObject netr_DELTA_ENUM_ARRAY_Type;
static PyTypeObject netr_UAS_INFO_0_Type;
static PyTypeObject netr_AccountBuffer_Type;
static PyTypeObject netr_NETLOGON_INFO_1_Type;
static PyTypeObject netr_NETLOGON_INFO_2_Type;
static PyTypeObject netr_NETLOGON_INFO_3_Type;
static PyTypeObject netr_NETLOGON_INFO_4_Type;
static PyTypeObject netr_CONTROL_QUERY_INFORMATION_Type;
static PyTypeObject netr_CONTROL_DATA_INFORMATION_Type;
static PyTypeObject netr_ChangeLogObject_Type;
static PyTypeObject netr_ChangeLogEntry_Type;
static PyTypeObject netr_Blob_Type;
static PyTypeObject netr_DsRGetDCNameInfo_Type;
static PyTypeObject netr_Capabilities_Type;
static PyTypeObject netr_LsaPolicyInformation_Type;
static PyTypeObject netr_OsVersionInfoEx_Type;
static PyTypeObject netr_OsVersion_Type;
static PyTypeObject netr_OsVersionContainer_Type;
static PyTypeObject netr_WorkstationInformation_Type;
static PyTypeObject netr_WorkstationInfo_Type;
static PyTypeObject netr_trust_extension_info_Type;
static PyTypeObject netr_trust_extension_Type;
static PyTypeObject netr_trust_extension_container_Type;
static PyTypeObject netr_OneDomainInfo_Type;
static PyTypeObject netr_DomainInformation_Type;
static PyTypeObject netr_DomainInfo_Type;
static PyTypeObject NL_PASSWORD_VERSION_Type;
static PyTypeObject netr_CryptPassword_Type;
static PyTypeObject netr_SendToSamResetBadPasswordCount_Type;
static PyTypeObject netr_SendToSamMessage_Type;
static PyTypeObject netr_SendToSamBase_Type;
static PyTypeObject netr_DsRAddressToSitenamesWCtr_Type;
static PyTypeObject netr_DsRAddress_Type;
static PyTypeObject netr_DomainTrust_Type;
static PyTypeObject netr_DomainTrustList_Type;
static PyTypeObject netr_DsRAddressToSitenamesExWCtr_Type;
static PyTypeObject DcSitesCtr_Type;
static PyTypeObject netr_TrustInfo_Type;
static PyTypeObject NL_DNS_NAME_INFO_Type;
static PyTypeObject NL_DNS_NAME_INFO_ARRAY_Type;
static PyTypeObject netlogon_InterfaceType;
static PyTypeObject netr_LogonUasLogon_Type;
static PyTypeObject netr_LogonUasLogoff_Type;
static PyTypeObject netr_LogonSamLogon_Type;
static PyTypeObject netr_LogonSamLogoff_Type;
static PyTypeObject netr_ServerReqChallenge_Type;
static PyTypeObject netr_ServerAuthenticate_Type;
static PyTypeObject netr_ServerPasswordSet_Type;
static PyTypeObject netr_DatabaseDeltas_Type;
static PyTypeObject netr_DatabaseSync_Type;
static PyTypeObject netr_AccountDeltas_Type;
static PyTypeObject netr_AccountSync_Type;
static PyTypeObject netr_GetDcName_Type;
static PyTypeObject netr_LogonControl_Type;
static PyTypeObject netr_GetAnyDCName_Type;
static PyTypeObject netr_LogonControl2_Type;
static PyTypeObject netr_ServerAuthenticate2_Type;
static PyTypeObject netr_DatabaseSync2_Type;
static PyTypeObject netr_DatabaseRedo_Type;
static PyTypeObject netr_LogonControl2Ex_Type;
static PyTypeObject netr_NetrEnumerateTrustedDomains_Type;
static PyTypeObject netr_DsRGetDCName_Type;
static PyTypeObject netr_LogonGetCapabilities_Type;
static PyTypeObject netr_LogonGetTrustRid_Type;
static PyTypeObject netr_ServerAuthenticate3_Type;
static PyTypeObject netr_DsRGetDCNameEx_Type;
static PyTypeObject netr_DsRGetSiteName_Type;
static PyTypeObject netr_LogonGetDomainInfo_Type;
static PyTypeObject netr_ServerPasswordSet2_Type;
static PyTypeObject netr_ServerPasswordGet_Type;
static PyTypeObject netr_NetrLogonSendToSam_Type;
static PyTypeObject netr_DsRAddressToSitenamesW_Type;
static PyTypeObject netr_DsRGetDCNameEx2_Type;
static PyTypeObject netr_NetrEnumerateTrustedDomainsEx_Type;
static PyTypeObject netr_DsRAddressToSitenamesExW_Type;
static PyTypeObject netr_DsrGetDcSiteCoverageW_Type;
static PyTypeObject netr_LogonSamLogonEx_Type;
static PyTypeObject netr_DsrEnumerateDomainTrusts_Type;
static PyTypeObject netr_DsrDeregisterDNSHostRecords_Type;
static PyTypeObject netr_ServerTrustPasswordsGet_Type;
static PyTypeObject netr_DsRGetForestTrustInformation_Type;
static PyTypeObject netr_GetForestTrustInformation_Type;
static PyTypeObject netr_LogonSamLogonWithFlags_Type;
static PyTypeObject netr_ServerGetTrustInfo_Type;
static PyTypeObject netr_Unused47_Type;
static PyTypeObject netr_DsrUpdateReadOnlyServerDnsRecords_Type;
static PyTypeObject netr_ServerAuthenticateKerberos_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *lsa_String_Type;
static PyTypeObject *samr_Password_Type;
static PyTypeObject *samr_RidWithAttributeArray_Type;
static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *samr_LogonHours_Type;
static PyTypeObject *lsa_BinaryString_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *lsa_SidArray_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *lsa_ForestTrustInformation_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_netr_UasInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		if (object->account_name == NULL) {
			py_account_name = Py_None;
			Py_INCREF(py_account_name);
		} else {
			py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
		}
	}
	return py_account_name;
}

static int py_netr_UasInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->account_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_priv(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_priv;
	py_priv = PyLong_FromUnsignedLongLong((uint32_t)(object->priv));
	return py_priv;
}

static int py_netr_UasInfo_set_priv(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->priv");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->priv));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->priv = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_auth_flags(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_flags;
	py_auth_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->auth_flags));
	return py_auth_flags;
}

static int py_netr_UasInfo_set_auth_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromUnsignedLongLong((uint32_t)(object->logon_count));
	return py_logon_count;
}

static int py_netr_UasInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_bad_pw_count(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_pw_count;
	py_bad_pw_count = PyLong_FromUnsignedLongLong((uint32_t)(object->bad_pw_count));
	return py_bad_pw_count;
}

static int py_netr_UasInfo_set_bad_pw_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_pw_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_pw_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_pw_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_last_logon(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromLong(object->last_logon);
	return py_last_logon;
}

static int py_netr_UasInfo_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logon");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->last_logon));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->last_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_last_logoff(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromLong(object->last_logoff);
	return py_last_logoff;
}

static int py_netr_UasInfo_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logoff");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->last_logoff));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->last_logoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_logoff_time(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logoff_time;
	py_logoff_time = PyLong_FromLong(object->logoff_time);
	return py_logoff_time;
}

static int py_netr_UasInfo_set_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logoff_time");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->logoff_time));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->logoff_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_kickoff_time(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_kickoff_time;
	py_kickoff_time = PyLong_FromLong(object->kickoff_time);
	return py_kickoff_time;
}

static int py_netr_UasInfo_set_kickoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->kickoff_time");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->kickoff_time));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->kickoff_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_password_age(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_password_age;
	py_password_age = PyLong_FromUnsignedLongLong((uint32_t)(object->password_age));
	return py_password_age;
}

static int py_netr_UasInfo_set_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_age");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_age));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_age = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_pw_can_change(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pw_can_change;
	py_pw_can_change = PyLong_FromLong(object->pw_can_change);
	return py_pw_can_change;
}

static int py_netr_UasInfo_set_pw_can_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pw_can_change");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->pw_can_change));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->pw_can_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_pw_must_change(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pw_must_change;
	py_pw_must_change = PyLong_FromLong(object->pw_must_change);
	return py_pw_must_change;
}

static int py_netr_UasInfo_set_pw_must_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pw_must_change");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->pw_must_change));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->pw_must_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_computer(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_computer;
	if (object->computer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->computer == NULL) {
		py_computer = Py_None;
		Py_INCREF(py_computer);
	} else {
		if (object->computer == NULL) {
			py_computer = Py_None;
			Py_INCREF(py_computer);
		} else {
			py_computer = PyUnicode_Decode(object->computer, strlen(object->computer), "utf-8", "ignore");
		}
	}
	return py_computer;
}

static int py_netr_UasInfo_set_computer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer");
		return -1;
	}
	if (value == Py_None) {
		object->computer = NULL;
	} else {
		object->computer = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->computer = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_domain(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (object->domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_netr_UasInfo_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_script_path(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_script_path;
	if (object->script_path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->script_path == NULL) {
		py_script_path = Py_None;
		Py_INCREF(py_script_path);
	} else {
		if (object->script_path == NULL) {
			py_script_path = Py_None;
			Py_INCREF(py_script_path);
		} else {
			py_script_path = PyUnicode_Decode(object->script_path, strlen(object->script_path), "utf-8", "ignore");
		}
	}
	return py_script_path;
}

static int py_netr_UasInfo_set_script_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->script_path");
		return -1;
	}
	if (value == Py_None) {
		object->script_path = NULL;
	} else {
		object->script_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->script_path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_unknown(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown));
	return py_unknown;
}

static int py_netr_UasInfo_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_UasInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_netr_UasInfo_get_account_name,
		.set = py_netr_UasInfo_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "priv"),
		.get = py_netr_UasInfo_get_priv,
		.set = py_netr_UasInfo_set_priv,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "auth_flags"),
		.get = py_netr_UasInfo_get_auth_flags,
		.set = py_netr_UasInfo_set_auth_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_netr_UasInfo_get_logon_count,
		.set = py_netr_UasInfo_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bad_pw_count"),
		.get = py_netr_UasInfo_get_bad_pw_count,
		.set = py_netr_UasInfo_set_bad_pw_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "last_logon"),
		.get = py_netr_UasInfo_get_last_logon,
		.set = py_netr_UasInfo_set_last_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "last_logoff"),
		.get = py_netr_UasInfo_get_last_logoff,
		.set = py_netr_UasInfo_set_last_logoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "logoff_time"),
		.get = py_netr_UasInfo_get_logoff_time,
		.set = py_netr_UasInfo_set_logoff_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "kickoff_time"),
		.get = py_netr_UasInfo_get_kickoff_time,
		.set = py_netr_UasInfo_set_kickoff_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "password_age"),
		.get = py_netr_UasInfo_get_password_age,
		.set = py_netr_UasInfo_set_password_age,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pw_can_change"),
		.get = py_netr_UasInfo_get_pw_can_change,
		.set = py_netr_UasInfo_set_pw_can_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "pw_must_change"),
		.get = py_netr_UasInfo_get_pw_must_change,
		.set = py_netr_UasInfo_set_pw_must_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "computer"),
		.get = py_netr_UasInfo_get_computer,
		.set = py_netr_UasInfo_set_computer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_netr_UasInfo_get_domain,
		.set = py_netr_UasInfo_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "script_path"),
		.get = py_netr_UasInfo_get_script_path,
		.set = py_netr_UasInfo_set_script_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "unknown"),
		.get = py_netr_UasInfo_get_unknown,
		.set = py_netr_UasInfo_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_UasInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UasInfo, type);
}


static PyTypeObject netr_UasInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_UasInfo",
	.tp_getset = py_netr_UasInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UasInfo_new,
};


static PyObject *py_netr_UasLogoffInfo_get_duration(PyObject *obj, void *closure)
{
	struct netr_UasLogoffInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_duration;
	py_duration = PyLong_FromUnsignedLongLong((uint32_t)(object->duration));
	return py_duration;
}

static int py_netr_UasLogoffInfo_set_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasLogoffInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->duration");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->duration));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->duration = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasLogoffInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_UasLogoffInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromLong((uint16_t)(object->logon_count));
	return py_logon_count;
}

static int py_netr_UasLogoffInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasLogoffInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_UasLogoffInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "duration"),
		.get = py_netr_UasLogoffInfo_get_duration,
		.set = py_netr_UasLogoffInfo_set_duration,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_netr_UasLogoffInfo_get_logon_count,
		.set = py_netr_UasLogoffInfo_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_netr_UasLogoffInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UasLogoffInfo, type);
}


static PyTypeObject netr_UasLogoffInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_UasLogoffInfo",
	.tp_getset = py_netr_UasLogoffInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UasLogoffInfo_new,
};


static PyObject *py_netr_AcctLockStr_get_lockout_duration(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_duration;
	py_lockout_duration = PyLong_FromLongLong(object->lockout_duration);
	return py_lockout_duration;
}

static int py_netr_AcctLockStr_set_lockout_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_duration");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->lockout_duration));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->lockout_duration = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_reset_count(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(obj);
	PyObject *py_reset_count;
	py_reset_count = PyLong_FromUnsignedLongLong(object->reset_count);
	return py_reset_count;
}

static int py_netr_AcctLockStr_set_reset_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reset_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reset_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reset_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_bad_attempt_lockout(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_attempt_lockout;
	py_bad_attempt_lockout = PyLong_FromUnsignedLongLong((uint32_t)(object->bad_attempt_lockout));
	return py_bad_attempt_lockout;
}

static int py_netr_AcctLockStr_set_bad_attempt_lockout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_attempt_lockout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_attempt_lockout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_attempt_lockout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_dummy(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy));
	return py_dummy;
}

static int py_netr_AcctLockStr_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_AcctLockStr_getsetters[] = {
	{
		.name = discard_const_p(char, "lockout_duration"),
		.get = py_netr_AcctLockStr_get_lockout_duration,
		.set = py_netr_AcctLockStr_set_lockout_duration,
		.doc = discard_const_p(char, "PIDL-generated element of base type dlong")
	},
	{
		.name = discard_const_p(char, "reset_count"),
		.get = py_netr_AcctLockStr_get_reset_count,
		.set = py_netr_AcctLockStr_set_reset_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type udlong")
	},
	{
		.name = discard_const_p(char, "bad_attempt_lockout"),
		.get = py_netr_AcctLockStr_get_bad_attempt_lockout,
		.set = py_netr_AcctLockStr_set_bad_attempt_lockout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dummy"),
		.get = py_netr_AcctLockStr_get_dummy,
		.set = py_netr_AcctLockStr_set_dummy,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_AcctLockStr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_AcctLockStr, type);
}

static PyObject *py_netr_AcctLockStr_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_AcctLockStr);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_AcctLockStr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_AcctLockStr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_AcctLockStr);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_AcctLockStr_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_AcctLockStr *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_AcctLockStr, "netr_AcctLockStr", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_AcctLockStr, "netr_AcctLockStr", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_AcctLockStr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_AcctLockStr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_AcctLockStr_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_AcctLockStr_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_AcctLockStr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_AcctLockStr",
	.tp_getset = py_netr_AcctLockStr_getsetters,
	.tp_methods = py_netr_AcctLockStr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_AcctLockStr_new,
};


static PyObject *py_netr_IdentityInfo_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_IdentityInfo_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_parameter_control(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_parameter_control;
	py_parameter_control = PyLong_FromUnsignedLongLong((uint32_t)(object->parameter_control));
	return py_parameter_control;
}

static int py_netr_IdentityInfo_set_parameter_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->parameter_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->parameter_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->parameter_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_logon_id(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_id;
	py_logon_id = PyLong_FromUnsignedLongLong(object->logon_id);
	return py_logon_id;
}

static int py_netr_IdentityInfo_set_logon_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_IdentityInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_workstation(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_workstation;
	py_workstation = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstation);
	return py_workstation;
}

static int py_netr_IdentityInfo_set_workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstation");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstation = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_IdentityInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_netr_IdentityInfo_get_domain_name,
		.set = py_netr_IdentityInfo_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "parameter_control"),
		.get = py_netr_IdentityInfo_get_parameter_control,
		.set = py_netr_IdentityInfo_set_parameter_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LogonParameterControl")
	},
	{
		.name = discard_const_p(char, "logon_id"),
		.get = py_netr_IdentityInfo_get_logon_id,
		.set = py_netr_IdentityInfo_set_logon_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type udlong")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_netr_IdentityInfo_get_account_name,
		.set = py_netr_IdentityInfo_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "workstation"),
		.get = py_netr_IdentityInfo_get_workstation,
		.set = py_netr_IdentityInfo_set_workstation,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_netr_IdentityInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_IdentityInfo, type);
}


static PyTypeObject netr_IdentityInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_IdentityInfo",
	.tp_getset = py_netr_IdentityInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_IdentityInfo_new,
};


static PyObject *py_netr_PasswordInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = pytalloc_reference_ex(&netr_IdentityInfo_Type, pytalloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_PasswordInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identity_info");
		return -1;
	}
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->identity_info = *(struct netr_IdentityInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PasswordInfo_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_PasswordInfo_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmpassword");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lmpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PasswordInfo_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_PasswordInfo_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntpassword");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_PasswordInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "identity_info"),
		.get = py_netr_PasswordInfo_get_identity_info,
		.set = py_netr_PasswordInfo_set_identity_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_IdentityInfo")
	},
	{
		.name = discard_const_p(char, "lmpassword"),
		.get = py_netr_PasswordInfo_get_lmpassword,
		.set = py_netr_PasswordInfo_set_lmpassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{
		.name = discard_const_p(char, "ntpassword"),
		.get = py_netr_PasswordInfo_get_ntpassword,
		.set = py_netr_PasswordInfo_set_ntpassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{ .name = NULL }
};

static PyObject *py_netr_PasswordInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_PasswordInfo, type);
}

static PyObject *py_netr_PasswordInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_PasswordInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_PasswordInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_PasswordInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_PasswordInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_PasswordInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_PasswordInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_PasswordInfo, "netr_PasswordInfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_PasswordInfo, "netr_PasswordInfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_PasswordInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_PasswordInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_PasswordInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_PasswordInfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_PasswordInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_PasswordInfo",
	.tp_getset = py_netr_PasswordInfo_getsetters,
	.tp_methods = py_netr_PasswordInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_PasswordInfo_new,
};


static PyObject *py_netr_ChallengeResponse_get_length(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_netr_ChallengeResponse_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChallengeResponse_get_size(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_netr_ChallengeResponse_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChallengeResponse_get_data(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_ChallengeResponse_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_ChallengeResponse_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_ChallengeResponse_get_length,
		.set = py_netr_ChallengeResponse_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_netr_ChallengeResponse_get_size,
		.set = py_netr_ChallengeResponse_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_netr_ChallengeResponse_get_data,
		.set = py_netr_ChallengeResponse_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_ChallengeResponse_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_ChallengeResponse, type);
}


static PyTypeObject netr_ChallengeResponse_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_ChallengeResponse",
	.tp_getset = py_netr_ChallengeResponse_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_ChallengeResponse_new,
};


static PyObject *py_netr_NetworkInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = pytalloc_reference_ex(&netr_IdentityInfo_Type, pytalloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_NetworkInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identity_info");
		return -1;
	}
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->identity_info = *(struct netr_IdentityInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_challenge(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_challenge;
	py_challenge = PyList_New(8);
	if (py_challenge == NULL) {
		return NULL;
	}
	{
		int challenge_cntr_0;
		for (challenge_cntr_0 = 0; challenge_cntr_0 < (8); challenge_cntr_0++) {
			PyObject *py_challenge_0;
			py_challenge_0 = PyLong_FromLong((uint16_t)((object->challenge)[challenge_cntr_0]));
			PyList_SetItem(py_challenge, challenge_cntr_0, py_challenge_0);
		}
	}
	return py_challenge;
}

static int py_netr_NetworkInfo_set_challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->challenge");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int challenge_cntr_0;
		if (ARRAY_SIZE(object->challenge) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->challenge),  PyList_GET_SIZE(value));
			return -1;
		}
		for (challenge_cntr_0 = 0; challenge_cntr_0 < PyList_GET_SIZE(value); challenge_cntr_0++) {
			if (PyList_GET_ITEM(value, challenge_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->challenge)[challenge_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->challenge)[challenge_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, challenge_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, challenge_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->challenge)[challenge_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_nt(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_nt;
	py_nt = pytalloc_reference_ex(&netr_ChallengeResponse_Type, pytalloc_get_mem_ctx(obj), &object->nt);
	return py_nt;
}

static int py_netr_NetworkInfo_set_nt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt");
		return -1;
	}
	PY_CHECK_TYPE(&netr_ChallengeResponse_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nt = *(struct netr_ChallengeResponse *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_lm(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_lm;
	py_lm = pytalloc_reference_ex(&netr_ChallengeResponse_Type, pytalloc_get_mem_ctx(obj), &object->lm);
	return py_lm;
}

static int py_netr_NetworkInfo_set_lm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm");
		return -1;
	}
	PY_CHECK_TYPE(&netr_ChallengeResponse_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lm = *(struct netr_ChallengeResponse *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_NetworkInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "identity_info"),
		.get = py_netr_NetworkInfo_get_identity_info,
		.set = py_netr_NetworkInfo_set_identity_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_IdentityInfo")
	},
	{
		.name = discard_const_p(char, "challenge"),
		.get = py_netr_NetworkInfo_get_challenge,
		.set = py_netr_NetworkInfo_set_challenge,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "nt"),
		.get = py_netr_NetworkInfo_get_nt,
		.set = py_netr_NetworkInfo_set_nt,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_ChallengeResponse")
	},
	{
		.name = discard_const_p(char, "lm"),
		.get = py_netr_NetworkInfo_get_lm,
		.set = py_netr_NetworkInfo_set_lm,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_ChallengeResponse")
	},
	{ .name = NULL }
};

static PyObject *py_netr_NetworkInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NetworkInfo, type);
}

static PyObject *py_netr_NetworkInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_NetworkInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_NetworkInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_NetworkInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_NetworkInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_NetworkInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_NetworkInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_NetworkInfo, "netr_NetworkInfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_NetworkInfo, "netr_NetworkInfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_NetworkInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_NetworkInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_NetworkInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_NetworkInfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_NetworkInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_NetworkInfo",
	.tp_getset = py_netr_NetworkInfo_getsetters,
	.tp_methods = py_netr_NetworkInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NetworkInfo_new,
};


static PyObject *py_netr_GenericInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = pytalloc_reference_ex(&netr_IdentityInfo_Type, pytalloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_GenericInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identity_info");
		return -1;
	}
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->identity_info = *(struct netr_IdentityInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_GenericInfo_get_package_name(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_package_name;
	py_package_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->package_name);
	return py_package_name;
}

static int py_netr_GenericInfo_set_package_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->package_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->package_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_GenericInfo_get_length(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_netr_GenericInfo_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_GenericInfo_get_data(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_GenericInfo_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_GenericInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "identity_info"),
		.get = py_netr_GenericInfo_get_identity_info,
		.set = py_netr_GenericInfo_set_identity_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_IdentityInfo")
	},
	{
		.name = discard_const_p(char, "package_name"),
		.get = py_netr_GenericInfo_get_package_name,
		.set = py_netr_GenericInfo_set_package_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_GenericInfo_get_length,
		.set = py_netr_GenericInfo_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_netr_GenericInfo_get_data,
		.set = py_netr_GenericInfo_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_GenericInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_GenericInfo, type);
}

static PyObject *py_netr_GenericInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_GenericInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_GenericInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_GenericInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_GenericInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_GenericInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_GenericInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_GenericInfo, "netr_GenericInfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_GenericInfo, "netr_GenericInfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_GenericInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_GenericInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_GenericInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_GenericInfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_GenericInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_GenericInfo",
	.tp_getset = py_netr_GenericInfo_getsetters,
	.tp_methods = py_netr_GenericInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_GenericInfo_new,
};


static PyObject *py_netr_TicketLogonInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = pytalloc_reference_ex(&netr_IdentityInfo_Type, pytalloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_TicketLogonInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identity_info");
		return -1;
	}
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->identity_info = *(struct netr_IdentityInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_TicketLogonInfo_get_request_options(PyObject *obj, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_request_options;
	py_request_options = PyLong_FromUnsignedLongLong(object->request_options);
	return py_request_options;
}

static int py_netr_TicketLogonInfo_set_request_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->request_options");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->request_options));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->request_options = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_TicketLogonInfo_get_service_ticket_length(PyObject *obj, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_service_ticket_length;
	py_service_ticket_length = PyLong_FromUnsignedLongLong((uint32_t)(object->service_ticket_length));
	return py_service_ticket_length;
}

static int py_netr_TicketLogonInfo_set_service_ticket_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->service_ticket_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->service_ticket_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->service_ticket_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_TicketLogonInfo_get_service_ticket(PyObject *obj, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_service_ticket;
	if (object->service_ticket == NULL) {
		Py_RETURN_NONE;
	}
	if (object->service_ticket == NULL) {
		py_service_ticket = Py_None;
		Py_INCREF(py_service_ticket);
	} else {
		py_service_ticket = PyList_New(object->service_ticket_length);
		if (py_service_ticket == NULL) {
			return NULL;
		}
		{
			int service_ticket_cntr_1;
			for (service_ticket_cntr_1 = 0; service_ticket_cntr_1 < (object->service_ticket_length); service_ticket_cntr_1++) {
				PyObject *py_service_ticket_1;
				py_service_ticket_1 = PyLong_FromLong((uint16_t)((object->service_ticket)[service_ticket_cntr_1]));
				PyList_SetItem(py_service_ticket, service_ticket_cntr_1, py_service_ticket_1);
			}
		}
	}
	return py_service_ticket;
}

static int py_netr_TicketLogonInfo_set_service_ticket(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->service_ticket));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->service_ticket");
		return -1;
	}
	if (value == Py_None) {
		object->service_ticket = NULL;
	} else {
		object->service_ticket = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int service_ticket_cntr_1;
			object->service_ticket = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->service_ticket, PyList_GET_SIZE(value));
			if (!object->service_ticket) { return -1; }
			talloc_set_name_const(object->service_ticket, "ARRAY: object->service_ticket");
			for (service_ticket_cntr_1 = 0; service_ticket_cntr_1 < PyList_GET_SIZE(value); service_ticket_cntr_1++) {
				if (PyList_GET_ITEM(value, service_ticket_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->service_ticket)[service_ticket_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->service_ticket)[service_ticket_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, service_ticket_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, service_ticket_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->service_ticket)[service_ticket_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_TicketLogonInfo_get_additional_ticket_length(PyObject *obj, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_additional_ticket_length;
	py_additional_ticket_length = PyLong_FromUnsignedLongLong((uint32_t)(object->additional_ticket_length));
	return py_additional_ticket_length;
}

static int py_netr_TicketLogonInfo_set_additional_ticket_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->additional_ticket_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->additional_ticket_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->additional_ticket_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_TicketLogonInfo_get_additional_ticket(PyObject *obj, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_additional_ticket;
	if (object->additional_ticket == NULL) {
		Py_RETURN_NONE;
	}
	if (object->additional_ticket == NULL) {
		py_additional_ticket = Py_None;
		Py_INCREF(py_additional_ticket);
	} else {
		py_additional_ticket = PyList_New(object->additional_ticket_length);
		if (py_additional_ticket == NULL) {
			return NULL;
		}
		{
			int additional_ticket_cntr_1;
			for (additional_ticket_cntr_1 = 0; additional_ticket_cntr_1 < (object->additional_ticket_length); additional_ticket_cntr_1++) {
				PyObject *py_additional_ticket_1;
				py_additional_ticket_1 = PyLong_FromLong((uint16_t)((object->additional_ticket)[additional_ticket_cntr_1]));
				PyList_SetItem(py_additional_ticket, additional_ticket_cntr_1, py_additional_ticket_1);
			}
		}
	}
	return py_additional_ticket;
}

static int py_netr_TicketLogonInfo_set_additional_ticket(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->additional_ticket));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->additional_ticket");
		return -1;
	}
	if (value == Py_None) {
		object->additional_ticket = NULL;
	} else {
		object->additional_ticket = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int additional_ticket_cntr_1;
			object->additional_ticket = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->additional_ticket, PyList_GET_SIZE(value));
			if (!object->additional_ticket) { return -1; }
			talloc_set_name_const(object->additional_ticket, "ARRAY: object->additional_ticket");
			for (additional_ticket_cntr_1 = 0; additional_ticket_cntr_1 < PyList_GET_SIZE(value); additional_ticket_cntr_1++) {
				if (PyList_GET_ITEM(value, additional_ticket_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->additional_ticket)[additional_ticket_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->additional_ticket)[additional_ticket_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, additional_ticket_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, additional_ticket_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->additional_ticket)[additional_ticket_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_TicketLogonInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "identity_info"),
		.get = py_netr_TicketLogonInfo_get_identity_info,
		.set = py_netr_TicketLogonInfo_set_identity_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_IdentityInfo")
	},
	{
		.name = discard_const_p(char, "request_options"),
		.get = py_netr_TicketLogonInfo_get_request_options,
		.set = py_netr_TicketLogonInfo_set_request_options,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_TicketLogonInfoRequestOptions")
	},
	{
		.name = discard_const_p(char, "service_ticket_length"),
		.get = py_netr_TicketLogonInfo_get_service_ticket_length,
		.set = py_netr_TicketLogonInfo_set_service_ticket_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "service_ticket"),
		.get = py_netr_TicketLogonInfo_get_service_ticket,
		.set = py_netr_TicketLogonInfo_set_service_ticket,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "additional_ticket_length"),
		.get = py_netr_TicketLogonInfo_get_additional_ticket_length,
		.set = py_netr_TicketLogonInfo_set_additional_ticket_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "additional_ticket"),
		.get = py_netr_TicketLogonInfo_get_additional_ticket,
		.set = py_netr_TicketLogonInfo_set_additional_ticket,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_TicketLogonInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_TicketLogonInfo, type);
}

static PyObject *py_netr_TicketLogonInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_TicketLogonInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_TicketLogonInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_TicketLogonInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_TicketLogonInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_TicketLogonInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_TicketLogonInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_TicketLogonInfo, "netr_TicketLogonInfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_TicketLogonInfo, "netr_TicketLogonInfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_TicketLogonInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_TicketLogonInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_TicketLogonInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_TicketLogonInfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_TicketLogonInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_TicketLogonInfo",
	.tp_getset = py_netr_TicketLogonInfo_getsetters,
	.tp_methods = py_netr_TicketLogonInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_TicketLogonInfo_new,
};

static PyObject *py_import_netr_LogonLevel(TALLOC_CTX *mem_ctx, int level, union netr_LogonLevel *in)
{
	PyObject *ret;

	switch (level) {
		case NetlogonInteractiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonNetworkInformation:
			if (in->network == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NetworkInfo_Type, in->network, in->network);
			}
			return ret;

		case NetlogonServiceInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonGenericInformation:
			if (in->generic == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_GenericInfo_Type, in->generic, in->generic);
			}
			return ret;

		case NetlogonInteractiveTransitiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonNetworkTransitiveInformation:
			if (in->network == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NetworkInfo_Type, in->network, in->network);
			}
			return ret;

		case NetlogonServiceTransitiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonTicketLogonInformation:
			if (in->ticket == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_TicketLogonInfo_Type, in->ticket, in->ticket);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_LogonLevel *py_export_netr_LogonLevel(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_LogonLevel *ret = talloc_zero(mem_ctx, union netr_LogonLevel);
	switch (level) {
		case NetlogonInteractiveInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->password");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonNetworkInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->network");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->network = NULL;
			} else {
				ret->network = NULL;
				PY_CHECK_TYPE(&netr_NetworkInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->network = (struct netr_NetworkInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonServiceInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->password");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonGenericInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->generic");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->generic = NULL;
			} else {
				ret->generic = NULL;
				PY_CHECK_TYPE(&netr_GenericInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->generic = (struct netr_GenericInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonInteractiveTransitiveInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->password");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonNetworkTransitiveInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->network");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->network = NULL;
			} else {
				ret->network = NULL;
				PY_CHECK_TYPE(&netr_NetworkInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->network = (struct netr_NetworkInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonServiceTransitiveInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->password");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonTicketLogonInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ticket");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ticket = NULL;
			} else {
				ret->ticket = NULL;
				PY_CHECK_TYPE(&netr_TicketLogonInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ticket = (struct netr_TicketLogonInfo *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_LogonLevel_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_LogonLevel *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_LogonLevel *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_LogonLevel!");
		return NULL;
	}

	return py_import_netr_LogonLevel(mem_ctx, level, in);
}

static PyObject *py_netr_LogonLevel_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_LogonLevel *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_LogonLevel(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_LogonLevel_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonLevel_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonLevel_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_LogonLevel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_LogonLevel_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_LogonLevel",
	.tp_getset = NULL,
	.tp_methods = py_netr_LogonLevel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LogonLevel_new,
};


static PyObject *py_netr_UserSessionKey_get_key(PyObject *obj, void *closure)
{
	struct netr_UserSessionKey *object = pytalloc_get_ptr(obj);
	PyObject *py_key;
	py_key = PyList_New(16);
	if (py_key == NULL) {
		return NULL;
	}
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < (16); key_cntr_0++) {
			PyObject *py_key_0;
			py_key_0 = PyLong_FromLong((uint16_t)((object->key)[key_cntr_0]));
			PyList_SetItem(py_key, key_cntr_0, py_key_0);
		}
	}
	return py_key;
}

static int py_netr_UserSessionKey_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UserSessionKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->key");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int key_cntr_0;
		if (ARRAY_SIZE(object->key) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->key),  PyList_GET_SIZE(value));
			return -1;
		}
		for (key_cntr_0 = 0; key_cntr_0 < PyList_GET_SIZE(value); key_cntr_0++) {
			if (PyList_GET_ITEM(value, key_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->key)[key_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->key)[key_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, key_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, key_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->key)[key_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_UserSessionKey_getsetters[] = {
	{
		.name = discard_const_p(char, "key"),
		.get = py_netr_UserSessionKey_get_key,
		.set = py_netr_UserSessionKey_set_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_UserSessionKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UserSessionKey, type);
}

static PyObject *py_netr_UserSessionKey_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_UserSessionKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_UserSessionKey);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_UserSessionKey_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_UserSessionKey *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_UserSessionKey);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_UserSessionKey);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_UserSessionKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_UserSessionKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_UserSessionKey, "netr_UserSessionKey", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_UserSessionKey, "netr_UserSessionKey", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_UserSessionKey_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_UserSessionKey_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_UserSessionKey_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_UserSessionKey_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_UserSessionKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_UserSessionKey",
	.tp_getset = py_netr_UserSessionKey_getsetters,
	.tp_methods = py_netr_UserSessionKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UserSessionKey_new,
};


static PyObject *py_netr_LMSessionKey_get_key(PyObject *obj, void *closure)
{
	struct netr_LMSessionKey *object = pytalloc_get_ptr(obj);
	PyObject *py_key;
	py_key = PyList_New(8);
	if (py_key == NULL) {
		return NULL;
	}
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < (8); key_cntr_0++) {
			PyObject *py_key_0;
			py_key_0 = PyLong_FromLong((uint16_t)((object->key)[key_cntr_0]));
			PyList_SetItem(py_key, key_cntr_0, py_key_0);
		}
	}
	return py_key;
}

static int py_netr_LMSessionKey_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LMSessionKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->key");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int key_cntr_0;
		if (ARRAY_SIZE(object->key) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->key),  PyList_GET_SIZE(value));
			return -1;
		}
		for (key_cntr_0 = 0; key_cntr_0 < PyList_GET_SIZE(value); key_cntr_0++) {
			if (PyList_GET_ITEM(value, key_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->key)[key_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->key)[key_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, key_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, key_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->key)[key_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_LMSessionKey_getsetters[] = {
	{
		.name = discard_const_p(char, "key"),
		.get = py_netr_LMSessionKey_get_key,
		.set = py_netr_LMSessionKey_set_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_LMSessionKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_LMSessionKey, type);
}

static PyObject *py_netr_LMSessionKey_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_LMSessionKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_LMSessionKey);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_LMSessionKey_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_LMSessionKey *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_LMSessionKey);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_LMSessionKey);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_LMSessionKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_LMSessionKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_LMSessionKey, "netr_LMSessionKey", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_LMSessionKey, "netr_LMSessionKey", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_LMSessionKey_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_LMSessionKey_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LMSessionKey_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LMSessionKey_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_LMSessionKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_LMSessionKey",
	.tp_getset = py_netr_LMSessionKey_getsetters,
	.tp_methods = py_netr_LMSessionKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LMSessionKey_new,
};


static PyObject *py_netr_SamBaseInfo_get_logon_time(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_time;
	py_logon_time = PyLong_FromUnsignedLongLong(object->logon_time);
	return py_logon_time;
}

static int py_netr_SamBaseInfo_set_logon_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logoff_time(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logoff_time;
	py_logoff_time = PyLong_FromUnsignedLongLong(object->logoff_time);
	return py_logoff_time;
}

static int py_netr_SamBaseInfo_set_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logoff_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logoff_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logoff_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_kickoff_time(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_kickoff_time;
	py_kickoff_time = PyLong_FromUnsignedLongLong(object->kickoff_time);
	return py_kickoff_time;
}

static int py_netr_SamBaseInfo_set_kickoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->kickoff_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->kickoff_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->kickoff_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromUnsignedLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_netr_SamBaseInfo_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_allow_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_allow_password_change;
	py_allow_password_change = PyLong_FromUnsignedLongLong(object->allow_password_change);
	return py_allow_password_change;
}

static int py_netr_SamBaseInfo_set_allow_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->allow_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->allow_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->allow_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_force_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_force_password_change;
	py_force_password_change = PyLong_FromUnsignedLongLong(object->force_password_change);
	return py_force_password_change;
}

static int py_netr_SamBaseInfo_set_force_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->force_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_SamBaseInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_full_name(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_netr_SamBaseInfo_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_script(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_netr_SamBaseInfo_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_script");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_profile_path(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_netr_SamBaseInfo_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->profile_path");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_home_directory(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_netr_SamBaseInfo_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_directory");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_home_drive(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_netr_SamBaseInfo_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_drive");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromLong((uint16_t)(object->logon_count));
	return py_logon_count;
}

static int py_netr_SamBaseInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_bad_password_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyLong_FromLong((uint16_t)(object->bad_password_count));
	return py_bad_password_count;
}

static int py_netr_SamBaseInfo_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_password_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_password_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_password_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_rid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_netr_SamBaseInfo_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_primary_gid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_netr_SamBaseInfo_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_groups(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_groups;
	py_groups = pytalloc_reference_ex(samr_RidWithAttributeArray_Type, pytalloc_get_mem_ctx(obj), &object->groups);
	return py_groups;
}

static int py_netr_SamBaseInfo_set_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->groups");
		return -1;
	}
	PY_CHECK_TYPE(samr_RidWithAttributeArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->groups = *(struct samr_RidWithAttributeArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_user_flags(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_user_flags;
	py_user_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->user_flags));
	return py_user_flags;
}

static int py_netr_SamBaseInfo_set_user_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_key(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_key;
	py_key = pytalloc_reference_ex(&netr_UserSessionKey_Type, pytalloc_get_mem_ctx(obj), &object->key);
	return py_key;
}

static int py_netr_SamBaseInfo_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->key");
		return -1;
	}
	PY_CHECK_TYPE(&netr_UserSessionKey_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->key = *(struct netr_UserSessionKey *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_server(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_server;
	py_logon_server = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->logon_server);
	return py_logon_server;
}

static int py_netr_SamBaseInfo_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_server");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_server = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_domain(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_domain;
	py_logon_domain = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->logon_domain);
	return py_logon_domain;
}

static int py_netr_SamBaseInfo_set_logon_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_domain");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_domain = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_domain_sid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_netr_SamBaseInfo_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domain_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_sid");
		return -1;
	}
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_LMSessKey(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_LMSessKey;
	py_LMSessKey = pytalloc_reference_ex(&netr_LMSessionKey_Type, pytalloc_get_mem_ctx(obj), &object->LMSessKey);
	return py_LMSessKey;
}

static int py_netr_SamBaseInfo_set_LMSessKey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->LMSessKey");
		return -1;
	}
	PY_CHECK_TYPE(&netr_LMSessionKey_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->LMSessKey = *(struct netr_LMSessionKey *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_acct_flags(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_netr_SamBaseInfo_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_sub_auth_status(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_sub_auth_status;
	py_sub_auth_status = PyLong_FromUnsignedLongLong((uint32_t)(object->sub_auth_status));
	return py_sub_auth_status;
}

static int py_netr_SamBaseInfo_set_sub_auth_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sub_auth_status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sub_auth_status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sub_auth_status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_successful_logon(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_last_successful_logon;
	py_last_successful_logon = PyLong_FromUnsignedLongLong(object->last_successful_logon);
	return py_last_successful_logon;
}

static int py_netr_SamBaseInfo_set_last_successful_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_successful_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_successful_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_successful_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_failed_logon(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_last_failed_logon;
	py_last_failed_logon = PyLong_FromUnsignedLongLong(object->last_failed_logon);
	return py_last_failed_logon;
}

static int py_netr_SamBaseInfo_set_last_failed_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_failed_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_failed_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_failed_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_failed_logon_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_failed_logon_count;
	py_failed_logon_count = PyLong_FromUnsignedLongLong((uint32_t)(object->failed_logon_count));
	return py_failed_logon_count;
}

static int py_netr_SamBaseInfo_set_failed_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->failed_logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->failed_logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->failed_logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_reserved(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_netr_SamBaseInfo_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamBaseInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "logon_time"),
		.get = py_netr_SamBaseInfo_get_logon_time,
		.set = py_netr_SamBaseInfo_set_logon_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "logoff_time"),
		.get = py_netr_SamBaseInfo_get_logoff_time,
		.set = py_netr_SamBaseInfo_set_logoff_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "kickoff_time"),
		.get = py_netr_SamBaseInfo_get_kickoff_time,
		.set = py_netr_SamBaseInfo_set_kickoff_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_password_change"),
		.get = py_netr_SamBaseInfo_get_last_password_change,
		.set = py_netr_SamBaseInfo_set_last_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "allow_password_change"),
		.get = py_netr_SamBaseInfo_get_allow_password_change,
		.set = py_netr_SamBaseInfo_set_allow_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "force_password_change"),
		.get = py_netr_SamBaseInfo_get_force_password_change,
		.set = py_netr_SamBaseInfo_set_force_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_netr_SamBaseInfo_get_account_name,
		.set = py_netr_SamBaseInfo_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_netr_SamBaseInfo_get_full_name,
		.set = py_netr_SamBaseInfo_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_script"),
		.get = py_netr_SamBaseInfo_get_logon_script,
		.set = py_netr_SamBaseInfo_set_logon_script,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "profile_path"),
		.get = py_netr_SamBaseInfo_get_profile_path,
		.set = py_netr_SamBaseInfo_set_profile_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_directory"),
		.get = py_netr_SamBaseInfo_get_home_directory,
		.set = py_netr_SamBaseInfo_set_home_directory,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_drive"),
		.get = py_netr_SamBaseInfo_get_home_drive,
		.set = py_netr_SamBaseInfo_set_home_drive,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_netr_SamBaseInfo_get_logon_count,
		.set = py_netr_SamBaseInfo_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "bad_password_count"),
		.get = py_netr_SamBaseInfo_get_bad_password_count,
		.set = py_netr_SamBaseInfo_set_bad_password_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_netr_SamBaseInfo_get_rid,
		.set = py_netr_SamBaseInfo_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_netr_SamBaseInfo_get_primary_gid,
		.set = py_netr_SamBaseInfo_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "groups"),
		.get = py_netr_SamBaseInfo_get_groups,
		.set = py_netr_SamBaseInfo_set_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_RidWithAttributeArray")
	},
	{
		.name = discard_const_p(char, "user_flags"),
		.get = py_netr_SamBaseInfo_get_user_flags,
		.set = py_netr_SamBaseInfo_set_user_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_UserFlags")
	},
	{
		.name = discard_const_p(char, "key"),
		.get = py_netr_SamBaseInfo_get_key,
		.set = py_netr_SamBaseInfo_set_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_UserSessionKey")
	},
	{
		.name = discard_const_p(char, "logon_server"),
		.get = py_netr_SamBaseInfo_get_logon_server,
		.set = py_netr_SamBaseInfo_set_logon_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "logon_domain"),
		.get = py_netr_SamBaseInfo_get_logon_domain,
		.set = py_netr_SamBaseInfo_set_logon_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "domain_sid"),
		.get = py_netr_SamBaseInfo_get_domain_sid,
		.set = py_netr_SamBaseInfo_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "LMSessKey"),
		.get = py_netr_SamBaseInfo_get_LMSessKey,
		.set = py_netr_SamBaseInfo_set_LMSessKey,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LMSessionKey")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_netr_SamBaseInfo_get_acct_flags,
		.set = py_netr_SamBaseInfo_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{
		.name = discard_const_p(char, "sub_auth_status"),
		.get = py_netr_SamBaseInfo_get_sub_auth_status,
		.set = py_netr_SamBaseInfo_set_sub_auth_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "last_successful_logon"),
		.get = py_netr_SamBaseInfo_get_last_successful_logon,
		.set = py_netr_SamBaseInfo_set_last_successful_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_failed_logon"),
		.get = py_netr_SamBaseInfo_get_last_failed_logon,
		.set = py_netr_SamBaseInfo_set_last_failed_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "failed_logon_count"),
		.get = py_netr_SamBaseInfo_get_failed_logon_count,
		.set = py_netr_SamBaseInfo_set_failed_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_netr_SamBaseInfo_get_reserved,
		.set = py_netr_SamBaseInfo_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_SamBaseInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamBaseInfo, type);
}


static PyTypeObject netr_SamBaseInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SamBaseInfo",
	.tp_getset = py_netr_SamBaseInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamBaseInfo_new,
};


static PyObject *py_netr_SamInfo2_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_base;
	py_base = pytalloc_reference_ex(&netr_SamBaseInfo_Type, pytalloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo2_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->base");
		return -1;
	}
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->base = *(struct netr_SamBaseInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_SamInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "base"),
		.get = py_netr_SamInfo2_get_base,
		.set = py_netr_SamInfo2_set_base,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamBaseInfo")
	},
	{ .name = NULL }
};

static PyObject *py_netr_SamInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamInfo2, type);
}

static PyObject *py_netr_SamInfo2_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_SamInfo2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_SamInfo2);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_SamInfo2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SamInfo2 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo2);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_SamInfo2_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SamInfo2 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SamInfo2, "netr_SamInfo2", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SamInfo2, "netr_SamInfo2", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_SamInfo2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_SamInfo2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SamInfo2_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SamInfo2_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_SamInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SamInfo2",
	.tp_getset = py_netr_SamInfo2_getsetters,
	.tp_methods = py_netr_SamInfo2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamInfo2_new,
};


static PyObject *py_netr_SidAttr_get_sid(PyObject *obj, void *closure)
{
	struct netr_SidAttr *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_netr_SidAttr_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SidAttr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_SidAttr_get_attributes(PyObject *obj, void *closure)
{
	struct netr_SidAttr *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->attributes));
	return py_attributes;
}

static int py_netr_SidAttr_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SidAttr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SidAttr_getsetters[] = {
	{
		.name = discard_const_p(char, "sid"),
		.get = py_netr_SidAttr_get_sid,
		.set = py_netr_SidAttr_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_netr_SidAttr_get_attributes,
		.set = py_netr_SidAttr_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{ .name = NULL }
};

static PyObject *py_netr_SidAttr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SidAttr, type);
}

static PyObject *py_netr_SidAttr_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_SidAttr *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_SidAttr);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_SidAttr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SidAttr *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SidAttr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SidAttr);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_SidAttr_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SidAttr *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SidAttr, "netr_SidAttr", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SidAttr, "netr_SidAttr", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_SidAttr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_SidAttr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SidAttr_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SidAttr_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_SidAttr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SidAttr",
	.tp_getset = py_netr_SidAttr_getsetters,
	.tp_methods = py_netr_SidAttr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SidAttr_new,
};


static PyObject *py_netr_SamInfo3_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_base;
	py_base = pytalloc_reference_ex(&netr_SamBaseInfo_Type, pytalloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo3_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->base");
		return -1;
	}
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->base = *(struct netr_SamBaseInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo3_get_sidcount(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_sidcount;
	py_sidcount = PyLong_FromUnsignedLongLong((uint32_t)(object->sidcount));
	return py_sidcount;
}

static int py_netr_SamInfo3_set_sidcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sidcount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sidcount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sidcount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamInfo3_get_sids(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->sidcount);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->sidcount); sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&netr_SidAttr_Type, object->sids, &(object->sids)[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_netr_SamInfo3_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sids)[sids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&netr_SidAttr_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sids)[sids_cntr_1] = *(struct netr_SidAttr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamInfo3_getsetters[] = {
	{
		.name = discard_const_p(char, "base"),
		.get = py_netr_SamInfo3_get_base,
		.set = py_netr_SamInfo3_set_base,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamBaseInfo")
	},
	{
		.name = discard_const_p(char, "sidcount"),
		.get = py_netr_SamInfo3_get_sidcount,
		.set = py_netr_SamInfo3_set_sidcount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_netr_SamInfo3_get_sids,
		.set = py_netr_SamInfo3_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SidAttr")
	},
	{ .name = NULL }
};

static PyObject *py_netr_SamInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamInfo3, type);
}

static PyObject *py_netr_SamInfo3_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_SamInfo3);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_SamInfo3_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo3);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo3);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_SamInfo3_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SamInfo3 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SamInfo3, "netr_SamInfo3", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SamInfo3, "netr_SamInfo3", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_SamInfo3_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_SamInfo3_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SamInfo3_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SamInfo3_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_SamInfo3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SamInfo3",
	.tp_getset = py_netr_SamInfo3_getsetters,
	.tp_methods = py_netr_SamInfo3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamInfo3_new,
};


static PyObject *py_netr_SamInfo6_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_base;
	py_base = pytalloc_reference_ex(&netr_SamBaseInfo_Type, pytalloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo6_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->base");
		return -1;
	}
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->base = *(struct netr_SamBaseInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_sidcount(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_sidcount;
	py_sidcount = PyLong_FromUnsignedLongLong((uint32_t)(object->sidcount));
	return py_sidcount;
}

static int py_netr_SamInfo6_set_sidcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sidcount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sidcount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sidcount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SamInfo6_get_sids(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->sidcount);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->sidcount); sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&netr_SidAttr_Type, object->sids, &(object->sids)[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_netr_SamInfo6_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sids)[sids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&netr_SidAttr_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sids)[sids_cntr_1] = *(struct netr_SidAttr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_SamInfo6_get_dns_domainname(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domainname;
	py_dns_domainname = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->dns_domainname);
	return py_dns_domainname;
}

static int py_netr_SamInfo6_set_dns_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domainname");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domainname = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_principal_name(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_principal_name;
	py_principal_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->principal_name);
	return py_principal_name;
}

static int py_netr_SamInfo6_set_principal_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->principal_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->principal_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyList_New(20);
	if (py_unknown4 == NULL) {
		return NULL;
	}
	{
		int unknown4_cntr_0;
		for (unknown4_cntr_0 = 0; unknown4_cntr_0 < (20); unknown4_cntr_0++) {
			PyObject *py_unknown4_0;
			py_unknown4_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->unknown4)[unknown4_cntr_0]));
			PyList_SetItem(py_unknown4, unknown4_cntr_0, py_unknown4_0);
		}
	}
	return py_unknown4;
}

static int py_netr_SamInfo6_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unknown4_cntr_0;
		if (ARRAY_SIZE(object->unknown4) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->unknown4),  PyList_GET_SIZE(value));
			return -1;
		}
		for (unknown4_cntr_0 = 0; unknown4_cntr_0 < PyList_GET_SIZE(value); unknown4_cntr_0++) {
			if (PyList_GET_ITEM(value, unknown4_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->unknown4)[unknown4_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->unknown4)[unknown4_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, unknown4_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, unknown4_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->unknown4)[unknown4_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamInfo6_getsetters[] = {
	{
		.name = discard_const_p(char, "base"),
		.get = py_netr_SamInfo6_get_base,
		.set = py_netr_SamInfo6_set_base,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamBaseInfo")
	},
	{
		.name = discard_const_p(char, "sidcount"),
		.get = py_netr_SamInfo6_get_sidcount,
		.set = py_netr_SamInfo6_set_sidcount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_netr_SamInfo6_get_sids,
		.set = py_netr_SamInfo6_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SidAttr")
	},
	{
		.name = discard_const_p(char, "dns_domainname"),
		.get = py_netr_SamInfo6_get_dns_domainname,
		.set = py_netr_SamInfo6_set_dns_domainname,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "principal_name"),
		.get = py_netr_SamInfo6_get_principal_name,
		.set = py_netr_SamInfo6_set_principal_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_SamInfo6_get_unknown4,
		.set = py_netr_SamInfo6_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_SamInfo6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamInfo6, type);
}

static PyObject *py_netr_SamInfo6_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_SamInfo6);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_SamInfo6_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo6);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo6);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_SamInfo6_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SamInfo6 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SamInfo6, "netr_SamInfo6", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SamInfo6, "netr_SamInfo6", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_SamInfo6_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_SamInfo6_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SamInfo6_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SamInfo6_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_SamInfo6_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SamInfo6",
	.tp_getset = py_netr_SamInfo6_getsetters,
	.tp_methods = py_netr_SamInfo6_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamInfo6_new,
};


static PyObject *py_netr_PacInfo_get_pac_size(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pac_size;
	py_pac_size = PyLong_FromUnsignedLongLong((uint32_t)(object->pac_size));
	return py_pac_size;
}

static int py_netr_PacInfo_set_pac_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pac_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pac_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pac_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_pac(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pac;
	if (object->pac == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pac == NULL) {
		py_pac = Py_None;
		Py_INCREF(py_pac);
	} else {
		py_pac = PyList_New(object->pac_size);
		if (py_pac == NULL) {
			return NULL;
		}
		{
			int pac_cntr_1;
			for (pac_cntr_1 = 0; pac_cntr_1 < (object->pac_size); pac_cntr_1++) {
				PyObject *py_pac_1;
				py_pac_1 = PyLong_FromLong((uint16_t)((object->pac)[pac_cntr_1]));
				PyList_SetItem(py_pac, pac_cntr_1, py_pac_1);
			}
		}
	}
	return py_pac;
}

static int py_netr_PacInfo_set_pac(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pac));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pac");
		return -1;
	}
	if (value == Py_None) {
		object->pac = NULL;
	} else {
		object->pac = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pac_cntr_1;
			object->pac = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pac, PyList_GET_SIZE(value));
			if (!object->pac) { return -1; }
			talloc_set_name_const(object->pac, "ARRAY: object->pac");
			for (pac_cntr_1 = 0; pac_cntr_1 < PyList_GET_SIZE(value); pac_cntr_1++) {
				if (PyList_GET_ITEM(value, pac_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pac)[pac_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->pac)[pac_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pac_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pac_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->pac)[pac_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_logon_domain(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_domain;
	py_logon_domain = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_domain);
	return py_logon_domain;
}

static int py_netr_PacInfo_set_logon_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_domain");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_domain = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_logon_server(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_server;
	py_logon_server = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_server);
	return py_logon_server;
}

static int py_netr_PacInfo_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_server");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_server = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_principal_name(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_principal_name;
	py_principal_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->principal_name);
	return py_principal_name;
}

static int py_netr_PacInfo_set_principal_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->principal_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->principal_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_auth_size(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_size;
	py_auth_size = PyLong_FromUnsignedLongLong((uint32_t)(object->auth_size));
	return py_auth_size;
}

static int py_netr_PacInfo_set_auth_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_auth(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_auth;
	if (object->auth == NULL) {
		Py_RETURN_NONE;
	}
	if (object->auth == NULL) {
		py_auth = Py_None;
		Py_INCREF(py_auth);
	} else {
		py_auth = PyList_New(object->auth_size);
		if (py_auth == NULL) {
			return NULL;
		}
		{
			int auth_cntr_1;
			for (auth_cntr_1 = 0; auth_cntr_1 < (object->auth_size); auth_cntr_1++) {
				PyObject *py_auth_1;
				py_auth_1 = PyLong_FromLong((uint16_t)((object->auth)[auth_cntr_1]));
				PyList_SetItem(py_auth, auth_cntr_1, py_auth_1);
			}
		}
	}
	return py_auth;
}

static int py_netr_PacInfo_set_auth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->auth));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth");
		return -1;
	}
	if (value == Py_None) {
		object->auth = NULL;
	} else {
		object->auth = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int auth_cntr_1;
			object->auth = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->auth, PyList_GET_SIZE(value));
			if (!object->auth) { return -1; }
			talloc_set_name_const(object->auth, "ARRAY: object->auth");
			for (auth_cntr_1 = 0; auth_cntr_1 < PyList_GET_SIZE(value); auth_cntr_1++) {
				if (PyList_GET_ITEM(value, auth_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->auth)[auth_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->auth)[auth_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, auth_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, auth_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->auth)[auth_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_user_session_key(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_user_session_key;
	py_user_session_key = pytalloc_reference_ex(&netr_UserSessionKey_Type, pytalloc_get_mem_ctx(obj), &object->user_session_key);
	return py_user_session_key;
}

static int py_netr_PacInfo_set_user_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_session_key");
		return -1;
	}
	PY_CHECK_TYPE(&netr_UserSessionKey_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->user_session_key = *(struct netr_UserSessionKey *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_expansionroom(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_expansionroom;
	py_expansionroom = PyList_New(10);
	if (py_expansionroom == NULL) {
		return NULL;
	}
	{
		int expansionroom_cntr_0;
		for (expansionroom_cntr_0 = 0; expansionroom_cntr_0 < (10); expansionroom_cntr_0++) {
			PyObject *py_expansionroom_0;
			py_expansionroom_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->expansionroom)[expansionroom_cntr_0]));
			PyList_SetItem(py_expansionroom, expansionroom_cntr_0, py_expansionroom_0);
		}
	}
	return py_expansionroom;
}

static int py_netr_PacInfo_set_expansionroom(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->expansionroom");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int expansionroom_cntr_0;
		if (ARRAY_SIZE(object->expansionroom) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->expansionroom),  PyList_GET_SIZE(value));
			return -1;
		}
		for (expansionroom_cntr_0 = 0; expansionroom_cntr_0 < PyList_GET_SIZE(value); expansionroom_cntr_0++) {
			if (PyList_GET_ITEM(value, expansionroom_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->expansionroom)[expansionroom_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->expansionroom)[expansionroom_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, expansionroom_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, expansionroom_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->expansionroom)[expansionroom_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_PacInfo_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_PacInfo_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_PacInfo_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_PacInfo_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_PacInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "pac_size"),
		.get = py_netr_PacInfo_get_pac_size,
		.set = py_netr_PacInfo_set_pac_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pac"),
		.get = py_netr_PacInfo_get_pac,
		.set = py_netr_PacInfo_set_pac,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "logon_domain"),
		.get = py_netr_PacInfo_get_logon_domain,
		.set = py_netr_PacInfo_set_logon_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_server"),
		.get = py_netr_PacInfo_get_logon_server,
		.set = py_netr_PacInfo_set_logon_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "principal_name"),
		.get = py_netr_PacInfo_get_principal_name,
		.set = py_netr_PacInfo_set_principal_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "auth_size"),
		.get = py_netr_PacInfo_get_auth_size,
		.set = py_netr_PacInfo_set_auth_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "auth"),
		.get = py_netr_PacInfo_get_auth,
		.set = py_netr_PacInfo_set_auth,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "user_session_key"),
		.get = py_netr_PacInfo_get_user_session_key,
		.set = py_netr_PacInfo_set_user_session_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_UserSessionKey")
	},
	{
		.name = discard_const_p(char, "expansionroom"),
		.get = py_netr_PacInfo_get_expansionroom,
		.set = py_netr_PacInfo_set_expansionroom,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_PacInfo_get_unknown1,
		.set = py_netr_PacInfo_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_PacInfo_get_unknown2,
		.set = py_netr_PacInfo_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_PacInfo_get_unknown3,
		.set = py_netr_PacInfo_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_PacInfo_get_unknown4,
		.set = py_netr_PacInfo_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_netr_PacInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_PacInfo, type);
}

static PyObject *py_netr_PacInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_PacInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_PacInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_PacInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_PacInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_PacInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_PacInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_PacInfo, "netr_PacInfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_PacInfo, "netr_PacInfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_PacInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_PacInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_PacInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_PacInfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_PacInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_PacInfo",
	.tp_getset = py_netr_PacInfo_getsetters,
	.tp_methods = py_netr_PacInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_PacInfo_new,
};


static PyObject *py_netr_GenericInfo2_get_length(PyObject *obj, void *closure)
{
	struct netr_GenericInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_netr_GenericInfo2_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_GenericInfo2_get_data(PyObject *obj, void *closure)
{
	struct netr_GenericInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_GenericInfo2_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo2 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_GenericInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_GenericInfo2_get_length,
		.set = py_netr_GenericInfo2_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_netr_GenericInfo2_get_data,
		.set = py_netr_GenericInfo2_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_GenericInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_GenericInfo2, type);
}

static PyObject *py_netr_GenericInfo2_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_GenericInfo2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_GenericInfo2);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_GenericInfo2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_GenericInfo2 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_GenericInfo2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_GenericInfo2);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_GenericInfo2_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_GenericInfo2 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_GenericInfo2, "netr_GenericInfo2", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_GenericInfo2, "netr_GenericInfo2", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_GenericInfo2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_GenericInfo2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_GenericInfo2_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_GenericInfo2_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_GenericInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_GenericInfo2",
	.tp_getset = py_netr_GenericInfo2_getsetters,
	.tp_methods = py_netr_GenericInfo2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_GenericInfo2_new,
};


static PyObject *py_netr_ValidationTicketLogon_get_results(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_results;
	py_results = PyLong_FromUnsignedLongLong(object->results);
	return py_results;
}

static int py_netr_ValidationTicketLogon_set_results(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->results");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->results));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->results = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_kerberos_status(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_kerberos_status;
	py_kerberos_status = PyErr_FromNTSTATUS(object->kerberos_status);
	return py_kerberos_status;
}

static int py_netr_ValidationTicketLogon_set_kerberos_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->kerberos_status");
		return -1;
	}
	object->kerberos_status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_netlogon_status(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_netlogon_status;
	py_netlogon_status = PyErr_FromNTSTATUS(object->netlogon_status);
	return py_netlogon_status;
}

static int py_netr_ValidationTicketLogon_set_netlogon_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->netlogon_status");
		return -1;
	}
	object->netlogon_status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_source_of_status(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_source_of_status;
	py_source_of_status = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->source_of_status);
	return py_source_of_status;
}

static int py_netr_ValidationTicketLogon_set_source_of_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_of_status");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_of_status = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_user_information(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_user_information;
	if (object->user_information == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user_information == NULL) {
		py_user_information = Py_None;
		Py_INCREF(py_user_information);
	} else {
		py_user_information = pytalloc_reference_ex(&netr_SamInfo6_Type, object->user_information, object->user_information);
	}
	return py_user_information;
}

static int py_netr_ValidationTicketLogon_set_user_information(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->user_information));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_information");
		return -1;
	}
	if (value == Py_None) {
		object->user_information = NULL;
	} else {
		object->user_information = NULL;
		PY_CHECK_TYPE(&netr_SamInfo6_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->user_information = (struct netr_SamInfo6 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_device_information(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_device_information;
	if (object->device_information == NULL) {
		Py_RETURN_NONE;
	}
	if (object->device_information == NULL) {
		py_device_information = Py_None;
		Py_INCREF(py_device_information);
	} else {
		py_device_information = pytalloc_reference_ex(&netr_SamInfo6_Type, object->device_information, object->device_information);
	}
	return py_device_information;
}

static int py_netr_ValidationTicketLogon_set_device_information(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->device_information));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->device_information");
		return -1;
	}
	if (value == Py_None) {
		object->device_information = NULL;
	} else {
		object->device_information = NULL;
		PY_CHECK_TYPE(&netr_SamInfo6_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->device_information = (struct netr_SamInfo6 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_user_claims_length(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_user_claims_length;
	py_user_claims_length = PyLong_FromUnsignedLongLong((uint32_t)(object->user_claims_length));
	return py_user_claims_length;
}

static int py_netr_ValidationTicketLogon_set_user_claims_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_claims_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_claims_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_claims_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_user_claims(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_user_claims;
	if (object->user_claims == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user_claims == NULL) {
		py_user_claims = Py_None;
		Py_INCREF(py_user_claims);
	} else {
		py_user_claims = PyList_New(object->user_claims_length);
		if (py_user_claims == NULL) {
			return NULL;
		}
		{
			int user_claims_cntr_1;
			for (user_claims_cntr_1 = 0; user_claims_cntr_1 < (object->user_claims_length); user_claims_cntr_1++) {
				PyObject *py_user_claims_1;
				py_user_claims_1 = PyLong_FromLong((uint16_t)((object->user_claims)[user_claims_cntr_1]));
				PyList_SetItem(py_user_claims, user_claims_cntr_1, py_user_claims_1);
			}
		}
	}
	return py_user_claims;
}

static int py_netr_ValidationTicketLogon_set_user_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->user_claims));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_claims");
		return -1;
	}
	if (value == Py_None) {
		object->user_claims = NULL;
	} else {
		object->user_claims = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int user_claims_cntr_1;
			object->user_claims = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->user_claims, PyList_GET_SIZE(value));
			if (!object->user_claims) { return -1; }
			talloc_set_name_const(object->user_claims, "ARRAY: object->user_claims");
			for (user_claims_cntr_1 = 0; user_claims_cntr_1 < PyList_GET_SIZE(value); user_claims_cntr_1++) {
				if (PyList_GET_ITEM(value, user_claims_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->user_claims)[user_claims_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->user_claims)[user_claims_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, user_claims_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, user_claims_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->user_claims)[user_claims_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_device_claims_length(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_device_claims_length;
	py_device_claims_length = PyLong_FromUnsignedLongLong((uint32_t)(object->device_claims_length));
	return py_device_claims_length;
}

static int py_netr_ValidationTicketLogon_set_device_claims_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->device_claims_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->device_claims_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->device_claims_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ValidationTicketLogon_get_device_claims(PyObject *obj, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_device_claims;
	if (object->device_claims == NULL) {
		Py_RETURN_NONE;
	}
	if (object->device_claims == NULL) {
		py_device_claims = Py_None;
		Py_INCREF(py_device_claims);
	} else {
		py_device_claims = PyList_New(object->device_claims_length);
		if (py_device_claims == NULL) {
			return NULL;
		}
		{
			int device_claims_cntr_1;
			for (device_claims_cntr_1 = 0; device_claims_cntr_1 < (object->device_claims_length); device_claims_cntr_1++) {
				PyObject *py_device_claims_1;
				py_device_claims_1 = PyLong_FromLong((uint16_t)((object->device_claims)[device_claims_cntr_1]));
				PyList_SetItem(py_device_claims, device_claims_cntr_1, py_device_claims_1);
			}
		}
	}
	return py_device_claims;
}

static int py_netr_ValidationTicketLogon_set_device_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->device_claims));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->device_claims");
		return -1;
	}
	if (value == Py_None) {
		object->device_claims = NULL;
	} else {
		object->device_claims = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int device_claims_cntr_1;
			object->device_claims = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->device_claims, PyList_GET_SIZE(value));
			if (!object->device_claims) { return -1; }
			talloc_set_name_const(object->device_claims, "ARRAY: object->device_claims");
			for (device_claims_cntr_1 = 0; device_claims_cntr_1 < PyList_GET_SIZE(value); device_claims_cntr_1++) {
				if (PyList_GET_ITEM(value, device_claims_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->device_claims)[device_claims_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->device_claims)[device_claims_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, device_claims_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, device_claims_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->device_claims)[device_claims_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_ValidationTicketLogon_getsetters[] = {
	{
		.name = discard_const_p(char, "results"),
		.get = py_netr_ValidationTicketLogon_get_results,
		.set = py_netr_ValidationTicketLogon_set_results,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_TicketLogonResults")
	},
	{
		.name = discard_const_p(char, "kerberos_status"),
		.get = py_netr_ValidationTicketLogon_get_kerberos_status,
		.set = py_netr_ValidationTicketLogon_set_kerberos_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "netlogon_status"),
		.get = py_netr_ValidationTicketLogon_get_netlogon_status,
		.set = py_netr_ValidationTicketLogon_set_netlogon_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "source_of_status"),
		.get = py_netr_ValidationTicketLogon_get_source_of_status,
		.set = py_netr_ValidationTicketLogon_set_source_of_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "user_information"),
		.get = py_netr_ValidationTicketLogon_get_user_information,
		.set = py_netr_ValidationTicketLogon_set_user_information,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamInfo6")
	},
	{
		.name = discard_const_p(char, "device_information"),
		.get = py_netr_ValidationTicketLogon_get_device_information,
		.set = py_netr_ValidationTicketLogon_set_device_information,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamInfo6")
	},
	{
		.name = discard_const_p(char, "user_claims_length"),
		.get = py_netr_ValidationTicketLogon_get_user_claims_length,
		.set = py_netr_ValidationTicketLogon_set_user_claims_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user_claims"),
		.get = py_netr_ValidationTicketLogon_get_user_claims,
		.set = py_netr_ValidationTicketLogon_set_user_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "device_claims_length"),
		.get = py_netr_ValidationTicketLogon_get_device_claims_length,
		.set = py_netr_ValidationTicketLogon_set_device_claims_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "device_claims"),
		.get = py_netr_ValidationTicketLogon_get_device_claims,
		.set = py_netr_ValidationTicketLogon_set_device_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_ValidationTicketLogon_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_ValidationTicketLogon, type);
}

static PyObject *py_netr_ValidationTicketLogon_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_ValidationTicketLogon);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_ValidationTicketLogon_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_ValidationTicketLogon);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_ValidationTicketLogon);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_ValidationTicketLogon_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_ValidationTicketLogon *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_ValidationTicketLogon, "netr_ValidationTicketLogon", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_ValidationTicketLogon, "netr_ValidationTicketLogon", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_ValidationTicketLogon_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_ValidationTicketLogon_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_ValidationTicketLogon_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_ValidationTicketLogon_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_ValidationTicketLogon_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_ValidationTicketLogon",
	.tp_getset = py_netr_ValidationTicketLogon_getsetters,
	.tp_methods = py_netr_ValidationTicketLogon_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_ValidationTicketLogon_new,
};

static PyObject *py_import_netr_Validation(TALLOC_CTX *mem_ctx, int level, union netr_Validation *in)
{
	PyObject *ret;

	switch (level) {
		case NetlogonValidationSamInfo:
			if (in->sam2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_SamInfo2_Type, in->sam2, in->sam2);
			}
			return ret;

		case NetlogonValidationSamInfo2:
			if (in->sam3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_SamInfo3_Type, in->sam3, in->sam3);
			}
			return ret;

		case 4:
			if (in->pac == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PacInfo_Type, in->pac, in->pac);
			}
			return ret;

		case NetlogonValidationGenericInfo2:
			if (in->generic == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_GenericInfo2_Type, in->generic, in->generic);
			}
			return ret;

		case NetlogonValidationSamInfo4:
			if (in->sam6 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_SamInfo6_Type, in->sam6, in->sam6);
			}
			return ret;

		case NetlogonValidationTicketLogon:
			if (in->ticket == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_ValidationTicketLogon_Type, in->ticket, in->ticket);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_Validation *py_export_netr_Validation(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_Validation *ret = talloc_zero(mem_ctx, union netr_Validation);
	switch (level) {
		case NetlogonValidationSamInfo:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sam2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sam2 = NULL;
			} else {
				ret->sam2 = NULL;
				PY_CHECK_TYPE(&netr_SamInfo2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sam2 = (struct netr_SamInfo2 *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonValidationSamInfo2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sam3");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sam3 = NULL;
			} else {
				ret->sam3 = NULL;
				PY_CHECK_TYPE(&netr_SamInfo3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sam3 = (struct netr_SamInfo3 *)pytalloc_get_ptr(in);
			}
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->pac");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->pac = NULL;
			} else {
				ret->pac = NULL;
				PY_CHECK_TYPE(&netr_PacInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->pac = (struct netr_PacInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonValidationGenericInfo2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->generic");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->generic = NULL;
			} else {
				ret->generic = NULL;
				PY_CHECK_TYPE(&netr_GenericInfo2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->generic = (struct netr_GenericInfo2 *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonValidationSamInfo4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sam6");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sam6 = NULL;
			} else {
				ret->sam6 = NULL;
				PY_CHECK_TYPE(&netr_SamInfo6_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sam6 = (struct netr_SamInfo6 *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonValidationTicketLogon:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ticket");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ticket = NULL;
			} else {
				ret->ticket = NULL;
				PY_CHECK_TYPE(&netr_ValidationTicketLogon_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ticket = (struct netr_ValidationTicketLogon *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_Validation_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_Validation *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_Validation *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_Validation!");
		return NULL;
	}

	return py_import_netr_Validation(mem_ctx, level, in);
}

static PyObject *py_netr_Validation_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_Validation *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_Validation(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_Validation_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Validation_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Validation_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_Validation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_Validation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_Validation",
	.tp_getset = NULL,
	.tp_methods = py_netr_Validation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Validation_new,
};


static PyObject *py_netr_Credential_get_data(PyObject *obj, void *closure)
{
	struct netr_Credential *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(8);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (8); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_netr_Credential_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Credential *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		if (ARRAY_SIZE(object->data) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->data),  PyList_GET_SIZE(value));
			return -1;
		}
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_Credential_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_netr_Credential_get_data,
		.set = py_netr_Credential_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_Credential_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_Credential, type);
}

static PyObject *py_netr_Credential_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_Credential *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_Credential);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_Credential_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_Credential *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Credential);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Credential);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_Credential_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_Credential *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_Credential, "netr_Credential", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_Credential, "netr_Credential", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_Credential_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_Credential_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Credential_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Credential_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_Credential_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_Credential",
	.tp_getset = py_netr_Credential_getsetters,
	.tp_methods = py_netr_Credential_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Credential_new,
};


static PyObject *py_netlogon_server_pipe_state_get_client_challenge(PyObject *obj, void *closure)
{
	struct netlogon_server_pipe_state *object = pytalloc_get_ptr(obj);
	PyObject *py_client_challenge;
	py_client_challenge = pytalloc_reference_ex(&netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->client_challenge);
	return py_client_challenge;
}

static int py_netlogon_server_pipe_state_set_client_challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_server_pipe_state *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_challenge");
		return -1;
	}
	PY_CHECK_TYPE(&netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_challenge = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_server_pipe_state_get_server_challenge(PyObject *obj, void *closure)
{
	struct netlogon_server_pipe_state *object = pytalloc_get_ptr(obj);
	PyObject *py_server_challenge;
	py_server_challenge = pytalloc_reference_ex(&netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->server_challenge);
	return py_server_challenge;
}

static int py_netlogon_server_pipe_state_set_server_challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_server_pipe_state *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_challenge");
		return -1;
	}
	PY_CHECK_TYPE(&netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_challenge = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netlogon_server_pipe_state_getsetters[] = {
	{
		.name = discard_const_p(char, "client_challenge"),
		.get = py_netlogon_server_pipe_state_get_client_challenge,
		.set = py_netlogon_server_pipe_state_set_client_challenge,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{
		.name = discard_const_p(char, "server_challenge"),
		.get = py_netlogon_server_pipe_state_get_server_challenge,
		.set = py_netlogon_server_pipe_state_set_server_challenge,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{ .name = NULL }
};

static PyObject *py_netlogon_server_pipe_state_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netlogon_server_pipe_state, type);
}

static PyObject *py_netlogon_server_pipe_state_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netlogon_server_pipe_state *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netlogon_server_pipe_state);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netlogon_server_pipe_state_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_server_pipe_state *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_server_pipe_state);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_server_pipe_state);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netlogon_server_pipe_state_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_server_pipe_state *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_server_pipe_state, "netlogon_server_pipe_state", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_server_pipe_state, "netlogon_server_pipe_state", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netlogon_server_pipe_state_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netlogon_server_pipe_state_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_server_pipe_state_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_server_pipe_state_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netlogon_server_pipe_state_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.server_pipe_state",
	.tp_getset = py_netlogon_server_pipe_state_getsetters,
	.tp_methods = py_netlogon_server_pipe_state_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netlogon_server_pipe_state_new,
};


static PyObject *py_netr_Authenticator_get_cred(PyObject *obj, void *closure)
{
	struct netr_Authenticator *object = pytalloc_get_ptr(obj);
	PyObject *py_cred;
	py_cred = pytalloc_reference_ex(&netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->cred);
	return py_cred;
}

static int py_netr_Authenticator_set_cred(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Authenticator *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cred");
		return -1;
	}
	PY_CHECK_TYPE(&netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->cred = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_Authenticator_get_timestamp(PyObject *obj, void *closure)
{
	struct netr_Authenticator *object = pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyLong_FromLong(object->timestamp);
	return py_timestamp;
}

static int py_netr_Authenticator_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Authenticator *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timestamp");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->timestamp));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->timestamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_Authenticator_getsetters[] = {
	{
		.name = discard_const_p(char, "cred"),
		.get = py_netr_Authenticator_get_cred,
		.set = py_netr_Authenticator_set_cred,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{
		.name = discard_const_p(char, "timestamp"),
		.get = py_netr_Authenticator_get_timestamp,
		.set = py_netr_Authenticator_set_timestamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{ .name = NULL }
};

static PyObject *py_netr_Authenticator_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_Authenticator, type);
}

static PyObject *py_netr_Authenticator_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_Authenticator *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_Authenticator);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_Authenticator_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_Authenticator *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Authenticator);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Authenticator);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_Authenticator_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_Authenticator *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_Authenticator, "netr_Authenticator", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_Authenticator, "netr_Authenticator", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_Authenticator_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_Authenticator_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Authenticator_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Authenticator_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_Authenticator_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_Authenticator",
	.tp_getset = py_netr_Authenticator_getsetters,
	.tp_methods = py_netr_Authenticator_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Authenticator_new,
};


static PyObject *py_netr_DELTA_DELETE_USER_get_account_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		if (object->account_name == NULL) {
			py_account_name = Py_None;
			Py_INCREF(py_account_name);
		} else {
			py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
		}
	}
	return py_account_name;
}

static int py_netr_DELTA_DELETE_USER_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->account_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_DELETE_USER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_DELETE_USER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_DELETE_USER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_DELETE_USER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_DELETE_USER_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_DELETE_USER_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_DELETE_USER_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_DELETE_USER_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_DELETE_USER_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_netr_DELTA_DELETE_USER_get_account_name,
		.set = py_netr_DELTA_DELETE_USER_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown1,
		.set = py_netr_DELTA_DELETE_USER_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown2,
		.set = py_netr_DELTA_DELETE_USER_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown3,
		.set = py_netr_DELTA_DELETE_USER_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown4,
		.set = py_netr_DELTA_DELETE_USER_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown5,
		.set = py_netr_DELTA_DELETE_USER_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown6,
		.set = py_netr_DELTA_DELETE_USER_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown7,
		.set = py_netr_DELTA_DELETE_USER_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_DELETE_USER_get_unknown8,
		.set = py_netr_DELTA_DELETE_USER_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_DELETE_USER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_DELETE_USER, type);
}


static PyTypeObject netr_DELTA_DELETE_USER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_DELETE_USER",
	.tp_getset = py_netr_DELTA_DELETE_USER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_DELETE_USER_new,
};


static PyObject *py_netr_USER_KEY16_get_length(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_netr_USER_KEY16_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_size(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_netr_USER_KEY16_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_flags(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_netr_USER_KEY16_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_pwd(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(obj);
	PyObject *py_pwd;
	py_pwd = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->pwd);
	return py_pwd;
}

static int py_netr_USER_KEY16_set_pwd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwd");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->pwd = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEY16_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_USER_KEY16_get_length,
		.set = py_netr_USER_KEY16_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_netr_USER_KEY16_get_size,
		.set = py_netr_USER_KEY16_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_netr_USER_KEY16_get_flags,
		.set = py_netr_USER_KEY16_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pwd"),
		.get = py_netr_USER_KEY16_get_pwd,
		.set = py_netr_USER_KEY16_set_pwd,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{ .name = NULL }
};

static PyObject *py_netr_USER_KEY16_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEY16, type);
}


static PyTypeObject netr_USER_KEY16_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_USER_KEY16",
	.tp_getset = py_netr_USER_KEY16_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEY16_new,
};


static PyObject *py_netr_PasswordHistory_get_nt_length(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_length;
	py_nt_length = PyLong_FromLong((uint16_t)(object->nt_length));
	return py_nt_length;
}

static int py_netr_PasswordHistory_set_nt_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_size(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_size;
	py_nt_size = PyLong_FromLong((uint16_t)(object->nt_size));
	return py_nt_size;
}

static int py_netr_PasswordHistory_set_nt_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_flags(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_flags;
	py_nt_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->nt_flags));
	return py_nt_flags;
}

static int py_netr_PasswordHistory_set_nt_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_length(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_length;
	py_lm_length = PyLong_FromLong((uint16_t)(object->lm_length));
	return py_lm_length;
}

static int py_netr_PasswordHistory_set_lm_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_size(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_size;
	py_lm_size = PyLong_FromLong((uint16_t)(object->lm_size));
	return py_lm_size;
}

static int py_netr_PasswordHistory_set_lm_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_flags(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_flags;
	py_lm_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->lm_flags));
	return py_lm_flags;
}

static int py_netr_PasswordHistory_set_lm_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_history(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_history;
	py_nt_history = PyList_New(object->nt_length);
	if (py_nt_history == NULL) {
		return NULL;
	}
	{
		int nt_history_cntr_0;
		for (nt_history_cntr_0 = 0; nt_history_cntr_0 < (object->nt_length); nt_history_cntr_0++) {
			PyObject *py_nt_history_0;
			py_nt_history_0 = PyLong_FromLong((uint16_t)((object->nt_history)[nt_history_cntr_0]));
			PyList_SetItem(py_nt_history, nt_history_cntr_0, py_nt_history_0);
		}
	}
	return py_nt_history;
}

static int py_netr_PasswordHistory_set_nt_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_history");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nt_history_cntr_0;
		object->nt_history = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->nt_history, PyList_GET_SIZE(value));
		if (!object->nt_history) { return -1; }
		talloc_set_name_const(object->nt_history, "ARRAY: object->nt_history");
		for (nt_history_cntr_0 = 0; nt_history_cntr_0 < PyList_GET_SIZE(value); nt_history_cntr_0++) {
			if (PyList_GET_ITEM(value, nt_history_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->nt_history)[nt_history_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->nt_history)[nt_history_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, nt_history_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, nt_history_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->nt_history)[nt_history_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_history(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_history;
	py_lm_history = PyList_New(object->lm_length);
	if (py_lm_history == NULL) {
		return NULL;
	}
	{
		int lm_history_cntr_0;
		for (lm_history_cntr_0 = 0; lm_history_cntr_0 < (object->lm_length); lm_history_cntr_0++) {
			PyObject *py_lm_history_0;
			py_lm_history_0 = PyLong_FromLong((uint16_t)((object->lm_history)[lm_history_cntr_0]));
			PyList_SetItem(py_lm_history, lm_history_cntr_0, py_lm_history_0);
		}
	}
	return py_lm_history;
}

static int py_netr_PasswordHistory_set_lm_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_history");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int lm_history_cntr_0;
		object->lm_history = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->lm_history, PyList_GET_SIZE(value));
		if (!object->lm_history) { return -1; }
		talloc_set_name_const(object->lm_history, "ARRAY: object->lm_history");
		for (lm_history_cntr_0 = 0; lm_history_cntr_0 < PyList_GET_SIZE(value); lm_history_cntr_0++) {
			if (PyList_GET_ITEM(value, lm_history_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->lm_history)[lm_history_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->lm_history)[lm_history_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, lm_history_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, lm_history_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->lm_history)[lm_history_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_PasswordHistory_getsetters[] = {
	{
		.name = discard_const_p(char, "nt_length"),
		.get = py_netr_PasswordHistory_get_nt_length,
		.set = py_netr_PasswordHistory_set_nt_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nt_size"),
		.get = py_netr_PasswordHistory_get_nt_size,
		.set = py_netr_PasswordHistory_set_nt_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nt_flags"),
		.get = py_netr_PasswordHistory_get_nt_flags,
		.set = py_netr_PasswordHistory_set_nt_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "lm_length"),
		.get = py_netr_PasswordHistory_get_lm_length,
		.set = py_netr_PasswordHistory_set_lm_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm_size"),
		.get = py_netr_PasswordHistory_get_lm_size,
		.set = py_netr_PasswordHistory_set_lm_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm_flags"),
		.get = py_netr_PasswordHistory_get_lm_flags,
		.set = py_netr_PasswordHistory_set_lm_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "nt_history"),
		.get = py_netr_PasswordHistory_get_nt_history,
		.set = py_netr_PasswordHistory_set_nt_history,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "lm_history"),
		.get = py_netr_PasswordHistory_get_lm_history,
		.set = py_netr_PasswordHistory_set_lm_history,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_PasswordHistory_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_PasswordHistory, type);
}


static PyTypeObject netr_PasswordHistory_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_PasswordHistory",
	.tp_getset = py_netr_PasswordHistory_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_PasswordHistory_new,
};


static PyObject *py_netr_USER_KEYS2_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = pytalloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = pytalloc_reference_ex(&netr_USER_KEY16_Type, pytalloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_USER_KEYS2_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmpassword");
		return -1;
	}
	PY_CHECK_TYPE(&netr_USER_KEY16_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lmpassword = *(struct netr_USER_KEY16 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_USER_KEYS2_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = pytalloc_reference_ex(&netr_USER_KEY16_Type, pytalloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_USER_KEYS2_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntpassword");
		return -1;
	}
	PY_CHECK_TYPE(&netr_USER_KEY16_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntpassword = *(struct netr_USER_KEY16 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_USER_KEYS2_get_history(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = pytalloc_get_ptr(obj);
	PyObject *py_history;
	py_history = pytalloc_reference_ex(&netr_PasswordHistory_Type, pytalloc_get_mem_ctx(obj), &object->history);
	return py_history;
}

static int py_netr_USER_KEYS2_set_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->history");
		return -1;
	}
	PY_CHECK_TYPE(&netr_PasswordHistory_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->history = *(struct netr_PasswordHistory *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEYS2_getsetters[] = {
	{
		.name = discard_const_p(char, "lmpassword"),
		.get = py_netr_USER_KEYS2_get_lmpassword,
		.set = py_netr_USER_KEYS2_set_lmpassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_USER_KEY16")
	},
	{
		.name = discard_const_p(char, "ntpassword"),
		.get = py_netr_USER_KEYS2_get_ntpassword,
		.set = py_netr_USER_KEYS2_set_ntpassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_USER_KEY16")
	},
	{
		.name = discard_const_p(char, "history"),
		.get = py_netr_USER_KEYS2_get_history,
		.set = py_netr_USER_KEYS2_set_history,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_PasswordHistory")
	},
	{ .name = NULL }
};

static PyObject *py_netr_USER_KEYS2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEYS2, type);
}


static PyTypeObject netr_USER_KEYS2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_USER_KEYS2",
	.tp_getset = py_netr_USER_KEYS2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEYS2_new,
};


static PyObject *py_netr_USER_KEY_UNION_get_keys2(PyObject *obj, void *closure)
{
	struct netr_USER_KEY_UNION *object = pytalloc_get_ptr(obj);
	PyObject *py_keys2;
	py_keys2 = pytalloc_reference_ex(&netr_USER_KEYS2_Type, pytalloc_get_mem_ctx(obj), &object->keys2);
	return py_keys2;
}

static int py_netr_USER_KEY_UNION_set_keys2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY_UNION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->keys2");
		return -1;
	}
	PY_CHECK_TYPE(&netr_USER_KEYS2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->keys2 = *(struct netr_USER_KEYS2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEY_UNION_getsetters[] = {
	{
		.name = discard_const_p(char, "keys2"),
		.get = py_netr_USER_KEY_UNION_get_keys2,
		.set = py_netr_USER_KEY_UNION_set_keys2,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_USER_KEYS2")
	},
	{ .name = NULL }
};

static PyObject *py_netr_USER_KEY_UNION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEY_UNION, type);
}


static PyTypeObject netr_USER_KEY_UNION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_USER_KEY_UNION",
	.tp_getset = py_netr_USER_KEY_UNION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEY_UNION_new,
};


static PyObject *py_netr_USER_KEYS_get_version(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_netr_USER_KEYS_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_USER_KEYS_get_keys(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS *object = pytalloc_get_ptr(obj);
	PyObject *py_keys;
	py_keys = pytalloc_reference_ex(&netr_USER_KEY_UNION_Type, pytalloc_get_mem_ctx(obj), &object->keys);
	return py_keys;
}

static int py_netr_USER_KEYS_set_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->keys");
		return -1;
	}
	PY_CHECK_TYPE(&netr_USER_KEY_UNION_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->keys = *(struct netr_USER_KEY_UNION *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEYS_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_netr_USER_KEYS_get_version,
		.set = py_netr_USER_KEYS_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "keys"),
		.get = py_netr_USER_KEYS_get_keys,
		.set = py_netr_USER_KEYS_set_keys,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_USER_KEY_UNION")
	},
	{ .name = NULL }
};

static PyObject *py_netr_USER_KEYS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEYS, type);
}

static PyObject *py_netr_USER_KEYS_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_USER_KEYS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_USER_KEYS);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_USER_KEYS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_USER_KEYS *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_USER_KEYS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_USER_KEYS);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_USER_KEYS_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_USER_KEYS *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_USER_KEYS, "netr_USER_KEYS", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_USER_KEYS, "netr_USER_KEYS", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_USER_KEYS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_USER_KEYS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_USER_KEYS_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_USER_KEYS_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_USER_KEYS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_USER_KEYS",
	.tp_getset = py_netr_USER_KEYS_getsetters,
	.tp_methods = py_netr_USER_KEYS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEYS_new,
};


static PyObject *py_netr_USER_PRIVATE_INFO_get_SensitiveDataFlag(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_SensitiveDataFlag;
	py_SensitiveDataFlag = PyLong_FromLong((uint16_t)(object->SensitiveDataFlag));
	return py_SensitiveDataFlag;
}

static int py_netr_USER_PRIVATE_INFO_set_SensitiveDataFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SensitiveDataFlag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SensitiveDataFlag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SensitiveDataFlag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_USER_PRIVATE_INFO_get_DataLength(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_DataLength;
	py_DataLength = PyLong_FromUnsignedLongLong((uint32_t)(object->DataLength));
	return py_DataLength;
}

static int py_netr_USER_PRIVATE_INFO_set_DataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DataLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->DataLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->DataLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_USER_PRIVATE_INFO_get_SensitiveData(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_SensitiveData;
	if (object->SensitiveData == NULL) {
		Py_RETURN_NONE;
	}
	if (object->SensitiveData == NULL) {
		py_SensitiveData = Py_None;
		Py_INCREF(py_SensitiveData);
	} else {
		py_SensitiveData = PyList_New(object->DataLength);
		if (py_SensitiveData == NULL) {
			return NULL;
		}
		{
			int SensitiveData_cntr_1;
			for (SensitiveData_cntr_1 = 0; SensitiveData_cntr_1 < (object->DataLength); SensitiveData_cntr_1++) {
				PyObject *py_SensitiveData_1;
				py_SensitiveData_1 = PyLong_FromLong((uint16_t)((object->SensitiveData)[SensitiveData_cntr_1]));
				PyList_SetItem(py_SensitiveData, SensitiveData_cntr_1, py_SensitiveData_1);
			}
		}
	}
	return py_SensitiveData;
}

static int py_netr_USER_PRIVATE_INFO_set_SensitiveData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->SensitiveData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SensitiveData");
		return -1;
	}
	if (value == Py_None) {
		object->SensitiveData = NULL;
	} else {
		object->SensitiveData = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int SensitiveData_cntr_1;
			object->SensitiveData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->SensitiveData, PyList_GET_SIZE(value));
			if (!object->SensitiveData) { return -1; }
			talloc_set_name_const(object->SensitiveData, "ARRAY: object->SensitiveData");
			for (SensitiveData_cntr_1 = 0; SensitiveData_cntr_1 < PyList_GET_SIZE(value); SensitiveData_cntr_1++) {
				if (PyList_GET_ITEM(value, SensitiveData_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->SensitiveData)[SensitiveData_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->SensitiveData)[SensitiveData_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, SensitiveData_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, SensitiveData_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->SensitiveData)[SensitiveData_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_USER_PRIVATE_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "SensitiveDataFlag"),
		.get = py_netr_USER_PRIVATE_INFO_get_SensitiveDataFlag,
		.set = py_netr_USER_PRIVATE_INFO_set_SensitiveDataFlag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "DataLength"),
		.get = py_netr_USER_PRIVATE_INFO_get_DataLength,
		.set = py_netr_USER_PRIVATE_INFO_set_DataLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "SensitiveData"),
		.get = py_netr_USER_PRIVATE_INFO_get_SensitiveData,
		.set = py_netr_USER_PRIVATE_INFO_set_SensitiveData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_USER_PRIVATE_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_PRIVATE_INFO, type);
}


static PyTypeObject netr_USER_PRIVATE_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_USER_PRIVATE_INFO",
	.tp_getset = py_netr_USER_PRIVATE_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_PRIVATE_INFO_new,
};


static PyObject *py_netr_DELTA_USER_get_account_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_DELTA_USER_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_full_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_netr_DELTA_USER_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_netr_DELTA_USER_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_primary_gid(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_netr_DELTA_USER_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_home_directory(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_netr_DELTA_USER_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_directory");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_home_drive(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_netr_DELTA_USER_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_drive");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_script(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_netr_DELTA_USER_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_script");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_USER_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_workstations(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_workstations;
	py_workstations = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstations);
	return py_workstations;
}

static int py_netr_DELTA_USER_set_workstations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstations");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstations = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_logon(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromUnsignedLongLong(object->last_logon);
	return py_last_logon;
}

static int py_netr_DELTA_USER_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_logoff(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromUnsignedLongLong(object->last_logoff);
	return py_last_logoff;
}

static int py_netr_DELTA_USER_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_hours(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_hours;
	py_logon_hours = pytalloc_reference_ex(samr_LogonHours_Type, pytalloc_get_mem_ctx(obj), &object->logon_hours);
	return py_logon_hours;
}

static int py_netr_DELTA_USER_set_logon_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_hours");
		return -1;
	}
	PY_CHECK_TYPE(samr_LogonHours_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_hours = *(struct samr_LogonHours *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_bad_password_count(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyLong_FromLong((uint16_t)(object->bad_password_count));
	return py_bad_password_count;
}

static int py_netr_DELTA_USER_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_password_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_password_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_password_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromLong((uint16_t)(object->logon_count));
	return py_logon_count;
}

static int py_netr_DELTA_USER_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_password_change(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromUnsignedLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_netr_DELTA_USER_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_acct_expiry(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyLong_FromUnsignedLongLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_netr_DELTA_USER_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_expiry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_expiry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_expiry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_acct_flags(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_netr_DELTA_USER_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_DELTA_USER_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmpassword");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lmpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_DELTA_USER_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntpassword");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_nt_password_present(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_password_present;
	py_nt_password_present = PyLong_FromLong((uint16_t)(object->nt_password_present));
	return py_nt_password_present;
}

static int py_netr_DELTA_USER_set_nt_password_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_password_present");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_password_present));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_password_present = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_lm_password_present(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_password_present;
	py_lm_password_present = PyLong_FromLong((uint16_t)(object->lm_password_present));
	return py_lm_password_present;
}

static int py_netr_DELTA_USER_set_lm_password_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_password_present");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm_password_present));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm_password_present = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_password_expired(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyLong_FromLong((uint16_t)(object->password_expired));
	return py_password_expired;
}

static int py_netr_DELTA_USER_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_expired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_expired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_expired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_comment(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	py_comment = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->comment);
	return py_comment;
}

static int py_netr_DELTA_USER_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->comment = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_parameters(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_parameters;
	py_parameters = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->parameters);
	return py_parameters;
}

static int py_netr_DELTA_USER_set_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->parameters");
		return -1;
	}
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->parameters = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_country_code(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_country_code;
	py_country_code = PyLong_FromLong((uint16_t)(object->country_code));
	return py_country_code;
}

static int py_netr_DELTA_USER_set_country_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->country_code");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->country_code));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->country_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_code_page(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_code_page;
	py_code_page = PyLong_FromLong((uint16_t)(object->code_page));
	return py_code_page;
}

static int py_netr_DELTA_USER_set_code_page(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->code_page");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->code_page));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->code_page = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_user_private_info(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_user_private_info;
	py_user_private_info = pytalloc_reference_ex(&netr_USER_PRIVATE_INFO_Type, pytalloc_get_mem_ctx(obj), &object->user_private_info);
	return py_user_private_info;
}

static int py_netr_DELTA_USER_set_user_private_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_private_info");
		return -1;
	}
	PY_CHECK_TYPE(&netr_USER_PRIVATE_INFO_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->user_private_info = *(struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_USER_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_USER_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_profile_path(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_netr_DELTA_USER_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->profile_path");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_USER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_USER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_USER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_USER_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_USER_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_USER_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_USER_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_USER_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_netr_DELTA_USER_get_account_name,
		.set = py_netr_DELTA_USER_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_netr_DELTA_USER_get_full_name,
		.set = py_netr_DELTA_USER_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_netr_DELTA_USER_get_rid,
		.set = py_netr_DELTA_USER_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_netr_DELTA_USER_get_primary_gid,
		.set = py_netr_DELTA_USER_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "home_directory"),
		.get = py_netr_DELTA_USER_get_home_directory,
		.set = py_netr_DELTA_USER_set_home_directory,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_drive"),
		.get = py_netr_DELTA_USER_get_home_drive,
		.set = py_netr_DELTA_USER_set_home_drive,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_script"),
		.get = py_netr_DELTA_USER_get_logon_script,
		.set = py_netr_DELTA_USER_set_logon_script,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_netr_DELTA_USER_get_description,
		.set = py_netr_DELTA_USER_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "workstations"),
		.get = py_netr_DELTA_USER_get_workstations,
		.set = py_netr_DELTA_USER_set_workstations,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "last_logon"),
		.get = py_netr_DELTA_USER_get_last_logon,
		.set = py_netr_DELTA_USER_set_last_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_logoff"),
		.get = py_netr_DELTA_USER_get_last_logoff,
		.set = py_netr_DELTA_USER_set_last_logoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "logon_hours"),
		.get = py_netr_DELTA_USER_get_logon_hours,
		.set = py_netr_DELTA_USER_set_logon_hours,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_LogonHours")
	},
	{
		.name = discard_const_p(char, "bad_password_count"),
		.get = py_netr_DELTA_USER_get_bad_password_count,
		.set = py_netr_DELTA_USER_set_bad_password_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_netr_DELTA_USER_get_logon_count,
		.set = py_netr_DELTA_USER_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "last_password_change"),
		.get = py_netr_DELTA_USER_get_last_password_change,
		.set = py_netr_DELTA_USER_set_last_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "acct_expiry"),
		.get = py_netr_DELTA_USER_get_acct_expiry,
		.set = py_netr_DELTA_USER_set_acct_expiry,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_netr_DELTA_USER_get_acct_flags,
		.set = py_netr_DELTA_USER_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{
		.name = discard_const_p(char, "lmpassword"),
		.get = py_netr_DELTA_USER_get_lmpassword,
		.set = py_netr_DELTA_USER_set_lmpassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{
		.name = discard_const_p(char, "ntpassword"),
		.get = py_netr_DELTA_USER_get_ntpassword,
		.set = py_netr_DELTA_USER_set_ntpassword,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{
		.name = discard_const_p(char, "nt_password_present"),
		.get = py_netr_DELTA_USER_get_nt_password_present,
		.set = py_netr_DELTA_USER_set_nt_password_present,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "lm_password_present"),
		.get = py_netr_DELTA_USER_get_lm_password_present,
		.set = py_netr_DELTA_USER_set_lm_password_present,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "password_expired"),
		.get = py_netr_DELTA_USER_get_password_expired,
		.set = py_netr_DELTA_USER_set_password_expired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_netr_DELTA_USER_get_comment,
		.set = py_netr_DELTA_USER_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "parameters"),
		.get = py_netr_DELTA_USER_get_parameters,
		.set = py_netr_DELTA_USER_set_parameters,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_BinaryString")
	},
	{
		.name = discard_const_p(char, "country_code"),
		.get = py_netr_DELTA_USER_get_country_code,
		.set = py_netr_DELTA_USER_set_country_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "code_page"),
		.get = py_netr_DELTA_USER_get_code_page,
		.set = py_netr_DELTA_USER_set_code_page,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "user_private_info"),
		.get = py_netr_DELTA_USER_get_user_private_info,
		.set = py_netr_DELTA_USER_set_user_private_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_USER_PRIVATE_INFO")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_USER_get_SecurityInformation,
		.set = py_netr_DELTA_USER_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_USER_get_sdbuf,
		.set = py_netr_DELTA_USER_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "profile_path"),
		.get = py_netr_DELTA_USER_get_profile_path,
		.set = py_netr_DELTA_USER_set_profile_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_USER_get_unknown2,
		.set = py_netr_DELTA_USER_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_USER_get_unknown3,
		.set = py_netr_DELTA_USER_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_USER_get_unknown4,
		.set = py_netr_DELTA_USER_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_USER_get_unknown5,
		.set = py_netr_DELTA_USER_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_USER_get_unknown6,
		.set = py_netr_DELTA_USER_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_USER_get_unknown7,
		.set = py_netr_DELTA_USER_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_USER_get_unknown8,
		.set = py_netr_DELTA_USER_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_USER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_USER, type);
}


static PyTypeObject netr_DELTA_USER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_USER",
	.tp_getset = py_netr_DELTA_USER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_USER_new,
};


static PyObject *py_netr_DELTA_DOMAIN_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_DELTA_DOMAIN_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_oem_information(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_oem_information;
	py_oem_information = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->oem_information);
	return py_oem_information;
}

static int py_netr_DELTA_DOMAIN_set_oem_information(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oem_information");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->oem_information = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_force_logoff_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_force_logoff_time;
	py_force_logoff_time = PyLong_FromLongLong(object->force_logoff_time);
	return py_force_logoff_time;
}

static int py_netr_DELTA_DOMAIN_set_force_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->force_logoff_time");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->force_logoff_time));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->force_logoff_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_min_password_length(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_min_password_length;
	py_min_password_length = PyLong_FromLong((uint16_t)(object->min_password_length));
	return py_min_password_length;
}

static int py_netr_DELTA_DOMAIN_set_min_password_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->min_password_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->min_password_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->min_password_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_password_history_length(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_password_history_length;
	py_password_history_length = PyLong_FromLong((uint16_t)(object->password_history_length));
	return py_password_history_length;
}

static int py_netr_DELTA_DOMAIN_set_password_history_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_history_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_history_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_history_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_max_password_age(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_max_password_age;
	py_max_password_age = PyLong_FromLongLong(object->max_password_age);
	return py_max_password_age;
}

static int py_netr_DELTA_DOMAIN_set_max_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_password_age");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->max_password_age));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->max_password_age = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_min_password_age(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_min_password_age;
	py_min_password_age = PyLong_FromLongLong(object->min_password_age);
	return py_min_password_age;
}

static int py_netr_DELTA_DOMAIN_set_min_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->min_password_age");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->min_password_age));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->min_password_age = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_sequence_num(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyLong_FromUnsignedLongLong(object->sequence_num);
	return py_sequence_num;
}

static int py_netr_DELTA_DOMAIN_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sequence_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sequence_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sequence_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_domain_create_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_create_time;
	py_domain_create_time = PyLong_FromUnsignedLongLong(object->domain_create_time);
	return py_domain_create_time;
}

static int py_netr_DELTA_DOMAIN_set_domain_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_create_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_create_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_create_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_DOMAIN_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_DOMAIN_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_account_lockout(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_account_lockout;
	py_account_lockout = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->account_lockout);
	return py_account_lockout;
}

static int py_netr_DELTA_DOMAIN_set_account_lockout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_lockout");
		return -1;
	}
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_lockout = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_DOMAIN_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_DOMAIN_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_DOMAIN_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_logon_to_chgpass(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_to_chgpass;
	py_logon_to_chgpass = PyLong_FromUnsignedLongLong((uint32_t)(object->logon_to_chgpass));
	return py_logon_to_chgpass;
}

static int py_netr_DELTA_DOMAIN_set_logon_to_chgpass(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_to_chgpass");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_to_chgpass));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_to_chgpass = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_DOMAIN_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_DOMAIN_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_DOMAIN_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_DOMAIN_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_netr_DELTA_DOMAIN_get_domain_name,
		.set = py_netr_DELTA_DOMAIN_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "oem_information"),
		.get = py_netr_DELTA_DOMAIN_get_oem_information,
		.set = py_netr_DELTA_DOMAIN_set_oem_information,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "force_logoff_time"),
		.get = py_netr_DELTA_DOMAIN_get_force_logoff_time,
		.set = py_netr_DELTA_DOMAIN_set_force_logoff_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type dlong")
	},
	{
		.name = discard_const_p(char, "min_password_length"),
		.get = py_netr_DELTA_DOMAIN_get_min_password_length,
		.set = py_netr_DELTA_DOMAIN_set_min_password_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password_history_length"),
		.get = py_netr_DELTA_DOMAIN_get_password_history_length,
		.set = py_netr_DELTA_DOMAIN_set_password_history_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_password_age"),
		.get = py_netr_DELTA_DOMAIN_get_max_password_age,
		.set = py_netr_DELTA_DOMAIN_set_max_password_age,
		.doc = discard_const_p(char, "PIDL-generated element of base type dlong")
	},
	{
		.name = discard_const_p(char, "min_password_age"),
		.get = py_netr_DELTA_DOMAIN_get_min_password_age,
		.set = py_netr_DELTA_DOMAIN_set_min_password_age,
		.doc = discard_const_p(char, "PIDL-generated element of base type dlong")
	},
	{
		.name = discard_const_p(char, "sequence_num"),
		.get = py_netr_DELTA_DOMAIN_get_sequence_num,
		.set = py_netr_DELTA_DOMAIN_set_sequence_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type udlong")
	},
	{
		.name = discard_const_p(char, "domain_create_time"),
		.get = py_netr_DELTA_DOMAIN_get_domain_create_time,
		.set = py_netr_DELTA_DOMAIN_set_domain_create_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_DOMAIN_get_SecurityInformation,
		.set = py_netr_DELTA_DOMAIN_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_DOMAIN_get_sdbuf,
		.set = py_netr_DELTA_DOMAIN_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "account_lockout"),
		.get = py_netr_DELTA_DOMAIN_get_account_lockout,
		.set = py_netr_DELTA_DOMAIN_set_account_lockout,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_BinaryString")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_DOMAIN_get_unknown2,
		.set = py_netr_DELTA_DOMAIN_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_DOMAIN_get_unknown3,
		.set = py_netr_DELTA_DOMAIN_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_DOMAIN_get_unknown4,
		.set = py_netr_DELTA_DOMAIN_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_to_chgpass"),
		.get = py_netr_DELTA_DOMAIN_get_logon_to_chgpass,
		.set = py_netr_DELTA_DOMAIN_set_logon_to_chgpass,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_DOMAIN_get_unknown6,
		.set = py_netr_DELTA_DOMAIN_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_DOMAIN_get_unknown7,
		.set = py_netr_DELTA_DOMAIN_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_DOMAIN_get_unknown8,
		.set = py_netr_DELTA_DOMAIN_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_DOMAIN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_DOMAIN, type);
}


static PyTypeObject netr_DELTA_DOMAIN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_DOMAIN",
	.tp_getset = py_netr_DELTA_DOMAIN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_DOMAIN_new,
};


static PyObject *py_netr_DELTA_GROUP_get_group_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_group_name;
	py_group_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->group_name);
	return py_group_name;
}

static int py_netr_DELTA_GROUP_set_group_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->group_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->group_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_netr_DELTA_GROUP_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_attributes(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->attributes));
	return py_attributes;
}

static int py_netr_DELTA_GROUP_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_GROUP_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_GROUP_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_GROUP_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_GROUP_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_GROUP_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_GROUP_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_GROUP_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_GROUP_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_GROUP_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_GROUP_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_GROUP_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_GROUP_getsetters[] = {
	{
		.name = discard_const_p(char, "group_name"),
		.get = py_netr_DELTA_GROUP_get_group_name,
		.set = py_netr_DELTA_GROUP_set_group_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_netr_DELTA_GROUP_get_rid,
		.set = py_netr_DELTA_GROUP_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_netr_DELTA_GROUP_get_attributes,
		.set = py_netr_DELTA_GROUP_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_netr_DELTA_GROUP_get_description,
		.set = py_netr_DELTA_GROUP_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_GROUP_get_SecurityInformation,
		.set = py_netr_DELTA_GROUP_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_GROUP_get_sdbuf,
		.set = py_netr_DELTA_GROUP_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_GROUP_get_unknown1,
		.set = py_netr_DELTA_GROUP_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_GROUP_get_unknown2,
		.set = py_netr_DELTA_GROUP_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_GROUP_get_unknown3,
		.set = py_netr_DELTA_GROUP_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_GROUP_get_unknown4,
		.set = py_netr_DELTA_GROUP_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_GROUP_get_unknown5,
		.set = py_netr_DELTA_GROUP_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_GROUP_get_unknown6,
		.set = py_netr_DELTA_GROUP_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_GROUP_get_unknown7,
		.set = py_netr_DELTA_GROUP_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_GROUP_get_unknown8,
		.set = py_netr_DELTA_GROUP_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_GROUP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_GROUP, type);
}


static PyTypeObject netr_DELTA_GROUP_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_GROUP",
	.tp_getset = py_netr_DELTA_GROUP_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_GROUP_new,
};


static PyObject *py_netr_DELTA_RENAME_get_OldName(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_OldName;
	py_OldName = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->OldName);
	return py_OldName;
}

static int py_netr_DELTA_RENAME_set_OldName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OldName");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->OldName = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_NewName(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_NewName;
	py_NewName = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->NewName);
	return py_NewName;
}

static int py_netr_DELTA_RENAME_set_NewName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NewName");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->NewName = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_RENAME_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_RENAME_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_RENAME_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_RENAME_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_RENAME_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_RENAME_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_RENAME_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_RENAME_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_RENAME_getsetters[] = {
	{
		.name = discard_const_p(char, "OldName"),
		.get = py_netr_DELTA_RENAME_get_OldName,
		.set = py_netr_DELTA_RENAME_set_OldName,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "NewName"),
		.get = py_netr_DELTA_RENAME_get_NewName,
		.set = py_netr_DELTA_RENAME_set_NewName,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_RENAME_get_unknown1,
		.set = py_netr_DELTA_RENAME_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_RENAME_get_unknown2,
		.set = py_netr_DELTA_RENAME_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_RENAME_get_unknown3,
		.set = py_netr_DELTA_RENAME_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_RENAME_get_unknown4,
		.set = py_netr_DELTA_RENAME_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_RENAME_get_unknown5,
		.set = py_netr_DELTA_RENAME_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_RENAME_get_unknown6,
		.set = py_netr_DELTA_RENAME_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_RENAME_get_unknown7,
		.set = py_netr_DELTA_RENAME_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_RENAME_get_unknown8,
		.set = py_netr_DELTA_RENAME_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_RENAME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_RENAME, type);
}


static PyTypeObject netr_DELTA_RENAME_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_RENAME",
	.tp_getset = py_netr_DELTA_RENAME_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_RENAME_new,
};


static PyObject *py_netr_DELTA_GROUP_MEMBER_get_rids(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->rids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->rids == NULL) {
		py_rids = Py_None;
		Py_INCREF(py_rids);
	} else {
		py_rids = PyList_New(object->num_rids);
		if (py_rids == NULL) {
			return NULL;
		}
		{
			int rids_cntr_1;
			for (rids_cntr_1 = 0; rids_cntr_1 < (object->num_rids); rids_cntr_1++) {
				PyObject *py_rids_1;
				py_rids_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->rids)[rids_cntr_1]));
				PyList_SetItem(py_rids, rids_cntr_1, py_rids_1);
			}
		}
	}
	return py_rids;
}

static int py_netr_DELTA_GROUP_MEMBER_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rids");
		return -1;
	}
	if (value == Py_None) {
		object->rids = NULL;
	} else {
		object->rids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int rids_cntr_1;
			object->rids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rids, PyList_GET_SIZE(value));
			if (!object->rids) { return -1; }
			talloc_set_name_const(object->rids, "ARRAY: object->rids");
			for (rids_cntr_1 = 0; rids_cntr_1 < PyList_GET_SIZE(value); rids_cntr_1++) {
				if (PyList_GET_ITEM(value, rids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->rids)[rids_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->rids)[rids_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, rids_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, rids_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->rids)[rids_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_attribs(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_attribs;
	if (object->attribs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->attribs == NULL) {
		py_attribs = Py_None;
		Py_INCREF(py_attribs);
	} else {
		py_attribs = PyList_New(object->num_rids);
		if (py_attribs == NULL) {
			return NULL;
		}
		{
			int attribs_cntr_1;
			for (attribs_cntr_1 = 0; attribs_cntr_1 < (object->num_rids); attribs_cntr_1++) {
				PyObject *py_attribs_1;
				py_attribs_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->attribs)[attribs_cntr_1]));
				PyList_SetItem(py_attribs, attribs_cntr_1, py_attribs_1);
			}
		}
	}
	return py_attribs;
}

static int py_netr_DELTA_GROUP_MEMBER_set_attribs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->attribs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attribs");
		return -1;
	}
	if (value == Py_None) {
		object->attribs = NULL;
	} else {
		object->attribs = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int attribs_cntr_1;
			object->attribs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->attribs, PyList_GET_SIZE(value));
			if (!object->attribs) { return -1; }
			talloc_set_name_const(object->attribs, "ARRAY: object->attribs");
			for (attribs_cntr_1 = 0; attribs_cntr_1 < PyList_GET_SIZE(value); attribs_cntr_1++) {
				if (PyList_GET_ITEM(value, attribs_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->attribs)[attribs_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->attribs)[attribs_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, attribs_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, attribs_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->attribs)[attribs_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_num_rids(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_num_rids;
	py_num_rids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_rids));
	return py_num_rids;
}

static int py_netr_DELTA_GROUP_MEMBER_set_num_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_rids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_rids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_rids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown1));
	return py_unknown1;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown2));
	return py_unknown2;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown3));
	return py_unknown3;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown4));
	return py_unknown4;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_GROUP_MEMBER_getsetters[] = {
	{
		.name = discard_const_p(char, "rids"),
		.get = py_netr_DELTA_GROUP_MEMBER_get_rids,
		.set = py_netr_DELTA_GROUP_MEMBER_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attribs"),
		.get = py_netr_DELTA_GROUP_MEMBER_get_attribs,
		.set = py_netr_DELTA_GROUP_MEMBER_set_attribs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_rids"),
		.get = py_netr_DELTA_GROUP_MEMBER_get_num_rids,
		.set = py_netr_DELTA_GROUP_MEMBER_set_num_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_GROUP_MEMBER_get_unknown1,
		.set = py_netr_DELTA_GROUP_MEMBER_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_GROUP_MEMBER_get_unknown2,
		.set = py_netr_DELTA_GROUP_MEMBER_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_GROUP_MEMBER_get_unknown3,
		.set = py_netr_DELTA_GROUP_MEMBER_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_GROUP_MEMBER_get_unknown4,
		.set = py_netr_DELTA_GROUP_MEMBER_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_GROUP_MEMBER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_GROUP_MEMBER, type);
}


static PyTypeObject netr_DELTA_GROUP_MEMBER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_GROUP_MEMBER",
	.tp_getset = py_netr_DELTA_GROUP_MEMBER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_GROUP_MEMBER_new,
};


static PyObject *py_netr_DELTA_ALIAS_get_alias_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_alias_name;
	py_alias_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->alias_name);
	return py_alias_name;
}

static int py_netr_DELTA_ALIAS_set_alias_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alias_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->alias_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_netr_DELTA_ALIAS_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_ALIAS_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_ALIAS_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_ALIAS_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ALIAS_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ALIAS_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ALIAS_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_ALIAS_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_ALIAS_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_ALIAS_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_ALIAS_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ALIAS_getsetters[] = {
	{
		.name = discard_const_p(char, "alias_name"),
		.get = py_netr_DELTA_ALIAS_get_alias_name,
		.set = py_netr_DELTA_ALIAS_set_alias_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_netr_DELTA_ALIAS_get_rid,
		.set = py_netr_DELTA_ALIAS_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_ALIAS_get_SecurityInformation,
		.set = py_netr_DELTA_ALIAS_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_ALIAS_get_sdbuf,
		.set = py_netr_DELTA_ALIAS_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_netr_DELTA_ALIAS_get_description,
		.set = py_netr_DELTA_ALIAS_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_ALIAS_get_unknown2,
		.set = py_netr_DELTA_ALIAS_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_ALIAS_get_unknown3,
		.set = py_netr_DELTA_ALIAS_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_ALIAS_get_unknown4,
		.set = py_netr_DELTA_ALIAS_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_ALIAS_get_unknown5,
		.set = py_netr_DELTA_ALIAS_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_ALIAS_get_unknown6,
		.set = py_netr_DELTA_ALIAS_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_ALIAS_get_unknown7,
		.set = py_netr_DELTA_ALIAS_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_ALIAS_get_unknown8,
		.set = py_netr_DELTA_ALIAS_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_ALIAS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ALIAS, type);
}


static PyTypeObject netr_DELTA_ALIAS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_ALIAS",
	.tp_getset = py_netr_DELTA_ALIAS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ALIAS_new,
};


static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_sids(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = pytalloc_reference_ex(lsa_SidArray_Type, pytalloc_get_mem_ctx(obj), &object->sids);
	return py_sids;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sids");
		return -1;
	}
	PY_CHECK_TYPE(lsa_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sids = *(struct lsa_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown1));
	return py_unknown1;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown2));
	return py_unknown2;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown3));
	return py_unknown3;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown4));
	return py_unknown4;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ALIAS_MEMBER_getsetters[] = {
	{
		.name = discard_const_p(char, "sids"),
		.get = py_netr_DELTA_ALIAS_MEMBER_get_sids,
		.set = py_netr_DELTA_ALIAS_MEMBER_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidArray")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_ALIAS_MEMBER_get_unknown1,
		.set = py_netr_DELTA_ALIAS_MEMBER_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_ALIAS_MEMBER_get_unknown2,
		.set = py_netr_DELTA_ALIAS_MEMBER_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_ALIAS_MEMBER_get_unknown3,
		.set = py_netr_DELTA_ALIAS_MEMBER_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_ALIAS_MEMBER_get_unknown4,
		.set = py_netr_DELTA_ALIAS_MEMBER_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_ALIAS_MEMBER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ALIAS_MEMBER, type);
}


static PyTypeObject netr_DELTA_ALIAS_MEMBER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_ALIAS_MEMBER",
	.tp_getset = py_netr_DELTA_ALIAS_MEMBER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ALIAS_MEMBER_new,
};


static PyObject *py_netr_QUOTA_LIMITS_get_pagedpoollimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(obj);
	PyObject *py_pagedpoollimit;
	py_pagedpoollimit = PyLong_FromUnsignedLongLong((uint32_t)(object->pagedpoollimit));
	return py_pagedpoollimit;
}

static int py_netr_QUOTA_LIMITS_set_pagedpoollimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pagedpoollimit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pagedpoollimit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pagedpoollimit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_nonpagedpoollimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(obj);
	PyObject *py_nonpagedpoollimit;
	py_nonpagedpoollimit = PyLong_FromUnsignedLongLong((uint32_t)(object->nonpagedpoollimit));
	return py_nonpagedpoollimit;
}

static int py_netr_QUOTA_LIMITS_set_nonpagedpoollimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nonpagedpoollimit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nonpagedpoollimit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nonpagedpoollimit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_minimumworkingsetsize(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(obj);
	PyObject *py_minimumworkingsetsize;
	py_minimumworkingsetsize = PyLong_FromUnsignedLongLong((uint32_t)(object->minimumworkingsetsize));
	return py_minimumworkingsetsize;
}

static int py_netr_QUOTA_LIMITS_set_minimumworkingsetsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->minimumworkingsetsize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minimumworkingsetsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minimumworkingsetsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_maximumworkingsetsize(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(obj);
	PyObject *py_maximumworkingsetsize;
	py_maximumworkingsetsize = PyLong_FromUnsignedLongLong((uint32_t)(object->maximumworkingsetsize));
	return py_maximumworkingsetsize;
}

static int py_netr_QUOTA_LIMITS_set_maximumworkingsetsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maximumworkingsetsize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maximumworkingsetsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maximumworkingsetsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_pagefilelimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(obj);
	PyObject *py_pagefilelimit;
	py_pagefilelimit = PyLong_FromUnsignedLongLong((uint32_t)(object->pagefilelimit));
	return py_pagefilelimit;
}

static int py_netr_QUOTA_LIMITS_set_pagefilelimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pagefilelimit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pagefilelimit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pagefilelimit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_timelimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(obj);
	PyObject *py_timelimit;
	py_timelimit = PyLong_FromUnsignedLongLong(object->timelimit);
	return py_timelimit;
}

static int py_netr_QUOTA_LIMITS_set_timelimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timelimit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timelimit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timelimit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_QUOTA_LIMITS_getsetters[] = {
	{
		.name = discard_const_p(char, "pagedpoollimit"),
		.get = py_netr_QUOTA_LIMITS_get_pagedpoollimit,
		.set = py_netr_QUOTA_LIMITS_set_pagedpoollimit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "nonpagedpoollimit"),
		.get = py_netr_QUOTA_LIMITS_get_nonpagedpoollimit,
		.set = py_netr_QUOTA_LIMITS_set_nonpagedpoollimit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minimumworkingsetsize"),
		.get = py_netr_QUOTA_LIMITS_get_minimumworkingsetsize,
		.set = py_netr_QUOTA_LIMITS_set_minimumworkingsetsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maximumworkingsetsize"),
		.get = py_netr_QUOTA_LIMITS_get_maximumworkingsetsize,
		.set = py_netr_QUOTA_LIMITS_set_maximumworkingsetsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pagefilelimit"),
		.get = py_netr_QUOTA_LIMITS_get_pagefilelimit,
		.set = py_netr_QUOTA_LIMITS_set_pagefilelimit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "timelimit"),
		.get = py_netr_QUOTA_LIMITS_get_timelimit,
		.set = py_netr_QUOTA_LIMITS_set_timelimit,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_netr_QUOTA_LIMITS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_QUOTA_LIMITS, type);
}


static PyTypeObject netr_QUOTA_LIMITS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_QUOTA_LIMITS",
	.tp_getset = py_netr_QUOTA_LIMITS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_QUOTA_LIMITS_new,
};


static PyObject *py_netr_DELTA_POLICY_get_maxlogsize(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_maxlogsize;
	py_maxlogsize = PyLong_FromUnsignedLongLong((uint32_t)(object->maxlogsize));
	return py_maxlogsize;
}

static int py_netr_DELTA_POLICY_set_maxlogsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxlogsize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxlogsize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxlogsize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_auditretentionperiod(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_auditretentionperiod;
	py_auditretentionperiod = PyLong_FromUnsignedLongLong(object->auditretentionperiod);
	return py_auditretentionperiod;
}

static int py_netr_DELTA_POLICY_set_auditretentionperiod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auditretentionperiod");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auditretentionperiod));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auditretentionperiod = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_auditingmode(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_auditingmode;
	py_auditingmode = PyLong_FromLong((uint16_t)(object->auditingmode));
	return py_auditingmode;
}

static int py_netr_DELTA_POLICY_set_auditingmode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auditingmode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auditingmode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auditingmode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_maxauditeventcount(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_maxauditeventcount;
	py_maxauditeventcount = PyLong_FromUnsignedLongLong((uint32_t)(object->maxauditeventcount));
	return py_maxauditeventcount;
}

static int py_netr_DELTA_POLICY_set_maxauditeventcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxauditeventcount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxauditeventcount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxauditeventcount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_eventauditoptions(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_eventauditoptions;
	if (object->eventauditoptions == NULL) {
		Py_RETURN_NONE;
	}
	if (object->eventauditoptions == NULL) {
		py_eventauditoptions = Py_None;
		Py_INCREF(py_eventauditoptions);
	} else {
		py_eventauditoptions = PyList_New(object->maxauditeventcount + 1);
		if (py_eventauditoptions == NULL) {
			return NULL;
		}
		{
			int eventauditoptions_cntr_1;
			for (eventauditoptions_cntr_1 = 0; eventauditoptions_cntr_1 < (object->maxauditeventcount + 1); eventauditoptions_cntr_1++) {
				PyObject *py_eventauditoptions_1;
				py_eventauditoptions_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->eventauditoptions)[eventauditoptions_cntr_1]));
				PyList_SetItem(py_eventauditoptions, eventauditoptions_cntr_1, py_eventauditoptions_1);
			}
		}
	}
	return py_eventauditoptions;
}

static int py_netr_DELTA_POLICY_set_eventauditoptions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->eventauditoptions));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->eventauditoptions");
		return -1;
	}
	if (value == Py_None) {
		object->eventauditoptions = NULL;
	} else {
		object->eventauditoptions = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int eventauditoptions_cntr_1;
			object->eventauditoptions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->eventauditoptions, PyList_GET_SIZE(value));
			if (!object->eventauditoptions) { return -1; }
			talloc_set_name_const(object->eventauditoptions, "ARRAY: object->eventauditoptions");
			for (eventauditoptions_cntr_1 = 0; eventauditoptions_cntr_1 < PyList_GET_SIZE(value); eventauditoptions_cntr_1++) {
				if (PyList_GET_ITEM(value, eventauditoptions_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->eventauditoptions)[eventauditoptions_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->eventauditoptions)[eventauditoptions_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, eventauditoptions_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, eventauditoptions_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->eventauditoptions)[eventauditoptions_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_primary_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_domain_name;
	py_primary_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->primary_domain_name);
	return py_primary_domain_name;
}

static int py_netr_DELTA_POLICY_set_primary_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_domain_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->primary_domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sid(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_netr_DELTA_POLICY_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_quota_limits(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_quota_limits;
	py_quota_limits = pytalloc_reference_ex(&netr_QUOTA_LIMITS_Type, pytalloc_get_mem_ctx(obj), &object->quota_limits);
	return py_quota_limits;
}

static int py_netr_DELTA_POLICY_set_quota_limits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->quota_limits");
		return -1;
	}
	PY_CHECK_TYPE(&netr_QUOTA_LIMITS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->quota_limits = *(struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sequence_num(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyLong_FromUnsignedLongLong(object->sequence_num);
	return py_sequence_num;
}

static int py_netr_DELTA_POLICY_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sequence_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sequence_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sequence_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_db_create_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_db_create_time;
	py_db_create_time = PyLong_FromUnsignedLongLong(object->db_create_time);
	return py_db_create_time;
}

static int py_netr_DELTA_POLICY_set_db_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_create_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->db_create_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->db_create_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_POLICY_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_POLICY_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_POLICY_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_POLICY_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_POLICY_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_POLICY_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_POLICY_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_POLICY_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_POLICY_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_POLICY_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_POLICY_getsetters[] = {
	{
		.name = discard_const_p(char, "maxlogsize"),
		.get = py_netr_DELTA_POLICY_get_maxlogsize,
		.set = py_netr_DELTA_POLICY_set_maxlogsize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "auditretentionperiod"),
		.get = py_netr_DELTA_POLICY_get_auditretentionperiod,
		.set = py_netr_DELTA_POLICY_set_auditretentionperiod,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "auditingmode"),
		.get = py_netr_DELTA_POLICY_get_auditingmode,
		.set = py_netr_DELTA_POLICY_set_auditingmode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "maxauditeventcount"),
		.get = py_netr_DELTA_POLICY_get_maxauditeventcount,
		.set = py_netr_DELTA_POLICY_set_maxauditeventcount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "eventauditoptions"),
		.get = py_netr_DELTA_POLICY_get_eventauditoptions,
		.set = py_netr_DELTA_POLICY_set_eventauditoptions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "primary_domain_name"),
		.get = py_netr_DELTA_POLICY_get_primary_domain_name,
		.set = py_netr_DELTA_POLICY_set_primary_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_netr_DELTA_POLICY_get_sid,
		.set = py_netr_DELTA_POLICY_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "quota_limits"),
		.get = py_netr_DELTA_POLICY_get_quota_limits,
		.set = py_netr_DELTA_POLICY_set_quota_limits,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_QUOTA_LIMITS")
	},
	{
		.name = discard_const_p(char, "sequence_num"),
		.get = py_netr_DELTA_POLICY_get_sequence_num,
		.set = py_netr_DELTA_POLICY_set_sequence_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type udlong")
	},
	{
		.name = discard_const_p(char, "db_create_time"),
		.get = py_netr_DELTA_POLICY_get_db_create_time,
		.set = py_netr_DELTA_POLICY_set_db_create_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_POLICY_get_SecurityInformation,
		.set = py_netr_DELTA_POLICY_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_POLICY_get_sdbuf,
		.set = py_netr_DELTA_POLICY_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_POLICY_get_unknown1,
		.set = py_netr_DELTA_POLICY_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_POLICY_get_unknown2,
		.set = py_netr_DELTA_POLICY_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_POLICY_get_unknown3,
		.set = py_netr_DELTA_POLICY_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_POLICY_get_unknown4,
		.set = py_netr_DELTA_POLICY_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_POLICY_get_unknown5,
		.set = py_netr_DELTA_POLICY_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_POLICY_get_unknown6,
		.set = py_netr_DELTA_POLICY_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_POLICY_get_unknown7,
		.set = py_netr_DELTA_POLICY_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_POLICY_get_unknown8,
		.set = py_netr_DELTA_POLICY_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_POLICY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_POLICY, type);
}


static PyTypeObject netr_DELTA_POLICY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_POLICY",
	.tp_getset = py_netr_DELTA_POLICY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_POLICY_new,
};


static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_num_controllers(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_num_controllers;
	py_num_controllers = PyLong_FromUnsignedLongLong((uint32_t)(object->num_controllers));
	return py_num_controllers;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_num_controllers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_controllers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_controllers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_controllers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_controller_names(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_controller_names;
	if (object->controller_names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->controller_names == NULL) {
		py_controller_names = Py_None;
		Py_INCREF(py_controller_names);
	} else {
		py_controller_names = PyList_New(object->num_controllers);
		if (py_controller_names == NULL) {
			return NULL;
		}
		{
			int controller_names_cntr_1;
			for (controller_names_cntr_1 = 0; controller_names_cntr_1 < (object->num_controllers); controller_names_cntr_1++) {
				PyObject *py_controller_names_1;
				py_controller_names_1 = pytalloc_reference_ex(lsa_String_Type, object->controller_names, &(object->controller_names)[controller_names_cntr_1]);
				PyList_SetItem(py_controller_names, controller_names_cntr_1, py_controller_names_1);
			}
		}
	}
	return py_controller_names;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_controller_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->controller_names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->controller_names");
		return -1;
	}
	if (value == Py_None) {
		object->controller_names = NULL;
	} else {
		object->controller_names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int controller_names_cntr_1;
			object->controller_names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->controller_names, PyList_GET_SIZE(value));
			if (!object->controller_names) { return -1; }
			talloc_set_name_const(object->controller_names, "ARRAY: object->controller_names");
			for (controller_names_cntr_1 = 0; controller_names_cntr_1 < PyList_GET_SIZE(value); controller_names_cntr_1++) {
				if (PyList_GET_ITEM(value, controller_names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->controller_names)[controller_names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, controller_names_cntr_1), return -1;);
				if (talloc_reference(object->controller_names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, controller_names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->controller_names)[controller_names_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, controller_names_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_posix_offset(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = PyLong_FromUnsignedLongLong((uint32_t)(object->posix_offset));
	return py_posix_offset;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->posix_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->posix_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->posix_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_TRUSTED_DOMAIN_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_domain_name,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "num_controllers"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_num_controllers,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_num_controllers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "controller_names"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_controller_names,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_controller_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_SecurityInformation,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_sdbuf,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_unknown1,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_unknown2,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_unknown3,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_unknown4,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "posix_offset"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_posix_offset,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_posix_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_unknown6,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_unknown7,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_TRUSTED_DOMAIN_get_unknown8,
		.set = py_netr_DELTA_TRUSTED_DOMAIN_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_TRUSTED_DOMAIN, type);
}


static PyTypeObject netr_DELTA_TRUSTED_DOMAIN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_TRUSTED_DOMAIN",
	.tp_getset = py_netr_DELTA_TRUSTED_DOMAIN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_TRUSTED_DOMAIN_new,
};


static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_entries(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_privilege_entries;
	py_privilege_entries = PyLong_FromUnsignedLongLong((uint32_t)(object->privilege_entries));
	return py_privilege_entries;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->privilege_entries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->privilege_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->privilege_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_control(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_privilege_control;
	py_privilege_control = PyLong_FromUnsignedLongLong((uint32_t)(object->privilege_control));
	return py_privilege_control;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->privilege_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->privilege_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->privilege_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_attrib(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_privilege_attrib;
	if (object->privilege_attrib == NULL) {
		Py_RETURN_NONE;
	}
	if (object->privilege_attrib == NULL) {
		py_privilege_attrib = Py_None;
		Py_INCREF(py_privilege_attrib);
	} else {
		py_privilege_attrib = PyList_New(object->privilege_entries);
		if (py_privilege_attrib == NULL) {
			return NULL;
		}
		{
			int privilege_attrib_cntr_1;
			for (privilege_attrib_cntr_1 = 0; privilege_attrib_cntr_1 < (object->privilege_entries); privilege_attrib_cntr_1++) {
				PyObject *py_privilege_attrib_1;
				py_privilege_attrib_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->privilege_attrib)[privilege_attrib_cntr_1]));
				PyList_SetItem(py_privilege_attrib, privilege_attrib_cntr_1, py_privilege_attrib_1);
			}
		}
	}
	return py_privilege_attrib;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_attrib(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->privilege_attrib));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->privilege_attrib");
		return -1;
	}
	if (value == Py_None) {
		object->privilege_attrib = NULL;
	} else {
		object->privilege_attrib = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privilege_attrib_cntr_1;
			object->privilege_attrib = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->privilege_attrib, PyList_GET_SIZE(value));
			if (!object->privilege_attrib) { return -1; }
			talloc_set_name_const(object->privilege_attrib, "ARRAY: object->privilege_attrib");
			for (privilege_attrib_cntr_1 = 0; privilege_attrib_cntr_1 < PyList_GET_SIZE(value); privilege_attrib_cntr_1++) {
				if (PyList_GET_ITEM(value, privilege_attrib_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->privilege_attrib)[privilege_attrib_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->privilege_attrib)[privilege_attrib_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, privilege_attrib_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, privilege_attrib_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->privilege_attrib)[privilege_attrib_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_privilege_name;
	if (object->privilege_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->privilege_name == NULL) {
		py_privilege_name = Py_None;
		Py_INCREF(py_privilege_name);
	} else {
		py_privilege_name = PyList_New(object->privilege_entries);
		if (py_privilege_name == NULL) {
			return NULL;
		}
		{
			int privilege_name_cntr_1;
			for (privilege_name_cntr_1 = 0; privilege_name_cntr_1 < (object->privilege_entries); privilege_name_cntr_1++) {
				PyObject *py_privilege_name_1;
				py_privilege_name_1 = pytalloc_reference_ex(lsa_String_Type, object->privilege_name, &(object->privilege_name)[privilege_name_cntr_1]);
				PyList_SetItem(py_privilege_name, privilege_name_cntr_1, py_privilege_name_1);
			}
		}
	}
	return py_privilege_name;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->privilege_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->privilege_name");
		return -1;
	}
	if (value == Py_None) {
		object->privilege_name = NULL;
	} else {
		object->privilege_name = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privilege_name_cntr_1;
			object->privilege_name = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->privilege_name, PyList_GET_SIZE(value));
			if (!object->privilege_name) { return -1; }
			talloc_set_name_const(object->privilege_name, "ARRAY: object->privilege_name");
			for (privilege_name_cntr_1 = 0; privilege_name_cntr_1 < PyList_GET_SIZE(value); privilege_name_cntr_1++) {
				if (PyList_GET_ITEM(value, privilege_name_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->privilege_name)[privilege_name_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, privilege_name_cntr_1), return -1;);
				if (talloc_reference(object->privilege_name, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, privilege_name_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->privilege_name)[privilege_name_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, privilege_name_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_quotalimits(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_quotalimits;
	py_quotalimits = pytalloc_reference_ex(&netr_QUOTA_LIMITS_Type, pytalloc_get_mem_ctx(obj), &object->quotalimits);
	return py_quotalimits;
}

static int py_netr_DELTA_ACCOUNT_set_quotalimits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->quotalimits");
		return -1;
	}
	PY_CHECK_TYPE(&netr_QUOTA_LIMITS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->quotalimits = *(struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_system_flags(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_system_flags;
	py_system_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->system_flags));
	return py_system_flags;
}

static int py_netr_DELTA_ACCOUNT_set_system_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->system_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->system_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->system_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_ACCOUNT_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_ACCOUNT_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_ACCOUNT_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ACCOUNT_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ACCOUNT_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ACCOUNT_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_ACCOUNT_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_ACCOUNT_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_ACCOUNT_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_ACCOUNT_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ACCOUNT_getsetters[] = {
	{
		.name = discard_const_p(char, "privilege_entries"),
		.get = py_netr_DELTA_ACCOUNT_get_privilege_entries,
		.set = py_netr_DELTA_ACCOUNT_set_privilege_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "privilege_control"),
		.get = py_netr_DELTA_ACCOUNT_get_privilege_control,
		.set = py_netr_DELTA_ACCOUNT_set_privilege_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "privilege_attrib"),
		.get = py_netr_DELTA_ACCOUNT_get_privilege_attrib,
		.set = py_netr_DELTA_ACCOUNT_set_privilege_attrib,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "privilege_name"),
		.get = py_netr_DELTA_ACCOUNT_get_privilege_name,
		.set = py_netr_DELTA_ACCOUNT_set_privilege_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "quotalimits"),
		.get = py_netr_DELTA_ACCOUNT_get_quotalimits,
		.set = py_netr_DELTA_ACCOUNT_set_quotalimits,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_QUOTA_LIMITS")
	},
	{
		.name = discard_const_p(char, "system_flags"),
		.get = py_netr_DELTA_ACCOUNT_get_system_flags,
		.set = py_netr_DELTA_ACCOUNT_set_system_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_ACCOUNT_get_SecurityInformation,
		.set = py_netr_DELTA_ACCOUNT_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_ACCOUNT_get_sdbuf,
		.set = py_netr_DELTA_ACCOUNT_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown1,
		.set = py_netr_DELTA_ACCOUNT_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown2,
		.set = py_netr_DELTA_ACCOUNT_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown3,
		.set = py_netr_DELTA_ACCOUNT_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown4,
		.set = py_netr_DELTA_ACCOUNT_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown5,
		.set = py_netr_DELTA_ACCOUNT_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown6,
		.set = py_netr_DELTA_ACCOUNT_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown7,
		.set = py_netr_DELTA_ACCOUNT_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_ACCOUNT_get_unknown8,
		.set = py_netr_DELTA_ACCOUNT_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_ACCOUNT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ACCOUNT, type);
}


static PyTypeObject netr_DELTA_ACCOUNT_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_ACCOUNT",
	.tp_getset = py_netr_DELTA_ACCOUNT_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ACCOUNT_new,
};


static PyObject *py_netr_CIPHER_VALUE_get_len(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromUnsignedLongLong((uint32_t)(object->len));
	return py_len;
}

static int py_netr_CIPHER_VALUE_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_CIPHER_VALUE_get_maxlen(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = pytalloc_get_ptr(obj);
	PyObject *py_maxlen;
	py_maxlen = PyLong_FromUnsignedLongLong((uint32_t)(object->maxlen));
	return py_maxlen;
}

static int py_netr_CIPHER_VALUE_set_maxlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->maxlen");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->maxlen));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->maxlen = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_CIPHER_VALUE_get_cipher_data(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = pytalloc_get_ptr(obj);
	PyObject *py_cipher_data;
	if (object->cipher_data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->cipher_data == NULL) {
		py_cipher_data = Py_None;
		Py_INCREF(py_cipher_data);
	} else {
		py_cipher_data = PyList_New(object->len);
		if (py_cipher_data == NULL) {
			return NULL;
		}
		{
			int cipher_data_cntr_1;
			for (cipher_data_cntr_1 = 0; cipher_data_cntr_1 < (object->len); cipher_data_cntr_1++) {
				PyObject *py_cipher_data_1;
				py_cipher_data_1 = PyLong_FromLong((uint16_t)((object->cipher_data)[cipher_data_cntr_1]));
				PyList_SetItem(py_cipher_data, cipher_data_cntr_1, py_cipher_data_1);
			}
		}
	}
	return py_cipher_data;
}

static int py_netr_CIPHER_VALUE_set_cipher_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->cipher_data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cipher_data");
		return -1;
	}
	if (value == Py_None) {
		object->cipher_data = NULL;
	} else {
		object->cipher_data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int cipher_data_cntr_1;
			object->cipher_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cipher_data, PyList_GET_SIZE(value));
			if (!object->cipher_data) { return -1; }
			talloc_set_name_const(object->cipher_data, "ARRAY: object->cipher_data");
			for (cipher_data_cntr_1 = 0; cipher_data_cntr_1 < PyList_GET_SIZE(value); cipher_data_cntr_1++) {
				if (PyList_GET_ITEM(value, cipher_data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->cipher_data)[cipher_data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->cipher_data)[cipher_data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, cipher_data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, cipher_data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->cipher_data)[cipher_data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_CIPHER_VALUE_getsetters[] = {
	{
		.name = discard_const_p(char, "len"),
		.get = py_netr_CIPHER_VALUE_get_len,
		.set = py_netr_CIPHER_VALUE_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "maxlen"),
		.get = py_netr_CIPHER_VALUE_get_maxlen,
		.set = py_netr_CIPHER_VALUE_set_maxlen,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cipher_data"),
		.get = py_netr_CIPHER_VALUE_get_cipher_data,
		.set = py_netr_CIPHER_VALUE_set_cipher_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_CIPHER_VALUE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_CIPHER_VALUE, type);
}


static PyTypeObject netr_CIPHER_VALUE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_CIPHER_VALUE",
	.tp_getset = py_netr_CIPHER_VALUE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_CIPHER_VALUE_new,
};


static PyObject *py_netr_DELTA_SECRET_get_current_cipher(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_current_cipher;
	py_current_cipher = pytalloc_reference_ex(&netr_CIPHER_VALUE_Type, pytalloc_get_mem_ctx(obj), &object->current_cipher);
	return py_current_cipher;
}

static int py_netr_DELTA_SECRET_set_current_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->current_cipher");
		return -1;
	}
	PY_CHECK_TYPE(&netr_CIPHER_VALUE_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->current_cipher = *(struct netr_CIPHER_VALUE *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_current_cipher_set_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_current_cipher_set_time;
	py_current_cipher_set_time = PyLong_FromUnsignedLongLong(object->current_cipher_set_time);
	return py_current_cipher_set_time;
}

static int py_netr_DELTA_SECRET_set_current_cipher_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->current_cipher_set_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->current_cipher_set_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->current_cipher_set_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_old_cipher(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_old_cipher;
	py_old_cipher = pytalloc_reference_ex(&netr_CIPHER_VALUE_Type, pytalloc_get_mem_ctx(obj), &object->old_cipher);
	return py_old_cipher;
}

static int py_netr_DELTA_SECRET_set_old_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->old_cipher");
		return -1;
	}
	PY_CHECK_TYPE(&netr_CIPHER_VALUE_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->old_cipher = *(struct netr_CIPHER_VALUE *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_old_cipher_set_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_old_cipher_set_time;
	py_old_cipher_set_time = PyLong_FromUnsignedLongLong(object->old_cipher_set_time);
	return py_old_cipher_set_time;
}

static int py_netr_DELTA_SECRET_set_old_cipher_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->old_cipher_set_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->old_cipher_set_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->old_cipher_set_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyLong_FromUnsignedLongLong((uint32_t)(object->SecurityInformation));
	return py_SecurityInformation;
}

static int py_netr_DELTA_SECRET_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SecurityInformation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SecurityInformation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SecurityInformation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_SECRET_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sdbuf");
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_SECRET_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_SECRET_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_SECRET_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_SECRET_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_DELTA_SECRET_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown6));
	return py_unknown6;
}

static int py_netr_DELTA_SECRET_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown7));
	return py_unknown7;
}

static int py_netr_DELTA_SECRET_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown8));
	return py_unknown8;
}

static int py_netr_DELTA_SECRET_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_SECRET_getsetters[] = {
	{
		.name = discard_const_p(char, "current_cipher"),
		.get = py_netr_DELTA_SECRET_get_current_cipher,
		.set = py_netr_DELTA_SECRET_set_current_cipher,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_CIPHER_VALUE")
	},
	{
		.name = discard_const_p(char, "current_cipher_set_time"),
		.get = py_netr_DELTA_SECRET_get_current_cipher_set_time,
		.set = py_netr_DELTA_SECRET_set_current_cipher_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "old_cipher"),
		.get = py_netr_DELTA_SECRET_get_old_cipher,
		.set = py_netr_DELTA_SECRET_set_old_cipher,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_CIPHER_VALUE")
	},
	{
		.name = discard_const_p(char, "old_cipher_set_time"),
		.get = py_netr_DELTA_SECRET_get_old_cipher_set_time,
		.set = py_netr_DELTA_SECRET_set_old_cipher_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "SecurityInformation"),
		.get = py_netr_DELTA_SECRET_get_SecurityInformation,
		.set = py_netr_DELTA_SECRET_set_SecurityInformation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sdbuf"),
		.get = py_netr_DELTA_SECRET_get_sdbuf,
		.set = py_netr_DELTA_SECRET_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_DELTA_SECRET_get_unknown1,
		.set = py_netr_DELTA_SECRET_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_DELTA_SECRET_get_unknown2,
		.set = py_netr_DELTA_SECRET_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_DELTA_SECRET_get_unknown3,
		.set = py_netr_DELTA_SECRET_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_DELTA_SECRET_get_unknown4,
		.set = py_netr_DELTA_SECRET_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_DELTA_SECRET_get_unknown5,
		.set = py_netr_DELTA_SECRET_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown6"),
		.get = py_netr_DELTA_SECRET_get_unknown6,
		.set = py_netr_DELTA_SECRET_set_unknown6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown7"),
		.get = py_netr_DELTA_SECRET_get_unknown7,
		.set = py_netr_DELTA_SECRET_set_unknown7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown8"),
		.get = py_netr_DELTA_SECRET_get_unknown8,
		.set = py_netr_DELTA_SECRET_set_unknown8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_SECRET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_SECRET, type);
}


static PyTypeObject netr_DELTA_SECRET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_SECRET",
	.tp_getset = py_netr_DELTA_SECRET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_SECRET_new,
};

static PyObject *py_import_netr_DELTA_UNION(TALLOC_CTX *mem_ctx, int level, union netr_DELTA_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_DELTA_DOMAIN:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_DOMAIN_Type, in->domain, in->domain);
			}
			return ret;

		case NETR_DELTA_GROUP:
			if (in->group == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_GROUP_Type, in->group, in->group);
			}
			return ret;

		case NETR_DELTA_DELETE_GROUP:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_RENAME_GROUP:
			if (in->rename_group == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_RENAME_Type, in->rename_group, in->rename_group);
			}
			return ret;

		case NETR_DELTA_USER:
			if (in->user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_USER_Type, in->user, in->user);
			}
			return ret;

		case NETR_DELTA_DELETE_USER:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_RENAME_USER:
			if (in->rename_user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_RENAME_Type, in->rename_user, in->rename_user);
			}
			return ret;

		case NETR_DELTA_GROUP_MEMBER:
			if (in->group_member == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_GROUP_MEMBER_Type, in->group_member, in->group_member);
			}
			return ret;

		case NETR_DELTA_ALIAS:
			if (in->alias == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_ALIAS_Type, in->alias, in->alias);
			}
			return ret;

		case NETR_DELTA_DELETE_ALIAS:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_RENAME_ALIAS:
			if (in->rename_alias == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_RENAME_Type, in->rename_alias, in->rename_alias);
			}
			return ret;

		case NETR_DELTA_ALIAS_MEMBER:
			if (in->alias_member == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_ALIAS_MEMBER_Type, in->alias_member, in->alias_member);
			}
			return ret;

		case NETR_DELTA_POLICY:
			if (in->policy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_POLICY_Type, in->policy, in->policy);
			}
			return ret;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in->trusted_domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_TRUSTED_DOMAIN_Type, in->trusted_domain, in->trusted_domain);
			}
			return ret;

		case NETR_DELTA_DELETE_TRUST:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_ACCOUNT:
			if (in->account == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_ACCOUNT_Type, in->account, in->account);
			}
			return ret;

		case NETR_DELTA_DELETE_ACCOUNT:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_SECRET:
			if (in->secret == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_SECRET_Type, in->secret, in->secret);
			}
			return ret;

		case NETR_DELTA_DELETE_SECRET:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_DELETE_GROUP2:
			if (in->delete_group == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_DELETE_USER_Type, in->delete_group, in->delete_group);
			}
			return ret;

		case NETR_DELTA_DELETE_USER2:
			if (in->delete_user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_DELETE_USER_Type, in->delete_user, in->delete_user);
			}
			return ret;

		case NETR_DELTA_MODIFY_COUNT:
			if (in->modified_count == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromUnsignedLongLong(*in->modified_count);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_DELTA_UNION *py_export_netr_DELTA_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DELTA_UNION *ret = talloc_zero(mem_ctx, union netr_DELTA_UNION);
	switch (level) {
		case NETR_DELTA_DOMAIN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				PY_CHECK_TYPE(&netr_DELTA_DOMAIN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->domain = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_GROUP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->group");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->group = NULL;
			} else {
				ret->group = NULL;
				PY_CHECK_TYPE(&netr_DELTA_GROUP_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->group = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_GROUP:
			break;

		case NETR_DELTA_RENAME_GROUP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rename_group");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->rename_group = NULL;
			} else {
				ret->rename_group = NULL;
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->rename_group = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_USER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->user");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->user = NULL;
			} else {
				ret->user = NULL;
				PY_CHECK_TYPE(&netr_DELTA_USER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->user = (struct netr_DELTA_USER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_USER:
			break;

		case NETR_DELTA_RENAME_USER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rename_user");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->rename_user = NULL;
			} else {
				ret->rename_user = NULL;
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->rename_user = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_GROUP_MEMBER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->group_member");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->group_member = NULL;
			} else {
				ret->group_member = NULL;
				PY_CHECK_TYPE(&netr_DELTA_GROUP_MEMBER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->group_member = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ALIAS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->alias");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->alias = NULL;
			} else {
				ret->alias = NULL;
				PY_CHECK_TYPE(&netr_DELTA_ALIAS_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->alias = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ALIAS:
			break;

		case NETR_DELTA_RENAME_ALIAS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rename_alias");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->rename_alias = NULL;
			} else {
				ret->rename_alias = NULL;
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->rename_alias = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ALIAS_MEMBER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->alias_member");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->alias_member = NULL;
			} else {
				ret->alias_member = NULL;
				PY_CHECK_TYPE(&netr_DELTA_ALIAS_MEMBER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->alias_member = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_POLICY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->policy");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->policy = NULL;
			} else {
				ret->policy = NULL;
				PY_CHECK_TYPE(&netr_DELTA_POLICY_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->policy = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->trusted_domain");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->trusted_domain = NULL;
			} else {
				ret->trusted_domain = NULL;
				PY_CHECK_TYPE(&netr_DELTA_TRUSTED_DOMAIN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->trusted_domain = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_TRUST:
			break;

		case NETR_DELTA_ACCOUNT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->account");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->account = NULL;
			} else {
				ret->account = NULL;
				PY_CHECK_TYPE(&netr_DELTA_ACCOUNT_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->account = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ACCOUNT:
			break;

		case NETR_DELTA_SECRET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->secret");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->secret = NULL;
			} else {
				ret->secret = NULL;
				PY_CHECK_TYPE(&netr_DELTA_SECRET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->secret = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_SECRET:
			break;

		case NETR_DELTA_DELETE_GROUP2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->delete_group");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->delete_group = NULL;
			} else {
				ret->delete_group = NULL;
				PY_CHECK_TYPE(&netr_DELTA_DELETE_USER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->delete_group = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_USER2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->delete_user");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->delete_user = NULL;
			} else {
				ret->delete_user = NULL;
				PY_CHECK_TYPE(&netr_DELTA_DELETE_USER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->delete_user = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_MODIFY_COUNT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->modified_count");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->modified_count = NULL;
			} else {
				ret->modified_count = talloc_ptrtype(mem_ctx, ret->modified_count);
				if (ret->modified_count == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->modified_count));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->modified_count = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_DELTA_UNION_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_DELTA_UNION *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_DELTA_UNION *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_DELTA_UNION!");
		return NULL;
	}

	return py_import_netr_DELTA_UNION(mem_ctx, level, in);
}

static PyObject *py_netr_DELTA_UNION_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_DELTA_UNION *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_DELTA_UNION(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_DELTA_UNION_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DELTA_UNION_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DELTA_UNION_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_DELTA_UNION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_DELTA_UNION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_UNION",
	.tp_getset = NULL,
	.tp_methods = py_netr_DELTA_UNION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_UNION_new,
};

static PyObject *py_import_netr_DELTA_ID_UNION(TALLOC_CTX *mem_ctx, int level, union netr_DELTA_ID_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_DELTA_DOMAIN:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_GROUP:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_DELETE_GROUP:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_RENAME_GROUP:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_USER:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_DELETE_USER:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_RENAME_USER:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_GROUP_MEMBER:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_ALIAS:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_DELETE_ALIAS:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_RENAME_ALIAS:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_ALIAS_MEMBER:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_POLICY:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_DELETE_TRUST:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_ACCOUNT:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_DELETE_ACCOUNT:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_SECRET:
			if (in->name == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->name == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->name, strlen(in->name), "utf-8", "ignore");
				}
			}
			return ret;

		case NETR_DELTA_DELETE_SECRET:
			if (in->name == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->name == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->name, strlen(in->name), "utf-8", "ignore");
				}
			}
			return ret;

		case NETR_DELTA_DELETE_GROUP2:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_DELETE_USER2:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->rid));
			return ret;

		case NETR_DELTA_MODIFY_COUNT:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_DELTA_ID_UNION *py_export_netr_DELTA_ID_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DELTA_ID_UNION *ret = talloc_zero(mem_ctx, union netr_DELTA_ID_UNION);
	switch (level) {
		case NETR_DELTA_DOMAIN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_GROUP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_DELETE_GROUP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_RENAME_GROUP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_USER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_DELETE_USER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_RENAME_USER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_GROUP_MEMBER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_ALIAS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_DELETE_ALIAS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_RENAME_ALIAS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_ALIAS_MEMBER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_POLICY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sid");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sid");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_TRUST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sid");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ACCOUNT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sid");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ACCOUNT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sid");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_SECRET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->name = NULL;
			} else {
				ret->name = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->name = talloc_str;
				}
			}
			break;

		case NETR_DELTA_DELETE_SECRET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->name = NULL;
			} else {
				ret->name = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->name = talloc_str;
				}
			}
			break;

		case NETR_DELTA_DELETE_GROUP2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_DELETE_USER2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rid");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->rid));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->rid = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_MODIFY_COUNT:
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_DELTA_ID_UNION_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_DELTA_ID_UNION *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_DELTA_ID_UNION *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_DELTA_ID_UNION!");
		return NULL;
	}

	return py_import_netr_DELTA_ID_UNION(mem_ctx, level, in);
}

static PyObject *py_netr_DELTA_ID_UNION_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_DELTA_ID_UNION *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_DELTA_ID_UNION(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_DELTA_ID_UNION_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DELTA_ID_UNION_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DELTA_ID_UNION_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_DELTA_ID_UNION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_DELTA_ID_UNION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_ID_UNION",
	.tp_getset = NULL,
	.tp_methods = py_netr_DELTA_ID_UNION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ID_UNION_new,
};


static PyObject *py_netr_DELTA_ENUM_get_delta_type(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_delta_type;
	py_delta_type = PyLong_FromLong((uint16_t)(object->delta_type));
	return py_delta_type;
}

static int py_netr_DELTA_ENUM_set_delta_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->delta_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->delta_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->delta_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_get_delta_id_union(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_delta_id_union;
	py_delta_id_union = pyrpc_import_union(&netr_DELTA_ID_UNION_Type, pytalloc_get_mem_ctx(obj), object->delta_type, &object->delta_id_union, "union netr_DELTA_ID_UNION");
	if (py_delta_id_union == NULL) {
		return NULL;
	}
	return py_delta_id_union;
}

static int py_netr_DELTA_ENUM_set_delta_id_union(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->delta_id_union");
		return -1;
	}
	{
		union netr_DELTA_ID_UNION *delta_id_union_switch_0;
		delta_id_union_switch_0 = (union netr_DELTA_ID_UNION *)pyrpc_export_union(&netr_DELTA_ID_UNION_Type, pytalloc_get_mem_ctx(py_obj), object->delta_type, value, "union netr_DELTA_ID_UNION");
		if (delta_id_union_switch_0 == NULL) {
			return -1;
		}
		object->delta_id_union = *delta_id_union_switch_0;
	}
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_get_delta_union(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_delta_union;
	py_delta_union = pyrpc_import_union(&netr_DELTA_UNION_Type, pytalloc_get_mem_ctx(obj), object->delta_type, &object->delta_union, "union netr_DELTA_UNION");
	if (py_delta_union == NULL) {
		return NULL;
	}
	return py_delta_union;
}

static int py_netr_DELTA_ENUM_set_delta_union(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->delta_union");
		return -1;
	}
	{
		union netr_DELTA_UNION *delta_union_switch_0;
		delta_union_switch_0 = (union netr_DELTA_UNION *)pyrpc_export_union(&netr_DELTA_UNION_Type, pytalloc_get_mem_ctx(py_obj), object->delta_type, value, "union netr_DELTA_UNION");
		if (delta_union_switch_0 == NULL) {
			return -1;
		}
		object->delta_union = *delta_union_switch_0;
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ENUM_getsetters[] = {
	{
		.name = discard_const_p(char, "delta_type"),
		.get = py_netr_DELTA_ENUM_get_delta_type,
		.set = py_netr_DELTA_ENUM_set_delta_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DeltaEnum")
	},
	{
		.name = discard_const_p(char, "delta_id_union"),
		.get = py_netr_DELTA_ENUM_get_delta_id_union,
		.set = py_netr_DELTA_ENUM_set_delta_id_union,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DELTA_ID_UNION")
	},
	{
		.name = discard_const_p(char, "delta_union"),
		.get = py_netr_DELTA_ENUM_get_delta_union,
		.set = py_netr_DELTA_ENUM_set_delta_union,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DELTA_UNION")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_ENUM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ENUM, type);
}


static PyTypeObject netr_DELTA_ENUM_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_ENUM",
	.tp_getset = py_netr_DELTA_ENUM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ENUM_new,
};


static PyObject *py_netr_DELTA_ENUM_ARRAY_get_num_deltas(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_num_deltas;
	py_num_deltas = PyLong_FromUnsignedLongLong((uint32_t)(object->num_deltas));
	return py_num_deltas;
}

static int py_netr_DELTA_ENUM_ARRAY_set_num_deltas(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_deltas");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_deltas));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_deltas = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_ARRAY_get_delta_enum(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_delta_enum;
	if (object->delta_enum == NULL) {
		Py_RETURN_NONE;
	}
	if (object->delta_enum == NULL) {
		py_delta_enum = Py_None;
		Py_INCREF(py_delta_enum);
	} else {
		py_delta_enum = PyList_New(object->num_deltas);
		if (py_delta_enum == NULL) {
			return NULL;
		}
		{
			int delta_enum_cntr_1;
			for (delta_enum_cntr_1 = 0; delta_enum_cntr_1 < (object->num_deltas); delta_enum_cntr_1++) {
				PyObject *py_delta_enum_1;
				py_delta_enum_1 = pytalloc_reference_ex(&netr_DELTA_ENUM_Type, object->delta_enum, &(object->delta_enum)[delta_enum_cntr_1]);
				PyList_SetItem(py_delta_enum, delta_enum_cntr_1, py_delta_enum_1);
			}
		}
	}
	return py_delta_enum;
}

static int py_netr_DELTA_ENUM_ARRAY_set_delta_enum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->delta_enum));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->delta_enum");
		return -1;
	}
	if (value == Py_None) {
		object->delta_enum = NULL;
	} else {
		object->delta_enum = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int delta_enum_cntr_1;
			object->delta_enum = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->delta_enum, PyList_GET_SIZE(value));
			if (!object->delta_enum) { return -1; }
			talloc_set_name_const(object->delta_enum, "ARRAY: object->delta_enum");
			for (delta_enum_cntr_1 = 0; delta_enum_cntr_1 < PyList_GET_SIZE(value); delta_enum_cntr_1++) {
				if (PyList_GET_ITEM(value, delta_enum_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->delta_enum)[delta_enum_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&netr_DELTA_ENUM_Type, PyList_GET_ITEM(value, delta_enum_cntr_1), return -1;);
				if (talloc_reference(object->delta_enum, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, delta_enum_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->delta_enum)[delta_enum_cntr_1] = *(struct netr_DELTA_ENUM *)pytalloc_get_ptr(PyList_GET_ITEM(value, delta_enum_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ENUM_ARRAY_getsetters[] = {
	{
		.name = discard_const_p(char, "num_deltas"),
		.get = py_netr_DELTA_ENUM_ARRAY_get_num_deltas,
		.set = py_netr_DELTA_ENUM_ARRAY_set_num_deltas,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "delta_enum"),
		.get = py_netr_DELTA_ENUM_ARRAY_get_delta_enum,
		.set = py_netr_DELTA_ENUM_ARRAY_set_delta_enum,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DELTA_ENUM")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DELTA_ENUM_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ENUM_ARRAY, type);
}


static PyTypeObject netr_DELTA_ENUM_ARRAY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DELTA_ENUM_ARRAY",
	.tp_getset = py_netr_DELTA_ENUM_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ENUM_ARRAY_new,
};


static PyObject *py_netr_UAS_INFO_0_get_computer_name(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyList_New(16);
	if (py_computer_name == NULL) {
		return NULL;
	}
	{
		int computer_name_cntr_0;
		for (computer_name_cntr_0 = 0; computer_name_cntr_0 < (16); computer_name_cntr_0++) {
			PyObject *py_computer_name_0;
			py_computer_name_0 = PyLong_FromLong((uint16_t)((object->computer_name)[computer_name_cntr_0]));
			PyList_SetItem(py_computer_name, computer_name_cntr_0, py_computer_name_0);
		}
	}
	return py_computer_name;
}

static int py_netr_UAS_INFO_0_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_name");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int computer_name_cntr_0;
		if (ARRAY_SIZE(object->computer_name) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->computer_name),  PyList_GET_SIZE(value));
			return -1;
		}
		for (computer_name_cntr_0 = 0; computer_name_cntr_0 < PyList_GET_SIZE(value); computer_name_cntr_0++) {
			if (PyList_GET_ITEM(value, computer_name_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->computer_name)[computer_name_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->computer_name)[computer_name_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, computer_name_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, computer_name_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->computer_name)[computer_name_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_UAS_INFO_0_get_timecreated(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = pytalloc_get_ptr(obj);
	PyObject *py_timecreated;
	py_timecreated = PyLong_FromUnsignedLongLong((uint32_t)(object->timecreated));
	return py_timecreated;
}

static int py_netr_UAS_INFO_0_set_timecreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timecreated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timecreated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timecreated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UAS_INFO_0_get_serial_number(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_number;
	py_serial_number = PyLong_FromUnsignedLongLong((uint32_t)(object->serial_number));
	return py_serial_number;
}

static int py_netr_UAS_INFO_0_set_serial_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_number");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_number));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_number = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_UAS_INFO_0_getsetters[] = {
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_netr_UAS_INFO_0_get_computer_name,
		.set = py_netr_UAS_INFO_0_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "timecreated"),
		.get = py_netr_UAS_INFO_0_get_timecreated,
		.set = py_netr_UAS_INFO_0_set_timecreated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "serial_number"),
		.get = py_netr_UAS_INFO_0_get_serial_number,
		.set = py_netr_UAS_INFO_0_set_serial_number,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_UAS_INFO_0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UAS_INFO_0, type);
}


static PyTypeObject netr_UAS_INFO_0_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_UAS_INFO_0",
	.tp_getset = py_netr_UAS_INFO_0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UAS_INFO_0_new,
};


static PyObject *py_netr_AccountBuffer_get_blob(PyObject *obj, void *closure)
{
	struct netr_AccountBuffer *object = pytalloc_get_ptr(obj);
	PyObject *py_blob;
	py_blob = PyBytes_FromStringAndSize((char *)(object->blob).data, (object->blob).length);
	return py_blob;
}

static int py_netr_AccountBuffer_set_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AccountBuffer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->blob");
		return -1;
	}
	object->blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_netr_AccountBuffer_getsetters[] = {
	{
		.name = discard_const_p(char, "blob"),
		.get = py_netr_AccountBuffer_get_blob,
		.set = py_netr_AccountBuffer_set_blob,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_netr_AccountBuffer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_AccountBuffer, type);
}


static PyTypeObject netr_AccountBuffer_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_AccountBuffer",
	.tp_getset = py_netr_AccountBuffer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_AccountBuffer_new,
};


static PyObject *py_netr_NETLOGON_INFO_1_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_netr_NETLOGON_INFO_1_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_1_get_pdc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_connection_status;
	py_pdc_connection_status = PyErr_FromWERROR(object->pdc_connection_status);
	return py_pdc_connection_status;
}

static int py_netr_NETLOGON_INFO_1_set_pdc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_connection_status");
		return -1;
	}
	object->pdc_connection_status = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_1_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_netr_NETLOGON_INFO_1_get_flags,
		.set = py_netr_NETLOGON_INFO_1_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_InfoFlags")
	},
	{
		.name = discard_const_p(char, "pdc_connection_status"),
		.get = py_netr_NETLOGON_INFO_1_get_pdc_connection_status,
		.set = py_netr_NETLOGON_INFO_1_set_pdc_connection_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_netr_NETLOGON_INFO_1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_1, type);
}


static PyTypeObject netr_NETLOGON_INFO_1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_NETLOGON_INFO_1",
	.tp_getset = py_netr_NETLOGON_INFO_1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_1_new,
};


static PyObject *py_netr_NETLOGON_INFO_2_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_netr_NETLOGON_INFO_2_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_pdc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_connection_status;
	py_pdc_connection_status = PyErr_FromWERROR(object->pdc_connection_status);
	return py_pdc_connection_status;
}

static int py_netr_NETLOGON_INFO_2_set_pdc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_connection_status");
		return -1;
	}
	object->pdc_connection_status = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_trusted_dc_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_trusted_dc_name;
	if (object->trusted_dc_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->trusted_dc_name == NULL) {
		py_trusted_dc_name = Py_None;
		Py_INCREF(py_trusted_dc_name);
	} else {
		if (object->trusted_dc_name == NULL) {
			py_trusted_dc_name = Py_None;
			Py_INCREF(py_trusted_dc_name);
		} else {
			py_trusted_dc_name = PyUnicode_Decode(object->trusted_dc_name, strlen(object->trusted_dc_name), "utf-8", "ignore");
		}
	}
	return py_trusted_dc_name;
}

static int py_netr_NETLOGON_INFO_2_set_trusted_dc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trusted_dc_name");
		return -1;
	}
	if (value == Py_None) {
		object->trusted_dc_name = NULL;
	} else {
		object->trusted_dc_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->trusted_dc_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_tc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(obj);
	PyObject *py_tc_connection_status;
	py_tc_connection_status = PyErr_FromWERROR(object->tc_connection_status);
	return py_tc_connection_status;
}

static int py_netr_NETLOGON_INFO_2_set_tc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tc_connection_status");
		return -1;
	}
	object->tc_connection_status = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_2_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_netr_NETLOGON_INFO_2_get_flags,
		.set = py_netr_NETLOGON_INFO_2_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_InfoFlags")
	},
	{
		.name = discard_const_p(char, "pdc_connection_status"),
		.get = py_netr_NETLOGON_INFO_2_get_pdc_connection_status,
		.set = py_netr_NETLOGON_INFO_2_set_pdc_connection_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{
		.name = discard_const_p(char, "trusted_dc_name"),
		.get = py_netr_NETLOGON_INFO_2_get_trusted_dc_name,
		.set = py_netr_NETLOGON_INFO_2_set_trusted_dc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "tc_connection_status"),
		.get = py_netr_NETLOGON_INFO_2_get_tc_connection_status,
		.set = py_netr_NETLOGON_INFO_2_set_tc_connection_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_netr_NETLOGON_INFO_2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_2, type);
}


static PyTypeObject netr_NETLOGON_INFO_2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_NETLOGON_INFO_2",
	.tp_getset = py_netr_NETLOGON_INFO_2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_2_new,
};


static PyObject *py_netr_NETLOGON_INFO_3_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_netr_NETLOGON_INFO_3_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_logon_attempts(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_attempts;
	py_logon_attempts = PyLong_FromUnsignedLongLong((uint32_t)(object->logon_attempts));
	return py_logon_attempts;
}

static int py_netr_NETLOGON_INFO_3_set_logon_attempts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_attempts");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_attempts));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_attempts = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown1));
	return py_unknown1;
}

static int py_netr_NETLOGON_INFO_3_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown2));
	return py_unknown2;
}

static int py_netr_NETLOGON_INFO_3_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown3));
	return py_unknown3;
}

static int py_netr_NETLOGON_INFO_3_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown4));
	return py_unknown4;
}

static int py_netr_NETLOGON_INFO_3_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown5));
	return py_unknown5;
}

static int py_netr_NETLOGON_INFO_3_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_3_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_netr_NETLOGON_INFO_3_get_flags,
		.set = py_netr_NETLOGON_INFO_3_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_InfoFlags")
	},
	{
		.name = discard_const_p(char, "logon_attempts"),
		.get = py_netr_NETLOGON_INFO_3_get_logon_attempts,
		.set = py_netr_NETLOGON_INFO_3_set_logon_attempts,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown1"),
		.get = py_netr_NETLOGON_INFO_3_get_unknown1,
		.set = py_netr_NETLOGON_INFO_3_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown2"),
		.get = py_netr_NETLOGON_INFO_3_get_unknown2,
		.set = py_netr_NETLOGON_INFO_3_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_netr_NETLOGON_INFO_3_get_unknown3,
		.set = py_netr_NETLOGON_INFO_3_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown4"),
		.get = py_netr_NETLOGON_INFO_3_get_unknown4,
		.set = py_netr_NETLOGON_INFO_3_set_unknown4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "unknown5"),
		.get = py_netr_NETLOGON_INFO_3_get_unknown5,
		.set = py_netr_NETLOGON_INFO_3_set_unknown5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_NETLOGON_INFO_3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_3, type);
}


static PyTypeObject netr_NETLOGON_INFO_3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_NETLOGON_INFO_3",
	.tp_getset = py_netr_NETLOGON_INFO_3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_3_new,
};


static PyObject *py_netr_NETLOGON_INFO_4_get_trusted_dc_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = pytalloc_get_ptr(obj);
	PyObject *py_trusted_dc_name;
	if (object->trusted_dc_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->trusted_dc_name == NULL) {
		py_trusted_dc_name = Py_None;
		Py_INCREF(py_trusted_dc_name);
	} else {
		if (object->trusted_dc_name == NULL) {
			py_trusted_dc_name = Py_None;
			Py_INCREF(py_trusted_dc_name);
		} else {
			py_trusted_dc_name = PyUnicode_Decode(object->trusted_dc_name, strlen(object->trusted_dc_name), "utf-8", "ignore");
		}
	}
	return py_trusted_dc_name;
}

static int py_netr_NETLOGON_INFO_4_set_trusted_dc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trusted_dc_name");
		return -1;
	}
	if (value == Py_None) {
		object->trusted_dc_name = NULL;
	} else {
		object->trusted_dc_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->trusted_dc_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_4_get_trusted_domain_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = pytalloc_get_ptr(obj);
	PyObject *py_trusted_domain_name;
	if (object->trusted_domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->trusted_domain_name == NULL) {
		py_trusted_domain_name = Py_None;
		Py_INCREF(py_trusted_domain_name);
	} else {
		if (object->trusted_domain_name == NULL) {
			py_trusted_domain_name = Py_None;
			Py_INCREF(py_trusted_domain_name);
		} else {
			py_trusted_domain_name = PyUnicode_Decode(object->trusted_domain_name, strlen(object->trusted_domain_name), "utf-8", "ignore");
		}
	}
	return py_trusted_domain_name;
}

static int py_netr_NETLOGON_INFO_4_set_trusted_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trusted_domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->trusted_domain_name = NULL;
	} else {
		object->trusted_domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->trusted_domain_name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_4_getsetters[] = {
	{
		.name = discard_const_p(char, "trusted_dc_name"),
		.get = py_netr_NETLOGON_INFO_4_get_trusted_dc_name,
		.set = py_netr_NETLOGON_INFO_4_set_trusted_dc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "trusted_domain_name"),
		.get = py_netr_NETLOGON_INFO_4_get_trusted_domain_name,
		.set = py_netr_NETLOGON_INFO_4_set_trusted_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_netr_NETLOGON_INFO_4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_4, type);
}


static PyTypeObject netr_NETLOGON_INFO_4_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_NETLOGON_INFO_4",
	.tp_getset = py_netr_NETLOGON_INFO_4_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_4_new,
};

static PyObject *py_import_netr_CONTROL_QUERY_INFORMATION(TALLOC_CTX *mem_ctx, int level, union netr_CONTROL_QUERY_INFORMATION *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_1_Type, in->info1, in->info1);
			}
			return ret;

		case 2:
			if (in->info2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_2_Type, in->info2, in->info2);
			}
			return ret;

		case 3:
			if (in->info3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_3_Type, in->info3, in->info3);
			}
			return ret;

		case 4:
			if (in->info4 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_4_Type, in->info4, in->info4);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_CONTROL_QUERY_INFORMATION *py_export_netr_CONTROL_QUERY_INFORMATION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_CONTROL_QUERY_INFORMATION *ret = talloc_zero(mem_ctx, union netr_CONTROL_QUERY_INFORMATION);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1 = (struct netr_NETLOGON_INFO_1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info2");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info2 = NULL;
			} else {
				ret->info2 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info2 = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info3");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info3 = NULL;
			} else {
				ret->info3 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info3 = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(in);
			}
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info4");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->info4 = NULL;
			} else {
				ret->info4 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_4_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info4 = (struct netr_NETLOGON_INFO_4 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_CONTROL_QUERY_INFORMATION_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_CONTROL_QUERY_INFORMATION *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_CONTROL_QUERY_INFORMATION *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_CONTROL_QUERY_INFORMATION!");
		return NULL;
	}

	return py_import_netr_CONTROL_QUERY_INFORMATION(mem_ctx, level, in);
}

static PyObject *py_netr_CONTROL_QUERY_INFORMATION_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_CONTROL_QUERY_INFORMATION *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_CONTROL_QUERY_INFORMATION(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_CONTROL_QUERY_INFORMATION_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_CONTROL_QUERY_INFORMATION_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_CONTROL_QUERY_INFORMATION_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_CONTROL_QUERY_INFORMATION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_CONTROL_QUERY_INFORMATION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_CONTROL_QUERY_INFORMATION",
	.tp_getset = NULL,
	.tp_methods = py_netr_CONTROL_QUERY_INFORMATION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_CONTROL_QUERY_INFORMATION_new,
};

static PyObject *py_import_netr_CONTROL_DATA_INFORMATION(TALLOC_CTX *mem_ctx, int level, union netr_CONTROL_DATA_INFORMATION *in)
{
	PyObject *ret;

	switch (level) {
		case NETLOGON_CONTROL_REDISCOVER:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_TC_QUERY:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_CHANGE_PASSWORD:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_TC_VERIFY:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_FIND_USER:
			if (in->user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->user == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->user, strlen(in->user), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_SET_DBFLAG:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->debug_level));
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_CONTROL_DATA_INFORMATION *py_export_netr_CONTROL_DATA_INFORMATION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_CONTROL_DATA_INFORMATION *ret = talloc_zero(mem_ctx, union netr_CONTROL_DATA_INFORMATION);
	switch (level) {
		case NETLOGON_CONTROL_REDISCOVER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->domain = talloc_str;
				}
			}
			break;

		case NETLOGON_CONTROL_TC_QUERY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->domain = talloc_str;
				}
			}
			break;

		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->domain = talloc_str;
				}
			}
			break;

		case NETLOGON_CONTROL_CHANGE_PASSWORD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->domain = talloc_str;
				}
			}
			break;

		case NETLOGON_CONTROL_TC_VERIFY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->domain = talloc_str;
				}
			}
			break;

		case NETLOGON_CONTROL_FIND_USER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->user");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->user = NULL;
			} else {
				ret->user = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->user = talloc_str;
				}
			}
			break;

		case NETLOGON_CONTROL_SET_DBFLAG:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->debug_level");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->debug_level));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->debug_level = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_CONTROL_DATA_INFORMATION_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_CONTROL_DATA_INFORMATION *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_CONTROL_DATA_INFORMATION *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_CONTROL_DATA_INFORMATION!");
		return NULL;
	}

	return py_import_netr_CONTROL_DATA_INFORMATION(mem_ctx, level, in);
}

static PyObject *py_netr_CONTROL_DATA_INFORMATION_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_CONTROL_DATA_INFORMATION *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_CONTROL_DATA_INFORMATION(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_CONTROL_DATA_INFORMATION_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_CONTROL_DATA_INFORMATION_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_CONTROL_DATA_INFORMATION_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_CONTROL_DATA_INFORMATION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_CONTROL_DATA_INFORMATION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_CONTROL_DATA_INFORMATION",
	.tp_getset = NULL,
	.tp_methods = py_netr_CONTROL_DATA_INFORMATION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_CONTROL_DATA_INFORMATION_new,
};

static PyObject *py_import_netr_ChangeLogObject(TALLOC_CTX *mem_ctx, int level, union netr_ChangeLogObject *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_CHANGELOG_SID_INCLUDED:
			ret = pytalloc_reference_ex(dom_sid_Type, mem_ctx, &in->object_sid);
			return ret;

		case NETR_CHANGELOG_NAME_INCLUDED:
			ret = PyString_FromStringOrNULL(in->object_name);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_ChangeLogObject *py_export_netr_ChangeLogObject(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_ChangeLogObject *ret = talloc_zero(mem_ctx, union netr_ChangeLogObject);
	switch (level) {
		case NETR_CHANGELOG_SID_INCLUDED:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->object_sid");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->object_sid = *(struct dom_sid *)pytalloc_get_ptr(in);
			break;

		case NETR_CHANGELOG_NAME_INCLUDED:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->object_name");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->object_name = talloc_str;
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_ChangeLogObject_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_ChangeLogObject *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_ChangeLogObject *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_ChangeLogObject!");
		return NULL;
	}

	return py_import_netr_ChangeLogObject(mem_ctx, level, in);
}

static PyObject *py_netr_ChangeLogObject_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_ChangeLogObject *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_ChangeLogObject(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_ChangeLogObject_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_ChangeLogObject_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_ChangeLogObject_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_ChangeLogObject_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_ChangeLogObject_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_ChangeLogObject",
	.tp_getset = NULL,
	.tp_methods = py_netr_ChangeLogObject_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_ChangeLogObject_new,
};


static PyObject *py_netr_ChangeLogEntry_get_serial_number1(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_number1;
	py_serial_number1 = PyLong_FromUnsignedLongLong((uint32_t)(object->serial_number1));
	return py_serial_number1;
}

static int py_netr_ChangeLogEntry_set_serial_number1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_number1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_number1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_number1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_serial_number2(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_number2;
	py_serial_number2 = PyLong_FromUnsignedLongLong((uint32_t)(object->serial_number2));
	return py_serial_number2;
}

static int py_netr_ChangeLogEntry_set_serial_number2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_number2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_number2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_number2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_object_rid(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_object_rid;
	py_object_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->object_rid));
	return py_object_rid;
}

static int py_netr_ChangeLogEntry_set_object_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object_rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->object_rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->object_rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_flags(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_netr_ChangeLogEntry_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_db_index(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_db_index;
	py_db_index = PyLong_FromLong((uint16_t)(object->db_index));
	return py_db_index;
}

static int py_netr_ChangeLogEntry_set_db_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->db_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->db_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_delta_type(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_delta_type;
	py_delta_type = PyLong_FromLong((uint16_t)(object->delta_type));
	return py_delta_type;
}

static int py_netr_ChangeLogEntry_set_delta_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->delta_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->delta_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->delta_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_object(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pyrpc_import_union(&netr_ChangeLogObject_Type, pytalloc_get_mem_ctx(obj), object->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED), &object->object, "union netr_ChangeLogObject");
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_netr_ChangeLogEntry_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object");
		return -1;
	}
	{
		union netr_ChangeLogObject *object_switch_0;
		object_switch_0 = (union netr_ChangeLogObject *)pyrpc_export_union(&netr_ChangeLogObject_Type, pytalloc_get_mem_ctx(py_obj), object->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED), value, "union netr_ChangeLogObject");
		if (object_switch_0 == NULL) {
			return -1;
		}
		object->object = *object_switch_0;
	}
	return 0;
}

static PyGetSetDef py_netr_ChangeLogEntry_getsetters[] = {
	{
		.name = discard_const_p(char, "serial_number1"),
		.get = py_netr_ChangeLogEntry_get_serial_number1,
		.set = py_netr_ChangeLogEntry_set_serial_number1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "serial_number2"),
		.get = py_netr_ChangeLogEntry_get_serial_number2,
		.set = py_netr_ChangeLogEntry_set_serial_number2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "object_rid"),
		.get = py_netr_ChangeLogEntry_get_object_rid,
		.set = py_netr_ChangeLogEntry_set_object_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_netr_ChangeLogEntry_get_flags,
		.set = py_netr_ChangeLogEntry_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_ChangeLogFlags")
	},
	{
		.name = discard_const_p(char, "db_index"),
		.get = py_netr_ChangeLogEntry_get_db_index,
		.set = py_netr_ChangeLogEntry_set_db_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamDatabaseID8Bit")
	},
	{
		.name = discard_const_p(char, "delta_type"),
		.get = py_netr_ChangeLogEntry_get_delta_type,
		.set = py_netr_ChangeLogEntry_set_delta_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DeltaEnum8Bit")
	},
	{
		.name = discard_const_p(char, "object"),
		.get = py_netr_ChangeLogEntry_get_object,
		.set = py_netr_ChangeLogEntry_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_ChangeLogObject")
	},
	{ .name = NULL }
};

static PyObject *py_netr_ChangeLogEntry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_ChangeLogEntry, type);
}

static PyObject *py_netr_ChangeLogEntry_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_ChangeLogEntry);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_ChangeLogEntry_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_ChangeLogEntry);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_ChangeLogEntry);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_ChangeLogEntry_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_ChangeLogEntry *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_ChangeLogEntry, "netr_ChangeLogEntry", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_ChangeLogEntry, "netr_ChangeLogEntry", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_ChangeLogEntry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_ChangeLogEntry_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_ChangeLogEntry_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_ChangeLogEntry_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_ChangeLogEntry_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_ChangeLogEntry",
	.tp_getset = py_netr_ChangeLogEntry_getsetters,
	.tp_methods = py_netr_ChangeLogEntry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_ChangeLogEntry_new,
};


static PyObject *py_netr_Blob_get_length(PyObject *obj, void *closure)
{
	struct netr_Blob *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_netr_Blob_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Blob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_Blob_get_data(PyObject *obj, void *closure)
{
	struct netr_Blob *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_Blob_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Blob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_Blob_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_Blob_get_length,
		.set = py_netr_Blob_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_netr_Blob_get_data,
		.set = py_netr_Blob_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_Blob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_Blob, type);
}


static PyTypeObject netr_Blob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_Blob",
	.tp_getset = py_netr_Blob_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Blob_new,
};


static PyObject *py_netr_DsRGetDCNameInfo_get_dc_unc(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dc_unc;
	if (object->dc_unc == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dc_unc == NULL) {
		py_dc_unc = Py_None;
		Py_INCREF(py_dc_unc);
	} else {
		if (object->dc_unc == NULL) {
			py_dc_unc = Py_None;
			Py_INCREF(py_dc_unc);
		} else {
			py_dc_unc = PyUnicode_Decode(object->dc_unc, strlen(object->dc_unc), "utf-8", "ignore");
		}
	}
	return py_dc_unc;
}

static int py_netr_DsRGetDCNameInfo_set_dc_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dc_unc");
		return -1;
	}
	if (value == Py_None) {
		object->dc_unc = NULL;
	} else {
		object->dc_unc = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dc_unc = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_address(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dc_address;
	if (object->dc_address == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dc_address == NULL) {
		py_dc_address = Py_None;
		Py_INCREF(py_dc_address);
	} else {
		if (object->dc_address == NULL) {
			py_dc_address = Py_None;
			Py_INCREF(py_dc_address);
		} else {
			py_dc_address = PyUnicode_Decode(object->dc_address, strlen(object->dc_address), "utf-8", "ignore");
		}
	}
	return py_dc_address;
}

static int py_netr_DsRGetDCNameInfo_set_dc_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dc_address");
		return -1;
	}
	if (value == Py_None) {
		object->dc_address = NULL;
	} else {
		object->dc_address = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dc_address = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_address_type(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dc_address_type;
	py_dc_address_type = PyLong_FromUnsignedLongLong((uint32_t)(object->dc_address_type));
	return py_dc_address_type;
}

static int py_netr_DsRGetDCNameInfo_set_dc_address_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dc_address_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dc_address_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dc_address_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_domain_guid(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_guid;
	py_domain_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_guid);
	return py_domain_guid;
}

static int py_netr_DsRGetDCNameInfo_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_netr_DsRGetDCNameInfo_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_forest_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_forest_name;
	if (object->forest_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->forest_name == NULL) {
		py_forest_name = Py_None;
		Py_INCREF(py_forest_name);
	} else {
		if (object->forest_name == NULL) {
			py_forest_name = Py_None;
			Py_INCREF(py_forest_name);
		} else {
			py_forest_name = PyUnicode_Decode(object->forest_name, strlen(object->forest_name), "utf-8", "ignore");
		}
	}
	return py_forest_name;
}

static int py_netr_DsRGetDCNameInfo_set_forest_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->forest_name");
		return -1;
	}
	if (value == Py_None) {
		object->forest_name = NULL;
	} else {
		object->forest_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->forest_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_flags(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dc_flags;
	py_dc_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->dc_flags));
	return py_dc_flags;
}

static int py_netr_DsRGetDCNameInfo_set_dc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dc_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dc_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dc_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_site_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dc_site_name;
	if (object->dc_site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dc_site_name == NULL) {
		py_dc_site_name = Py_None;
		Py_INCREF(py_dc_site_name);
	} else {
		if (object->dc_site_name == NULL) {
			py_dc_site_name = Py_None;
			Py_INCREF(py_dc_site_name);
		} else {
			py_dc_site_name = PyUnicode_Decode(object->dc_site_name, strlen(object->dc_site_name), "utf-8", "ignore");
		}
	}
	return py_dc_site_name;
}

static int py_netr_DsRGetDCNameInfo_set_dc_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dc_site_name");
		return -1;
	}
	if (value == Py_None) {
		object->dc_site_name = NULL;
	} else {
		object->dc_site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dc_site_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_client_site_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_client_site_name;
	if (object->client_site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->client_site_name == NULL) {
		py_client_site_name = Py_None;
		Py_INCREF(py_client_site_name);
	} else {
		if (object->client_site_name == NULL) {
			py_client_site_name = Py_None;
			Py_INCREF(py_client_site_name);
		} else {
			py_client_site_name = PyUnicode_Decode(object->client_site_name, strlen(object->client_site_name), "utf-8", "ignore");
		}
	}
	return py_client_site_name;
}

static int py_netr_DsRGetDCNameInfo_set_client_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_site_name");
		return -1;
	}
	if (value == Py_None) {
		object->client_site_name = NULL;
	} else {
		object->client_site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->client_site_name = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRGetDCNameInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "dc_unc"),
		.get = py_netr_DsRGetDCNameInfo_get_dc_unc,
		.set = py_netr_DsRGetDCNameInfo_set_dc_unc,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dc_address"),
		.get = py_netr_DsRGetDCNameInfo_get_dc_address,
		.set = py_netr_DsRGetDCNameInfo_set_dc_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dc_address_type"),
		.get = py_netr_DsRGetDCNameInfo_get_dc_address_type,
		.set = py_netr_DsRGetDCNameInfo_set_dc_address_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DsRGetDCNameInfo_AddressType")
	},
	{
		.name = discard_const_p(char, "domain_guid"),
		.get = py_netr_DsRGetDCNameInfo_get_domain_guid,
		.set = py_netr_DsRGetDCNameInfo_set_domain_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_netr_DsRGetDCNameInfo_get_domain_name,
		.set = py_netr_DsRGetDCNameInfo_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "forest_name"),
		.get = py_netr_DsRGetDCNameInfo_get_forest_name,
		.set = py_netr_DsRGetDCNameInfo_set_forest_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dc_flags"),
		.get = py_netr_DsRGetDCNameInfo_get_dc_flags,
		.set = py_netr_DsRGetDCNameInfo_set_dc_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_server_type")
	},
	{
		.name = discard_const_p(char, "dc_site_name"),
		.get = py_netr_DsRGetDCNameInfo_get_dc_site_name,
		.set = py_netr_DsRGetDCNameInfo_set_dc_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "client_site_name"),
		.get = py_netr_DsRGetDCNameInfo_get_client_site_name,
		.set = py_netr_DsRGetDCNameInfo_set_client_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DsRGetDCNameInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRGetDCNameInfo, type);
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_DsRGetDCNameInfo);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DsRGetDCNameInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DsRGetDCNameInfo);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_DsRGetDCNameInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_DsRGetDCNameInfo, "netr_DsRGetDCNameInfo", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_DsRGetDCNameInfo, "netr_DsRGetDCNameInfo", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_DsRGetDCNameInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_DsRGetDCNameInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DsRGetDCNameInfo_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DsRGetDCNameInfo_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_DsRGetDCNameInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DsRGetDCNameInfo",
	.tp_getset = py_netr_DsRGetDCNameInfo_getsetters,
	.tp_methods = py_netr_DsRGetDCNameInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRGetDCNameInfo_new,
};

static PyObject *py_import_netr_Capabilities(TALLOC_CTX *mem_ctx, int level, union netr_Capabilities *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->server_capabilities));
			return ret;

		case 2:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->requested_flags));
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_Capabilities *py_export_netr_Capabilities(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_Capabilities *ret = talloc_zero(mem_ctx, union netr_Capabilities);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->server_capabilities");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->server_capabilities));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->server_capabilities = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->requested_flags");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->requested_flags));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->requested_flags = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_netr_Capabilities_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_Capabilities *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_Capabilities *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_Capabilities!");
		return NULL;
	}

	return py_import_netr_Capabilities(mem_ctx, level, in);
}

static PyObject *py_netr_Capabilities_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_Capabilities *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_Capabilities(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_Capabilities_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Capabilities_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_Capabilities_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_Capabilities_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_Capabilities_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_Capabilities",
	.tp_getset = NULL,
	.tp_methods = py_netr_Capabilities_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Capabilities_new,
};


static PyObject *py_netr_LsaPolicyInformation_get_policy_size(PyObject *obj, void *closure)
{
	struct netr_LsaPolicyInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_policy_size;
	py_policy_size = PyLong_FromUnsignedLongLong((uint32_t)(object->policy_size));
	return py_policy_size;
}

static int py_netr_LsaPolicyInformation_set_policy_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LsaPolicyInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->policy_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->policy_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->policy_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_LsaPolicyInformation_get_policy(PyObject *obj, void *closure)
{
	struct netr_LsaPolicyInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_policy;
	if (object->policy == NULL) {
		Py_RETURN_NONE;
	}
	if (object->policy == NULL) {
		py_policy = Py_None;
		Py_INCREF(py_policy);
	} else {
		py_policy = PyList_New(object->policy_size);
		if (py_policy == NULL) {
			return NULL;
		}
		{
			int policy_cntr_1;
			for (policy_cntr_1 = 0; policy_cntr_1 < (object->policy_size); policy_cntr_1++) {
				PyObject *py_policy_1;
				py_policy_1 = PyLong_FromLong((uint16_t)((object->policy)[policy_cntr_1]));
				PyList_SetItem(py_policy, policy_cntr_1, py_policy_1);
			}
		}
	}
	return py_policy;
}

static int py_netr_LsaPolicyInformation_set_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LsaPolicyInformation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->policy));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->policy");
		return -1;
	}
	if (value == Py_None) {
		object->policy = NULL;
	} else {
		object->policy = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int policy_cntr_1;
			object->policy = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->policy, PyList_GET_SIZE(value));
			if (!object->policy) { return -1; }
			talloc_set_name_const(object->policy, "ARRAY: object->policy");
			for (policy_cntr_1 = 0; policy_cntr_1 < PyList_GET_SIZE(value); policy_cntr_1++) {
				if (PyList_GET_ITEM(value, policy_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->policy)[policy_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->policy)[policy_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, policy_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, policy_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->policy)[policy_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_LsaPolicyInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "policy_size"),
		.get = py_netr_LsaPolicyInformation_get_policy_size,
		.set = py_netr_LsaPolicyInformation_set_policy_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "policy"),
		.get = py_netr_LsaPolicyInformation_get_policy,
		.set = py_netr_LsaPolicyInformation_set_policy,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_LsaPolicyInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_LsaPolicyInformation, type);
}


static PyTypeObject netr_LsaPolicyInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_LsaPolicyInformation",
	.tp_getset = py_netr_LsaPolicyInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LsaPolicyInformation_new,
};


static PyObject *py_netr_OsVersionInfoEx_get_OSVersionInfoSize(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_OSVersionInfoSize;
	py_OSVersionInfoSize = PyLong_FromUnsignedLongLong((uint32_t)(object->OSVersionInfoSize));
	return py_OSVersionInfoSize;
}

static int py_netr_OsVersionInfoEx_set_OSVersionInfoSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OSVersionInfoSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->OSVersionInfoSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->OSVersionInfoSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_MajorVersion(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_MajorVersion;
	py_MajorVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->MajorVersion));
	return py_MajorVersion;
}

static int py_netr_OsVersionInfoEx_set_MajorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MajorVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MajorVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MajorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_MinorVersion(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_MinorVersion;
	py_MinorVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->MinorVersion));
	return py_MinorVersion;
}

static int py_netr_OsVersionInfoEx_set_MinorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MinorVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MinorVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MinorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_BuildNumber(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_BuildNumber;
	py_BuildNumber = PyLong_FromUnsignedLongLong((uint32_t)(object->BuildNumber));
	return py_BuildNumber;
}

static int py_netr_OsVersionInfoEx_set_BuildNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BuildNumber");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->BuildNumber));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->BuildNumber = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_PlatformId(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_PlatformId;
	py_PlatformId = PyLong_FromUnsignedLongLong((uint32_t)(object->PlatformId));
	return py_PlatformId;
}

static int py_netr_OsVersionInfoEx_set_PlatformId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->PlatformId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->PlatformId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->PlatformId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_CSDVersion(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_CSDVersion;
	py_CSDVersion = PyString_FromStringOrNULL(object->CSDVersion);
	return py_CSDVersion;
}

static int py_netr_OsVersionInfoEx_set_CSDVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->CSDVersion");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->CSDVersion = talloc_str;
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_ServicePackMajor(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_ServicePackMajor;
	py_ServicePackMajor = PyLong_FromLong((uint16_t)(object->ServicePackMajor));
	return py_ServicePackMajor;
}

static int py_netr_OsVersionInfoEx_set_ServicePackMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServicePackMajor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ServicePackMajor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ServicePackMajor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_ServicePackMinor(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_ServicePackMinor;
	py_ServicePackMinor = PyLong_FromLong((uint16_t)(object->ServicePackMinor));
	return py_ServicePackMinor;
}

static int py_netr_OsVersionInfoEx_set_ServicePackMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServicePackMinor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ServicePackMinor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ServicePackMinor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_SuiteMask(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_SuiteMask;
	py_SuiteMask = PyLong_FromLong((uint16_t)(object->SuiteMask));
	return py_SuiteMask;
}

static int py_netr_OsVersionInfoEx_set_SuiteMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SuiteMask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SuiteMask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SuiteMask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_ProductType(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_ProductType;
	py_ProductType = PyLong_FromLong((uint16_t)(object->ProductType));
	return py_ProductType;
}

static int py_netr_OsVersionInfoEx_set_ProductType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ProductType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ProductType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ProductType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_Reserved(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyLong_FromLong((uint16_t)(object->Reserved));
	return py_Reserved;
}

static int py_netr_OsVersionInfoEx_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_OsVersionInfoEx_getsetters[] = {
	{
		.name = discard_const_p(char, "OSVersionInfoSize"),
		.get = py_netr_OsVersionInfoEx_get_OSVersionInfoSize,
		.set = py_netr_OsVersionInfoEx_set_OSVersionInfoSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "MajorVersion"),
		.get = py_netr_OsVersionInfoEx_get_MajorVersion,
		.set = py_netr_OsVersionInfoEx_set_MajorVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "MinorVersion"),
		.get = py_netr_OsVersionInfoEx_get_MinorVersion,
		.set = py_netr_OsVersionInfoEx_set_MinorVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "BuildNumber"),
		.get = py_netr_OsVersionInfoEx_get_BuildNumber,
		.set = py_netr_OsVersionInfoEx_set_BuildNumber,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "PlatformId"),
		.get = py_netr_OsVersionInfoEx_get_PlatformId,
		.set = py_netr_OsVersionInfoEx_set_PlatformId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "CSDVersion"),
		.get = py_netr_OsVersionInfoEx_get_CSDVersion,
		.set = py_netr_OsVersionInfoEx_set_CSDVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "ServicePackMajor"),
		.get = py_netr_OsVersionInfoEx_get_ServicePackMajor,
		.set = py_netr_OsVersionInfoEx_set_ServicePackMajor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ServicePackMinor"),
		.get = py_netr_OsVersionInfoEx_get_ServicePackMinor,
		.set = py_netr_OsVersionInfoEx_set_ServicePackMinor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "SuiteMask"),
		.get = py_netr_OsVersionInfoEx_get_SuiteMask,
		.set = py_netr_OsVersionInfoEx_set_SuiteMask,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SuiteMask")
	},
	{
		.name = discard_const_p(char, "ProductType"),
		.get = py_netr_OsVersionInfoEx_get_ProductType,
		.set = py_netr_OsVersionInfoEx_set_ProductType,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_ProductType")
	},
	{
		.name = discard_const_p(char, "Reserved"),
		.get = py_netr_OsVersionInfoEx_get_Reserved,
		.set = py_netr_OsVersionInfoEx_set_Reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_netr_OsVersionInfoEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OsVersionInfoEx, type);
}


static PyTypeObject netr_OsVersionInfoEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_OsVersionInfoEx",
	.tp_getset = py_netr_OsVersionInfoEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_OsVersionInfoEx_new,
};


static PyObject *py_netr_OsVersion_get_length(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_netr_OsVersion_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersion_get_dummy(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy));
	return py_dummy;
}

static int py_netr_OsVersion_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersion_get_size(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_netr_OsVersion_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersion_get_os(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(obj);
	PyObject *py_os;
	py_os = pytalloc_reference_ex(&netr_OsVersionInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->os);
	return py_os;
}

static int py_netr_OsVersion_set_os(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->os");
		return -1;
	}
	PY_CHECK_TYPE(&netr_OsVersionInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->os = *(struct netr_OsVersionInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_OsVersion_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_OsVersion_get_length,
		.set = py_netr_OsVersion_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "dummy"),
		.get = py_netr_OsVersion_get_dummy,
		.set = py_netr_OsVersion_set_dummy,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_netr_OsVersion_get_size,
		.set = py_netr_OsVersion_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "os"),
		.get = py_netr_OsVersion_get_os,
		.set = py_netr_OsVersion_set_os,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_OsVersionInfoEx")
	},
	{ .name = NULL }
};

static PyObject *py_netr_OsVersion_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OsVersion, type);
}


static PyTypeObject netr_OsVersion_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_OsVersion",
	.tp_getset = py_netr_OsVersion_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_OsVersion_new,
};


static PyObject *py_netr_OsVersionContainer_get_length(PyObject *obj, void *closure)
{
	struct netr_OsVersionContainer *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_netr_OsVersionContainer_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionContainer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionContainer_get_size(PyObject *obj, void *closure)
{
	struct netr_OsVersionContainer *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_netr_OsVersionContainer_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionContainer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OsVersionContainer_get_os(PyObject *obj, void *closure)
{
	struct netr_OsVersionContainer *object = pytalloc_get_ptr(obj);
	PyObject *py_os;
	if (object->os == NULL) {
		Py_RETURN_NONE;
	}
	if (object->os == NULL) {
		py_os = Py_None;
		Py_INCREF(py_os);
	} else {
		py_os = pytalloc_reference_ex(&netr_OsVersion_Type, object->os, object->os);
	}
	return py_os;
}

static int py_netr_OsVersionContainer_set_os(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionContainer *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->os));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->os");
		return -1;
	}
	if (value == Py_None) {
		object->os = NULL;
	} else {
		object->os = NULL;
		PY_CHECK_TYPE(&netr_OsVersion_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->os = (struct netr_OsVersion *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_netr_OsVersionContainer_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_OsVersionContainer_get_length,
		.set = py_netr_OsVersionContainer_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_netr_OsVersionContainer_get_size,
		.set = py_netr_OsVersionContainer_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "os"),
		.get = py_netr_OsVersionContainer_get_os,
		.set = py_netr_OsVersionContainer_set_os,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_OsVersion")
	},
	{ .name = NULL }
};

static PyObject *py_netr_OsVersionContainer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OsVersionContainer, type);
}


static PyTypeObject netr_OsVersionContainer_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_OsVersionContainer",
	.tp_getset = py_netr_OsVersionContainer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_OsVersionContainer_new,
};


static PyObject *py_netr_WorkstationInformation_get_lsa_policy(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_lsa_policy;
	py_lsa_policy = pytalloc_reference_ex(&netr_LsaPolicyInformation_Type, pytalloc_get_mem_ctx(obj), &object->lsa_policy);
	return py_lsa_policy;
}

static int py_netr_WorkstationInformation_set_lsa_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lsa_policy");
		return -1;
	}
	PY_CHECK_TYPE(&netr_LsaPolicyInformation_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lsa_policy = *(struct netr_LsaPolicyInformation *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dns_hostname(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_hostname;
	if (object->dns_hostname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_hostname == NULL) {
		py_dns_hostname = Py_None;
		Py_INCREF(py_dns_hostname);
	} else {
		if (object->dns_hostname == NULL) {
			py_dns_hostname = Py_None;
			Py_INCREF(py_dns_hostname);
		} else {
			py_dns_hostname = PyUnicode_Decode(object->dns_hostname, strlen(object->dns_hostname), "utf-8", "ignore");
		}
	}
	return py_dns_hostname;
}

static int py_netr_WorkstationInformation_set_dns_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_hostname");
		return -1;
	}
	if (value == Py_None) {
		object->dns_hostname = NULL;
	} else {
		object->dns_hostname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_hostname = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_sitename(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sitename == NULL) {
		py_sitename = Py_None;
		Py_INCREF(py_sitename);
	} else {
		if (object->sitename == NULL) {
			py_sitename = Py_None;
			Py_INCREF(py_sitename);
		} else {
			py_sitename = PyUnicode_Decode(object->sitename, strlen(object->sitename), "utf-8", "ignore");
		}
	}
	return py_sitename;
}

static int py_netr_WorkstationInformation_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sitename");
		return -1;
	}
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->sitename = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy1(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy1;
	if (object->dummy1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dummy1 == NULL) {
		py_dummy1 = Py_None;
		Py_INCREF(py_dummy1);
	} else {
		if (object->dummy1 == NULL) {
			py_dummy1 = Py_None;
			Py_INCREF(py_dummy1);
		} else {
			py_dummy1 = PyUnicode_Decode(object->dummy1, strlen(object->dummy1), "utf-8", "ignore");
		}
	}
	return py_dummy1;
}

static int py_netr_WorkstationInformation_set_dummy1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy1");
		return -1;
	}
	if (value == Py_None) {
		object->dummy1 = NULL;
	} else {
		object->dummy1 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dummy1 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy2(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy2;
	if (object->dummy2 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dummy2 == NULL) {
		py_dummy2 = Py_None;
		Py_INCREF(py_dummy2);
	} else {
		if (object->dummy2 == NULL) {
			py_dummy2 = Py_None;
			Py_INCREF(py_dummy2);
		} else {
			py_dummy2 = PyUnicode_Decode(object->dummy2, strlen(object->dummy2), "utf-8", "ignore");
		}
	}
	return py_dummy2;
}

static int py_netr_WorkstationInformation_set_dummy2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy2");
		return -1;
	}
	if (value == Py_None) {
		object->dummy2 = NULL;
	} else {
		object->dummy2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dummy2 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy3(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy3;
	if (object->dummy3 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dummy3 == NULL) {
		py_dummy3 = Py_None;
		Py_INCREF(py_dummy3);
	} else {
		if (object->dummy3 == NULL) {
			py_dummy3 = Py_None;
			Py_INCREF(py_dummy3);
		} else {
			py_dummy3 = PyUnicode_Decode(object->dummy3, strlen(object->dummy3), "utf-8", "ignore");
		}
	}
	return py_dummy3;
}

static int py_netr_WorkstationInformation_set_dummy3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy3");
		return -1;
	}
	if (value == Py_None) {
		object->dummy3 = NULL;
	} else {
		object->dummy3 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dummy3 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy4(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy4;
	if (object->dummy4 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dummy4 == NULL) {
		py_dummy4 = Py_None;
		Py_INCREF(py_dummy4);
	} else {
		if (object->dummy4 == NULL) {
			py_dummy4 = Py_None;
			Py_INCREF(py_dummy4);
		} else {
			py_dummy4 = PyUnicode_Decode(object->dummy4, strlen(object->dummy4), "utf-8", "ignore");
		}
	}
	return py_dummy4;
}

static int py_netr_WorkstationInformation_set_dummy4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy4");
		return -1;
	}
	if (value == Py_None) {
		object->dummy4 = NULL;
	} else {
		object->dummy4 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dummy4 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_os_version(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_os_version;
	py_os_version = pytalloc_reference_ex(&netr_OsVersionContainer_Type, pytalloc_get_mem_ctx(obj), &object->os_version);
	return py_os_version;
}

static int py_netr_WorkstationInformation_set_os_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->os_version");
		return -1;
	}
	PY_CHECK_TYPE(&netr_OsVersionContainer_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->os_version = *(struct netr_OsVersionContainer *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_os_name(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_os_name;
	py_os_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->os_name);
	return py_os_name;
}

static int py_netr_WorkstationInformation_set_os_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->os_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->os_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_string3(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string3;
	py_dummy_string3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string3);
	return py_dummy_string3;
}

static int py_netr_WorkstationInformation_set_dummy_string3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_string4(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string4;
	py_dummy_string4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string4);
	return py_dummy_string4;
}

static int py_netr_WorkstationInformation_set_dummy_string4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_workstation_flags(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_workstation_flags;
	py_workstation_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->workstation_flags));
	return py_workstation_flags;
}

static int py_netr_WorkstationInformation_set_workstation_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstation_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->workstation_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->workstation_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_supported_enc_types(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_enc_types;
	py_supported_enc_types = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_enc_types));
	return py_supported_enc_types;
}

static int py_netr_WorkstationInformation_set_supported_enc_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_enc_types");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_enc_types));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_enc_types = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_long3(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long3;
	py_dummy_long3 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long3));
	return py_dummy_long3;
}

static int py_netr_WorkstationInformation_set_dummy_long3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_long4(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long4;
	py_dummy_long4 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long4));
	return py_dummy_long4;
}

static int py_netr_WorkstationInformation_set_dummy_long4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_WorkstationInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "lsa_policy"),
		.get = py_netr_WorkstationInformation_get_lsa_policy,
		.set = py_netr_WorkstationInformation_set_lsa_policy,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LsaPolicyInformation")
	},
	{
		.name = discard_const_p(char, "dns_hostname"),
		.get = py_netr_WorkstationInformation_get_dns_hostname,
		.set = py_netr_WorkstationInformation_set_dns_hostname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "sitename"),
		.get = py_netr_WorkstationInformation_get_sitename,
		.set = py_netr_WorkstationInformation_set_sitename,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dummy1"),
		.get = py_netr_WorkstationInformation_get_dummy1,
		.set = py_netr_WorkstationInformation_set_dummy1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dummy2"),
		.get = py_netr_WorkstationInformation_get_dummy2,
		.set = py_netr_WorkstationInformation_set_dummy2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dummy3"),
		.get = py_netr_WorkstationInformation_get_dummy3,
		.set = py_netr_WorkstationInformation_set_dummy3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dummy4"),
		.get = py_netr_WorkstationInformation_get_dummy4,
		.set = py_netr_WorkstationInformation_set_dummy4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "os_version"),
		.get = py_netr_WorkstationInformation_get_os_version,
		.set = py_netr_WorkstationInformation_set_os_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_OsVersionContainer")
	},
	{
		.name = discard_const_p(char, "os_name"),
		.get = py_netr_WorkstationInformation_get_os_name,
		.set = py_netr_WorkstationInformation_set_os_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "dummy_string3"),
		.get = py_netr_WorkstationInformation_get_dummy_string3,
		.set = py_netr_WorkstationInformation_set_dummy_string3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "dummy_string4"),
		.get = py_netr_WorkstationInformation_get_dummy_string4,
		.set = py_netr_WorkstationInformation_set_dummy_string4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "workstation_flags"),
		.get = py_netr_WorkstationInformation_get_workstation_flags,
		.set = py_netr_WorkstationInformation_set_workstation_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_WorkstationFlags")
	},
	{
		.name = discard_const_p(char, "supported_enc_types"),
		.get = py_netr_WorkstationInformation_get_supported_enc_types,
		.set = py_netr_WorkstationInformation_set_supported_enc_types,
		.doc = discard_const_p(char, "PIDL-generated element of base type kerb_EncTypes")
	},
	{
		.name = discard_const_p(char, "dummy_long3"),
		.get = py_netr_WorkstationInformation_get_dummy_long3,
		.set = py_netr_WorkstationInformation_set_dummy_long3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dummy_long4"),
		.get = py_netr_WorkstationInformation_get_dummy_long4,
		.set = py_netr_WorkstationInformation_set_dummy_long4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_WorkstationInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_WorkstationInformation, type);
}


static PyTypeObject netr_WorkstationInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_WorkstationInformation",
	.tp_getset = py_netr_WorkstationInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_WorkstationInformation_new,
};

static PyObject *py_import_netr_WorkstationInfo(TALLOC_CTX *mem_ctx, int level, union netr_WorkstationInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->workstation_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_WorkstationInformation_Type, in->workstation_info, in->workstation_info);
			}
			return ret;

		case 2:
			if (in->lsa_policy_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_WorkstationInformation_Type, in->lsa_policy_info, in->lsa_policy_info);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_WorkstationInfo *py_export_netr_WorkstationInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_WorkstationInfo *ret = talloc_zero(mem_ctx, union netr_WorkstationInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->workstation_info");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->workstation_info = NULL;
			} else {
				ret->workstation_info = NULL;
				PY_CHECK_TYPE(&netr_WorkstationInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->workstation_info = (struct netr_WorkstationInformation *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->lsa_policy_info");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->lsa_policy_info = NULL;
			} else {
				ret->lsa_policy_info = NULL;
				PY_CHECK_TYPE(&netr_WorkstationInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->lsa_policy_info = (struct netr_WorkstationInformation *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_netr_WorkstationInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_WorkstationInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_WorkstationInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_WorkstationInfo!");
		return NULL;
	}

	return py_import_netr_WorkstationInfo(mem_ctx, level, in);
}

static PyObject *py_netr_WorkstationInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_WorkstationInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_WorkstationInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_WorkstationInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_WorkstationInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_WorkstationInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_WorkstationInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_WorkstationInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_WorkstationInfo",
	.tp_getset = NULL,
	.tp_methods = py_netr_WorkstationInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_WorkstationInfo_new,
};


static PyObject *py_netr_trust_extension_info_get_flags(PyObject *obj, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_netr_trust_extension_info_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_info_get_parent_index(PyObject *obj, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(obj);
	PyObject *py_parent_index;
	py_parent_index = PyLong_FromUnsignedLongLong((uint32_t)(object->parent_index));
	return py_parent_index;
}

static int py_netr_trust_extension_info_set_parent_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->parent_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->parent_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->parent_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_info_get_trust_type(PyObject *obj, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_type));
	return py_trust_type;
}

static int py_netr_trust_extension_info_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trust_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_info_get_trust_attributes(PyObject *obj, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_attributes));
	return py_trust_attributes;
}

static int py_netr_trust_extension_info_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trust_attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_trust_extension_info_getsetters[] = {
	{
		.name = discard_const_p(char, "flags"),
		.get = py_netr_trust_extension_info_get_flags,
		.set = py_netr_trust_extension_info_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_TrustFlags")
	},
	{
		.name = discard_const_p(char, "parent_index"),
		.get = py_netr_trust_extension_info_get_parent_index,
		.set = py_netr_trust_extension_info_set_parent_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "trust_type"),
		.get = py_netr_trust_extension_info_get_trust_type,
		.set = py_netr_trust_extension_info_set_trust_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustType")
	},
	{
		.name = discard_const_p(char, "trust_attributes"),
		.get = py_netr_trust_extension_info_get_trust_attributes,
		.set = py_netr_trust_extension_info_set_trust_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustAttributes")
	},
	{ .name = NULL }
};

static PyObject *py_netr_trust_extension_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_trust_extension_info, type);
}


static PyTypeObject netr_trust_extension_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_trust_extension_info",
	.tp_getset = py_netr_trust_extension_info_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_trust_extension_info_new,
};


static PyObject *py_netr_trust_extension_get_length(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_netr_trust_extension_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_get_dummy(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy));
	return py_dummy;
}

static int py_netr_trust_extension_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_get_size(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_netr_trust_extension_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_get_info(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&netr_trust_extension_info_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_netr_trust_extension_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&netr_trust_extension_info_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct netr_trust_extension_info *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_trust_extension_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_trust_extension_get_length,
		.set = py_netr_trust_extension_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "dummy"),
		.get = py_netr_trust_extension_get_dummy,
		.set = py_netr_trust_extension_set_dummy,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_netr_trust_extension_get_size,
		.set = py_netr_trust_extension_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_netr_trust_extension_get_info,
		.set = py_netr_trust_extension_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_trust_extension_info")
	},
	{ .name = NULL }
};

static PyObject *py_netr_trust_extension_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_trust_extension, type);
}


static PyTypeObject netr_trust_extension_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_trust_extension",
	.tp_getset = py_netr_trust_extension_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_trust_extension_new,
};


static PyObject *py_netr_trust_extension_container_get_length(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_netr_trust_extension_container_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_container_get_size(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_netr_trust_extension_container_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_trust_extension_container_get_info(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_trust_extension_Type, object->info, object->info);
	}
	return py_info;
}

static int py_netr_trust_extension_container_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&netr_trust_extension_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct netr_trust_extension *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_netr_trust_extension_container_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_trust_extension_container_get_length,
		.set = py_netr_trust_extension_container_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_netr_trust_extension_container_get_size,
		.set = py_netr_trust_extension_container_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_netr_trust_extension_container_get_info,
		.set = py_netr_trust_extension_container_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_trust_extension")
	},
	{ .name = NULL }
};

static PyObject *py_netr_trust_extension_container_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_trust_extension_container, type);
}


static PyTypeObject netr_trust_extension_container_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_trust_extension_container",
	.tp_getset = py_netr_trust_extension_container_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_trust_extension_container_new,
};


static PyObject *py_netr_OneDomainInfo_get_domainname(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domainname;
	py_domainname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->domainname);
	return py_domainname;
}

static int py_netr_OneDomainInfo_set_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domainname");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domainname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dns_domainname(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domainname;
	py_dns_domainname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_domainname);
	return py_dns_domainname;
}

static int py_netr_OneDomainInfo_set_dns_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domainname");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domainname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dns_forestname(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_forestname;
	py_dns_forestname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_forestname);
	return py_dns_forestname;
}

static int py_netr_OneDomainInfo_set_dns_forestname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_forestname");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_forestname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_domain_guid(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_guid;
	py_domain_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_guid);
	return py_domain_guid;
}

static int py_netr_OneDomainInfo_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_domain_sid(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_netr_OneDomainInfo_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domain_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_sid");
		return -1;
	}
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_trust_extension(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_extension;
	py_trust_extension = pytalloc_reference_ex(&netr_trust_extension_container_Type, pytalloc_get_mem_ctx(obj), &object->trust_extension);
	return py_trust_extension;
}

static int py_netr_OneDomainInfo_set_trust_extension(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trust_extension");
		return -1;
	}
	PY_CHECK_TYPE(&netr_trust_extension_container_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->trust_extension = *(struct netr_trust_extension_container *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_string2(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string2;
	py_dummy_string2 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string2);
	return py_dummy_string2;
}

static int py_netr_OneDomainInfo_set_dummy_string2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string2 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_string3(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string3;
	py_dummy_string3 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string3);
	return py_dummy_string3;
}

static int py_netr_OneDomainInfo_set_dummy_string3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string3 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_string4(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string4;
	py_dummy_string4 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string4);
	return py_dummy_string4;
}

static int py_netr_OneDomainInfo_set_dummy_string4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string4 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long1(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long1;
	py_dummy_long1 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long1));
	return py_dummy_long1;
}

static int py_netr_OneDomainInfo_set_dummy_long1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long2(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long2;
	py_dummy_long2 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long2));
	return py_dummy_long2;
}

static int py_netr_OneDomainInfo_set_dummy_long2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long3(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long3;
	py_dummy_long3 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long3));
	return py_dummy_long3;
}

static int py_netr_OneDomainInfo_set_dummy_long3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long4(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long4;
	py_dummy_long4 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long4));
	return py_dummy_long4;
}

static int py_netr_OneDomainInfo_set_dummy_long4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_OneDomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "domainname"),
		.get = py_netr_OneDomainInfo_get_domainname,
		.set = py_netr_OneDomainInfo_set_domainname,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dns_domainname"),
		.get = py_netr_OneDomainInfo_get_dns_domainname,
		.set = py_netr_OneDomainInfo_set_dns_domainname,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dns_forestname"),
		.get = py_netr_OneDomainInfo_get_dns_forestname,
		.set = py_netr_OneDomainInfo_set_dns_forestname,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "domain_guid"),
		.get = py_netr_OneDomainInfo_get_domain_guid,
		.set = py_netr_OneDomainInfo_set_domain_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "domain_sid"),
		.get = py_netr_OneDomainInfo_get_domain_sid,
		.set = py_netr_OneDomainInfo_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "trust_extension"),
		.get = py_netr_OneDomainInfo_get_trust_extension,
		.set = py_netr_OneDomainInfo_set_trust_extension,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_trust_extension_container")
	},
	{
		.name = discard_const_p(char, "dummy_string2"),
		.get = py_netr_OneDomainInfo_get_dummy_string2,
		.set = py_netr_OneDomainInfo_set_dummy_string2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dummy_string3"),
		.get = py_netr_OneDomainInfo_get_dummy_string3,
		.set = py_netr_OneDomainInfo_set_dummy_string3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dummy_string4"),
		.get = py_netr_OneDomainInfo_get_dummy_string4,
		.set = py_netr_OneDomainInfo_set_dummy_string4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dummy_long1"),
		.get = py_netr_OneDomainInfo_get_dummy_long1,
		.set = py_netr_OneDomainInfo_set_dummy_long1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dummy_long2"),
		.get = py_netr_OneDomainInfo_get_dummy_long2,
		.set = py_netr_OneDomainInfo_set_dummy_long2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dummy_long3"),
		.get = py_netr_OneDomainInfo_get_dummy_long3,
		.set = py_netr_OneDomainInfo_set_dummy_long3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dummy_long4"),
		.get = py_netr_OneDomainInfo_get_dummy_long4,
		.set = py_netr_OneDomainInfo_set_dummy_long4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_OneDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OneDomainInfo, type);
}


static PyTypeObject netr_OneDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_OneDomainInfo",
	.tp_getset = py_netr_OneDomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_OneDomainInfo_new,
};


static PyObject *py_netr_DomainInformation_get_primary_domain(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_domain;
	py_primary_domain = pytalloc_reference_ex(&netr_OneDomainInfo_Type, pytalloc_get_mem_ctx(obj), &object->primary_domain);
	return py_primary_domain;
}

static int py_netr_DomainInformation_set_primary_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_domain");
		return -1;
	}
	PY_CHECK_TYPE(&netr_OneDomainInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->primary_domain = *(struct netr_OneDomainInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_trusted_domain_count(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_trusted_domain_count;
	py_trusted_domain_count = PyLong_FromUnsignedLongLong((uint32_t)(object->trusted_domain_count));
	return py_trusted_domain_count;
}

static int py_netr_DomainInformation_set_trusted_domain_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trusted_domain_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trusted_domain_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trusted_domain_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_trusted_domains(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_trusted_domains;
	if (object->trusted_domains == NULL) {
		Py_RETURN_NONE;
	}
	if (object->trusted_domains == NULL) {
		py_trusted_domains = Py_None;
		Py_INCREF(py_trusted_domains);
	} else {
		py_trusted_domains = PyList_New(object->trusted_domain_count);
		if (py_trusted_domains == NULL) {
			return NULL;
		}
		{
			int trusted_domains_cntr_1;
			for (trusted_domains_cntr_1 = 0; trusted_domains_cntr_1 < (object->trusted_domain_count); trusted_domains_cntr_1++) {
				PyObject *py_trusted_domains_1;
				py_trusted_domains_1 = pytalloc_reference_ex(&netr_OneDomainInfo_Type, object->trusted_domains, &(object->trusted_domains)[trusted_domains_cntr_1]);
				PyList_SetItem(py_trusted_domains, trusted_domains_cntr_1, py_trusted_domains_1);
			}
		}
	}
	return py_trusted_domains;
}

static int py_netr_DomainInformation_set_trusted_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->trusted_domains));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trusted_domains");
		return -1;
	}
	if (value == Py_None) {
		object->trusted_domains = NULL;
	} else {
		object->trusted_domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int trusted_domains_cntr_1;
			object->trusted_domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->trusted_domains, PyList_GET_SIZE(value));
			if (!object->trusted_domains) { return -1; }
			talloc_set_name_const(object->trusted_domains, "ARRAY: object->trusted_domains");
			for (trusted_domains_cntr_1 = 0; trusted_domains_cntr_1 < PyList_GET_SIZE(value); trusted_domains_cntr_1++) {
				if (PyList_GET_ITEM(value, trusted_domains_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->trusted_domains)[trusted_domains_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&netr_OneDomainInfo_Type, PyList_GET_ITEM(value, trusted_domains_cntr_1), return -1;);
				if (talloc_reference(object->trusted_domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, trusted_domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->trusted_domains)[trusted_domains_cntr_1] = *(struct netr_OneDomainInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, trusted_domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_lsa_policy(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_lsa_policy;
	py_lsa_policy = pytalloc_reference_ex(&netr_LsaPolicyInformation_Type, pytalloc_get_mem_ctx(obj), &object->lsa_policy);
	return py_lsa_policy;
}

static int py_netr_DomainInformation_set_lsa_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lsa_policy");
		return -1;
	}
	PY_CHECK_TYPE(&netr_LsaPolicyInformation_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lsa_policy = *(struct netr_LsaPolicyInformation *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dns_hostname(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_hostname;
	py_dns_hostname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_hostname);
	return py_dns_hostname;
}

static int py_netr_DomainInformation_set_dns_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_hostname");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_hostname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_string2(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string2;
	py_dummy_string2 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string2);
	return py_dummy_string2;
}

static int py_netr_DomainInformation_set_dummy_string2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string2");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string2 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_string3(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string3;
	py_dummy_string3 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string3);
	return py_dummy_string3;
}

static int py_netr_DomainInformation_set_dummy_string3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string3");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string3 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_string4(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_string4;
	py_dummy_string4 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string4);
	return py_dummy_string4;
}

static int py_netr_DomainInformation_set_dummy_string4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_string4");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string4 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_workstation_flags(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_workstation_flags;
	py_workstation_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->workstation_flags));
	return py_workstation_flags;
}

static int py_netr_DomainInformation_set_workstation_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstation_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->workstation_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->workstation_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_supported_enc_types(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_enc_types;
	py_supported_enc_types = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_enc_types));
	return py_supported_enc_types;
}

static int py_netr_DomainInformation_set_supported_enc_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_enc_types");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_enc_types));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_enc_types = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_long3(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long3;
	py_dummy_long3 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long3));
	return py_dummy_long3;
}

static int py_netr_DomainInformation_set_dummy_long3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_long4(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_long4;
	py_dummy_long4 = PyLong_FromUnsignedLongLong((uint32_t)(object->dummy_long4));
	return py_dummy_long4;
}

static int py_netr_DomainInformation_set_dummy_long4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_long4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dummy_long4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dummy_long4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DomainInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "primary_domain"),
		.get = py_netr_DomainInformation_get_primary_domain,
		.set = py_netr_DomainInformation_set_primary_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_OneDomainInfo")
	},
	{
		.name = discard_const_p(char, "trusted_domain_count"),
		.get = py_netr_DomainInformation_get_trusted_domain_count,
		.set = py_netr_DomainInformation_set_trusted_domain_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "trusted_domains"),
		.get = py_netr_DomainInformation_get_trusted_domains,
		.set = py_netr_DomainInformation_set_trusted_domains,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_OneDomainInfo")
	},
	{
		.name = discard_const_p(char, "lsa_policy"),
		.get = py_netr_DomainInformation_get_lsa_policy,
		.set = py_netr_DomainInformation_set_lsa_policy,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LsaPolicyInformation")
	},
	{
		.name = discard_const_p(char, "dns_hostname"),
		.get = py_netr_DomainInformation_get_dns_hostname,
		.set = py_netr_DomainInformation_set_dns_hostname,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dummy_string2"),
		.get = py_netr_DomainInformation_get_dummy_string2,
		.set = py_netr_DomainInformation_set_dummy_string2,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dummy_string3"),
		.get = py_netr_DomainInformation_get_dummy_string3,
		.set = py_netr_DomainInformation_set_dummy_string3,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "dummy_string4"),
		.get = py_netr_DomainInformation_get_dummy_string4,
		.set = py_netr_DomainInformation_set_dummy_string4,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "workstation_flags"),
		.get = py_netr_DomainInformation_get_workstation_flags,
		.set = py_netr_DomainInformation_set_workstation_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_WorkstationFlags")
	},
	{
		.name = discard_const_p(char, "supported_enc_types"),
		.get = py_netr_DomainInformation_get_supported_enc_types,
		.set = py_netr_DomainInformation_set_supported_enc_types,
		.doc = discard_const_p(char, "PIDL-generated element of base type kerb_EncTypes")
	},
	{
		.name = discard_const_p(char, "dummy_long3"),
		.get = py_netr_DomainInformation_get_dummy_long3,
		.set = py_netr_DomainInformation_set_dummy_long3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dummy_long4"),
		.get = py_netr_DomainInformation_get_dummy_long4,
		.set = py_netr_DomainInformation_set_dummy_long4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DomainInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DomainInformation, type);
}


static PyTypeObject netr_DomainInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DomainInformation",
	.tp_getset = py_netr_DomainInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainInformation_new,
};

static PyObject *py_import_netr_DomainInfo(TALLOC_CTX *mem_ctx, int level, union netr_DomainInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->domain_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DomainInformation_Type, in->domain_info, in->domain_info);
			}
			return ret;

		case 2:
			if (in->lsa_policy_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_LsaPolicyInformation_Type, in->lsa_policy_info, in->lsa_policy_info);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_DomainInfo *py_export_netr_DomainInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DomainInfo *ret = talloc_zero(mem_ctx, union netr_DomainInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain_info");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->domain_info = NULL;
			} else {
				ret->domain_info = NULL;
				PY_CHECK_TYPE(&netr_DomainInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->domain_info = (struct netr_DomainInformation *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->lsa_policy_info");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->lsa_policy_info = NULL;
			} else {
				ret->lsa_policy_info = NULL;
				PY_CHECK_TYPE(&netr_LsaPolicyInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->lsa_policy_info = (struct netr_LsaPolicyInformation *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_netr_DomainInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_DomainInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_DomainInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_DomainInfo!");
		return NULL;
	}

	return py_import_netr_DomainInfo(mem_ctx, level, in);
}

static PyObject *py_netr_DomainInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_DomainInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_DomainInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_DomainInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DomainInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DomainInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_DomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_DomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DomainInfo",
	.tp_getset = NULL,
	.tp_methods = py_netr_DomainInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainInfo_new,
};


static PyObject *py_NL_PASSWORD_VERSION_get_ReservedField(PyObject *obj, void *closure)
{
	struct NL_PASSWORD_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_ReservedField;
	py_ReservedField = PyLong_FromUnsignedLongLong((uint32_t)(object->ReservedField));
	return py_ReservedField;
}

static int py_NL_PASSWORD_VERSION_set_ReservedField(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_PASSWORD_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ReservedField");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ReservedField));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ReservedField = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_PASSWORD_VERSION_get_PasswordVersionNumber(PyObject *obj, void *closure)
{
	struct NL_PASSWORD_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_PasswordVersionNumber;
	py_PasswordVersionNumber = PyLong_FromUnsignedLongLong((uint32_t)(object->PasswordVersionNumber));
	return py_PasswordVersionNumber;
}

static int py_NL_PASSWORD_VERSION_set_PasswordVersionNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_PASSWORD_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->PasswordVersionNumber");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->PasswordVersionNumber));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->PasswordVersionNumber = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_PASSWORD_VERSION_get_PasswordVersionPresent(PyObject *obj, void *closure)
{
	struct NL_PASSWORD_VERSION *object = pytalloc_get_ptr(obj);
	PyObject *py_PasswordVersionPresent;
	py_PasswordVersionPresent = PyLong_FromUnsignedLongLong((uint32_t)(object->PasswordVersionPresent));
	return py_PasswordVersionPresent;
}

static int py_NL_PASSWORD_VERSION_set_PasswordVersionPresent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_PASSWORD_VERSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->PasswordVersionPresent");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->PasswordVersionPresent));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->PasswordVersionPresent = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NL_PASSWORD_VERSION_getsetters[] = {
	{
		.name = discard_const_p(char, "ReservedField"),
		.get = py_NL_PASSWORD_VERSION_get_ReservedField,
		.set = py_NL_PASSWORD_VERSION_set_ReservedField,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "PasswordVersionNumber"),
		.get = py_NL_PASSWORD_VERSION_get_PasswordVersionNumber,
		.set = py_NL_PASSWORD_VERSION_set_PasswordVersionNumber,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "PasswordVersionPresent"),
		.get = py_NL_PASSWORD_VERSION_get_PasswordVersionPresent,
		.set = py_NL_PASSWORD_VERSION_set_PasswordVersionPresent,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_NL_PASSWORD_VERSION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_PASSWORD_VERSION, type);
}


static PyTypeObject NL_PASSWORD_VERSION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.NL_PASSWORD_VERSION",
	.tp_getset = py_NL_PASSWORD_VERSION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_PASSWORD_VERSION_new,
};


static PyObject *py_netr_CryptPassword_get_data(PyObject *obj, void *closure)
{
	struct netr_CryptPassword *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(512);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (512); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_netr_CryptPassword_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		if (ARRAY_SIZE(object->data) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->data),  PyList_GET_SIZE(value));
			return -1;
		}
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_CryptPassword_get_length(PyObject *obj, void *closure)
{
	struct netr_CryptPassword *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_netr_CryptPassword_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_CryptPassword_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_netr_CryptPassword_get_data,
		.set = py_netr_CryptPassword_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "length"),
		.get = py_netr_CryptPassword_get_length,
		.set = py_netr_CryptPassword_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_CryptPassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_CryptPassword, type);
}

static PyObject *py_netr_CryptPassword_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_CryptPassword);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_CryptPassword_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_CryptPassword);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_CryptPassword);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_CryptPassword_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_CryptPassword, "netr_CryptPassword", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_CryptPassword, "netr_CryptPassword", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_CryptPassword_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_CryptPassword_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_CryptPassword_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_CryptPassword_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_CryptPassword_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_CryptPassword",
	.tp_getset = py_netr_CryptPassword_getsetters,
	.tp_methods = py_netr_CryptPassword_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_CryptPassword_new,
};


static PyObject *py_netr_SendToSamResetBadPasswordCount_get_guid(PyObject *obj, void *closure)
{
	struct netr_SendToSamResetBadPasswordCount *object = pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_netr_SendToSamResetBadPasswordCount_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SendToSamResetBadPasswordCount *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_SendToSamResetBadPasswordCount_getsetters[] = {
	{
		.name = discard_const_p(char, "guid"),
		.get = py_netr_SendToSamResetBadPasswordCount_get_guid,
		.set = py_netr_SendToSamResetBadPasswordCount_set_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_netr_SendToSamResetBadPasswordCount_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SendToSamResetBadPasswordCount, type);
}


static PyTypeObject netr_SendToSamResetBadPasswordCount_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SendToSamResetBadPasswordCount",
	.tp_getset = py_netr_SendToSamResetBadPasswordCount_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SendToSamResetBadPasswordCount_new,
};

static PyObject *py_import_netr_SendToSamMessage(TALLOC_CTX *mem_ctx, int level, union netr_SendToSamMessage *in)
{
	PyObject *ret;

	switch (level) {
		case SendToSamResetBadPasswordCount:
			ret = pytalloc_reference_ex(&netr_SendToSamResetBadPasswordCount_Type, mem_ctx, &in->reset_bad_password);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netr_SendToSamMessage *py_export_netr_SendToSamMessage(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_SendToSamMessage *ret = talloc_zero(mem_ctx, union netr_SendToSamMessage);
	switch (level) {
		case SendToSamResetBadPasswordCount:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->reset_bad_password");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&netr_SendToSamResetBadPasswordCount_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->reset_bad_password = *(struct netr_SendToSamResetBadPasswordCount *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_netr_SendToSamMessage_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netr_SendToSamMessage *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netr_SendToSamMessage *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netr_SendToSamMessage!");
		return NULL;
	}

	return py_import_netr_SendToSamMessage(mem_ctx, level, in);
}

static PyObject *py_netr_SendToSamMessage_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netr_SendToSamMessage *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netr_SendToSamMessage(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netr_SendToSamMessage_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SendToSamMessage_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SendToSamMessage_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netr_SendToSamMessage_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netr_SendToSamMessage_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SendToSamMessage",
	.tp_getset = NULL,
	.tp_methods = py_netr_SendToSamMessage_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SendToSamMessage_new,
};


static PyObject *py_netr_SendToSamBase_get_message_type(PyObject *obj, void *closure)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(obj);
	PyObject *py_message_type;
	py_message_type = PyLong_FromLong((uint16_t)(object->message_type));
	return py_message_type;
}

static int py_netr_SendToSamBase_set_message_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->message_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->message_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->message_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SendToSamBase_get_message_size(PyObject *obj, void *closure)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(obj);
	PyObject *py_message_size;
	py_message_size = PyLong_FromUnsignedLongLong((uint32_t)(object->message_size));
	return py_message_size;
}

static int py_netr_SendToSamBase_set_message_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->message_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->message_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->message_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_SendToSamBase_get_message(PyObject *obj, void *closure)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(obj);
	PyObject *py_message;
	py_message = pyrpc_import_union(&netr_SendToSamMessage_Type, pytalloc_get_mem_ctx(obj), object->message_type, &object->message, "union netr_SendToSamMessage");
	if (py_message == NULL) {
		return NULL;
	}
	return py_message;
}

static int py_netr_SendToSamBase_set_message(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->message");
		return -1;
	}
	{
		union netr_SendToSamMessage *message_switch_1;
		message_switch_1 = (union netr_SendToSamMessage *)pyrpc_export_union(&netr_SendToSamMessage_Type, pytalloc_get_mem_ctx(py_obj), object->message_type, value, "union netr_SendToSamMessage");
		if (message_switch_1 == NULL) {
			return -1;
		}
		object->message = *message_switch_1;
	}
	return 0;
}

static PyGetSetDef py_netr_SendToSamBase_getsetters[] = {
	{
		.name = discard_const_p(char, "message_type"),
		.get = py_netr_SendToSamBase_get_message_type,
		.set = py_netr_SendToSamBase_set_message_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SendToSamType")
	},
	{
		.name = discard_const_p(char, "message_size"),
		.get = py_netr_SendToSamBase_get_message_size,
		.set = py_netr_SendToSamBase_set_message_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "message"),
		.get = py_netr_SendToSamBase_get_message,
		.set = py_netr_SendToSamBase_set_message,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SendToSamMessage")
	},
	{ .name = NULL }
};

static PyObject *py_netr_SendToSamBase_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SendToSamBase, type);
}

static PyObject *py_netr_SendToSamBase_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_SendToSamBase);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_SendToSamBase_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SendToSamBase);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SendToSamBase);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_SendToSamBase_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SendToSamBase *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SendToSamBase, "netr_SendToSamBase", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SendToSamBase, "netr_SendToSamBase", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_SendToSamBase_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_SendToSamBase_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SendToSamBase_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_SendToSamBase_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_SendToSamBase_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_SendToSamBase",
	.tp_getset = py_netr_SendToSamBase_getsetters,
	.tp_methods = py_netr_SendToSamBase_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SendToSamBase_new,
};


static PyObject *py_netr_DsRAddressToSitenamesWCtr_get_count(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_netr_DsRAddressToSitenamesWCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesWCtr_get_sitename(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sitename == NULL) {
		py_sitename = Py_None;
		Py_INCREF(py_sitename);
	} else {
		py_sitename = PyList_New(object->count);
		if (py_sitename == NULL) {
			return NULL;
		}
		{
			int sitename_cntr_1;
			for (sitename_cntr_1 = 0; sitename_cntr_1 < (object->count); sitename_cntr_1++) {
				PyObject *py_sitename_1;
				py_sitename_1 = pytalloc_reference_ex(lsa_String_Type, object->sitename, &(object->sitename)[sitename_cntr_1]);
				PyList_SetItem(py_sitename, sitename_cntr_1, py_sitename_1);
			}
		}
	}
	return py_sitename;
}

static int py_netr_DsRAddressToSitenamesWCtr_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sitename));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sitename");
		return -1;
	}
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sitename_cntr_1;
			object->sitename = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sitename, PyList_GET_SIZE(value));
			if (!object->sitename) { return -1; }
			talloc_set_name_const(object->sitename, "ARRAY: object->sitename");
			for (sitename_cntr_1 = 0; sitename_cntr_1 < PyList_GET_SIZE(value); sitename_cntr_1++) {
				if (PyList_GET_ITEM(value, sitename_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sitename)[sitename_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, sitename_cntr_1), return -1;);
				if (talloc_reference(object->sitename, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sitename_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sitename)[sitename_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, sitename_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRAddressToSitenamesWCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_netr_DsRAddressToSitenamesWCtr_get_count,
		.set = py_netr_DsRAddressToSitenamesWCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sitename"),
		.get = py_netr_DsRAddressToSitenamesWCtr_get_sitename,
		.set = py_netr_DsRAddressToSitenamesWCtr_set_sitename,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DsRAddressToSitenamesWCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRAddressToSitenamesWCtr, type);
}


static PyTypeObject netr_DsRAddressToSitenamesWCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DsRAddressToSitenamesWCtr",
	.tp_getset = py_netr_DsRAddressToSitenamesWCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRAddressToSitenamesWCtr_new,
};


static PyObject *py_netr_DsRAddress_get_buffer(PyObject *obj, void *closure)
{
	struct netr_DsRAddress *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(object->size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (object->size); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((object->buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_netr_DsRAddress_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddress *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffer");
		return -1;
	}
	if (value == Py_None) {
		object->buffer = NULL;
	} else {
		object->buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffer, PyList_GET_SIZE(value));
			if (!object->buffer) { return -1; }
			talloc_set_name_const(object->buffer, "ARRAY: object->buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffer)[buffer_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddress_get_size(PyObject *obj, void *closure)
{
	struct netr_DsRAddress *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromUnsignedLongLong((uint32_t)(object->size));
	return py_size;
}

static int py_netr_DsRAddress_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddress *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRAddress_getsetters[] = {
	{
		.name = discard_const_p(char, "buffer"),
		.get = py_netr_DsRAddress_get_buffer,
		.set = py_netr_DsRAddress_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_netr_DsRAddress_get_size,
		.set = py_netr_DsRAddress_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DsRAddress_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRAddress, type);
}


static PyTypeObject netr_DsRAddress_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DsRAddress",
	.tp_getset = py_netr_DsRAddress_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRAddress_new,
};


static PyObject *py_netr_DomainTrust_get_netbios_name(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	if (object->netbios_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->netbios_name == NULL) {
		py_netbios_name = Py_None;
		Py_INCREF(py_netbios_name);
	} else {
		if (object->netbios_name == NULL) {
			py_netbios_name = Py_None;
			Py_INCREF(py_netbios_name);
		} else {
			py_netbios_name = PyUnicode_Decode(object->netbios_name, strlen(object->netbios_name), "utf-8", "ignore");
		}
	}
	return py_netbios_name;
}

static int py_netr_DomainTrust_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->netbios_name");
		return -1;
	}
	if (value == Py_None) {
		object->netbios_name = NULL;
	} else {
		object->netbios_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->netbios_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_dns_name(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_name;
	if (object->dns_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_name == NULL) {
		py_dns_name = Py_None;
		Py_INCREF(py_dns_name);
	} else {
		if (object->dns_name == NULL) {
			py_dns_name = Py_None;
			Py_INCREF(py_dns_name);
		} else {
			py_dns_name = PyUnicode_Decode(object->dns_name, strlen(object->dns_name), "utf-8", "ignore");
		}
	}
	return py_dns_name;
}

static int py_netr_DomainTrust_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_name");
		return -1;
	}
	if (value == Py_None) {
		object->dns_name = NULL;
	} else {
		object->dns_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_flags(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_flags;
	py_trust_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_flags));
	return py_trust_flags;
}

static int py_netr_DomainTrust_set_trust_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trust_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_parent_index(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_parent_index;
	py_parent_index = PyLong_FromUnsignedLongLong((uint32_t)(object->parent_index));
	return py_parent_index;
}

static int py_netr_DomainTrust_set_parent_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->parent_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->parent_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->parent_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_type(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_type));
	return py_trust_type;
}

static int py_netr_DomainTrust_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trust_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_attributes(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->trust_attributes));
	return py_trust_attributes;
}

static int py_netr_DomainTrust_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trust_attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trust_attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trust_attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_sid(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_netr_DomainTrust_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_guid(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_netr_DomainTrust_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_DomainTrust_getsetters[] = {
	{
		.name = discard_const_p(char, "netbios_name"),
		.get = py_netr_DomainTrust_get_netbios_name,
		.set = py_netr_DomainTrust_set_netbios_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dns_name"),
		.get = py_netr_DomainTrust_get_dns_name,
		.set = py_netr_DomainTrust_set_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "trust_flags"),
		.get = py_netr_DomainTrust_get_trust_flags,
		.set = py_netr_DomainTrust_set_trust_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_TrustFlags")
	},
	{
		.name = discard_const_p(char, "parent_index"),
		.get = py_netr_DomainTrust_get_parent_index,
		.set = py_netr_DomainTrust_set_parent_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "trust_type"),
		.get = py_netr_DomainTrust_get_trust_type,
		.set = py_netr_DomainTrust_set_trust_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustType")
	},
	{
		.name = discard_const_p(char, "trust_attributes"),
		.get = py_netr_DomainTrust_get_trust_attributes,
		.set = py_netr_DomainTrust_set_trust_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_TrustAttributes")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_netr_DomainTrust_get_sid,
		.set = py_netr_DomainTrust_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "guid"),
		.get = py_netr_DomainTrust_get_guid,
		.set = py_netr_DomainTrust_set_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DomainTrust_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DomainTrust, type);
}

static PyObject *py_netr_DomainTrust_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_DomainTrust);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_DomainTrust_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DomainTrust);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DomainTrust);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_DomainTrust_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_DomainTrust *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_DomainTrust, "netr_DomainTrust", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_DomainTrust, "netr_DomainTrust", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_DomainTrust_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_DomainTrust_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DomainTrust_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DomainTrust_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_DomainTrust_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DomainTrust",
	.tp_getset = py_netr_DomainTrust_getsetters,
	.tp_methods = py_netr_DomainTrust_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainTrust_new,
};


static PyObject *py_netr_DomainTrustList_get_count(PyObject *obj, void *closure)
{
	struct netr_DomainTrustList *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_netr_DomainTrustList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustList *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrustList_get_array(PyObject *obj, void *closure)
{
	struct netr_DomainTrustList *object = pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		Py_RETURN_NONE;
	}
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < (object->count); array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&netr_DomainTrust_Type, object->array, &(object->array)[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_netr_DomainTrustList_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustList *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->array));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->array");
		return -1;
	}
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				if (PyList_GET_ITEM(value, array_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->array)[array_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&netr_DomainTrust_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->array)[array_cntr_1] = *(struct netr_DomainTrust *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DomainTrustList_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_netr_DomainTrustList_get_count,
		.set = py_netr_DomainTrustList_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "array"),
		.get = py_netr_DomainTrustList_get_array,
		.set = py_netr_DomainTrustList_set_array,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DomainTrust")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DomainTrustList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DomainTrustList, type);
}

static PyObject *py_netr_DomainTrustList_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netr_DomainTrustList *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netr_DomainTrustList);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netr_DomainTrustList_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_DomainTrustList *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DomainTrustList);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DomainTrustList);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_DomainTrustList_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_DomainTrustList *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_DomainTrustList, "netr_DomainTrustList", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_DomainTrustList, "netr_DomainTrustList", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_DomainTrustList_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_DomainTrustList_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DomainTrustList_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_DomainTrustList_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_DomainTrustList_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DomainTrustList",
	.tp_getset = py_netr_DomainTrustList_getsetters,
	.tp_methods = py_netr_DomainTrustList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainTrustList_new,
};


static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_count(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_sitename(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sitename == NULL) {
		py_sitename = Py_None;
		Py_INCREF(py_sitename);
	} else {
		py_sitename = PyList_New(object->count);
		if (py_sitename == NULL) {
			return NULL;
		}
		{
			int sitename_cntr_1;
			for (sitename_cntr_1 = 0; sitename_cntr_1 < (object->count); sitename_cntr_1++) {
				PyObject *py_sitename_1;
				py_sitename_1 = pytalloc_reference_ex(lsa_String_Type, object->sitename, &(object->sitename)[sitename_cntr_1]);
				PyList_SetItem(py_sitename, sitename_cntr_1, py_sitename_1);
			}
		}
	}
	return py_sitename;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sitename));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sitename");
		return -1;
	}
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sitename_cntr_1;
			object->sitename = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sitename, PyList_GET_SIZE(value));
			if (!object->sitename) { return -1; }
			talloc_set_name_const(object->sitename, "ARRAY: object->sitename");
			for (sitename_cntr_1 = 0; sitename_cntr_1 < PyList_GET_SIZE(value); sitename_cntr_1++) {
				if (PyList_GET_ITEM(value, sitename_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sitename)[sitename_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, sitename_cntr_1), return -1;);
				if (talloc_reference(object->sitename, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sitename_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sitename)[sitename_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, sitename_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_subnetname(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_subnetname;
	if (object->subnetname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->subnetname == NULL) {
		py_subnetname = Py_None;
		Py_INCREF(py_subnetname);
	} else {
		py_subnetname = PyList_New(object->count);
		if (py_subnetname == NULL) {
			return NULL;
		}
		{
			int subnetname_cntr_1;
			for (subnetname_cntr_1 = 0; subnetname_cntr_1 < (object->count); subnetname_cntr_1++) {
				PyObject *py_subnetname_1;
				py_subnetname_1 = pytalloc_reference_ex(lsa_String_Type, object->subnetname, &(object->subnetname)[subnetname_cntr_1]);
				PyList_SetItem(py_subnetname, subnetname_cntr_1, py_subnetname_1);
			}
		}
	}
	return py_subnetname;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_subnetname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->subnetname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->subnetname");
		return -1;
	}
	if (value == Py_None) {
		object->subnetname = NULL;
	} else {
		object->subnetname = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int subnetname_cntr_1;
			object->subnetname = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->subnetname, PyList_GET_SIZE(value));
			if (!object->subnetname) { return -1; }
			talloc_set_name_const(object->subnetname, "ARRAY: object->subnetname");
			for (subnetname_cntr_1 = 0; subnetname_cntr_1 < PyList_GET_SIZE(value); subnetname_cntr_1++) {
				if (PyList_GET_ITEM(value, subnetname_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->subnetname)[subnetname_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, subnetname_cntr_1), return -1;);
				if (talloc_reference(object->subnetname, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, subnetname_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->subnetname)[subnetname_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, subnetname_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRAddressToSitenamesExWCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_netr_DsRAddressToSitenamesExWCtr_get_count,
		.set = py_netr_DsRAddressToSitenamesExWCtr_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sitename"),
		.get = py_netr_DsRAddressToSitenamesExWCtr_get_sitename,
		.set = py_netr_DsRAddressToSitenamesExWCtr_set_sitename,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "subnetname"),
		.get = py_netr_DsRAddressToSitenamesExWCtr_get_subnetname,
		.set = py_netr_DsRAddressToSitenamesExWCtr_set_subnetname,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRAddressToSitenamesExWCtr, type);
}


static PyTypeObject netr_DsRAddressToSitenamesExWCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_DsRAddressToSitenamesExWCtr",
	.tp_getset = py_netr_DsRAddressToSitenamesExWCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRAddressToSitenamesExWCtr_new,
};


static PyObject *py_DcSitesCtr_get_num_sites(PyObject *obj, void *closure)
{
	struct DcSitesCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_num_sites;
	py_num_sites = PyLong_FromUnsignedLongLong((uint32_t)(object->num_sites));
	return py_num_sites;
}

static int py_DcSitesCtr_set_num_sites(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DcSitesCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_sites");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_sites));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_sites = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DcSitesCtr_get_sites(PyObject *obj, void *closure)
{
	struct DcSitesCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_sites;
	if (object->sites == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sites == NULL) {
		py_sites = Py_None;
		Py_INCREF(py_sites);
	} else {
		py_sites = PyList_New(object->num_sites);
		if (py_sites == NULL) {
			return NULL;
		}
		{
			int sites_cntr_1;
			for (sites_cntr_1 = 0; sites_cntr_1 < (object->num_sites); sites_cntr_1++) {
				PyObject *py_sites_1;
				py_sites_1 = pytalloc_reference_ex(lsa_String_Type, object->sites, &(object->sites)[sites_cntr_1]);
				PyList_SetItem(py_sites, sites_cntr_1, py_sites_1);
			}
		}
	}
	return py_sites;
}

static int py_DcSitesCtr_set_sites(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DcSitesCtr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sites));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sites");
		return -1;
	}
	if (value == Py_None) {
		object->sites = NULL;
	} else {
		object->sites = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sites_cntr_1;
			object->sites = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sites, PyList_GET_SIZE(value));
			if (!object->sites) { return -1; }
			talloc_set_name_const(object->sites, "ARRAY: object->sites");
			for (sites_cntr_1 = 0; sites_cntr_1 < PyList_GET_SIZE(value); sites_cntr_1++) {
				if (PyList_GET_ITEM(value, sites_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sites)[sites_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, sites_cntr_1), return -1;);
				if (talloc_reference(object->sites, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sites_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sites)[sites_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, sites_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DcSitesCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "num_sites"),
		.get = py_DcSitesCtr_get_num_sites,
		.set = py_DcSitesCtr_set_num_sites,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sites"),
		.get = py_DcSitesCtr_get_sites,
		.set = py_DcSitesCtr_set_sites,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_DcSitesCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DcSitesCtr, type);
}


static PyTypeObject DcSitesCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.DcSitesCtr",
	.tp_getset = py_DcSitesCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DcSitesCtr_new,
};


static PyObject *py_netr_TrustInfo_get_count(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_netr_TrustInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_TrustInfo_get_data(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->count);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->count); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_TrustInfo_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netr_TrustInfo_get_entry_count(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_entry_count;
	py_entry_count = PyLong_FromUnsignedLongLong((uint32_t)(object->entry_count));
	return py_entry_count;
}

static int py_netr_TrustInfo_set_entry_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entry_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->entry_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->entry_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_TrustInfo_get_entries(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = pytalloc_reference_ex(lsa_String_Type, object->entries, &(object->entries)[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_netr_TrustInfo_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->entries)[entries_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
				if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->entries)[entries_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_TrustInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_netr_TrustInfo_get_count,
		.set = py_netr_TrustInfo_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_netr_TrustInfo_get_data,
		.set = py_netr_TrustInfo_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entry_count"),
		.get = py_netr_TrustInfo_get_entry_count,
		.set = py_netr_TrustInfo_set_entry_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_netr_TrustInfo_get_entries,
		.set = py_netr_TrustInfo_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_netr_TrustInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_TrustInfo, type);
}


static PyTypeObject netr_TrustInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_TrustInfo",
	.tp_getset = py_netr_TrustInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_TrustInfo_new,
};


static PyObject *py_NL_DNS_NAME_INFO_get_type(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_NL_DNS_NAME_INFO_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_dns_domain_info(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_info;
	if (object->dns_domain_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_domain_info == NULL) {
		py_dns_domain_info = Py_None;
		Py_INCREF(py_dns_domain_info);
	} else {
		if (object->dns_domain_info == NULL) {
			py_dns_domain_info = Py_None;
			Py_INCREF(py_dns_domain_info);
		} else {
			py_dns_domain_info = PyUnicode_Decode(object->dns_domain_info, strlen(object->dns_domain_info), "utf-8", "ignore");
		}
	}
	return py_dns_domain_info;
}

static int py_NL_DNS_NAME_INFO_set_dns_domain_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain_info");
		return -1;
	}
	if (value == Py_None) {
		object->dns_domain_info = NULL;
	} else {
		object->dns_domain_info = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_domain_info = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_dns_domain_info_type(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_info_type;
	py_dns_domain_info_type = PyLong_FromLong((uint16_t)(object->dns_domain_info_type));
	return py_dns_domain_info_type;
}

static int py_NL_DNS_NAME_INFO_set_dns_domain_info_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain_info_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dns_domain_info_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dns_domain_info_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_priority(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyLong_FromUnsignedLongLong((uint32_t)(object->priority));
	return py_priority;
}

static int py_NL_DNS_NAME_INFO_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->priority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->priority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->priority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_weight(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_weight;
	py_weight = PyLong_FromUnsignedLongLong((uint32_t)(object->weight));
	return py_weight;
}

static int py_NL_DNS_NAME_INFO_set_weight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->weight");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->weight));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->weight = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_port(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromUnsignedLongLong((uint32_t)(object->port));
	return py_port;
}

static int py_NL_DNS_NAME_INFO_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_dns_register(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_register;
	py_dns_register = PyLong_FromUnsignedLongLong((uint32_t)(object->dns_register));
	return py_dns_register;
}

static int py_NL_DNS_NAME_INFO_set_dns_register(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_register");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dns_register));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dns_register = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_status(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(object->status));
	return py_status;
}

static int py_NL_DNS_NAME_INFO_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NL_DNS_NAME_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_NL_DNS_NAME_INFO_get_type,
		.set = py_NL_DNS_NAME_INFO_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DnsType")
	},
	{
		.name = discard_const_p(char, "dns_domain_info"),
		.get = py_NL_DNS_NAME_INFO_get_dns_domain_info,
		.set = py_NL_DNS_NAME_INFO_set_dns_domain_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dns_domain_info_type"),
		.get = py_NL_DNS_NAME_INFO_get_dns_domain_info_type,
		.set = py_NL_DNS_NAME_INFO_set_dns_domain_info_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_DnsDomainInfoType")
	},
	{
		.name = discard_const_p(char, "priority"),
		.get = py_NL_DNS_NAME_INFO_get_priority,
		.set = py_NL_DNS_NAME_INFO_set_priority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "weight"),
		.get = py_NL_DNS_NAME_INFO_get_weight,
		.set = py_NL_DNS_NAME_INFO_set_weight,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "port"),
		.get = py_NL_DNS_NAME_INFO_get_port,
		.set = py_NL_DNS_NAME_INFO_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dns_register"),
		.get = py_NL_DNS_NAME_INFO_get_dns_register,
		.set = py_NL_DNS_NAME_INFO_set_dns_register,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_NL_DNS_NAME_INFO_get_status,
		.set = py_NL_DNS_NAME_INFO_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_NL_DNS_NAME_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_DNS_NAME_INFO, type);
}


static PyTypeObject NL_DNS_NAME_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.NL_DNS_NAME_INFO",
	.tp_getset = py_NL_DNS_NAME_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_DNS_NAME_INFO_new,
};


static PyObject *py_NL_DNS_NAME_INFO_ARRAY_get_count(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_NL_DNS_NAME_INFO_ARRAY_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_get_names(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		Py_RETURN_NONE;
	}
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < (object->count); names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&NL_DNS_NAME_INFO_Type, object->names, &(object->names)[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_NL_DNS_NAME_INFO_ARRAY_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->names");
		return -1;
	}
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				if (PyList_GET_ITEM(value, names_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->names)[names_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&NL_DNS_NAME_INFO_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->names)[names_cntr_1] = *(struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_NL_DNS_NAME_INFO_ARRAY_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_NL_DNS_NAME_INFO_ARRAY_get_count,
		.set = py_NL_DNS_NAME_INFO_ARRAY_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "names"),
		.get = py_NL_DNS_NAME_INFO_ARRAY_get_names,
		.set = py_NL_DNS_NAME_INFO_ARRAY_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_DNS_NAME_INFO")
	},
	{ .name = NULL }
};

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_DNS_NAME_INFO_ARRAY, type);
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NL_DNS_NAME_INFO_ARRAY *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NL_DNS_NAME_INFO_ARRAY);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_DNS_NAME_INFO_ARRAY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_DNS_NAME_INFO_ARRAY);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_DNS_NAME_INFO_ARRAY, "NL_DNS_NAME_INFO_ARRAY", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_DNS_NAME_INFO_ARRAY, "NL_DNS_NAME_INFO_ARRAY", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_DNS_NAME_INFO_ARRAY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_DNS_NAME_INFO_ARRAY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_DNS_NAME_INFO_ARRAY_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_DNS_NAME_INFO_ARRAY_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_DNS_NAME_INFO_ARRAY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.NL_DNS_NAME_INFO_ARRAY",
	.tp_getset = py_NL_DNS_NAME_INFO_ARRAY_getsetters,
	.tp_methods = py_NL_DNS_NAME_INFO_ARRAY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_DNS_NAME_INFO_ARRAY_new,
};



static PyObject *py_netr_LogonUasLogon_in_get_server_name(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_netr_LogonUasLogon_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonUasLogon_in_get_account_name(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->in.account_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		py_account_name = PyUnicode_Decode(object->in.account_name, strlen(object->in.account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_netr_LogonUasLogon_in_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.account_name");
		return -1;
	}
	object->in.account_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.account_name);
	if (object->in.account_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.account_name = talloc_str;
	}
	return 0;
}

static PyObject *py_netr_LogonUasLogon_in_get_workstation(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_workstation;
	if (object->in.workstation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.workstation == NULL) {
		py_workstation = Py_None;
		Py_INCREF(py_workstation);
	} else {
		py_workstation = PyUnicode_Decode(object->in.workstation, strlen(object->in.workstation), "utf-8", "ignore");
	}
	return py_workstation;
}

static int py_netr_LogonUasLogon_in_set_workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.workstation");
		return -1;
	}
	object->in.workstation = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.workstation);
	if (object->in.workstation == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.workstation = talloc_str;
	}
	return 0;
}

static PyObject *py_netr_LogonUasLogon_out_get_info(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_UasInfo_Type, *object->out.info, *object->out.info);
	}
	return py_info;
}

static int py_netr_LogonUasLogon_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.info = NULL;
	} else {
		*object->out.info = NULL;
		PY_CHECK_TYPE(&netr_UasInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.info = (struct netr_UasInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_LogonUasLogon_get_result(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_netr_LogonUasLogon_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_netr_LogonUasLogon_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_netr_LogonUasLogon_in_get_server_name,
		.set = py_netr_LogonUasLogon_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_account_name"),
		.get = py_netr_LogonUasLogon_in_get_account_name,
		.set = py_netr_LogonUasLogon_in_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_workstation"),
		.get = py_netr_LogonUasLogon_in_get_workstation,
		.set = py_netr_LogonUasLogon_in_set_workstation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_netr_LogonUasLogon_out_get_info,
		.set = py_netr_LogonUasLogon_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_UasInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_netr_LogonUasLogon_get_result,
		.set = py_netr_LogonUasLogon_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_netr_LogonUasLogon_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct netr_LogonUasLogon, type);
	struct netr_LogonUasLogon *_self = (struct netr_LogonUasLogon *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.info = talloc_zero(mem_ctx, struct netr_UasInfo *);
	return self;
}

static PyObject *py_netr_LogonUasLogon_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_netr_LogonUasLogon_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_netlogon.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonUasLogon_ndr_pack");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_netr_LogonUasLogon_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_netr_LogonUasLogon_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_netr_LogonUasLogon_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_netr_LogonUasLogon_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_netr_LogonUasLogon_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_netlogon.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonUasLogon_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_netr_LogonUasLogon_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_netr_LogonUasLogon_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_netr_LogonUasLogon_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_netr_LogonUasLogon_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_netr_LogonUasLogon_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonUasLogon *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_netlogon.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonUasLogon_ndr_print");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_netr_LogonUasLogon_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_netr_LogonUasLogon_ndr_print(py_obj, args, kwargs, "netr_LogonUasLogon_in", NDR_IN);
}

static PyObject *py_netr_LogonUasLogon_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_netr_LogonUasLogon_ndr_print(py_obj, args, kwargs, "netr_LogonUasLogon_out", NDR_OUT);
}

static PyMethodDef py_netr_LogonUasLogon_methods[] = {
	{ "opnum", (PyCFunction)py_netr_LogonUasLogon_ndr_opnum, METH_NOARGS|METH_CLASS,
		"netlogon.netr_LogonUasLogon.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogon_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogon_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogon_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogon_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogon_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogon_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_LogonUasLogon_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_LogonUasLogon",
	.tp_getset = py_netr_LogonUasLogon_getsetters,
	.tp_methods = py_netr_LogonUasLogon_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LogonUasLogon_new,
};

static bool pack_py_netr_LogonUasLogon_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonUasLogon *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_workstation;
	const char *kwnames[] = {
		"server_name", "account_name", "workstation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonUasLogon", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_workstation)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_account_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.account_name");
		return false;
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (r->in.account_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_account_name)) {
			unicode = PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_account_name)) {
			test_str = PyBytes_AS_STRING(py_account_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.account_name = talloc_str;
	}
	if (py_workstation == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.workstation");
		return false;
	}
	r->in.workstation = talloc_ptrtype(r, r->in.workstation);
	if (r->in.workstation == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_workstation)) {
			unicode = PyUnicode_AsEncodedString(py_workstation, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_workstation)) {
			test_str = PyBytes_AS_STRING(py_workstation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_workstation)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.workstation = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonUasLogon_args_out(struct netr_LogonUasLogon *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_UasInfo_Type, *r->out.info, *r->out.info);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_info);
	}
	if (result_size == 1) {
		result = py_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_netr_LogonUasLogoff_in_get_server_name(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_netr_LogonUasLogoff_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonUasLogoff_in_get_account_name(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->in.account_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		py_account_name = PyUnicode_Decode(object->in.account_name, strlen(object->in.account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_netr_LogonUasLogoff_in_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.account_name");
		return -1;
	}
	object->in.account_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.account_name);
	if (object->in.account_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.account_name = talloc_str;
	}
	return 0;
}

static PyObject *py_netr_LogonUasLogoff_in_get_workstation(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(obj);
	PyObject *py_workstation;
	if (object->in.workstation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.workstation == NULL) {
		py_workstation = Py_None;
		Py_INCREF(py_workstation);
	} else {
		py_workstation = PyUnicode_Decode(object->in.workstation, strlen(object->in.workstation), "utf-8", "ignore");
	}
	return py_workstation;
}

static int py_netr_LogonUasLogoff_in_set_workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.workstation");
		return -1;
	}
	object->in.workstation = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.workstation);
	if (object->in.workstation == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.workstation = talloc_str;
	}
	return 0;
}

static PyObject *py_netr_LogonUasLogoff_out_get_info(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pytalloc_reference_ex(&netr_UasLogoffInfo_Type, object->out.info, object->out.info);
	return py_info;
}

static int py_netr_LogonUasLogoff_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&netr_UasLogoffInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.info = (struct netr_UasLogoffInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_LogonUasLogoff_get_result(PyObject *obj, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_netr_LogonUasLogoff_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_netr_LogonUasLogoff_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_netr_LogonUasLogoff_in_get_server_name,
		.set = py_netr_LogonUasLogoff_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_account_name"),
		.get = py_netr_LogonUasLogoff_in_get_account_name,
		.set = py_netr_LogonUasLogoff_in_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_workstation"),
		.get = py_netr_LogonUasLogoff_in_get_workstation,
		.set = py_netr_LogonUasLogoff_in_set_workstation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_netr_LogonUasLogoff_out_get_info,
		.set = py_netr_LogonUasLogoff_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_UasLogoffInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_netr_LogonUasLogoff_get_result,
		.set = py_netr_LogonUasLogoff_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_netr_LogonUasLogoff_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct netr_LogonUasLogoff, type);
	struct netr_LogonUasLogoff *_self = (struct netr_LogonUasLogoff *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.info = talloc_zero(mem_ctx, struct netr_UasLogoffInfo);
	return self;
}

static PyObject *py_netr_LogonUasLogoff_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_netr_LogonUasLogoff_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_netlogon.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonUasLogoff_ndr_pack");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_netr_LogonUasLogoff_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_netr_LogonUasLogoff_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_netr_LogonUasLogoff_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_netr_LogonUasLogoff_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_netr_LogonUasLogoff_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_netlogon.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonUasLogoff_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_netr_LogonUasLogoff_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_netr_LogonUasLogoff_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_netr_LogonUasLogoff_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_netr_LogonUasLogoff_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_netr_LogonUasLogoff_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonUasLogoff *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_netlogon.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonUasLogoff_ndr_print");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_netr_LogonUasLogoff_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_netr_LogonUasLogoff_ndr_print(py_obj, args, kwargs, "netr_LogonUasLogoff_in", NDR_IN);
}

static PyObject *py_netr_LogonUasLogoff_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_netr_LogonUasLogoff_ndr_print(py_obj, args, kwargs, "netr_LogonUasLogoff_out", NDR_OUT);
}

static PyMethodDef py_netr_LogonUasLogoff_methods[] = {
	{ "opnum", (PyCFunction)py_netr_LogonUasLogoff_ndr_opnum, METH_NOARGS|METH_CLASS,
		"netlogon.netr_LogonUasLogoff.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogoff_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogoff_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogoff_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogoff_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogoff_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonUasLogoff_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_LogonUasLogoff_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_LogonUasLogoff",
	.tp_getset = py_netr_LogonUasLogoff_getsetters,
	.tp_methods = py_netr_LogonUasLogoff_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LogonUasLogoff_new,
};

static bool pack_py_netr_LogonUasLogoff_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonUasLogoff *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_workstation;
	const char *kwnames[] = {
		"server_name", "account_name", "workstation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonUasLogoff", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_workstation)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_account_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.account_name");
		return false;
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (r->in.account_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_account_name)) {
			unicode = PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_account_name)) {
			test_str = PyBytes_AS_STRING(py_account_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.account_name = talloc_str;
	}
	if (py_workstation == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.workstation");
		return false;
	}
	r->in.workstation = talloc_ptrtype(r, r->in.workstation);
	if (r->in.workstation == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_workstation)) {
			unicode = PyUnicode_AsEncodedString(py_workstation, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_workstation)) {
			test_str = PyBytes_AS_STRING(py_workstation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_workstation)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.workstation = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonUasLogoff_args_out(struct netr_LogonUasLogoff *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_info = pytalloc_reference_ex(&netr_UasLogoffInfo_Type, r->out.info, r->out.info);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_info);
	}
	if (result_size == 1) {
		result = py_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_netr_LogonSamLogon_in_get_server_name(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_netr_LogonSamLogon_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_in_get_computer_name(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	if (object->in.computer_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.computer_name == NULL) {
		py_computer_name = Py_None;
		Py_INCREF(py_computer_name);
	} else {
		if (object->in.computer_name == NULL) {
			py_computer_name = Py_None;
			Py_INCREF(py_computer_name);
		} else {
			py_computer_name = PyUnicode_Decode(object->in.computer_name, strlen(object->in.computer_name), "utf-8", "ignore");
		}
	}
	return py_computer_name;
}

static int py_netr_LogonSamLogon_in_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.computer_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.computer_name = NULL;
	} else {
		object->in.computer_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.computer_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_in_get_credential(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_credential;
	if (object->in.credential == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.credential == NULL) {
		py_credential = Py_None;
		Py_INCREF(py_credential);
	} else {
		py_credential = pytalloc_reference_ex(&netr_Authenticator_Type, object->in.credential, object->in.credential);
	}
	return py_credential;
}

static int py_netr_LogonSamLogon_in_set_credential(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.credential));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.credential");
		return -1;
	}
	if (value == Py_None) {
		object->in.credential = NULL;
	} else {
		object->in.credential = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_in_get_return_authenticator(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_return_authenticator;
	if (object->in.return_authenticator == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
		Py_INCREF(py_return_authenticator);
	} else {
		py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, object->in.return_authenticator, object->in.return_authenticator);
	}
	return py_return_authenticator;
}

static int py_netr_LogonSamLogon_in_set_return_authenticator(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.return_authenticator));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.return_authenticator");
		return -1;
	}
	if (value == Py_None) {
		object->in.return_authenticator = NULL;
	} else {
		object->in.return_authenticator = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_out_get_return_authenticator(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_return_authenticator;
	if (object->out.return_authenticator == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
		Py_INCREF(py_return_authenticator);
	} else {
		py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, object->out.return_authenticator, object->out.return_authenticator);
	}
	return py_return_authenticator;
}

static int py_netr_LogonSamLogon_out_set_return_authenticator(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.return_authenticator));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.return_authenticator");
		return -1;
	}
	if (value == Py_None) {
		object->out.return_authenticator = NULL;
	} else {
		object->out.return_authenticator = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->out.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_in_get_logon_level(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_level;
	py_logon_level = PyLong_FromLong((uint16_t)(object->in.logon_level));
	return py_logon_level;
}

static int py_netr_LogonSamLogon_in_set_logon_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.logon_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.logon_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.logon_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_in_get_logon(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_logon;
	if (object->in.logon == NULL) {
		Py_RETURN_NONE;
	}
	py_logon = pyrpc_import_union(&netr_LogonLevel_Type, object->in.logon, object->in.logon_level, object->in.logon, "union netr_LogonLevel");
	if (py_logon == NULL) {
		return NULL;
	}
	return py_logon;
}

static int py_netr_LogonSamLogon_in_set_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.logon));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.logon");
		return -1;
	}
	object->in.logon = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.logon);
	if (object->in.logon == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union netr_LogonLevel *logon_switch_1;
		logon_switch_1 = (union netr_LogonLevel *)pyrpc_export_union(&netr_LogonLevel_Type, pytalloc_get_mem_ctx(py_obj), object->in.logon_level, value, "union netr_LogonLevel");
		if (logon_switch_1 == NULL) {
			return -1;
		}
		object->in.logon = logon_switch_1;
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_in_get_validation_level(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_validation_level;
	py_validation_level = PyLong_FromLong((uint16_t)(object->in.validation_level));
	return py_validation_level;
}

static int py_netr_LogonSamLogon_in_set_validation_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.validation_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.validation_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.validation_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_out_get_validation(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_validation;
	if (object->out.validation == NULL) {
		Py_RETURN_NONE;
	}
	py_validation = pyrpc_import_union(&netr_Validation_Type, object->out.validation, object->in.validation_level, object->out.validation, "union netr_Validation");
	if (py_validation == NULL) {
		return NULL;
	}
	return py_validation;
}

static int py_netr_LogonSamLogon_out_set_validation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.validation));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.validation");
		return -1;
	}
	object->out.validation = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.validation);
	if (object->out.validation == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union netr_Validation *validation_switch_1;
		validation_switch_1 = (union netr_Validation *)pyrpc_export_union(&netr_Validation_Type, pytalloc_get_mem_ctx(py_obj), object->in.validation_level, value, "union netr_Validation");
		if (validation_switch_1 == NULL) {
			return -1;
		}
		object->out.validation = validation_switch_1;
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_out_get_authoritative(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_authoritative;
	if (object->out.authoritative == NULL) {
		Py_RETURN_NONE;
	}
	py_authoritative = PyLong_FromLong((uint16_t)(*object->out.authoritative));
	return py_authoritative;
}

static int py_netr_LogonSamLogon_out_set_authoritative(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.authoritative));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.authoritative");
		return -1;
	}
	object->out.authoritative = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.authoritative);
	if (object->out.authoritative == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.authoritative));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.authoritative = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogon_get_result(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_netr_LogonSamLogon_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_netr_LogonSamLogon_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server_name"),
		.get = py_netr_LogonSamLogon_in_get_server_name,
		.set = py_netr_LogonSamLogon_in_set_server_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_computer_name"),
		.get = py_netr_LogonSamLogon_in_get_computer_name,
		.set = py_netr_LogonSamLogon_in_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_credential"),
		.get = py_netr_LogonSamLogon_in_get_credential,
		.set = py_netr_LogonSamLogon_in_set_credential,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Authenticator")
	},
	{
		.name = discard_const_p(char, "in_return_authenticator"),
		.get = py_netr_LogonSamLogon_in_get_return_authenticator,
		.set = py_netr_LogonSamLogon_in_set_return_authenticator,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Authenticator")
	},
	{
		.name = discard_const_p(char, "out_return_authenticator"),
		.get = py_netr_LogonSamLogon_out_get_return_authenticator,
		.set = py_netr_LogonSamLogon_out_set_return_authenticator,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Authenticator")
	},
	{
		.name = discard_const_p(char, "in_logon_level"),
		.get = py_netr_LogonSamLogon_in_get_logon_level,
		.set = py_netr_LogonSamLogon_in_set_logon_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LogonInfoClass")
	},
	{
		.name = discard_const_p(char, "in_logon"),
		.get = py_netr_LogonSamLogon_in_get_logon,
		.set = py_netr_LogonSamLogon_in_set_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_LogonLevel")
	},
	{
		.name = discard_const_p(char, "in_validation_level"),
		.get = py_netr_LogonSamLogon_in_get_validation_level,
		.set = py_netr_LogonSamLogon_in_set_validation_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_validation"),
		.get = py_netr_LogonSamLogon_out_get_validation,
		.set = py_netr_LogonSamLogon_out_set_validation,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Validation")
	},
	{
		.name = discard_const_p(char, "out_authoritative"),
		.get = py_netr_LogonSamLogon_out_get_authoritative,
		.set = py_netr_LogonSamLogon_out_set_authoritative,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_netr_LogonSamLogon_get_result,
		.set = py_netr_LogonSamLogon_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_netr_LogonSamLogon_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct netr_LogonSamLogon, type);
	struct netr_LogonSamLogon *_self = (struct netr_LogonSamLogon *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.logon = talloc_zero(mem_ctx, union netr_LogonLevel);
	_self->out.validation = talloc_zero(mem_ctx, union netr_Validation);
	_self->out.authoritative = talloc_zero(mem_ctx, uint8_t);
	return self;
}

static PyObject *py_netr_LogonSamLogon_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_netr_LogonSamLogon_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_netlogon.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonSamLogon_ndr_pack");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_netr_LogonSamLogon_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_netr_LogonSamLogon_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_netr_LogonSamLogon_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_netr_LogonSamLogon_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_netr_LogonSamLogon_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_netlogon.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonSamLogon_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_netr_LogonSamLogon_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_netr_LogonSamLogon_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_netr_LogonSamLogon_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_netr_LogonSamLogon_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_netr_LogonSamLogon_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct netr_LogonSamLogon *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_netlogon.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_netr_LogonSamLogon_ndr_print");
		return NULL;
	}
	call = &ndr_table_netlogon.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_netr_LogonSamLogon_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_netr_LogonSamLogon_ndr_print(py_obj, args, kwargs, "netr_LogonSamLogon_in", NDR_IN);
}

static PyObject *py_netr_LogonSamLogon_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_netr_LogonSamLogon_ndr_print(py_obj, args, kwargs, "netr_LogonSamLogon_out", NDR_OUT);
}

static PyMethodDef py_netr_LogonSamLogon_methods[] = {
	{ "opnum", (PyCFunction)py_netr_LogonSamLogon_ndr_opnum, METH_NOARGS|METH_CLASS,
		"netlogon.netr_LogonSamLogon.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonSamLogon_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonSamLogon_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonSamLogon_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonSamLogon_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonSamLogon_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netr_LogonSamLogon_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_LogonSamLogon_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "netlogon.netr_LogonSamLogon",
	.tp_getset = py_netr_LogonSamLogon_getsetters,
	.tp_methods = py_netr_LogonSamLogon_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LogonSamLogon_new,
};

static bool pack_py_netr_LogonSamLogon_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogon *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "logon_level", "logon", "validation_level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_LogonSamLogon", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_logon_level, &py_logon, &py_validation_level)) {
		return false;
	}

	if (py_server_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server_name");
		return false;
	}
	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_server_name)) {
				unicode = PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_server_name)) {
				test_str = PyBytes_AS_STRING(py_server_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.server_name = talloc_str;
		}
	}
	if (py_computer_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.computer_name");
		return false;
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_computer_name)) {
				unicode = PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_computer_name)) {
				test_str = PyBytes_AS_STRING(py_computer_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.computer_name = talloc_str;
		}
	}
	if (py_credential == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.credential");
		return false;
	}
	if (py_credential == Py_None) {
		r->in.credential = NULL;
	} else {
		r->in.credential = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	}
	if (py_return_authenticator == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.return_authenticator");
		return false;
	}
	if (py_return_authenticator == Py_None) {
		r->in.return_authenticator = NULL;
	} else {
		r->in.return_authenticator = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	}
	if (py_logon_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.logon_level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.logon_level));
		if (PyLong_Check(py_logon_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_logon_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.logon_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_logon == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.logon");
		return false;
	}
	r->in.logon = talloc_ptrtype(r, r->in.logon);
	if (r->in.logon == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union netr_LogonLevel *logon_switch_1;
		logon_switch_1 = (union netr_LogonLevel *)pyrpc_export_union(&netr_LogonLevel_Type, r, r->in.logon_level, py_logon, "union netr_LogonLevel");
		if (logon_switch_1 == NULL) {
			return false;
		}
		r->in.logon = logon_switch_1;
	}
	if (py_validation_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.validation_level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.validation_level));
		if (PyLong_Check(py_validation_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_validation_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.validation_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogon_args_out(struct netr_LogonSamLogon *r, bool raise_result_exception)
{
	PyObject *py_return_authenticator = NULL;
	PyObject *py_validation = NULL;
	PyObject *py_authoritative = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
		Py_INCREF(py_return_authenticator);
	} else {
		py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	}
	PyTuple_SetItem(result, 0, py_return_authenticator);

	py_validation = pyrpc_import_union(&netr_Validation_Type, r->out.validation, r->in.validation_level, r->out.validation, "union netr_Validation");
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_validation);

	py_authoritative = PyLong_FromLong((uint16_t)(*r->out.authoritative));
	PyTuple_SetItem(result, 2, py_authoritative);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_netr_LogonSamLogoff_in_get_server_name(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogoff *object = pytalloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->in.server_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server_name == NULL) {
		py_server_name = Py_None;
		Py_INCREF(py_server_name);
	} else {
		if (object->in.server_name == NULL) {
			py_server_name = Py_None;
			Py_INCREF(py_server_name);
		} else {
			py_server_name = PyUnicode_Decode(object->in.server_name, strlen(object->in.server_name), "utf-8", "ignore");
		}
	}
	return py_server_name;
}

static int py_netr_LogonSamLogoff_in_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LogonSamLogoff *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.server_name = NULL;
	} else {
		object->in.server_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.server_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netr_LogonSamLogoff_in_get_computer_name(PyObject *obj, void *closure)
{
	struct netr_LogonSamLogoff *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	if (object->in.computer_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.computer_name == NULL) {
		py_computer_name = Py_None;
		Py_INCREF(py_computer_name);
	} else {
		if (object->in.computer_name == NULL) {
			py_computer_name = Py_None;
			Py_INCREF(py_computer_name);
		} else {