/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_winspool.h"
#include "bin/default/librpc/gen_ndr/ndr_winspool_c.h"

/* iremotewinspool - client functions generated by pidl */

struct dcerpc_winspool_AsyncOpenPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncOpenPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncOpenPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncOpenPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncOpenPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncOpenPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCOPENPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncOpenPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncOpenPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncOpenPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncOpenPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncOpenPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncOpenPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncOpenPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCOPENPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncOpenPrinter_state {
	struct winspool_AsyncOpenPrinter orig;
	struct winspool_AsyncOpenPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncOpenPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncOpenPrinter_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_pPrinterName /* [in] [charset(UTF16),unique] */,
							 struct policy_handle *_pHandle /* [out] [ref] */,
							 const char *_pDatatype /* [in] [charset(UTF16),unique] */,
							 struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
							 uint32_t _AccessRequired /* [in]  */,
							 struct spoolss_UserLevelCtr *_pClientInfo /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncOpenPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncOpenPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pPrinterName = _pPrinterName;
	state->orig.in.pDatatype = _pDatatype;
	state->orig.in.pDevModeContainer = _pDevModeContainer;
	state->orig.in.AccessRequired = _AccessRequired;
	state->orig.in.pClientInfo = _pClientInfo;

	/* Out parameters */
	state->orig.out.pHandle = _pHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncOpenPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncOpenPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncOpenPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncOpenPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncOpenPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncOpenPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncOpenPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pHandle = *state->tmp.out.pHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncOpenPrinter_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_winspool_AsyncOpenPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncOpenPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncOpenPrinter(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_pPrinterName /* [in] [charset(UTF16),unique] */,
					  struct policy_handle *_pHandle /* [out] [ref] */,
					  const char *_pDatatype /* [in] [charset(UTF16),unique] */,
					  struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
					  uint32_t _AccessRequired /* [in]  */,
					  struct spoolss_UserLevelCtr *_pClientInfo /* [in] [ref] */,
					  WERROR *result)
{
	struct winspool_AsyncOpenPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.pPrinterName = _pPrinterName;
	r.in.pDatatype = _pDatatype;
	r.in.pDevModeContainer = _pDevModeContainer;
	r.in.AccessRequired = _AccessRequired;
	r.in.pClientInfo = _pClientInfo;

	/* Out parameters */
	r.out.pHandle = _pHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncOpenPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pHandle = *r.out.pHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddPrinter_state {
	struct winspool_AsyncAddPrinter orig;
	struct winspool_AsyncAddPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPrinter_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_pName /* [in] [charset(UTF16),unique] */,
							struct spoolss_SetPrinterInfoCtr *_pPrinterContainer /* [in] [ref] */,
							struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
							struct sec_desc_buf *_pSecurityContainer /* [in] [ref] */,
							struct spoolss_UserLevelCtr *_pClientInfo /* [in] [ref] */,
							struct policy_handle *_pHandle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pPrinterContainer = _pPrinterContainer;
	state->orig.in.pDevModeContainer = _pDevModeContainer;
	state->orig.in.pSecurityContainer = _pSecurityContainer;
	state->orig.in.pClientInfo = _pClientInfo;

	/* Out parameters */
	state->orig.out.pHandle = _pHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncAddPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pHandle = *state->tmp.out.pHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPrinter_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_winspool_AsyncAddPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPrinter(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_pName /* [in] [charset(UTF16),unique] */,
					 struct spoolss_SetPrinterInfoCtr *_pPrinterContainer /* [in] [ref] */,
					 struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
					 struct sec_desc_buf *_pSecurityContainer /* [in] [ref] */,
					 struct spoolss_UserLevelCtr *_pClientInfo /* [in] [ref] */,
					 struct policy_handle *_pHandle /* [out] [ref] */,
					 WERROR *result)
{
	struct winspool_AsyncAddPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pPrinterContainer = _pPrinterContainer;
	r.in.pDevModeContainer = _pDevModeContainer;
	r.in.pSecurityContainer = _pSecurityContainer;
	r.in.pClientInfo = _pClientInfo;

	/* Out parameters */
	r.out.pHandle = _pHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pHandle = *r.out.pHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSetJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSetJob *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETJOB, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetJob_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSetJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSetJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSetJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSetJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETJOB, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSetJob_state {
	struct winspool_AsyncSetJob orig;
	struct winspool_AsyncSetJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetJob_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hPrinter /* [in]  */,
						    uint32_t _JobId /* [in]  */,
						    struct spoolss_JobInfoContainer *_pJobContainer /* [in] [unique] */,
						    uint32_t _Command /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.JobId = _JobId;
	state->orig.in.pJobContainer = _pJobContainer;
	state->orig.in.Command = _Command;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSetJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetJob_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSetJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSetJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSetJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetJob_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_winspool_AsyncSetJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetJob(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hPrinter /* [in]  */,
				     uint32_t _JobId /* [in]  */,
				     struct spoolss_JobInfoContainer *_pJobContainer /* [in] [unique] */,
				     uint32_t _Command /* [in]  */,
				     WERROR *result)
{
	struct winspool_AsyncSetJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.JobId = _JobId;
	r.in.pJobContainer = _pJobContainer;
	r.in.Command = _Command;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSetJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetJob *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETJOB, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetJob_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETJOB, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetJob_state {
	struct winspool_AsyncGetJob orig;
	struct winspool_AsyncGetJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetJob_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hPrinter /* [in]  */,
						    uint32_t _JobId /* [in]  */,
						    uint32_t _Level /* [in]  */,
						    uint8_t *_pJob /* [in,out] [size_is(cbBuf),unique] */,
						    uint32_t _cbBuf /* [in]  */,
						    uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.JobId = _JobId;
	state->orig.in.Level = _Level;
	state->orig.in.pJob = _pJob;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pJob = _pJob;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetJob_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetJob_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pJob && state->tmp.out.pJob) {
		{
			size_t _copy_len_pJob;
			_copy_len_pJob = state->tmp.in.cbBuf;
			if (state->orig.out.pJob != state->tmp.out.pJob) {
				memcpy(state->orig.out.pJob, state->tmp.out.pJob, _copy_len_pJob * sizeof(*state->orig.out.pJob));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetJob_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_winspool_AsyncGetJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetJob(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hPrinter /* [in]  */,
				     uint32_t _JobId /* [in]  */,
				     uint32_t _Level /* [in]  */,
				     uint8_t *_pJob /* [in,out] [size_is(cbBuf),unique] */,
				     uint32_t _cbBuf /* [in]  */,
				     uint32_t *_pcbNeeded /* [out] [ref] */,
				     WERROR *result)
{
	struct winspool_AsyncGetJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.JobId = _JobId;
	r.in.Level = _Level;
	r.in.pJob = _pJob;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pJob = _pJob;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pJob && r.out.pJob) {
		{
			size_t _copy_len_pJob;
			_copy_len_pJob = r.in.cbBuf;
			if (_pJob != r.out.pJob) {
				memcpy(_pJob, r.out.pJob, _copy_len_pJob * sizeof(*_pJob));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumJobs_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumJobs_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumJobs_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumJobs *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumJobs_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumJobs_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMJOBS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumJobs_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumJobs_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumJobs_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumJobs_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumJobs_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumJobs_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumJobs *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMJOBS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumJobs_state {
	struct winspool_AsyncEnumJobs orig;
	struct winspool_AsyncEnumJobs tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumJobs_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumJobs_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle _hPrinter /* [in]  */,
						      uint32_t _FirstJob /* [in]  */,
						      uint32_t _NoJobs /* [in]  */,
						      uint32_t _Level /* [in]  */,
						      uint8_t *_pJob /* [in,out] [size_is(cbBuf),unique] */,
						      uint32_t _cbBuf /* [in]  */,
						      uint32_t *_pcbNeeded /* [out] [ref] */,
						      uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumJobs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumJobs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.FirstJob = _FirstJob;
	state->orig.in.NoJobs = _NoJobs;
	state->orig.in.Level = _Level;
	state->orig.in.pJob = _pJob;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pJob = _pJob;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumJobs_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumJobs_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumJobs_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumJobs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumJobs_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumJobs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumJobs_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pJob && state->tmp.out.pJob) {
		{
			size_t _copy_len_pJob;
			_copy_len_pJob = state->tmp.in.cbBuf;
			if (state->orig.out.pJob != state->tmp.out.pJob) {
				memcpy(state->orig.out.pJob, state->tmp.out.pJob, _copy_len_pJob * sizeof(*state->orig.out.pJob));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumJobs_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumJobs_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumJobs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumJobs(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle _hPrinter /* [in]  */,
				       uint32_t _FirstJob /* [in]  */,
				       uint32_t _NoJobs /* [in]  */,
				       uint32_t _Level /* [in]  */,
				       uint8_t *_pJob /* [in,out] [size_is(cbBuf),unique] */,
				       uint32_t _cbBuf /* [in]  */,
				       uint32_t *_pcbNeeded /* [out] [ref] */,
				       uint32_t *_pcReturned /* [out] [ref] */,
				       WERROR *result)
{
	struct winspool_AsyncEnumJobs r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.FirstJob = _FirstJob;
	r.in.NoJobs = _NoJobs;
	r.in.Level = _Level;
	r.in.pJob = _pJob;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pJob = _pJob;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumJobs_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pJob && r.out.pJob) {
		{
			size_t _copy_len_pJob;
			_copy_len_pJob = r.in.cbBuf;
			if (_pJob != r.out.pJob) {
				memcpy(_pJob, r.out.pJob, _copy_len_pJob * sizeof(*_pJob));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddJob *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDJOB, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddJob_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDJOB, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddJob_state {
	struct winspool_AsyncAddJob orig;
	struct winspool_AsyncAddJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddJob_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle _hPrinter /* [in]  */,
						    uint32_t _Level /* [in]  */,
						    uint8_t *_pAddJob /* [in,out] [size_is(cbBuf),unique] */,
						    uint32_t _cbBuf /* [in]  */,
						    uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.Level = _Level;
	state->orig.in.pAddJob = _pAddJob;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pAddJob = _pAddJob;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncAddJob_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddJob_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pAddJob && state->tmp.out.pAddJob) {
		{
			size_t _copy_len_pAddJob;
			_copy_len_pAddJob = state->tmp.in.cbBuf;
			if (state->orig.out.pAddJob != state->tmp.out.pAddJob) {
				memcpy(state->orig.out.pAddJob, state->tmp.out.pAddJob, _copy_len_pAddJob * sizeof(*state->orig.out.pAddJob));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddJob_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_winspool_AsyncAddJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddJob(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle _hPrinter /* [in]  */,
				     uint32_t _Level /* [in]  */,
				     uint8_t *_pAddJob /* [in,out] [size_is(cbBuf),unique] */,
				     uint32_t _cbBuf /* [in]  */,
				     uint32_t *_pcbNeeded /* [out] [ref] */,
				     WERROR *result)
{
	struct winspool_AsyncAddJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.Level = _Level;
	r.in.pAddJob = _pAddJob;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pAddJob = _pAddJob;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pAddJob && r.out.pAddJob) {
		{
			size_t _copy_len_pAddJob;
			_copy_len_pAddJob = r.in.cbBuf;
			if (_pAddJob != r.out.pAddJob) {
				memcpy(_pAddJob, r.out.pAddJob, _copy_len_pAddJob * sizeof(*_pAddJob));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncScheduleJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncScheduleJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncScheduleJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncScheduleJob *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncScheduleJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncScheduleJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSCHEDULEJOB, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncScheduleJob_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncScheduleJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncScheduleJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncScheduleJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncScheduleJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncScheduleJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncScheduleJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSCHEDULEJOB, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncScheduleJob_state {
	struct winspool_AsyncScheduleJob orig;
	struct winspool_AsyncScheduleJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncScheduleJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncScheduleJob_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hPrinter /* [in]  */,
							 uint32_t _JobId /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncScheduleJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncScheduleJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.JobId = _JobId;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncScheduleJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncScheduleJob_done, req);
	return req;
}

static void dcerpc_winspool_AsyncScheduleJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncScheduleJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncScheduleJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncScheduleJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncScheduleJob_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_winspool_AsyncScheduleJob_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncScheduleJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncScheduleJob(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hPrinter /* [in]  */,
					  uint32_t _JobId /* [in]  */,
					  WERROR *result)
{
	struct winspool_AsyncScheduleJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.JobId = _JobId;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncScheduleJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinter_state {
	struct winspool_AsyncDeletePrinter orig;
	struct winspool_AsyncDeletePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinter_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hPrinter /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinter_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinter(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hPrinter /* [in]  */,
					    WERROR *result)
{
	struct winspool_AsyncDeletePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSetPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSetPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSetPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSetPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSetPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSetPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSetPrinter_state {
	struct winspool_AsyncSetPrinter orig;
	struct winspool_AsyncSetPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPrinter_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hPrinter /* [in]  */,
							struct spoolss_SetPrinterInfoCtr *_pPrinterContainer /* [in] [ref] */,
							struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
							struct sec_desc_buf *_pSecurityContainer /* [in] [ref] */,
							uint32_t _Command /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pPrinterContainer = _pPrinterContainer;
	state->orig.in.pDevModeContainer = _pDevModeContainer;
	state->orig.in.pSecurityContainer = _pSecurityContainer;
	state->orig.in.Command = _Command;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSetPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSetPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSetPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPrinter_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_winspool_AsyncSetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPrinter(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hPrinter /* [in]  */,
					 struct spoolss_SetPrinterInfoCtr *_pPrinterContainer /* [in] [ref] */,
					 struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
					 struct sec_desc_buf *_pSecurityContainer /* [in] [ref] */,
					 uint32_t _Command /* [in]  */,
					 WERROR *result)
{
	struct winspool_AsyncSetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pPrinterContainer = _pPrinterContainer;
	r.in.pDevModeContainer = _pDevModeContainer;
	r.in.pSecurityContainer = _pSecurityContainer;
	r.in.Command = _Command;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSetPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetPrinter_state {
	struct winspool_AsyncGetPrinter orig;
	struct winspool_AsyncGetPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinter_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hPrinter /* [in]  */,
							uint32_t _Level /* [in]  */,
							uint8_t *_pPrinter /* [in,out] [size_is(cbBuf),unique] */,
							uint32_t _cbBuf /* [in]  */,
							uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.Level = _Level;
	state->orig.in.pPrinter = _pPrinter;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pPrinter = _pPrinter;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pPrinter && state->tmp.out.pPrinter) {
		{
			size_t _copy_len_pPrinter;
			_copy_len_pPrinter = state->tmp.in.cbBuf;
			if (state->orig.out.pPrinter != state->tmp.out.pPrinter) {
				memcpy(state->orig.out.pPrinter, state->tmp.out.pPrinter, _copy_len_pPrinter * sizeof(*state->orig.out.pPrinter));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinter_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_winspool_AsyncGetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinter(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hPrinter /* [in]  */,
					 uint32_t _Level /* [in]  */,
					 uint8_t *_pPrinter /* [in,out] [size_is(cbBuf),unique] */,
					 uint32_t _cbBuf /* [in]  */,
					 uint32_t *_pcbNeeded /* [out] [ref] */,
					 WERROR *result)
{
	struct winspool_AsyncGetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.Level = _Level;
	r.in.pPrinter = _pPrinter;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pPrinter = _pPrinter;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pPrinter && r.out.pPrinter) {
		{
			size_t _copy_len_pPrinter;
			_copy_len_pPrinter = r.in.cbBuf;
			if (_pPrinter != r.out.pPrinter) {
				memcpy(_pPrinter, r.out.pPrinter, _copy_len_pPrinter * sizeof(*_pPrinter));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncStartDocPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncStartDocPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncStartDocPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncStartDocPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncStartDocPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncStartDocPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSTARTDOCPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncStartDocPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncStartDocPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncStartDocPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncStartDocPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncStartDocPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncStartDocPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncStartDocPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSTARTDOCPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncStartDocPrinter_state {
	struct winspool_AsyncStartDocPrinter orig;
	struct winspool_AsyncStartDocPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncStartDocPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncStartDocPrinter_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle _hPrinter /* [in]  */,
							     struct spoolss_DocumentInfoCtr *_pDocInfoContainer /* [in] [ref] */,
							     uint32_t *_pJobId /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncStartDocPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncStartDocPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pDocInfoContainer = _pDocInfoContainer;

	/* Out parameters */
	state->orig.out.pJobId = _pJobId;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncStartDocPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncStartDocPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncStartDocPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncStartDocPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncStartDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncStartDocPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncStartDocPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pJobId = *state->tmp.out.pJobId;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncStartDocPrinter_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_winspool_AsyncStartDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncStartDocPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncStartDocPrinter(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle _hPrinter /* [in]  */,
					      struct spoolss_DocumentInfoCtr *_pDocInfoContainer /* [in] [ref] */,
					      uint32_t *_pJobId /* [out] [ref] */,
					      WERROR *result)
{
	struct winspool_AsyncStartDocPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pDocInfoContainer = _pDocInfoContainer;

	/* Out parameters */
	r.out.pJobId = _pJobId;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncStartDocPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pJobId = *r.out.pJobId;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncStartPagePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncStartPagePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncStartPagePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncStartPagePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncStartPagePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncStartPagePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSTARTPAGEPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncStartPagePrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncStartPagePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncStartPagePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncStartPagePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncStartPagePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncStartPagePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncStartPagePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSTARTPAGEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncStartPagePrinter_state {
	struct winspool_AsyncStartPagePrinter orig;
	struct winspool_AsyncStartPagePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncStartPagePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncStartPagePrinter_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hPrinter /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncStartPagePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncStartPagePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncStartPagePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncStartPagePrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncStartPagePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncStartPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncStartPagePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncStartPagePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncStartPagePrinter_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_winspool_AsyncStartPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncStartPagePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncStartPagePrinter(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hPrinter /* [in]  */,
					       WERROR *result)
{
	struct winspool_AsyncStartPagePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncStartPagePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncWritePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncWritePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncWritePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncWritePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncWritePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncWritePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCWRITEPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncWritePrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncWritePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncWritePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncWritePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncWritePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncWritePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncWritePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCWRITEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncWritePrinter_state {
	struct winspool_AsyncWritePrinter orig;
	struct winspool_AsyncWritePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncWritePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncWritePrinter_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hPrinter /* [in]  */,
							  uint8_t *_pBuf /* [in] [ref,size_is(cbBuf)] */,
							  uint32_t _cbBuf /* [in]  */,
							  uint32_t *_pcWritten /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncWritePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncWritePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pBuf = _pBuf;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pcWritten = _pcWritten;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncWritePrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncWritePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncWritePrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncWritePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncWritePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncWritePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncWritePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pcWritten = *state->tmp.out.pcWritten;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncWritePrinter_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winspool_AsyncWritePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncWritePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncWritePrinter(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hPrinter /* [in]  */,
					   uint8_t *_pBuf /* [in] [ref,size_is(cbBuf)] */,
					   uint32_t _cbBuf /* [in]  */,
					   uint32_t *_pcWritten /* [out] [ref] */,
					   WERROR *result)
{
	struct winspool_AsyncWritePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pBuf = _pBuf;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pcWritten = _pcWritten;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncWritePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pcWritten = *r.out.pcWritten;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEndPagePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEndPagePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEndPagePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEndPagePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEndPagePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEndPagePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENDPAGEPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEndPagePrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEndPagePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEndPagePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEndPagePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEndPagePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEndPagePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEndPagePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENDPAGEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEndPagePrinter_state {
	struct winspool_AsyncEndPagePrinter orig;
	struct winspool_AsyncEndPagePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEndPagePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEndPagePrinter_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle _hPrinter /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEndPagePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEndPagePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEndPagePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEndPagePrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEndPagePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEndPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEndPagePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEndPagePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEndPagePrinter_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_winspool_AsyncEndPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEndPagePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEndPagePrinter(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle _hPrinter /* [in]  */,
					     WERROR *result)
{
	struct winspool_AsyncEndPagePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEndPagePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEndDocPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEndDocPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEndDocPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEndDocPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEndDocPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEndDocPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENDDOCPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEndDocPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEndDocPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEndDocPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEndDocPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEndDocPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEndDocPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEndDocPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENDDOCPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEndDocPrinter_state {
	struct winspool_AsyncEndDocPrinter orig;
	struct winspool_AsyncEndDocPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEndDocPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEndDocPrinter_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hPrinter /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEndDocPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEndDocPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEndDocPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEndDocPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEndDocPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEndDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEndDocPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEndDocPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEndDocPrinter_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_winspool_AsyncEndDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEndDocPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEndDocPrinter(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hPrinter /* [in]  */,
					    WERROR *result)
{
	struct winspool_AsyncEndDocPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEndDocPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAbortPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAbortPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAbortPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAbortPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAbortPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAbortPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCABORTPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAbortPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAbortPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAbortPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAbortPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAbortPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAbortPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAbortPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCABORTPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAbortPrinter_state {
	struct winspool_AsyncAbortPrinter orig;
	struct winspool_AsyncAbortPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAbortPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAbortPrinter_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hPrinter /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAbortPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAbortPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAbortPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAbortPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAbortPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAbortPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAbortPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAbortPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAbortPrinter_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winspool_AsyncAbortPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAbortPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAbortPrinter(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hPrinter /* [in]  */,
					   WERROR *result)
{
	struct winspool_AsyncAbortPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAbortPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetPrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetPrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterData_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetPrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetPrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetPrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetPrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetPrinterData_state {
	struct winspool_AsyncGetPrinterData orig;
	struct winspool_AsyncGetPrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterData_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle _hPrinter /* [in]  */,
							    const char *_pValueName /* [in] [charset(UTF16),ref] */,
							    uint32_t *_pType /* [out] [ref] */,
							    uint8_t *_pData /* [out] [ref,size_is(nSize)] */,
							    uint32_t _nSize /* [in]  */,
							    uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pValueName = _pValueName;
	state->orig.in.nSize = _nSize;

	/* Out parameters */
	state->orig.out.pType = _pType;
	state->orig.out.pData = _pData;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetPrinterData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetPrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterData_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetPrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetPrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pType = *state->tmp.out.pType;
	{
		size_t _copy_len_pData;
		_copy_len_pData = state->tmp.in.nSize;
		if (state->orig.out.pData != state->tmp.out.pData) {
			memcpy(state->orig.out.pData, state->tmp.out.pData, _copy_len_pData * sizeof(*state->orig.out.pData));
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterData_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_winspool_AsyncGetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterData(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle _hPrinter /* [in]  */,
					     const char *_pValueName /* [in] [charset(UTF16),ref] */,
					     uint32_t *_pType /* [out] [ref] */,
					     uint8_t *_pData /* [out] [ref,size_is(nSize)] */,
					     uint32_t _nSize /* [in]  */,
					     uint32_t *_pcbNeeded /* [out] [ref] */,
					     WERROR *result)
{
	struct winspool_AsyncGetPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pValueName = _pValueName;
	r.in.nSize = _nSize;

	/* Out parameters */
	r.out.pType = _pType;
	r.out.pData = _pData;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetPrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pType = *r.out.pType;
	{
		size_t _copy_len_pData;
		_copy_len_pData = r.in.nSize;
		if (_pData != r.out.pData) {
			memcpy(_pData, r.out.pData, _copy_len_pData * sizeof(*_pData));
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetPrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetPrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDATAEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetPrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetPrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetPrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetPrinterDataEx_state {
	struct winspool_AsyncGetPrinterDataEx orig;
	struct winspool_AsyncGetPrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDataEx_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hPrinter /* [in]  */,
							      const char *_pKeyName /* [in] [charset(UTF16),ref] */,
							      const char *_pValueName /* [in] [charset(UTF16),ref] */,
							      uint32_t *_pType /* [out] [ref] */,
							      uint8_t *_pData /* [out] [ref,size_is(nSize)] */,
							      uint32_t _nSize /* [in]  */,
							      uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pKeyName = _pKeyName;
	state->orig.in.pValueName = _pValueName;
	state->orig.in.nSize = _nSize;

	/* Out parameters */
	state->orig.out.pType = _pType;
	state->orig.out.pData = _pData;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetPrinterDataEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetPrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDataEx_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetPrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pType = *state->tmp.out.pType;
	{
		size_t _copy_len_pData;
		_copy_len_pData = state->tmp.in.nSize;
		if (state->orig.out.pData != state->tmp.out.pData) {
			memcpy(state->orig.out.pData, state->tmp.out.pData, _copy_len_pData * sizeof(*state->orig.out.pData));
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDataEx_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_winspool_AsyncGetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDataEx(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hPrinter /* [in]  */,
					       const char *_pKeyName /* [in] [charset(UTF16),ref] */,
					       const char *_pValueName /* [in] [charset(UTF16),ref] */,
					       uint32_t *_pType /* [out] [ref] */,
					       uint8_t *_pData /* [out] [ref,size_is(nSize)] */,
					       uint32_t _nSize /* [in]  */,
					       uint32_t *_pcbNeeded /* [out] [ref] */,
					       WERROR *result)
{
	struct winspool_AsyncGetPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pKeyName = _pKeyName;
	r.in.pValueName = _pValueName;
	r.in.nSize = _nSize;

	/* Out parameters */
	r.out.pType = _pType;
	r.out.pData = _pData;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetPrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pType = *r.out.pType;
	{
		size_t _copy_len_pData;
		_copy_len_pData = r.in.nSize;
		if (_pData != r.out.pData) {
			memcpy(_pData, r.out.pData, _copy_len_pData * sizeof(*_pData));
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSetPrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSetPrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPRINTERDATA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPrinterData_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSetPrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSetPrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSetPrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSetPrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSetPrinterData_state {
	struct winspool_AsyncSetPrinterData orig;
	struct winspool_AsyncSetPrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPrinterData_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle _hPrinter /* [in]  */,
							    const char *_pValueName /* [in] [charset(UTF16),ref] */,
							    uint32_t _Type /* [in]  */,
							    uint8_t *_pData /* [in] [ref,size_is(cbData)] */,
							    uint32_t _cbData /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pValueName = _pValueName;
	state->orig.in.Type = _Type;
	state->orig.in.pData = _pData;
	state->orig.in.cbData = _cbData;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSetPrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPrinterData_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSetPrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSetPrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterData_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_winspool_AsyncSetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterData(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle _hPrinter /* [in]  */,
					     const char *_pValueName /* [in] [charset(UTF16),ref] */,
					     uint32_t _Type /* [in]  */,
					     uint8_t *_pData /* [in] [ref,size_is(cbData)] */,
					     uint32_t _cbData /* [in]  */,
					     WERROR *result)
{
	struct winspool_AsyncSetPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pValueName = _pValueName;
	r.in.Type = _Type;
	r.in.pData = _pData;
	r.in.cbData = _cbData;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSetPrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSetPrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSetPrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPRINTERDATAEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSetPrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSetPrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSetPrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSetPrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSetPrinterDataEx_state {
	struct winspool_AsyncSetPrinterDataEx orig;
	struct winspool_AsyncSetPrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPrinterDataEx_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hPrinter /* [in]  */,
							      const char *_pKeyName /* [in] [charset(UTF16),ref] */,
							      const char *_pValueName /* [in] [charset(UTF16),ref] */,
							      uint32_t _Type /* [in]  */,
							      uint8_t *_pData /* [in] [ref,size_is(cbData)] */,
							      uint32_t _cbData /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pKeyName = _pKeyName;
	state->orig.in.pValueName = _pValueName;
	state->orig.in.Type = _Type;
	state->orig.in.pData = _pData;
	state->orig.in.cbData = _cbData;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSetPrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPrinterDataEx_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSetPrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSetPrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterDataEx_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_winspool_AsyncSetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPrinterDataEx(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hPrinter /* [in]  */,
					       const char *_pKeyName /* [in] [charset(UTF16),ref] */,
					       const char *_pValueName /* [in] [charset(UTF16),ref] */,
					       uint32_t _Type /* [in]  */,
					       uint8_t *_pData /* [in] [ref,size_is(cbData)] */,
					       uint32_t _cbData /* [in]  */,
					       WERROR *result)
{
	struct winspool_AsyncSetPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pKeyName = _pKeyName;
	r.in.pValueName = _pValueName;
	r.in.Type = _Type;
	r.in.pData = _pData;
	r.in.cbData = _cbData;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSetPrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncClosePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncClosePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncClosePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncClosePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncClosePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncClosePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCCLOSEPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncClosePrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncClosePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncClosePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncClosePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncClosePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncClosePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncClosePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCCLOSEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncClosePrinter_state {
	struct winspool_AsyncClosePrinter orig;
	struct winspool_AsyncClosePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncClosePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncClosePrinter_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_phPrinter /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncClosePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncClosePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.phPrinter = _phPrinter;

	/* Out parameters */
	state->orig.out.phPrinter = _phPrinter;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncClosePrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncClosePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncClosePrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncClosePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncClosePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncClosePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncClosePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.phPrinter = *state->tmp.out.phPrinter;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncClosePrinter_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winspool_AsyncClosePrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncClosePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncClosePrinter(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_phPrinter /* [in,out] [ref] */,
					   WERROR *result)
{
	struct winspool_AsyncClosePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.phPrinter = _phPrinter;

	/* Out parameters */
	r.out.phPrinter = _phPrinter;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncClosePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_phPrinter = *r.out.phPrinter;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddForm *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDFORM, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddForm_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDFORM, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddForm_state {
	struct winspool_AsyncAddForm orig;
	struct winspool_AsyncAddForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddForm_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hPrinter /* [in]  */,
						     struct spoolss_AddFormInfoCtr *_pFormInfoContainer /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pFormInfoContainer = _pFormInfoContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddForm_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddForm_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winspool_AsyncAddForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddForm(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hPrinter /* [in]  */,
				      struct spoolss_AddFormInfoCtr *_pFormInfoContainer /* [in] [ref] */,
				      WERROR *result)
{
	struct winspool_AsyncAddForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pFormInfoContainer = _pFormInfoContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeleteForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeleteForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeleteForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeleteForm *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeleteForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeleteForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEFORM, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeleteForm_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeleteForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeleteForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeleteForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeleteForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeleteForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeleteForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEFORM, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeleteForm_state {
	struct winspool_AsyncDeleteForm orig;
	struct winspool_AsyncDeleteForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeleteForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeleteForm_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hPrinter /* [in]  */,
							const char *_pFormName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeleteForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeleteForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pFormName = _pFormName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeleteForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeleteForm_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeleteForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeleteForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeleteForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeleteForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeleteForm_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_winspool_AsyncDeleteForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeleteForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeleteForm(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hPrinter /* [in]  */,
					 const char *_pFormName /* [in] [charset(UTF16),ref] */,
					 WERROR *result)
{
	struct winspool_AsyncDeleteForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pFormName = _pFormName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeleteForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetForm *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETFORM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetForm_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETFORM, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetForm_state {
	struct winspool_AsyncGetForm orig;
	struct winspool_AsyncGetForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetForm_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hPrinter /* [in]  */,
						     const char *_pFormName /* [in] [charset(UTF16),ref] */,
						     uint32_t _Level /* [in]  */,
						     uint8_t *_pForm /* [in,out] [size_is(cbBuf),unique] */,
						     uint32_t _cbBuf /* [in]  */,
						     uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pFormName = _pFormName;
	state->orig.in.Level = _Level;
	state->orig.in.pForm = _pForm;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pForm = _pForm;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetForm_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetForm_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pForm && state->tmp.out.pForm) {
		{
			size_t _copy_len_pForm;
			_copy_len_pForm = state->tmp.in.cbBuf;
			if (state->orig.out.pForm != state->tmp.out.pForm) {
				memcpy(state->orig.out.pForm, state->tmp.out.pForm, _copy_len_pForm * sizeof(*state->orig.out.pForm));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetForm_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winspool_AsyncGetForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetForm(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hPrinter /* [in]  */,
				      const char *_pFormName /* [in] [charset(UTF16),ref] */,
				      uint32_t _Level /* [in]  */,
				      uint8_t *_pForm /* [in,out] [size_is(cbBuf),unique] */,
				      uint32_t _cbBuf /* [in]  */,
				      uint32_t *_pcbNeeded /* [out] [ref] */,
				      WERROR *result)
{
	struct winspool_AsyncGetForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pFormName = _pFormName;
	r.in.Level = _Level;
	r.in.pForm = _pForm;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pForm = _pForm;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pForm && r.out.pForm) {
		{
			size_t _copy_len_pForm;
			_copy_len_pForm = r.in.cbBuf;
			if (_pForm != r.out.pForm) {
				memcpy(_pForm, r.out.pForm, _copy_len_pForm * sizeof(*_pForm));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSetForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSetForm *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETFORM, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetForm_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSetForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSetForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSetForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSetForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETFORM, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSetForm_state {
	struct winspool_AsyncSetForm orig;
	struct winspool_AsyncSetForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetForm_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hPrinter /* [in]  */,
						     const char *_pFormName /* [in] [charset(UTF16),ref] */,
						     struct spoolss_AddFormInfoCtr *_pFormInfoContainer /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pFormName = _pFormName;
	state->orig.in.pFormInfoContainer = _pFormInfoContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSetForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetForm_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSetForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSetForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSetForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetForm_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winspool_AsyncSetForm_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetForm(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hPrinter /* [in]  */,
				      const char *_pFormName /* [in] [charset(UTF16),ref] */,
				      struct spoolss_AddFormInfoCtr *_pFormInfoContainer /* [in] [ref] */,
				      WERROR *result)
{
	struct winspool_AsyncSetForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pFormName = _pFormName;
	r.in.pFormInfoContainer = _pFormInfoContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSetForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumForms_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumForms_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumForms_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumForms *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumForms_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumForms_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMFORMS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumForms_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumForms_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumForms_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumForms_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumForms_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumForms_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumForms *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMFORMS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumForms_state {
	struct winspool_AsyncEnumForms orig;
	struct winspool_AsyncEnumForms tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumForms_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumForms_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hPrinter /* [in]  */,
						       uint32_t _Level /* [in]  */,
						       uint8_t *_pForm /* [in,out] [size_is(cbBuf),unique] */,
						       uint32_t _cbBuf /* [in]  */,
						       uint32_t *_pcbNeeded /* [out] [ref] */,
						       uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumForms_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumForms_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.Level = _Level;
	state->orig.in.pForm = _pForm;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pForm = _pForm;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumForms_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumForms_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumForms_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumForms_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumForms_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumForms_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumForms_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pForm && state->tmp.out.pForm) {
		{
			size_t _copy_len_pForm;
			_copy_len_pForm = state->tmp.in.cbBuf;
			if (state->orig.out.pForm != state->tmp.out.pForm) {
				memcpy(state->orig.out.pForm, state->tmp.out.pForm, _copy_len_pForm * sizeof(*state->orig.out.pForm));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumForms_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumForms_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumForms_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumForms(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hPrinter /* [in]  */,
					uint32_t _Level /* [in]  */,
					uint8_t *_pForm /* [in,out] [size_is(cbBuf),unique] */,
					uint32_t _cbBuf /* [in]  */,
					uint32_t *_pcbNeeded /* [out] [ref] */,
					uint32_t *_pcReturned /* [out] [ref] */,
					WERROR *result)
{
	struct winspool_AsyncEnumForms r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.Level = _Level;
	r.in.pForm = _pForm;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pForm = _pForm;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumForms_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pForm && r.out.pForm) {
		{
			size_t _copy_len_pForm;
			_copy_len_pForm = r.in.cbBuf;
			if (_pForm != r.out.pForm) {
				memcpy(_pForm, r.out.pForm, _copy_len_pForm * sizeof(*_pForm));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetPrinterDriver_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDriver_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDriver_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetPrinterDriver *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDriver_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDriver_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDRIVER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDriver_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDriver_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriver_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetPrinterDriver_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetPrinterDriver_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriver_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetPrinterDriver *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDRIVER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetPrinterDriver_state {
	struct winspool_AsyncGetPrinterDriver orig;
	struct winspool_AsyncGetPrinterDriver tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDriver_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDriver_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hPrinter /* [in]  */,
							      const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
							      uint32_t _Level /* [in]  */,
							      uint8_t *_pDriver /* [in,out] [size_is(cbBuf),unique] */,
							      uint32_t _cbBuf /* [in]  */,
							      uint32_t *_pcbNeeded /* [out] [ref] */,
							      uint32_t _dwClientMajorVersion /* [in]  */,
							      uint32_t _dwClientMinorVersion /* [in]  */,
							      uint32_t *_pdwServerMaxVersion /* [out] [ref] */,
							      uint32_t *_pdwServerMinVersion /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDriver_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDriver_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.Level = _Level;
	state->orig.in.pDriver = _pDriver;
	state->orig.in.cbBuf = _cbBuf;
	state->orig.in.dwClientMajorVersion = _dwClientMajorVersion;
	state->orig.in.dwClientMinorVersion = _dwClientMinorVersion;

	/* Out parameters */
	state->orig.out.pDriver = _pDriver;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pdwServerMaxVersion = _pdwServerMaxVersion;
	state->orig.out.pdwServerMinVersion = _pdwServerMinVersion;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetPrinterDriver_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetPrinterDriver_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDriver_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDriver_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDriver_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetPrinterDriver_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pDriver && state->tmp.out.pDriver) {
		{
			size_t _copy_len_pDriver;
			_copy_len_pDriver = state->tmp.in.cbBuf;
			if (state->orig.out.pDriver != state->tmp.out.pDriver) {
				memcpy(state->orig.out.pDriver, state->tmp.out.pDriver, _copy_len_pDriver * sizeof(*state->orig.out.pDriver));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pdwServerMaxVersion = *state->tmp.out.pdwServerMaxVersion;
	*state->orig.out.pdwServerMinVersion = *state->tmp.out.pdwServerMinVersion;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriver_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_winspool_AsyncGetPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDriver_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriver(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hPrinter /* [in]  */,
					       const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
					       uint32_t _Level /* [in]  */,
					       uint8_t *_pDriver /* [in,out] [size_is(cbBuf),unique] */,
					       uint32_t _cbBuf /* [in]  */,
					       uint32_t *_pcbNeeded /* [out] [ref] */,
					       uint32_t _dwClientMajorVersion /* [in]  */,
					       uint32_t _dwClientMinorVersion /* [in]  */,
					       uint32_t *_pdwServerMaxVersion /* [out] [ref] */,
					       uint32_t *_pdwServerMinVersion /* [out] [ref] */,
					       WERROR *result)
{
	struct winspool_AsyncGetPrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pEnvironment = _pEnvironment;
	r.in.Level = _Level;
	r.in.pDriver = _pDriver;
	r.in.cbBuf = _cbBuf;
	r.in.dwClientMajorVersion = _dwClientMajorVersion;
	r.in.dwClientMinorVersion = _dwClientMinorVersion;

	/* Out parameters */
	r.out.pDriver = _pDriver;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pdwServerMaxVersion = _pdwServerMaxVersion;
	r.out.pdwServerMinVersion = _pdwServerMinVersion;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetPrinterDriver_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pDriver && r.out.pDriver) {
		{
			size_t _copy_len_pDriver;
			_copy_len_pDriver = r.in.cbBuf;
			if (_pDriver != r.out.pDriver) {
				memcpy(_pDriver, r.out.pDriver, _copy_len_pDriver * sizeof(*_pDriver));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pdwServerMaxVersion = *r.out.pdwServerMaxVersion;
	*_pdwServerMinVersion = *r.out.pdwServerMinVersion;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterData_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPrinterData_state {
	struct winspool_AsyncEnumPrinterData orig;
	struct winspool_AsyncEnumPrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterData_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle _hPrinter /* [in]  */,
							     uint32_t _dwIndex /* [in]  */,
							     uint16_t *_pValueName /* [out] [ref,size_is(cbValueName/2)] */,
							     uint32_t _cbValueName /* [in]  */,
							     uint32_t *_pcbValueName /* [out] [ref] */,
							     uint32_t *_pType /* [out] [ref] */,
							     uint8_t *_pData /* [out] [ref,size_is(cbData)] */,
							     uint32_t _cbData /* [in]  */,
							     uint32_t *_pcbData /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.dwIndex = _dwIndex;
	state->orig.in.cbValueName = _cbValueName;
	state->orig.in.cbData = _cbData;

	/* Out parameters */
	state->orig.out.pValueName = _pValueName;
	state->orig.out.pcbValueName = _pcbValueName;
	state->orig.out.pType = _pType;
	state->orig.out.pData = _pData;
	state->orig.out.pcbData = _pcbData;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPrinterData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterData_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_pValueName;
		_copy_len_pValueName = state->tmp.in.cbValueName / 2;
		if (state->orig.out.pValueName != state->tmp.out.pValueName) {
			memcpy(state->orig.out.pValueName, state->tmp.out.pValueName, _copy_len_pValueName * sizeof(*state->orig.out.pValueName));
		}
	}
	*state->orig.out.pcbValueName = *state->tmp.out.pcbValueName;
	*state->orig.out.pType = *state->tmp.out.pType;
	{
		size_t _copy_len_pData;
		_copy_len_pData = state->tmp.in.cbData;
		if (state->orig.out.pData != state->tmp.out.pData) {
			memcpy(state->orig.out.pData, state->tmp.out.pData, _copy_len_pData * sizeof(*state->orig.out.pData));
		}
	}
	*state->orig.out.pcbData = *state->tmp.out.pcbData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterData_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterData(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle _hPrinter /* [in]  */,
					      uint32_t _dwIndex /* [in]  */,
					      uint16_t *_pValueName /* [out] [ref,size_is(cbValueName/2)] */,
					      uint32_t _cbValueName /* [in]  */,
					      uint32_t *_pcbValueName /* [out] [ref] */,
					      uint32_t *_pType /* [out] [ref] */,
					      uint8_t *_pData /* [out] [ref,size_is(cbData)] */,
					      uint32_t _cbData /* [in]  */,
					      uint32_t *_pcbData /* [out] [ref] */,
					      WERROR *result)
{
	struct winspool_AsyncEnumPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.dwIndex = _dwIndex;
	r.in.cbValueName = _cbValueName;
	r.in.cbData = _cbData;

	/* Out parameters */
	r.out.pValueName = _pValueName;
	r.out.pcbValueName = _pcbValueName;
	r.out.pType = _pType;
	r.out.pData = _pData;
	r.out.pcbData = _pcbData;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_pValueName;
		_copy_len_pValueName = r.in.cbValueName / 2;
		if (_pValueName != r.out.pValueName) {
			memcpy(_pValueName, r.out.pValueName, _copy_len_pValueName * sizeof(*_pValueName));
		}
	}
	*_pcbValueName = *r.out.pcbValueName;
	*_pType = *r.out.pType;
	{
		size_t _copy_len_pData;
		_copy_len_pData = r.in.cbData;
		if (_pData != r.out.pData) {
			memcpy(_pData, r.out.pData, _copy_len_pData * sizeof(*_pData));
		}
	}
	*_pcbData = *r.out.pcbData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERDATAEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPrinterDataEx_state {
	struct winspool_AsyncEnumPrinterDataEx orig;
	struct winspool_AsyncEnumPrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterDataEx_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle _hPrinter /* [in]  */,
							       const char *_pKeyName /* [in] [charset(UTF16),ref] */,
							       uint8_t *_pEnumValues /* [out] [ref,size_is(cbEnumValues)] */,
							       uint32_t _cbEnumValues /* [in]  */,
							       uint32_t *_pcbEnumValues /* [out] [ref] */,
							       uint32_t *_pnEnumValues /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pKeyName = _pKeyName;
	state->orig.in.cbEnumValues = _cbEnumValues;

	/* Out parameters */
	state->orig.out.pEnumValues = _pEnumValues;
	state->orig.out.pcbEnumValues = _pcbEnumValues;
	state->orig.out.pnEnumValues = _pnEnumValues;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPrinterDataEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterDataEx_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_pEnumValues;
		_copy_len_pEnumValues = state->tmp.in.cbEnumValues;
		if (state->orig.out.pEnumValues != state->tmp.out.pEnumValues) {
			memcpy(state->orig.out.pEnumValues, state->tmp.out.pEnumValues, _copy_len_pEnumValues * sizeof(*state->orig.out.pEnumValues));
		}
	}
	*state->orig.out.pcbEnumValues = *state->tmp.out.pcbEnumValues;
	*state->orig.out.pnEnumValues = *state->tmp.out.pnEnumValues;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDataEx_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDataEx(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle _hPrinter /* [in]  */,
						const char *_pKeyName /* [in] [charset(UTF16),ref] */,
						uint8_t *_pEnumValues /* [out] [ref,size_is(cbEnumValues)] */,
						uint32_t _cbEnumValues /* [in]  */,
						uint32_t *_pcbEnumValues /* [out] [ref] */,
						uint32_t *_pnEnumValues /* [out] [ref] */,
						WERROR *result)
{
	struct winspool_AsyncEnumPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pKeyName = _pKeyName;
	r.in.cbEnumValues = _cbEnumValues;

	/* Out parameters */
	r.out.pEnumValues = _pEnumValues;
	r.out.pcbEnumValues = _pcbEnumValues;
	r.out.pnEnumValues = _pnEnumValues;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_pEnumValues;
		_copy_len_pEnumValues = r.in.cbEnumValues;
		if (_pEnumValues != r.out.pEnumValues) {
			memcpy(_pEnumValues, r.out.pEnumValues, _copy_len_pEnumValues * sizeof(*_pEnumValues));
		}
	}
	*_pcbEnumValues = *r.out.pcbEnumValues;
	*_pnEnumValues = *r.out.pnEnumValues;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPrinterKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPrinterKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterKey_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPrinterKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPrinterKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPrinterKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPrinterKey_state {
	struct winspool_AsyncEnumPrinterKey orig;
	struct winspool_AsyncEnumPrinterKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterKey_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle _hPrinter /* [in]  */,
							    const char *_pKeyName /* [in] [charset(UTF16),ref] */,
							    uint16_t *_pSubkey /* [out] [ref,size_is(cbSubkey/2)] */,
							    uint32_t _cbSubkey /* [in]  */,
							    uint32_t *_pcbSubkey /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pKeyName = _pKeyName;
	state->orig.in.cbSubkey = _cbSubkey;

	/* Out parameters */
	state->orig.out.pSubkey = _pSubkey;
	state->orig.out.pcbSubkey = _pcbSubkey;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPrinterKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPrinterKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterKey_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPrinterKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_pSubkey;
		_copy_len_pSubkey = state->tmp.in.cbSubkey / 2;
		if (state->orig.out.pSubkey != state->tmp.out.pSubkey) {
			memcpy(state->orig.out.pSubkey, state->tmp.out.pSubkey, _copy_len_pSubkey * sizeof(*state->orig.out.pSubkey));
		}
	}
	*state->orig.out.pcbSubkey = *state->tmp.out.pcbSubkey;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterKey_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterKey(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle _hPrinter /* [in]  */,
					     const char *_pKeyName /* [in] [charset(UTF16),ref] */,
					     uint16_t *_pSubkey /* [out] [ref,size_is(cbSubkey/2)] */,
					     uint32_t _cbSubkey /* [in]  */,
					     uint32_t *_pcbSubkey /* [out] [ref] */,
					     WERROR *result)
{
	struct winspool_AsyncEnumPrinterKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pKeyName = _pKeyName;
	r.in.cbSubkey = _cbSubkey;

	/* Out parameters */
	r.out.pSubkey = _pSubkey;
	r.out.pcbSubkey = _pcbSubkey;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPrinterKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_pSubkey;
		_copy_len_pSubkey = r.in.cbSubkey / 2;
		if (_pSubkey != r.out.pSubkey) {
			memcpy(_pSubkey, r.out.pSubkey, _copy_len_pSubkey * sizeof(*_pSubkey));
		}
	}
	*_pcbSubkey = *r.out.pcbSubkey;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDATA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterData_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinterData_state {
	struct winspool_AsyncDeletePrinterData orig;
	struct winspool_AsyncDeletePrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterData_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle _hPrinter /* [in]  */,
							       const char *_pValueName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pValueName = _pValueName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterData_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterData_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrinterData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterData(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle _hPrinter /* [in]  */,
						const char *_pValueName /* [in] [charset(UTF16),ref] */,
						WERROR *result)
{
	struct winspool_AsyncDeletePrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pValueName = _pValueName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDATAEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinterDataEx_state {
	struct winspool_AsyncDeletePrinterDataEx orig;
	struct winspool_AsyncDeletePrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDataEx_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct policy_handle _hPrinter /* [in]  */,
								 const char *_pKeyName /* [in] [charset(UTF16),ref] */,
								 const char *_pValueName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pKeyName = _pKeyName;
	state->orig.in.pValueName = _pValueName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDataEx_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDataEx_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDataEx(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle _hPrinter /* [in]  */,
						  const char *_pKeyName /* [in] [charset(UTF16),ref] */,
						  const char *_pValueName /* [in] [charset(UTF16),ref] */,
						  WERROR *result)
{
	struct winspool_AsyncDeletePrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pKeyName = _pKeyName;
	r.in.pValueName = _pValueName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinterKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinterKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterKey_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinterKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinterKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinterKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinterKey_state {
	struct winspool_AsyncDeletePrinterKey orig;
	struct winspool_AsyncDeletePrinterKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterKey_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hPrinter /* [in]  */,
							      const char *_pKeyName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pKeyName = _pKeyName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinterKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterKey_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinterKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterKey_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterKey(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hPrinter /* [in]  */,
					       const char *_pKeyName /* [in] [charset(UTF16),ref] */,
					       WERROR *result)
{
	struct winspool_AsyncDeletePrinterKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pKeyName = _pKeyName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinterKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncXcvData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncXcvData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncXcvData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncXcvData *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncXcvData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncXcvData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCXCVDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncXcvData_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncXcvData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncXcvData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncXcvData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncXcvData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncXcvData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncXcvData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCXCVDATA, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncXcvData_state {
	struct winspool_AsyncXcvData orig;
	struct winspool_AsyncXcvData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncXcvData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncXcvData_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _hXcv /* [in]  */,
						     const char *_pszDataName /* [in] [charset(UTF16),ref] */,
						     uint8_t *_pInputData /* [in] [ref,size_is(cbInputData)] */,
						     uint32_t _cbInputData /* [in]  */,
						     uint8_t *_pOutputData /* [out] [ref,size_is(cbOutputData)] */,
						     uint32_t _cbOutputData /* [in]  */,
						     uint32_t *_pcbOutputNeeded /* [out] [ref] */,
						     uint32_t *_pdwStatus /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncXcvData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncXcvData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hXcv = _hXcv;
	state->orig.in.pszDataName = _pszDataName;
	state->orig.in.pInputData = _pInputData;
	state->orig.in.cbInputData = _cbInputData;
	state->orig.in.cbOutputData = _cbOutputData;
	state->orig.in.pdwStatus = _pdwStatus;

	/* Out parameters */
	state->orig.out.pOutputData = _pOutputData;
	state->orig.out.pcbOutputNeeded = _pcbOutputNeeded;
	state->orig.out.pdwStatus = _pdwStatus;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncXcvData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncXcvData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncXcvData_done, req);
	return req;
}

static void dcerpc_winspool_AsyncXcvData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncXcvData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncXcvData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncXcvData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_pOutputData;
		_copy_len_pOutputData = state->tmp.in.cbOutputData;
		if (state->orig.out.pOutputData != state->tmp.out.pOutputData) {
			memcpy(state->orig.out.pOutputData, state->tmp.out.pOutputData, _copy_len_pOutputData * sizeof(*state->orig.out.pOutputData));
		}
	}
	*state->orig.out.pcbOutputNeeded = *state->tmp.out.pcbOutputNeeded;
	*state->orig.out.pdwStatus = *state->tmp.out.pdwStatus;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncXcvData_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winspool_AsyncXcvData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncXcvData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncXcvData(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _hXcv /* [in]  */,
				      const char *_pszDataName /* [in] [charset(UTF16),ref] */,
				      uint8_t *_pInputData /* [in] [ref,size_is(cbInputData)] */,
				      uint32_t _cbInputData /* [in]  */,
				      uint8_t *_pOutputData /* [out] [ref,size_is(cbOutputData)] */,
				      uint32_t _cbOutputData /* [in]  */,
				      uint32_t *_pcbOutputNeeded /* [out] [ref] */,
				      uint32_t *_pdwStatus /* [in,out] [ref] */,
				      WERROR *result)
{
	struct winspool_AsyncXcvData r;
	NTSTATUS status;

	/* In parameters */
	r.in.hXcv = _hXcv;
	r.in.pszDataName = _pszDataName;
	r.in.pInputData = _pInputData;
	r.in.cbInputData = _cbInputData;
	r.in.cbOutputData = _cbOutputData;
	r.in.pdwStatus = _pdwStatus;

	/* Out parameters */
	r.out.pOutputData = _pOutputData;
	r.out.pcbOutputNeeded = _pcbOutputNeeded;
	r.out.pdwStatus = _pdwStatus;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncXcvData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_pOutputData;
		_copy_len_pOutputData = r.in.cbOutputData;
		if (_pOutputData != r.out.pOutputData) {
			memcpy(_pOutputData, r.out.pOutputData, _copy_len_pOutputData * sizeof(*_pOutputData));
		}
	}
	*_pcbOutputNeeded = *r.out.pcbOutputNeeded;
	*_pdwStatus = *r.out.pdwStatus;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSendRecvBidiData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSendRecvBidiData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSendRecvBidiData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSendRecvBidiData *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSendRecvBidiData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSendRecvBidiData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSENDRECVBIDIDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSendRecvBidiData_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSendRecvBidiData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSendRecvBidiData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSendRecvBidiData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSendRecvBidiData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSendRecvBidiData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSendRecvBidiData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSENDRECVBIDIDATA, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSendRecvBidiData_state {
	struct winspool_AsyncSendRecvBidiData orig;
	struct winspool_AsyncSendRecvBidiData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSendRecvBidiData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSendRecvBidiData_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle _hPrinter /* [in]  */,
							      const char *_pAction /* [in] [charset(UTF16),unique] */,
							      struct RPC_BIDI_REQUEST_CONTAINER *_pReqData /* [in] [ref] */,
							      struct RPC_BIDI_RESPONSE_CONTAINER **_ppRespData /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSendRecvBidiData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSendRecvBidiData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pAction = _pAction;
	state->orig.in.pReqData = _pReqData;

	/* Out parameters */
	state->orig.out.ppRespData = _ppRespData;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncSendRecvBidiData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSendRecvBidiData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSendRecvBidiData_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSendRecvBidiData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSendRecvBidiData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSendRecvBidiData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSendRecvBidiData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ppRespData = *state->tmp.out.ppRespData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSendRecvBidiData_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_winspool_AsyncSendRecvBidiData_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSendRecvBidiData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSendRecvBidiData(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle _hPrinter /* [in]  */,
					       const char *_pAction /* [in] [charset(UTF16),unique] */,
					       struct RPC_BIDI_REQUEST_CONTAINER *_pReqData /* [in] [ref] */,
					       struct RPC_BIDI_RESPONSE_CONTAINER **_ppRespData /* [out] [ref] */,
					       WERROR *result)
{
	struct winspool_AsyncSendRecvBidiData r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pAction = _pAction;
	r.in.pReqData = _pReqData;

	/* Out parameters */
	r.out.ppRespData = _ppRespData;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSendRecvBidiData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ppRespData = *r.out.ppRespData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncCreatePrinterIC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncCreatePrinterIC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncCreatePrinterIC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncCreatePrinterIC *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncCreatePrinterIC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncCreatePrinterIC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCCREATEPRINTERIC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncCreatePrinterIC_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncCreatePrinterIC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncCreatePrinterIC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncCreatePrinterIC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncCreatePrinterIC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncCreatePrinterIC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncCreatePrinterIC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCCREATEPRINTERIC, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncCreatePrinterIC_state {
	struct winspool_AsyncCreatePrinterIC orig;
	struct winspool_AsyncCreatePrinterIC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncCreatePrinterIC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncCreatePrinterIC_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle _hPrinter /* [in]  */,
							     struct policy_handle *_pHandle /* [out] [ref] */,
							     struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncCreatePrinterIC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncCreatePrinterIC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pDevModeContainer = _pDevModeContainer;

	/* Out parameters */
	state->orig.out.pHandle = _pHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncCreatePrinterIC_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncCreatePrinterIC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncCreatePrinterIC_done, req);
	return req;
}

static void dcerpc_winspool_AsyncCreatePrinterIC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncCreatePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncCreatePrinterIC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncCreatePrinterIC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pHandle = *state->tmp.out.pHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncCreatePrinterIC_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_winspool_AsyncCreatePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncCreatePrinterIC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncCreatePrinterIC(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle _hPrinter /* [in]  */,
					      struct policy_handle *_pHandle /* [out] [ref] */,
					      struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
					      WERROR *result)
{
	struct winspool_AsyncCreatePrinterIC r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pDevModeContainer = _pDevModeContainer;

	/* Out parameters */
	r.out.pHandle = _pHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncCreatePrinterIC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pHandle = *r.out.pHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCPLAYGDISCRIPTONPRINTERIC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncPlayGdiScriptOnPrinterIC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCPLAYGDISCRIPTONPRINTERIC, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_state {
	struct winspool_AsyncPlayGdiScriptOnPrinterIC orig;
	struct winspool_AsyncPlayGdiScriptOnPrinterIC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct dcerpc_binding_handle *h,
								      struct policy_handle _hPrinterIC /* [in]  */,
								      uint8_t *_pIn /* [in] [ref,size_is(cIn)] */,
								      uint32_t _cIn /* [in]  */,
								      uint8_t *_pOut /* [out] [ref,size_is(cOut)] */,
								      uint32_t _cOut /* [in]  */,
								      uint32_t _ul /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinterIC = _hPrinterIC;
	state->orig.in.pIn = _pIn;
	state->orig.in.cIn = _cIn;
	state->orig.in.cOut = _cOut;
	state->orig.in.ul = _ul;

	/* Out parameters */
	state->orig.out.pOut = _pOut;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_done, req);
	return req;
}

static void dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_pOut;
		_copy_len_pOut = state->tmp.in.cOut;
		if (state->orig.out.pOut != state->tmp.out.pOut) {
			memcpy(state->orig.out.pOut, state->tmp.out.pOut, _copy_len_pOut * sizeof(*state->orig.out.pOut));
		}
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx,
							    WERROR *result)
{
	struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC(struct dcerpc_binding_handle *h,
						       TALLOC_CTX *mem_ctx,
						       struct policy_handle _hPrinterIC /* [in]  */,
						       uint8_t *_pIn /* [in] [ref,size_is(cIn)] */,
						       uint32_t _cIn /* [in]  */,
						       uint8_t *_pOut /* [out] [ref,size_is(cOut)] */,
						       uint32_t _cOut /* [in]  */,
						       uint32_t _ul /* [in]  */,
						       WERROR *result)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinterIC = _hPrinterIC;
	r.in.pIn = _pIn;
	r.in.cIn = _cIn;
	r.in.cOut = _cOut;
	r.in.ul = _ul;

	/* Out parameters */
	r.out.pOut = _pOut;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncPlayGdiScriptOnPrinterIC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_pOut;
		_copy_len_pOut = r.in.cOut;
		if (_pOut != r.out.pOut) {
			memcpy(_pOut, r.out.pOut, _copy_len_pOut * sizeof(*_pOut));
		}
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinterIC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterIC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterIC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinterIC *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterIC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterIC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERIC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterIC_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterIC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterIC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinterIC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinterIC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterIC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinterIC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERIC, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinterIC_state {
	struct winspool_AsyncDeletePrinterIC orig;
	struct winspool_AsyncDeletePrinterIC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterIC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterIC_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_phPrinterIC /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterIC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterIC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.phPrinterIC = _phPrinterIC;

	/* Out parameters */
	state->orig.out.phPrinterIC = _phPrinterIC;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncDeletePrinterIC_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinterIC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterIC_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterIC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterIC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinterIC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.phPrinterIC = *state->tmp.out.phPrinterIC;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterIC_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterIC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterIC(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_phPrinterIC /* [in,out] [ref] */,
					      WERROR *result)
{
	struct winspool_AsyncDeletePrinterIC r;
	NTSTATUS status;

	/* In parameters */
	r.in.phPrinterIC = _phPrinterIC;

	/* Out parameters */
	r.out.phPrinterIC = _phPrinterIC;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinterIC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_phPrinterIC = *r.out.phPrinterIC;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPrinters_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinters_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinters_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPrinters *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinters_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinters_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinters_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPrinters_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinters_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPrinters_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPrinters_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinters_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPrinters *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPrinters_state {
	struct winspool_AsyncEnumPrinters orig;
	struct winspool_AsyncEnumPrinters tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinters_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinters_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  uint32_t _Flags /* [in]  */,
							  const char *_pName /* [in] [charset(UTF16),unique] */,
							  uint32_t _Level /* [in]  */,
							  uint8_t *_pPrinterEnum /* [in,out] [size_is(cbBuf),unique] */,
							  uint32_t _cbBuf /* [in]  */,
							  uint32_t *_pcbNeeded /* [out] [ref] */,
							  uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinters_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinters_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Flags = _Flags;
	state->orig.in.pName = _pName;
	state->orig.in.Level = _Level;
	state->orig.in.pPrinterEnum = _pPrinterEnum;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pPrinterEnum = _pPrinterEnum;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPrinters_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPrinters_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinters_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPrinters_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPrinters_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinters_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPrinters_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pPrinterEnum && state->tmp.out.pPrinterEnum) {
		{
			size_t _copy_len_pPrinterEnum;
			_copy_len_pPrinterEnum = state->tmp.in.cbBuf;
			if (state->orig.out.pPrinterEnum != state->tmp.out.pPrinterEnum) {
				memcpy(state->orig.out.pPrinterEnum, state->tmp.out.pPrinterEnum, _copy_len_pPrinterEnum * sizeof(*state->orig.out.pPrinterEnum));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinters_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPrinters_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinters_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinters(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   uint32_t _Flags /* [in]  */,
					   const char *_pName /* [in] [charset(UTF16),unique] */,
					   uint32_t _Level /* [in]  */,
					   uint8_t *_pPrinterEnum /* [in,out] [size_is(cbBuf),unique] */,
					   uint32_t _cbBuf /* [in]  */,
					   uint32_t *_pcbNeeded /* [out] [ref] */,
					   uint32_t *_pcReturned /* [out] [ref] */,
					   WERROR *result)
{
	struct winspool_AsyncEnumPrinters r;
	NTSTATUS status;

	/* In parameters */
	r.in.Flags = _Flags;
	r.in.pName = _pName;
	r.in.Level = _Level;
	r.in.pPrinterEnum = _pPrinterEnum;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pPrinterEnum = _pPrinterEnum;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPrinters_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pPrinterEnum && r.out.pPrinterEnum) {
		{
			size_t _copy_len_pPrinterEnum;
			_copy_len_pPrinterEnum = r.in.cbBuf;
			if (_pPrinterEnum != r.out.pPrinterEnum) {
				memcpy(_pPrinterEnum, r.out.pPrinterEnum, _copy_len_pPrinterEnum * sizeof(*_pPrinterEnum));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddPrinterDriver_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPrinterDriver_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPrinterDriver_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddPrinterDriver *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPrinterDriver_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPrinterDriver_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPRINTERDRIVER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPrinterDriver_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddPrinterDriver_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPrinterDriver_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddPrinterDriver_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddPrinterDriver_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPrinterDriver_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddPrinterDriver *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPRINTERDRIVER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddPrinterDriver_state {
	struct winspool_AsyncAddPrinterDriver orig;
	struct winspool_AsyncAddPrinterDriver tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPrinterDriver_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPrinterDriver_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      const char *_pName /* [in] [charset(UTF16),unique] */,
							      struct spoolss_AddDriverInfoCtr *_pDriverContainer /* [in] [ref] */,
							      uint32_t _dwFileCopyFlags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPrinterDriver_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPrinterDriver_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pDriverContainer = _pDriverContainer;
	state->orig.in.dwFileCopyFlags = _dwFileCopyFlags;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddPrinterDriver_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPrinterDriver_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddPrinterDriver_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPrinterDriver_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddPrinterDriver_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPrinterDriver_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_winspool_AsyncAddPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPrinterDriver_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPrinterDriver(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       const char *_pName /* [in] [charset(UTF16),unique] */,
					       struct spoolss_AddDriverInfoCtr *_pDriverContainer /* [in] [ref] */,
					       uint32_t _dwFileCopyFlags /* [in]  */,
					       WERROR *result)
{
	struct winspool_AsyncAddPrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pDriverContainer = _pDriverContainer;
	r.in.dwFileCopyFlags = _dwFileCopyFlags;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddPrinterDriver_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPrinterDrivers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterDrivers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterDrivers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPrinterDrivers *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterDrivers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterDrivers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERDRIVERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterDrivers_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterDrivers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDrivers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPrinterDrivers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPrinterDrivers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDrivers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPrinterDrivers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTERDRIVERS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPrinterDrivers_state {
	struct winspool_AsyncEnumPrinterDrivers orig;
	struct winspool_AsyncEnumPrinterDrivers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrinterDrivers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrinterDrivers_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_pName /* [in] [charset(UTF16),unique] */,
								const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
								uint32_t _Level /* [in]  */,
								uint8_t *_pDrivers /* [in,out] [size_is(cbBuf),unique] */,
								uint32_t _cbBuf /* [in]  */,
								uint32_t *_pcbNeeded /* [out] [ref] */,
								uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrinterDrivers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrinterDrivers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.Level = _Level;
	state->orig.in.pDrivers = _pDrivers;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pDrivers = _pDrivers;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPrinterDrivers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPrinterDrivers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrinterDrivers_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPrinterDrivers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterDrivers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPrinterDrivers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pDrivers && state->tmp.out.pDrivers) {
		{
			size_t _copy_len_pDrivers;
			_copy_len_pDrivers = state->tmp.in.cbBuf;
			if (state->orig.out.pDrivers != state->tmp.out.pDrivers) {
				memcpy(state->orig.out.pDrivers, state->tmp.out.pDrivers, _copy_len_pDrivers * sizeof(*state->orig.out.pDrivers));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDrivers_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrinterDrivers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrinterDrivers(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_pName /* [in] [charset(UTF16),unique] */,
						 const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
						 uint32_t _Level /* [in]  */,
						 uint8_t *_pDrivers /* [in,out] [size_is(cbBuf),unique] */,
						 uint32_t _cbBuf /* [in]  */,
						 uint32_t *_pcbNeeded /* [out] [ref] */,
						 uint32_t *_pcReturned /* [out] [ref] */,
						 WERROR *result)
{
	struct winspool_AsyncEnumPrinterDrivers r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pEnvironment = _pEnvironment;
	r.in.Level = _Level;
	r.in.pDrivers = _pDrivers;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pDrivers = _pDrivers;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPrinterDrivers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pDrivers && r.out.pDrivers) {
		{
			size_t _copy_len_pDrivers;
			_copy_len_pDrivers = r.in.cbBuf;
			if (_pDrivers != r.out.pDrivers) {
				memcpy(_pDrivers, r.out.pDrivers, _copy_len_pDrivers * sizeof(*_pDrivers));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetPrinterDriverDirectory *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDRIVERDIRECTORY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverDirectory_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetPrinterDriverDirectory *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDRIVERDIRECTORY, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_state {
	struct winspool_AsyncGetPrinterDriverDirectory orig;
	struct winspool_AsyncGetPrinterDriverDirectory tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDriverDirectory_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDriverDirectory_send(TALLOC_CTX *mem_ctx,
								       struct tevent_context *ev,
								       struct dcerpc_binding_handle *h,
								       const char *_pName /* [in] [charset(UTF16),unique] */,
								       const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
								       uint32_t _Level /* [in]  */,
								       uint8_t *_pDriverDirectory /* [in,out] [size_is(cbBuf),unique] */,
								       uint32_t _cbBuf /* [in]  */,
								       uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.Level = _Level;
	state->orig.in.pDriverDirectory = _pDriverDirectory;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pDriverDirectory = _pDriverDirectory;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetPrinterDriverDirectory_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDriverDirectory_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDriverDirectory_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetPrinterDriverDirectory_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pDriverDirectory && state->tmp.out.pDriverDirectory) {
		{
			size_t _copy_len_pDriverDirectory;
			_copy_len_pDriverDirectory = state->tmp.in.cbBuf;
			if (state->orig.out.pDriverDirectory != state->tmp.out.pDriverDirectory) {
				memcpy(state->orig.out.pDriverDirectory, state->tmp.out.pDriverDirectory, _copy_len_pDriverDirectory * sizeof(*state->orig.out.pDriverDirectory));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverDirectory_recv(struct tevent_req *req,
							     TALLOC_CTX *mem_ctx,
							     WERROR *result)
{
	struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDriverDirectory_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverDirectory(struct dcerpc_binding_handle *h,
							TALLOC_CTX *mem_ctx,
							const char *_pName /* [in] [charset(UTF16),unique] */,
							const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
							uint32_t _Level /* [in]  */,
							uint8_t *_pDriverDirectory /* [in,out] [size_is(cbBuf),unique] */,
							uint32_t _cbBuf /* [in]  */,
							uint32_t *_pcbNeeded /* [out] [ref] */,
							WERROR *result)
{
	struct winspool_AsyncGetPrinterDriverDirectory r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pEnvironment = _pEnvironment;
	r.in.Level = _Level;
	r.in.pDriverDirectory = _pDriverDirectory;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pDriverDirectory = _pDriverDirectory;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetPrinterDriverDirectory_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pDriverDirectory && r.out.pDriverDirectory) {
		{
			size_t _copy_len_pDriverDirectory;
			_copy_len_pDriverDirectory = r.in.cbBuf;
			if (_pDriverDirectory != r.out.pDriverDirectory) {
				memcpy(_pDriverDirectory, r.out.pDriverDirectory, _copy_len_pDriverDirectory * sizeof(*_pDriverDirectory));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinterDriver_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDriver_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDriver_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinterDriver *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDriver_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDriver_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDriver_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDriver_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriver_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinterDriver_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinterDriver_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriver_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinterDriver *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinterDriver_state {
	struct winspool_AsyncDeletePrinterDriver orig;
	struct winspool_AsyncDeletePrinterDriver tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDriver_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDriver_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_pName /* [in] [charset(UTF16),unique] */,
								 const char *_pEnvironment /* [in] [charset(UTF16),ref] */,
								 const char *_pDriverName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDriver_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDriver_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.pDriverName = _pDriverName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinterDriver_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDriver_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDriver_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDriver_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinterDriver_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriver_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDriver_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriver(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_pName /* [in] [charset(UTF16),unique] */,
						  const char *_pEnvironment /* [in] [charset(UTF16),ref] */,
						  const char *_pDriverName /* [in] [charset(UTF16),ref] */,
						  WERROR *result)
{
	struct winspool_AsyncDeletePrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pEnvironment = _pEnvironment;
	r.in.pDriverName = _pDriverName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinterDriver_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinterDriverEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDriverEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDriverEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinterDriverEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDriverEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDriverEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVEREX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDriverEx_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDriverEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinterDriverEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinterDriverEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinterDriverEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVEREX, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinterDriverEx_state {
	struct winspool_AsyncDeletePrinterDriverEx orig;
	struct winspool_AsyncDeletePrinterDriverEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDriverEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDriverEx_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   const char *_pName /* [in] [charset(UTF16),unique] */,
								   const char *_pEnvironment /* [in] [charset(UTF16),ref] */,
								   const char *_pDriverName /* [in] [charset(UTF16),ref] */,
								   uint32_t _dwDeleteFlag /* [in]  */,
								   uint32_t _dwVersionNum /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDriverEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDriverEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.pDriverName = _pDriverName;
	state->orig.in.dwDeleteFlag = _dwDeleteFlag;
	state->orig.in.dwVersionNum = _dwVersionNum;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinterDriverEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDriverEx_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDriverEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinterDriverEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDriverEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinterDriverEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverEx_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrinterDriverEx_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDriverEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverEx(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    const char *_pName /* [in] [charset(UTF16),unique] */,
						    const char *_pEnvironment /* [in] [charset(UTF16),ref] */,
						    const char *_pDriverName /* [in] [charset(UTF16),ref] */,
						    uint32_t _dwDeleteFlag /* [in]  */,
						    uint32_t _dwVersionNum /* [in]  */,
						    WERROR *result)
{
	struct winspool_AsyncDeletePrinterDriverEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pEnvironment = _pEnvironment;
	r.in.pDriverName = _pDriverName;
	r.in.dwDeleteFlag = _dwDeleteFlag;
	r.in.dwVersionNum = _dwVersionNum;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinterDriverEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddPrintProcessor_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPrintProcessor_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPrintProcessor_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddPrintProcessor *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPrintProcessor_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPrintProcessor_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPRINTPROCESSOR, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPrintProcessor_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddPrintProcessor_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPrintProcessor_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddPrintProcessor_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddPrintProcessor_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPrintProcessor_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddPrintProcessor *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPRINTPROCESSOR, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddPrintProcessor_state {
	struct winspool_AsyncAddPrintProcessor orig;
	struct winspool_AsyncAddPrintProcessor tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPrintProcessor_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPrintProcessor_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       const char *_pName /* [in] [charset(UTF16),unique] */,
							       const char *_pEnvironment /* [in] [charset(UTF16),ref] */,
							       const char *_pPathName /* [in] [charset(UTF16),ref] */,
							       const char *_pPrintProcessorName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPrintProcessor_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPrintProcessor_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.pPathName = _pPathName;
	state->orig.in.pPrintProcessorName = _pPrintProcessorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddPrintProcessor_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPrintProcessor_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddPrintProcessor_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddPrintProcessor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPrintProcessor_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddPrintProcessor_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPrintProcessor_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_winspool_AsyncAddPrintProcessor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPrintProcessor_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPrintProcessor(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						const char *_pName /* [in] [charset(UTF16),unique] */,
						const char *_pEnvironment /* [in] [charset(UTF16),ref] */,
						const char *_pPathName /* [in] [charset(UTF16),ref] */,
						const char *_pPrintProcessorName /* [in] [charset(UTF16),ref] */,
						WERROR *result)
{
	struct winspool_AsyncAddPrintProcessor r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pEnvironment = _pEnvironment;
	r.in.pPathName = _pPathName;
	r.in.pPrintProcessorName = _pPrintProcessorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddPrintProcessor_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPrintProcessors_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrintProcessors_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrintProcessors_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPrintProcessors *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrintProcessors_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrintProcessors_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTPROCESSORS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrintProcessors_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPrintProcessors_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessors_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPrintProcessors_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPrintProcessors_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessors_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPrintProcessors *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTPROCESSORS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPrintProcessors_state {
	struct winspool_AsyncEnumPrintProcessors orig;
	struct winspool_AsyncEnumPrintProcessors tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrintProcessors_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrintProcessors_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_pName /* [in] [charset(UTF16),unique] */,
								 const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
								 uint32_t _Level /* [in]  */,
								 uint8_t *_pPrintProcessorInfo /* [in,out] [size_is(cbBuf),unique] */,
								 uint32_t _cbBuf /* [in]  */,
								 uint32_t *_pcbNeeded /* [out] [ref] */,
								 uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrintProcessors_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrintProcessors_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.Level = _Level;
	state->orig.in.pPrintProcessorInfo = _pPrintProcessorInfo;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pPrintProcessorInfo = _pPrintProcessorInfo;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPrintProcessors_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPrintProcessors_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrintProcessors_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPrintProcessors_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPrintProcessors_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrintProcessors_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPrintProcessors_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pPrintProcessorInfo && state->tmp.out.pPrintProcessorInfo) {
		{
			size_t _copy_len_pPrintProcessorInfo;
			_copy_len_pPrintProcessorInfo = state->tmp.in.cbBuf;
			if (state->orig.out.pPrintProcessorInfo != state->tmp.out.pPrintProcessorInfo) {
				memcpy(state->orig.out.pPrintProcessorInfo, state->tmp.out.pPrintProcessorInfo, _copy_len_pPrintProcessorInfo * sizeof(*state->orig.out.pPrintProcessorInfo));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessors_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPrintProcessors_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrintProcessors_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessors(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_pName /* [in] [charset(UTF16),unique] */,
						  const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
						  uint32_t _Level /* [in]  */,
						  uint8_t *_pPrintProcessorInfo /* [in,out] [size_is(cbBuf),unique] */,
						  uint32_t _cbBuf /* [in]  */,
						  uint32_t *_pcbNeeded /* [out] [ref] */,
						  uint32_t *_pcReturned /* [out] [ref] */,
						  WERROR *result)
{
	struct winspool_AsyncEnumPrintProcessors r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pEnvironment = _pEnvironment;
	r.in.Level = _Level;
	r.in.pPrintProcessorInfo = _pPrintProcessorInfo;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pPrintProcessorInfo = _pPrintProcessorInfo;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPrintProcessors_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pPrintProcessorInfo && r.out.pPrintProcessorInfo) {
		{
			size_t _copy_len_pPrintProcessorInfo;
			_copy_len_pPrintProcessorInfo = r.in.cbBuf;
			if (_pPrintProcessorInfo != r.out.pPrintProcessorInfo) {
				memcpy(_pPrintProcessorInfo, r.out.pPrintProcessorInfo, _copy_len_pPrintProcessorInfo * sizeof(*_pPrintProcessorInfo));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetPrintProcessorDirectory *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTPROCESSORDIRECTORY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrintProcessorDirectory_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetPrintProcessorDirectory *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTPROCESSORDIRECTORY, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_state {
	struct winspool_AsyncGetPrintProcessorDirectory orig;
	struct winspool_AsyncGetPrintProcessorDirectory tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrintProcessorDirectory_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrintProcessorDirectory_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct dcerpc_binding_handle *h,
									const char *_pName /* [in] [charset(UTF16),unique] */,
									const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
									uint32_t _Level /* [in]  */,
									uint8_t *_pPrintProcessorDirectory /* [in,out] [size_is(cbBuf),unique] */,
									uint32_t _cbBuf /* [in]  */,
									uint32_t *_pcbNeeded /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.Level = _Level;
	state->orig.in.pPrintProcessorDirectory = _pPrintProcessorDirectory;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pPrintProcessorDirectory = _pPrintProcessorDirectory;
	state->orig.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetPrintProcessorDirectory_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrintProcessorDirectory_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetPrintProcessorDirectory_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetPrintProcessorDirectory_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pPrintProcessorDirectory && state->tmp.out.pPrintProcessorDirectory) {
		{
			size_t _copy_len_pPrintProcessorDirectory;
			_copy_len_pPrintProcessorDirectory = state->tmp.in.cbBuf;
			if (state->orig.out.pPrintProcessorDirectory != state->tmp.out.pPrintProcessorDirectory) {
				memcpy(state->orig.out.pPrintProcessorDirectory, state->tmp.out.pPrintProcessorDirectory, _copy_len_pPrintProcessorDirectory * sizeof(*state->orig.out.pPrintProcessorDirectory));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrintProcessorDirectory_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      WERROR *result)
{
	struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrintProcessorDirectory_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrintProcessorDirectory(struct dcerpc_binding_handle *h,
							 TALLOC_CTX *mem_ctx,
							 const char *_pName /* [in] [charset(UTF16),unique] */,
							 const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
							 uint32_t _Level /* [in]  */,
							 uint8_t *_pPrintProcessorDirectory /* [in,out] [size_is(cbBuf),unique] */,
							 uint32_t _cbBuf /* [in]  */,
							 uint32_t *_pcbNeeded /* [out] [ref] */,
							 WERROR *result)
{
	struct winspool_AsyncGetPrintProcessorDirectory r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pEnvironment = _pEnvironment;
	r.in.Level = _Level;
	r.in.pPrintProcessorDirectory = _pPrintProcessorDirectory;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pPrintProcessorDirectory = _pPrintProcessorDirectory;
	r.out.pcbNeeded = _pcbNeeded;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetPrintProcessorDirectory_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pPrintProcessorDirectory && r.out.pPrintProcessorDirectory) {
		{
			size_t _copy_len_pPrintProcessorDirectory;
			_copy_len_pPrintProcessorDirectory = r.in.cbBuf;
			if (_pPrintProcessorDirectory != r.out.pPrintProcessorDirectory) {
				memcpy(_pPrintProcessorDirectory, r.out.pPrintProcessorDirectory, _copy_len_pPrintProcessorDirectory * sizeof(*_pPrintProcessorDirectory));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPorts_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPorts_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPorts_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPorts *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPorts_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPorts_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPORTS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPorts_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPorts_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPorts_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPorts_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPorts_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPorts_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPorts *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPORTS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPorts_state {
	struct winspool_AsyncEnumPorts orig;
	struct winspool_AsyncEnumPorts tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPorts_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPorts_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_pName /* [in] [charset(UTF16),unique] */,
						       uint32_t _Level /* [in]  */,
						       uint8_t *_pPort /* [in,out] [size_is(cbBuf),unique] */,
						       uint32_t _cbBuf /* [in]  */,
						       uint32_t *_pcbNeeded /* [out] [ref] */,
						       uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPorts_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPorts_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.Level = _Level;
	state->orig.in.pPort = _pPort;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pPort = _pPort;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPorts_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPorts_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPorts_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPorts_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPorts_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPorts_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPorts_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pPort && state->tmp.out.pPort) {
		{
			size_t _copy_len_pPort;
			_copy_len_pPort = state->tmp.in.cbBuf;
			if (state->orig.out.pPort != state->tmp.out.pPort) {
				memcpy(state->orig.out.pPort, state->tmp.out.pPort, _copy_len_pPort * sizeof(*state->orig.out.pPort));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPorts_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPorts_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPorts_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPorts(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_pName /* [in] [charset(UTF16),unique] */,
					uint32_t _Level /* [in]  */,
					uint8_t *_pPort /* [in,out] [size_is(cbBuf),unique] */,
					uint32_t _cbBuf /* [in]  */,
					uint32_t *_pcbNeeded /* [out] [ref] */,
					uint32_t *_pcReturned /* [out] [ref] */,
					WERROR *result)
{
	struct winspool_AsyncEnumPorts r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.Level = _Level;
	r.in.pPort = _pPort;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pPort = _pPort;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPorts_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pPort && r.out.pPort) {
		{
			size_t _copy_len_pPort;
			_copy_len_pPort = r.in.cbBuf;
			if (_pPort != r.out.pPort) {
				memcpy(_pPort, r.out.pPort, _copy_len_pPort * sizeof(*_pPort));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumMonitors_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumMonitors_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumMonitors_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumMonitors *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumMonitors_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumMonitors_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMMONITORS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumMonitors_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumMonitors_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumMonitors_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumMonitors_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumMonitors_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumMonitors_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumMonitors *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMMONITORS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumMonitors_state {
	struct winspool_AsyncEnumMonitors orig;
	struct winspool_AsyncEnumMonitors tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumMonitors_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumMonitors_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_pName /* [in] [charset(UTF16),unique] */,
							  uint32_t _Level /* [in]  */,
							  uint8_t *_pMonitor /* [in,out] [size_is(cbBuf),unique] */,
							  uint32_t _cbBuf /* [in]  */,
							  uint32_t *_pcbNeeded /* [out] [ref] */,
							  uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumMonitors_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumMonitors_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.Level = _Level;
	state->orig.in.pMonitor = _pMonitor;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pMonitor = _pMonitor;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumMonitors_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumMonitors_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumMonitors_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumMonitors_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumMonitors_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumMonitors_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumMonitors_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pMonitor && state->tmp.out.pMonitor) {
		{
			size_t _copy_len_pMonitor;
			_copy_len_pMonitor = state->tmp.in.cbBuf;
			if (state->orig.out.pMonitor != state->tmp.out.pMonitor) {
				memcpy(state->orig.out.pMonitor, state->tmp.out.pMonitor, _copy_len_pMonitor * sizeof(*state->orig.out.pMonitor));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumMonitors_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumMonitors_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumMonitors_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumMonitors(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_pName /* [in] [charset(UTF16),unique] */,
					   uint32_t _Level /* [in]  */,
					   uint8_t *_pMonitor /* [in,out] [size_is(cbBuf),unique] */,
					   uint32_t _cbBuf /* [in]  */,
					   uint32_t *_pcbNeeded /* [out] [ref] */,
					   uint32_t *_pcReturned /* [out] [ref] */,
					   WERROR *result)
{
	struct winspool_AsyncEnumMonitors r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.Level = _Level;
	r.in.pMonitor = _pMonitor;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pMonitor = _pMonitor;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumMonitors_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pMonitor && r.out.pMonitor) {
		{
			size_t _copy_len_pMonitor;
			_copy_len_pMonitor = r.in.cbBuf;
			if (_pMonitor != r.out.pMonitor) {
				memcpy(_pMonitor, r.out.pMonitor, _copy_len_pMonitor * sizeof(*_pMonitor));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddPort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddPort *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPORT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPort_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddPort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddPort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddPort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddPort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPORT, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddPort_state {
	struct winspool_AsyncAddPort orig;
	struct winspool_AsyncAddPort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPort_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_pName /* [in] [charset(UTF16),unique] */,
						     struct spoolss_SetPortInfoContainer *_pPortContainer /* [in] [ref] */,
						     struct spoolss_PortVarContainer *_pPortVarContainer /* [in] [ref] */,
						     const char *_pMonitorName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pPortContainer = _pPortContainer;
	state->orig.in.pPortVarContainer = _pPortVarContainer;
	state->orig.in.pMonitorName = _pMonitorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddPort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPort_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddPort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddPort_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddPort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPort_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winspool_AsyncAddPort_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPort(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_pName /* [in] [charset(UTF16),unique] */,
				      struct spoolss_SetPortInfoContainer *_pPortContainer /* [in] [ref] */,
				      struct spoolss_PortVarContainer *_pPortVarContainer /* [in] [ref] */,
				      const char *_pMonitorName /* [in] [charset(UTF16),ref] */,
				      WERROR *result)
{
	struct winspool_AsyncAddPort r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pPortContainer = _pPortContainer;
	r.in.pPortVarContainer = _pPortVarContainer;
	r.in.pMonitorName = _pMonitorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddPort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSetPort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSetPort *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPORT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPort_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSetPort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSetPort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSetPort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSetPort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETPORT, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSetPort_state {
	struct winspool_AsyncSetPort orig;
	struct winspool_AsyncSetPort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetPort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetPort_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_pName /* [in] [charset(UTF16),unique] */,
						     const char *_pPortName /* [in] [charset(UTF16),unique] */,
						     struct spoolss_SetPortInfoContainer *_pPortContainer /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetPort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetPort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pPortName = _pPortName;
	state->orig.in.pPortContainer = _pPortContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSetPort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetPort_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSetPort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSetPort_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSetPort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetPort_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winspool_AsyncSetPort_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetPort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetPort(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_pName /* [in] [charset(UTF16),unique] */,
				      const char *_pPortName /* [in] [charset(UTF16),unique] */,
				      struct spoolss_SetPortInfoContainer *_pPortContainer /* [in] [ref] */,
				      WERROR *result)
{
	struct winspool_AsyncSetPort r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pPortName = _pPortName;
	r.in.pPortContainer = _pPortContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSetPort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddMonitor_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddMonitor_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddMonitor_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddMonitor *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddMonitor_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddMonitor_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDMONITOR, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddMonitor_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddMonitor_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddMonitor_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddMonitor_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddMonitor_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddMonitor_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddMonitor *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDMONITOR, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddMonitor_state {
	struct winspool_AsyncAddMonitor orig;
	struct winspool_AsyncAddMonitor tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddMonitor_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddMonitor_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_Name /* [in] [charset(UTF16),unique] */,
							struct spoolss_MonitorContainer *_pMonitorContainer /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddMonitor_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddMonitor_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Name = _Name;
	state->orig.in.pMonitorContainer = _pMonitorContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddMonitor_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddMonitor_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddMonitor_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddMonitor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddMonitor_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddMonitor_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddMonitor_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_winspool_AsyncAddMonitor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddMonitor_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddMonitor(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_Name /* [in] [charset(UTF16),unique] */,
					 struct spoolss_MonitorContainer *_pMonitorContainer /* [in] [ref] */,
					 WERROR *result)
{
	struct winspool_AsyncAddMonitor r;
	NTSTATUS status;

	/* In parameters */
	r.in.Name = _Name;
	r.in.pMonitorContainer = _pMonitorContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddMonitor_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeleteMonitor_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeleteMonitor_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeleteMonitor_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeleteMonitor *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeleteMonitor_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeleteMonitor_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEMONITOR, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeleteMonitor_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeleteMonitor_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeleteMonitor_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeleteMonitor_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeleteMonitor_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeleteMonitor_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeleteMonitor *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEMONITOR, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeleteMonitor_state {
	struct winspool_AsyncDeleteMonitor orig;
	struct winspool_AsyncDeleteMonitor tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeleteMonitor_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeleteMonitor_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_Name /* [in] [charset(UTF16),unique] */,
							   const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
							   const char *_pMonitorName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeleteMonitor_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeleteMonitor_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Name = _Name;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.pMonitorName = _pMonitorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeleteMonitor_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeleteMonitor_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeleteMonitor_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeleteMonitor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeleteMonitor_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeleteMonitor_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeleteMonitor_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_winspool_AsyncDeleteMonitor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeleteMonitor_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeleteMonitor(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_Name /* [in] [charset(UTF16),unique] */,
					    const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
					    const char *_pMonitorName /* [in] [charset(UTF16),ref] */,
					    WERROR *result)
{
	struct winspool_AsyncDeleteMonitor r;
	NTSTATUS status;

	/* In parameters */
	r.in.Name = _Name;
	r.in.pEnvironment = _pEnvironment;
	r.in.pMonitorName = _pMonitorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeleteMonitor_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrintProcessor_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrintProcessor_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrintProcessor_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrintProcessor *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrintProcessor_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrintProcessor_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTPROCESSOR, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrintProcessor_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrintProcessor_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrintProcessor_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrintProcessor_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrintProcessor_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrintProcessor_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrintProcessor *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTPROCESSOR, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrintProcessor_state {
	struct winspool_AsyncDeletePrintProcessor orig;
	struct winspool_AsyncDeletePrintProcessor tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrintProcessor_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrintProcessor_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct dcerpc_binding_handle *h,
								  const char *_Name /* [in] [charset(UTF16),unique] */,
								  const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
								  const char *_pPrintProcessorName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrintProcessor_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrintProcessor_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Name = _Name;
	state->orig.in.pEnvironment = _pEnvironment;
	state->orig.in.pPrintProcessorName = _pPrintProcessorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrintProcessor_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrintProcessor_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrintProcessor_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrintProcessor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrintProcessor_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrintProcessor_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrintProcessor_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePrintProcessor_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrintProcessor_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrintProcessor(struct dcerpc_binding_handle *h,
						   TALLOC_CTX *mem_ctx,
						   const char *_Name /* [in] [charset(UTF16),unique] */,
						   const char *_pEnvironment /* [in] [charset(UTF16),unique] */,
						   const char *_pPrintProcessorName /* [in] [charset(UTF16),ref] */,
						   WERROR *result)
{
	struct winspool_AsyncDeletePrintProcessor r;
	NTSTATUS status;

	/* In parameters */
	r.in.Name = _Name;
	r.in.pEnvironment = _pEnvironment;
	r.in.pPrintProcessorName = _pPrintProcessorName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrintProcessor_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPrintProcessorDatatypes *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTPROCESSORDATATYPES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPrintProcessorDatatypes *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPRINTPROCESSORDATATYPES, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_state {
	struct winspool_AsyncEnumPrintProcessorDatatypes orig;
	struct winspool_AsyncEnumPrintProcessorDatatypes tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_send(TALLOC_CTX *mem_ctx,
									 struct tevent_context *ev,
									 struct dcerpc_binding_handle *h,
									 const char *_pName /* [in] [charset(UTF16),unique] */,
									 const char *_pPrintProcessorName /* [in] [charset(UTF16),unique] */,
									 uint32_t _Level /* [in]  */,
									 uint8_t *_pDatatypes /* [in,out] [size_is(cbBuf),unique] */,
									 uint32_t _cbBuf /* [in]  */,
									 uint32_t *_pcbNeeded /* [out] [ref] */,
									 uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pName = _pName;
	state->orig.in.pPrintProcessorName = _pPrintProcessorName;
	state->orig.in.Level = _Level;
	state->orig.in.pDatatypes = _pDatatypes;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pDatatypes = _pDatatypes;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pDatatypes && state->tmp.out.pDatatypes) {
		{
			size_t _copy_len_pDatatypes;
			_copy_len_pDatatypes = state->tmp.in.cbBuf;
			if (state->orig.out.pDatatypes != state->tmp.out.pDatatypes) {
				memcpy(state->orig.out.pDatatypes, state->tmp.out.pDatatypes, _copy_len_pDatatypes * sizeof(*state->orig.out.pDatatypes));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_recv(struct tevent_req *req,
							       TALLOC_CTX *mem_ctx,
							       WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPrintProcessorDatatypes(struct dcerpc_binding_handle *h,
							  TALLOC_CTX *mem_ctx,
							  const char *_pName /* [in] [charset(UTF16),unique] */,
							  const char *_pPrintProcessorName /* [in] [charset(UTF16),unique] */,
							  uint32_t _Level /* [in]  */,
							  uint8_t *_pDatatypes /* [in,out] [size_is(cbBuf),unique] */,
							  uint32_t _cbBuf /* [in]  */,
							  uint32_t *_pcbNeeded /* [out] [ref] */,
							  uint32_t *_pcReturned /* [out] [ref] */,
							  WERROR *result)
{
	struct winspool_AsyncEnumPrintProcessorDatatypes r;
	NTSTATUS status;

	/* In parameters */
	r.in.pName = _pName;
	r.in.pPrintProcessorName = _pPrintProcessorName;
	r.in.Level = _Level;
	r.in.pDatatypes = _pDatatypes;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pDatatypes = _pDatatypes;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPrintProcessorDatatypes_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pDatatypes && r.out.pDatatypes) {
		{
			size_t _copy_len_pDatatypes;
			_copy_len_pDatatypes = r.in.cbBuf;
			if (_pDatatypes != r.out.pDatatypes) {
				memcpy(_pDatatypes, r.out.pDatatypes, _copy_len_pDatatypes * sizeof(*_pDatatypes));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncAddPerMachineConnection_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPerMachineConnection_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPerMachineConnection_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncAddPerMachineConnection *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPerMachineConnection_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPerMachineConnection_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPERMACHINECONNECTION, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPerMachineConnection_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncAddPerMachineConnection_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPerMachineConnection_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncAddPerMachineConnection_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncAddPerMachineConnection_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPerMachineConnection_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncAddPerMachineConnection *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCADDPERMACHINECONNECTION, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncAddPerMachineConnection_state {
	struct winspool_AsyncAddPerMachineConnection orig;
	struct winspool_AsyncAddPerMachineConnection tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncAddPerMachineConnection_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncAddPerMachineConnection_send(TALLOC_CTX *mem_ctx,
								     struct tevent_context *ev,
								     struct dcerpc_binding_handle *h,
								     const char *_pServer /* [in] [charset(UTF16),unique] */,
								     const char *_pPrinterName /* [in] [charset(UTF16),ref] */,
								     const char *_pPrintServer /* [in] [charset(UTF16),ref] */,
								     const char *_pProvider /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncAddPerMachineConnection_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncAddPerMachineConnection_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pServer = _pServer;
	state->orig.in.pPrinterName = _pPrinterName;
	state->orig.in.pPrintServer = _pPrintServer;
	state->orig.in.pProvider = _pProvider;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncAddPerMachineConnection_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncAddPerMachineConnection_done, req);
	return req;
}

static void dcerpc_winspool_AsyncAddPerMachineConnection_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncAddPerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPerMachineConnection_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncAddPerMachineConnection_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncAddPerMachineConnection_recv(struct tevent_req *req,
							   TALLOC_CTX *mem_ctx,
							   WERROR *result)
{
	struct dcerpc_winspool_AsyncAddPerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncAddPerMachineConnection_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncAddPerMachineConnection(struct dcerpc_binding_handle *h,
						      TALLOC_CTX *mem_ctx,
						      const char *_pServer /* [in] [charset(UTF16),unique] */,
						      const char *_pPrinterName /* [in] [charset(UTF16),ref] */,
						      const char *_pPrintServer /* [in] [charset(UTF16),ref] */,
						      const char *_pProvider /* [in] [charset(UTF16),ref] */,
						      WERROR *result)
{
	struct winspool_AsyncAddPerMachineConnection r;
	NTSTATUS status;

	/* In parameters */
	r.in.pServer = _pServer;
	r.in.pPrinterName = _pPrinterName;
	r.in.pPrintServer = _pPrintServer;
	r.in.pProvider = _pProvider;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncAddPerMachineConnection_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePerMachineConnection_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePerMachineConnection_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePerMachineConnection_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePerMachineConnection *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePerMachineConnection_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePerMachineConnection_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPERMACHINECONNECTION, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePerMachineConnection_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePerMachineConnection_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePerMachineConnection_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePerMachineConnection_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePerMachineConnection_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePerMachineConnection_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePerMachineConnection *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPERMACHINECONNECTION, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePerMachineConnection_state {
	struct winspool_AsyncDeletePerMachineConnection orig;
	struct winspool_AsyncDeletePerMachineConnection tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePerMachineConnection_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePerMachineConnection_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct dcerpc_binding_handle *h,
									const char *_pServer /* [in] [charset(UTF16),unique] */,
									const char *_pPrinterName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePerMachineConnection_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePerMachineConnection_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pServer = _pServer;
	state->orig.in.pPrinterName = _pPrinterName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePerMachineConnection_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePerMachineConnection_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePerMachineConnection_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePerMachineConnection_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePerMachineConnection_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePerMachineConnection_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      WERROR *result)
{
	struct dcerpc_winspool_AsyncDeletePerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePerMachineConnection_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePerMachineConnection(struct dcerpc_binding_handle *h,
							 TALLOC_CTX *mem_ctx,
							 const char *_pServer /* [in] [charset(UTF16),unique] */,
							 const char *_pPrinterName /* [in] [charset(UTF16),ref] */,
							 WERROR *result)
{
	struct winspool_AsyncDeletePerMachineConnection r;
	NTSTATUS status;

	/* In parameters */
	r.in.pServer = _pServer;
	r.in.pPrinterName = _pPrinterName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePerMachineConnection_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumPerMachineConnections_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPerMachineConnections_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPerMachineConnections_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumPerMachineConnections *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPerMachineConnections_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPerMachineConnections_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPERMACHINECONNECTIONS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPerMachineConnections_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumPerMachineConnections_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPerMachineConnections_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumPerMachineConnections_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumPerMachineConnections_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPerMachineConnections_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumPerMachineConnections *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMPERMACHINECONNECTIONS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumPerMachineConnections_state {
	struct winspool_AsyncEnumPerMachineConnections orig;
	struct winspool_AsyncEnumPerMachineConnections tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumPerMachineConnections_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumPerMachineConnections_send(TALLOC_CTX *mem_ctx,
								       struct tevent_context *ev,
								       struct dcerpc_binding_handle *h,
								       const char *_pServer /* [in] [charset(UTF16),unique] */,
								       uint8_t *_pPrinterEnum /* [in,out] [size_is(cbBuf),unique] */,
								       uint32_t _cbBuf /* [in]  */,
								       uint32_t *_pcbNeeded /* [out] [ref] */,
								       uint32_t *_pcReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumPerMachineConnections_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumPerMachineConnections_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pServer = _pServer;
	state->orig.in.pPrinterEnum = _pPrinterEnum;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pPrinterEnum = _pPrinterEnum;
	state->orig.out.pcbNeeded = _pcbNeeded;
	state->orig.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumPerMachineConnections_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumPerMachineConnections_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumPerMachineConnections_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumPerMachineConnections_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumPerMachineConnections_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPerMachineConnections_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumPerMachineConnections_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pPrinterEnum && state->tmp.out.pPrinterEnum) {
		{
			size_t _copy_len_pPrinterEnum;
			_copy_len_pPrinterEnum = state->tmp.in.cbBuf;
			if (state->orig.out.pPrinterEnum != state->tmp.out.pPrinterEnum) {
				memcpy(state->orig.out.pPrinterEnum, state->tmp.out.pPrinterEnum, _copy_len_pPrinterEnum * sizeof(*state->orig.out.pPrinterEnum));
			}
		}
	}
	*state->orig.out.pcbNeeded = *state->tmp.out.pcbNeeded;
	*state->orig.out.pcReturned = *state->tmp.out.pcReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumPerMachineConnections_recv(struct tevent_req *req,
							     TALLOC_CTX *mem_ctx,
							     WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumPerMachineConnections_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumPerMachineConnections_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumPerMachineConnections(struct dcerpc_binding_handle *h,
							TALLOC_CTX *mem_ctx,
							const char *_pServer /* [in] [charset(UTF16),unique] */,
							uint8_t *_pPrinterEnum /* [in,out] [size_is(cbBuf),unique] */,
							uint32_t _cbBuf /* [in]  */,
							uint32_t *_pcbNeeded /* [out] [ref] */,
							uint32_t *_pcReturned /* [out] [ref] */,
							WERROR *result)
{
	struct winspool_AsyncEnumPerMachineConnections r;
	NTSTATUS status;

	/* In parameters */
	r.in.pServer = _pServer;
	r.in.pPrinterEnum = _pPrinterEnum;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pPrinterEnum = _pPrinterEnum;
	r.out.pcbNeeded = _pcbNeeded;
	r.out.pcReturned = _pcReturned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumPerMachineConnections_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pPrinterEnum && r.out.pPrinterEnum) {
		{
			size_t _copy_len_pPrinterEnum;
			_copy_len_pPrinterEnum = r.in.cbBuf;
			if (_pPrinterEnum != r.out.pPrinterEnum) {
				memcpy(_pPrinterEnum, r.out.pPrinterEnum, _copy_len_pPrinterEnum * sizeof(*_pPrinterEnum));
			}
		}
	}
	*_pcbNeeded = *r.out.pcbNeeded;
	*_pcReturned = *r.out.pcReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_SyncRegisterForRemoteNotifications_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_SyncRegisterForRemoteNotifications_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_SyncRegisterForRemoteNotifications_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_SyncRegisterForRemoteNotifications *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_SyncRegisterForRemoteNotifications_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_SyncRegisterForRemoteNotifications_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_SYNCREGISTERFORREMOTENOTIFICATIONS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_SyncRegisterForRemoteNotifications_r_done, req);

	return req;
}

static void dcerpc_winspool_SyncRegisterForRemoteNotifications_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_SyncRegisterForRemoteNotifications_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_SyncRegisterForRemoteNotifications_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_SyncRegisterForRemoteNotifications_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_SyncRegisterForRemoteNotifications_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_SyncRegisterForRemoteNotifications *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_SYNCREGISTERFORREMOTENOTIFICATIONS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_SyncRegisterForRemoteNotifications_state {
	struct winspool_SyncRegisterForRemoteNotifications orig;
	struct winspool_SyncRegisterForRemoteNotifications tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_SyncRegisterForRemoteNotifications_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_SyncRegisterForRemoteNotifications_send(TALLOC_CTX *mem_ctx,
									   struct tevent_context *ev,
									   struct dcerpc_binding_handle *h,
									   struct policy_handle _hPrinter /* [in]  */,
									   struct winspool_PrintPropertiesCollection *_pNotifyFilter /* [in] [ref] */,
									   struct policy_handle *_phRpcHandle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_SyncRegisterForRemoteNotifications_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_SyncRegisterForRemoteNotifications_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pNotifyFilter = _pNotifyFilter;

	/* Out parameters */
	state->orig.out.phRpcHandle = _phRpcHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_SyncRegisterForRemoteNotifications_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_SyncRegisterForRemoteNotifications_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_SyncRegisterForRemoteNotifications_done, req);
	return req;
}

static void dcerpc_winspool_SyncRegisterForRemoteNotifications_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_SyncRegisterForRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_SyncRegisterForRemoteNotifications_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_SyncRegisterForRemoteNotifications_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.phRpcHandle = *state->tmp.out.phRpcHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_SyncRegisterForRemoteNotifications_recv(struct tevent_req *req,
								 TALLOC_CTX *mem_ctx,
								 HRESULT *result)
{
	struct dcerpc_winspool_SyncRegisterForRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_SyncRegisterForRemoteNotifications_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_SyncRegisterForRemoteNotifications(struct dcerpc_binding_handle *h,
							    TALLOC_CTX *mem_ctx,
							    struct policy_handle _hPrinter /* [in]  */,
							    struct winspool_PrintPropertiesCollection *_pNotifyFilter /* [in] [ref] */,
							    struct policy_handle *_phRpcHandle /* [out] [ref] */,
							    HRESULT *result)
{
	struct winspool_SyncRegisterForRemoteNotifications r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pNotifyFilter = _pNotifyFilter;

	/* Out parameters */
	r.out.phRpcHandle = _phRpcHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_SyncRegisterForRemoteNotifications_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_phRpcHandle = *r.out.phRpcHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_SyncUnRegisterForRemoteNotifications *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_SYNCUNREGISTERFORREMOTENOTIFICATIONS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_done, req);

	return req;
}

static void dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_SyncUnRegisterForRemoteNotifications *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_SYNCUNREGISTERFORREMOTENOTIFICATIONS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_state {
	struct winspool_SyncUnRegisterForRemoteNotifications orig;
	struct winspool_SyncUnRegisterForRemoteNotifications tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_SyncUnRegisterForRemoteNotifications_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_SyncUnRegisterForRemoteNotifications_send(TALLOC_CTX *mem_ctx,
									     struct tevent_context *ev,
									     struct dcerpc_binding_handle *h,
									     struct policy_handle *_phRpcHandle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.phRpcHandle = _phRpcHandle;

	/* Out parameters */
	state->orig.out.phRpcHandle = _phRpcHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_SyncUnRegisterForRemoteNotifications_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_SyncUnRegisterForRemoteNotifications_done, req);
	return req;
}

static void dcerpc_winspool_SyncUnRegisterForRemoteNotifications_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.phRpcHandle = *state->tmp.out.phRpcHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_SyncUnRegisterForRemoteNotifications_recv(struct tevent_req *req,
								   TALLOC_CTX *mem_ctx,
								   HRESULT *result)
{
	struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_SyncUnRegisterForRemoteNotifications_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_SyncUnRegisterForRemoteNotifications(struct dcerpc_binding_handle *h,
							      TALLOC_CTX *mem_ctx,
							      struct policy_handle *_phRpcHandle /* [in,out] [ref] */,
							      HRESULT *result)
{
	struct winspool_SyncUnRegisterForRemoteNotifications r;
	NTSTATUS status;

	/* In parameters */
	r.in.phRpcHandle = _phRpcHandle;

	/* Out parameters */
	r.out.phRpcHandle = _phRpcHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_SyncUnRegisterForRemoteNotifications_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_phRpcHandle = *r.out.phRpcHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_SyncRefreshRemoteNotifications_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_SyncRefreshRemoteNotifications_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_SyncRefreshRemoteNotifications_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_SyncRefreshRemoteNotifications *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_SyncRefreshRemoteNotifications_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_SyncRefreshRemoteNotifications_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_SYNCREFRESHREMOTENOTIFICATIONS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_SyncRefreshRemoteNotifications_r_done, req);

	return req;
}

static void dcerpc_winspool_SyncRefreshRemoteNotifications_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_SyncRefreshRemoteNotifications_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_SyncRefreshRemoteNotifications_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_SyncRefreshRemoteNotifications_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_SyncRefreshRemoteNotifications_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_SyncRefreshRemoteNotifications *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_SYNCREFRESHREMOTENOTIFICATIONS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_SyncRefreshRemoteNotifications_state {
	struct winspool_SyncRefreshRemoteNotifications orig;
	struct winspool_SyncRefreshRemoteNotifications tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_SyncRefreshRemoteNotifications_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_SyncRefreshRemoteNotifications_send(TALLOC_CTX *mem_ctx,
								       struct tevent_context *ev,
								       struct dcerpc_binding_handle *h,
								       struct policy_handle _hRpcHandle /* [in]  */,
								       struct winspool_PrintPropertiesCollection *_pNotifyFilter /* [in] [ref] */,
								       struct winspool_PrintPropertiesCollection **_ppNotifyData /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_SyncRefreshRemoteNotifications_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_SyncRefreshRemoteNotifications_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hRpcHandle = _hRpcHandle;
	state->orig.in.pNotifyFilter = _pNotifyFilter;

	/* Out parameters */
	state->orig.out.ppNotifyData = _ppNotifyData;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_SyncRefreshRemoteNotifications_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_SyncRefreshRemoteNotifications_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_SyncRefreshRemoteNotifications_done, req);
	return req;
}

static void dcerpc_winspool_SyncRefreshRemoteNotifications_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_SyncRefreshRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_SyncRefreshRemoteNotifications_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_SyncRefreshRemoteNotifications_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ppNotifyData = *state->tmp.out.ppNotifyData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_SyncRefreshRemoteNotifications_recv(struct tevent_req *req,
							     TALLOC_CTX *mem_ctx,
							     HRESULT *result)
{
	struct dcerpc_winspool_SyncRefreshRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_SyncRefreshRemoteNotifications_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_SyncRefreshRemoteNotifications(struct dcerpc_binding_handle *h,
							TALLOC_CTX *mem_ctx,
							struct policy_handle _hRpcHandle /* [in]  */,
							struct winspool_PrintPropertiesCollection *_pNotifyFilter /* [in] [ref] */,
							struct winspool_PrintPropertiesCollection **_ppNotifyData /* [out] [ref] */,
							HRESULT *result)
{
	struct winspool_SyncRefreshRemoteNotifications r;
	NTSTATUS status;

	/* In parameters */
	r.in.hRpcHandle = _hRpcHandle;
	r.in.pNotifyFilter = _pNotifyFilter;

	/* Out parameters */
	r.out.ppNotifyData = _ppNotifyData;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_SyncRefreshRemoteNotifications_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ppNotifyData = *r.out.ppNotifyData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetRemoteNotifications_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetRemoteNotifications_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetRemoteNotifications_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetRemoteNotifications *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetRemoteNotifications_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetRemoteNotifications_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETREMOTENOTIFICATIONS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetRemoteNotifications_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetRemoteNotifications_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetRemoteNotifications_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetRemoteNotifications_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetRemoteNotifications_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetRemoteNotifications_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetRemoteNotifications *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETREMOTENOTIFICATIONS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetRemoteNotifications_state {
	struct winspool_AsyncGetRemoteNotifications orig;
	struct winspool_AsyncGetRemoteNotifications tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetRemoteNotifications_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetRemoteNotifications_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    struct policy_handle _hRpcHandle /* [in]  */,
								    struct winspool_PrintPropertiesCollection **_ppNotifyData /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetRemoteNotifications_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetRemoteNotifications_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hRpcHandle = _hRpcHandle;

	/* Out parameters */
	state->orig.out.ppNotifyData = _ppNotifyData;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetRemoteNotifications_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetRemoteNotifications_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetRemoteNotifications_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetRemoteNotifications_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetRemoteNotifications_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetRemoteNotifications_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ppNotifyData = *state->tmp.out.ppNotifyData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetRemoteNotifications_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  HRESULT *result)
{
	struct dcerpc_winspool_AsyncGetRemoteNotifications_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetRemoteNotifications_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetRemoteNotifications(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     struct policy_handle _hRpcHandle /* [in]  */,
						     struct winspool_PrintPropertiesCollection **_ppNotifyData /* [out] [ref] */,
						     HRESULT *result)
{
	struct winspool_AsyncGetRemoteNotifications r;
	NTSTATUS status;

	/* In parameters */
	r.in.hRpcHandle = _hRpcHandle;

	/* Out parameters */
	r.out.ppNotifyData = _ppNotifyData;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetRemoteNotifications_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ppNotifyData = *r.out.ppNotifyData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncInstallPrinterDriverFromPackage *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCINSTALLPRINTERDRIVERFROMPACKAGE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncInstallPrinterDriverFromPackage *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCINSTALLPRINTERDRIVERFROMPACKAGE, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_state {
	struct winspool_AsyncInstallPrinterDriverFromPackage orig;
	struct winspool_AsyncInstallPrinterDriverFromPackage tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_send(TALLOC_CTX *mem_ctx,
									     struct tevent_context *ev,
									     struct dcerpc_binding_handle *h,
									     const char *_pszServer /* [in] [charset(UTF16),unique] */,
									     const char *_pszInfPath /* [in] [charset(UTF16),unique] */,
									     const char *_pszDriverName /* [in] [charset(UTF16),ref] */,
									     const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
									     uint32_t _dwFlags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pszServer = _pszServer;
	state->orig.in.pszInfPath = _pszInfPath;
	state->orig.in.pszDriverName = _pszDriverName;
	state->orig.in.pszEnvironment = _pszEnvironment;
	state->orig.in.dwFlags = _dwFlags;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_done, req);
	return req;
}

static void dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_recv(struct tevent_req *req,
								   TALLOC_CTX *mem_ctx,
								   HRESULT *result)
{
	struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncInstallPrinterDriverFromPackage(struct dcerpc_binding_handle *h,
							      TALLOC_CTX *mem_ctx,
							      const char *_pszServer /* [in] [charset(UTF16),unique] */,
							      const char *_pszInfPath /* [in] [charset(UTF16),unique] */,
							      const char *_pszDriverName /* [in] [charset(UTF16),ref] */,
							      const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
							      uint32_t _dwFlags /* [in]  */,
							      HRESULT *result)
{
	struct winspool_AsyncInstallPrinterDriverFromPackage r;
	NTSTATUS status;

	/* In parameters */
	r.in.pszServer = _pszServer;
	r.in.pszInfPath = _pszInfPath;
	r.in.pszDriverName = _pszDriverName;
	r.in.pszEnvironment = _pszEnvironment;
	r.in.dwFlags = _dwFlags;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncInstallPrinterDriverFromPackage_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncUploadPrinterDriverPackage *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCUPLOADPRINTERDRIVERPACKAGE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncUploadPrinterDriverPackage_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncUploadPrinterDriverPackage *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCUPLOADPRINTERDRIVERPACKAGE, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_state {
	struct winspool_AsyncUploadPrinterDriverPackage orig;
	struct winspool_AsyncUploadPrinterDriverPackage tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncUploadPrinterDriverPackage_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncUploadPrinterDriverPackage_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct dcerpc_binding_handle *h,
									const char *_pszServer /* [in] [charset(UTF16),unique] */,
									const char *_pszInfPath /* [in] [charset(UTF16),ref] */,
									const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
									uint32_t _dwFlags /* [in]  */,
									const char *_pszDestInfPath /* [in,out] [charset(UTF16),size_is(*pcchDestInfPath),unique] */,
									uint32_t *_pcchDestInfPath /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pszServer = _pszServer;
	state->orig.in.pszInfPath = _pszInfPath;
	state->orig.in.pszEnvironment = _pszEnvironment;
	state->orig.in.dwFlags = _dwFlags;
	state->orig.in.pszDestInfPath = _pszDestInfPath;
	state->orig.in.pcchDestInfPath = _pcchDestInfPath;

	/* Out parameters */
	state->orig.out.pszDestInfPath = _pszDestInfPath;
	state->orig.out.pcchDestInfPath = _pcchDestInfPath;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncUploadPrinterDriverPackage_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncUploadPrinterDriverPackage_done, req);
	return req;
}

static void dcerpc_winspool_AsyncUploadPrinterDriverPackage_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncUploadPrinterDriverPackage_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pszDestInfPath && state->tmp.out.pszDestInfPath) {
		{
			size_t _copy_len_pszDestInfPath;
			if ((*state->tmp.out.pcchDestInfPath) > (*state->tmp.in.pcchDestInfPath)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			_copy_len_pszDestInfPath = ndr_charset_length(state->tmp.out.pszDestInfPath, CH_UNIX);
			if (_copy_len_pszDestInfPath > ndr_charset_length(state->tmp.in.pszDestInfPath, CH_UNIX)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			if (state->orig.out.pszDestInfPath != state->tmp.out.pszDestInfPath) {
				memcpy(discard_const_p(uint8_t *, state->orig.out.pszDestInfPath), state->tmp.out.pszDestInfPath, _copy_len_pszDestInfPath * sizeof(*state->orig.out.pszDestInfPath));
			}
		}
	}
	*state->orig.out.pcchDestInfPath = *state->tmp.out.pcchDestInfPath;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncUploadPrinterDriverPackage_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      HRESULT *result)
{
	struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncUploadPrinterDriverPackage_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncUploadPrinterDriverPackage(struct dcerpc_binding_handle *h,
							 TALLOC_CTX *mem_ctx,
							 const char *_pszServer /* [in] [charset(UTF16),unique] */,
							 const char *_pszInfPath /* [in] [charset(UTF16),ref] */,
							 const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
							 uint32_t _dwFlags /* [in]  */,
							 const char *_pszDestInfPath /* [in,out] [charset(UTF16),size_is(*pcchDestInfPath),unique] */,
							 uint32_t *_pcchDestInfPath /* [in,out] [ref] */,
							 HRESULT *result)
{
	struct winspool_AsyncUploadPrinterDriverPackage r;
	NTSTATUS status;

	/* In parameters */
	r.in.pszServer = _pszServer;
	r.in.pszInfPath = _pszInfPath;
	r.in.pszEnvironment = _pszEnvironment;
	r.in.dwFlags = _dwFlags;
	r.in.pszDestInfPath = _pszDestInfPath;
	r.in.pcchDestInfPath = _pcchDestInfPath;

	/* Out parameters */
	r.out.pszDestInfPath = _pszDestInfPath;
	r.out.pcchDestInfPath = _pcchDestInfPath;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncUploadPrinterDriverPackage_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pszDestInfPath && r.out.pszDestInfPath) {
		{
			size_t _copy_len_pszDestInfPath;
			if ((*r.out.pcchDestInfPath) > (*r.in.pcchDestInfPath)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			_copy_len_pszDestInfPath = ndr_charset_length(r.out.pszDestInfPath, CH_UNIX);
			if (_copy_len_pszDestInfPath > ndr_charset_length(r.in.pszDestInfPath, CH_UNIX)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			if (_pszDestInfPath != r.out.pszDestInfPath) {
				memcpy(discard_const_p(uint8_t *, _pszDestInfPath), r.out.pszDestInfPath, _copy_len_pszDestInfPath * sizeof(*_pszDestInfPath));
			}
		}
	}
	*_pcchDestInfPath = *r.out.pcchDestInfPath;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetCorePrinterDrivers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetCorePrinterDrivers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetCorePrinterDrivers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetCorePrinterDrivers *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetCorePrinterDrivers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetCorePrinterDrivers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETCOREPRINTERDRIVERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetCorePrinterDrivers_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetCorePrinterDrivers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetCorePrinterDrivers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetCorePrinterDrivers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetCorePrinterDrivers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetCorePrinterDrivers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetCorePrinterDrivers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETCOREPRINTERDRIVERS, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetCorePrinterDrivers_state {
	struct winspool_AsyncGetCorePrinterDrivers orig;
	struct winspool_AsyncGetCorePrinterDrivers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetCorePrinterDrivers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetCorePrinterDrivers_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   const char *_pszServer /* [in] [charset(UTF16),unique] */,
								   const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
								   uint32_t _cchCoreDrivers /* [in]  */,
								   uint16_t *_pszzCoreDriverDependencies /* [in] [ref,size_is(cchCoreDrivers)] */,
								   uint32_t _cCorePrinterDrivers /* [in]  */,
								   struct spoolss_CorePrinterDriver *_pCorePrinterDrivers /* [out] [ref,size_is(cCorePrinterDrivers)] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetCorePrinterDrivers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetCorePrinterDrivers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pszServer = _pszServer;
	state->orig.in.pszEnvironment = _pszEnvironment;
	state->orig.in.cchCoreDrivers = _cchCoreDrivers;
	state->orig.in.pszzCoreDriverDependencies = _pszzCoreDriverDependencies;
	state->orig.in.cCorePrinterDrivers = _cCorePrinterDrivers;

	/* Out parameters */
	state->orig.out.pCorePrinterDrivers = _pCorePrinterDrivers;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetCorePrinterDrivers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetCorePrinterDrivers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetCorePrinterDrivers_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetCorePrinterDrivers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetCorePrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetCorePrinterDrivers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetCorePrinterDrivers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_pCorePrinterDrivers;
		_copy_len_pCorePrinterDrivers = state->tmp.in.cCorePrinterDrivers;
		if (state->orig.out.pCorePrinterDrivers != state->tmp.out.pCorePrinterDrivers) {
			memcpy(state->orig.out.pCorePrinterDrivers, state->tmp.out.pCorePrinterDrivers, _copy_len_pCorePrinterDrivers * sizeof(*state->orig.out.pCorePrinterDrivers));
		}
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetCorePrinterDrivers_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 HRESULT *result)
{
	struct dcerpc_winspool_AsyncGetCorePrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetCorePrinterDrivers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetCorePrinterDrivers(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    const char *_pszServer /* [in] [charset(UTF16),unique] */,
						    const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
						    uint32_t _cchCoreDrivers /* [in]  */,
						    uint16_t *_pszzCoreDriverDependencies /* [in] [ref,size_is(cchCoreDrivers)] */,
						    uint32_t _cCorePrinterDrivers /* [in]  */,
						    struct spoolss_CorePrinterDriver *_pCorePrinterDrivers /* [out] [ref,size_is(cCorePrinterDrivers)] */,
						    HRESULT *result)
{
	struct winspool_AsyncGetCorePrinterDrivers r;
	NTSTATUS status;

	/* In parameters */
	r.in.pszServer = _pszServer;
	r.in.pszEnvironment = _pszEnvironment;
	r.in.cchCoreDrivers = _cchCoreDrivers;
	r.in.pszzCoreDriverDependencies = _pszzCoreDriverDependencies;
	r.in.cCorePrinterDrivers = _cCorePrinterDrivers;

	/* Out parameters */
	r.out.pCorePrinterDrivers = _pCorePrinterDrivers;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetCorePrinterDrivers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_pCorePrinterDrivers;
		_copy_len_pCorePrinterDrivers = r.in.cCorePrinterDrivers;
		if (_pCorePrinterDrivers != r.out.pCorePrinterDrivers) {
			memcpy(_pCorePrinterDrivers, r.out.pCorePrinterDrivers, _copy_len_pCorePrinterDrivers * sizeof(*_pCorePrinterDrivers));
		}
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncCorePrinterDriverInstalled *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCCOREPRINTERDRIVERINSTALLED, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncCorePrinterDriverInstalled_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncCorePrinterDriverInstalled *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCCOREPRINTERDRIVERINSTALLED, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_state {
	struct winspool_AsyncCorePrinterDriverInstalled orig;
	struct winspool_AsyncCorePrinterDriverInstalled tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncCorePrinterDriverInstalled_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncCorePrinterDriverInstalled_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct dcerpc_binding_handle *h,
									const char *_pszServer /* [in] [charset(UTF16),unique] */,
									const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
									struct GUID _CoreDriverGUID /* [in]  */,
									NTTIME _ftDriverDate /* [in]  */,
									uint64_t _dwlDriverVersion /* [in]  */,
									int32_t *_pbDriverInstalled /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pszServer = _pszServer;
	state->orig.in.pszEnvironment = _pszEnvironment;
	state->orig.in.CoreDriverGUID = _CoreDriverGUID;
	state->orig.in.ftDriverDate = _ftDriverDate;
	state->orig.in.dwlDriverVersion = _dwlDriverVersion;

	/* Out parameters */
	state->orig.out.pbDriverInstalled = _pbDriverInstalled;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncCorePrinterDriverInstalled_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncCorePrinterDriverInstalled_done, req);
	return req;
}

static void dcerpc_winspool_AsyncCorePrinterDriverInstalled_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncCorePrinterDriverInstalled_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pbDriverInstalled = *state->tmp.out.pbDriverInstalled;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncCorePrinterDriverInstalled_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      HRESULT *result)
{
	struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncCorePrinterDriverInstalled_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncCorePrinterDriverInstalled(struct dcerpc_binding_handle *h,
							 TALLOC_CTX *mem_ctx,
							 const char *_pszServer /* [in] [charset(UTF16),unique] */,
							 const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
							 struct GUID _CoreDriverGUID /* [in]  */,
							 NTTIME _ftDriverDate /* [in]  */,
							 uint64_t _dwlDriverVersion /* [in]  */,
							 int32_t *_pbDriverInstalled /* [out] [ref] */,
							 HRESULT *result)
{
	struct winspool_AsyncCorePrinterDriverInstalled r;
	NTSTATUS status;

	/* In parameters */
	r.in.pszServer = _pszServer;
	r.in.pszEnvironment = _pszEnvironment;
	r.in.CoreDriverGUID = _CoreDriverGUID;
	r.in.ftDriverDate = _ftDriverDate;
	r.in.dwlDriverVersion = _dwlDriverVersion;

	/* Out parameters */
	r.out.pbDriverInstalled = _pbDriverInstalled;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncCorePrinterDriverInstalled_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pbDriverInstalled = *r.out.pbDriverInstalled;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetPrinterDriverPackagePath *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDRIVERPACKAGEPATH, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetPrinterDriverPackagePath *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETPRINTERDRIVERPACKAGEPATH, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_state {
	struct winspool_AsyncGetPrinterDriverPackagePath orig;
	struct winspool_AsyncGetPrinterDriverPackagePath tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetPrinterDriverPackagePath_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetPrinterDriverPackagePath_send(TALLOC_CTX *mem_ctx,
									 struct tevent_context *ev,
									 struct dcerpc_binding_handle *h,
									 const char *_pszServer /* [in] [charset(UTF16),unique] */,
									 const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
									 const char *_pszLanguage /* [in] [charset(UTF16),unique] */,
									 const char *_pszPackageID /* [in] [charset(UTF16),ref] */,
									 uint16_t *_pszDriverPackageCab /* [in,out] [size_is(cchDriverPackageCab),unique] */,
									 uint32_t _cchDriverPackageCab /* [in]  */,
									 uint32_t *_pcchRequiredSize /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pszServer = _pszServer;
	state->orig.in.pszEnvironment = _pszEnvironment;
	state->orig.in.pszLanguage = _pszLanguage;
	state->orig.in.pszPackageID = _pszPackageID;
	state->orig.in.pszDriverPackageCab = _pszDriverPackageCab;
	state->orig.in.cchDriverPackageCab = _cchDriverPackageCab;

	/* Out parameters */
	state->orig.out.pszDriverPackageCab = _pszDriverPackageCab;
	state->orig.out.pcchRequiredSize = _pcchRequiredSize;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetPrinterDriverPackagePath_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetPrinterDriverPackagePath_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetPrinterDriverPackagePath_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.pszDriverPackageCab && state->tmp.out.pszDriverPackageCab) {
		{
			size_t _copy_len_pszDriverPackageCab;
			_copy_len_pszDriverPackageCab = state->tmp.in.cchDriverPackageCab;
			if (state->orig.out.pszDriverPackageCab != state->tmp.out.pszDriverPackageCab) {
				memcpy(state->orig.out.pszDriverPackageCab, state->tmp.out.pszDriverPackageCab, _copy_len_pszDriverPackageCab * sizeof(*state->orig.out.pszDriverPackageCab));
			}
		}
	}
	*state->orig.out.pcchRequiredSize = *state->tmp.out.pcchRequiredSize;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverPackagePath_recv(struct tevent_req *req,
							       TALLOC_CTX *mem_ctx,
							       HRESULT *result)
{
	struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetPrinterDriverPackagePath_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetPrinterDriverPackagePath(struct dcerpc_binding_handle *h,
							  TALLOC_CTX *mem_ctx,
							  const char *_pszServer /* [in] [charset(UTF16),unique] */,
							  const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
							  const char *_pszLanguage /* [in] [charset(UTF16),unique] */,
							  const char *_pszPackageID /* [in] [charset(UTF16),ref] */,
							  uint16_t *_pszDriverPackageCab /* [in,out] [size_is(cchDriverPackageCab),unique] */,
							  uint32_t _cchDriverPackageCab /* [in]  */,
							  uint32_t *_pcchRequiredSize /* [out] [ref] */,
							  HRESULT *result)
{
	struct winspool_AsyncGetPrinterDriverPackagePath r;
	NTSTATUS status;

	/* In parameters */
	r.in.pszServer = _pszServer;
	r.in.pszEnvironment = _pszEnvironment;
	r.in.pszLanguage = _pszLanguage;
	r.in.pszPackageID = _pszPackageID;
	r.in.pszDriverPackageCab = _pszDriverPackageCab;
	r.in.cchDriverPackageCab = _cchDriverPackageCab;

	/* Out parameters */
	r.out.pszDriverPackageCab = _pszDriverPackageCab;
	r.out.pcchRequiredSize = _pcchRequiredSize;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetPrinterDriverPackagePath_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_pszDriverPackageCab && r.out.pszDriverPackageCab) {
		{
			size_t _copy_len_pszDriverPackageCab;
			_copy_len_pszDriverPackageCab = r.in.cchDriverPackageCab;
			if (_pszDriverPackageCab != r.out.pszDriverPackageCab) {
				memcpy(_pszDriverPackageCab, r.out.pszDriverPackageCab, _copy_len_pszDriverPackageCab * sizeof(*_pszDriverPackageCab));
			}
		}
	}
	*_pcchRequiredSize = *r.out.pcchRequiredSize;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeletePrinterDriverPackage *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVERPACKAGE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverPackage_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeletePrinterDriverPackage *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVERPACKAGE, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_state {
	struct winspool_AsyncDeletePrinterDriverPackage orig;
	struct winspool_AsyncDeletePrinterDriverPackage tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeletePrinterDriverPackage_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeletePrinterDriverPackage_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct dcerpc_binding_handle *h,
									const char *_pszServer /* [in] [charset(UTF16),unique] */,
									const char *_pszInfPath /* [in] [charset(UTF16),ref] */,
									const char *_pszEnvironment /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pszServer = _pszServer;
	state->orig.in.pszInfPath = _pszInfPath;
	state->orig.in.pszEnvironment = _pszEnvironment;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeletePrinterDriverPackage_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeletePrinterDriverPackage_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeletePrinterDriverPackage_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverPackage_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      HRESULT *result)
{
	struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeletePrinterDriverPackage_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeletePrinterDriverPackage(struct dcerpc_binding_handle *h,
							 TALLOC_CTX *mem_ctx,
							 const char *_pszServer /* [in] [charset(UTF16),unique] */,
							 const char *_pszInfPath /* [in] [charset(UTF16),ref] */,
							 const char *_pszEnvironment /* [in] [charset(UTF16),ref] */,
							 HRESULT *result)
{
	struct winspool_AsyncDeletePrinterDriverPackage r;
	NTSTATUS status;

	/* In parameters */
	r.in.pszServer = _pszServer;
	r.in.pszInfPath = _pszInfPath;
	r.in.pszEnvironment = _pszEnvironment;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeletePrinterDriverPackage_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncReadPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncReadPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncReadPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncReadPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncReadPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncReadPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCREADPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncReadPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncReadPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncReadPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncReadPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncReadPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncReadPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncReadPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCREADPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncReadPrinter_state {
	struct winspool_AsyncReadPrinter orig;
	struct winspool_AsyncReadPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncReadPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncReadPrinter_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle _hPrinter /* [in]  */,
							 uint8_t *_pBuf /* [out] [ref,size_is(cbBuf)] */,
							 uint32_t _cbBuf /* [in]  */,
							 uint32_t *_pcNoBytesRead /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncReadPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncReadPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.cbBuf = _cbBuf;

	/* Out parameters */
	state->orig.out.pBuf = _pBuf;
	state->orig.out.pcNoBytesRead = _pcNoBytesRead;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncReadPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncReadPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncReadPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncReadPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncReadPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncReadPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncReadPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_pBuf;
		_copy_len_pBuf = state->tmp.in.cbBuf;
		if (state->orig.out.pBuf != state->tmp.out.pBuf) {
			memcpy(state->orig.out.pBuf, state->tmp.out.pBuf, _copy_len_pBuf * sizeof(*state->orig.out.pBuf));
		}
	}
	*state->orig.out.pcNoBytesRead = *state->tmp.out.pcNoBytesRead;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncReadPrinter_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_winspool_AsyncReadPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncReadPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncReadPrinter(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle _hPrinter /* [in]  */,
					  uint8_t *_pBuf /* [out] [ref,size_is(cbBuf)] */,
					  uint32_t _cbBuf /* [in]  */,
					  uint32_t *_pcNoBytesRead /* [out] [ref] */,
					  WERROR *result)
{
	struct winspool_AsyncReadPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.cbBuf = _cbBuf;

	/* Out parameters */
	r.out.pBuf = _pBuf;
	r.out.pcNoBytesRead = _pcNoBytesRead;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncReadPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_pBuf;
		_copy_len_pBuf = r.in.cbBuf;
		if (_pBuf != r.out.pBuf) {
			memcpy(_pBuf, r.out.pBuf, _copy_len_pBuf * sizeof(*_pBuf));
		}
	}
	*_pcNoBytesRead = *r.out.pcNoBytesRead;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncResetPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncResetPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncResetPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncResetPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncResetPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncResetPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCRESETPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncResetPrinter_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncResetPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncResetPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncResetPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncResetPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncResetPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncResetPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCRESETPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncResetPrinter_state {
	struct winspool_AsyncResetPrinter orig;
	struct winspool_AsyncResetPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncResetPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncResetPrinter_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hPrinter /* [in]  */,
							  const char *_pDatatype /* [in] [charset(UTF16),unique] */,
							  struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncResetPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncResetPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pDatatype = _pDatatype;
	state->orig.in.pDevModeContainer = _pDevModeContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncResetPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncResetPrinter_done, req);
	return req;
}

static void dcerpc_winspool_AsyncResetPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncResetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncResetPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncResetPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncResetPrinter_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winspool_AsyncResetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncResetPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncResetPrinter(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hPrinter /* [in]  */,
					   const char *_pDatatype /* [in] [charset(UTF16),unique] */,
					   struct spoolss_DevmodeContainer *_pDevModeContainer /* [in] [ref] */,
					   WERROR *result)
{
	struct winspool_AsyncResetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pDatatype = _pDatatype;
	r.in.pDevModeContainer = _pDevModeContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncResetPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncGetJobNamedPropertyValue *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETJOBNAMEDPROPERTYVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetJobNamedPropertyValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncGetJobNamedPropertyValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCGETJOBNAMEDPROPERTYVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_state {
	struct winspool_AsyncGetJobNamedPropertyValue orig;
	struct winspool_AsyncGetJobNamedPropertyValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncGetJobNamedPropertyValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncGetJobNamedPropertyValue_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct dcerpc_binding_handle *h,
								      struct policy_handle _hPrinter /* [in]  */,
								      uint32_t _JobId /* [in]  */,
								      const char *_pszName /* [in] [charset(UTF16),ref] */,
								      struct spoolss_PrintPropertyValue *_pValue /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.JobId = _JobId;
	state->orig.in.pszName = _pszName;

	/* Out parameters */
	state->orig.out.pValue = _pValue;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncGetJobNamedPropertyValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncGetJobNamedPropertyValue_done, req);
	return req;
}

static void dcerpc_winspool_AsyncGetJobNamedPropertyValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncGetJobNamedPropertyValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pValue = *state->tmp.out.pValue;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncGetJobNamedPropertyValue_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx,
							    WERROR *result)
{
	struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncGetJobNamedPropertyValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncGetJobNamedPropertyValue(struct dcerpc_binding_handle *h,
						       TALLOC_CTX *mem_ctx,
						       struct policy_handle _hPrinter /* [in]  */,
						       uint32_t _JobId /* [in]  */,
						       const char *_pszName /* [in] [charset(UTF16),ref] */,
						       struct spoolss_PrintPropertyValue *_pValue /* [out] [ref] */,
						       WERROR *result)
{
	struct winspool_AsyncGetJobNamedPropertyValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.JobId = _JobId;
	r.in.pszName = _pszName;

	/* Out parameters */
	r.out.pValue = _pValue;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncGetJobNamedPropertyValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pValue = *r.out.pValue;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncSetJobNamedProperty_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetJobNamedProperty_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetJobNamedProperty_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncSetJobNamedProperty *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetJobNamedProperty_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetJobNamedProperty_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETJOBNAMEDPROPERTY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetJobNamedProperty_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncSetJobNamedProperty_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetJobNamedProperty_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncSetJobNamedProperty_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncSetJobNamedProperty_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetJobNamedProperty_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncSetJobNamedProperty *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCSETJOBNAMEDPROPERTY, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncSetJobNamedProperty_state {
	struct winspool_AsyncSetJobNamedProperty orig;
	struct winspool_AsyncSetJobNamedProperty tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncSetJobNamedProperty_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncSetJobNamedProperty_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct policy_handle _hPrinter /* [in]  */,
								 uint32_t _JobId /* [in]  */,
								 struct spoolss_PrintNamedProperty *_pProperty /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncSetJobNamedProperty_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncSetJobNamedProperty_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.JobId = _JobId;
	state->orig.in.pProperty = _pProperty;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncSetJobNamedProperty_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncSetJobNamedProperty_done, req);
	return req;
}

static void dcerpc_winspool_AsyncSetJobNamedProperty_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncSetJobNamedProperty_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetJobNamedProperty_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncSetJobNamedProperty_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncSetJobNamedProperty_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_winspool_AsyncSetJobNamedProperty_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncSetJobNamedProperty_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncSetJobNamedProperty(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle _hPrinter /* [in]  */,
						  uint32_t _JobId /* [in]  */,
						  struct spoolss_PrintNamedProperty *_pProperty /* [in] [ref] */,
						  WERROR *result)
{
	struct winspool_AsyncSetJobNamedProperty r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.JobId = _JobId;
	r.in.pProperty = _pProperty;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncSetJobNamedProperty_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncDeleteJobNamedProperty_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeleteJobNamedProperty_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeleteJobNamedProperty_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncDeleteJobNamedProperty *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeleteJobNamedProperty_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeleteJobNamedProperty_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEJOBNAMEDPROPERTY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeleteJobNamedProperty_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncDeleteJobNamedProperty_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeleteJobNamedProperty_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncDeleteJobNamedProperty_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncDeleteJobNamedProperty_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeleteJobNamedProperty_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncDeleteJobNamedProperty *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCDELETEJOBNAMEDPROPERTY, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncDeleteJobNamedProperty_state {
	struct winspool_AsyncDeleteJobNamedProperty orig;
	struct winspool_AsyncDeleteJobNamedProperty tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncDeleteJobNamedProperty_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncDeleteJobNamedProperty_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    struct policy_handle _hPrinter /* [in]  */,
								    uint32_t _JobId /* [in]  */,
								    const char *_pszName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncDeleteJobNamedProperty_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncDeleteJobNamedProperty_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.JobId = _JobId;
	state->orig.in.pszName = _pszName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncDeleteJobNamedProperty_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncDeleteJobNamedProperty_done, req);
	return req;
}

static void dcerpc_winspool_AsyncDeleteJobNamedProperty_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncDeleteJobNamedProperty_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeleteJobNamedProperty_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncDeleteJobNamedProperty_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncDeleteJobNamedProperty_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct dcerpc_winspool_AsyncDeleteJobNamedProperty_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncDeleteJobNamedProperty_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncDeleteJobNamedProperty(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     struct policy_handle _hPrinter /* [in]  */,
						     uint32_t _JobId /* [in]  */,
						     const char *_pszName /* [in] [charset(UTF16),ref] */,
						     WERROR *result)
{
	struct winspool_AsyncDeleteJobNamedProperty r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.JobId = _JobId;
	r.in.pszName = _pszName;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncDeleteJobNamedProperty_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncEnumJobNamedProperties_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumJobNamedProperties_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumJobNamedProperties_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncEnumJobNamedProperties *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumJobNamedProperties_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumJobNamedProperties_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMJOBNAMEDPROPERTIES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumJobNamedProperties_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncEnumJobNamedProperties_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumJobNamedProperties_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncEnumJobNamedProperties_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncEnumJobNamedProperties_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumJobNamedProperties_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncEnumJobNamedProperties *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCENUMJOBNAMEDPROPERTIES, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncEnumJobNamedProperties_state {
	struct winspool_AsyncEnumJobNamedProperties orig;
	struct winspool_AsyncEnumJobNamedProperties tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncEnumJobNamedProperties_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncEnumJobNamedProperties_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    struct policy_handle _hPrinter /* [in]  */,
								    uint32_t _JobId /* [in]  */,
								    uint32_t *_pcProperties /* [out] [ref] */,
								    struct spoolss_PrintNamedProperty **_ppProperties /* [out] [ref,size_is(,*pcProperties)] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncEnumJobNamedProperties_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncEnumJobNamedProperties_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.JobId = _JobId;

	/* Out parameters */
	state->orig.out.pcProperties = _pcProperties;
	state->orig.out.ppProperties = _ppProperties;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winspool_AsyncEnumJobNamedProperties_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncEnumJobNamedProperties_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncEnumJobNamedProperties_done, req);
	return req;
}

static void dcerpc_winspool_AsyncEnumJobNamedProperties_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncEnumJobNamedProperties_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumJobNamedProperties_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncEnumJobNamedProperties_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pcProperties = *state->tmp.out.pcProperties;
	*state->orig.out.ppProperties = *state->tmp.out.ppProperties;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncEnumJobNamedProperties_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct dcerpc_winspool_AsyncEnumJobNamedProperties_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncEnumJobNamedProperties_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncEnumJobNamedProperties(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     struct policy_handle _hPrinter /* [in]  */,
						     uint32_t _JobId /* [in]  */,
						     uint32_t *_pcProperties /* [out] [ref] */,
						     struct spoolss_PrintNamedProperty **_ppProperties /* [out] [ref,size_is(,*pcProperties)] */,
						     WERROR *result)
{
	struct winspool_AsyncEnumJobNamedProperties r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.JobId = _JobId;

	/* Out parameters */
	r.out.pcProperties = _pcProperties;
	r.out.ppProperties = _ppProperties;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncEnumJobNamedProperties_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pcProperties = *r.out.pcProperties;
	*_ppProperties = *r.out.ppProperties;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winspool_AsyncLogJobInfoForBranchOffice *r)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCLOGJOBINFOFORBRANCHOFFICE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_done, req);

	return req;
}

static void dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winspool_AsyncLogJobInfoForBranchOffice *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_iremotewinspool,
			NDR_WINSPOOL_ASYNCLOGJOBINFOFORBRANCHOFFICE, mem_ctx, r);

	return status;
}

struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_state {
	struct winspool_AsyncLogJobInfoForBranchOffice orig;
	struct winspool_AsyncLogJobInfoForBranchOffice tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winspool_AsyncLogJobInfoForBranchOffice_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winspool_AsyncLogJobInfoForBranchOffice_send(TALLOC_CTX *mem_ctx,
								       struct tevent_context *ev,
								       struct dcerpc_binding_handle *h,
								       struct policy_handle _hPrinter /* [in]  */,
								       struct spoolss_BranchOfficeJobDataContainer *_pBranchOfficeJobDataContainer /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hPrinter = _hPrinter;
	state->orig.in.pBranchOfficeJobDataContainer = _pBranchOfficeJobDataContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winspool_AsyncLogJobInfoForBranchOffice_done, req);
	return req;
}

static void dcerpc_winspool_AsyncLogJobInfoForBranchOffice_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winspool_AsyncLogJobInfoForBranchOffice_recv(struct tevent_req *req,
							     TALLOC_CTX *mem_ctx,
							     WERROR *result)
{
	struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_state *state = tevent_req_data(
		req, struct dcerpc_winspool_AsyncLogJobInfoForBranchOffice_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winspool_AsyncLogJobInfoForBranchOffice(struct dcerpc_binding_handle *h,
							TALLOC_CTX *mem_ctx,
							struct policy_handle _hPrinter /* [in]  */,
							struct spoolss_BranchOfficeJobDataContainer *_pBranchOfficeJobDataContainer /* [in] [ref] */,
							WERROR *result)
{
	struct winspool_AsyncLogJobInfoForBranchOffice r;
	NTSTATUS status;

	/* In parameters */
	r.in.hPrinter = _hPrinter;
	r.in.pBranchOfficeJobDataContainer = _pBranchOfficeJobDataContainer;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_winspool_AsyncLogJobInfoForBranchOffice_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

