/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_echo.h"
#include "bin/default/librpc/gen_ndr/ndr_echo_c.h"

/* rpcecho - client functions generated by pidl */

struct dcerpc_echo_AddOne_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_AddOne_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_AddOne_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_AddOne *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_AddOne_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_AddOne_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_ADDONE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_AddOne_r_done, req);

	return req;
}

static void dcerpc_echo_AddOne_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_AddOne_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_AddOne_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_AddOne_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_AddOne_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_AddOne *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_ADDONE, mem_ctx, r);

	return status;
}

struct dcerpc_echo_AddOne_state {
	struct echo_AddOne orig;
	struct echo_AddOne tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_AddOne_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_AddOne_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   uint32_t _in_data /* [in]  */,
					   uint32_t *_out_data /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_AddOne_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_AddOne_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.in_data = _in_data;

	/* Out parameters */
	state->orig.out.out_data = _out_data;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_echo_AddOne_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_AddOne_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_AddOne_done, req);
	return req;
}

static void dcerpc_echo_AddOne_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_AddOne_state *state = tevent_req_data(
		req, struct dcerpc_echo_AddOne_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_AddOne_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.out_data = *state->tmp.out.out_data;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_AddOne_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_AddOne_state *state = tevent_req_data(
		req, struct dcerpc_echo_AddOne_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_AddOne(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    uint32_t _in_data /* [in]  */,
			    uint32_t *_out_data /* [out] [ref] */)
{
	struct echo_AddOne r;
	NTSTATUS status;

	/* In parameters */
	r.in.in_data = _in_data;

	/* Out parameters */
	r.out.out_data = _out_data;

	status = dcerpc_echo_AddOne_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_out_data = *r.out.out_data;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_echo_EchoData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_EchoData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_EchoData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_EchoData *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_EchoData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_EchoData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_ECHODATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_EchoData_r_done, req);

	return req;
}

static void dcerpc_echo_EchoData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_EchoData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_EchoData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_EchoData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_EchoData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_EchoData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_ECHODATA, mem_ctx, r);

	return status;
}

struct dcerpc_echo_EchoData_state {
	struct echo_EchoData orig;
	struct echo_EchoData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_EchoData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_EchoData_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     uint32_t _len /* [in]  */,
					     uint8_t *_in_data /* [in] [size_is(len)] */,
					     uint8_t *_out_data /* [out] [size_is(len)] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_EchoData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_EchoData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.len = _len;
	state->orig.in.in_data = _in_data;

	/* Out parameters */
	state->orig.out.out_data = _out_data;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_echo_EchoData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_EchoData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_EchoData_done, req);
	return req;
}

static void dcerpc_echo_EchoData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_EchoData_state *state = tevent_req_data(
		req, struct dcerpc_echo_EchoData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_EchoData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_out_data;
		_copy_len_out_data = state->tmp.in.len;
		if (state->orig.out.out_data != state->tmp.out.out_data) {
			memcpy(state->orig.out.out_data, state->tmp.out.out_data, _copy_len_out_data * sizeof(*state->orig.out.out_data));
		}
	}

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_EchoData_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_EchoData_state *state = tevent_req_data(
		req, struct dcerpc_echo_EchoData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_EchoData(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      uint32_t _len /* [in]  */,
			      uint8_t *_in_data /* [in] [size_is(len)] */,
			      uint8_t *_out_data /* [out] [size_is(len)] */)
{
	struct echo_EchoData r;
	NTSTATUS status;

	/* In parameters */
	r.in.len = _len;
	r.in.in_data = _in_data;

	/* Out parameters */
	r.out.out_data = _out_data;

	status = dcerpc_echo_EchoData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_out_data;
		_copy_len_out_data = r.in.len;
		if (_out_data != r.out.out_data) {
			memcpy(_out_data, r.out.out_data, _copy_len_out_data * sizeof(*_out_data));
		}
	}

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_echo_SinkData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_SinkData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_SinkData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_SinkData *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_SinkData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_SinkData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_SINKDATA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_SinkData_r_done, req);

	return req;
}

static void dcerpc_echo_SinkData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_SinkData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_SinkData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_SinkData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_SinkData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_SinkData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_SINKDATA, mem_ctx, r);

	return status;
}

struct dcerpc_echo_SinkData_state {
	struct echo_SinkData orig;
	struct echo_SinkData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_SinkData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_SinkData_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     uint32_t _len /* [in]  */,
					     uint8_t *_data /* [in] [size_is(len)] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_SinkData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_SinkData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.len = _len;
	state->orig.in.data = _data;

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_SinkData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_SinkData_done, req);
	return req;
}

static void dcerpc_echo_SinkData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_SinkData_state *state = tevent_req_data(
		req, struct dcerpc_echo_SinkData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_SinkData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_SinkData_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_SinkData_state *state = tevent_req_data(
		req, struct dcerpc_echo_SinkData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_SinkData(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      uint32_t _len /* [in]  */,
			      uint8_t *_data /* [in] [size_is(len)] */)
{
	struct echo_SinkData r;
	NTSTATUS status;

	/* In parameters */
	r.in.len = _len;
	r.in.data = _data;

	/* Out parameters */

	status = dcerpc_echo_SinkData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_echo_SourceData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_SourceData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_SourceData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_SourceData *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_SourceData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_SourceData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_SOURCEDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_SourceData_r_done, req);

	return req;
}

static void dcerpc_echo_SourceData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_SourceData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_SourceData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_SourceData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_SourceData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_SourceData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_SOURCEDATA, mem_ctx, r);

	return status;
}

struct dcerpc_echo_SourceData_state {
	struct echo_SourceData orig;
	struct echo_SourceData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_SourceData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_SourceData_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint32_t _len /* [in]  */,
					       uint8_t *_data /* [out] [size_is(len)] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_SourceData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_SourceData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.len = _len;

	/* Out parameters */
	state->orig.out.data = _data;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_echo_SourceData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_SourceData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_SourceData_done, req);
	return req;
}

static void dcerpc_echo_SourceData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_SourceData_state *state = tevent_req_data(
		req, struct dcerpc_echo_SourceData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_SourceData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_data;
		_copy_len_data = state->tmp.in.len;
		if (state->orig.out.data != state->tmp.out.data) {
			memcpy(state->orig.out.data, state->tmp.out.data, _copy_len_data * sizeof(*state->orig.out.data));
		}
	}

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_SourceData_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_SourceData_state *state = tevent_req_data(
		req, struct dcerpc_echo_SourceData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_SourceData(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint32_t _len /* [in]  */,
				uint8_t *_data /* [out] [size_is(len)] */)
{
	struct echo_SourceData r;
	NTSTATUS status;

	/* In parameters */
	r.in.len = _len;

	/* Out parameters */
	r.out.data = _data;

	status = dcerpc_echo_SourceData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_data;
		_copy_len_data = r.in.len;
		if (_data != r.out.data) {
			memcpy(_data, r.out.data, _copy_len_data * sizeof(*_data));
		}
	}

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_echo_TestCall_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestCall_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestCall_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_TestCall *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestCall_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestCall_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTCALL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestCall_r_done, req);

	return req;
}

static void dcerpc_echo_TestCall_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestCall_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestCall_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_TestCall_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestCall_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_TestCall *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTCALL, mem_ctx, r);

	return status;
}

struct dcerpc_echo_TestCall_state {
	struct echo_TestCall orig;
	struct echo_TestCall tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestCall_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestCall_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_s1 /* [in] [charset(UTF16),ref] */,
					     const char **_s2 /* [out] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestCall_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestCall_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.s1 = _s1;

	/* Out parameters */
	state->orig.out.s2 = _s2;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_echo_TestCall_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_TestCall_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestCall_done, req);
	return req;
}

static void dcerpc_echo_TestCall_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_TestCall_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestCall_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_TestCall_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.s2 = *state->tmp.out.s2;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestCall_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestCall_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestCall_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestCall(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_s1 /* [in] [charset(UTF16),ref] */,
			      const char **_s2 /* [out] [charset(UTF16),ref] */)
{
	struct echo_TestCall r;
	NTSTATUS status;

	/* In parameters */
	r.in.s1 = _s1;

	/* Out parameters */
	r.out.s2 = _s2;

	status = dcerpc_echo_TestCall_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_s2 = *r.out.s2;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_echo_TestCall2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestCall2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestCall2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_TestCall2 *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestCall2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestCall2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTCALL2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestCall2_r_done, req);

	return req;
}

static void dcerpc_echo_TestCall2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestCall2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestCall2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_TestCall2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestCall2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_TestCall2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTCALL2, mem_ctx, r);

	return status;
}

struct dcerpc_echo_TestCall2_state {
	struct echo_TestCall2 orig;
	struct echo_TestCall2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestCall2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestCall2_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      uint16_t _level /* [in]  */,
					      union echo_Info *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestCall2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestCall2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_echo_TestCall2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_TestCall2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestCall2_done, req);
	return req;
}

static void dcerpc_echo_TestCall2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_TestCall2_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestCall2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_TestCall2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestCall2_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct dcerpc_echo_TestCall2_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestCall2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestCall2(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       uint16_t _level /* [in]  */,
			       union echo_Info *_info /* [out] [ref,switch_is(level)] */,
			       NTSTATUS *result)
{
	struct echo_TestCall2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_echo_TestCall2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_echo_TestSleep_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestSleep_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestSleep_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_TestSleep *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestSleep_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestSleep_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTSLEEP, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestSleep_r_done, req);

	return req;
}

static void dcerpc_echo_TestSleep_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestSleep_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestSleep_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_TestSleep_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestSleep_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_TestSleep *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTSLEEP, mem_ctx, r);

	return status;
}

struct dcerpc_echo_TestSleep_state {
	struct echo_TestSleep orig;
	struct echo_TestSleep tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestSleep_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestSleep_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      uint32_t _seconds /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestSleep_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestSleep_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.seconds = _seconds;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_TestSleep_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestSleep_done, req);
	return req;
}

static void dcerpc_echo_TestSleep_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_TestSleep_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestSleep_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_TestSleep_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestSleep_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    uint32_t *result)
{
	struct dcerpc_echo_TestSleep_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestSleep_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestSleep(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       uint32_t _seconds /* [in]  */,
			       uint32_t *result)
{
	struct echo_TestSleep r;
	NTSTATUS status;

	/* In parameters */
	r.in.seconds = _seconds;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_echo_TestSleep_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_echo_TestEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_TestEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestEnum_r_done, req);

	return req;
}

static void dcerpc_echo_TestEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_TestEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_TestEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTENUM, mem_ctx, r);

	return status;
}

struct dcerpc_echo_TestEnum_state {
	struct echo_TestEnum orig;
	struct echo_TestEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestEnum_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     enum echo_Enum1 *_foo1 /* [in,out] [ref] */,
					     struct echo_Enum2 *_foo2 /* [in,out] [ref] */,
					     union echo_Enum3 *_foo3 /* [in,out] [ref,switch_is(*foo1)] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.foo1 = _foo1;
	state->orig.in.foo2 = _foo2;
	state->orig.in.foo3 = _foo3;

	/* Out parameters */
	state->orig.out.foo1 = _foo1;
	state->orig.out.foo2 = _foo2;
	state->orig.out.foo3 = _foo3;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_echo_TestEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_TestEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestEnum_done, req);
	return req;
}

static void dcerpc_echo_TestEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_TestEnum_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_TestEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.foo1 = *state->tmp.out.foo1;
	*state->orig.out.foo2 = *state->tmp.out.foo2;
	*state->orig.out.foo3 = *state->tmp.out.foo3;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestEnum_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestEnum_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestEnum(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      enum echo_Enum1 *_foo1 /* [in,out] [ref] */,
			      struct echo_Enum2 *_foo2 /* [in,out] [ref] */,
			      union echo_Enum3 *_foo3 /* [in,out] [ref,switch_is(*foo1)] */)
{
	struct echo_TestEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.foo1 = _foo1;
	r.in.foo2 = _foo2;
	r.in.foo3 = _foo3;

	/* Out parameters */
	r.out.foo1 = _foo1;
	r.out.foo2 = _foo2;
	r.out.foo3 = _foo3;

	status = dcerpc_echo_TestEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_foo1 = *r.out.foo1;
	*_foo2 = *r.out.foo2;
	*_foo3 = *r.out.foo3;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_echo_TestSurrounding_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestSurrounding_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestSurrounding_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_TestSurrounding *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestSurrounding_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestSurrounding_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTSURROUNDING, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestSurrounding_r_done, req);

	return req;
}

static void dcerpc_echo_TestSurrounding_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestSurrounding_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestSurrounding_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_TestSurrounding_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestSurrounding_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_TestSurrounding *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTSURROUNDING, mem_ctx, r);

	return status;
}

struct dcerpc_echo_TestSurrounding_state {
	struct echo_TestSurrounding orig;
	struct echo_TestSurrounding tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestSurrounding_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestSurrounding_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct echo_Surrounding *_data /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestSurrounding_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestSurrounding_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.data = _data;

	/* Out parameters */
	state->orig.out.data = _data;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_echo_TestSurrounding_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_TestSurrounding_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestSurrounding_done, req);
	return req;
}

static void dcerpc_echo_TestSurrounding_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_TestSurrounding_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestSurrounding_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_TestSurrounding_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.data = *state->tmp.out.data;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestSurrounding_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestSurrounding_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestSurrounding_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestSurrounding(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct echo_Surrounding *_data /* [in,out] [ref] */)
{
	struct echo_TestSurrounding r;
	NTSTATUS status;

	/* In parameters */
	r.in.data = _data;

	/* Out parameters */
	r.out.data = _data;

	status = dcerpc_echo_TestSurrounding_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_data = *r.out.data;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_echo_TestDoublePointer_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestDoublePointer_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestDoublePointer_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct echo_TestDoublePointer *r)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestDoublePointer_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestDoublePointer_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTDOUBLEPOINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestDoublePointer_r_done, req);

	return req;
}

static void dcerpc_echo_TestDoublePointer_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestDoublePointer_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_echo_TestDoublePointer_r_state *state =
		tevent_req_data(req,
		struct dcerpc_echo_TestDoublePointer_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestDoublePointer_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct echo_TestDoublePointer *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rpcecho,
			NDR_ECHO_TESTDOUBLEPOINTER, mem_ctx, r);

	return status;
}

struct dcerpc_echo_TestDoublePointer_state {
	struct echo_TestDoublePointer orig;
	struct echo_TestDoublePointer tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_echo_TestDoublePointer_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_echo_TestDoublePointer_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      uint16_t ***_data /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_echo_TestDoublePointer_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_echo_TestDoublePointer_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.data = _data;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_echo_TestDoublePointer_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_echo_TestDoublePointer_done, req);
	return req;
}

static void dcerpc_echo_TestDoublePointer_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_echo_TestDoublePointer_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestDoublePointer_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_echo_TestDoublePointer_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_echo_TestDoublePointer_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    uint16_t *result)
{
	struct dcerpc_echo_TestDoublePointer_state *state = tevent_req_data(
		req, struct dcerpc_echo_TestDoublePointer_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_echo_TestDoublePointer(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       uint16_t ***_data /* [in] [ref] */,
				       uint16_t *result)
{
	struct echo_TestDoublePointer r;
	NTSTATUS status;

	/* In parameters */
	r.in.data = _data;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_echo_TestDoublePointer_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

