#ifndef __SOURCE4_DSDB_SAMDB_SAMDB_PROTO_H__
#define __SOURCE4_DSDB_SAMDB_SAMDB_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/dsdb/samdb/samdb.c  */

int samdb_connect_url(TALLOC_CTX *mem_ctx,
		      struct tevent_context *ev_ctx,
		      struct loadparm_context *lp_ctx,
		      struct auth_session_info *session_info,
		      unsigned int flags,
		      const char *url,
		      const struct tsocket_address *remote_address,
		      struct ldb_context **ldb_ret,
		      char **errstring);
struct ldb_context *samdb_connect(TALLOC_CTX *mem_ctx,
				  struct tevent_context *ev_ctx,
				  struct loadparm_context *lp_ctx,
				  struct auth_session_info *session_info,
				  const struct tsocket_address *remote_address,
				  unsigned int flags);

/****************************************************************************
 Create the SID list for this user.
****************************************************************************/
NTSTATUS security_token_create(TALLOC_CTX *mem_ctx, 
			       struct loadparm_context *lp_ctx,
			       uint32_t num_sids,
			       const struct auth_SidAttr *sids,
			       uint32_t num_device_sids,
			       const struct auth_SidAttr *device_sids,
			       struct auth_claims auth_claims,
			       uint32_t session_info_flags,
			       struct security_token **token);

/* The following definitions come from ../../source4/dsdb/samdb/samdb_privilege.c  */

struct ldb_context *privilege_connect(TALLOC_CTX *mem_ctx, 
				      struct loadparm_context *lp_ctx);
NTSTATUS samdb_privilege_setup(struct loadparm_context *lp_ctx, struct security_token *token);

/* The following definitions come from ../../source4/dsdb/samdb/cracknames.c  */

WERROR DsCrackNameOneName(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx,
			  uint32_t format_flags, enum drsuapi_DsNameFormat format_offered,
			  enum drsuapi_DsNameFormat format_desired,
			  const char *name, struct drsuapi_DsNameInfo1 *info1);
NTSTATUS crack_user_principal_name(struct ldb_context *sam_ctx,
				   TALLOC_CTX *mem_ctx,
				   const char *user_principal_name,
				   struct ldb_dn **user_dn,
				   struct ldb_dn **domain_dn);
NTSTATUS crack_service_principal_name(struct ldb_context *sam_ctx,
				      TALLOC_CTX *mem_ctx,
				      const char *service_principal_name,
				      struct ldb_dn **user_dn,
				      struct ldb_dn **domain_dn);
NTSTATUS crack_name_to_nt4_name(TALLOC_CTX *mem_ctx,
				struct ldb_context *ldb,
				enum drsuapi_DsNameFormat format_offered,
				const char *name,
				const char **nt4_domain, const char **nt4_account);
NTSTATUS crack_auto_name_to_nt4_name(TALLOC_CTX *mem_ctx,
				     struct ldb_context *ldb,
				     const char *name,
				     const char **nt4_domain,
				     const char **nt4_account);
WERROR dcesrv_drsuapi_ListRoles(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx,
				const struct drsuapi_DsNameRequest1 *req1,
				struct drsuapi_DsNameCtr1 **ctr1);
WERROR dcesrv_drsuapi_CrackNamesByNameFormat(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx,
					     const struct drsuapi_DsNameRequest1 *req1,
					     struct drsuapi_DsNameCtr1 **ctr1);
WERROR dcesrv_drsuapi_ListInfoServer(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx,
				     const struct drsuapi_DsNameRequest1 *req1,
				     struct drsuapi_DsNameCtr1 **_ctr1);

/* The following definitions come from ../../source4/dsdb/repl/replicated_objects.c  */

WERROR dsdb_repl_resolve_working_schema(struct ldb_context *ldb,
					struct dsdb_schema_prefixmap *pfm_remote,
					uint32_t cycle_before_switching,
					struct dsdb_schema *initial_schema,
					struct dsdb_schema *resulting_schema,
					uint32_t object_count,
					const struct drsuapi_DsReplicaObjectListItemEx *first_object);

/**
 * Multi-pass working schema creation
 * Function will:
 *  - shallow copy initial schema supplied
 *  - create a working schema in multiple passes
 *    until all objects are resolved
 * Working schema is a schema with Attributes, Classes
 * and indexes, but w/o subClassOf, possibleSupperiors etc.
 * It is to be used just us cache for converting attribute values.
 */
WERROR dsdb_repl_make_working_schema(struct ldb_context *ldb,
				     const struct dsdb_schema *initial_schema,
				     const struct drsuapi_DsReplicaOIDMapping_Ctr *mapping_ctr,
				     uint32_t object_count,
				     const struct drsuapi_DsReplicaObjectListItemEx *first_object,
				     const DATA_BLOB *gensec_skey,
				     TALLOC_CTX *mem_ctx,
				     struct dsdb_schema **_schema_out);
WERROR dsdb_convert_object_ex(struct ldb_context *ldb,
			      const struct dsdb_schema *schema,
			      struct ldb_dn *partition_dn,
			      const struct dsdb_schema_prefixmap *pfm_remote,
			      const struct drsuapi_DsReplicaObjectListItemEx *in,
			      const DATA_BLOB *gensec_skey,
			      const uint32_t *ignore_attids,
			      uint32_t dsdb_repl_flags,
			      TALLOC_CTX *mem_ctx,
			      struct dsdb_extended_replicated_object *out);
WERROR dsdb_replicated_objects_convert(struct ldb_context *ldb,
				       const struct dsdb_schema *schema,
				       struct ldb_dn *partition_dn,
				       const struct drsuapi_DsReplicaOIDMapping_Ctr *mapping_ctr,
				       uint32_t object_count,
				       const struct drsuapi_DsReplicaObjectListItemEx *first_object,
				       uint32_t linked_attributes_count,
				       const struct drsuapi_DsReplicaLinkedAttribute *linked_attributes,
				       const struct repsFromTo1 *source_dsa,
				       const struct drsuapi_DsReplicaCursor2CtrEx *uptodateness_vector,
				       const DATA_BLOB *gensec_skey,
				       uint32_t dsdb_repl_flags,
				       TALLOC_CTX *mem_ctx,
				       struct dsdb_extended_replicated_objects **objects);

/**
 * Commits a list of replicated objects.
 *
 * @param working_schema dsdb_schema to be used for resolving
 * 			 Classes/Attributes during Schema replication. If not NULL,
 * 			 it will be set on ldb and used while committing replicated objects
 */
WERROR dsdb_replicated_objects_commit(struct ldb_context *ldb,
				      struct dsdb_schema *working_schema,
				      struct dsdb_extended_replicated_objects *objects,
				      uint64_t *notify_uSN);
WERROR dsdb_origin_objects_commit(struct ldb_context *ldb,
				  TALLOC_CTX *mem_ctx,
				  const struct drsuapi_DsReplicaObjectListItem *first_object,
				  uint32_t *_num,
				  uint32_t dsdb_repl_flags,
				  struct drsuapi_DsReplicaObjectIdentifier2 **_ids);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_DSDB_SAMDB_SAMDB_PROTO_H__ */

