/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/source3/librpc/gen_ndr/ndr_smbXsrv.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_server_id.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_auth.h"
static enum ndr_err_code ndr_push_smbXsrv_version_values(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum smbXsrv_version_values r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_values(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum smbXsrv_version_values *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_values(struct ndr_print *ndr, const char *name, enum smbXsrv_version_values r)
{
	const char *val = NULL;

	switch (r) {
		case SMBXSRV_VERSION_0: val = "SMBXSRV_VERSION_0"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_smbXsrv_version_node0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_version_node0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->min_version));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->max_version));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->current_version));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_node0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_version_node0 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->min_version));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->max_version));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->current_version));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_node0(struct ndr_print *ndr, const char *name, const struct smbXsrv_version_node0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_version_node0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_smbXsrv_version_values(ndr, "min_version", r->min_version);
	ndr_print_smbXsrv_version_values(ndr, "max_version", r->max_version);
	ndr_print_smbXsrv_version_values(ndr, "current_version", r->current_version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_version_global0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_version_global0 *r)
{
	uint32_t cntr_nodes_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_nodes));
		for (cntr_nodes_0 = 0; cntr_nodes_0 < (r->num_nodes); cntr_nodes_0++) {
			NDR_CHECK(ndr_push_smbXsrv_version_node0(ndr, NDR_SCALARS, &r->nodes[cntr_nodes_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_global0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_version_global0 *r)
{
	uint32_t size_nodes_0 = 0;
	uint32_t cntr_nodes_0;
	TALLOC_CTX *_mem_save_nodes_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_nodes));
		if (r->num_nodes < 1 || r->num_nodes > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_nodes), (uint32_t)(1), (uint32_t)(1024));
		}
		size_nodes_0 = r->num_nodes;
		NDR_PULL_ALLOC_N(ndr, r->nodes, size_nodes_0);
		_mem_save_nodes_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->nodes, 0);
		for (cntr_nodes_0 = 0; cntr_nodes_0 < (size_nodes_0); cntr_nodes_0++) {
			NDR_CHECK(ndr_pull_smbXsrv_version_node0(ndr, NDR_SCALARS, &r->nodes[cntr_nodes_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nodes_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_version_global0 *r)
{
	uint32_t cntr_nodes_0;
	ndr_print_struct(ndr, name, "smbXsrv_version_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_nodes", r->num_nodes);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "nodes", (uint32_t)(r->num_nodes));
	ndr->depth++;
	for (cntr_nodes_0 = 0; cntr_nodes_0 < (r->num_nodes); cntr_nodes_0++) {
		ndr_print_smbXsrv_version_node0(ndr, "nodes", &r->nodes[cntr_nodes_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_version_globalU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_version_globalU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_version_global0(ndr, NDR_SCALARS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_globalU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_version_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_version_global0(ndr, NDR_SCALARS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_version_globalU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_version_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_version_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_version_globalB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_version_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_version_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_version_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_version_globalB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_version_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_version_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_version_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_version_globalB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_version_globalB *r)
{
	ndr_print_smbXsrv_version_globalB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_version_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_version_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_version_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_version_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_client_global0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_client_global0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->local_address, ndr_charset_length(r->local_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_address, ndr_charset_length(r->remote_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_name, ndr_charset_length(r->remote_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->initial_connect_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->stored));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_client_global0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_client_global0 *r)
{
	uint32_t _ptr_db_rec;
	uint32_t size_local_address_0 = 0;
	uint32_t length_local_address_0 = 0;
	uint32_t size_remote_address_0 = 0;
	uint32_t length_remote_address_0 = 0;
	uint32_t size_remote_name_0 = 0;
	uint32_t length_remote_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->local_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->local_address));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->local_address, &size_local_address_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->local_address, &length_local_address_0));
		if (length_local_address_0 > size_local_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_local_address_0, length_local_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_local_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->local_address, length_local_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_address));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->remote_address, &size_remote_address_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->remote_address, &length_remote_address_0));
		if (length_remote_address_0 > size_remote_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_remote_address_0, length_remote_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_address, length_remote_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->remote_name, &size_remote_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->remote_name, &length_remote_name_0));
		if (length_remote_name_0 > size_remote_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_remote_name_0, length_remote_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_name, length_remote_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->initial_connect_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->stored));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_client_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_client_global0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_client_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_string(ndr, "local_address", r->local_address);
	ndr_print_string(ndr, "remote_address", r->remote_address);
	ndr_print_string(ndr, "remote_name", r->remote_name);
	ndr_print_NTTIME(ndr, "initial_connect_time", r->initial_connect_time);
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_uint8(ndr, "stored", r->stored);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_client_globalU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_client_globalU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_client_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_client_globalU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_client_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_client_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_client_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_client_globalU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_client_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_client_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_client_globalB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_client_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_client_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_client_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_client_globalB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_client_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_client_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_client_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_client_globalB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_client_globalB *r)
{
	ndr_print_smbXsrv_client_globalB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_client_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_client_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_client_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_client_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_client(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_client *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->global == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'raw_ev_ctx' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'msg_ctx' */
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->global */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'sconn' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'session_table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'tcon_table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'open_table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'connections' */
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->server_multi_channel_enabled));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->next_channel_id));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'connection_pass_subreq' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'connection_drop_subreq' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'pending_breaks' */
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'raw_ev_ctx' */
		/* [ignore] 'msg_ctx' */
		NDR_CHECK(ndr_push_smbXsrv_client_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		/* [ignore] 'sconn' */
		/* [ignore] 'session_table' */
		/* [ignore] 'tcon_table' */
		/* [ignore] 'open_table' */
		/* [ignore] 'connections' */
		/* [ignore] 'connection_pass_subreq' */
		/* [ignore] 'connection_drop_subreq' */
		/* [ignore] 'pending_breaks' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_client(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_client *r)
{
	uint32_t _ptr_table;
	uint32_t _ptr_raw_ev_ctx;
	uint32_t _ptr_msg_ctx;
	uint32_t _ptr_global;
	TALLOC_CTX *_mem_save_global_0 = NULL;
	uint32_t _ptr_sconn;
	uint32_t _ptr_session_table;
	uint32_t _ptr_tcon_table;
	uint32_t _ptr_open_table;
	uint32_t _ptr_connections;
	uint32_t _ptr_connection_pass_subreq;
	uint32_t _ptr_connection_drop_subreq;
	uint32_t _ptr_pending_breaks;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_table));
		_ptr_table = 0;
		if (_ptr_table) {
		} else {
			r->table = NULL;
		}
		/* [ignore] 'table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_raw_ev_ctx));
		_ptr_raw_ev_ctx = 0;
		if (_ptr_raw_ev_ctx) {
		} else {
			r->raw_ev_ctx = NULL;
		}
		/* [ignore] 'raw_ev_ctx' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_msg_ctx));
		_ptr_msg_ctx = 0;
		if (_ptr_msg_ctx) {
		} else {
			r->msg_ctx = NULL;
		}
		/* [ignore] 'msg_ctx' */
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_global));
		if (_ptr_global) {
			NDR_PULL_ALLOC(ndr, r->global);
		} else {
			r->global = NULL;
		}
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_sconn));
		_ptr_sconn = 0;
		if (_ptr_sconn) {
		} else {
			r->sconn = NULL;
		}
		/* [ignore] 'sconn' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_session_table));
		_ptr_session_table = 0;
		if (_ptr_session_table) {
		} else {
			r->session_table = NULL;
		}
		/* [ignore] 'session_table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_tcon_table));
		_ptr_tcon_table = 0;
		if (_ptr_tcon_table) {
		} else {
			r->tcon_table = NULL;
		}
		/* [ignore] 'tcon_table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_open_table));
		_ptr_open_table = 0;
		if (_ptr_open_table) {
		} else {
			r->open_table = NULL;
		}
		/* [ignore] 'open_table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_connections));
		_ptr_connections = 0;
		if (_ptr_connections) {
		} else {
			r->connections = NULL;
		}
		/* [ignore] 'connections' */
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->server_multi_channel_enabled));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->next_channel_id));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_connection_pass_subreq));
		_ptr_connection_pass_subreq = 0;
		if (_ptr_connection_pass_subreq) {
		} else {
			r->connection_pass_subreq = NULL;
		}
		/* [ignore] 'connection_pass_subreq' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_connection_drop_subreq));
		_ptr_connection_drop_subreq = 0;
		if (_ptr_connection_drop_subreq) {
		} else {
			r->connection_drop_subreq = NULL;
		}
		/* [ignore] 'connection_drop_subreq' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_pending_breaks));
		_ptr_pending_breaks = 0;
		if (_ptr_pending_breaks) {
		} else {
			r->pending_breaks = NULL;
		}
		/* [ignore] 'pending_breaks' */
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'raw_ev_ctx' */
		/* [ignore] 'msg_ctx' */
		_mem_save_global_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->global, 0);
		NDR_CHECK(ndr_pull_smbXsrv_client_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_global_0, 0);
		/* [ignore] 'sconn' */
		/* [ignore] 'session_table' */
		/* [ignore] 'tcon_table' */
		/* [ignore] 'open_table' */
		/* [ignore] 'connections' */
		/* [ignore] 'connection_pass_subreq' */
		/* [ignore] 'connection_drop_subreq' */
		/* [ignore] 'pending_breaks' */
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_client(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_client *r)
{
	ndr_print_smbXsrv_client(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_client(struct ndr_print *ndr, const char *name, const struct smbXsrv_client *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_client");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "table", r->table);
	/* [ignore] 'table' */
	ndr_print_ptr(ndr, "raw_ev_ctx", r->raw_ev_ctx);
	/* [ignore] 'raw_ev_ctx' */
	ndr_print_ptr(ndr, "msg_ctx", r->msg_ctx);
	/* [ignore] 'msg_ctx' */
	ndr_print_ptr(ndr, "global", r->global);
	ndr->depth++;
	ndr_print_smbXsrv_client_global0(ndr, "global", r->global);
	ndr->depth--;
	ndr_print_ptr(ndr, "sconn", r->sconn);
	/* [ignore] 'sconn' */
	ndr_print_ptr(ndr, "session_table", r->session_table);
	/* [ignore] 'session_table' */
	ndr_print_ptr(ndr, "tcon_table", r->tcon_table);
	/* [ignore] 'tcon_table' */
	ndr_print_ptr(ndr, "open_table", r->open_table);
	/* [ignore] 'open_table' */
	ndr_print_ptr(ndr, "connections", r->connections);
	/* [ignore] 'connections' */
	ndr_print_uint8(ndr, "server_multi_channel_enabled", r->server_multi_channel_enabled);
	ndr_print_hyper(ndr, "next_channel_id", r->next_channel_id);
	ndr_print_ptr(ndr, "connection_pass_subreq", r->connection_pass_subreq);
	/* [ignore] 'connection_pass_subreq' */
	ndr_print_ptr(ndr, "connection_drop_subreq", r->connection_drop_subreq);
	/* [ignore] 'connection_drop_subreq' */
	ndr_print_ptr(ndr, "pending_breaks", r->pending_breaks);
	/* [ignore] 'pending_breaks' */
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_clientU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_clientU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_client(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_clientU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_clientU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_client(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_clientU(struct ndr_print *ndr, const char *name, const union smbXsrv_clientU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_clientU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_client(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_clientB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_clientB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_clientU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_clientU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_clientB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_clientB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_clientU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_clientU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_clientB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_clientB *r)
{
	ndr_print_smbXsrv_clientB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_clientB(struct ndr_print *ndr, const char *name, const struct smbXsrv_clientB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_clientB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_clientU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_connection_pass0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_connection_pass0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->src_server_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->xconn_connect_time));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->dst_server_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->client_connect_time));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->transport_type));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->negotiate_request));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_connection_pass0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_connection_pass0 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->src_server_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->xconn_connect_time));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->dst_server_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->client_connect_time));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->transport_type));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->negotiate_request));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_connection_pass0(struct ndr_print *ndr, const char *name, const struct smbXsrv_connection_pass0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_connection_pass0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_server_id(ndr, "src_server_id", &r->src_server_id);
	ndr_print_NTTIME(ndr, "xconn_connect_time", r->xconn_connect_time);
	ndr_print_server_id(ndr, "dst_server_id", &r->dst_server_id);
	ndr_print_NTTIME(ndr, "client_connect_time", r->client_connect_time);
	ndr_print_uint8(ndr, "transport_type", r->transport_type);
	ndr_print_DATA_BLOB(ndr, "negotiate_request", r->negotiate_request);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_connection_passU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_connection_passU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_connection_pass0(ndr, NDR_SCALARS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_connection_passU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_connection_passU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_connection_pass0(ndr, NDR_SCALARS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_connection_passU(struct ndr_print *ndr, const char *name, const union smbXsrv_connection_passU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_connection_passU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_connection_pass0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_connection_passB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_connection_passB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_connection_passU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_connection_passU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_connection_passB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_connection_passB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_connection_passU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_connection_passU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_connection_passB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_connection_passB *r)
{
	ndr_print_smbXsrv_connection_passB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_connection_passB(struct ndr_print *ndr, const char *name, const struct smbXsrv_connection_passB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_connection_passB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_connection_passU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_connection_drop0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_connection_drop0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->src_server_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->xconn_connect_time));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->dst_server_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->client_connect_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_connection_drop0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_connection_drop0 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->src_server_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->xconn_connect_time));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->dst_server_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->client_connect_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_connection_drop0(struct ndr_print *ndr, const char *name, const struct smbXsrv_connection_drop0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_connection_drop0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_server_id(ndr, "src_server_id", &r->src_server_id);
	ndr_print_NTTIME(ndr, "xconn_connect_time", r->xconn_connect_time);
	ndr_print_server_id(ndr, "dst_server_id", &r->dst_server_id);
	ndr_print_NTTIME(ndr, "client_connect_time", r->client_connect_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_connection_dropU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_connection_dropU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_connection_drop0(ndr, NDR_SCALARS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_connection_dropU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_connection_dropU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_connection_drop0(ndr, NDR_SCALARS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_connection_dropU(struct ndr_print *ndr, const char *name, const union smbXsrv_connection_dropU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_connection_dropU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_connection_drop0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_connection_dropB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_connection_dropB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_connection_dropU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_connection_dropU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_connection_dropB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_connection_dropB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_connection_dropU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_connection_dropU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_connection_dropB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_connection_dropB *r)
{
	ndr_print_smbXsrv_connection_dropB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_connection_dropB(struct ndr_print *ndr, const char *name, const struct smbXsrv_connection_dropB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_connection_dropB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_connection_dropU(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_encrpytion_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_encrpytion_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_encrpytion_flags(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_ENCRYPTION_REQUIRED", SMBXSRV_ENCRYPTION_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_ENCRYPTION_DESIRED", SMBXSRV_ENCRYPTION_DESIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_PROCESSED_ENCRYPTED_PACKET", SMBXSRV_PROCESSED_ENCRYPTED_PACKET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_PROCESSED_UNENCRYPTED_PACKET", SMBXSRV_PROCESSED_UNENCRYPTED_PACKET, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_signing_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_signing_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_signing_flags(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_SIGNING_REQUIRED", SMBXSRV_SIGNING_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_PROCESSED_SIGNED_PACKET", SMBXSRV_PROCESSED_SIGNED_PACKET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_PROCESSED_UNSIGNED_PACKET", SMBXSRV_PROCESSED_UNSIGNED_PACKET, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_channel_global0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_channel_global0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->channel_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->creation_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->local_address, ndr_charset_length(r->local_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_address, ndr_charset_length(r->remote_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_name, ndr_charset_length(r->remote_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->signing_key_blob));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'signing_key' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_session_info_seqnum));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'connection' */
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->signing_algo));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->encryption_cipher));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->transport_type));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'signing_key' */
		/* [ignore] 'connection' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_channel_global0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_channel_global0 *r)
{
	uint32_t size_local_address_0 = 0;
	uint32_t length_local_address_0 = 0;
	uint32_t size_remote_address_0 = 0;
	uint32_t length_remote_address_0 = 0;
	uint32_t size_remote_name_0 = 0;
	uint32_t length_remote_name_0 = 0;
	uint32_t _ptr_signing_key;
	uint32_t _ptr_connection;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->channel_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->creation_time));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->local_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->local_address));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->local_address, &size_local_address_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->local_address, &length_local_address_0));
		if (length_local_address_0 > size_local_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_local_address_0, length_local_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_local_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->local_address, length_local_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_address));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->remote_address, &size_remote_address_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->remote_address, &length_remote_address_0));
		if (length_remote_address_0 > size_remote_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_remote_address_0, length_remote_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_address, length_remote_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->remote_name, &size_remote_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->remote_name, &length_remote_name_0));
		if (length_remote_name_0 > size_remote_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_remote_name_0, length_remote_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_name, length_remote_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->signing_key_blob));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_signing_key));
		_ptr_signing_key = 0;
		if (_ptr_signing_key) {
		} else {
			r->signing_key = NULL;
		}
		/* [ignore] 'signing_key' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_session_info_seqnum));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_connection));
		_ptr_connection = 0;
		if (_ptr_connection) {
		} else {
			r->connection = NULL;
		}
		/* [ignore] 'connection' */
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->signing_algo));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->encryption_cipher));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->transport_type));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'signing_key' */
		/* [ignore] 'connection' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_channel_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_channel_global0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_channel_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_hyper(ndr, "channel_id", r->channel_id);
	ndr_print_NTTIME(ndr, "creation_time", r->creation_time);
	ndr_print_string(ndr, "local_address", r->local_address);
	ndr_print_string(ndr, "remote_address", r->remote_address);
	ndr_print_string(ndr, "remote_name", r->remote_name);
	ndr_print_ptr(ndr, "signing_key", r->signing_key);
	/* [ignore] 'signing_key' */
	ndr_print_uint32(ndr, "auth_session_info_seqnum", r->auth_session_info_seqnum);
	ndr_print_ptr(ndr, "connection", r->connection);
	/* [ignore] 'connection' */
	ndr_print_uint16(ndr, "signing_algo", r->signing_algo);
	ndr_print_uint16(ndr, "encryption_cipher", r->encryption_cipher);
	ndr_print_uint8(ndr, "transport_type", r->transport_type);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_global0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_session_global0 *r)
{
	uint32_t cntr_channels_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_global_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->session_wire_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->creation_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->expiration_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->auth_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_session_info_seqnum));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->auth_session_info));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->connection_dialect));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_smbXsrv_signing_flags(ndr, NDR_SCALARS, r->signing_flags));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->signing_algo));
		NDR_CHECK(ndr_push_smbXsrv_encrpytion_flags(ndr, NDR_SCALARS, r->encryption_flags));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->encryption_cipher));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->signing_key_blob));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'signing_key' */
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->encryption_key_blob));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'encryption_key' */
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->decryption_key_blob));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'decryption_key' */
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->application_key_blob));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'application_key' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_channels));
		for (cntr_channels_0 = 0; cntr_channels_0 < (r->num_channels); cntr_channels_0++) {
			NDR_CHECK(ndr_push_smbXsrv_channel_global0(ndr, NDR_SCALARS, &r->channels[cntr_channels_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
		if (r->auth_session_info) {
			NDR_CHECK(ndr_push_auth_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->auth_session_info));
		}
		/* [ignore] 'signing_key' */
		/* [ignore] 'encryption_key' */
		/* [ignore] 'decryption_key' */
		/* [ignore] 'application_key' */
		for (cntr_channels_0 = 0; cntr_channels_0 < (r->num_channels); cntr_channels_0++) {
			NDR_CHECK(ndr_push_smbXsrv_channel_global0(ndr, NDR_BUFFERS, &r->channels[cntr_channels_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_global0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_session_global0 *r)
{
	uint32_t _ptr_db_rec;
	uint32_t _ptr_auth_session_info;
	TALLOC_CTX *_mem_save_auth_session_info_0 = NULL;
	uint32_t _ptr_signing_key;
	uint32_t _ptr_encryption_key;
	uint32_t _ptr_decryption_key;
	uint32_t _ptr_application_key;
	uint32_t size_channels_0 = 0;
	uint32_t cntr_channels_0;
	TALLOC_CTX *_mem_save_channels_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_global_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->session_wire_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->creation_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->expiration_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->auth_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_session_info_seqnum));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_auth_session_info));
		if (_ptr_auth_session_info) {
			NDR_PULL_ALLOC(ndr, r->auth_session_info);
		} else {
			r->auth_session_info = NULL;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->connection_dialect));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_smbXsrv_signing_flags(ndr, NDR_SCALARS, &r->signing_flags));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->signing_algo));
		NDR_CHECK(ndr_pull_smbXsrv_encrpytion_flags(ndr, NDR_SCALARS, &r->encryption_flags));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->encryption_cipher));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->signing_key_blob));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_signing_key));
		_ptr_signing_key = 0;
		if (_ptr_signing_key) {
		} else {
			r->signing_key = NULL;
		}
		/* [ignore] 'signing_key' */
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->encryption_key_blob));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_encryption_key));
		_ptr_encryption_key = 0;
		if (_ptr_encryption_key) {
		} else {
			r->encryption_key = NULL;
		}
		/* [ignore] 'encryption_key' */
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->decryption_key_blob));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_decryption_key));
		_ptr_decryption_key = 0;
		if (_ptr_decryption_key) {
		} else {
			r->decryption_key = NULL;
		}
		/* [ignore] 'decryption_key' */
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->application_key_blob));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_application_key));
		_ptr_application_key = 0;
		if (_ptr_application_key) {
		} else {
			r->application_key = NULL;
		}
		/* [ignore] 'application_key' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_channels));
		if (r->num_channels < 1 || r->num_channels > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_channels), (uint32_t)(1), (uint32_t)(1024));
		}
		size_channels_0 = r->num_channels;
		NDR_PULL_ALLOC_N(ndr, r->channels, size_channels_0);
		_mem_save_channels_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->channels, 0);
		for (cntr_channels_0 = 0; cntr_channels_0 < (size_channels_0); cntr_channels_0++) {
			NDR_CHECK(ndr_pull_smbXsrv_channel_global0(ndr, NDR_SCALARS, &r->channels[cntr_channels_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channels_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
		if (r->auth_session_info) {
			_mem_save_auth_session_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->auth_session_info, 0);
			NDR_CHECK(ndr_pull_auth_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->auth_session_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_auth_session_info_0, 0);
		}
		/* [ignore] 'signing_key' */
		/* [ignore] 'encryption_key' */
		/* [ignore] 'decryption_key' */
		/* [ignore] 'application_key' */
		size_channels_0 = r->num_channels;
		_mem_save_channels_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->channels, 0);
		for (cntr_channels_0 = 0; cntr_channels_0 < (size_channels_0); cntr_channels_0++) {
			NDR_CHECK(ndr_pull_smbXsrv_channel_global0(ndr, NDR_BUFFERS, &r->channels[cntr_channels_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channels_0, 0);
		for (cntr_channels_0 = 0; cntr_channels_0 < (size_channels_0); cntr_channels_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_global0 *r)
{
	uint32_t cntr_channels_0;
	ndr_print_struct(ndr, name, "smbXsrv_session_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "session_global_id", r->session_global_id);
	ndr_print_hyper(ndr, "session_wire_id", r->session_wire_id);
	ndr_print_NTTIME(ndr, "creation_time", r->creation_time);
	ndr_print_NTTIME(ndr, "expiration_time", r->expiration_time);
	ndr_print_NTTIME(ndr, "auth_time", r->auth_time);
	ndr_print_uint32(ndr, "auth_session_info_seqnum", r->auth_session_info_seqnum);
	ndr_print_ptr(ndr, "auth_session_info", r->auth_session_info);
	ndr->depth++;
	if (r->auth_session_info) {
		ndr_print_auth_session_info(ndr, "auth_session_info", r->auth_session_info);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "connection_dialect", r->connection_dialect);
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_smbXsrv_signing_flags(ndr, "signing_flags", r->signing_flags);
	ndr_print_uint16(ndr, "signing_algo", r->signing_algo);
	ndr_print_smbXsrv_encrpytion_flags(ndr, "encryption_flags", r->encryption_flags);
	ndr_print_uint16(ndr, "encryption_cipher", r->encryption_cipher);
	ndr_print_ptr(ndr, "signing_key", r->signing_key);
	/* [ignore] 'signing_key' */
	ndr_print_ptr(ndr, "encryption_key", r->encryption_key);
	/* [ignore] 'encryption_key' */
	ndr_print_ptr(ndr, "decryption_key", r->decryption_key);
	/* [ignore] 'decryption_key' */
	ndr_print_ptr(ndr, "application_key", r->application_key);
	/* [ignore] 'application_key' */
	ndr_print_uint32(ndr, "num_channels", r->num_channels);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "channels", (uint32_t)(r->num_channels));
	ndr->depth++;
	for (cntr_channels_0 = 0; cntr_channels_0 < (r->num_channels); cntr_channels_0++) {
		ndr_print_smbXsrv_channel_global0(ndr, "channels", &r->channels[cntr_channels_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_globalU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_session_globalU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_globalU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_session_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_session_globalU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_session_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_session_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_session_globalB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_session_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_session_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_session_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_session_globalB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_session_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_session_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_session_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_session_globalB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_session_globalB *r)
{
	ndr_print_smbXsrv_session_globalB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_session_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_session_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_auth0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_session_auth0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'prev' */
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'session' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'connection' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'gensec' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'preauth' */
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in_flags));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in_security_mode));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->creation_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->channel_id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'prev' */
		if (r->next) {
			NDR_CHECK(ndr_push_smbXsrv_session_auth0(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
		}
		/* [ignore] 'session' */
		/* [ignore] 'connection' */
		/* [ignore] 'gensec' */
		/* [ignore] 'preauth' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_auth0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_session_auth0 *r)
{
	uint32_t _ptr_prev;
	uint32_t _ptr_next;
	TALLOC_CTX *_mem_save_next_0 = NULL;
	uint32_t _ptr_session;
	uint32_t _ptr_connection;
	uint32_t _ptr_gensec;
	uint32_t _ptr_preauth;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_prev));
		_ptr_prev = 0;
		if (_ptr_prev) {
		} else {
			r->prev = NULL;
		}
		/* [ignore] 'prev' */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next));
		if (_ptr_next) {
			NDR_PULL_ALLOC(ndr, r->next);
		} else {
			r->next = NULL;
		}
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_session));
		_ptr_session = 0;
		if (_ptr_session) {
		} else {
			r->session = NULL;
		}
		/* [ignore] 'session' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_connection));
		_ptr_connection = 0;
		if (_ptr_connection) {
		} else {
			r->connection = NULL;
		}
		/* [ignore] 'connection' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_gensec));
		_ptr_gensec = 0;
		if (_ptr_gensec) {
		} else {
			r->gensec = NULL;
		}
		/* [ignore] 'gensec' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_preauth));
		_ptr_preauth = 0;
		if (_ptr_preauth) {
		} else {
			r->preauth = NULL;
		}
		/* [ignore] 'preauth' */
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in_flags));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in_security_mode));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->creation_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->channel_id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'prev' */
		if (r->next) {
			_mem_save_next_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next, 0);
			NDR_RECURSION_CHECK(ndr, 20000);
			NDR_CHECK(ndr_pull_smbXsrv_session_auth0(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
			NDR_RECURSION_UNWIND(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_0, 0);
		}
		/* [ignore] 'session' */
		/* [ignore] 'connection' */
		/* [ignore] 'gensec' */
		/* [ignore] 'preauth' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_auth0(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_auth0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_auth0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "prev", r->prev);
	/* [ignore] 'prev' */
	ndr_print_ptr(ndr, "next", r->next);
	ndr->depth++;
	if (r->next) {
		ndr_print_smbXsrv_session_auth0(ndr, "next", r->next);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "session", r->session);
	/* [ignore] 'session' */
	ndr_print_ptr(ndr, "connection", r->connection);
	/* [ignore] 'connection' */
	ndr_print_ptr(ndr, "gensec", r->gensec);
	/* [ignore] 'gensec' */
	ndr_print_ptr(ndr, "preauth", r->preauth);
	/* [ignore] 'preauth' */
	ndr_print_uint8(ndr, "in_flags", r->in_flags);
	ndr_print_uint8(ndr, "in_security_mode", r->in_security_mode);
	ndr_print_NTTIME(ndr, "creation_time", r->creation_time);
	ndr_print_NTTIME(ndr, "idle_time", r->idle_time);
	ndr_print_hyper(ndr, "channel_id", r->channel_id);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_session *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->global == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'client' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->local_id));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->global */
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->nonce_high_random));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->nonce_high_max));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->nonce_high));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->nonce_low));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'tcon_table' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->homes_snum));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pending_auth));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		/* [ignore] 'client' */
		NDR_CHECK(ndr_push_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		/* [ignore] 'tcon_table' */
		if (r->pending_auth) {
			NDR_CHECK(ndr_push_smbXsrv_session_auth0(ndr, NDR_SCALARS|NDR_BUFFERS, r->pending_auth));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_session *r)
{
	uint32_t _ptr_table;
	uint32_t _ptr_db_rec;
	uint32_t _ptr_client;
	uint32_t _ptr_global;
	TALLOC_CTX *_mem_save_global_0 = NULL;
	uint32_t _ptr_tcon_table;
	uint32_t _ptr_pending_auth;
	TALLOC_CTX *_mem_save_pending_auth_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_table));
		_ptr_table = 0;
		if (_ptr_table) {
		} else {
			r->table = NULL;
		}
		/* [ignore] 'table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_client));
		_ptr_client = 0;
		if (_ptr_client) {
		} else {
			r->client = NULL;
		}
		/* [ignore] 'client' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->local_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_global));
		if (_ptr_global) {
			NDR_PULL_ALLOC(ndr, r->global);
		} else {
			r->global = NULL;
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->nonce_high_random));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->nonce_high_max));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->nonce_high));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->nonce_low));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_tcon_table));
		_ptr_tcon_table = 0;
		if (_ptr_tcon_table) {
		} else {
			r->tcon_table = NULL;
		}
		/* [ignore] 'tcon_table' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->homes_snum));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pending_auth));
		if (_ptr_pending_auth) {
			NDR_PULL_ALLOC(ndr, r->pending_auth);
		} else {
			r->pending_auth = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		/* [ignore] 'client' */
		_mem_save_global_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->global, 0);
		NDR_CHECK(ndr_pull_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_global_0, 0);
		/* [ignore] 'tcon_table' */
		if (r->pending_auth) {
			_mem_save_pending_auth_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pending_auth, 0);
			NDR_CHECK(ndr_pull_smbXsrv_session_auth0(ndr, NDR_SCALARS|NDR_BUFFERS, r->pending_auth));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pending_auth_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session(struct ndr_print *ndr, const char *name, const struct smbXsrv_session *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "table", r->table);
	/* [ignore] 'table' */
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_ptr(ndr, "client", r->client);
	/* [ignore] 'client' */
	ndr_print_uint32(ndr, "local_id", r->local_id);
	ndr_print_ptr(ndr, "global", r->global);
	ndr->depth++;
	ndr_print_smbXsrv_session_global0(ndr, "global", r->global);
	ndr->depth--;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_NTTIME(ndr, "idle_time", r->idle_time);
	ndr_print_hyper(ndr, "nonce_high_random", r->nonce_high_random);
	ndr_print_hyper(ndr, "nonce_high_max", r->nonce_high_max);
	ndr_print_hyper(ndr, "nonce_high", r->nonce_high);
	ndr_print_hyper(ndr, "nonce_low", r->nonce_low);
	ndr_print_ptr(ndr, "tcon_table", r->tcon_table);
	/* [ignore] 'tcon_table' */
	ndr_print_uint32(ndr, "homes_snum", r->homes_snum);
	ndr_print_ptr(ndr, "pending_auth", r->pending_auth);
	ndr->depth++;
	if (r->pending_auth) {
		ndr_print_smbXsrv_session_auth0(ndr, "pending_auth", r->pending_auth);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_sessionU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_sessionU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_session(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_sessionU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_sessionU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_session(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_sessionU(struct ndr_print *ndr, const char *name, const union smbXsrv_sessionU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_sessionU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_session(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_sessionB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_sessionB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_sessionU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_sessionU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_sessionB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_sessionB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_sessionU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_sessionU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_sessionB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_sessionB *r)
{
	ndr_print_smbXsrv_sessionB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_sessionB(struct ndr_print *ndr, const char *name, const struct smbXsrv_sessionB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_sessionB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_sessionU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_close0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_session_close0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->old_session_global_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->old_session_wire_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->old_creation_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->new_session_wire_id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_close0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_session_close0 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->old_session_global_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->old_session_wire_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->old_creation_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->new_session_wire_id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_close0(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_close0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_close0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "old_session_global_id", r->old_session_global_id);
	ndr_print_hyper(ndr, "old_session_wire_id", r->old_session_wire_id);
	ndr_print_NTTIME(ndr, "old_creation_time", r->old_creation_time);
	ndr_print_hyper(ndr, "new_session_wire_id", r->new_session_wire_id);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_closeU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_session_closeU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_session_close0(ndr, NDR_SCALARS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_closeU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_session_closeU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_session_close0(ndr, NDR_SCALARS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_closeU(struct ndr_print *ndr, const char *name, const union smbXsrv_session_closeU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_session_closeU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_session_close0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_session_closeB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_session_closeB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_session_closeU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_session_closeU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_session_closeB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_session_closeB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_session_closeU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_session_closeU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_session_closeB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_session_closeB *r)
{
	ndr_print_smbXsrv_session_closeB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_session_closeB(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_closeB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_closeB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_session_closeU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon_global0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_tcon_global0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tcon_global_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tcon_wire_id));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->creation_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->share_name, ndr_charset_length(r->share_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_smbXsrv_encrpytion_flags(ndr, NDR_SCALARS, r->encryption_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_global_id));
		NDR_CHECK(ndr_push_smbXsrv_signing_flags(ndr, NDR_SCALARS, r->signing_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon_global0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_tcon_global0 *r)
{
	uint32_t _ptr_db_rec;
	uint32_t size_share_name_0 = 0;
	uint32_t length_share_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tcon_global_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tcon_wire_id));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->creation_time));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->share_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->share_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->share_name, &size_share_name_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->share_name, &length_share_name_0));
		if (length_share_name_0 > size_share_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_share_name_0, length_share_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_share_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->share_name, length_share_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_smbXsrv_encrpytion_flags(ndr, NDR_SCALARS, &r->encryption_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_global_id));
		NDR_CHECK(ndr_pull_smbXsrv_signing_flags(ndr, NDR_SCALARS, &r->signing_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_tcon_global0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "tcon_global_id", r->tcon_global_id);
	ndr_print_uint32(ndr, "tcon_wire_id", r->tcon_wire_id);
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_NTTIME(ndr, "creation_time", r->creation_time);
	ndr_print_string(ndr, "share_name", r->share_name);
	ndr_print_smbXsrv_encrpytion_flags(ndr, "encryption_flags", r->encryption_flags);
	ndr_print_uint32(ndr, "session_global_id", r->session_global_id);
	ndr_print_smbXsrv_signing_flags(ndr, "signing_flags", r->signing_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon_globalU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_tcon_globalU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon_globalU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_tcon_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_tcon_globalU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_tcon_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_tcon_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_tcon_globalB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_tcon_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_tcon_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_tcon_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_tcon_globalB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_tcon_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_tcon_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_tcon_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_tcon_globalB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_tcon_globalB *r)
{
	ndr_print_smbXsrv_tcon_globalB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_tcon_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_tcon_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_tcon *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->global == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->local_id));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->global */
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_tcon *r)
{
	uint32_t _ptr_table;
	uint32_t _ptr_db_rec;
	uint32_t _ptr_global;
	TALLOC_CTX *_mem_save_global_0 = NULL;
	uint32_t _ptr_compat;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_table));
		_ptr_table = 0;
		if (_ptr_table) {
		} else {
			r->table = NULL;
		}
		/* [ignore] 'table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->local_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_global));
		if (_ptr_global) {
			NDR_PULL_ALLOC(ndr, r->global);
		} else {
			r->global = NULL;
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_compat));
		_ptr_compat = 0;
		if (_ptr_compat) {
		} else {
			r->compat = NULL;
		}
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		_mem_save_global_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->global, 0);
		NDR_CHECK(ndr_pull_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_global_0, 0);
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon(struct ndr_print *ndr, const char *name, const struct smbXsrv_tcon *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "table", r->table);
	/* [ignore] 'table' */
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "local_id", r->local_id);
	ndr_print_ptr(ndr, "global", r->global);
	ndr->depth++;
	ndr_print_smbXsrv_tcon_global0(ndr, "global", r->global);
	ndr->depth--;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_NTTIME(ndr, "idle_time", r->idle_time);
	ndr_print_ptr(ndr, "compat", r->compat);
	/* [ignore] 'compat' */
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tconU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_tconU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_tcon(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tconU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_tconU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_tcon(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tconU(struct ndr_print *ndr, const char *name, const union smbXsrv_tconU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_tconU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_tcon(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_tconB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_tconB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_tconU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_tconU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_tconB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_tconB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_tconU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_tconU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_tconB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_tconB *r)
{
	ndr_print_smbXsrv_tconB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_tconB(struct ndr_print *ndr, const char *name, const struct smbXsrv_tconB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tconB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_tconU(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_open_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_open_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_flags(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_OPEN_NEED_REPLAY_CACHE", SMBXSRV_OPEN_NEED_REPLAY_CACHE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "SMBXSRV_OPEN_HAVE_REPLAY_CACHE", SMBXSRV_OPEN_HAVE_REPLAY_CACHE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open_global0(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_open_global0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->session_global_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tcon_global_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->open_global_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->open_persistent_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->open_volatile_id));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->open_owner));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->open_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->create_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->app_instance_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->create_action));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->disconnect_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->durable_timeout_msec));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->durable));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->backend_cookie));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->channel_sequence));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->channel_generation));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->lock_sequence_array, 64));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open_global0(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_open_global0 *r)
{
	uint32_t size_lock_sequence_array_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->session_global_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tcon_global_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->open_global_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->open_persistent_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->open_volatile_id));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->open_owner));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->open_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->create_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->app_instance_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->create_action));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->disconnect_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->durable_timeout_msec));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->durable));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->backend_cookie));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->channel_sequence));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->channel_generation));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			size_lock_sequence_array_0 = 64;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->lock_sequence_array, size_lock_sequence_array_0));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_open_global0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_hyper(ndr, "session_global_id", r->session_global_id);
	ndr_print_uint32(ndr, "tcon_global_id", r->tcon_global_id);
	ndr_print_uint32(ndr, "open_global_id", r->open_global_id);
	ndr_print_hyper(ndr, "open_persistent_id", r->open_persistent_id);
	ndr_print_hyper(ndr, "open_volatile_id", r->open_volatile_id);
	ndr_print_dom_sid(ndr, "open_owner", &r->open_owner);
	ndr_print_NTTIME(ndr, "open_time", r->open_time);
	ndr_print_GUID(ndr, "create_guid", &r->create_guid);
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_GUID(ndr, "app_instance_id", &r->app_instance_id);
	ndr_print_uint32(ndr, "create_action", r->create_action);
	ndr_print_NTTIME(ndr, "disconnect_time", r->disconnect_time);
	ndr_print_uint32(ndr, "durable_timeout_msec", r->durable_timeout_msec);
	ndr_print_uint8(ndr, "durable", r->durable);
	ndr_print_DATA_BLOB(ndr, "backend_cookie", r->backend_cookie);
	ndr_print_uint16(ndr, "channel_sequence", r->channel_sequence);
	ndr_print_hyper(ndr, "channel_generation", r->channel_generation);
	{
		libndr_flags _flags_save_uint8 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr_print_array_uint8(ndr, "lock_sequence_array", r->lock_sequence_array, 64);
		ndr->flags = _flags_save_uint8;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open_globalU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_open_globalU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_open_global0(ndr, NDR_SCALARS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open_globalU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_open_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_open_global0(ndr, NDR_SCALARS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_open_globalU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_open_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_open_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_open_globalB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_open_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_open_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_open_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_open_globalB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_open_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_open_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_open_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_open_globalB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_open_globalB *r)
{
	ndr_print_smbXsrv_open_globalB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_open_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_open_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_open_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_open *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->global == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->local_id));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->global */
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->session));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->tcon));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_push_smbXsrv_open_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->request_count));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->pre_request_count));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_smbXsrv_open_global0(ndr, NDR_SCALARS, r->global));
		if (r->session) {
			NDR_CHECK(ndr_push_smbXsrv_session(ndr, NDR_SCALARS|NDR_BUFFERS, r->session));
		}
		if (r->tcon) {
			NDR_CHECK(ndr_push_smbXsrv_tcon(ndr, NDR_SCALARS|NDR_BUFFERS, r->tcon));
		}
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_open *r)
{
	uint32_t _ptr_table;
	uint32_t _ptr_global;
	TALLOC_CTX *_mem_save_global_0 = NULL;
	uint32_t _ptr_session;
	TALLOC_CTX *_mem_save_session_0 = NULL;
	uint32_t _ptr_tcon;
	TALLOC_CTX *_mem_save_tcon_0 = NULL;
	uint32_t _ptr_compat;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_table));
		_ptr_table = 0;
		if (_ptr_table) {
		} else {
			r->table = NULL;
		}
		/* [ignore] 'table' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->local_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_global));
		if (_ptr_global) {
			NDR_PULL_ALLOC(ndr, r->global);
		} else {
			r->global = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_session));
		if (_ptr_session) {
			NDR_PULL_ALLOC(ndr, r->session);
		} else {
			r->session = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tcon));
		if (_ptr_tcon) {
			NDR_PULL_ALLOC(ndr, r->tcon);
		} else {
			r->tcon = NULL;
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_compat));
		_ptr_compat = 0;
		if (_ptr_compat) {
		} else {
			r->compat = NULL;
		}
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_pull_smbXsrv_open_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->request_count));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->pre_request_count));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		_mem_save_global_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->global, 0);
		NDR_CHECK(ndr_pull_smbXsrv_open_global0(ndr, NDR_SCALARS, r->global));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_global_0, 0);
		if (r->session) {
			_mem_save_session_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->session, 0);
			NDR_CHECK(ndr_pull_smbXsrv_session(ndr, NDR_SCALARS|NDR_BUFFERS, r->session));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_session_0, 0);
		}
		if (r->tcon) {
			_mem_save_tcon_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tcon, 0);
			NDR_CHECK(ndr_pull_smbXsrv_tcon(ndr, NDR_SCALARS|NDR_BUFFERS, r->tcon));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tcon_0, 0);
		}
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open(struct ndr_print *ndr, const char *name, const struct smbXsrv_open *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "table", r->table);
	/* [ignore] 'table' */
	ndr_print_uint32(ndr, "local_id", r->local_id);
	ndr_print_ptr(ndr, "global", r->global);
	ndr->depth++;
	ndr_print_smbXsrv_open_global0(ndr, "global", r->global);
	ndr->depth--;
	ndr_print_ptr(ndr, "session", r->session);
	ndr->depth++;
	if (r->session) {
		ndr_print_smbXsrv_session(ndr, "session", r->session);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "tcon", r->tcon);
	ndr->depth++;
	if (r->tcon) {
		ndr_print_smbXsrv_tcon(ndr, "tcon", r->tcon);
	}
	ndr->depth--;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_NTTIME(ndr, "idle_time", r->idle_time);
	ndr_print_ptr(ndr, "compat", r->compat);
	/* [ignore] 'compat' */
	ndr_print_smbXsrv_open_flags(ndr, "flags", r->flags);
	ndr_print_hyper(ndr, "request_count", r->request_count);
	ndr_print_hyper(ndr, "pre_request_count", r->pre_request_count);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_openU(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union smbXsrv_openU *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_open(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_openU(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union smbXsrv_openU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0 = NULL;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0 = NULL;
	uint32_t _ptr_dummy;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_open(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_openU(struct ndr_print *ndr, const char *name, const union smbXsrv_openU *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_openU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_open(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_openB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_openB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_openU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_openU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_openB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_openB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_openU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_openU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_openB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_openB *r)
{
	ndr_print_smbXsrv_openB(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_openB(struct ndr_print *ndr, const char *name, const struct smbXsrv_openB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_openB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_openU(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_open_replay_cache_key(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_open_replay_cache_key *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->create_guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_open_replay_cache_key(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_open_replay_cache_key *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->create_guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_open_replay_cache_key(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_open_replay_cache_key *r)
{
	ndr_print_smbXsrv_open_replay_cache_key(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_open_replay_cache_key(struct ndr_print *ndr, const char *name, const struct smbXsrv_open_replay_cache_key *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_replay_cache_key");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_GUID(ndr, "create_guid", &r->create_guid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_open_replay_cache(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct smbXsrv_open_replay_cache *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->open_global_key));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_open_replay_cache(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct smbXsrv_open_replay_cache *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->open_global_key));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_smbXsrv_open_replay_cache(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct smbXsrv_open_replay_cache *r)
{
	ndr_print_smbXsrv_open_replay_cache(ndr, name, r);
}

_PUBLIC_ void ndr_print_smbXsrv_open_replay_cache(struct ndr_print *ndr, const char *name, const struct smbXsrv_open_replay_cache *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_replay_cache");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_DATA_BLOB(ndr, "open_global_key", r->open_global_key);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_smbXsrv
static const struct ndr_interface_public_struct smbXsrv_public_structs[] = {
	{
		.name = "smbXsrv_version_globalB",
		.struct_size = sizeof(struct smbXsrv_version_globalB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_version_globalB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_version_globalB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_version_globalB,
	},
	{
		.name = "smbXsrv_client_globalB",
		.struct_size = sizeof(struct smbXsrv_client_globalB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_client_globalB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_client_globalB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_client_globalB,
	},
	{
		.name = "smbXsrv_client",
		.struct_size = sizeof(struct smbXsrv_client ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_client,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_client,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_client,
	},
	{
		.name = "smbXsrv_clientB",
		.struct_size = sizeof(struct smbXsrv_clientB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_clientB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_clientB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_clientB,
	},
	{
		.name = "smbXsrv_connection_passB",
		.struct_size = sizeof(struct smbXsrv_connection_passB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_connection_passB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_connection_passB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_connection_passB,
	},
	{
		.name = "smbXsrv_connection_dropB",
		.struct_size = sizeof(struct smbXsrv_connection_dropB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_connection_dropB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_connection_dropB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_connection_dropB,
	},
	{
		.name = "smbXsrv_session_globalB",
		.struct_size = sizeof(struct smbXsrv_session_globalB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_session_globalB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_session_globalB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_session_globalB,
	},
	{
		.name = "smbXsrv_sessionB",
		.struct_size = sizeof(struct smbXsrv_sessionB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_sessionB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_sessionB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_sessionB,
	},
	{
		.name = "smbXsrv_session_closeB",
		.struct_size = sizeof(struct smbXsrv_session_closeB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_session_closeB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_session_closeB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_session_closeB,
	},
	{
		.name = "smbXsrv_tcon_globalB",
		.struct_size = sizeof(struct smbXsrv_tcon_globalB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_tcon_globalB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_tcon_globalB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_tcon_globalB,
	},
	{
		.name = "smbXsrv_tconB",
		.struct_size = sizeof(struct smbXsrv_tconB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_tconB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_tconB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_tconB,
	},
	{
		.name = "smbXsrv_open_globalB",
		.struct_size = sizeof(struct smbXsrv_open_globalB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_open_globalB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_open_globalB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_open_globalB,
	},
	{
		.name = "smbXsrv_openB",
		.struct_size = sizeof(struct smbXsrv_openB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_openB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_openB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_openB,
	},
	{
		.name = "smbXsrv_open_replay_cache_key",
		.struct_size = sizeof(struct smbXsrv_open_replay_cache_key ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_open_replay_cache_key,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_open_replay_cache_key,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_open_replay_cache_key,
	},
	{
		.name = "smbXsrv_open_replay_cache",
		.struct_size = sizeof(struct smbXsrv_open_replay_cache ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_smbXsrv_open_replay_cache,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_smbXsrv_open_replay_cache,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_smbXsrv_open_replay_cache,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call smbXsrv_calls[] = {
	{ .name = NULL }
};

static const char * const smbXsrv_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\smbXsrv]", 
};

static const struct ndr_interface_string_array smbXsrv_endpoints = {
	.count	= 1,
	.names	= smbXsrv_endpoint_strings
};

static const char * const smbXsrv_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array smbXsrv_authservices = {
	.count	= 1,
	.names	= smbXsrv_authservice_strings
};


const struct ndr_interface_table ndr_table_smbXsrv = {
	.name		= "smbXsrv",
	.syntax_id	= {
		{0x07408340,0xae31,0x11e1,{0x97,0xdc},{0x53,0x9f,0x7f,0xdd,0xc0,0x6f}},
		NDR_SMBXSRV_VERSION
	},
	.helpstring	= NDR_SMBXSRV_HELPSTRING,
	.num_calls	= 0,
	.calls		= smbXsrv_calls,
	.num_public_structs	= 15,
	.public_structs		= smbXsrv_public_structs,
	.endpoints	= &smbXsrv_endpoints,
	.authservices	= &smbXsrv_authservices
};

#endif /* SKIP_NDR_TABLE_smbXsrv */
