
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_schannel.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/nbt.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
static PyTypeObject netlogon_creds_CredentialState_extra_info_Type;
static PyTypeObject netlogon_creds_CredentialState_Type;
static PyTypeObject netlogon_cache_entry_Type;
static PyTypeObject NL_AUTH_MESSAGE_BUFFER_Type;
static PyTypeObject NL_AUTH_MESSAGE_BUFFER_REPLY_Type;
static PyTypeObject NL_AUTH_MESSAGE_Type;
static PyTypeObject NL_AUTH_SIGNATURE_Type;
static PyTypeObject NL_AUTH_SHA2_SIGNATURE_Type;

static PyTypeObject *dom_sid_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *netr_Credential_Type;
static PyTypeObject *GUID_Type;

static PyObject *py_netlogon_creds_CredentialState_extra_info_get_dummy_sid(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState_extra_info *object = pytalloc_get_ptr(obj);
	PyObject *py_dummy_sid;
	py_dummy_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->dummy_sid);
	return py_dummy_sid;
}

static int py_netlogon_creds_CredentialState_extra_info_set_dummy_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState_extra_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dummy_sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netlogon_creds_CredentialState_extra_info_getsetters[] = {
	{
		.name = discard_const_p(char, "dummy_sid"),
		.get = py_netlogon_creds_CredentialState_extra_info_get_dummy_sid,
		.set = py_netlogon_creds_CredentialState_extra_info_set_dummy_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{ .name = NULL }
};

static PyObject *py_netlogon_creds_CredentialState_extra_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netlogon_creds_CredentialState_extra_info, type);
}


static PyTypeObject netlogon_creds_CredentialState_extra_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.netlogon_creds_CredentialState_extra_info",
	.tp_getset = py_netlogon_creds_CredentialState_extra_info_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netlogon_creds_CredentialState_extra_info_new,
};


static PyObject *py_netlogon_creds_CredentialState_get_zero_flags(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_zero_flags;
	py_zero_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->zero_flags));
	return py_zero_flags;
}

static int py_netlogon_creds_CredentialState_set_zero_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->zero_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->zero_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->zero_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_session_key(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_session_key;
	py_session_key = PyList_New(16);
	if (py_session_key == NULL) {
		return NULL;
	}
	{
		int session_key_cntr_0;
		for (session_key_cntr_0 = 0; session_key_cntr_0 < (16); session_key_cntr_0++) {
			PyObject *py_session_key_0;
			py_session_key_0 = PyLong_FromLong((uint16_t)((object->session_key)[session_key_cntr_0]));
			PyList_SetItem(py_session_key, session_key_cntr_0, py_session_key_0);
		}
	}
	return py_session_key;
}

static int py_netlogon_creds_CredentialState_set_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_key");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int session_key_cntr_0;
		if (ARRAY_SIZE(object->session_key) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->session_key),  PyList_GET_SIZE(value));
			return -1;
		}
		for (session_key_cntr_0 = 0; session_key_cntr_0 < PyList_GET_SIZE(value); session_key_cntr_0++) {
			if (PyList_GET_ITEM(value, session_key_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->session_key)[session_key_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->session_key)[session_key_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, session_key_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, session_key_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->session_key)[session_key_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_sequence(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_sequence;
	py_sequence = PyLong_FromUnsignedLongLong((uint32_t)(object->sequence));
	return py_sequence;
}

static int py_netlogon_creds_CredentialState_set_sequence(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sequence");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sequence));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sequence = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_seed(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_seed;
	py_seed = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->seed);
	return py_seed;
}

static int py_netlogon_creds_CredentialState_set_seed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->seed");
		return -1;
	}
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->seed = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_client(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_client;
	py_client = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->client);
	return py_client;
}

static int py_netlogon_creds_CredentialState_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client");
		return -1;
	}
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_server(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_server;
	py_server = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->server);
	return py_server;
}

static int py_netlogon_creds_CredentialState_set_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server");
		return -1;
	}
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_secure_channel_type(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_secure_channel_type;
	py_secure_channel_type = PyLong_FromLong((uint16_t)(object->secure_channel_type));
	return py_secure_channel_type;
}

static int py_netlogon_creds_CredentialState_set_secure_channel_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->secure_channel_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->secure_channel_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->secure_channel_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_computer_name(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	if (object->computer_name == NULL) {
		py_computer_name = Py_None;
		Py_INCREF(py_computer_name);
	} else {
		py_computer_name = PyUnicode_Decode(object->computer_name, strlen(object->computer_name), "utf-8", "ignore");
	}
	return py_computer_name;
}

static int py_netlogon_creds_CredentialState_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->computer_name = talloc_str;
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_account_name(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_netlogon_creds_CredentialState_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->account_name = talloc_str;
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_magic1(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_magic1;
	py_magic1 = PyLong_FromUnsignedLongLong((uint32_t)(object->magic1));
	return py_magic1;
}

static int py_netlogon_creds_CredentialState_set_magic1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->magic1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_magic2(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_magic2;
	py_magic2 = PyLong_FromUnsignedLongLong((uint32_t)(object->magic2));
	return py_magic2;
}

static int py_netlogon_creds_CredentialState_set_magic2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->magic2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_negotiate_flags(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_negotiate_flags;
	py_negotiate_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->negotiate_flags));
	return py_negotiate_flags;
}

static int py_netlogon_creds_CredentialState_set_negotiate_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->negotiate_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->negotiate_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->negotiate_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_client_requested_flags(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_client_requested_flags;
	py_client_requested_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->client_requested_flags));
	return py_client_requested_flags;
}

static int py_netlogon_creds_CredentialState_set_client_requested_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_requested_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->client_requested_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->client_requested_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_auth_time(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_time;
	py_auth_time = PyLong_FromUnsignedLongLong(object->auth_time);
	return py_auth_time;
}

static int py_netlogon_creds_CredentialState_set_auth_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_magic3(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_magic3;
	py_magic3 = PyLong_FromUnsignedLongLong((uint32_t)(object->magic3));
	return py_magic3;
}

static int py_netlogon_creds_CredentialState_set_magic3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->magic3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_client_sid(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_client_sid;
	py_client_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->client_sid);
	return py_client_sid;
}

static int py_netlogon_creds_CredentialState_set_client_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_tdo_guid(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_tdo_guid;
	py_tdo_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->tdo_guid);
	return py_tdo_guid;
}

static int py_netlogon_creds_CredentialState_set_tdo_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tdo_guid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->tdo_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_authenticate_kerberos(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_authenticate_kerberos;
	py_authenticate_kerberos = PyLong_FromLong((uint16_t)(object->authenticate_kerberos));
	return py_authenticate_kerberos;
}

static int py_netlogon_creds_CredentialState_set_authenticate_kerberos(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->authenticate_kerberos");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->authenticate_kerberos));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->authenticate_kerberos = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_reserved2(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved2;
	py_reserved2 = PyLong_FromUnsignedLongLong(object->reserved2);
	return py_reserved2;
}

static int py_netlogon_creds_CredentialState_set_reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_ex(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(obj);
	PyObject *py_ex;
	if (object->ex == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ex == NULL) {
		py_ex = Py_None;
		Py_INCREF(py_ex);
	} else {
		py_ex = pytalloc_reference_ex(&netlogon_creds_CredentialState_extra_info_Type, object->ex, object->ex);
	}
	return py_ex;
}

static int py_netlogon_creds_CredentialState_set_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->ex));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ex");
		return -1;
	}
	if (value == Py_None) {
		object->ex = NULL;
	} else {
		object->ex = NULL;
		PY_CHECK_TYPE(&netlogon_creds_CredentialState_extra_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ex = (struct netlogon_creds_CredentialState_extra_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_netlogon_creds_CredentialState_getsetters[] = {
	{
		.name = discard_const_p(char, "zero_flags"),
		.get = py_netlogon_creds_CredentialState_get_zero_flags,
		.set = py_netlogon_creds_CredentialState_set_zero_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "session_key"),
		.get = py_netlogon_creds_CredentialState_get_session_key,
		.set = py_netlogon_creds_CredentialState_set_session_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "sequence"),
		.get = py_netlogon_creds_CredentialState_get_sequence,
		.set = py_netlogon_creds_CredentialState_set_sequence,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "seed"),
		.get = py_netlogon_creds_CredentialState_get_seed,
		.set = py_netlogon_creds_CredentialState_set_seed,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{
		.name = discard_const_p(char, "client"),
		.get = py_netlogon_creds_CredentialState_get_client,
		.set = py_netlogon_creds_CredentialState_set_client,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{
		.name = discard_const_p(char, "server"),
		.get = py_netlogon_creds_CredentialState_get_server,
		.set = py_netlogon_creds_CredentialState_set_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{
		.name = discard_const_p(char, "secure_channel_type"),
		.get = py_netlogon_creds_CredentialState_get_secure_channel_type,
		.set = py_netlogon_creds_CredentialState_set_secure_channel_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SchannelType")
	},
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_netlogon_creds_CredentialState_get_computer_name,
		.set = py_netlogon_creds_CredentialState_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_netlogon_creds_CredentialState_get_account_name,
		.set = py_netlogon_creds_CredentialState_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "magic1"),
		.get = py_netlogon_creds_CredentialState_get_magic1,
		.set = py_netlogon_creds_CredentialState_set_magic1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "magic2"),
		.get = py_netlogon_creds_CredentialState_get_magic2,
		.set = py_netlogon_creds_CredentialState_set_magic2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "negotiate_flags"),
		.get = py_netlogon_creds_CredentialState_get_negotiate_flags,
		.set = py_netlogon_creds_CredentialState_set_negotiate_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_NegotiateFlags")
	},
	{
		.name = discard_const_p(char, "client_requested_flags"),
		.get = py_netlogon_creds_CredentialState_get_client_requested_flags,
		.set = py_netlogon_creds_CredentialState_set_client_requested_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_NegotiateFlags")
	},
	{
		.name = discard_const_p(char, "auth_time"),
		.get = py_netlogon_creds_CredentialState_get_auth_time,
		.set = py_netlogon_creds_CredentialState_set_auth_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "magic3"),
		.get = py_netlogon_creds_CredentialState_get_magic3,
		.set = py_netlogon_creds_CredentialState_set_magic3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "client_sid"),
		.get = py_netlogon_creds_CredentialState_get_client_sid,
		.set = py_netlogon_creds_CredentialState_set_client_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid28")
	},
	{
		.name = discard_const_p(char, "tdo_guid"),
		.get = py_netlogon_creds_CredentialState_get_tdo_guid,
		.set = py_netlogon_creds_CredentialState_set_tdo_guid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "authenticate_kerberos"),
		.get = py_netlogon_creds_CredentialState_get_authenticate_kerberos,
		.set = py_netlogon_creds_CredentialState_set_authenticate_kerberos,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "reserved2"),
		.get = py_netlogon_creds_CredentialState_get_reserved2,
		.set = py_netlogon_creds_CredentialState_set_reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "ex"),
		.get = py_netlogon_creds_CredentialState_get_ex,
		.set = py_netlogon_creds_CredentialState_set_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_creds_CredentialState_extra_info")
	},
	{ .name = NULL }
};

static PyObject *py_netlogon_creds_CredentialState_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netlogon_creds_CredentialState, type);
}

static PyObject *py_netlogon_creds_CredentialState_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netlogon_creds_CredentialState);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netlogon_creds_CredentialState_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_creds_CredentialState);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_creds_CredentialState);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netlogon_creds_CredentialState_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_creds_CredentialState *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_creds_CredentialState, "netlogon_creds_CredentialState", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_creds_CredentialState, "netlogon_creds_CredentialState", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netlogon_creds_CredentialState_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netlogon_creds_CredentialState_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_creds_CredentialState_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_creds_CredentialState_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netlogon_creds_CredentialState_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.netlogon_creds_CredentialState",
	.tp_getset = py_netlogon_creds_CredentialState_getsetters,
	.tp_methods = py_netlogon_creds_CredentialState_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netlogon_creds_CredentialState_new,
};


static PyObject *py_netlogon_cache_entry_get_computer_name(PyObject *obj, void *closure)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	if (object->computer_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->computer_name == NULL) {
		py_computer_name = Py_None;
		Py_INCREF(py_computer_name);
	} else {
		if (object->computer_name == NULL) {
			py_computer_name = Py_None;
			Py_INCREF(py_computer_name);
		} else {
			py_computer_name = PyUnicode_Decode(object->computer_name, strlen(object->computer_name), "utf-8", "ignore");
		}
	}
	return py_computer_name;
}

static int py_netlogon_cache_entry_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_name");
		return -1;
	}
	if (value == Py_None) {
		object->computer_name = NULL;
	} else {
		object->computer_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->computer_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_netlogon_cache_entry_get_server_challenge(PyObject *obj, void *closure)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_server_challenge;
	py_server_challenge = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->server_challenge);
	return py_server_challenge;
}

static int py_netlogon_cache_entry_set_server_challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_challenge");
		return -1;
	}
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server_challenge = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_cache_entry_get_client_challenge(PyObject *obj, void *closure)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_client_challenge;
	py_client_challenge = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->client_challenge);
	return py_client_challenge;
}

static int py_netlogon_cache_entry_set_client_challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_challenge");
		return -1;
	}
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client_challenge = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netlogon_cache_entry_getsetters[] = {
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_netlogon_cache_entry_get_computer_name,
		.set = py_netlogon_cache_entry_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "server_challenge"),
		.get = py_netlogon_cache_entry_get_server_challenge,
		.set = py_netlogon_cache_entry_set_server_challenge,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{
		.name = discard_const_p(char, "client_challenge"),
		.get = py_netlogon_cache_entry_get_client_challenge,
		.set = py_netlogon_cache_entry_set_client_challenge,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_Credential")
	},
	{ .name = NULL }
};

static PyObject *py_netlogon_cache_entry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netlogon_cache_entry, type);
}

static PyObject *py_netlogon_cache_entry_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netlogon_cache_entry);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netlogon_cache_entry_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_cache_entry);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_cache_entry);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netlogon_cache_entry_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_cache_entry *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_cache_entry, "netlogon_cache_entry", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_cache_entry, "netlogon_cache_entry", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netlogon_cache_entry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netlogon_cache_entry_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_cache_entry_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_cache_entry_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netlogon_cache_entry_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.netlogon_cache_entry",
	.tp_getset = py_netlogon_cache_entry_getsetters,
	.tp_methods = py_netlogon_cache_entry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netlogon_cache_entry_new,
};

static PyObject *py_import_NL_AUTH_MESSAGE_BUFFER(TALLOC_CTX *mem_ctx, int level, union NL_AUTH_MESSAGE_BUFFER *in)
{
	PyObject *ret;

	switch (level) {
		case NL_FLAG_OEM_NETBIOS_DOMAIN_NAME:
			ret = PyString_FromStringOrNULL(in->a);
			return ret;

		case NL_FLAG_OEM_NETBIOS_COMPUTER_NAME:
			ret = PyString_FromStringOrNULL(in->a);
			return ret;

		case NL_FLAG_UTF8_DNS_DOMAIN_NAME:
			ret = PyString_FromStringOrNULL(in->u);
			return ret;

		case NL_FLAG_UTF8_DNS_HOST_NAME:
			ret = PyString_FromStringOrNULL(in->u);
			return ret;

		case NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME:
			ret = PyString_FromStringOrNULL(in->u);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union NL_AUTH_MESSAGE_BUFFER *py_export_NL_AUTH_MESSAGE_BUFFER(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union NL_AUTH_MESSAGE_BUFFER *ret = talloc_zero(mem_ctx, union NL_AUTH_MESSAGE_BUFFER);
	switch (level) {
		case NL_FLAG_OEM_NETBIOS_DOMAIN_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->a");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->a = talloc_str;
			}
			break;

		case NL_FLAG_OEM_NETBIOS_COMPUTER_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->a");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->a = talloc_str;
			}
			break;

		case NL_FLAG_UTF8_DNS_DOMAIN_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->u");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->u = talloc_str;
			}
			break;

		case NL_FLAG_UTF8_DNS_HOST_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->u");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->u = talloc_str;
			}
			break;

		case NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->u");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->u = talloc_str;
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_NL_AUTH_MESSAGE_BUFFER_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union NL_AUTH_MESSAGE_BUFFER *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union NL_AUTH_MESSAGE_BUFFER *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union NL_AUTH_MESSAGE_BUFFER!");
		return NULL;
	}

	return py_import_NL_AUTH_MESSAGE_BUFFER(mem_ctx, level, in);
}

static PyObject *py_NL_AUTH_MESSAGE_BUFFER_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union NL_AUTH_MESSAGE_BUFFER *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_NL_AUTH_MESSAGE_BUFFER(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_NL_AUTH_MESSAGE_BUFFER_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_MESSAGE_BUFFER_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_MESSAGE_BUFFER_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_NL_AUTH_MESSAGE_BUFFER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject NL_AUTH_MESSAGE_BUFFER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.NL_AUTH_MESSAGE_BUFFER",
	.tp_getset = NULL,
	.tp_methods = py_NL_AUTH_MESSAGE_BUFFER_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_AUTH_MESSAGE_BUFFER_new,
};

static PyObject *py_import_NL_AUTH_MESSAGE_BUFFER_REPLY(TALLOC_CTX *mem_ctx, int level, union NL_AUTH_MESSAGE_BUFFER_REPLY *in)
{
	PyObject *ret;

	switch (level) {
		case NL_NEGOTIATE_RESPONSE:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->dummy));
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union NL_AUTH_MESSAGE_BUFFER_REPLY *py_export_NL_AUTH_MESSAGE_BUFFER_REPLY(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union NL_AUTH_MESSAGE_BUFFER_REPLY *ret = talloc_zero(mem_ctx, union NL_AUTH_MESSAGE_BUFFER_REPLY);
	switch (level) {
		case NL_NEGOTIATE_RESPONSE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dummy");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->dummy));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->dummy = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_NL_AUTH_MESSAGE_BUFFER_REPLY_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union NL_AUTH_MESSAGE_BUFFER_REPLY *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union NL_AUTH_MESSAGE_BUFFER_REPLY *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union NL_AUTH_MESSAGE_BUFFER_REPLY!");
		return NULL;
	}

	return py_import_NL_AUTH_MESSAGE_BUFFER_REPLY(mem_ctx, level, in);
}

static PyObject *py_NL_AUTH_MESSAGE_BUFFER_REPLY_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union NL_AUTH_MESSAGE_BUFFER_REPLY *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_NL_AUTH_MESSAGE_BUFFER_REPLY(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_NL_AUTH_MESSAGE_BUFFER_REPLY_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_MESSAGE_BUFFER_REPLY_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_MESSAGE_BUFFER_REPLY_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_NL_AUTH_MESSAGE_BUFFER_REPLY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject NL_AUTH_MESSAGE_BUFFER_REPLY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.NL_AUTH_MESSAGE_BUFFER_REPLY",
	.tp_getset = NULL,
	.tp_methods = py_NL_AUTH_MESSAGE_BUFFER_REPLY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_AUTH_MESSAGE_BUFFER_REPLY_new,
};


static PyObject *py_NL_AUTH_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyLong_FromUnsignedLongLong((uint32_t)(object->MessageType));
	return py_MessageType;
}

static int py_NL_AUTH_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MessageType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MessageType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MessageType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_Flags(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromUnsignedLongLong((uint32_t)(object->Flags));
	return py_Flags;
}

static int py_NL_AUTH_MESSAGE_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_oem_netbios_domain(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_oem_netbios_domain;
	py_oem_netbios_domain = pyrpc_import_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME, &object->oem_netbios_domain, "union NL_AUTH_MESSAGE_BUFFER");
	if (py_oem_netbios_domain == NULL) {
		return NULL;
	}
	return py_oem_netbios_domain;
}

static int py_NL_AUTH_MESSAGE_set_oem_netbios_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oem_netbios_domain");
		return -1;
	}
	{
		union NL_AUTH_MESSAGE_BUFFER *oem_netbios_domain_switch_0;
		oem_netbios_domain_switch_0 = (union NL_AUTH_MESSAGE_BUFFER *)pyrpc_export_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME, value, "union NL_AUTH_MESSAGE_BUFFER");
		if (oem_netbios_domain_switch_0 == NULL) {
			return -1;
		}
		object->oem_netbios_domain = *oem_netbios_domain_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_oem_netbios_computer(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_oem_netbios_computer;
	py_oem_netbios_computer = pyrpc_import_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME, &object->oem_netbios_computer, "union NL_AUTH_MESSAGE_BUFFER");
	if (py_oem_netbios_computer == NULL) {
		return NULL;
	}
	return py_oem_netbios_computer;
}

static int py_NL_AUTH_MESSAGE_set_oem_netbios_computer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oem_netbios_computer");
		return -1;
	}
	{
		union NL_AUTH_MESSAGE_BUFFER *oem_netbios_computer_switch_0;
		oem_netbios_computer_switch_0 = (union NL_AUTH_MESSAGE_BUFFER *)pyrpc_export_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME, value, "union NL_AUTH_MESSAGE_BUFFER");
		if (oem_netbios_computer_switch_0 == NULL) {
			return -1;
		}
		object->oem_netbios_computer = *oem_netbios_computer_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_utf8_dns_domain(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_utf8_dns_domain;
	py_utf8_dns_domain = pyrpc_import_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME, &object->utf8_dns_domain, "union NL_AUTH_MESSAGE_BUFFER");
	if (py_utf8_dns_domain == NULL) {
		return NULL;
	}
	return py_utf8_dns_domain;
}

static int py_NL_AUTH_MESSAGE_set_utf8_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->utf8_dns_domain");
		return -1;
	}
	{
		union NL_AUTH_MESSAGE_BUFFER *utf8_dns_domain_switch_0;
		utf8_dns_domain_switch_0 = (union NL_AUTH_MESSAGE_BUFFER *)pyrpc_export_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME, value, "union NL_AUTH_MESSAGE_BUFFER");
		if (utf8_dns_domain_switch_0 == NULL) {
			return -1;
		}
		object->utf8_dns_domain = *utf8_dns_domain_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_utf8_dns_host(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_utf8_dns_host;
	py_utf8_dns_host = pyrpc_import_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_UTF8_DNS_HOST_NAME, &object->utf8_dns_host, "union NL_AUTH_MESSAGE_BUFFER");
	if (py_utf8_dns_host == NULL) {
		return NULL;
	}
	return py_utf8_dns_host;
}

static int py_NL_AUTH_MESSAGE_set_utf8_dns_host(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->utf8_dns_host");
		return -1;
	}
	{
		union NL_AUTH_MESSAGE_BUFFER *utf8_dns_host_switch_0;
		utf8_dns_host_switch_0 = (union NL_AUTH_MESSAGE_BUFFER *)pyrpc_export_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_UTF8_DNS_HOST_NAME, value, "union NL_AUTH_MESSAGE_BUFFER");
		if (utf8_dns_host_switch_0 == NULL) {
			return -1;
		}
		object->utf8_dns_host = *utf8_dns_host_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_utf8_netbios_computer(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_utf8_netbios_computer;
	py_utf8_netbios_computer = pyrpc_import_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME, &object->utf8_netbios_computer, "union NL_AUTH_MESSAGE_BUFFER");
	if (py_utf8_netbios_computer == NULL) {
		return NULL;
	}
	return py_utf8_netbios_computer;
}

static int py_NL_AUTH_MESSAGE_set_utf8_netbios_computer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->utf8_netbios_computer");
		return -1;
	}
	{
		union NL_AUTH_MESSAGE_BUFFER *utf8_netbios_computer_switch_0;
		utf8_netbios_computer_switch_0 = (union NL_AUTH_MESSAGE_BUFFER *)pyrpc_export_union(&NL_AUTH_MESSAGE_BUFFER_Type, pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME, value, "union NL_AUTH_MESSAGE_BUFFER");
		if (utf8_netbios_computer_switch_0 == NULL) {
			return -1;
		}
		object->utf8_netbios_computer = *utf8_netbios_computer_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_Buffer(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(obj);
	PyObject *py_Buffer;
	py_Buffer = pyrpc_import_union(&NL_AUTH_MESSAGE_BUFFER_REPLY_Type, pytalloc_get_mem_ctx(obj), object->MessageType & NL_NEGOTIATE_RESPONSE, &object->Buffer, "union NL_AUTH_MESSAGE_BUFFER_REPLY");
	if (py_Buffer == NULL) {
		return NULL;
	}
	return py_Buffer;
}

static int py_NL_AUTH_MESSAGE_set_Buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Buffer");
		return -1;
	}
	{
		union NL_AUTH_MESSAGE_BUFFER_REPLY *Buffer_switch_0;
		Buffer_switch_0 = (union NL_AUTH_MESSAGE_BUFFER_REPLY *)pyrpc_export_union(&NL_AUTH_MESSAGE_BUFFER_REPLY_Type, pytalloc_get_mem_ctx(py_obj), object->MessageType & NL_NEGOTIATE_RESPONSE, value, "union NL_AUTH_MESSAGE_BUFFER_REPLY");
		if (Buffer_switch_0 == NULL) {
			return -1;
		}
		object->Buffer = *Buffer_switch_0;
	}
	return 0;
}

static PyGetSetDef py_NL_AUTH_MESSAGE_getsetters[] = {
	{
		.name = discard_const_p(char, "MessageType"),
		.get = py_NL_AUTH_MESSAGE_get_MessageType,
		.set = py_NL_AUTH_MESSAGE_set_MessageType,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_TYPE")
	},
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_NL_AUTH_MESSAGE_get_Flags,
		.set = py_NL_AUTH_MESSAGE_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_FLAGS")
	},
	{
		.name = discard_const_p(char, "oem_netbios_domain"),
		.get = py_NL_AUTH_MESSAGE_get_oem_netbios_domain,
		.set = py_NL_AUTH_MESSAGE_set_oem_netbios_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_BUFFER")
	},
	{
		.name = discard_const_p(char, "oem_netbios_computer"),
		.get = py_NL_AUTH_MESSAGE_get_oem_netbios_computer,
		.set = py_NL_AUTH_MESSAGE_set_oem_netbios_computer,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_BUFFER")
	},
	{
		.name = discard_const_p(char, "utf8_dns_domain"),
		.get = py_NL_AUTH_MESSAGE_get_utf8_dns_domain,
		.set = py_NL_AUTH_MESSAGE_set_utf8_dns_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_BUFFER")
	},
	{
		.name = discard_const_p(char, "utf8_dns_host"),
		.get = py_NL_AUTH_MESSAGE_get_utf8_dns_host,
		.set = py_NL_AUTH_MESSAGE_set_utf8_dns_host,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_BUFFER")
	},
	{
		.name = discard_const_p(char, "utf8_netbios_computer"),
		.get = py_NL_AUTH_MESSAGE_get_utf8_netbios_computer,
		.set = py_NL_AUTH_MESSAGE_set_utf8_netbios_computer,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_BUFFER")
	},
	{
		.name = discard_const_p(char, "Buffer"),
		.get = py_NL_AUTH_MESSAGE_get_Buffer,
		.set = py_NL_AUTH_MESSAGE_set_Buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_AUTH_MESSAGE_BUFFER_REPLY")
	},
	{ .name = NULL }
};

static PyObject *py_NL_AUTH_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_AUTH_MESSAGE, type);
}

static PyObject *py_NL_AUTH_MESSAGE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NL_AUTH_MESSAGE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NL_AUTH_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_MESSAGE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_MESSAGE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_AUTH_MESSAGE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_MESSAGE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_MESSAGE, "NL_AUTH_MESSAGE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_MESSAGE, "NL_AUTH_MESSAGE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_AUTH_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_AUTH_MESSAGE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_MESSAGE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_MESSAGE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_AUTH_MESSAGE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.NL_AUTH_MESSAGE",
	.tp_getset = py_NL_AUTH_MESSAGE_getsetters,
	.tp_methods = py_NL_AUTH_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_AUTH_MESSAGE_new,
};


static PyObject *py_NL_AUTH_SIGNATURE_get_SignatureAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_SignatureAlgorithm;
	py_SignatureAlgorithm = PyLong_FromLong((uint16_t)(object->SignatureAlgorithm));
	return py_SignatureAlgorithm;
}

static int py_NL_AUTH_SIGNATURE_set_SignatureAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SignatureAlgorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SignatureAlgorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SignatureAlgorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_SealAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_SealAlgorithm;
	py_SealAlgorithm = PyLong_FromLong((uint16_t)(object->SealAlgorithm));
	return py_SealAlgorithm;
}

static int py_NL_AUTH_SIGNATURE_set_SealAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SealAlgorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SealAlgorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SealAlgorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Pad(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Pad;
	py_Pad = PyLong_FromLong((uint16_t)(object->Pad));
	return py_Pad;
}

static int py_NL_AUTH_SIGNATURE_set_Pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Flags(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromLong((uint16_t)(object->Flags));
	return py_Flags;
}

static int py_NL_AUTH_SIGNATURE_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_SequenceNumber(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_SequenceNumber;
	py_SequenceNumber = PyList_New(8);
	if (py_SequenceNumber == NULL) {
		return NULL;
	}
	{
		int SequenceNumber_cntr_0;
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < (8); SequenceNumber_cntr_0++) {
			PyObject *py_SequenceNumber_0;
			py_SequenceNumber_0 = PyLong_FromLong((uint16_t)((object->SequenceNumber)[SequenceNumber_cntr_0]));
			PyList_SetItem(py_SequenceNumber, SequenceNumber_cntr_0, py_SequenceNumber_0);
		}
	}
	return py_SequenceNumber;
}

static int py_NL_AUTH_SIGNATURE_set_SequenceNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SequenceNumber");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int SequenceNumber_cntr_0;
		if (ARRAY_SIZE(object->SequenceNumber) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->SequenceNumber),  PyList_GET_SIZE(value));
			return -1;
		}
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < PyList_GET_SIZE(value); SequenceNumber_cntr_0++) {
			if (PyList_GET_ITEM(value, SequenceNumber_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->SequenceNumber)[SequenceNumber_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->SequenceNumber)[SequenceNumber_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, SequenceNumber_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, SequenceNumber_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->SequenceNumber)[SequenceNumber_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Checksum(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyList_New(8);
	if (py_Checksum == NULL) {
		return NULL;
	}
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < (8); Checksum_cntr_0++) {
			PyObject *py_Checksum_0;
			py_Checksum_0 = PyLong_FromLong((uint16_t)((object->Checksum)[Checksum_cntr_0]));
			PyList_SetItem(py_Checksum, Checksum_cntr_0, py_Checksum_0);
		}
	}
	return py_Checksum;
}

static int py_NL_AUTH_SIGNATURE_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Checksum");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Checksum_cntr_0;
		if (ARRAY_SIZE(object->Checksum) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Checksum),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < PyList_GET_SIZE(value); Checksum_cntr_0++) {
			if (PyList_GET_ITEM(value, Checksum_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Checksum)[Checksum_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Checksum)[Checksum_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Checksum_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Checksum_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Checksum)[Checksum_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Confounder(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Confounder;
	py_Confounder = PyList_New(8);
	if (py_Confounder == NULL) {
		return NULL;
	}
	{
		int Confounder_cntr_0;
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < (8); Confounder_cntr_0++) {
			PyObject *py_Confounder_0;
			py_Confounder_0 = PyLong_FromLong((uint16_t)((object->Confounder)[Confounder_cntr_0]));
			PyList_SetItem(py_Confounder, Confounder_cntr_0, py_Confounder_0);
		}
	}
	return py_Confounder;
}

static int py_NL_AUTH_SIGNATURE_set_Confounder(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Confounder");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Confounder_cntr_0;
		if (ARRAY_SIZE(object->Confounder) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Confounder),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < PyList_GET_SIZE(value); Confounder_cntr_0++) {
			if (PyList_GET_ITEM(value, Confounder_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Confounder)[Confounder_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Confounder)[Confounder_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Confounder_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Confounder_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Confounder)[Confounder_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_NL_AUTH_SIGNATURE_getsetters[] = {
	{
		.name = discard_const_p(char, "SignatureAlgorithm"),
		.get = py_NL_AUTH_SIGNATURE_get_SignatureAlgorithm,
		.set = py_NL_AUTH_SIGNATURE_set_SignatureAlgorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_SIGNATURE_ALGORITHM")
	},
	{
		.name = discard_const_p(char, "SealAlgorithm"),
		.get = py_NL_AUTH_SIGNATURE_get_SealAlgorithm,
		.set = py_NL_AUTH_SIGNATURE_set_SealAlgorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_SEAL_ALGORITHM")
	},
	{
		.name = discard_const_p(char, "Pad"),
		.get = py_NL_AUTH_SIGNATURE_get_Pad,
		.set = py_NL_AUTH_SIGNATURE_set_Pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_NL_AUTH_SIGNATURE_get_Flags,
		.set = py_NL_AUTH_SIGNATURE_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "SequenceNumber"),
		.get = py_NL_AUTH_SIGNATURE_get_SequenceNumber,
		.set = py_NL_AUTH_SIGNATURE_set_SequenceNumber,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Checksum"),
		.get = py_NL_AUTH_SIGNATURE_get_Checksum,
		.set = py_NL_AUTH_SIGNATURE_set_Checksum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Confounder"),
		.get = py_NL_AUTH_SIGNATURE_get_Confounder,
		.set = py_NL_AUTH_SIGNATURE_set_Confounder,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_NL_AUTH_SIGNATURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_AUTH_SIGNATURE, type);
}

static PyObject *py_NL_AUTH_SIGNATURE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NL_AUTH_SIGNATURE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NL_AUTH_SIGNATURE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SIGNATURE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SIGNATURE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_AUTH_SIGNATURE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_SIGNATURE, "NL_AUTH_SIGNATURE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_SIGNATURE, "NL_AUTH_SIGNATURE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_AUTH_SIGNATURE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_AUTH_SIGNATURE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_SIGNATURE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_SIGNATURE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_AUTH_SIGNATURE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.NL_AUTH_SIGNATURE",
	.tp_getset = py_NL_AUTH_SIGNATURE_getsetters,
	.tp_methods = py_NL_AUTH_SIGNATURE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_AUTH_SIGNATURE_new,
};


static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_SignatureAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_SignatureAlgorithm;
	py_SignatureAlgorithm = PyLong_FromLong((uint16_t)(object->SignatureAlgorithm));
	return py_SignatureAlgorithm;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_SignatureAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SignatureAlgorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SignatureAlgorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SignatureAlgorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_SealAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_SealAlgorithm;
	py_SealAlgorithm = PyLong_FromLong((uint16_t)(object->SealAlgorithm));
	return py_SealAlgorithm;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_SealAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SealAlgorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SealAlgorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SealAlgorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Pad(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Pad;
	py_Pad = PyLong_FromLong((uint16_t)(object->Pad));
	return py_Pad;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Flags(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromLong((uint16_t)(object->Flags));
	return py_Flags;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_SequenceNumber(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_SequenceNumber;
	py_SequenceNumber = PyList_New(8);
	if (py_SequenceNumber == NULL) {
		return NULL;
	}
	{
		int SequenceNumber_cntr_0;
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < (8); SequenceNumber_cntr_0++) {
			PyObject *py_SequenceNumber_0;
			py_SequenceNumber_0 = PyLong_FromLong((uint16_t)((object->SequenceNumber)[SequenceNumber_cntr_0]));
			PyList_SetItem(py_SequenceNumber, SequenceNumber_cntr_0, py_SequenceNumber_0);
		}
	}
	return py_SequenceNumber;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_SequenceNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SequenceNumber");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int SequenceNumber_cntr_0;
		if (ARRAY_SIZE(object->SequenceNumber) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->SequenceNumber),  PyList_GET_SIZE(value));
			return -1;
		}
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < PyList_GET_SIZE(value); SequenceNumber_cntr_0++) {
			if (PyList_GET_ITEM(value, SequenceNumber_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->SequenceNumber)[SequenceNumber_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->SequenceNumber)[SequenceNumber_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, SequenceNumber_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, SequenceNumber_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->SequenceNumber)[SequenceNumber_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Checksum(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyList_New(32);
	if (py_Checksum == NULL) {
		return NULL;
	}
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < (32); Checksum_cntr_0++) {
			PyObject *py_Checksum_0;
			py_Checksum_0 = PyLong_FromLong((uint16_t)((object->Checksum)[Checksum_cntr_0]));
			PyList_SetItem(py_Checksum, Checksum_cntr_0, py_Checksum_0);
		}
	}
	return py_Checksum;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Checksum");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Checksum_cntr_0;
		if (ARRAY_SIZE(object->Checksum) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Checksum),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < PyList_GET_SIZE(value); Checksum_cntr_0++) {
			if (PyList_GET_ITEM(value, Checksum_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Checksum)[Checksum_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Checksum)[Checksum_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Checksum_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Checksum_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Checksum)[Checksum_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Confounder(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(obj);
	PyObject *py_Confounder;
	py_Confounder = PyList_New(8);
	if (py_Confounder == NULL) {
		return NULL;
	}
	{
		int Confounder_cntr_0;
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < (8); Confounder_cntr_0++) {
			PyObject *py_Confounder_0;
			py_Confounder_0 = PyLong_FromLong((uint16_t)((object->Confounder)[Confounder_cntr_0]));
			PyList_SetItem(py_Confounder, Confounder_cntr_0, py_Confounder_0);
		}
	}
	return py_Confounder;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Confounder(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Confounder");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Confounder_cntr_0;
		if (ARRAY_SIZE(object->Confounder) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Confounder),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < PyList_GET_SIZE(value); Confounder_cntr_0++) {
			if (PyList_GET_ITEM(value, Confounder_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Confounder)[Confounder_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Confounder)[Confounder_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Confounder_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Confounder_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Confounder)[Confounder_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_NL_AUTH_SHA2_SIGNATURE_getsetters[] = {
	{
		.name = discard_const_p(char, "SignatureAlgorithm"),
		.get = py_NL_AUTH_SHA2_SIGNATURE_get_SignatureAlgorithm,
		.set = py_NL_AUTH_SHA2_SIGNATURE_set_SignatureAlgorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_SIGNATURE_ALGORITHM")
	},
	{
		.name = discard_const_p(char, "SealAlgorithm"),
		.get = py_NL_AUTH_SHA2_SIGNATURE_get_SealAlgorithm,
		.set = py_NL_AUTH_SHA2_SIGNATURE_set_SealAlgorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_SEAL_ALGORITHM")
	},
	{
		.name = discard_const_p(char, "Pad"),
		.get = py_NL_AUTH_SHA2_SIGNATURE_get_Pad,
		.set = py_NL_AUTH_SHA2_SIGNATURE_set_Pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_NL_AUTH_SHA2_SIGNATURE_get_Flags,
		.set = py_NL_AUTH_SHA2_SIGNATURE_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "SequenceNumber"),
		.get = py_NL_AUTH_SHA2_SIGNATURE_get_SequenceNumber,
		.set = py_NL_AUTH_SHA2_SIGNATURE_set_SequenceNumber,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Checksum"),
		.get = py_NL_AUTH_SHA2_SIGNATURE_get_Checksum,
		.set = py_NL_AUTH_SHA2_SIGNATURE_set_Checksum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Confounder"),
		.get = py_NL_AUTH_SHA2_SIGNATURE_get_Confounder,
		.set = py_NL_AUTH_SHA2_SIGNATURE_set_Confounder,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_AUTH_SHA2_SIGNATURE, type);
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NL_AUTH_SHA2_SIGNATURE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SHA2_SIGNATURE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SHA2_SIGNATURE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_SHA2_SIGNATURE, "NL_AUTH_SHA2_SIGNATURE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_SHA2_SIGNATURE, "NL_AUTH_SHA2_SIGNATURE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_AUTH_SHA2_SIGNATURE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_AUTH_SHA2_SIGNATURE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_SHA2_SIGNATURE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NL_AUTH_SHA2_SIGNATURE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_AUTH_SHA2_SIGNATURE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "schannel.NL_AUTH_SHA2_SIGNATURE",
	.tp_getset = py_NL_AUTH_SHA2_SIGNATURE_getsetters,
	.tp_methods = py_NL_AUTH_SHA2_SIGNATURE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NL_AUTH_SHA2_SIGNATURE_new,
};

static PyMethodDef schannel_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "schannel",
	.m_doc = "schannel DCE/RPC",
	.m_size = -1,
	.m_methods = schannel_methods,
};
MODULE_INIT_FUNC(schannel)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_netlogon = NULL;
	PyObject *dep_samba_dcerpc_nbt = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_talloc = NULL;

	dep_samba_dcerpc_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_samba_dcerpc_netlogon == NULL)
		goto out;

	dep_samba_dcerpc_nbt = PyImport_ImportModule("samba.dcerpc.nbt");
	if (dep_samba_dcerpc_nbt == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	netr_Credential_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_Credential");
	if (netr_Credential_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	netlogon_creds_CredentialState_extra_info_Type.tp_base = BaseObject_Type;
	netlogon_creds_CredentialState_extra_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	netlogon_creds_CredentialState_Type.tp_base = BaseObject_Type;
	netlogon_creds_CredentialState_Type.tp_basicsize = pytalloc_BaseObject_size();

	netlogon_cache_entry_Type.tp_base = BaseObject_Type;
	netlogon_cache_entry_Type.tp_basicsize = pytalloc_BaseObject_size();

	NL_AUTH_MESSAGE_BUFFER_Type.tp_base = BaseObject_Type;
	NL_AUTH_MESSAGE_BUFFER_Type.tp_basicsize = pytalloc_BaseObject_size();

	NL_AUTH_MESSAGE_BUFFER_REPLY_Type.tp_base = BaseObject_Type;
	NL_AUTH_MESSAGE_BUFFER_REPLY_Type.tp_basicsize = pytalloc_BaseObject_size();

	NL_AUTH_MESSAGE_Type.tp_base = BaseObject_Type;
	NL_AUTH_MESSAGE_Type.tp_basicsize = pytalloc_BaseObject_size();

	NL_AUTH_SIGNATURE_Type.tp_base = BaseObject_Type;
	NL_AUTH_SIGNATURE_Type.tp_basicsize = pytalloc_BaseObject_size();

	NL_AUTH_SHA2_SIGNATURE_Type.tp_base = BaseObject_Type;
	NL_AUTH_SHA2_SIGNATURE_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&netlogon_creds_CredentialState_extra_info_Type) < 0)
		goto out;
	if (PyType_Ready(&netlogon_creds_CredentialState_Type) < 0)
		goto out;
	if (PyType_Ready(&netlogon_cache_entry_Type) < 0)
		goto out;
	if (PyType_Ready(&NL_AUTH_MESSAGE_BUFFER_Type) < 0)
		goto out;
	if (PyType_Ready(&NL_AUTH_MESSAGE_BUFFER_REPLY_Type) < 0)
		goto out;
	if (PyType_Ready(&NL_AUTH_MESSAGE_Type) < 0)
		goto out;
	if (PyType_Ready(&NL_AUTH_SIGNATURE_Type) < 0)
		goto out;
	if (PyType_Ready(&NL_AUTH_SHA2_SIGNATURE_Type) < 0)
		goto out;
#ifdef PY_NETLOGON_CREDS_CREDENTIALSTATE_EXTRA_INFO_PATCH
	PY_NETLOGON_CREDS_CREDENTIALSTATE_EXTRA_INFO_PATCH(&netlogon_creds_CredentialState_extra_info_Type);
#endif
#ifdef PY_NETLOGON_CREDS_CREDENTIALSTATE_PATCH
	PY_NETLOGON_CREDS_CREDENTIALSTATE_PATCH(&netlogon_creds_CredentialState_Type);
#endif
#ifdef PY_NETLOGON_CACHE_ENTRY_PATCH
	PY_NETLOGON_CACHE_ENTRY_PATCH(&netlogon_cache_entry_Type);
#endif
#ifdef PY_NL_AUTH_MESSAGE_BUFFER_PATCH
	PY_NL_AUTH_MESSAGE_BUFFER_PATCH(&NL_AUTH_MESSAGE_BUFFER_Type);
#endif
#ifdef PY_NL_AUTH_MESSAGE_BUFFER_REPLY_PATCH
	PY_NL_AUTH_MESSAGE_BUFFER_REPLY_PATCH(&NL_AUTH_MESSAGE_BUFFER_REPLY_Type);
#endif
#ifdef PY_NL_AUTH_MESSAGE_PATCH
	PY_NL_AUTH_MESSAGE_PATCH(&NL_AUTH_MESSAGE_Type);
#endif
#ifdef PY_NL_AUTH_SIGNATURE_PATCH
	PY_NL_AUTH_SIGNATURE_PATCH(&NL_AUTH_SIGNATURE_Type);
#endif
#ifdef PY_NL_AUTH_SHA2_SIGNATURE_PATCH
	PY_NL_AUTH_SHA2_SIGNATURE_PATCH(&NL_AUTH_SHA2_SIGNATURE_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "NL_AUTH_SIGNATURE_SIZE", PyLong_FromUnsignedLongLong(0x20));
	PyModule_AddObject(m, "NL_NEGOTIATE_REQUEST", PyLong_FromUnsignedLongLong((uint32_t)(NL_NEGOTIATE_REQUEST)));
	PyModule_AddObject(m, "NL_NEGOTIATE_RESPONSE", PyLong_FromUnsignedLongLong((uint32_t)(NL_NEGOTIATE_RESPONSE)));
	PyModule_AddObject(m, "NL_FLAG_OEM_NETBIOS_DOMAIN_NAME", PyLong_FromUnsignedLongLong((uint32_t)(NL_FLAG_OEM_NETBIOS_DOMAIN_NAME)));
	PyModule_AddObject(m, "NL_FLAG_OEM_NETBIOS_COMPUTER_NAME", PyLong_FromUnsignedLongLong((uint32_t)(NL_FLAG_OEM_NETBIOS_COMPUTER_NAME)));
	PyModule_AddObject(m, "NL_FLAG_UTF8_DNS_DOMAIN_NAME", PyLong_FromUnsignedLongLong((uint32_t)(NL_FLAG_UTF8_DNS_DOMAIN_NAME)));
	PyModule_AddObject(m, "NL_FLAG_UTF8_DNS_HOST_NAME", PyLong_FromUnsignedLongLong((uint32_t)(NL_FLAG_UTF8_DNS_HOST_NAME)));
	PyModule_AddObject(m, "NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME", PyLong_FromUnsignedLongLong((uint32_t)(NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME)));
	PyModule_AddObject(m, "NL_SIGN_HMAC_SHA256", PyLong_FromLong((uint16_t)(NL_SIGN_HMAC_SHA256)));
	PyModule_AddObject(m, "NL_SIGN_HMAC_MD5", PyLong_FromLong((uint16_t)(NL_SIGN_HMAC_MD5)));
	PyModule_AddObject(m, "NL_SEAL_AES128", PyLong_FromLong((uint16_t)(NL_SEAL_AES128)));
	PyModule_AddObject(m, "NL_SEAL_RC4", PyLong_FromLong((uint16_t)(NL_SEAL_RC4)));
	PyModule_AddObject(m, "NL_SEAL_NONE", PyLong_FromLong((uint16_t)(NL_SEAL_NONE)));
	Py_INCREF((PyObject *)(void *)&netlogon_creds_CredentialState_extra_info_Type);
	PyModule_AddObject(m, "netlogon_creds_CredentialState_extra_info", (PyObject *)(void *)&netlogon_creds_CredentialState_extra_info_Type);
	Py_INCREF((PyObject *)(void *)&netlogon_creds_CredentialState_Type);
	PyModule_AddObject(m, "netlogon_creds_CredentialState", (PyObject *)(void *)&netlogon_creds_CredentialState_Type);
	Py_INCREF((PyObject *)(void *)&netlogon_cache_entry_Type);
	PyModule_AddObject(m, "netlogon_cache_entry", (PyObject *)(void *)&netlogon_cache_entry_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_MESSAGE_BUFFER_Type);
	PyModule_AddObject(m, "NL_AUTH_MESSAGE_BUFFER", (PyObject *)(void *)&NL_AUTH_MESSAGE_BUFFER_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_MESSAGE_BUFFER_REPLY_Type);
	PyModule_AddObject(m, "NL_AUTH_MESSAGE_BUFFER_REPLY", (PyObject *)(void *)&NL_AUTH_MESSAGE_BUFFER_REPLY_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_MESSAGE_Type);
	PyModule_AddObject(m, "NL_AUTH_MESSAGE", (PyObject *)(void *)&NL_AUTH_MESSAGE_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_SIGNATURE_Type);
	PyModule_AddObject(m, "NL_AUTH_SIGNATURE", (PyObject *)(void *)&NL_AUTH_SIGNATURE_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_SHA2_SIGNATURE_Type);
	PyModule_AddObject(m, "NL_AUTH_SHA2_SIGNATURE", (PyObject *)(void *)&NL_AUTH_SHA2_SIGNATURE_Type);
#ifdef PY_MOD_SCHANNEL_PATCH
	PY_MOD_SCHANNEL_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_netlogon);
	Py_XDECREF(dep_samba_dcerpc_nbt);
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_talloc);
	return m;

}
