/* rygel-playspeed-request.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-playspeed-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_PLAY_SPEED_REQUEST_0_PROPERTY,
	RYGEL_PLAY_SPEED_REQUEST_SPEED_PROPERTY,
	RYGEL_PLAY_SPEED_REQUEST_NUM_PROPERTIES
};
static GParamSpec* rygel_play_speed_request_properties[RYGEL_PLAY_SPEED_REQUEST_NUM_PROPERTIES];
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;

struct _RygelPlaySpeedRequestPrivate {
	RygelPlaySpeed* _speed;
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

static gint RygelPlaySpeedRequest_private_offset;
static gpointer rygel_play_speed_request_parent_class = NULL;

VALA_EXTERN gboolean rygel_play_speed_request_requested (RygelHTTPGet* request);
static void rygel_play_speed_request_set_speed (RygelPlaySpeedRequest* self,
                                         RygelPlaySpeed* value);
VALA_EXTERN RygelPlaySpeedRequest* rygel_play_speed_request_new_from_request (RygelHTTPGet* request,
                                                                  GError** error);
VALA_EXTERN RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_request (GType object_type,
                                                                        RygelHTTPGet* request,
                                                                        GError** error);
VALA_EXTERN GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST ;
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static void rygel_play_speed_request_finalize (GObject * obj);
static GType rygel_play_speed_request_get_type_once (void);
static void _vala_rygel_play_speed_request_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_rygel_play_speed_request_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
rygel_play_speed_error_quark (void)
{
	return g_quark_from_static_string ("rygel-play-speed-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_play_speed_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, "RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT", "invalid-speed-format"}, {RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT, "RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT", "speed-not-present"}, {0, NULL, NULL}};
	GType rygel_play_speed_error_type_id;
	rygel_play_speed_error_type_id = g_enum_register_static ("RygelPlaySpeedError", values);
	return rygel_play_speed_error_type_id;
}

GType
rygel_play_speed_error_get_type (void)
{
	static volatile gsize rygel_play_speed_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_play_speed_error_type_id__once)) {
		GType rygel_play_speed_error_type_id;
		rygel_play_speed_error_type_id = rygel_play_speed_error_get_type_once ();
		g_once_init_leave (&rygel_play_speed_error_type_id__once, rygel_play_speed_error_type_id);
	}
	return rygel_play_speed_error_type_id__once;
}

static inline gpointer
rygel_play_speed_request_get_instance_private (RygelPlaySpeedRequest* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPlaySpeedRequest_private_offset);
}

/**
     * Return true if playspeed is supported
     *
     * This method utilizes elements associated with the request to determine
     * if a PlaySpeed request is supported for the given request/resource.
     */
gboolean
rygel_play_speed_request_supported (RygelHTTPGet* request)
{
	RygelHTTPGetHandler* _tmp0_;
	gboolean result;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request->handler;
	result = rygel_http_get_handler_supports_playspeed (_tmp0_);
	return result;
}

gboolean
rygel_play_speed_request_requested (RygelHTTPGet* request)
{
	SoupServerMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = ((RygelHTTPRequest*) request)->msg;
	_tmp1_ = soup_server_message_get_request_headers (_tmp0_);
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
	result = _tmp2_ != NULL;
	return result;
}

RygelPlaySpeedRequest*
rygel_play_speed_request_construct (GType object_type,
                                    gint numerator,
                                    guint denominator)
{
	RygelPlaySpeedRequest * self = NULL;
	RygelPlaySpeed* _tmp0_;
	RygelPlaySpeed* _tmp1_;
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_play_speed_new (numerator, denominator);
	_tmp1_ = _tmp0_;
	rygel_play_speed_request_set_speed (self, _tmp1_);
	_rygel_play_speed_unref0 (_tmp1_);
	return self;
}

RygelPlaySpeedRequest*
rygel_play_speed_request_new (gint numerator,
                              guint denominator)
{
	return rygel_play_speed_request_construct (RYGEL_TYPE_PLAY_SPEED_REQUEST, numerator, denominator);
}

RygelPlaySpeedRequest*
rygel_play_speed_request_construct_from_string (GType object_type,
                                                const gchar* speed,
                                                GError** error)
{
	RygelPlaySpeedRequest * self = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
	_tmp1_ = rygel_play_speed_new_from_string (speed, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	rygel_play_speed_request_set_speed (self, _tmp0_);
	_rygel_play_speed_unref0 (_tmp0_);
	return self;
}

RygelPlaySpeedRequest*
rygel_play_speed_request_new_from_string (const gchar* speed,
                                          GError** error)
{
	return rygel_play_speed_request_construct_from_string (RYGEL_TYPE_PLAY_SPEED_REQUEST, speed, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

RygelPlaySpeedRequest*
rygel_play_speed_request_construct_from_request (GType object_type,
                                                 RygelHTTPGet* request,
                                                 GError** error)
{
	RygelPlaySpeedRequest * self = NULL;
	gchar* speed_string = NULL;
	SoupServerMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** elements = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint elements_length1;
	gint _elements_size_;
	gboolean _tmp11_ = FALSE;
	gchar** _tmp12_;
	gint _tmp12__length1;
	RygelPlaySpeed* _tmp19_ = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	RygelPlaySpeed* _tmp22_;
	RygelPlaySpeed* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
	_tmp0_ = ((RygelHTTPRequest*) request)->msg;
	_tmp1_ = soup_server_message_get_request_headers (_tmp0_);
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
	_tmp3_ = g_strdup (_tmp2_);
	speed_string = _tmp3_;
	_tmp4_ = speed_string;
	if (_tmp4_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		_tmp5_ = g_strdup ("Could not find playspeed header %s");
		msg = _tmp5_;
		_tmp6_ = msg;
		_tmp7_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT, _tmp6_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			_g_free0 (speed_string);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			_g_free0 (speed_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp8_ = speed_string;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 0);
	elements = _tmp10_;
	elements_length1 = _vala_array_length (_tmp9_);
	_elements_size_ = elements_length1;
	_tmp12_ = elements;
	_tmp12__length1 = elements_length1;
	if (_tmp12__length1 != 2) {
		_tmp11_ = TRUE;
	} else {
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		_tmp13_ = elements;
		_tmp13__length1 = elements_length1;
		_tmp14_ = _tmp13_[0];
		_tmp11_ = g_strcmp0 (_tmp14_, "speed") != 0;
	}
	if (_tmp11_) {
		gchar* msg = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
		_tmp15_ = g_strdup ("Ill-formed value for header %s: %s");
		msg = _tmp15_;
		_tmp16_ = msg;
		_tmp17_ = speed_string;
		_tmp18_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp16_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER, _tmp17_);
		_inner_error0_ = _tmp18_;
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp20_ = elements;
	_tmp20__length1 = elements_length1;
	_tmp21_ = _tmp20_[1];
	_tmp22_ = rygel_play_speed_new_from_string (_tmp21_, &_inner_error0_);
	_tmp19_ = _tmp22_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			_g_object_unref0 (self);
			return NULL;
		} else {
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	rygel_play_speed_request_set_speed (self, _tmp19_);
	_tmp23_ = self->priv->_speed;
	if (!rygel_play_speed_is_normal_rate (_tmp23_)) {
		RygelHTTPMediaResourceHandler* resource_handler = NULL;
		RygelHTTPGetHandler* _tmp24_;
		RygelHTTPMediaResourceHandler* _tmp25_;
		RygelHTTPMediaResourceHandler* _tmp26_;
		_tmp24_ = request->handler;
		_tmp25_ = _g_object_ref0 (RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER (_tmp24_) ? ((RygelHTTPMediaResourceHandler*) _tmp24_) : NULL);
		resource_handler = _tmp25_;
		_tmp26_ = resource_handler;
		if (_tmp26_ != NULL) {
			RygelMediaResource* resource = NULL;
			RygelHTTPMediaResourceHandler* _tmp27_;
			RygelMediaResource* _tmp28_;
			RygelMediaResource* _tmp29_;
			gchar** speeds = NULL;
			RygelMediaResource* _tmp30_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			gchar** _tmp32_;
			gint _tmp32__length1;
			gint speeds_length1;
			gint _speeds_size_;
			gboolean found_speed = FALSE;
			gchar** _tmp33_;
			gint _tmp33__length1;
			_tmp27_ = resource_handler;
			_tmp28_ = _tmp27_->media_resource;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			resource = _tmp29_;
			_tmp30_ = resource;
			_tmp31_ = _tmp30_->play_speeds;
			_tmp31__length1 = _tmp30_->play_speeds_length1;
			_tmp32_ = (_tmp31_ != NULL) ? _vala_array_dup8 (_tmp31_, _tmp31__length1) : _tmp31_;
			_tmp32__length1 = _tmp31__length1;
			speeds = _tmp32_;
			speeds_length1 = _tmp32__length1;
			_speeds_size_ = speeds_length1;
			found_speed = FALSE;
			_tmp33_ = speeds;
			_tmp33__length1 = speeds_length1;
			{
				gchar** speed_collection = NULL;
				gint speed_collection_length1 = 0;
				gint _speed_collection_size_ = 0;
				gint speed_it = 0;
				speed_collection = _tmp33_;
				speed_collection_length1 = _tmp33__length1;
				for (speed_it = 0; speed_it < speed_collection_length1; speed_it = speed_it + 1) {
					gchar* _tmp34_;
					gchar* speed = NULL;
					_tmp34_ = g_strdup (speed_collection[speed_it]);
					speed = _tmp34_;
					{
						RygelPlaySpeedRequest* cur_speed = NULL;
						const gchar* _tmp35_;
						RygelPlaySpeedRequest* _tmp36_;
						RygelPlaySpeedRequest* _tmp37_;
						_tmp35_ = speed;
						_tmp36_ = rygel_play_speed_request_new_from_string (_tmp35_, &_inner_error0_);
						cur_speed = _tmp36_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_free0 (speed);
								speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (resource);
								_g_object_unref0 (resource_handler);
								_rygel_play_speed_unref0 (_tmp19_);
								elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (speed_string);
								_g_object_unref0 (self);
								return NULL;
							} else {
								_g_free0 (speed);
								speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (resource);
								_g_object_unref0 (resource_handler);
								_rygel_play_speed_unref0 (_tmp19_);
								elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (speed_string);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp37_ = cur_speed;
						if (rygel_play_speed_request_equals (self, _tmp37_)) {
							found_speed = TRUE;
							_g_object_unref0 (cur_speed);
							_g_free0 (speed);
							break;
						}
						_g_object_unref0 (cur_speed);
						_g_free0 (speed);
					}
				}
			}
			if (!found_speed) {
				const gchar* _tmp38_;
				GError* _tmp39_;
				_tmp38_ = speed_string;
				_tmp39_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT, "Unknown playspeed requested (%s)", _tmp38_);
				_inner_error0_ = _tmp39_;
				if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
					g_propagate_error (error, _inner_error0_);
					speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (resource);
					_g_object_unref0 (resource_handler);
					_rygel_play_speed_unref0 (_tmp19_);
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (speed_string);
					_g_object_unref0 (self);
					return NULL;
				} else {
					speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (resource);
					_g_object_unref0 (resource_handler);
					_rygel_play_speed_unref0 (_tmp19_);
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (speed_string);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource);
		}
		_g_object_unref0 (resource_handler);
	}
	_rygel_play_speed_unref0 (_tmp19_);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (speed_string);
	return self;
}

RygelPlaySpeedRequest*
rygel_play_speed_request_new_from_request (RygelHTTPGet* request,
                                           GError** error)
{
	return rygel_play_speed_request_construct_from_request (RYGEL_TYPE_PLAY_SPEED_REQUEST, request, error);
}

gboolean
rygel_play_speed_request_equals (RygelPlaySpeedRequest* self,
                                 RygelPlaySpeedRequest* that)
{
	RygelPlaySpeed* _tmp0_;
	RygelPlaySpeed* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (that != NULL, FALSE);
	if (that == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->_speed;
	_tmp1_ = that->priv->_speed;
	result = rygel_play_speed_equals (_tmp0_, _tmp1_);
	return result;
}

RygelPlaySpeed*
rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self)
{
	RygelPlaySpeed* result;
	RygelPlaySpeed* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_speed;
	result = _tmp0_;
	return result;
}

static gpointer
_rygel_play_speed_ref0 (gpointer self)
{
	return self ? rygel_play_speed_ref (self) : NULL;
}

static void
rygel_play_speed_request_set_speed (RygelPlaySpeedRequest* self,
                                    RygelPlaySpeed* value)
{
	RygelPlaySpeed* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_play_speed_request_get_speed (self);
	if (old_value != value) {
		RygelPlaySpeed* _tmp0_;
		_tmp0_ = _rygel_play_speed_ref0 (value);
		_rygel_play_speed_unref0 (self->priv->_speed);
		self->priv->_speed = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_play_speed_request_properties[RYGEL_PLAY_SPEED_REQUEST_SPEED_PROPERTY]);
	}
}

static void
rygel_play_speed_request_class_init (RygelPlaySpeedRequestClass * klass,
                                     gpointer klass_data)
{
	rygel_play_speed_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPlaySpeedRequest_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_play_speed_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_play_speed_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_play_speed_request_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAY_SPEED_REQUEST_SPEED_PROPERTY, rygel_play_speed_request_properties[RYGEL_PLAY_SPEED_REQUEST_SPEED_PROPERTY] = rygel_param_spec_play_speed ("speed", "speed", "speed", RYGEL_TYPE_PLAY_SPEED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_play_speed_request_instance_init (RygelPlaySpeedRequest * self,
                                        gpointer klass)
{
	self->priv = rygel_play_speed_request_get_instance_private (self);
}

static void
rygel_play_speed_request_finalize (GObject * obj)
{
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
	_rygel_play_speed_unref0 (self->priv->_speed);
	G_OBJECT_CLASS (rygel_play_speed_request_parent_class)->finalize (obj);
}

/**
 * This class represents a DLNA PlaySpeed request (PlaySpeed.dlna.org)
 */
 G_GNUC_NO_INLINE static GType
rygel_play_speed_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeedRequest), 0, (GInstanceInitFunc) rygel_play_speed_request_instance_init, NULL };
	GType rygel_play_speed_request_type_id;
	rygel_play_speed_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaySpeedRequest", &g_define_type_info, 0);
	RygelPlaySpeedRequest_private_offset = g_type_add_instance_private (rygel_play_speed_request_type_id, sizeof (RygelPlaySpeedRequestPrivate));
	return rygel_play_speed_request_type_id;
}

GType
rygel_play_speed_request_get_type (void)
{
	static volatile gsize rygel_play_speed_request_type_id__once = 0;
	if (g_once_init_enter (&rygel_play_speed_request_type_id__once)) {
		GType rygel_play_speed_request_type_id;
		rygel_play_speed_request_type_id = rygel_play_speed_request_get_type_once ();
		g_once_init_leave (&rygel_play_speed_request_type_id__once, rygel_play_speed_request_type_id);
	}
	return rygel_play_speed_request_type_id__once;
}

static void
_vala_rygel_play_speed_request_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
	switch (property_id) {
		case RYGEL_PLAY_SPEED_REQUEST_SPEED_PROPERTY:
		rygel_value_set_play_speed (value, rygel_play_speed_request_get_speed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_play_speed_request_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
	switch (property_id) {
		case RYGEL_PLAY_SPEED_REQUEST_SPEED_PROPERTY:
		rygel_play_speed_request_set_speed (self, rygel_value_get_play_speed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

