/* rygel-engine-loader.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-engine-loader.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <glib-object.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gmodule.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_ENGINE_LOADER (rygel_engine_loader_get_type ())
#define RYGEL_ENGINE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoader))
#define RYGEL_ENGINE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoaderClass))
#define RYGEL_IS_ENGINE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENGINE_LOADER))
#define RYGEL_IS_ENGINE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENGINE_LOADER))
#define RYGEL_ENGINE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoaderClass))

typedef struct _RygelEngineLoader RygelEngineLoader;
typedef struct _RygelEngineLoaderClass RygelEngineLoaderClass;
typedef struct _RygelEngineLoaderPrivate RygelEngineLoaderPrivate;
enum  {
	RYGEL_ENGINE_LOADER_0_PROPERTY,
	RYGEL_ENGINE_LOADER_NUM_PROPERTIES
};
static GParamSpec* rygel_engine_loader_properties[RYGEL_ENGINE_LOADER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef RygelMediaEngine* (*RygelEngineLoaderModuleInstanceFunc) (gpointer user_data);

struct _RygelEngineLoader {
	RygelRecursiveModuleLoader parent_instance;
	RygelEngineLoaderPrivate * priv;
};

struct _RygelEngineLoaderClass {
	RygelRecursiveModuleLoaderClass parent_class;
};

struct _RygelEngineLoaderPrivate {
	RygelMediaEngine* instance;
	gchar* engine_name;
};

static gint RygelEngineLoader_private_offset;
static gpointer rygel_engine_loader_parent_class = NULL;

VALA_EXTERN GType rygel_engine_loader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelEngineLoader* rygel_engine_loader_new (void);
VALA_EXTERN RygelEngineLoader* rygel_engine_loader_construct (GType object_type);
static gchar* rygel_engine_loader_get_config (void);
static void rygel_engine_loader_real_constructed (GObject* base);
VALA_EXTERN RygelMediaEngine* rygel_engine_loader_load_engine (RygelEngineLoader* self);
static gboolean rygel_engine_loader_real_load_module_from_file (RygelRecursiveModuleLoader* base,
                                                         GFile* file);
static gboolean rygel_engine_loader_real_load_module_from_info (RygelRecursiveModuleLoader* base,
                                                         RygelPluginInformation* info);
static void rygel_engine_loader_finalize (GObject * obj);
static GType rygel_engine_loader_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_engine_loader_get_instance_private (RygelEngineLoader* self)
{
	return G_STRUCT_MEMBER_P (self, RygelEngineLoader_private_offset);
}

RygelEngineLoader*
rygel_engine_loader_construct (GType object_type)
{
	RygelEngineLoader * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = rygel_engine_loader_get_config ();
	_tmp1_ = _tmp0_;
	self = (RygelEngineLoader*) g_object_new (object_type, "base-path", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	return self;
}

RygelEngineLoader*
rygel_engine_loader_new (void)
{
	return rygel_engine_loader_construct (RYGEL_TYPE_ENGINE_LOADER);
}

static void
rygel_engine_loader_real_constructed (GObject* base)
{
	RygelEngineLoader * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (RygelEngineLoader*) base;
	G_OBJECT_CLASS (rygel_engine_loader_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader));
	_tmp0_ = rygel_recursive_module_loader_get_base_path ((RygelRecursiveModuleLoader*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = rygel_engine_loader_get_config ();
		_tmp3_ = _tmp2_;
		rygel_recursive_module_loader_set_base_path ((RygelRecursiveModuleLoader*) self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = rygel_meta_config_get_default ();
		config = _tmp4_;
		_tmp6_ = rygel_configuration_get_media_engine ((RygelConfiguration*) config, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (self->priv->engine_name);
		self->priv->engine_name = _tmp7_;
		_tmp8_ = self->priv->engine_name;
		g_debug ("rygel-engine-loader.vala:45: Looking for specific engine named '%s", _tmp8_);
		_g_free0 (_tmp5_);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * Load a media engine.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMediaEngine*
rygel_engine_loader_load_engine (RygelEngineLoader* self)
{
	RygelMediaEngine* _tmp0_;
	RygelMediaEngine* _tmp1_;
	RygelMediaEngine* result;
	g_return_val_if_fail (self != NULL, NULL);
	rygel_recursive_module_loader_load_modules_sync ((RygelRecursiveModuleLoader*) self, NULL);
	_tmp0_ = self->priv->instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
rygel_engine_loader_real_load_module_from_file (RygelRecursiveModuleLoader* base,
                                                GFile* file)
{
	RygelEngineLoader * self;
	const gchar* _tmp0_;
	GModule* module = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GModule* _tmp7_;
	GModule* _tmp8_;
	GModule* _tmp9_;
	void* function = NULL;
	GModule* _tmp14_;
	void* _tmp15_ = NULL;
	gboolean _tmp16_;
	RygelEngineLoaderModuleInstanceFunc get_instance = NULL;
	void* _tmp18_;
	gpointer get_instance_target;
	GModule* _tmp19_;
	RygelEngineLoaderModuleInstanceFunc _tmp20_;
	gpointer _tmp20__target;
	RygelMediaEngine* _tmp21_;
	gboolean result;
	self = (RygelEngineLoader*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->engine_name;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = g_file_get_basename (file);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->engine_name;
		_tmp4_ = g_strcmp0 (_tmp2_, _tmp3_) != 0;
		_g_free0 (_tmp2_);
		if (_tmp4_) {
			result = TRUE;
			return result;
		}
	}
	_tmp5_ = g_file_get_path (file);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_module_open (_tmp6_, G_MODULE_BIND_LOCAL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	module = _tmp8_;
	_tmp9_ = module;
	if (_tmp9_ == NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = g_file_get_path (file);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_module_error ();
		g_debug ("rygel-engine-loader.vala:72: Failed to load engine %s: %s", _tmp11_, _tmp12_);
		_g_free0 (_tmp11_);
		_tmp13_ = self->priv->engine_name;
		if (_tmp13_ != NULL) {
			result = FALSE;
			_g_module_close0 (module);
			return result;
		}
		result = TRUE;
		_g_module_close0 (module);
		return result;
	}
	_tmp14_ = module;
	_tmp16_ = g_module_symbol (_tmp14_, "module_get_instance", &_tmp15_);
	function = _tmp15_;
	if (!_tmp16_) {
		const gchar* _tmp17_;
		_tmp17_ = self->priv->engine_name;
		if (_tmp17_ != NULL) {
			result = FALSE;
			_g_module_close0 (module);
			return result;
		}
		result = TRUE;
		_g_module_close0 (module);
		return result;
	}
	_tmp18_ = function;
	get_instance = (RygelEngineLoaderModuleInstanceFunc) _tmp18_;
	get_instance_target = NULL;
	_tmp19_ = module;
	g_module_make_resident (_tmp19_);
	_tmp20_ = get_instance;
	_tmp20__target = get_instance_target;
	_tmp21_ = _tmp20_ (_tmp20__target);
	_g_object_unref0 (self->priv->instance);
	self->priv->instance = _tmp21_;
	result = FALSE;
	_g_module_close0 (module);
	return result;
}

static gboolean
rygel_engine_loader_real_load_module_from_info (RygelRecursiveModuleLoader* base,
                                                RygelPluginInformation* info)
{
	RygelEngineLoader * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	self = (RygelEngineLoader*) base;
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp0_ = rygel_plugin_information_get_module_path (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_recursive_module_loader_load_module_from_file ((RygelRecursiveModuleLoader*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static gchar*
rygel_engine_loader_get_config (void)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_strdup (ENGINE_DIR);
	path = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	{
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = rygel_configuration_get_engine_path ((RygelConfiguration*) config, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (path);
		path = _tmp4_;
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = path;
	_g_object_unref0 (config);
	return result;
}

static void
rygel_engine_loader_class_init (RygelEngineLoaderClass * klass,
                                gpointer klass_data)
{
	rygel_engine_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelEngineLoader_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_engine_loader_real_constructed;
	((RygelRecursiveModuleLoaderClass *) klass)->load_module_from_file = (gboolean (*) (RygelRecursiveModuleLoader*, GFile*)) rygel_engine_loader_real_load_module_from_file;
	((RygelRecursiveModuleLoaderClass *) klass)->load_module_from_info = (gboolean (*) (RygelRecursiveModuleLoader*, RygelPluginInformation*)) rygel_engine_loader_real_load_module_from_info;
	G_OBJECT_CLASS (klass)->finalize = rygel_engine_loader_finalize;
}

static void
rygel_engine_loader_instance_init (RygelEngineLoader * self,
                                   gpointer klass)
{
	self->priv = rygel_engine_loader_get_instance_private (self);
}

static void
rygel_engine_loader_finalize (GObject * obj)
{
	RygelEngineLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoader);
	_g_object_unref0 (self->priv->instance);
	_g_free0 (self->priv->engine_name);
	G_OBJECT_CLASS (rygel_engine_loader_parent_class)->finalize (obj);
}

/**
 * Load a media engine.
 */
 G_GNUC_NO_INLINE static GType
rygel_engine_loader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelEngineLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_engine_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelEngineLoader), 0, (GInstanceInitFunc) rygel_engine_loader_instance_init, NULL };
	GType rygel_engine_loader_type_id;
	rygel_engine_loader_type_id = g_type_register_static (RYGEL_TYPE_RECURSIVE_MODULE_LOADER, "RygelEngineLoader", &g_define_type_info, 0);
	RygelEngineLoader_private_offset = g_type_add_instance_private (rygel_engine_loader_type_id, sizeof (RygelEngineLoaderPrivate));
	return rygel_engine_loader_type_id;
}

GType
rygel_engine_loader_get_type (void)
{
	static volatile gsize rygel_engine_loader_type_id__once = 0;
	if (g_once_init_enter (&rygel_engine_loader_type_id__once)) {
		GType rygel_engine_loader_type_id;
		rygel_engine_loader_type_id = rygel_engine_loader_get_type_once ();
		g_once_init_leave (&rygel_engine_loader_type_id__once, rygel_engine_loader_type_id);
	}
	return rygel_engine_loader_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

