// Copyright (C) 2021 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

// This file is automatically generated by qvkgen. Do not edit.

#include "qvulkanfunctions_p.h"
#include "qvulkaninstance.h"

#include <QtCore/private/qoffsetstringarray_p.h>

QT_BEGIN_NAMESPACE


#if VK_VERSION_1_0
VkResult QVulkanFunctions::vkEnumeratePhysicalDevices(VkInstance instance, uint32_t *pPhysicalDeviceCount, VkPhysicalDevice *pPhysicalDevices)
{
    Q_ASSERT(d_ptr->m_funcs[0]);
    return reinterpret_cast<PFN_vkEnumeratePhysicalDevices>(d_ptr->m_funcs[0])(instance, pPhysicalDeviceCount, pPhysicalDevices);
}

PFN_vkVoidFunction QVulkanFunctions::vkGetDeviceProcAddr(VkDevice device, const char *pName)
{
    Q_ASSERT(d_ptr->m_funcs[1]);
    return reinterpret_cast<PFN_vkGetDeviceProcAddr>(d_ptr->m_funcs[1])(device, pName);
}

void QVulkanFunctions::vkGetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[2]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceProperties>(d_ptr->m_funcs[2])(physicalDevice, pProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t *pQueueFamilyPropertyCount, VkQueueFamilyProperties *pQueueFamilyProperties)
{
    Q_ASSERT(d_ptr->m_funcs[3]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyProperties>(d_ptr->m_funcs[3])(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties *pMemoryProperties)
{
    Q_ASSERT(d_ptr->m_funcs[4]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceMemoryProperties>(d_ptr->m_funcs[4])(physicalDevice, pMemoryProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures *pFeatures)
{
    Q_ASSERT(d_ptr->m_funcs[5]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceFeatures>(d_ptr->m_funcs[5])(physicalDevice, pFeatures);
}

void QVulkanFunctions::vkGetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties *pFormatProperties)
{
    Q_ASSERT(d_ptr->m_funcs[6]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceFormatProperties>(d_ptr->m_funcs[6])(physicalDevice, format, pFormatProperties);
}

VkResult QVulkanFunctions::vkGetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties *pImageFormatProperties)
{
    Q_ASSERT(d_ptr->m_funcs[7]);
    return reinterpret_cast<PFN_vkGetPhysicalDeviceImageFormatProperties>(d_ptr->m_funcs[7])(physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
}

VkResult QVulkanFunctions::vkCreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkDevice *pDevice)
{
    Q_ASSERT(d_ptr->m_funcs[8]);
    return reinterpret_cast<PFN_vkCreateDevice>(d_ptr->m_funcs[8])(physicalDevice, pCreateInfo, pAllocator, pDevice);
}

VkResult QVulkanFunctions::vkEnumerateInstanceLayerProperties(uint32_t *pPropertyCount, VkLayerProperties *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[9]);
    return reinterpret_cast<PFN_vkEnumerateInstanceLayerProperties>(d_ptr->m_funcs[9])(pPropertyCount, pProperties);
}

VkResult QVulkanFunctions::vkEnumerateInstanceExtensionProperties(const char *pLayerName, uint32_t *pPropertyCount, VkExtensionProperties *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[10]);
    return reinterpret_cast<PFN_vkEnumerateInstanceExtensionProperties>(d_ptr->m_funcs[10])(pLayerName, pPropertyCount, pProperties);
}

VkResult QVulkanFunctions::vkEnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t *pPropertyCount, VkLayerProperties *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[11]);
    return reinterpret_cast<PFN_vkEnumerateDeviceLayerProperties>(d_ptr->m_funcs[11])(physicalDevice, pPropertyCount, pProperties);
}

VkResult QVulkanFunctions::vkEnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char *pLayerName, uint32_t *pPropertyCount, VkExtensionProperties *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[12]);
    return reinterpret_cast<PFN_vkEnumerateDeviceExtensionProperties>(d_ptr->m_funcs[12])(physicalDevice, pLayerName, pPropertyCount, pProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t *pPropertyCount, VkSparseImageFormatProperties *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[13]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceSparseImageFormatProperties>(d_ptr->m_funcs[13])(physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
}

#endif


#if VK_VERSION_1_1
void QVulkanFunctions::vkGetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2 *pFeatures)
{
    Q_ASSERT(d_ptr->m_funcs[14]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceFeatures2>(d_ptr->m_funcs[14])(physicalDevice, pFeatures);
}

void QVulkanFunctions::vkGetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2 *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[15]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceProperties2>(d_ptr->m_funcs[15])(physicalDevice, pProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2 *pFormatProperties)
{
    Q_ASSERT(d_ptr->m_funcs[16]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceFormatProperties2>(d_ptr->m_funcs[16])(physicalDevice, format, pFormatProperties);
}

VkResult QVulkanFunctions::vkGetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2 *pImageFormatInfo, VkImageFormatProperties2 *pImageFormatProperties)
{
    Q_ASSERT(d_ptr->m_funcs[17]);
    return reinterpret_cast<PFN_vkGetPhysicalDeviceImageFormatProperties2>(d_ptr->m_funcs[17])(physicalDevice, pImageFormatInfo, pImageFormatProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t *pQueueFamilyPropertyCount, VkQueueFamilyProperties2 *pQueueFamilyProperties)
{
    Q_ASSERT(d_ptr->m_funcs[18]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyProperties2>(d_ptr->m_funcs[18])(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2 *pMemoryProperties)
{
    Q_ASSERT(d_ptr->m_funcs[19]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceMemoryProperties2>(d_ptr->m_funcs[19])(physicalDevice, pMemoryProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2 *pFormatInfo, uint32_t *pPropertyCount, VkSparseImageFormatProperties2 *pProperties)
{
    Q_ASSERT(d_ptr->m_funcs[20]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceSparseImageFormatProperties2>(d_ptr->m_funcs[20])(physicalDevice, pFormatInfo, pPropertyCount, pProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo *pExternalBufferInfo, VkExternalBufferProperties *pExternalBufferProperties)
{
    Q_ASSERT(d_ptr->m_funcs[21]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceExternalBufferProperties>(d_ptr->m_funcs[21])(physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo *pExternalSemaphoreInfo, VkExternalSemaphoreProperties *pExternalSemaphoreProperties)
{
    Q_ASSERT(d_ptr->m_funcs[22]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceExternalSemaphoreProperties>(d_ptr->m_funcs[22])(physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
}

void QVulkanFunctions::vkGetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo *pExternalFenceInfo, VkExternalFenceProperties *pExternalFenceProperties)
{
    Q_ASSERT(d_ptr->m_funcs[23]);
    reinterpret_cast<PFN_vkGetPhysicalDeviceExternalFenceProperties>(d_ptr->m_funcs[23])(physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
}

VkResult QVulkanFunctions::vkEnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t *pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties *pPhysicalDeviceGroupProperties)
{
    Q_ASSERT(d_ptr->m_funcs[24]);
    return reinterpret_cast<PFN_vkEnumeratePhysicalDeviceGroups>(d_ptr->m_funcs[24])(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
}

#endif


#if VK_VERSION_1_2
#endif


#if VK_VERSION_1_3
VkResult QVulkanFunctions::vkGetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t *pToolCount, VkPhysicalDeviceToolProperties *pToolProperties)
{
    Q_ASSERT(d_ptr->m_funcs[25]);
    return reinterpret_cast<PFN_vkGetPhysicalDeviceToolProperties>(d_ptr->m_funcs[25])(physicalDevice, pToolCount, pToolProperties);
}

#endif


#if VK_VERSION_1_4
#endif

QVulkanFunctionsPrivate::QVulkanFunctionsPrivate(QVulkanInstance *inst)
{
    static constexpr auto funcNames = qOffsetStringArray(
        "vkEnumeratePhysicalDevices",
        "vkGetDeviceProcAddr",
        "vkGetPhysicalDeviceProperties",
        "vkGetPhysicalDeviceQueueFamilyProperties",
        "vkGetPhysicalDeviceMemoryProperties",
        "vkGetPhysicalDeviceFeatures",
        "vkGetPhysicalDeviceFormatProperties",
        "vkGetPhysicalDeviceImageFormatProperties",
        "vkCreateDevice",
        "vkEnumerateInstanceLayerProperties",
        "vkEnumerateInstanceExtensionProperties",
        "vkEnumerateDeviceLayerProperties",
        "vkEnumerateDeviceExtensionProperties",
        "vkGetPhysicalDeviceSparseImageFormatProperties",
        "vkGetPhysicalDeviceFeatures2",
        "vkGetPhysicalDeviceProperties2",
        "vkGetPhysicalDeviceFormatProperties2",
        "vkGetPhysicalDeviceImageFormatProperties2",
        "vkGetPhysicalDeviceQueueFamilyProperties2",
        "vkGetPhysicalDeviceMemoryProperties2",
        "vkGetPhysicalDeviceSparseImageFormatProperties2",
        "vkGetPhysicalDeviceExternalBufferProperties",
        "vkGetPhysicalDeviceExternalSemaphoreProperties",
        "vkGetPhysicalDeviceExternalFenceProperties",
        "vkEnumeratePhysicalDeviceGroups",
        "vkGetPhysicalDeviceToolProperties"
    );
    static_assert(std::extent_v<decltype(m_funcs)> == size_t(funcNames.count()));
    for (int i = 0; i < funcNames.count(); ++i) {
        m_funcs[i] = inst->getInstanceProcAddr(funcNames.at(i));
        if (i < 14 && !m_funcs[i])
            qWarning("QVulkanFunctions: Failed to resolve %s", funcNames.at(i));
    }
}


#if VK_VERSION_1_0
void QVulkanDeviceFunctions::vkDestroyDevice(VkDevice device, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[0]);
    reinterpret_cast<PFN_vkDestroyDevice>(d_ptr->m_funcs[0])(device, pAllocator);
}

void QVulkanDeviceFunctions::vkGetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue *pQueue)
{
    Q_ASSERT(d_ptr->m_funcs[1]);
    reinterpret_cast<PFN_vkGetDeviceQueue>(d_ptr->m_funcs[1])(device, queueFamilyIndex, queueIndex, pQueue);
}

VkResult QVulkanDeviceFunctions::vkQueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo *pSubmits, VkFence fence)
{
    Q_ASSERT(d_ptr->m_funcs[2]);
    return reinterpret_cast<PFN_vkQueueSubmit>(d_ptr->m_funcs[2])(queue, submitCount, pSubmits, fence);
}

VkResult QVulkanDeviceFunctions::vkQueueWaitIdle(VkQueue queue)
{
    Q_ASSERT(d_ptr->m_funcs[3]);
    return reinterpret_cast<PFN_vkQueueWaitIdle>(d_ptr->m_funcs[3])(queue);
}

VkResult QVulkanDeviceFunctions::vkDeviceWaitIdle(VkDevice device)
{
    Q_ASSERT(d_ptr->m_funcs[4]);
    return reinterpret_cast<PFN_vkDeviceWaitIdle>(d_ptr->m_funcs[4])(device);
}

VkResult QVulkanDeviceFunctions::vkAllocateMemory(VkDevice device, const VkMemoryAllocateInfo *pAllocateInfo, const VkAllocationCallbacks *pAllocator, VkDeviceMemory *pMemory)
{
    Q_ASSERT(d_ptr->m_funcs[5]);
    return reinterpret_cast<PFN_vkAllocateMemory>(d_ptr->m_funcs[5])(device, pAllocateInfo, pAllocator, pMemory);
}

void QVulkanDeviceFunctions::vkFreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[6]);
    reinterpret_cast<PFN_vkFreeMemory>(d_ptr->m_funcs[6])(device, memory, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkMapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void **ppData)
{
    Q_ASSERT(d_ptr->m_funcs[7]);
    return reinterpret_cast<PFN_vkMapMemory>(d_ptr->m_funcs[7])(device, memory, offset, size, flags, ppData);
}

void QVulkanDeviceFunctions::vkUnmapMemory(VkDevice device, VkDeviceMemory memory)
{
    Q_ASSERT(d_ptr->m_funcs[8]);
    reinterpret_cast<PFN_vkUnmapMemory>(d_ptr->m_funcs[8])(device, memory);
}

VkResult QVulkanDeviceFunctions::vkFlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange *pMemoryRanges)
{
    Q_ASSERT(d_ptr->m_funcs[9]);
    return reinterpret_cast<PFN_vkFlushMappedMemoryRanges>(d_ptr->m_funcs[9])(device, memoryRangeCount, pMemoryRanges);
}

VkResult QVulkanDeviceFunctions::vkInvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange *pMemoryRanges)
{
    Q_ASSERT(d_ptr->m_funcs[10]);
    return reinterpret_cast<PFN_vkInvalidateMappedMemoryRanges>(d_ptr->m_funcs[10])(device, memoryRangeCount, pMemoryRanges);
}

void QVulkanDeviceFunctions::vkGetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize *pCommittedMemoryInBytes)
{
    Q_ASSERT(d_ptr->m_funcs[11]);
    reinterpret_cast<PFN_vkGetDeviceMemoryCommitment>(d_ptr->m_funcs[11])(device, memory, pCommittedMemoryInBytes);
}

void QVulkanDeviceFunctions::vkGetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements *pMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[12]);
    reinterpret_cast<PFN_vkGetBufferMemoryRequirements>(d_ptr->m_funcs[12])(device, buffer, pMemoryRequirements);
}

VkResult QVulkanDeviceFunctions::vkBindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    Q_ASSERT(d_ptr->m_funcs[13]);
    return reinterpret_cast<PFN_vkBindBufferMemory>(d_ptr->m_funcs[13])(device, buffer, memory, memoryOffset);
}

void QVulkanDeviceFunctions::vkGetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements *pMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[14]);
    reinterpret_cast<PFN_vkGetImageMemoryRequirements>(d_ptr->m_funcs[14])(device, image, pMemoryRequirements);
}

VkResult QVulkanDeviceFunctions::vkBindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset)
{
    Q_ASSERT(d_ptr->m_funcs[15]);
    return reinterpret_cast<PFN_vkBindImageMemory>(d_ptr->m_funcs[15])(device, image, memory, memoryOffset);
}

void QVulkanDeviceFunctions::vkGetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t *pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements *pSparseMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[16]);
    reinterpret_cast<PFN_vkGetImageSparseMemoryRequirements>(d_ptr->m_funcs[16])(device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
}

VkResult QVulkanDeviceFunctions::vkQueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo *pBindInfo, VkFence fence)
{
    Q_ASSERT(d_ptr->m_funcs[17]);
    return reinterpret_cast<PFN_vkQueueBindSparse>(d_ptr->m_funcs[17])(queue, bindInfoCount, pBindInfo, fence);
}

VkResult QVulkanDeviceFunctions::vkCreateFence(VkDevice device, const VkFenceCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkFence *pFence)
{
    Q_ASSERT(d_ptr->m_funcs[18]);
    return reinterpret_cast<PFN_vkCreateFence>(d_ptr->m_funcs[18])(device, pCreateInfo, pAllocator, pFence);
}

void QVulkanDeviceFunctions::vkDestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[19]);
    reinterpret_cast<PFN_vkDestroyFence>(d_ptr->m_funcs[19])(device, fence, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkResetFences(VkDevice device, uint32_t fenceCount, const VkFence *pFences)
{
    Q_ASSERT(d_ptr->m_funcs[20]);
    return reinterpret_cast<PFN_vkResetFences>(d_ptr->m_funcs[20])(device, fenceCount, pFences);
}

VkResult QVulkanDeviceFunctions::vkGetFenceStatus(VkDevice device, VkFence fence)
{
    Q_ASSERT(d_ptr->m_funcs[21]);
    return reinterpret_cast<PFN_vkGetFenceStatus>(d_ptr->m_funcs[21])(device, fence);
}

VkResult QVulkanDeviceFunctions::vkWaitForFences(VkDevice device, uint32_t fenceCount, const VkFence *pFences, VkBool32 waitAll, uint64_t timeout)
{
    Q_ASSERT(d_ptr->m_funcs[22]);
    return reinterpret_cast<PFN_vkWaitForFences>(d_ptr->m_funcs[22])(device, fenceCount, pFences, waitAll, timeout);
}

VkResult QVulkanDeviceFunctions::vkCreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkSemaphore *pSemaphore)
{
    Q_ASSERT(d_ptr->m_funcs[23]);
    return reinterpret_cast<PFN_vkCreateSemaphore>(d_ptr->m_funcs[23])(device, pCreateInfo, pAllocator, pSemaphore);
}

void QVulkanDeviceFunctions::vkDestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[24]);
    reinterpret_cast<PFN_vkDestroySemaphore>(d_ptr->m_funcs[24])(device, semaphore, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateEvent(VkDevice device, const VkEventCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkEvent *pEvent)
{
    Q_ASSERT(d_ptr->m_funcs[25]);
    return reinterpret_cast<PFN_vkCreateEvent>(d_ptr->m_funcs[25])(device, pCreateInfo, pAllocator, pEvent);
}

void QVulkanDeviceFunctions::vkDestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[26]);
    reinterpret_cast<PFN_vkDestroyEvent>(d_ptr->m_funcs[26])(device, event, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkGetEventStatus(VkDevice device, VkEvent event)
{
    Q_ASSERT(d_ptr->m_funcs[27]);
    return reinterpret_cast<PFN_vkGetEventStatus>(d_ptr->m_funcs[27])(device, event);
}

VkResult QVulkanDeviceFunctions::vkSetEvent(VkDevice device, VkEvent event)
{
    Q_ASSERT(d_ptr->m_funcs[28]);
    return reinterpret_cast<PFN_vkSetEvent>(d_ptr->m_funcs[28])(device, event);
}

VkResult QVulkanDeviceFunctions::vkResetEvent(VkDevice device, VkEvent event)
{
    Q_ASSERT(d_ptr->m_funcs[29]);
    return reinterpret_cast<PFN_vkResetEvent>(d_ptr->m_funcs[29])(device, event);
}

VkResult QVulkanDeviceFunctions::vkCreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkQueryPool *pQueryPool)
{
    Q_ASSERT(d_ptr->m_funcs[30]);
    return reinterpret_cast<PFN_vkCreateQueryPool>(d_ptr->m_funcs[30])(device, pCreateInfo, pAllocator, pQueryPool);
}

void QVulkanDeviceFunctions::vkDestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[31]);
    reinterpret_cast<PFN_vkDestroyQueryPool>(d_ptr->m_funcs[31])(device, queryPool, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkGetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void *pData, VkDeviceSize stride, VkQueryResultFlags flags)
{
    Q_ASSERT(d_ptr->m_funcs[32]);
    return reinterpret_cast<PFN_vkGetQueryPoolResults>(d_ptr->m_funcs[32])(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
}

VkResult QVulkanDeviceFunctions::vkCreateBuffer(VkDevice device, const VkBufferCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkBuffer *pBuffer)
{
    Q_ASSERT(d_ptr->m_funcs[33]);
    return reinterpret_cast<PFN_vkCreateBuffer>(d_ptr->m_funcs[33])(device, pCreateInfo, pAllocator, pBuffer);
}

void QVulkanDeviceFunctions::vkDestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[34]);
    reinterpret_cast<PFN_vkDestroyBuffer>(d_ptr->m_funcs[34])(device, buffer, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateBufferView(VkDevice device, const VkBufferViewCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkBufferView *pView)
{
    Q_ASSERT(d_ptr->m_funcs[35]);
    return reinterpret_cast<PFN_vkCreateBufferView>(d_ptr->m_funcs[35])(device, pCreateInfo, pAllocator, pView);
}

void QVulkanDeviceFunctions::vkDestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[36]);
    reinterpret_cast<PFN_vkDestroyBufferView>(d_ptr->m_funcs[36])(device, bufferView, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateImage(VkDevice device, const VkImageCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkImage *pImage)
{
    Q_ASSERT(d_ptr->m_funcs[37]);
    return reinterpret_cast<PFN_vkCreateImage>(d_ptr->m_funcs[37])(device, pCreateInfo, pAllocator, pImage);
}

void QVulkanDeviceFunctions::vkDestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[38]);
    reinterpret_cast<PFN_vkDestroyImage>(d_ptr->m_funcs[38])(device, image, pAllocator);
}

void QVulkanDeviceFunctions::vkGetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource *pSubresource, VkSubresourceLayout *pLayout)
{
    Q_ASSERT(d_ptr->m_funcs[39]);
    reinterpret_cast<PFN_vkGetImageSubresourceLayout>(d_ptr->m_funcs[39])(device, image, pSubresource, pLayout);
}

VkResult QVulkanDeviceFunctions::vkCreateImageView(VkDevice device, const VkImageViewCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkImageView *pView)
{
    Q_ASSERT(d_ptr->m_funcs[40]);
    return reinterpret_cast<PFN_vkCreateImageView>(d_ptr->m_funcs[40])(device, pCreateInfo, pAllocator, pView);
}

void QVulkanDeviceFunctions::vkDestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[41]);
    reinterpret_cast<PFN_vkDestroyImageView>(d_ptr->m_funcs[41])(device, imageView, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkShaderModule *pShaderModule)
{
    Q_ASSERT(d_ptr->m_funcs[42]);
    return reinterpret_cast<PFN_vkCreateShaderModule>(d_ptr->m_funcs[42])(device, pCreateInfo, pAllocator, pShaderModule);
}

void QVulkanDeviceFunctions::vkDestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[43]);
    reinterpret_cast<PFN_vkDestroyShaderModule>(d_ptr->m_funcs[43])(device, shaderModule, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkPipelineCache *pPipelineCache)
{
    Q_ASSERT(d_ptr->m_funcs[44]);
    return reinterpret_cast<PFN_vkCreatePipelineCache>(d_ptr->m_funcs[44])(device, pCreateInfo, pAllocator, pPipelineCache);
}

void QVulkanDeviceFunctions::vkDestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[45]);
    reinterpret_cast<PFN_vkDestroyPipelineCache>(d_ptr->m_funcs[45])(device, pipelineCache, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkGetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t *pDataSize, void *pData)
{
    Q_ASSERT(d_ptr->m_funcs[46]);
    return reinterpret_cast<PFN_vkGetPipelineCacheData>(d_ptr->m_funcs[46])(device, pipelineCache, pDataSize, pData);
}

VkResult QVulkanDeviceFunctions::vkMergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache *pSrcCaches)
{
    Q_ASSERT(d_ptr->m_funcs[47]);
    return reinterpret_cast<PFN_vkMergePipelineCaches>(d_ptr->m_funcs[47])(device, dstCache, srcCacheCount, pSrcCaches);
}

VkResult QVulkanDeviceFunctions::vkCreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo *pCreateInfos, const VkAllocationCallbacks *pAllocator, VkPipeline *pPipelines)
{
    Q_ASSERT(d_ptr->m_funcs[48]);
    return reinterpret_cast<PFN_vkCreateGraphicsPipelines>(d_ptr->m_funcs[48])(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
}

VkResult QVulkanDeviceFunctions::vkCreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo *pCreateInfos, const VkAllocationCallbacks *pAllocator, VkPipeline *pPipelines)
{
    Q_ASSERT(d_ptr->m_funcs[49]);
    return reinterpret_cast<PFN_vkCreateComputePipelines>(d_ptr->m_funcs[49])(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
}

void QVulkanDeviceFunctions::vkDestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[50]);
    reinterpret_cast<PFN_vkDestroyPipeline>(d_ptr->m_funcs[50])(device, pipeline, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkPipelineLayout *pPipelineLayout)
{
    Q_ASSERT(d_ptr->m_funcs[51]);
    return reinterpret_cast<PFN_vkCreatePipelineLayout>(d_ptr->m_funcs[51])(device, pCreateInfo, pAllocator, pPipelineLayout);
}

void QVulkanDeviceFunctions::vkDestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[52]);
    reinterpret_cast<PFN_vkDestroyPipelineLayout>(d_ptr->m_funcs[52])(device, pipelineLayout, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateSampler(VkDevice device, const VkSamplerCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkSampler *pSampler)
{
    Q_ASSERT(d_ptr->m_funcs[53]);
    return reinterpret_cast<PFN_vkCreateSampler>(d_ptr->m_funcs[53])(device, pCreateInfo, pAllocator, pSampler);
}

void QVulkanDeviceFunctions::vkDestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[54]);
    reinterpret_cast<PFN_vkDestroySampler>(d_ptr->m_funcs[54])(device, sampler, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkDescriptorSetLayout *pSetLayout)
{
    Q_ASSERT(d_ptr->m_funcs[55]);
    return reinterpret_cast<PFN_vkCreateDescriptorSetLayout>(d_ptr->m_funcs[55])(device, pCreateInfo, pAllocator, pSetLayout);
}

void QVulkanDeviceFunctions::vkDestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[56]);
    reinterpret_cast<PFN_vkDestroyDescriptorSetLayout>(d_ptr->m_funcs[56])(device, descriptorSetLayout, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkDescriptorPool *pDescriptorPool)
{
    Q_ASSERT(d_ptr->m_funcs[57]);
    return reinterpret_cast<PFN_vkCreateDescriptorPool>(d_ptr->m_funcs[57])(device, pCreateInfo, pAllocator, pDescriptorPool);
}

void QVulkanDeviceFunctions::vkDestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[58]);
    reinterpret_cast<PFN_vkDestroyDescriptorPool>(d_ptr->m_funcs[58])(device, descriptorPool, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags)
{
    Q_ASSERT(d_ptr->m_funcs[59]);
    return reinterpret_cast<PFN_vkResetDescriptorPool>(d_ptr->m_funcs[59])(device, descriptorPool, flags);
}

VkResult QVulkanDeviceFunctions::vkAllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo *pAllocateInfo, VkDescriptorSet *pDescriptorSets)
{
    Q_ASSERT(d_ptr->m_funcs[60]);
    return reinterpret_cast<PFN_vkAllocateDescriptorSets>(d_ptr->m_funcs[60])(device, pAllocateInfo, pDescriptorSets);
}

VkResult QVulkanDeviceFunctions::vkFreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet *pDescriptorSets)
{
    Q_ASSERT(d_ptr->m_funcs[61]);
    return reinterpret_cast<PFN_vkFreeDescriptorSets>(d_ptr->m_funcs[61])(device, descriptorPool, descriptorSetCount, pDescriptorSets);
}

void QVulkanDeviceFunctions::vkUpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet *pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet *pDescriptorCopies)
{
    Q_ASSERT(d_ptr->m_funcs[62]);
    reinterpret_cast<PFN_vkUpdateDescriptorSets>(d_ptr->m_funcs[62])(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies);
}

VkResult QVulkanDeviceFunctions::vkCreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkFramebuffer *pFramebuffer)
{
    Q_ASSERT(d_ptr->m_funcs[63]);
    return reinterpret_cast<PFN_vkCreateFramebuffer>(d_ptr->m_funcs[63])(device, pCreateInfo, pAllocator, pFramebuffer);
}

void QVulkanDeviceFunctions::vkDestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[64]);
    reinterpret_cast<PFN_vkDestroyFramebuffer>(d_ptr->m_funcs[64])(device, framebuffer, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkCreateRenderPass(VkDevice device, const VkRenderPassCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkRenderPass *pRenderPass)
{
    Q_ASSERT(d_ptr->m_funcs[65]);
    return reinterpret_cast<PFN_vkCreateRenderPass>(d_ptr->m_funcs[65])(device, pCreateInfo, pAllocator, pRenderPass);
}

void QVulkanDeviceFunctions::vkDestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[66]);
    reinterpret_cast<PFN_vkDestroyRenderPass>(d_ptr->m_funcs[66])(device, renderPass, pAllocator);
}

void QVulkanDeviceFunctions::vkGetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D *pGranularity)
{
    Q_ASSERT(d_ptr->m_funcs[67]);
    reinterpret_cast<PFN_vkGetRenderAreaGranularity>(d_ptr->m_funcs[67])(device, renderPass, pGranularity);
}

VkResult QVulkanDeviceFunctions::vkCreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkCommandPool *pCommandPool)
{
    Q_ASSERT(d_ptr->m_funcs[68]);
    return reinterpret_cast<PFN_vkCreateCommandPool>(d_ptr->m_funcs[68])(device, pCreateInfo, pAllocator, pCommandPool);
}

void QVulkanDeviceFunctions::vkDestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[69]);
    reinterpret_cast<PFN_vkDestroyCommandPool>(d_ptr->m_funcs[69])(device, commandPool, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags)
{
    Q_ASSERT(d_ptr->m_funcs[70]);
    return reinterpret_cast<PFN_vkResetCommandPool>(d_ptr->m_funcs[70])(device, commandPool, flags);
}

VkResult QVulkanDeviceFunctions::vkAllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo *pAllocateInfo, VkCommandBuffer *pCommandBuffers)
{
    Q_ASSERT(d_ptr->m_funcs[71]);
    return reinterpret_cast<PFN_vkAllocateCommandBuffers>(d_ptr->m_funcs[71])(device, pAllocateInfo, pCommandBuffers);
}

void QVulkanDeviceFunctions::vkFreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer *pCommandBuffers)
{
    Q_ASSERT(d_ptr->m_funcs[72]);
    reinterpret_cast<PFN_vkFreeCommandBuffers>(d_ptr->m_funcs[72])(device, commandPool, commandBufferCount, pCommandBuffers);
}

VkResult QVulkanDeviceFunctions::vkBeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo *pBeginInfo)
{
    Q_ASSERT(d_ptr->m_funcs[73]);
    return reinterpret_cast<PFN_vkBeginCommandBuffer>(d_ptr->m_funcs[73])(commandBuffer, pBeginInfo);
}

VkResult QVulkanDeviceFunctions::vkEndCommandBuffer(VkCommandBuffer commandBuffer)
{
    Q_ASSERT(d_ptr->m_funcs[74]);
    return reinterpret_cast<PFN_vkEndCommandBuffer>(d_ptr->m_funcs[74])(commandBuffer);
}

VkResult QVulkanDeviceFunctions::vkResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    Q_ASSERT(d_ptr->m_funcs[75]);
    return reinterpret_cast<PFN_vkResetCommandBuffer>(d_ptr->m_funcs[75])(commandBuffer, flags);
}

void QVulkanDeviceFunctions::vkCmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    Q_ASSERT(d_ptr->m_funcs[76]);
    reinterpret_cast<PFN_vkCmdBindPipeline>(d_ptr->m_funcs[76])(commandBuffer, pipelineBindPoint, pipeline);
}

void QVulkanDeviceFunctions::vkCmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport *pViewports)
{
    Q_ASSERT(d_ptr->m_funcs[77]);
    reinterpret_cast<PFN_vkCmdSetViewport>(d_ptr->m_funcs[77])(commandBuffer, firstViewport, viewportCount, pViewports);
}

void QVulkanDeviceFunctions::vkCmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D *pScissors)
{
    Q_ASSERT(d_ptr->m_funcs[78]);
    reinterpret_cast<PFN_vkCmdSetScissor>(d_ptr->m_funcs[78])(commandBuffer, firstScissor, scissorCount, pScissors);
}

void QVulkanDeviceFunctions::vkCmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth)
{
    Q_ASSERT(d_ptr->m_funcs[79]);
    reinterpret_cast<PFN_vkCmdSetLineWidth>(d_ptr->m_funcs[79])(commandBuffer, lineWidth);
}

void QVulkanDeviceFunctions::vkCmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    Q_ASSERT(d_ptr->m_funcs[80]);
    reinterpret_cast<PFN_vkCmdSetDepthBias>(d_ptr->m_funcs[80])(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
}

void QVulkanDeviceFunctions::vkCmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    Q_ASSERT(d_ptr->m_funcs[81]);
    reinterpret_cast<PFN_vkCmdSetBlendConstants>(d_ptr->m_funcs[81])(commandBuffer, blendConstants);
}

void QVulkanDeviceFunctions::vkCmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    Q_ASSERT(d_ptr->m_funcs[82]);
    reinterpret_cast<PFN_vkCmdSetDepthBounds>(d_ptr->m_funcs[82])(commandBuffer, minDepthBounds, maxDepthBounds);
}

void QVulkanDeviceFunctions::vkCmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    Q_ASSERT(d_ptr->m_funcs[83]);
    reinterpret_cast<PFN_vkCmdSetStencilCompareMask>(d_ptr->m_funcs[83])(commandBuffer, faceMask, compareMask);
}

void QVulkanDeviceFunctions::vkCmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    Q_ASSERT(d_ptr->m_funcs[84]);
    reinterpret_cast<PFN_vkCmdSetStencilWriteMask>(d_ptr->m_funcs[84])(commandBuffer, faceMask, writeMask);
}

void QVulkanDeviceFunctions::vkCmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    Q_ASSERT(d_ptr->m_funcs[85]);
    reinterpret_cast<PFN_vkCmdSetStencilReference>(d_ptr->m_funcs[85])(commandBuffer, faceMask, reference);
}

void QVulkanDeviceFunctions::vkCmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet *pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t *pDynamicOffsets)
{
    Q_ASSERT(d_ptr->m_funcs[86]);
    reinterpret_cast<PFN_vkCmdBindDescriptorSets>(d_ptr->m_funcs[86])(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
}

void QVulkanDeviceFunctions::vkCmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    Q_ASSERT(d_ptr->m_funcs[87]);
    reinterpret_cast<PFN_vkCmdBindIndexBuffer>(d_ptr->m_funcs[87])(commandBuffer, buffer, offset, indexType);
}

void QVulkanDeviceFunctions::vkCmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer *pBuffers, const VkDeviceSize *pOffsets)
{
    Q_ASSERT(d_ptr->m_funcs[88]);
    reinterpret_cast<PFN_vkCmdBindVertexBuffers>(d_ptr->m_funcs[88])(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
}

void QVulkanDeviceFunctions::vkCmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    Q_ASSERT(d_ptr->m_funcs[89]);
    reinterpret_cast<PFN_vkCmdDraw>(d_ptr->m_funcs[89])(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
}

void QVulkanDeviceFunctions::vkCmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    Q_ASSERT(d_ptr->m_funcs[90]);
    reinterpret_cast<PFN_vkCmdDrawIndexed>(d_ptr->m_funcs[90])(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
}

void QVulkanDeviceFunctions::vkCmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    Q_ASSERT(d_ptr->m_funcs[91]);
    reinterpret_cast<PFN_vkCmdDrawIndirect>(d_ptr->m_funcs[91])(commandBuffer, buffer, offset, drawCount, stride);
}

void QVulkanDeviceFunctions::vkCmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    Q_ASSERT(d_ptr->m_funcs[92]);
    reinterpret_cast<PFN_vkCmdDrawIndexedIndirect>(d_ptr->m_funcs[92])(commandBuffer, buffer, offset, drawCount, stride);
}

void QVulkanDeviceFunctions::vkCmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    Q_ASSERT(d_ptr->m_funcs[93]);
    reinterpret_cast<PFN_vkCmdDispatch>(d_ptr->m_funcs[93])(commandBuffer, groupCountX, groupCountY, groupCountZ);
}

void QVulkanDeviceFunctions::vkCmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    Q_ASSERT(d_ptr->m_funcs[94]);
    reinterpret_cast<PFN_vkCmdDispatchIndirect>(d_ptr->m_funcs[94])(commandBuffer, buffer, offset);
}

void QVulkanDeviceFunctions::vkCmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy *pRegions)
{
    Q_ASSERT(d_ptr->m_funcs[95]);
    reinterpret_cast<PFN_vkCmdCopyBuffer>(d_ptr->m_funcs[95])(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
}

void QVulkanDeviceFunctions::vkCmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy *pRegions)
{
    Q_ASSERT(d_ptr->m_funcs[96]);
    reinterpret_cast<PFN_vkCmdCopyImage>(d_ptr->m_funcs[96])(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
}

void QVulkanDeviceFunctions::vkCmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit *pRegions, VkFilter filter)
{
    Q_ASSERT(d_ptr->m_funcs[97]);
    reinterpret_cast<PFN_vkCmdBlitImage>(d_ptr->m_funcs[97])(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
}

void QVulkanDeviceFunctions::vkCmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy *pRegions)
{
    Q_ASSERT(d_ptr->m_funcs[98]);
    reinterpret_cast<PFN_vkCmdCopyBufferToImage>(d_ptr->m_funcs[98])(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
}

void QVulkanDeviceFunctions::vkCmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy *pRegions)
{
    Q_ASSERT(d_ptr->m_funcs[99]);
    reinterpret_cast<PFN_vkCmdCopyImageToBuffer>(d_ptr->m_funcs[99])(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
}

void QVulkanDeviceFunctions::vkCmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void *pData)
{
    Q_ASSERT(d_ptr->m_funcs[100]);
    reinterpret_cast<PFN_vkCmdUpdateBuffer>(d_ptr->m_funcs[100])(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
}

void QVulkanDeviceFunctions::vkCmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    Q_ASSERT(d_ptr->m_funcs[101]);
    reinterpret_cast<PFN_vkCmdFillBuffer>(d_ptr->m_funcs[101])(commandBuffer, dstBuffer, dstOffset, size, data);
}

void QVulkanDeviceFunctions::vkCmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue *pColor, uint32_t rangeCount, const VkImageSubresourceRange *pRanges)
{
    Q_ASSERT(d_ptr->m_funcs[102]);
    reinterpret_cast<PFN_vkCmdClearColorImage>(d_ptr->m_funcs[102])(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
}

void QVulkanDeviceFunctions::vkCmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue *pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange *pRanges)
{
    Q_ASSERT(d_ptr->m_funcs[103]);
    reinterpret_cast<PFN_vkCmdClearDepthStencilImage>(d_ptr->m_funcs[103])(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
}

void QVulkanDeviceFunctions::vkCmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment *pAttachments, uint32_t rectCount, const VkClearRect *pRects)
{
    Q_ASSERT(d_ptr->m_funcs[104]);
    reinterpret_cast<PFN_vkCmdClearAttachments>(d_ptr->m_funcs[104])(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
}

void QVulkanDeviceFunctions::vkCmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve *pRegions)
{
    Q_ASSERT(d_ptr->m_funcs[105]);
    reinterpret_cast<PFN_vkCmdResolveImage>(d_ptr->m_funcs[105])(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
}

void QVulkanDeviceFunctions::vkCmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    Q_ASSERT(d_ptr->m_funcs[106]);
    reinterpret_cast<PFN_vkCmdSetEvent>(d_ptr->m_funcs[106])(commandBuffer, event, stageMask);
}

void QVulkanDeviceFunctions::vkCmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    Q_ASSERT(d_ptr->m_funcs[107]);
    reinterpret_cast<PFN_vkCmdResetEvent>(d_ptr->m_funcs[107])(commandBuffer, event, stageMask);
}

void QVulkanDeviceFunctions::vkCmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent *pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier *pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier *pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier *pImageMemoryBarriers)
{
    Q_ASSERT(d_ptr->m_funcs[108]);
    reinterpret_cast<PFN_vkCmdWaitEvents>(d_ptr->m_funcs[108])(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
}

void QVulkanDeviceFunctions::vkCmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier *pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier *pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier *pImageMemoryBarriers)
{
    Q_ASSERT(d_ptr->m_funcs[109]);
    reinterpret_cast<PFN_vkCmdPipelineBarrier>(d_ptr->m_funcs[109])(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
}

void QVulkanDeviceFunctions::vkCmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    Q_ASSERT(d_ptr->m_funcs[110]);
    reinterpret_cast<PFN_vkCmdBeginQuery>(d_ptr->m_funcs[110])(commandBuffer, queryPool, query, flags);
}

void QVulkanDeviceFunctions::vkCmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    Q_ASSERT(d_ptr->m_funcs[111]);
    reinterpret_cast<PFN_vkCmdEndQuery>(d_ptr->m_funcs[111])(commandBuffer, queryPool, query);
}

void QVulkanDeviceFunctions::vkCmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    Q_ASSERT(d_ptr->m_funcs[112]);
    reinterpret_cast<PFN_vkCmdResetQueryPool>(d_ptr->m_funcs[112])(commandBuffer, queryPool, firstQuery, queryCount);
}

void QVulkanDeviceFunctions::vkCmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    Q_ASSERT(d_ptr->m_funcs[113]);
    reinterpret_cast<PFN_vkCmdWriteTimestamp>(d_ptr->m_funcs[113])(commandBuffer, pipelineStage, queryPool, query);
}

void QVulkanDeviceFunctions::vkCmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    Q_ASSERT(d_ptr->m_funcs[114]);
    reinterpret_cast<PFN_vkCmdCopyQueryPoolResults>(d_ptr->m_funcs[114])(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
}

void QVulkanDeviceFunctions::vkCmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void *pValues)
{
    Q_ASSERT(d_ptr->m_funcs[115]);
    reinterpret_cast<PFN_vkCmdPushConstants>(d_ptr->m_funcs[115])(commandBuffer, layout, stageFlags, offset, size, pValues);
}

void QVulkanDeviceFunctions::vkCmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo *pRenderPassBegin, VkSubpassContents contents)
{
    Q_ASSERT(d_ptr->m_funcs[116]);
    reinterpret_cast<PFN_vkCmdBeginRenderPass>(d_ptr->m_funcs[116])(commandBuffer, pRenderPassBegin, contents);
}

void QVulkanDeviceFunctions::vkCmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    Q_ASSERT(d_ptr->m_funcs[117]);
    reinterpret_cast<PFN_vkCmdNextSubpass>(d_ptr->m_funcs[117])(commandBuffer, contents);
}

void QVulkanDeviceFunctions::vkCmdEndRenderPass(VkCommandBuffer commandBuffer)
{
    Q_ASSERT(d_ptr->m_funcs[118]);
    reinterpret_cast<PFN_vkCmdEndRenderPass>(d_ptr->m_funcs[118])(commandBuffer);
}

void QVulkanDeviceFunctions::vkCmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer *pCommandBuffers)
{
    Q_ASSERT(d_ptr->m_funcs[119]);
    reinterpret_cast<PFN_vkCmdExecuteCommands>(d_ptr->m_funcs[119])(commandBuffer, commandBufferCount, pCommandBuffers);
}

#endif


#if VK_VERSION_1_1
void QVulkanDeviceFunctions::vkTrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags)
{
    Q_ASSERT(d_ptr->m_funcs[120]);
    reinterpret_cast<PFN_vkTrimCommandPool>(d_ptr->m_funcs[120])(device, commandPool, flags);
}

void QVulkanDeviceFunctions::vkGetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags *pPeerMemoryFeatures)
{
    Q_ASSERT(d_ptr->m_funcs[121]);
    reinterpret_cast<PFN_vkGetDeviceGroupPeerMemoryFeatures>(d_ptr->m_funcs[121])(device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
}

VkResult QVulkanDeviceFunctions::vkBindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo *pBindInfos)
{
    Q_ASSERT(d_ptr->m_funcs[122]);
    return reinterpret_cast<PFN_vkBindBufferMemory2>(d_ptr->m_funcs[122])(device, bindInfoCount, pBindInfos);
}

VkResult QVulkanDeviceFunctions::vkBindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo *pBindInfos)
{
    Q_ASSERT(d_ptr->m_funcs[123]);
    return reinterpret_cast<PFN_vkBindImageMemory2>(d_ptr->m_funcs[123])(device, bindInfoCount, pBindInfos);
}

void QVulkanDeviceFunctions::vkCmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    Q_ASSERT(d_ptr->m_funcs[124]);
    reinterpret_cast<PFN_vkCmdSetDeviceMask>(d_ptr->m_funcs[124])(commandBuffer, deviceMask);
}

void QVulkanDeviceFunctions::vkCmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    Q_ASSERT(d_ptr->m_funcs[125]);
    reinterpret_cast<PFN_vkCmdDispatchBase>(d_ptr->m_funcs[125])(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
}

VkResult QVulkanDeviceFunctions::vkCreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkDescriptorUpdateTemplate *pDescriptorUpdateTemplate)
{
    Q_ASSERT(d_ptr->m_funcs[126]);
    return reinterpret_cast<PFN_vkCreateDescriptorUpdateTemplate>(d_ptr->m_funcs[126])(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
}

void QVulkanDeviceFunctions::vkDestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[127]);
    reinterpret_cast<PFN_vkDestroyDescriptorUpdateTemplate>(d_ptr->m_funcs[127])(device, descriptorUpdateTemplate, pAllocator);
}

void QVulkanDeviceFunctions::vkUpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void *pData)
{
    Q_ASSERT(d_ptr->m_funcs[128]);
    reinterpret_cast<PFN_vkUpdateDescriptorSetWithTemplate>(d_ptr->m_funcs[128])(device, descriptorSet, descriptorUpdateTemplate, pData);
}

void QVulkanDeviceFunctions::vkGetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2 *pInfo, VkMemoryRequirements2 *pMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[129]);
    reinterpret_cast<PFN_vkGetBufferMemoryRequirements2>(d_ptr->m_funcs[129])(device, pInfo, pMemoryRequirements);
}

void QVulkanDeviceFunctions::vkGetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2 *pInfo, VkMemoryRequirements2 *pMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[130]);
    reinterpret_cast<PFN_vkGetImageMemoryRequirements2>(d_ptr->m_funcs[130])(device, pInfo, pMemoryRequirements);
}

void QVulkanDeviceFunctions::vkGetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2 *pInfo, uint32_t *pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2 *pSparseMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[131]);
    reinterpret_cast<PFN_vkGetImageSparseMemoryRequirements2>(d_ptr->m_funcs[131])(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
}

VkResult QVulkanDeviceFunctions::vkCreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkSamplerYcbcrConversion *pYcbcrConversion)
{
    Q_ASSERT(d_ptr->m_funcs[132]);
    return reinterpret_cast<PFN_vkCreateSamplerYcbcrConversion>(d_ptr->m_funcs[132])(device, pCreateInfo, pAllocator, pYcbcrConversion);
}

void QVulkanDeviceFunctions::vkDestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[133]);
    reinterpret_cast<PFN_vkDestroySamplerYcbcrConversion>(d_ptr->m_funcs[133])(device, ycbcrConversion, pAllocator);
}

void QVulkanDeviceFunctions::vkGetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2 *pQueueInfo, VkQueue *pQueue)
{
    Q_ASSERT(d_ptr->m_funcs[134]);
    reinterpret_cast<PFN_vkGetDeviceQueue2>(d_ptr->m_funcs[134])(device, pQueueInfo, pQueue);
}

void QVulkanDeviceFunctions::vkGetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo *pCreateInfo, VkDescriptorSetLayoutSupport *pSupport)
{
    Q_ASSERT(d_ptr->m_funcs[135]);
    reinterpret_cast<PFN_vkGetDescriptorSetLayoutSupport>(d_ptr->m_funcs[135])(device, pCreateInfo, pSupport);
}

#endif


#if VK_VERSION_1_2
void QVulkanDeviceFunctions::vkResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    Q_ASSERT(d_ptr->m_funcs[136]);
    reinterpret_cast<PFN_vkResetQueryPool>(d_ptr->m_funcs[136])(device, queryPool, firstQuery, queryCount);
}

VkResult QVulkanDeviceFunctions::vkCreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2 *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkRenderPass *pRenderPass)
{
    Q_ASSERT(d_ptr->m_funcs[137]);
    return reinterpret_cast<PFN_vkCreateRenderPass2>(d_ptr->m_funcs[137])(device, pCreateInfo, pAllocator, pRenderPass);
}

void QVulkanDeviceFunctions::vkCmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo *pRenderPassBegin, const VkSubpassBeginInfo *pSubpassBeginInfo)
{
    Q_ASSERT(d_ptr->m_funcs[138]);
    reinterpret_cast<PFN_vkCmdBeginRenderPass2>(d_ptr->m_funcs[138])(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
}

void QVulkanDeviceFunctions::vkCmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo *pSubpassBeginInfo, const VkSubpassEndInfo *pSubpassEndInfo)
{
    Q_ASSERT(d_ptr->m_funcs[139]);
    reinterpret_cast<PFN_vkCmdNextSubpass2>(d_ptr->m_funcs[139])(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
}

void QVulkanDeviceFunctions::vkCmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo *pSubpassEndInfo)
{
    Q_ASSERT(d_ptr->m_funcs[140]);
    reinterpret_cast<PFN_vkCmdEndRenderPass2>(d_ptr->m_funcs[140])(commandBuffer, pSubpassEndInfo);
}

VkResult QVulkanDeviceFunctions::vkGetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t *pValue)
{
    Q_ASSERT(d_ptr->m_funcs[141]);
    return reinterpret_cast<PFN_vkGetSemaphoreCounterValue>(d_ptr->m_funcs[141])(device, semaphore, pValue);
}

VkResult QVulkanDeviceFunctions::vkWaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo *pWaitInfo, uint64_t timeout)
{
    Q_ASSERT(d_ptr->m_funcs[142]);
    return reinterpret_cast<PFN_vkWaitSemaphores>(d_ptr->m_funcs[142])(device, pWaitInfo, timeout);
}

VkResult QVulkanDeviceFunctions::vkSignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo *pSignalInfo)
{
    Q_ASSERT(d_ptr->m_funcs[143]);
    return reinterpret_cast<PFN_vkSignalSemaphore>(d_ptr->m_funcs[143])(device, pSignalInfo);
}

void QVulkanDeviceFunctions::vkCmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    Q_ASSERT(d_ptr->m_funcs[144]);
    reinterpret_cast<PFN_vkCmdDrawIndirectCount>(d_ptr->m_funcs[144])(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
}

void QVulkanDeviceFunctions::vkCmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    Q_ASSERT(d_ptr->m_funcs[145]);
    reinterpret_cast<PFN_vkCmdDrawIndexedIndirectCount>(d_ptr->m_funcs[145])(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
}

uint64_t QVulkanDeviceFunctions::vkGetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo *pInfo)
{
    Q_ASSERT(d_ptr->m_funcs[146]);
    return reinterpret_cast<PFN_vkGetBufferOpaqueCaptureAddress>(d_ptr->m_funcs[146])(device, pInfo);
}

VkDeviceAddress QVulkanDeviceFunctions::vkGetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo *pInfo)
{
    Q_ASSERT(d_ptr->m_funcs[147]);
    return reinterpret_cast<PFN_vkGetBufferDeviceAddress>(d_ptr->m_funcs[147])(device, pInfo);
}

uint64_t QVulkanDeviceFunctions::vkGetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo *pInfo)
{
    Q_ASSERT(d_ptr->m_funcs[148]);
    return reinterpret_cast<PFN_vkGetDeviceMemoryOpaqueCaptureAddress>(d_ptr->m_funcs[148])(device, pInfo);
}

#endif


#if VK_VERSION_1_3
void QVulkanDeviceFunctions::vkGetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements *pInfo, VkMemoryRequirements2 *pMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[149]);
    reinterpret_cast<PFN_vkGetDeviceBufferMemoryRequirements>(d_ptr->m_funcs[149])(device, pInfo, pMemoryRequirements);
}

void QVulkanDeviceFunctions::vkGetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements *pInfo, VkMemoryRequirements2 *pMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[150]);
    reinterpret_cast<PFN_vkGetDeviceImageMemoryRequirements>(d_ptr->m_funcs[150])(device, pInfo, pMemoryRequirements);
}

void QVulkanDeviceFunctions::vkGetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements *pInfo, uint32_t *pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2 *pSparseMemoryRequirements)
{
    Q_ASSERT(d_ptr->m_funcs[151]);
    reinterpret_cast<PFN_vkGetDeviceImageSparseMemoryRequirements>(d_ptr->m_funcs[151])(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
}

void QVulkanDeviceFunctions::vkCmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    Q_ASSERT(d_ptr->m_funcs[152]);
    reinterpret_cast<PFN_vkCmdSetCullMode>(d_ptr->m_funcs[152])(commandBuffer, cullMode);
}

void QVulkanDeviceFunctions::vkCmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    Q_ASSERT(d_ptr->m_funcs[153]);
    reinterpret_cast<PFN_vkCmdSetFrontFace>(d_ptr->m_funcs[153])(commandBuffer, frontFace);
}

void QVulkanDeviceFunctions::vkCmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    Q_ASSERT(d_ptr->m_funcs[154]);
    reinterpret_cast<PFN_vkCmdSetPrimitiveTopology>(d_ptr->m_funcs[154])(commandBuffer, primitiveTopology);
}

void QVulkanDeviceFunctions::vkCmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport *pViewports)
{
    Q_ASSERT(d_ptr->m_funcs[155]);
    reinterpret_cast<PFN_vkCmdSetViewportWithCount>(d_ptr->m_funcs[155])(commandBuffer, viewportCount, pViewports);
}

void QVulkanDeviceFunctions::vkCmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D *pScissors)
{
    Q_ASSERT(d_ptr->m_funcs[156]);
    reinterpret_cast<PFN_vkCmdSetScissorWithCount>(d_ptr->m_funcs[156])(commandBuffer, scissorCount, pScissors);
}

void QVulkanDeviceFunctions::vkCmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer *pBuffers, const VkDeviceSize *pOffsets, const VkDeviceSize *pSizes, const VkDeviceSize *pStrides)
{
    Q_ASSERT(d_ptr->m_funcs[157]);
    reinterpret_cast<PFN_vkCmdBindVertexBuffers2>(d_ptr->m_funcs[157])(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
}

void QVulkanDeviceFunctions::vkCmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    Q_ASSERT(d_ptr->m_funcs[158]);
    reinterpret_cast<PFN_vkCmdSetDepthTestEnable>(d_ptr->m_funcs[158])(commandBuffer, depthTestEnable);
}

void QVulkanDeviceFunctions::vkCmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    Q_ASSERT(d_ptr->m_funcs[159]);
    reinterpret_cast<PFN_vkCmdSetDepthWriteEnable>(d_ptr->m_funcs[159])(commandBuffer, depthWriteEnable);
}

void QVulkanDeviceFunctions::vkCmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    Q_ASSERT(d_ptr->m_funcs[160]);
    reinterpret_cast<PFN_vkCmdSetDepthCompareOp>(d_ptr->m_funcs[160])(commandBuffer, depthCompareOp);
}

void QVulkanDeviceFunctions::vkCmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    Q_ASSERT(d_ptr->m_funcs[161]);
    reinterpret_cast<PFN_vkCmdSetDepthBoundsTestEnable>(d_ptr->m_funcs[161])(commandBuffer, depthBoundsTestEnable);
}

void QVulkanDeviceFunctions::vkCmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    Q_ASSERT(d_ptr->m_funcs[162]);
    reinterpret_cast<PFN_vkCmdSetStencilTestEnable>(d_ptr->m_funcs[162])(commandBuffer, stencilTestEnable);
}

void QVulkanDeviceFunctions::vkCmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    Q_ASSERT(d_ptr->m_funcs[163]);
    reinterpret_cast<PFN_vkCmdSetStencilOp>(d_ptr->m_funcs[163])(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
}

void QVulkanDeviceFunctions::vkCmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    Q_ASSERT(d_ptr->m_funcs[164]);
    reinterpret_cast<PFN_vkCmdSetRasterizerDiscardEnable>(d_ptr->m_funcs[164])(commandBuffer, rasterizerDiscardEnable);
}

void QVulkanDeviceFunctions::vkCmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    Q_ASSERT(d_ptr->m_funcs[165]);
    reinterpret_cast<PFN_vkCmdSetDepthBiasEnable>(d_ptr->m_funcs[165])(commandBuffer, depthBiasEnable);
}

void QVulkanDeviceFunctions::vkCmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    Q_ASSERT(d_ptr->m_funcs[166]);
    reinterpret_cast<PFN_vkCmdSetPrimitiveRestartEnable>(d_ptr->m_funcs[166])(commandBuffer, primitiveRestartEnable);
}

VkResult QVulkanDeviceFunctions::vkCreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo *pCreateInfo, const VkAllocationCallbacks *pAllocator, VkPrivateDataSlot *pPrivateDataSlot)
{
    Q_ASSERT(d_ptr->m_funcs[167]);
    return reinterpret_cast<PFN_vkCreatePrivateDataSlot>(d_ptr->m_funcs[167])(device, pCreateInfo, pAllocator, pPrivateDataSlot);
}

void QVulkanDeviceFunctions::vkDestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks *pAllocator)
{
    Q_ASSERT(d_ptr->m_funcs[168]);
    reinterpret_cast<PFN_vkDestroyPrivateDataSlot>(d_ptr->m_funcs[168])(device, privateDataSlot, pAllocator);
}

VkResult QVulkanDeviceFunctions::vkSetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    Q_ASSERT(d_ptr->m_funcs[169]);
    return reinterpret_cast<PFN_vkSetPrivateData>(d_ptr->m_funcs[169])(device, objectType, objectHandle, privateDataSlot, data);
}

void QVulkanDeviceFunctions::vkGetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t *pData)
{
    Q_ASSERT(d_ptr->m_funcs[170]);
    reinterpret_cast<PFN_vkGetPrivateData>(d_ptr->m_funcs[170])(device, objectType, objectHandle, privateDataSlot, pData);
}

void QVulkanDeviceFunctions::vkCmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2 *pCopyBufferInfo)
{
    Q_ASSERT(d_ptr->m_funcs[171]);
    reinterpret_cast<PFN_vkCmdCopyBuffer2>(d_ptr->m_funcs[171])(commandBuffer, pCopyBufferInfo);
}

void QVulkanDeviceFunctions::vkCmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2 *pCopyImageInfo)
{
    Q_ASSERT(d_ptr->m_funcs[172]);
    reinterpret_cast<PFN_vkCmdCopyImage2>(d_ptr->m_funcs[172])(commandBuffer, pCopyImageInfo);
}

void QVulkanDeviceFunctions::vkCmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2 *pBlitImageInfo)
{
    Q_ASSERT(d_ptr->m_funcs[173]);
    reinterpret_cast<PFN_vkCmdBlitImage2>(d_ptr->m_funcs[173])(commandBuffer, pBlitImageInfo);
}

void QVulkanDeviceFunctions::vkCmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2 *pCopyBufferToImageInfo)
{
    Q_ASSERT(d_ptr->m_funcs[174]);
    reinterpret_cast<PFN_vkCmdCopyBufferToImage2>(d_ptr->m_funcs[174])(commandBuffer, pCopyBufferToImageInfo);
}

void QVulkanDeviceFunctions::vkCmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2 *pCopyImageToBufferInfo)
{
    Q_ASSERT(d_ptr->m_funcs[175]);
    reinterpret_cast<PFN_vkCmdCopyImageToBuffer2>(d_ptr->m_funcs[175])(commandBuffer, pCopyImageToBufferInfo);
}

void QVulkanDeviceFunctions::vkCmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2 *pResolveImageInfo)
{
    Q_ASSERT(d_ptr->m_funcs[176]);
    reinterpret_cast<PFN_vkCmdResolveImage2>(d_ptr->m_funcs[176])(commandBuffer, pResolveImageInfo);
}

void QVulkanDeviceFunctions::vkCmdSetEvent2(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo *pDependencyInfo)
{
    Q_ASSERT(d_ptr->m_funcs[177]);
    reinterpret_cast<PFN_vkCmdSetEvent2>(d_ptr->m_funcs[177])(commandBuffer, event, pDependencyInfo);
}

void QVulkanDeviceFunctions::vkCmdResetEvent2(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask)
{
    Q_ASSERT(d_ptr->m_funcs[178]);
    reinterpret_cast<PFN_vkCmdResetEvent2>(d_ptr->m_funcs[178])(commandBuffer, event, stageMask);
}

void QVulkanDeviceFunctions::vkCmdWaitEvents2(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent *pEvents, const VkDependencyInfo *pDependencyInfos)
{
    Q_ASSERT(d_ptr->m_funcs[179]);
    reinterpret_cast<PFN_vkCmdWaitEvents2>(d_ptr->m_funcs[179])(commandBuffer, eventCount, pEvents, pDependencyInfos);
}

void QVulkanDeviceFunctions::vkCmdPipelineBarrier2(VkCommandBuffer commandBuffer, const VkDependencyInfo *pDependencyInfo)
{
    Q_ASSERT(d_ptr->m_funcs[180]);
    reinterpret_cast<PFN_vkCmdPipelineBarrier2>(d_ptr->m_funcs[180])(commandBuffer, pDependencyInfo);
}

VkResult QVulkanDeviceFunctions::vkQueueSubmit2(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2 *pSubmits, VkFence fence)
{
    Q_ASSERT(d_ptr->m_funcs[181]);
    return reinterpret_cast<PFN_vkQueueSubmit2>(d_ptr->m_funcs[181])(queue, submitCount, pSubmits, fence);
}

void QVulkanDeviceFunctions::vkCmdWriteTimestamp2(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query)
{
    Q_ASSERT(d_ptr->m_funcs[182]);
    reinterpret_cast<PFN_vkCmdWriteTimestamp2>(d_ptr->m_funcs[182])(commandBuffer, stage, queryPool, query);
}

void QVulkanDeviceFunctions::vkCmdBeginRendering(VkCommandBuffer commandBuffer, const VkRenderingInfo *pRenderingInfo)
{
    Q_ASSERT(d_ptr->m_funcs[183]);
    reinterpret_cast<PFN_vkCmdBeginRendering>(d_ptr->m_funcs[183])(commandBuffer, pRenderingInfo);
}

void QVulkanDeviceFunctions::vkCmdEndRendering(VkCommandBuffer commandBuffer)
{
    Q_ASSERT(d_ptr->m_funcs[184]);
    reinterpret_cast<PFN_vkCmdEndRendering>(d_ptr->m_funcs[184])(commandBuffer);
}

#endif


#if VK_VERSION_1_4
void QVulkanDeviceFunctions::vkGetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo *pRenderingAreaInfo, VkExtent2D *pGranularity)
{
    Q_ASSERT(d_ptr->m_funcs[185]);
    reinterpret_cast<PFN_vkGetRenderingAreaGranularity>(d_ptr->m_funcs[185])(device, pRenderingAreaInfo, pGranularity);
}

void QVulkanDeviceFunctions::vkCmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet *pDescriptorWrites)
{
    Q_ASSERT(d_ptr->m_funcs[186]);
    reinterpret_cast<PFN_vkCmdPushDescriptorSet>(d_ptr->m_funcs[186])(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
}

void QVulkanDeviceFunctions::vkCmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void *pData)
{
    Q_ASSERT(d_ptr->m_funcs[187]);
    reinterpret_cast<PFN_vkCmdPushDescriptorSetWithTemplate>(d_ptr->m_funcs[187])(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
}

void QVulkanDeviceFunctions::vkCmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    Q_ASSERT(d_ptr->m_funcs[188]);
    reinterpret_cast<PFN_vkCmdSetLineStipple>(d_ptr->m_funcs[188])(commandBuffer, lineStippleFactor, lineStipplePattern);
}

void QVulkanDeviceFunctions::vkCmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    Q_ASSERT(d_ptr->m_funcs[189]);
    reinterpret_cast<PFN_vkCmdBindIndexBuffer2>(d_ptr->m_funcs[189])(commandBuffer, buffer, offset, size, indexType);
}

VkResult QVulkanDeviceFunctions::vkCopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo *pCopyMemoryToImageInfo)
{
    Q_ASSERT(d_ptr->m_funcs[190]);
    return reinterpret_cast<PFN_vkCopyMemoryToImage>(d_ptr->m_funcs[190])(device, pCopyMemoryToImageInfo);
}

VkResult QVulkanDeviceFunctions::vkCopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo *pCopyImageToMemoryInfo)
{
    Q_ASSERT(d_ptr->m_funcs[191]);
    return reinterpret_cast<PFN_vkCopyImageToMemory>(d_ptr->m_funcs[191])(device, pCopyImageToMemoryInfo);
}

VkResult QVulkanDeviceFunctions::vkCopyImageToImage(VkDevice device, const VkCopyImageToImageInfo *pCopyImageToImageInfo)
{
    Q_ASSERT(d_ptr->m_funcs[192]);
    return reinterpret_cast<PFN_vkCopyImageToImage>(d_ptr->m_funcs[192])(device, pCopyImageToImageInfo);
}

VkResult QVulkanDeviceFunctions::vkTransitionImageLayout(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo *pTransitions)
{
    Q_ASSERT(d_ptr->m_funcs[193]);
    return reinterpret_cast<PFN_vkTransitionImageLayout>(d_ptr->m_funcs[193])(device, transitionCount, pTransitions);
}

void QVulkanDeviceFunctions::vkGetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2 *pSubresource, VkSubresourceLayout2 *pLayout)
{
    Q_ASSERT(d_ptr->m_funcs[194]);
    reinterpret_cast<PFN_vkGetImageSubresourceLayout2>(d_ptr->m_funcs[194])(device, image, pSubresource, pLayout);
}

void QVulkanDeviceFunctions::vkGetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo *pInfo, VkSubresourceLayout2 *pLayout)
{
    Q_ASSERT(d_ptr->m_funcs[195]);
    reinterpret_cast<PFN_vkGetDeviceImageSubresourceLayout>(d_ptr->m_funcs[195])(device, pInfo, pLayout);
}

VkResult QVulkanDeviceFunctions::vkMapMemory2(VkDevice device, const VkMemoryMapInfo *pMemoryMapInfo, void **ppData)
{
    Q_ASSERT(d_ptr->m_funcs[196]);
    return reinterpret_cast<PFN_vkMapMemory2>(d_ptr->m_funcs[196])(device, pMemoryMapInfo, ppData);
}

VkResult QVulkanDeviceFunctions::vkUnmapMemory2(VkDevice device, const VkMemoryUnmapInfo *pMemoryUnmapInfo)
{
    Q_ASSERT(d_ptr->m_funcs[197]);
    return reinterpret_cast<PFN_vkUnmapMemory2>(d_ptr->m_funcs[197])(device, pMemoryUnmapInfo);
}

void QVulkanDeviceFunctions::vkCmdBindDescriptorSets2(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo *pBindDescriptorSetsInfo)
{
    Q_ASSERT(d_ptr->m_funcs[198]);
    reinterpret_cast<PFN_vkCmdBindDescriptorSets2>(d_ptr->m_funcs[198])(commandBuffer, pBindDescriptorSetsInfo);
}

void QVulkanDeviceFunctions::vkCmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo *pPushConstantsInfo)
{
    Q_ASSERT(d_ptr->m_funcs[199]);
    reinterpret_cast<PFN_vkCmdPushConstants2>(d_ptr->m_funcs[199])(commandBuffer, pPushConstantsInfo);
}

void QVulkanDeviceFunctions::vkCmdPushDescriptorSet2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo *pPushDescriptorSetInfo)
{
    Q_ASSERT(d_ptr->m_funcs[200]);
    reinterpret_cast<PFN_vkCmdPushDescriptorSet2>(d_ptr->m_funcs[200])(commandBuffer, pPushDescriptorSetInfo);
}

void QVulkanDeviceFunctions::vkCmdPushDescriptorSetWithTemplate2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo *pPushDescriptorSetWithTemplateInfo)
{
    Q_ASSERT(d_ptr->m_funcs[201]);
    reinterpret_cast<PFN_vkCmdPushDescriptorSetWithTemplate2>(d_ptr->m_funcs[201])(commandBuffer, pPushDescriptorSetWithTemplateInfo);
}

void QVulkanDeviceFunctions::vkCmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo *pLocationInfo)
{
    Q_ASSERT(d_ptr->m_funcs[202]);
    reinterpret_cast<PFN_vkCmdSetRenderingAttachmentLocations>(d_ptr->m_funcs[202])(commandBuffer, pLocationInfo);
}

void QVulkanDeviceFunctions::vkCmdSetRenderingInputAttachmentIndices(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo *pInputAttachmentIndexInfo)
{
    Q_ASSERT(d_ptr->m_funcs[203]);
    reinterpret_cast<PFN_vkCmdSetRenderingInputAttachmentIndices>(d_ptr->m_funcs[203])(commandBuffer, pInputAttachmentIndexInfo);
}

#endif

QVulkanDeviceFunctionsPrivate::QVulkanDeviceFunctionsPrivate(QVulkanInstance *inst, VkDevice device)
{
    QVulkanFunctions *f = inst->functions();
    Q_ASSERT(f);

    static constexpr auto funcNames = qOffsetStringArray(
        "vkDestroyDevice",
        "vkGetDeviceQueue",
        "vkQueueSubmit",
        "vkQueueWaitIdle",
        "vkDeviceWaitIdle",
        "vkAllocateMemory",
        "vkFreeMemory",
        "vkMapMemory",
        "vkUnmapMemory",
        "vkFlushMappedMemoryRanges",
        "vkInvalidateMappedMemoryRanges",
        "vkGetDeviceMemoryCommitment",
        "vkGetBufferMemoryRequirements",
        "vkBindBufferMemory",
        "vkGetImageMemoryRequirements",
        "vkBindImageMemory",
        "vkGetImageSparseMemoryRequirements",
        "vkQueueBindSparse",
        "vkCreateFence",
        "vkDestroyFence",
        "vkResetFences",
        "vkGetFenceStatus",
        "vkWaitForFences",
        "vkCreateSemaphore",
        "vkDestroySemaphore",
        "vkCreateEvent",
        "vkDestroyEvent",
        "vkGetEventStatus",
        "vkSetEvent",
        "vkResetEvent",
        "vkCreateQueryPool",
        "vkDestroyQueryPool",
        "vkGetQueryPoolResults",
        "vkCreateBuffer",
        "vkDestroyBuffer",
        "vkCreateBufferView",
        "vkDestroyBufferView",
        "vkCreateImage",
        "vkDestroyImage",
        "vkGetImageSubresourceLayout",
        "vkCreateImageView",
        "vkDestroyImageView",
        "vkCreateShaderModule",
        "vkDestroyShaderModule",
        "vkCreatePipelineCache",
        "vkDestroyPipelineCache",
        "vkGetPipelineCacheData",
        "vkMergePipelineCaches",
        "vkCreateGraphicsPipelines",
        "vkCreateComputePipelines",
        "vkDestroyPipeline",
        "vkCreatePipelineLayout",
        "vkDestroyPipelineLayout",
        "vkCreateSampler",
        "vkDestroySampler",
        "vkCreateDescriptorSetLayout",
        "vkDestroyDescriptorSetLayout",
        "vkCreateDescriptorPool",
        "vkDestroyDescriptorPool",
        "vkResetDescriptorPool",
        "vkAllocateDescriptorSets",
        "vkFreeDescriptorSets",
        "vkUpdateDescriptorSets",
        "vkCreateFramebuffer",
        "vkDestroyFramebuffer",
        "vkCreateRenderPass",
        "vkDestroyRenderPass",
        "vkGetRenderAreaGranularity",
        "vkCreateCommandPool",
        "vkDestroyCommandPool",
        "vkResetCommandPool",
        "vkAllocateCommandBuffers",
        "vkFreeCommandBuffers",
        "vkBeginCommandBuffer",
        "vkEndCommandBuffer",
        "vkResetCommandBuffer",
        "vkCmdBindPipeline",
        "vkCmdSetViewport",
        "vkCmdSetScissor",
        "vkCmdSetLineWidth",
        "vkCmdSetDepthBias",
        "vkCmdSetBlendConstants",
        "vkCmdSetDepthBounds",
        "vkCmdSetStencilCompareMask",
        "vkCmdSetStencilWriteMask",
        "vkCmdSetStencilReference",
        "vkCmdBindDescriptorSets",
        "vkCmdBindIndexBuffer",
        "vkCmdBindVertexBuffers",
        "vkCmdDraw",
        "vkCmdDrawIndexed",
        "vkCmdDrawIndirect",
        "vkCmdDrawIndexedIndirect",
        "vkCmdDispatch",
        "vkCmdDispatchIndirect",
        "vkCmdCopyBuffer",
        "vkCmdCopyImage",
        "vkCmdBlitImage",
        "vkCmdCopyBufferToImage",
        "vkCmdCopyImageToBuffer",
        "vkCmdUpdateBuffer",
        "vkCmdFillBuffer",
        "vkCmdClearColorImage",
        "vkCmdClearDepthStencilImage",
        "vkCmdClearAttachments",
        "vkCmdResolveImage",
        "vkCmdSetEvent",
        "vkCmdResetEvent",
        "vkCmdWaitEvents",
        "vkCmdPipelineBarrier",
        "vkCmdBeginQuery",
        "vkCmdEndQuery",
        "vkCmdResetQueryPool",
        "vkCmdWriteTimestamp",
        "vkCmdCopyQueryPoolResults",
        "vkCmdPushConstants",
        "vkCmdBeginRenderPass",
        "vkCmdNextSubpass",
        "vkCmdEndRenderPass",
        "vkCmdExecuteCommands",
        "vkTrimCommandPool",
        "vkGetDeviceGroupPeerMemoryFeatures",
        "vkBindBufferMemory2",
        "vkBindImageMemory2",
        "vkCmdSetDeviceMask",
        "vkCmdDispatchBase",
        "vkCreateDescriptorUpdateTemplate",
        "vkDestroyDescriptorUpdateTemplate",
        "vkUpdateDescriptorSetWithTemplate",
        "vkGetBufferMemoryRequirements2",
        "vkGetImageMemoryRequirements2",
        "vkGetImageSparseMemoryRequirements2",
        "vkCreateSamplerYcbcrConversion",
        "vkDestroySamplerYcbcrConversion",
        "vkGetDeviceQueue2",
        "vkGetDescriptorSetLayoutSupport",
        "vkResetQueryPool",
        "vkCreateRenderPass2",
        "vkCmdBeginRenderPass2",
        "vkCmdNextSubpass2",
        "vkCmdEndRenderPass2",
        "vkGetSemaphoreCounterValue",
        "vkWaitSemaphores",
        "vkSignalSemaphore",
        "vkCmdDrawIndirectCount",
        "vkCmdDrawIndexedIndirectCount",
        "vkGetBufferOpaqueCaptureAddress",
        "vkGetBufferDeviceAddress",
        "vkGetDeviceMemoryOpaqueCaptureAddress",
        "vkGetDeviceBufferMemoryRequirements",
        "vkGetDeviceImageMemoryRequirements",
        "vkGetDeviceImageSparseMemoryRequirements",
        "vkCmdSetCullMode",
        "vkCmdSetFrontFace",
        "vkCmdSetPrimitiveTopology",
        "vkCmdSetViewportWithCount",
        "vkCmdSetScissorWithCount",
        "vkCmdBindVertexBuffers2",
        "vkCmdSetDepthTestEnable",
        "vkCmdSetDepthWriteEnable",
        "vkCmdSetDepthCompareOp",
        "vkCmdSetDepthBoundsTestEnable",
        "vkCmdSetStencilTestEnable",
        "vkCmdSetStencilOp",
        "vkCmdSetRasterizerDiscardEnable",
        "vkCmdSetDepthBiasEnable",
        "vkCmdSetPrimitiveRestartEnable",
        "vkCreatePrivateDataSlot",
        "vkDestroyPrivateDataSlot",
        "vkSetPrivateData",
        "vkGetPrivateData",
        "vkCmdCopyBuffer2",
        "vkCmdCopyImage2",
        "vkCmdBlitImage2",
        "vkCmdCopyBufferToImage2",
        "vkCmdCopyImageToBuffer2",
        "vkCmdResolveImage2",
        "vkCmdSetEvent2",
        "vkCmdResetEvent2",
        "vkCmdWaitEvents2",
        "vkCmdPipelineBarrier2",
        "vkQueueSubmit2",
        "vkCmdWriteTimestamp2",
        "vkCmdBeginRendering",
        "vkCmdEndRendering",
        "vkGetRenderingAreaGranularity",
        "vkCmdPushDescriptorSet",
        "vkCmdPushDescriptorSetWithTemplate",
        "vkCmdSetLineStipple",
        "vkCmdBindIndexBuffer2",
        "vkCopyMemoryToImage",
        "vkCopyImageToMemory",
        "vkCopyImageToImage",
        "vkTransitionImageLayout",
        "vkGetImageSubresourceLayout2",
        "vkGetDeviceImageSubresourceLayout",
        "vkMapMemory2",
        "vkUnmapMemory2",
        "vkCmdBindDescriptorSets2",
        "vkCmdPushConstants2",
        "vkCmdPushDescriptorSet2",
        "vkCmdPushDescriptorSetWithTemplate2",
        "vkCmdSetRenderingAttachmentLocations",
        "vkCmdSetRenderingInputAttachmentIndices"
    );
    static_assert(std::extent_v<decltype(m_funcs)> == size_t(funcNames.count()));
    for (int i = 0; i < funcNames.count(); ++i) {
        m_funcs[i] = f->vkGetDeviceProcAddr(device, funcNames.at(i));
        if (i < 120 && !m_funcs[i])
            qWarning("QVulkanDeviceFunctions: Failed to resolve %s", funcNames.at(i));
    }
}

QT_END_NAMESPACE
