// ui/ozone/public/mojom/gesture_properties_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_SHARED_H_
#define UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace ui {
namespace ozone {
namespace mojom {
class GesturePropValueDataView;


}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::ozone::mojom::GesturePropValueDataView> {
  using Data = ::ui::ozone::mojom::internal::GesturePropValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace ui {
namespace ozone {
namespace mojom {


enum class SetGesturePropErrorCode : int32_t {
  
  SUCCESS = 0,
  
  UNKNOWN_ERROR = 1,
  
  NOT_FOUND = 2,
  
  READ_ONLY = 3,
  
  TYPE_MISMATCH = 4,
  
  SIZE_MISMATCH = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SetGesturePropErrorCode value);
inline bool IsKnownEnumValue(SetGesturePropErrorCode value) {
  return internal::SetGesturePropErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class GesturePropertiesServiceInterfaceBase {};

using GesturePropertiesServicePtrDataView =
    mojo::InterfacePtrDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceRequestDataView =
    mojo::InterfaceRequestDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GesturePropertiesServiceInterfaceBase>;


class GesturePropValueDataView {
 public:
  using Tag = internal::GesturePropValue_Data::GesturePropValue_Tag;

  GesturePropValueDataView() {}

  GesturePropValueDataView(
      internal::GesturePropValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_ints() const { return data_->tag == Tag::INTS; }
  inline void GetIntsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInts(UserType* output) {
    
    DCHECK(is_ints());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        data_->data.f_ints.Get(), output, context_);
  }
  bool is_shorts() const { return data_->tag == Tag::SHORTS; }
  inline void GetShortsDataView(
      mojo::ArrayDataView<int16_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShorts(UserType* output) {
    
    DCHECK(is_shorts());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int16_t>>(
        data_->data.f_shorts.Get(), output, context_);
  }
  bool is_bools() const { return data_->tag == Tag::BOOLS; }
  inline void GetBoolsDataView(
      mojo::ArrayDataView<bool>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBools(UserType* output) {
    
    DCHECK(is_bools());
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        data_->data.f_bools.Get(), output, context_);
  }
  bool is_str() const { return data_->tag == Tag::STR; }
  inline void GetStrDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStr(UserType* output) {
    
    DCHECK(is_str());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_str.Get(), output, context_);
  }
  bool is_reals() const { return data_->tag == Tag::REALS; }
  inline void GetRealsDataView(
      mojo::ArrayDataView<double>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReals(UserType* output) {
    
    DCHECK(is_reals());
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        data_->data.f_reals.Get(), output, context_);
  }

 private:
  internal::GesturePropValue_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace std {

template <>
struct hash<::ui::ozone::mojom::SetGesturePropErrorCode>
    : public mojo::internal::EnumHashImpl<::ui::ozone::mojom::SetGesturePropErrorCode> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::ui::ozone::mojom::SetGesturePropErrorCode, ::ui::ozone::mojom::SetGesturePropErrorCode> {
  static ::ui::ozone::mojom::SetGesturePropErrorCode ToMojom(::ui::ozone::mojom::SetGesturePropErrorCode input) { return input; }
  static bool FromMojom(::ui::ozone::mojom::SetGesturePropErrorCode input, ::ui::ozone::mojom::SetGesturePropErrorCode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::ozone::mojom::SetGesturePropErrorCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::ozone::mojom::SetGesturePropErrorCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ui::ozone::mojom::SetGesturePropErrorCode>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::ozone::mojom::GesturePropValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::ui::ozone::mojom::GesturePropValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ui::ozone::mojom::internal::GesturePropValue_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::ui::ozone::mojom::internal::GesturePropValue_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::INTS: {
        decltype(Traits::ints(input))
            in_ints = Traits::ints(input);
        typename decltype(result->data.f_ints)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams ints_validate_params(
            0, false, nullptr);
        mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
            in_ints, buffer, &value_writer, &ints_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null ints in GesturePropValue union");
        result->data.f_ints.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::SHORTS: {
        decltype(Traits::shorts(input))
            in_shorts = Traits::shorts(input);
        typename decltype(result->data.f_shorts)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams shorts_validate_params(
            0, false, nullptr);
        mojo::internal::Serialize<mojo::ArrayDataView<int16_t>>(
            in_shorts, buffer, &value_writer, &shorts_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shorts in GesturePropValue union");
        result->data.f_shorts.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::BOOLS: {
        decltype(Traits::bools(input))
            in_bools = Traits::bools(input);
        typename decltype(result->data.f_bools)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams bools_validate_params(
            0, false, nullptr);
        mojo::internal::Serialize<mojo::ArrayDataView<bool>>(
            in_bools, buffer, &value_writer, &bools_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null bools in GesturePropValue union");
        result->data.f_bools.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::STR: {
        decltype(Traits::str(input))
            in_str = Traits::str(input);
        typename decltype(result->data.f_str)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<mojo::StringDataView>(
            in_str, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null str in GesturePropValue union");
        result->data.f_str.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::REALS: {
        decltype(Traits::reals(input))
            in_reals = Traits::reals(input);
        typename decltype(result->data.f_reals)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams reals_validate_params(
            0, false, nullptr);
        mojo::internal::Serialize<mojo::ArrayDataView<double>>(
            in_reals, buffer, &value_writer, &reals_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null reals in GesturePropValue union");
        result->data.f_reals.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::ui::ozone::mojom::internal::GesturePropValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::ui::ozone::mojom::GesturePropValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui {
namespace ozone {
namespace mojom {

inline void GesturePropValueDataView::GetIntsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  DCHECK(is_ints());
  *output = mojo::ArrayDataView<int32_t>(data_->data.f_ints.Get(), context_);
}
inline void GesturePropValueDataView::GetShortsDataView(
    mojo::ArrayDataView<int16_t>* output) {
  DCHECK(is_shorts());
  *output = mojo::ArrayDataView<int16_t>(data_->data.f_shorts.Get(), context_);
}
inline void GesturePropValueDataView::GetBoolsDataView(
    mojo::ArrayDataView<bool>* output) {
  DCHECK(is_bools());
  *output = mojo::ArrayDataView<bool>(data_->data.f_bools.Get(), context_);
}
inline void GesturePropValueDataView::GetStrDataView(
    mojo::StringDataView* output) {
  DCHECK(is_str());
  *output = mojo::StringDataView(data_->data.f_str.Get(), context_);
}
inline void GesturePropValueDataView::GetRealsDataView(
    mojo::ArrayDataView<double>* output) {
  DCHECK(is_reals());
  *output = mojo::ArrayDataView<double>(data_->data.f_reals.Get(), context_);
}


}  // namespace mojom
}  // namespace ozone
}  // namespace ui

#endif  // UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_SHARED_H_