// third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/worker_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class SharedWorkerInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SharedWorkerInfoDataView> {
  using Data = ::blink::mojom::internal::SharedWorkerInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class SharedWorkerInfoDataView {
 public:
  SharedWorkerInfoDataView() {}

  SharedWorkerInfoDataView(
      internal::SharedWorkerInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetOptionsDataView(
      ::blink::mojom::WorkerOptionsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::WorkerOptionsDataView>(
        pointer, output, context_);
  }
  inline void GetContentSecurityPolicyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentSecurityPolicy(UserType* output) {
    
    auto* pointer = data_->content_security_policy.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentSecurityPolicyType(UserType* output) const {
    auto data_value = data_->content_security_policy_type;
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyType>(
        data_value, output);
  }

  ::network::mojom::ContentSecurityPolicyType content_security_policy_type() const {
    return static_cast<::network::mojom::ContentSecurityPolicyType>(data_->content_security_policy_type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCreationAddressSpace(UserType* output) const {
    auto data_value = data_->creation_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }

  ::network::mojom::IPAddressSpace creation_address_space() const {
    return static_cast<::network::mojom::IPAddressSpace>(data_->creation_address_space);
  }
  inline void GetOutsideFetchClientSettingsObjectDataView(
      ::blink::mojom::FetchClientSettingsObjectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOutsideFetchClientSettingsObject(UserType* output) {
    
    auto* pointer = data_->outside_fetch_client_settings_object.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchClientSettingsObjectDataView>(
        pointer, output, context_);
  }
 private:
  internal::SharedWorkerInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedWorkerInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedWorkerInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SharedWorkerInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in SharedWorkerInfo struct");
    decltype(Traits::options(input)) in_options = Traits::options(input);
    typename decltype((*output)->options)::BaseType::BufferWriter
        options_writer;
    mojo::internal::Serialize<::blink::mojom::WorkerOptionsDataView>(
        in_options, buffer, &options_writer, context);
    (*output)->options.Set(
        options_writer.is_null() ? nullptr : options_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in SharedWorkerInfo struct");
    decltype(Traits::content_security_policy(input)) in_content_security_policy = Traits::content_security_policy(input);
    typename decltype((*output)->content_security_policy)::BaseType::BufferWriter
        content_security_policy_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_content_security_policy, buffer, &content_security_policy_writer, context);
    (*output)->content_security_policy.Set(
        content_security_policy_writer.is_null() ? nullptr : content_security_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content_security_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_security_policy in SharedWorkerInfo struct");
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyType>(
        Traits::content_security_policy_type(input), &(*output)->content_security_policy_type);
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::creation_address_space(input), &(*output)->creation_address_space);
    decltype(Traits::outside_fetch_client_settings_object(input)) in_outside_fetch_client_settings_object = Traits::outside_fetch_client_settings_object(input);
    typename decltype((*output)->outside_fetch_client_settings_object)::BaseType::BufferWriter
        outside_fetch_client_settings_object_writer;
    mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
        in_outside_fetch_client_settings_object, buffer, &outside_fetch_client_settings_object_writer, context);
    (*output)->outside_fetch_client_settings_object.Set(
        outside_fetch_client_settings_object_writer.is_null() ? nullptr : outside_fetch_client_settings_object_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->outside_fetch_client_settings_object.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null outside_fetch_client_settings_object in SharedWorkerInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::SharedWorkerInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedWorkerInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void SharedWorkerInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void SharedWorkerInfoDataView::GetOptionsDataView(
    ::blink::mojom::WorkerOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = ::blink::mojom::WorkerOptionsDataView(pointer, context_);
}
inline void SharedWorkerInfoDataView::GetContentSecurityPolicyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_security_policy.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SharedWorkerInfoDataView::GetOutsideFetchClientSettingsObjectDataView(
    ::blink::mojom::FetchClientSettingsObjectDataView* output) {
  auto pointer = data_->outside_fetch_client_settings_object.Get();
  *output = ::blink::mojom::FetchClientSettingsObjectDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SHARED_H_