// third_party/blink/public/mojom/window_features/window_features.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WINDOW_FEATURES_WINDOW_FEATURES_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WINDOW_FEATURES_WINDOW_FEATURES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-forward.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {








class BLINK_COMMON_EXPORT WindowFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WindowFeatures, T>::value>;
  using DataView = WindowFeaturesDataView;
  using Data_ = internal::WindowFeatures_Data;

  template <typename... Args>
  static WindowFeaturesPtr New(Args&&... args) {
    return WindowFeaturesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WindowFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<WindowFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WindowFeatures>::Convert(*this);
  }


  WindowFeatures();

  WindowFeatures(
      float x,
      bool has_x,
      float y,
      bool has_y,
      float width,
      bool has_width,
      float height,
      bool has_height,
      bool menu_bar_visible,
      bool status_bar_visible,
      bool tool_bar_visible,
      bool scrollbars_visible);

  ~WindowFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WindowFeaturesPtr>
  WindowFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WindowFeatures::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WindowFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WindowFeatures_UnserializedMessageContext<
            UserType, WindowFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WindowFeatures::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return WindowFeatures::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WindowFeatures_UnserializedMessageContext<
            UserType, WindowFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WindowFeatures::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float x;
  
  bool has_x;
  
  float y;
  
  bool has_y;
  
  float width;
  
  bool has_width;
  
  float height;
  
  bool has_height;
  
  bool menu_bar_visible;
  
  bool status_bar_visible;
  
  bool tool_bar_visible;
  
  bool scrollbars_visible;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WindowFeaturesPtr WindowFeatures::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(has_x),
      mojo::Clone(y),
      mojo::Clone(has_y),
      mojo::Clone(width),
      mojo::Clone(has_width),
      mojo::Clone(height),
      mojo::Clone(has_height),
      mojo::Clone(menu_bar_visible),
      mojo::Clone(status_bar_visible),
      mojo::Clone(tool_bar_visible),
      mojo::Clone(scrollbars_visible)
  );
}

template <typename T, WindowFeatures::EnableIfSame<T>*>
bool WindowFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->has_x, other_struct.has_x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->has_y, other_struct.has_y))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->has_width, other_struct.has_width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->has_height, other_struct.has_height))
    return false;
  if (!mojo::Equals(this->menu_bar_visible, other_struct.menu_bar_visible))
    return false;
  if (!mojo::Equals(this->status_bar_visible, other_struct.status_bar_visible))
    return false;
  if (!mojo::Equals(this->tool_bar_visible, other_struct.tool_bar_visible))
    return false;
  if (!mojo::Equals(this->scrollbars_visible, other_struct.scrollbars_visible))
    return false;
  return true;
}

template <typename T, WindowFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.x, rhs.x))
    return true;
  if (std::less<>{}(rhs.x, lhs.x))
    return false;
  if (std::less<>{}(lhs.has_x, rhs.has_x))
    return true;
  if (std::less<>{}(rhs.has_x, lhs.has_x))
    return false;
  if (std::less<>{}(lhs.y, rhs.y))
    return true;
  if (std::less<>{}(rhs.y, lhs.y))
    return false;
  if (std::less<>{}(lhs.has_y, rhs.has_y))
    return true;
  if (std::less<>{}(rhs.has_y, lhs.has_y))
    return false;
  if (std::less<>{}(lhs.width, rhs.width))
    return true;
  if (std::less<>{}(rhs.width, lhs.width))
    return false;
  if (std::less<>{}(lhs.has_width, rhs.has_width))
    return true;
  if (std::less<>{}(rhs.has_width, lhs.has_width))
    return false;
  if (std::less<>{}(lhs.height, rhs.height))
    return true;
  if (std::less<>{}(rhs.height, lhs.height))
    return false;
  if (std::less<>{}(lhs.has_height, rhs.has_height))
    return true;
  if (std::less<>{}(rhs.has_height, lhs.has_height))
    return false;
  if (std::less<>{}(lhs.menu_bar_visible, rhs.menu_bar_visible))
    return true;
  if (std::less<>{}(rhs.menu_bar_visible, lhs.menu_bar_visible))
    return false;
  if (std::less<>{}(lhs.status_bar_visible, rhs.status_bar_visible))
    return true;
  if (std::less<>{}(rhs.status_bar_visible, lhs.status_bar_visible))
    return false;
  if (std::less<>{}(lhs.tool_bar_visible, rhs.tool_bar_visible))
    return true;
  if (std::less<>{}(rhs.tool_bar_visible, lhs.tool_bar_visible))
    return false;
  if (std::less<>{}(lhs.scrollbars_visible, rhs.scrollbars_visible))
    return true;
  if (std::less<>{}(rhs.scrollbars_visible, lhs.scrollbars_visible))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WindowFeatures::DataView,
                                         ::blink::mojom::WindowFeaturesPtr> {
  static bool IsNull(const ::blink::mojom::WindowFeaturesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WindowFeaturesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::WindowFeatures::x) x(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->x;
  }

  static decltype(::blink::mojom::WindowFeatures::has_x) has_x(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->has_x;
  }

  static decltype(::blink::mojom::WindowFeatures::y) y(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->y;
  }

  static decltype(::blink::mojom::WindowFeatures::has_y) has_y(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->has_y;
  }

  static decltype(::blink::mojom::WindowFeatures::width) width(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->width;
  }

  static decltype(::blink::mojom::WindowFeatures::has_width) has_width(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->has_width;
  }

  static decltype(::blink::mojom::WindowFeatures::height) height(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->height;
  }

  static decltype(::blink::mojom::WindowFeatures::has_height) has_height(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->has_height;
  }

  static decltype(::blink::mojom::WindowFeatures::menu_bar_visible) menu_bar_visible(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->menu_bar_visible;
  }

  static decltype(::blink::mojom::WindowFeatures::status_bar_visible) status_bar_visible(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->status_bar_visible;
  }

  static decltype(::blink::mojom::WindowFeatures::tool_bar_visible) tool_bar_visible(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->tool_bar_visible;
  }

  static decltype(::blink::mojom::WindowFeatures::scrollbars_visible) scrollbars_visible(
      const ::blink::mojom::WindowFeaturesPtr& input) {
    return input->scrollbars_visible;
  }

  static bool Read(::blink::mojom::WindowFeatures::DataView input, ::blink::mojom::WindowFeaturesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WINDOW_FEATURES_WINDOW_FEATURES_MOJOM_H_