// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-params-data.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
ScrollAlignment::ScrollAlignment()
    : rect_visible(ScrollAlignment_Behavior::kNoScroll),
      rect_hidden(ScrollAlignment_Behavior::kCenter),
      rect_partial(ScrollAlignment_Behavior::kClosestEdge) {}

ScrollAlignment::ScrollAlignment(
    ScrollAlignment::Behavior rect_visible_in,
    ScrollAlignment::Behavior rect_hidden_in,
    ScrollAlignment::Behavior rect_partial_in)
    : rect_visible(std::move(rect_visible_in)),
      rect_hidden(std::move(rect_hidden_in)),
      rect_partial(std::move(rect_partial_in)) {}

ScrollAlignment::~ScrollAlignment() = default;
size_t ScrollAlignment::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->rect_visible);
  seed = mojo::internal::WTFHash(seed, this->rect_hidden);
  seed = mojo::internal::WTFHash(seed, this->rect_partial);
  return seed;
}

void ScrollAlignment::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("rect_visible", base::trace_event::ValueToString(this->rect_visible));
  value->SetString("rect_hidden", base::trace_event::ValueToString(this->rect_hidden));
  value->SetString("rect_partial", base::trace_event::ValueToString(this->rect_partial));
}

bool ScrollAlignment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollIntoViewParams::ScrollIntoViewParams()
    : align_x(),
      align_y(),
      type(::blink::mojom::blink::ScrollType::kProgrammatic),
      make_visible_in_visual_viewport(true),
      behavior(::blink::mojom::blink::ScrollBehavior::kAuto),
      is_for_scroll_sequence(false),
      zoom_into_rect(false),
      relative_element_bounds(),
      relative_caret_bounds(),
      stop_at_main_frame_layout_viewport(false) {}

ScrollIntoViewParams::ScrollIntoViewParams(
    ScrollAlignmentPtr align_x_in,
    ScrollAlignmentPtr align_y_in,
    ::blink::mojom::blink::ScrollType type_in,
    bool make_visible_in_visual_viewport_in,
    ::blink::mojom::blink::ScrollBehavior behavior_in,
    bool is_for_scroll_sequence_in,
    bool zoom_into_rect_in,
    const ::gfx::RectF& relative_element_bounds_in,
    const ::gfx::RectF& relative_caret_bounds_in,
    bool stop_at_main_frame_layout_viewport_in)
    : align_x(std::move(align_x_in)),
      align_y(std::move(align_y_in)),
      type(std::move(type_in)),
      make_visible_in_visual_viewport(std::move(make_visible_in_visual_viewport_in)),
      behavior(std::move(behavior_in)),
      is_for_scroll_sequence(std::move(is_for_scroll_sequence_in)),
      zoom_into_rect(std::move(zoom_into_rect_in)),
      relative_element_bounds(std::move(relative_element_bounds_in)),
      relative_caret_bounds(std::move(relative_caret_bounds_in)),
      stop_at_main_frame_layout_viewport(std::move(stop_at_main_frame_layout_viewport_in)) {}

ScrollIntoViewParams::~ScrollIntoViewParams() = default;

void ScrollIntoViewParams::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->align_x.is_null()) {
    value->SetString("align_x", "nullptr");
  } else {
    value->BeginDictionary("align_x");
    this->align_x->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->align_y.is_null()) {
    value->SetString("align_y", "nullptr");
  } else {
    value->BeginDictionary("align_y");
    this->align_y->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetBoolean("make_visible_in_visual_viewport", this->make_visible_in_visual_viewport);
  value->SetString("behavior", base::trace_event::ValueToString(this->behavior));
  value->SetBoolean("is_for_scroll_sequence", this->is_for_scroll_sequence);
  value->SetBoolean("zoom_into_rect", this->zoom_into_rect);
  value->SetString("relative_element_bounds", base::trace_event::ValueToString(this->relative_element_bounds, "<value of type const ::gfx::RectF&>"));
  value->SetString("relative_caret_bounds", base::trace_event::ValueToString(this->relative_caret_bounds, "<value of type const ::gfx::RectF&>"));
  value->SetBoolean("stop_at_main_frame_layout_viewport", this->stop_at_main_frame_layout_viewport);
}

bool ScrollIntoViewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ScrollAlignment::DataView, ::blink::mojom::blink::ScrollAlignmentPtr>::Read(
    ::blink::mojom::blink::ScrollAlignment::DataView input,
    ::blink::mojom::blink::ScrollAlignmentPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ScrollAlignmentPtr result(::blink::mojom::blink::ScrollAlignment::New());
  
      if (success && !input.ReadRectVisible(&result->rect_visible))
        success = false;
      if (success && !input.ReadRectHidden(&result->rect_hidden))
        success = false;
      if (success && !input.ReadRectPartial(&result->rect_partial))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ScrollIntoViewParams::DataView, ::blink::mojom::blink::ScrollIntoViewParamsPtr>::Read(
    ::blink::mojom::blink::ScrollIntoViewParams::DataView input,
    ::blink::mojom::blink::ScrollIntoViewParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ScrollIntoViewParamsPtr result(::blink::mojom::blink::ScrollIntoViewParams::New());
  
      if (success && !input.ReadAlignX(&result->align_x))
        success = false;
      if (success && !input.ReadAlignY(&result->align_y))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->make_visible_in_visual_viewport = input.make_visible_in_visual_viewport();
      if (success && !input.ReadBehavior(&result->behavior))
        success = false;
      if (success)
        result->is_for_scroll_sequence = input.is_for_scroll_sequence();
      if (success)
        result->zoom_into_rect = input.zoom_into_rect();
      if (success && !input.ReadRelativeElementBounds(&result->relative_element_bounds))
        success = false;
      if (success && !input.ReadRelativeCaretBounds(&result->relative_caret_bounds))
        success = false;
      if (success)
        result->stop_at_main_frame_layout_viewport = input.stop_at_main_frame_layout_viewport();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif