// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class PushSubscriptionOptionsDataView;

class PushSubscriptionDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PushSubscriptionOptionsDataView> {
  using Data = ::blink::mojom::internal::PushSubscriptionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PushSubscriptionDataView> {
  using Data = ::blink::mojom::internal::PushSubscription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class PushErrorType : int32_t {
  
  ABORT = 0,
  
  NETWORK = 1,
  
  NONE = 2,
  
  NOT_ALLOWED = 3,
  
  NOT_FOUND = 4,
  
  NOT_SUPPORTED = 5,
  
  INVALID_STATE = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PushErrorType value);
inline bool IsKnownEnumValue(PushErrorType value) {
  return internal::PushErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PushMessagingInterfaceBase {};

using PushMessagingPtrDataView =
    mojo::InterfacePtrDataView<PushMessagingInterfaceBase>;
using PushMessagingRequestDataView =
    mojo::InterfaceRequestDataView<PushMessagingInterfaceBase>;
using PushMessagingAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PushMessagingInterfaceBase>;
using PushMessagingAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PushMessagingInterfaceBase>;


class PushSubscriptionOptionsDataView {
 public:
  PushSubscriptionOptionsDataView() {}

  PushSubscriptionOptionsDataView(
      internal::PushSubscriptionOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool user_visible_only() const {
    return data_->user_visible_only;
  }
  inline void GetApplicationServerKeyDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadApplicationServerKey(UserType* output) {
    
    auto* pointer = data_->application_server_key.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::PushSubscriptionOptions_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PushSubscriptionDataView {
 public:
  PushSubscriptionDataView() {}

  PushSubscriptionDataView(
      internal::PushSubscription_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetEndpointDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEndpoint(UserType* output) {
    
    auto* pointer = data_->endpoint.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetExpirationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExpirationTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `expirationTime` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpirationTime` instead "
    "of `ReadExpirationTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expirationTime.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetOptionsDataView(
      PushSubscriptionOptionsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PushSubscriptionOptionsDataView>(
        pointer, output, context_);
  }
  inline void GetP256dhDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadP256dh(UserType* output) {
    
    auto* pointer = data_->p256dh.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetAuthDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAuth(UserType* output) {
    
    auto* pointer = data_->auth.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::PushSubscription_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::PushErrorType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PushErrorType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::PushErrorType, ::blink::mojom::PushErrorType> {
  static ::blink::mojom::PushErrorType ToMojom(::blink::mojom::PushErrorType input) { return input; }
  static bool FromMojom(::blink::mojom::PushErrorType input, ::blink::mojom::PushErrorType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PushErrorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PushErrorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PushErrorType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PushSubscriptionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PushSubscriptionOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PushSubscriptionOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->user_visible_only = Traits::user_visible_only(input);
    decltype(Traits::application_server_key(input)) in_application_server_key = Traits::application_server_key(input);
    typename decltype((*output)->application_server_key)::BaseType::BufferWriter
        application_server_key_writer;
    const mojo::internal::ContainerValidateParams application_server_key_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_application_server_key, buffer, &application_server_key_writer, &application_server_key_validate_params,
        context);
    (*output)->application_server_key.Set(
        application_server_key_writer.is_null() ? nullptr : application_server_key_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->application_server_key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null application_server_key in PushSubscriptionOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::PushSubscriptionOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PushSubscriptionOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PushSubscriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PushSubscriptionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PushSubscription_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::endpoint(input)) in_endpoint = Traits::endpoint(input);
    typename decltype((*output)->endpoint)::BaseType::BufferWriter
        endpoint_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_endpoint, buffer, &endpoint_writer, context);
    (*output)->endpoint.Set(
        endpoint_writer.is_null() ? nullptr : endpoint_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->endpoint.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null endpoint in PushSubscription struct");
    decltype(Traits::expirationTime(input)) in_expirationTime = Traits::expirationTime(input);
    typename decltype((*output)->expirationTime)::BaseType::BufferWriter
        expirationTime_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expirationTime, buffer, &expirationTime_writer, context);
    (*output)->expirationTime.Set(
        expirationTime_writer.is_null() ? nullptr : expirationTime_writer.data());
    decltype(Traits::options(input)) in_options = Traits::options(input);
    typename decltype((*output)->options)::BaseType::BufferWriter
        options_writer;
    mojo::internal::Serialize<::blink::mojom::PushSubscriptionOptionsDataView>(
        in_options, buffer, &options_writer, context);
    (*output)->options.Set(
        options_writer.is_null() ? nullptr : options_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in PushSubscription struct");
    decltype(Traits::p256dh(input)) in_p256dh = Traits::p256dh(input);
    typename decltype((*output)->p256dh)::BaseType::BufferWriter
        p256dh_writer;
    const mojo::internal::ContainerValidateParams p256dh_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_p256dh, buffer, &p256dh_writer, &p256dh_validate_params,
        context);
    (*output)->p256dh.Set(
        p256dh_writer.is_null() ? nullptr : p256dh_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->p256dh.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null p256dh in PushSubscription struct");
    decltype(Traits::auth(input)) in_auth = Traits::auth(input);
    typename decltype((*output)->auth)::BaseType::BufferWriter
        auth_writer;
    const mojo::internal::ContainerValidateParams auth_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_auth, buffer, &auth_writer, &auth_validate_params,
        context);
    (*output)->auth.Set(
        auth_writer.is_null() ? nullptr : auth_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->auth.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null auth in PushSubscription struct");
  }

  static bool Deserialize(::blink::mojom::internal::PushSubscription_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PushSubscriptionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void PushSubscriptionOptionsDataView::GetApplicationServerKeyDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->application_server_key.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}


inline void PushSubscriptionDataView::GetEndpointDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->endpoint.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void PushSubscriptionDataView::GetExpirationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expirationTime.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void PushSubscriptionDataView::GetOptionsDataView(
    PushSubscriptionOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = PushSubscriptionOptionsDataView(pointer, context_);
}
inline void PushSubscriptionDataView::GetP256dhDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->p256dh.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void PushSubscriptionDataView::GetAuthDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->auth.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_SHARED_H_