// third_party/blink/public/mojom/permissions/permission.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_PermissionName_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::PermissionName& value) {
    using utype = std::underlying_type<::blink::mojom::PermissionName>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::PermissionName& left, const ::blink::mojom::PermissionName& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::PermissionName>
    : public GenericHashTraits<::blink::mojom::PermissionName> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::PermissionName& value) {
    return value == static_cast<::blink::mojom::PermissionName>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::PermissionName& slot, bool) {
    slot = static_cast<::blink::mojom::PermissionName>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::PermissionName& value) {
    return value == static_cast<::blink::mojom::PermissionName>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class PermissionObserverProxy;

template <typename ImplRefTraits>
class PermissionObserverStub;

class PermissionObserverRequestValidator;


class PLATFORM_EXPORT PermissionObserver
    : public PermissionObserverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PermissionObserverInterfaceBase;
  using Proxy_ = PermissionObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PermissionObserverStub<ImplRefTraits>;

  using RequestValidator_ = PermissionObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPermissionStatusChangeMinVersion = 0,
  };
  virtual ~PermissionObserver() {}

  
  virtual void OnPermissionStatusChange(::blink::mojom::blink::PermissionStatus status) = 0;
};

class PermissionServiceProxy;

template <typename ImplRefTraits>
class PermissionServiceStub;

class PermissionServiceRequestValidator;
class PermissionServiceResponseValidator;


class PLATFORM_EXPORT PermissionService
    : public PermissionServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PermissionServiceInterfaceBase;
  using Proxy_ = PermissionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PermissionServiceStub<ImplRefTraits>;

  using RequestValidator_ = PermissionServiceRequestValidator;
  using ResponseValidator_ = PermissionServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasPermissionMinVersion = 0,
    kRequestPermissionMinVersion = 0,
    kRequestPermissionsMinVersion = 0,
    kRevokePermissionMinVersion = 0,
    kAddPermissionObserverMinVersion = 0,
  };
  virtual ~PermissionService() {}


  using HasPermissionCallback = base::OnceCallback<void(::blink::mojom::blink::PermissionStatus)>;
  
  virtual void HasPermission(PermissionDescriptorPtr permission, HasPermissionCallback callback) = 0;


  using RequestPermissionCallback = base::OnceCallback<void(::blink::mojom::blink::PermissionStatus)>;
  
  virtual void RequestPermission(PermissionDescriptorPtr permission, bool user_gesture, RequestPermissionCallback callback) = 0;


  using RequestPermissionsCallback = base::OnceCallback<void(const WTF::Vector<::blink::mojom::blink::PermissionStatus>&)>;
  
  virtual void RequestPermissions(WTF::Vector<PermissionDescriptorPtr> permission, bool user_gesture, RequestPermissionsCallback callback) = 0;


  using RevokePermissionCallback = base::OnceCallback<void(::blink::mojom::blink::PermissionStatus)>;
  
  virtual void RevokePermission(PermissionDescriptorPtr permission, RevokePermissionCallback callback) = 0;

  
  virtual void AddPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::blink::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) = 0;
};



class PLATFORM_EXPORT PermissionObserverProxy
    : public PermissionObserver {
 public:
  using InterfaceType = PermissionObserver;

  explicit PermissionObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPermissionStatusChange(::blink::mojom::blink::PermissionStatus status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT PermissionServiceProxy
    : public PermissionService {
 public:
  using InterfaceType = PermissionService;

  explicit PermissionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HasPermission(PermissionDescriptorPtr permission, HasPermissionCallback callback) final;
  
  void RequestPermission(PermissionDescriptorPtr permission, bool user_gesture, RequestPermissionCallback callback) final;
  
  void RequestPermissions(WTF::Vector<PermissionDescriptorPtr> permission, bool user_gesture, RequestPermissionsCallback callback) final;
  
  void RevokePermission(PermissionDescriptorPtr permission, RevokePermissionCallback callback) final;
  
  void AddPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::blink::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PermissionObserverStubDispatch {
 public:
  static bool Accept(PermissionObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PermissionObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PermissionObserver>>
class PermissionObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PermissionObserverStub() {}
  ~PermissionObserverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PermissionServiceStubDispatch {
 public:
  static bool Accept(PermissionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PermissionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PermissionService>>
class PermissionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PermissionServiceStub() {}
  ~PermissionServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PermissionObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PermissionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PermissionServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT MidiPermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MidiPermissionDescriptor, T>::value>;
  using DataView = MidiPermissionDescriptorDataView;
  using Data_ = internal::MidiPermissionDescriptor_Data;

  template <typename... Args>
  static MidiPermissionDescriptorPtr New(Args&&... args) {
    return MidiPermissionDescriptorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MidiPermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<MidiPermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MidiPermissionDescriptor>::Convert(*this);
  }


  MidiPermissionDescriptor();

  explicit MidiPermissionDescriptor(
      bool sysex);

  ~MidiPermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MidiPermissionDescriptorPtr>
  MidiPermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MidiPermissionDescriptor::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MidiPermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MidiPermissionDescriptor_UnserializedMessageContext<
            UserType, MidiPermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MidiPermissionDescriptor::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return MidiPermissionDescriptor::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MidiPermissionDescriptor_UnserializedMessageContext<
            UserType, MidiPermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MidiPermissionDescriptor::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool sysex;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ClipboardPermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClipboardPermissionDescriptor, T>::value>;
  using DataView = ClipboardPermissionDescriptorDataView;
  using Data_ = internal::ClipboardPermissionDescriptor_Data;

  template <typename... Args>
  static ClipboardPermissionDescriptorPtr New(Args&&... args) {
    return ClipboardPermissionDescriptorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClipboardPermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<ClipboardPermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClipboardPermissionDescriptor>::Convert(*this);
  }


  ClipboardPermissionDescriptor();

  ClipboardPermissionDescriptor(
      bool allowWithoutGesture,
      bool allowWithoutSanitization);

  ~ClipboardPermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClipboardPermissionDescriptorPtr>
  ClipboardPermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipboardPermissionDescriptor::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClipboardPermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClipboardPermissionDescriptor_UnserializedMessageContext<
            UserType, ClipboardPermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ClipboardPermissionDescriptor::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ClipboardPermissionDescriptor::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClipboardPermissionDescriptor_UnserializedMessageContext<
            UserType, ClipboardPermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClipboardPermissionDescriptor::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool allowWithoutGesture;
  
  bool allowWithoutSanitization;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT CameraDevicePermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CameraDevicePermissionDescriptor, T>::value>;
  using DataView = CameraDevicePermissionDescriptorDataView;
  using Data_ = internal::CameraDevicePermissionDescriptor_Data;

  template <typename... Args>
  static CameraDevicePermissionDescriptorPtr New(Args&&... args) {
    return CameraDevicePermissionDescriptorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CameraDevicePermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<CameraDevicePermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CameraDevicePermissionDescriptor>::Convert(*this);
  }


  CameraDevicePermissionDescriptor();

  explicit CameraDevicePermissionDescriptor(
      bool panTiltZoom);

  ~CameraDevicePermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CameraDevicePermissionDescriptorPtr>
  CameraDevicePermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CameraDevicePermissionDescriptor::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CameraDevicePermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CameraDevicePermissionDescriptor_UnserializedMessageContext<
            UserType, CameraDevicePermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CameraDevicePermissionDescriptor::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return CameraDevicePermissionDescriptor::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CameraDevicePermissionDescriptor_UnserializedMessageContext<
            UserType, CameraDevicePermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CameraDevicePermissionDescriptor::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool panTiltZoom;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT PermissionDescriptorExtension {
 public:
  using DataView = PermissionDescriptorExtensionDataView;
  using Data_ = internal::PermissionDescriptorExtension_Data;
  using Tag = Data_::PermissionDescriptorExtension_Tag;

  static PermissionDescriptorExtensionPtr New() {
    return PermissionDescriptorExtensionPtr(base::in_place);
  }
  // Construct an instance holding |midi|.
  static PermissionDescriptorExtensionPtr
  NewMidi(
      MidiPermissionDescriptorPtr midi) {
    auto result = PermissionDescriptorExtensionPtr(base::in_place);
    result->set_midi(std::move(midi));
    return result;
  }
  // Construct an instance holding |clipboard|.
  static PermissionDescriptorExtensionPtr
  NewClipboard(
      ClipboardPermissionDescriptorPtr clipboard) {
    auto result = PermissionDescriptorExtensionPtr(base::in_place);
    result->set_clipboard(std::move(clipboard));
    return result;
  }
  // Construct an instance holding |camera_device|.
  static PermissionDescriptorExtensionPtr
  NewCameraDevice(
      CameraDevicePermissionDescriptorPtr camera_device) {
    auto result = PermissionDescriptorExtensionPtr(base::in_place);
    result->set_camera_device(std::move(camera_device));
    return result;
  }

  template <typename U>
  static PermissionDescriptorExtensionPtr From(const U& u) {
    return mojo::TypeConverter<PermissionDescriptorExtensionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionDescriptorExtension>::Convert(*this);
  }

  PermissionDescriptorExtension();
  ~PermissionDescriptorExtension();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PermissionDescriptorExtensionPtr>
  PermissionDescriptorExtensionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PermissionDescriptorExtension>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_midi() const { return tag_ == Tag::MIDI; }

  
  MidiPermissionDescriptorPtr& get_midi() const {
    DCHECK(tag_ == Tag::MIDI);
    return *(data_.midi);
  }

  
  void set_midi(
      MidiPermissionDescriptorPtr midi);
  
  bool is_clipboard() const { return tag_ == Tag::CLIPBOARD; }

  
  ClipboardPermissionDescriptorPtr& get_clipboard() const {
    DCHECK(tag_ == Tag::CLIPBOARD);
    return *(data_.clipboard);
  }

  
  void set_clipboard(
      ClipboardPermissionDescriptorPtr clipboard);
  
  bool is_camera_device() const { return tag_ == Tag::CAMERA_DEVICE; }

  
  CameraDevicePermissionDescriptorPtr& get_camera_device() const {
    DCHECK(tag_ == Tag::CAMERA_DEVICE);
    return *(data_.camera_device);
  }

  
  void set_camera_device(
      CameraDevicePermissionDescriptorPtr camera_device);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionDescriptorExtension::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PermissionDescriptorExtension::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    MidiPermissionDescriptorPtr* midi;
    ClipboardPermissionDescriptorPtr* clipboard;
    CameraDevicePermissionDescriptorPtr* camera_device;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};








class PLATFORM_EXPORT PermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PermissionDescriptor, T>::value>;
  using DataView = PermissionDescriptorDataView;
  using Data_ = internal::PermissionDescriptor_Data;

  template <typename... Args>
  static PermissionDescriptorPtr New(Args&&... args) {
    return PermissionDescriptorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<PermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionDescriptor>::Convert(*this);
  }


  PermissionDescriptor();

  PermissionDescriptor(
      PermissionName name,
      PermissionDescriptorExtensionPtr extension);

  ~PermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionDescriptorPtr>
  PermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionDescriptor::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PermissionDescriptor_UnserializedMessageContext<
            UserType, PermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PermissionDescriptor::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PermissionDescriptor::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PermissionDescriptor_UnserializedMessageContext<
            UserType, PermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PermissionDescriptor::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  PermissionName name;
  
  PermissionDescriptorExtensionPtr extension;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PermissionDescriptor);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PermissionDescriptorExtensionPtr PermissionDescriptorExtension::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::MIDI:
      rv->set_midi(mojo::Clone(*data_.midi));
      break;
    case Tag::CLIPBOARD:
      rv->set_clipboard(mojo::Clone(*data_.clipboard));
      break;
    case Tag::CAMERA_DEVICE:
      rv->set_camera_device(mojo::Clone(*data_.camera_device));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PermissionDescriptorExtension>::value>::type*>
bool PermissionDescriptorExtension::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::MIDI:
      return mojo::Equals(*(data_.midi), *(other.data_.midi));
    case Tag::CLIPBOARD:
      return mojo::Equals(*(data_.clipboard), *(other.data_.clipboard));
    case Tag::CAMERA_DEVICE:
      return mojo::Equals(*(data_.camera_device), *(other.data_.camera_device));
  }

  return false;
}
template <typename StructPtrType>
MidiPermissionDescriptorPtr MidiPermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(sysex)
  );
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>*>
bool MidiPermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sysex, other_struct.sysex))
    return false;
  return true;
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.sysex, rhs.sysex))
    return true;
  if (std::less<>{}(rhs.sysex, lhs.sysex))
    return false;
  return false;
}
template <typename StructPtrType>
ClipboardPermissionDescriptorPtr ClipboardPermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(allowWithoutGesture),
      mojo::Clone(allowWithoutSanitization)
  );
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>*>
bool ClipboardPermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allowWithoutGesture, other_struct.allowWithoutGesture))
    return false;
  if (!mojo::Equals(this->allowWithoutSanitization, other_struct.allowWithoutSanitization))
    return false;
  return true;
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.allowWithoutGesture, rhs.allowWithoutGesture))
    return true;
  if (std::less<>{}(rhs.allowWithoutGesture, lhs.allowWithoutGesture))
    return false;
  if (std::less<>{}(lhs.allowWithoutSanitization, rhs.allowWithoutSanitization))
    return true;
  if (std::less<>{}(rhs.allowWithoutSanitization, lhs.allowWithoutSanitization))
    return false;
  return false;
}
template <typename StructPtrType>
CameraDevicePermissionDescriptorPtr CameraDevicePermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(panTiltZoom)
  );
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>*>
bool CameraDevicePermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->panTiltZoom, other_struct.panTiltZoom))
    return false;
  return true;
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.panTiltZoom, rhs.panTiltZoom))
    return true;
  if (std::less<>{}(rhs.panTiltZoom, lhs.panTiltZoom))
    return false;
  return false;
}
template <typename StructPtrType>
PermissionDescriptorPtr PermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(extension)
  );
}

template <typename T, PermissionDescriptor::EnableIfSame<T>*>
bool PermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->extension, other_struct.extension))
    return false;
  return true;
}

template <typename T, PermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.extension, rhs.extension))
    return true;
  if (std::less<>{}(rhs.extension, lhs.extension))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MidiPermissionDescriptor::DataView,
                                         ::blink::mojom::blink::MidiPermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::blink::MidiPermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MidiPermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::MidiPermissionDescriptor::sysex) sysex(
      const ::blink::mojom::blink::MidiPermissionDescriptorPtr& input) {
    return input->sysex;
  }

  static bool Read(::blink::mojom::blink::MidiPermissionDescriptor::DataView input, ::blink::mojom::blink::MidiPermissionDescriptorPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ClipboardPermissionDescriptor::DataView,
                                         ::blink::mojom::blink::ClipboardPermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::blink::ClipboardPermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ClipboardPermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ClipboardPermissionDescriptor::allowWithoutGesture) allowWithoutGesture(
      const ::blink::mojom::blink::ClipboardPermissionDescriptorPtr& input) {
    return input->allowWithoutGesture;
  }

  static decltype(::blink::mojom::blink::ClipboardPermissionDescriptor::allowWithoutSanitization) allowWithoutSanitization(
      const ::blink::mojom::blink::ClipboardPermissionDescriptorPtr& input) {
    return input->allowWithoutSanitization;
  }

  static bool Read(::blink::mojom::blink::ClipboardPermissionDescriptor::DataView input, ::blink::mojom::blink::ClipboardPermissionDescriptorPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CameraDevicePermissionDescriptor::DataView,
                                         ::blink::mojom::blink::CameraDevicePermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::blink::CameraDevicePermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CameraDevicePermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::CameraDevicePermissionDescriptor::panTiltZoom) panTiltZoom(
      const ::blink::mojom::blink::CameraDevicePermissionDescriptorPtr& input) {
    return input->panTiltZoom;
  }

  static bool Read(::blink::mojom::blink::CameraDevicePermissionDescriptor::DataView input, ::blink::mojom::blink::CameraDevicePermissionDescriptorPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PermissionDescriptor::DataView,
                                         ::blink::mojom::blink::PermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::blink::PermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PermissionDescriptor::name) name(
      const ::blink::mojom::blink::PermissionDescriptorPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::PermissionDescriptor::extension)& extension(
      const ::blink::mojom::blink::PermissionDescriptorPtr& input) {
    return input->extension;
  }

  static bool Read(::blink::mojom::blink::PermissionDescriptor::DataView input, ::blink::mojom::blink::PermissionDescriptorPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::PermissionDescriptorExtension::DataView,
                                        ::blink::mojom::blink::PermissionDescriptorExtensionPtr> {
  static bool IsNull(const ::blink::mojom::blink::PermissionDescriptorExtensionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PermissionDescriptorExtensionPtr* output) { output->reset(); }

  static ::blink::mojom::blink::PermissionDescriptorExtension::Tag GetTag(const ::blink::mojom::blink::PermissionDescriptorExtensionPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::blink::MidiPermissionDescriptorPtr& midi(const ::blink::mojom::blink::PermissionDescriptorExtensionPtr& input) {
    return input->get_midi();
  }

  static const ::blink::mojom::blink::ClipboardPermissionDescriptorPtr& clipboard(const ::blink::mojom::blink::PermissionDescriptorExtensionPtr& input) {
    return input->get_clipboard();
  }

  static const ::blink::mojom::blink::CameraDevicePermissionDescriptorPtr& camera_device(const ::blink::mojom::blink::PermissionDescriptorExtensionPtr& input) {
    return input->get_camera_device();
  }

  static bool Read(::blink::mojom::blink::PermissionDescriptorExtension::DataView input, ::blink::mojom::blink::PermissionDescriptorExtensionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_BLINK_H_