// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class PerContextV8MemoryUsageDataView;

class PerIsolateV8MemoryUsageDataView;

class PerProcessV8MemoryUsageDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PerContextV8MemoryUsageDataView> {
  using Data = ::blink::mojom::internal::PerContextV8MemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PerIsolateV8MemoryUsageDataView> {
  using Data = ::blink::mojom::internal::PerIsolateV8MemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PerProcessV8MemoryUsageDataView> {
  using Data = ::blink::mojom::internal::PerProcessV8MemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class V8DetailedMemoryReporter_Mode : int32_t {
  
  DEFAULT = 0,
  
  EAGER = 1,
  
  LAZY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, V8DetailedMemoryReporter_Mode value);
inline bool IsKnownEnumValue(V8DetailedMemoryReporter_Mode value) {
  return internal::V8DetailedMemoryReporter_Mode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class V8DetailedMemoryReporterInterfaceBase {};

using V8DetailedMemoryReporterPtrDataView =
    mojo::InterfacePtrDataView<V8DetailedMemoryReporterInterfaceBase>;
using V8DetailedMemoryReporterRequestDataView =
    mojo::InterfaceRequestDataView<V8DetailedMemoryReporterInterfaceBase>;
using V8DetailedMemoryReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<V8DetailedMemoryReporterInterfaceBase>;
using V8DetailedMemoryReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<V8DetailedMemoryReporterInterfaceBase>;


class PerContextV8MemoryUsageDataView {
 public:
  PerContextV8MemoryUsageDataView() {}

  PerContextV8MemoryUsageDataView(
      internal::PerContextV8MemoryUsage_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::ExecutionContextTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadToken(UserType* output) {
    
    auto* pointer = !data_->token.is_null() ? &data_->token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::ExecutionContextTokenDataView>(
        pointer, output, context_);
  }
  uint64_t bytes_used() const {
    return data_->bytes_used;
  }
 private:
  internal::PerContextV8MemoryUsage_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PerIsolateV8MemoryUsageDataView {
 public:
  PerIsolateV8MemoryUsageDataView() {}

  PerIsolateV8MemoryUsageDataView(
      internal::PerIsolateV8MemoryUsage_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t unassociated_bytes_used() const {
    return data_->unassociated_bytes_used;
  }
  uint64_t num_unassociated_contexts() const {
    return data_->num_unassociated_contexts;
  }
  uint64_t unassociated_context_bytes_used() const {
    return data_->unassociated_context_bytes_used;
  }
  inline void GetContextsDataView(
      mojo::ArrayDataView<PerContextV8MemoryUsageDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContexts(UserType* output) {
    
    auto* pointer = data_->contexts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PerContextV8MemoryUsageDataView>>(
        pointer, output, context_);
  }
 private:
  internal::PerIsolateV8MemoryUsage_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PerProcessV8MemoryUsageDataView {
 public:
  PerProcessV8MemoryUsageDataView() {}

  PerProcessV8MemoryUsageDataView(
      internal::PerProcessV8MemoryUsage_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIsolatesDataView(
      mojo::ArrayDataView<PerIsolateV8MemoryUsageDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIsolates(UserType* output) {
    
    auto* pointer = data_->isolates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PerIsolateV8MemoryUsageDataView>>(
        pointer, output, context_);
  }
 private:
  internal::PerProcessV8MemoryUsage_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::V8DetailedMemoryReporter_Mode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::V8DetailedMemoryReporter_Mode> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::V8DetailedMemoryReporter_Mode, ::blink::mojom::V8DetailedMemoryReporter_Mode> {
  static ::blink::mojom::V8DetailedMemoryReporter_Mode ToMojom(::blink::mojom::V8DetailedMemoryReporter_Mode input) { return input; }
  static bool FromMojom(::blink::mojom::V8DetailedMemoryReporter_Mode input, ::blink::mojom::V8DetailedMemoryReporter_Mode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::V8DetailedMemoryReporter_Mode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::V8DetailedMemoryReporter_Mode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::V8DetailedMemoryReporter_Mode>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerContextV8MemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerContextV8MemoryUsageDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PerContextV8MemoryUsage_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::token(input)) in_token = Traits::token(input);
    typename decltype((*output)->token)::BufferWriter token_writer;
    token_writer.AllocateInline(buffer, &(*output)->token);
    mojo::internal::Serialize<::blink::mojom::ExecutionContextTokenDataView>(
        in_token, buffer, &token_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in PerContextV8MemoryUsage struct");
    (*output)->bytes_used = Traits::bytes_used(input);
  }

  static bool Deserialize(::blink::mojom::internal::PerContextV8MemoryUsage_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerContextV8MemoryUsageDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerIsolateV8MemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerIsolateV8MemoryUsageDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PerIsolateV8MemoryUsage_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->unassociated_bytes_used = Traits::unassociated_bytes_used(input);
    (*output)->num_unassociated_contexts = Traits::num_unassociated_contexts(input);
    (*output)->unassociated_context_bytes_used = Traits::unassociated_context_bytes_used(input);
    decltype(Traits::contexts(input)) in_contexts = Traits::contexts(input);
    typename decltype((*output)->contexts)::BaseType::BufferWriter
        contexts_writer;
    const mojo::internal::ContainerValidateParams contexts_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PerContextV8MemoryUsageDataView>>(
        in_contexts, buffer, &contexts_writer, &contexts_validate_params,
        context);
    (*output)->contexts.Set(
        contexts_writer.is_null() ? nullptr : contexts_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->contexts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contexts in PerIsolateV8MemoryUsage struct");
  }

  static bool Deserialize(::blink::mojom::internal::PerIsolateV8MemoryUsage_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerIsolateV8MemoryUsageDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerProcessV8MemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerProcessV8MemoryUsageDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PerProcessV8MemoryUsage_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::isolates(input)) in_isolates = Traits::isolates(input);
    typename decltype((*output)->isolates)::BaseType::BufferWriter
        isolates_writer;
    const mojo::internal::ContainerValidateParams isolates_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PerIsolateV8MemoryUsageDataView>>(
        in_isolates, buffer, &isolates_writer, &isolates_validate_params,
        context);
    (*output)->isolates.Set(
        isolates_writer.is_null() ? nullptr : isolates_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->isolates.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null isolates in PerProcessV8MemoryUsage struct");
  }

  static bool Deserialize(::blink::mojom::internal::PerProcessV8MemoryUsage_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerProcessV8MemoryUsageDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void PerContextV8MemoryUsageDataView::GetTokenDataView(
    ::blink::mojom::ExecutionContextTokenDataView* output) {
  auto pointer = &data_->token;
  *output = ::blink::mojom::ExecutionContextTokenDataView(pointer, context_);
}


inline void PerIsolateV8MemoryUsageDataView::GetContextsDataView(
    mojo::ArrayDataView<PerContextV8MemoryUsageDataView>* output) {
  auto pointer = data_->contexts.Get();
  *output = mojo::ArrayDataView<PerContextV8MemoryUsageDataView>(pointer, context_);
}


inline void PerProcessV8MemoryUsageDataView::GetIsolatesDataView(
    mojo::ArrayDataView<PerIsolateV8MemoryUsageDataView>* output) {
  auto pointer = data_->isolates.Get();
  *output = mojo::ArrayDataView<PerIsolateV8MemoryUsageDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_SHARED_H_