// third_party/blink/public/mojom/page/widget.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/mojom/page/widget.mojom-blink-forward.h"
#include "cc/mojom/touch_action.mojom-blink.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/text_direction.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-blink-forward.h"
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-blink.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-blink.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-blink.h"
#include "third_party/blink/public/mojom/page/drag.mojom-blink.h"
#include "third_party/blink/public/mojom/page/record_content_to_visible_time_request.mojom-blink.h"
#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-blink.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-blink.h"
#include "ui/base/mojom/ui_base_types.mojom-blink-forward.h"
#include "ui/base/ime/mojom/text_input_state.mojom-blink.h"
#include "ui/base/cursor/mojom/cursor.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class FrameWidgetProxy;

template <typename ImplRefTraits>
class FrameWidgetStub;

class FrameWidgetRequestValidator;
class FrameWidgetResponseValidator;


class PLATFORM_EXPORT FrameWidget
    : public FrameWidgetInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameWidgetInterfaceBase;
  using Proxy_ = FrameWidgetProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameWidgetStub<ImplRefTraits>;

  using RequestValidator_ = FrameWidgetRequestValidator;
  using ResponseValidator_ = FrameWidgetResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDragTargetDragOverMinVersion = 0,
    kDragTargetDragLeaveMinVersion = 0,
    kDragTargetDropMinVersion = 0,
    kDragSourceEndedAtMinVersion = 0,
    kDragSourceSystemDragEndedMinVersion = 0,
    kSetBackgroundOpaqueMinVersion = 0,
    kSetTextDirectionMinVersion = 0,
    kSetActiveMinVersion = 0,
    kSetInheritedEffectiveTouchActionForSubFrameMinVersion = 0,
    kUpdateRenderThrottlingStatusForSubFrameMinVersion = 0,
    kSetIsInertForSubFrameMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kEnableDeviceEmulationMinVersion = 0,
    kDisableDeviceEmulationMinVersion = 0,
    kBindWidgetCompositorMinVersion = 0,
    kBindInputTargetClientMinVersion = 0,
  };
  virtual ~FrameWidget() {}


  using DragTargetDragOverCallback = base::OnceCallback<void(::blink::DragOperation)>;
  
  virtual void DragTargetDragOver(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragOverCallback callback) = 0;

  
  virtual void DragTargetDragLeave(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point) = 0;

  
  virtual void DragTargetDrop(const ::blink::WebDragData& drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, uint32_t key_modifiers) = 0;

  
  virtual void DragSourceEndedAt(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperation drag_operation) = 0;

  
  virtual void DragSourceSystemDragEnded() = 0;

  
  virtual void SetBackgroundOpaque(bool opaque) = 0;

  
  virtual void SetTextDirection(::base::i18n::TextDirection direction) = 0;

  
  virtual void SetActive(bool active) = 0;

  
  virtual void SetInheritedEffectiveTouchActionForSubFrame(::cc::TouchAction touch_action) = 0;

  
  virtual void UpdateRenderThrottlingStatusForSubFrame(bool is_throttled, bool subtree_throttled) = 0;

  
  virtual void SetIsInertForSubFrame(bool inert) = 0;

  
  virtual void ShowContextMenu(::ui::mojom::blink::MenuSourceType source_type, const ::gfx::Point& location) = 0;

  
  virtual void EnableDeviceEmulation(const ::blink::DeviceEmulationParams& parameters) = 0;

  
  virtual void DisableDeviceEmulation() = 0;

  
  virtual void BindWidgetCompositor(::mojo::PendingReceiver<WidgetCompositor> host) = 0;

  
  virtual void BindInputTargetClient(::mojo::PendingReceiver<::viz::mojom::blink::InputTargetClient> host) = 0;
};

class FrameWidgetHostProxy;

template <typename ImplRefTraits>
class FrameWidgetHostStub;

class FrameWidgetHostRequestValidator;


class PLATFORM_EXPORT FrameWidgetHost
    : public FrameWidgetHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameWidgetHostInterfaceBase;
  using Proxy_ = FrameWidgetHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameWidgetHostStub<ImplRefTraits>;

  using RequestValidator_ = FrameWidgetHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAnimateDoubleTapZoomInMainFrameMinVersion = 0,
    kZoomToFindInPageRectInMainFrameMinVersion = 0,
    kSetHasTouchEventConsumersMinVersion = 0,
    kIntrinsicSizingInfoChangedMinVersion = 0,
    kAutoscrollStartMinVersion = 0,
    kAutoscrollFlingMinVersion = 0,
    kAutoscrollEndMinVersion = 0,
    kDidFirstVisuallyNonEmptyPaintMinVersion = 0,
    kStartDraggingMinVersion = 0,
  };
  virtual ~FrameWidgetHost() {}

  
  virtual void AnimateDoubleTapZoomInMainFrame(const ::gfx::Point& tap_point, const ::gfx::Rect& rect_to_zoom) = 0;

  
  virtual void ZoomToFindInPageRectInMainFrame(const ::gfx::Rect& rect_to_zoom) = 0;

  
  virtual void SetHasTouchEventConsumers(::blink::mojom::blink::TouchEventConsumersPtr touch_event_consumers) = 0;

  
  virtual void IntrinsicSizingInfoChanged(::blink::mojom::blink::IntrinsicSizingInfoPtr sizing_info) = 0;

  
  virtual void AutoscrollStart(const ::gfx::PointF& position) = 0;

  
  virtual void AutoscrollFling(const ::gfx::Vector2dF& velocity) = 0;

  
  virtual void AutoscrollEnd() = 0;

  
  virtual void DidFirstVisuallyNonEmptyPaint() = 0;

  
  virtual void StartDragging(const ::blink::WebDragData& drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& bitmap_offset_in_dip, ::blink::mojom::blink::DragEventSourceInfoPtr event_info) = 0;
};

class WidgetProxy;

template <typename ImplRefTraits>
class WidgetStub;

class WidgetRequestValidator;
class WidgetResponseValidator;


class PLATFORM_EXPORT Widget
    : public WidgetInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WidgetInterfaceBase;
  using Proxy_ = WidgetProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetStub<ImplRefTraits>;

  using RequestValidator_ = WidgetRequestValidator;
  using ResponseValidator_ = WidgetResponseValidator;
  enum MethodMinVersions : uint32_t {
    kForceRedrawMinVersion = 0,
    kGetWidgetInputHandlerMinVersion = 0,
    kUpdateVisualPropertiesMinVersion = 0,
    kUpdateScreenRectsMinVersion = 0,
    kWasHiddenMinVersion = 0,
    kWasShownMinVersion = 0,
  };
  virtual ~Widget() {}


  using ForceRedrawCallback = base::OnceCallback<void()>;
  
  virtual void ForceRedraw(ForceRedrawCallback callback) = 0;

  
  virtual void GetWidgetInputHandler(::mojo::PendingReceiver<::blink::mojom::blink::WidgetInputHandler> request, ::mojo::PendingRemote<::blink::mojom::blink::WidgetInputHandlerHost> host) = 0;

  
  virtual void UpdateVisualProperties(const ::blink::VisualProperties& visual_properties) = 0;


  using UpdateScreenRectsCallback = base::OnceCallback<void()>;
  
  virtual void UpdateScreenRects(const ::gfx::Rect& widget_screen_rect, const ::gfx::Rect& window_screen_rect, UpdateScreenRectsCallback callback) = 0;

  
  virtual void WasHidden() = 0;

  
  virtual void WasShown(::base::TimeTicks show_request_timestamp, bool was_evicted, ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr record_tab_switch_time_request) = 0;
};

class WidgetHostProxy;

template <typename ImplRefTraits>
class WidgetHostStub;

class WidgetHostRequestValidator;


class PLATFORM_EXPORT WidgetHost
    : public WidgetHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WidgetHostInterfaceBase;
  using Proxy_ = WidgetHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetHostStub<ImplRefTraits>;

  using RequestValidator_ = WidgetHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetCursorMinVersion = 0,
    kSetToolTipTextMinVersion = 0,
    kTextInputStateChangedMinVersion = 0,
    kSelectionBoundsChangedMinVersion = 0,
  };
  virtual ~WidgetHost() {}

  
  virtual void SetCursor(const ::ui::Cursor& cursor) = 0;

  
  virtual void SetToolTipText(const ::WTF::String& tooltip_text, ::base::i18n::TextDirection text_direction_hint) = 0;

  
  virtual void TextInputStateChanged(::ui::mojom::blink::TextInputStatePtr state) = 0;

  
  virtual void SelectionBoundsChanged(const ::gfx::Rect& anchor_rect, ::base::i18n::TextDirection anchor_dir, const ::gfx::Rect& focus_rect, ::base::i18n::TextDirection focus_dir, bool is_anchor_first) = 0;
};

class WidgetCompositorProxy;

template <typename ImplRefTraits>
class WidgetCompositorStub;

class WidgetCompositorRequestValidator;
class WidgetCompositorResponseValidator;


class PLATFORM_EXPORT WidgetCompositor
    : public WidgetCompositorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WidgetCompositorInterfaceBase;
  using Proxy_ = WidgetCompositorProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetCompositorStub<ImplRefTraits>;

  using RequestValidator_ = WidgetCompositorRequestValidator;
  using ResponseValidator_ = WidgetCompositorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kVisualStateRequestMinVersion = 0,
  };
  virtual ~WidgetCompositor() {}


  using VisualStateRequestCallback = base::OnceCallback<void()>;
  
  virtual void VisualStateRequest(VisualStateRequestCallback callback) = 0;
};



class PLATFORM_EXPORT FrameWidgetProxy
    : public FrameWidget {
 public:
  using InterfaceType = FrameWidget;

  explicit FrameWidgetProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DragTargetDragOver(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragOverCallback callback) final;
  
  void DragTargetDragLeave(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point) final;
  
  void DragTargetDrop(const ::blink::WebDragData& drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, uint32_t key_modifiers) final;
  
  void DragSourceEndedAt(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperation drag_operation) final;
  
  void DragSourceSystemDragEnded() final;
  
  void SetBackgroundOpaque(bool opaque) final;
  
  void SetTextDirection(::base::i18n::TextDirection direction) final;
  
  void SetActive(bool active) final;
  
  void SetInheritedEffectiveTouchActionForSubFrame(::cc::TouchAction touch_action) final;
  
  void UpdateRenderThrottlingStatusForSubFrame(bool is_throttled, bool subtree_throttled) final;
  
  void SetIsInertForSubFrame(bool inert) final;
  
  void ShowContextMenu(::ui::mojom::blink::MenuSourceType source_type, const ::gfx::Point& location) final;
  
  void EnableDeviceEmulation(const ::blink::DeviceEmulationParams& parameters) final;
  
  void DisableDeviceEmulation() final;
  
  void BindWidgetCompositor(::mojo::PendingReceiver<WidgetCompositor> host) final;
  
  void BindInputTargetClient(::mojo::PendingReceiver<::viz::mojom::blink::InputTargetClient> host) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT FrameWidgetHostProxy
    : public FrameWidgetHost {
 public:
  using InterfaceType = FrameWidgetHost;

  explicit FrameWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AnimateDoubleTapZoomInMainFrame(const ::gfx::Point& tap_point, const ::gfx::Rect& rect_to_zoom) final;
  
  void ZoomToFindInPageRectInMainFrame(const ::gfx::Rect& rect_to_zoom) final;
  
  void SetHasTouchEventConsumers(::blink::mojom::blink::TouchEventConsumersPtr touch_event_consumers) final;
  
  void IntrinsicSizingInfoChanged(::blink::mojom::blink::IntrinsicSizingInfoPtr sizing_info) final;
  
  void AutoscrollStart(const ::gfx::PointF& position) final;
  
  void AutoscrollFling(const ::gfx::Vector2dF& velocity) final;
  
  void AutoscrollEnd() final;
  
  void DidFirstVisuallyNonEmptyPaint() final;
  
  void StartDragging(const ::blink::WebDragData& drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& bitmap_offset_in_dip, ::blink::mojom::blink::DragEventSourceInfoPtr event_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT WidgetProxy
    : public Widget {
 public:
  using InterfaceType = Widget;

  explicit WidgetProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ForceRedraw(ForceRedrawCallback callback) final;
  
  void GetWidgetInputHandler(::mojo::PendingReceiver<::blink::mojom::blink::WidgetInputHandler> request, ::mojo::PendingRemote<::blink::mojom::blink::WidgetInputHandlerHost> host) final;
  
  void UpdateVisualProperties(const ::blink::VisualProperties& visual_properties) final;
  
  void UpdateScreenRects(const ::gfx::Rect& widget_screen_rect, const ::gfx::Rect& window_screen_rect, UpdateScreenRectsCallback callback) final;
  
  void WasHidden() final;
  
  void WasShown(::base::TimeTicks show_request_timestamp, bool was_evicted, ::blink::mojom::blink::RecordContentToVisibleTimeRequestPtr record_tab_switch_time_request) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT WidgetHostProxy
    : public WidgetHost {
 public:
  using InterfaceType = WidgetHost;

  explicit WidgetHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCursor(const ::ui::Cursor& cursor) final;
  
  void SetToolTipText(const ::WTF::String& tooltip_text, ::base::i18n::TextDirection text_direction_hint) final;
  
  void TextInputStateChanged(::ui::mojom::blink::TextInputStatePtr state) final;
  
  void SelectionBoundsChanged(const ::gfx::Rect& anchor_rect, ::base::i18n::TextDirection anchor_dir, const ::gfx::Rect& focus_rect, ::base::i18n::TextDirection focus_dir, bool is_anchor_first) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT WidgetCompositorProxy
    : public WidgetCompositor {
 public:
  using InterfaceType = WidgetCompositor;

  explicit WidgetCompositorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void VisualStateRequest(VisualStateRequestCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT FrameWidgetStubDispatch {
 public:
  static bool Accept(FrameWidget* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameWidget* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameWidget>>
class FrameWidgetStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameWidgetStub() {}
  ~FrameWidgetStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FrameWidgetHostStubDispatch {
 public:
  static bool Accept(FrameWidgetHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameWidgetHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameWidgetHost>>
class FrameWidgetHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameWidgetHostStub() {}
  ~FrameWidgetHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WidgetStubDispatch {
 public:
  static bool Accept(Widget* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Widget* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Widget>>
class WidgetStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetStub() {}
  ~WidgetStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WidgetHostStubDispatch {
 public:
  static bool Accept(WidgetHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WidgetHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WidgetHost>>
class WidgetHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetHostStub() {}
  ~WidgetHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WidgetCompositorStubDispatch {
 public:
  static bool Accept(WidgetCompositor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WidgetCompositor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WidgetCompositor>>
class WidgetCompositorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetCompositorStub() {}
  ~WidgetCompositorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetCompositorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetCompositorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FrameWidgetRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FrameWidgetHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetCompositorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FrameWidgetResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WidgetCompositorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_BLINK_H_