// third_party/blink/public/mojom/messaging/transferable_message.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-blink-forward.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-blink.h"
#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom-blink.h"
#include "third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/core/messaging/blink_transferable_message_mojom_traits.h"
#include "third_party/blink/renderer/core/core_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {








class CORE_EXPORT TransferableMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransferableMessage, T>::value>;
  using DataView = TransferableMessageDataView;
  using Data_ = internal::TransferableMessage_Data;

  template <typename... Args>
  static TransferableMessagePtr New(Args&&... args) {
    return TransferableMessagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransferableMessagePtr From(const U& u) {
    return mojo::TypeConverter<TransferableMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransferableMessage>::Convert(*this);
  }


  TransferableMessage();

  TransferableMessage(
      ::blink::BlinkCloneableMessage message,
      WTF::Vector<::blink::MessagePortDescriptor> ports,
      WTF::Vector<::blink::MessagePortDescriptor> stream_channels,
      WTF::Vector<::blink::ArrayBufferContents> array_buffer_contents_array,
      WTF::Vector<::SkBitmap> image_bitmap_contents_array,
      ::blink::mojom::blink::UserActivationSnapshotPtr user_activation);

  ~TransferableMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransferableMessagePtr>
  TransferableMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransferableMessage::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransferableMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransferableMessage_UnserializedMessageContext<
            UserType, TransferableMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TransferableMessage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TransferableMessage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransferableMessage_UnserializedMessageContext<
            UserType, TransferableMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransferableMessage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::BlinkCloneableMessage message;
  
  WTF::Vector<::blink::MessagePortDescriptor> ports;
  
  WTF::Vector<::blink::MessagePortDescriptor> stream_channels;
  
  WTF::Vector<::blink::ArrayBufferContents> array_buffer_contents_array;
  
  WTF::Vector<::SkBitmap> image_bitmap_contents_array;
  
  ::blink::mojom::blink::UserActivationSnapshotPtr user_activation;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(TransferableMessage);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransferableMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TransferableMessagePtr TransferableMessage::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(ports),
      mojo::Clone(stream_channels),
      mojo::Clone(array_buffer_contents_array),
      mojo::Clone(image_bitmap_contents_array),
      mojo::Clone(user_activation)
  );
}

template <typename T, TransferableMessage::EnableIfSame<T>*>
bool TransferableMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->ports, other_struct.ports))
    return false;
  if (!mojo::Equals(this->stream_channels, other_struct.stream_channels))
    return false;
  if (!mojo::Equals(this->array_buffer_contents_array, other_struct.array_buffer_contents_array))
    return false;
  if (!mojo::Equals(this->image_bitmap_contents_array, other_struct.image_bitmap_contents_array))
    return false;
  if (!mojo::Equals(this->user_activation, other_struct.user_activation))
    return false;
  return true;
}

template <typename T, TransferableMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.message, rhs.message))
    return true;
  if (std::less<>{}(rhs.message, lhs.message))
    return false;
  if (std::less<>{}(lhs.ports, rhs.ports))
    return true;
  if (std::less<>{}(rhs.ports, lhs.ports))
    return false;
  if (std::less<>{}(lhs.stream_channels, rhs.stream_channels))
    return true;
  if (std::less<>{}(rhs.stream_channels, lhs.stream_channels))
    return false;
  if (std::less<>{}(lhs.array_buffer_contents_array, rhs.array_buffer_contents_array))
    return true;
  if (std::less<>{}(rhs.array_buffer_contents_array, lhs.array_buffer_contents_array))
    return false;
  if (std::less<>{}(lhs.image_bitmap_contents_array, rhs.image_bitmap_contents_array))
    return true;
  if (std::less<>{}(rhs.image_bitmap_contents_array, lhs.image_bitmap_contents_array))
    return false;
  if (std::less<>{}(lhs.user_activation, rhs.user_activation))
    return true;
  if (std::less<>{}(rhs.user_activation, lhs.user_activation))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::TransferableMessage::DataView,
                                         ::blink::mojom::blink::TransferableMessagePtr> {
  static bool IsNull(const ::blink::mojom::blink::TransferableMessagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TransferableMessagePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::TransferableMessage::message)& message(
       ::blink::mojom::blink::TransferableMessagePtr& input) {
    return input->message;
  }

  static  decltype(::blink::mojom::blink::TransferableMessage::ports)& ports(
       ::blink::mojom::blink::TransferableMessagePtr& input) {
    return input->ports;
  }

  static  decltype(::blink::mojom::blink::TransferableMessage::stream_channels)& stream_channels(
       ::blink::mojom::blink::TransferableMessagePtr& input) {
    return input->stream_channels;
  }

  static  decltype(::blink::mojom::blink::TransferableMessage::array_buffer_contents_array)& array_buffer_contents_array(
       ::blink::mojom::blink::TransferableMessagePtr& input) {
    return input->array_buffer_contents_array;
  }

  static  decltype(::blink::mojom::blink::TransferableMessage::image_bitmap_contents_array)& image_bitmap_contents_array(
       ::blink::mojom::blink::TransferableMessagePtr& input) {
    return input->image_bitmap_contents_array;
  }

  static const decltype(::blink::mojom::blink::TransferableMessage::user_activation)& user_activation(
      const ::blink::mojom::blink::TransferableMessagePtr& input) {
    return input->user_activation;
  }

  static bool Read(::blink::mojom::blink::TransferableMessage::DataView input, ::blink::mojom::blink::TransferableMessagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_BLINK_H_