// third_party/blink/public/mojom/mediastream/media_stream.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared.h"
#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink-forward.h"
#include "media/capture/mojom/video_capture_types.mojom-blink.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/display_media_information.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/mediastream/media_stream_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_MediaStreamType_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::MediaStreamType& value) {
    using utype = std::underlying_type<::blink::mojom::MediaStreamType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::MediaStreamType& left, const ::blink::mojom::MediaStreamType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::MediaStreamType>
    : public GenericHashTraits<::blink::mojom::MediaStreamType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::MediaStreamType& value) {
    return value == static_cast<::blink::mojom::MediaStreamType>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::MediaStreamType& slot, bool) {
    slot = static_cast<::blink::mojom::MediaStreamType>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::MediaStreamType& value) {
    return value == static_cast<::blink::mojom::MediaStreamType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_MediaStreamRequestResult_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::MediaStreamRequestResult& value) {
    using utype = std::underlying_type<::blink::mojom::MediaStreamRequestResult>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::MediaStreamRequestResult& left, const ::blink::mojom::MediaStreamRequestResult& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::MediaStreamRequestResult>
    : public GenericHashTraits<::blink::mojom::MediaStreamRequestResult> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::MediaStreamRequestResult& value) {
    return value == static_cast<::blink::mojom::MediaStreamRequestResult>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::MediaStreamRequestResult& slot, bool) {
    slot = static_cast<::blink::mojom::MediaStreamRequestResult>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::MediaStreamRequestResult& value) {
    return value == static_cast<::blink::mojom::MediaStreamRequestResult>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_StreamSelectionStrategy_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::StreamSelectionStrategy& value) {
    using utype = std::underlying_type<::blink::mojom::StreamSelectionStrategy>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::StreamSelectionStrategy& left, const ::blink::mojom::StreamSelectionStrategy& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::StreamSelectionStrategy>
    : public GenericHashTraits<::blink::mojom::StreamSelectionStrategy> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::StreamSelectionStrategy& value) {
    return value == static_cast<::blink::mojom::StreamSelectionStrategy>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::StreamSelectionStrategy& slot, bool) {
    slot = static_cast<::blink::mojom::StreamSelectionStrategy>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::StreamSelectionStrategy& value) {
    return value == static_cast<::blink::mojom::StreamSelectionStrategy>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class MediaStreamDeviceObserverProxy;

template <typename ImplRefTraits>
class MediaStreamDeviceObserverStub;

class MediaStreamDeviceObserverRequestValidator;


class PLATFORM_EXPORT MediaStreamDeviceObserver
    : public MediaStreamDeviceObserverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MediaStreamDeviceObserverInterfaceBase;
  using Proxy_ = MediaStreamDeviceObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaStreamDeviceObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaStreamDeviceObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceStoppedMinVersion = 0,
    kOnDeviceChangedMinVersion = 0,
  };
  virtual ~MediaStreamDeviceObserver() {}

  
  virtual void OnDeviceStopped(const WTF::String& label, const ::blink::MediaStreamDevice& device) = 0;

  
  virtual void OnDeviceChanged(const WTF::String& label, const ::blink::MediaStreamDevice& old_device, const ::blink::MediaStreamDevice& new_device) = 0;
};

class MediaStreamDispatcherHostProxy;

template <typename ImplRefTraits>
class MediaStreamDispatcherHostStub;

class MediaStreamDispatcherHostRequestValidator;
class MediaStreamDispatcherHostResponseValidator;


class PLATFORM_EXPORT MediaStreamDispatcherHost
    : public MediaStreamDispatcherHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MediaStreamDispatcherHostInterfaceBase;
  using Proxy_ = MediaStreamDispatcherHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaStreamDispatcherHostStub<ImplRefTraits>;

  using RequestValidator_ = MediaStreamDispatcherHostRequestValidator;
  using ResponseValidator_ = MediaStreamDispatcherHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGenerateStreamMinVersion = 0,
    kCancelRequestMinVersion = 0,
    kStopStreamDeviceMinVersion = 0,
    kOpenDeviceMinVersion = 0,
    kCloseDeviceMinVersion = 0,
    kSetCapturingLinkSecuredMinVersion = 0,
    kOnStreamStartedMinVersion = 0,
  };
  virtual ~MediaStreamDispatcherHost() {}


  using GenerateStreamCallback = base::OnceCallback<void(MediaStreamRequestResult, const WTF::String&, const WTF::Vector<::blink::MediaStreamDevice>&, const WTF::Vector<::blink::MediaStreamDevice>&, bool)>;
  
  virtual void GenerateStream(int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, GenerateStreamCallback callback) = 0;

  
  virtual void CancelRequest(int32_t request_id) = 0;

  
  virtual void StopStreamDevice(const WTF::String& device_id, const base::Optional<::base::UnguessableToken>& session_id) = 0;


  using OpenDeviceCallback = base::OnceCallback<void(bool, const WTF::String&, const ::blink::MediaStreamDevice&)>;
  
  virtual void OpenDevice(int32_t request_id, const WTF::String& device_id, MediaStreamType type, OpenDeviceCallback callback) = 0;

  
  virtual void CloseDevice(const WTF::String& label) = 0;

  
  virtual void SetCapturingLinkSecured(const base::Optional<::base::UnguessableToken>& session_id, MediaStreamType type, bool is_secure) = 0;

  
  virtual void OnStreamStarted(const WTF::String& label) = 0;
};

class MediaStreamTrackMetricsHostProxy;

template <typename ImplRefTraits>
class MediaStreamTrackMetricsHostStub;

class MediaStreamTrackMetricsHostRequestValidator;


class PLATFORM_EXPORT MediaStreamTrackMetricsHost
    : public MediaStreamTrackMetricsHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MediaStreamTrackMetricsHostInterfaceBase;
  using Proxy_ = MediaStreamTrackMetricsHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaStreamTrackMetricsHostStub<ImplRefTraits>;

  using RequestValidator_ = MediaStreamTrackMetricsHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddTrackMinVersion = 0,
    kRemoveTrackMinVersion = 0,
  };
  virtual ~MediaStreamTrackMetricsHost() {}

  
  virtual void AddTrack(uint64_t id, bool is_audio, bool is_remote) = 0;

  
  virtual void RemoveTrack(uint64_t id) = 0;
};



class PLATFORM_EXPORT MediaStreamDeviceObserverProxy
    : public MediaStreamDeviceObserver {
 public:
  using InterfaceType = MediaStreamDeviceObserver;

  explicit MediaStreamDeviceObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceStopped(const WTF::String& label, const ::blink::MediaStreamDevice& device) final;
  
  void OnDeviceChanged(const WTF::String& label, const ::blink::MediaStreamDevice& old_device, const ::blink::MediaStreamDevice& new_device) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT MediaStreamDispatcherHostProxy
    : public MediaStreamDispatcherHost {
 public:
  using InterfaceType = MediaStreamDispatcherHost;

  explicit MediaStreamDispatcherHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GenerateStream(int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, GenerateStreamCallback callback) final;
  
  void CancelRequest(int32_t request_id) final;
  
  void StopStreamDevice(const WTF::String& device_id, const base::Optional<::base::UnguessableToken>& session_id) final;
  
  void OpenDevice(int32_t request_id, const WTF::String& device_id, MediaStreamType type, OpenDeviceCallback callback) final;
  
  void CloseDevice(const WTF::String& label) final;
  
  void SetCapturingLinkSecured(const base::Optional<::base::UnguessableToken>& session_id, MediaStreamType type, bool is_secure) final;
  
  void OnStreamStarted(const WTF::String& label) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT MediaStreamTrackMetricsHostProxy
    : public MediaStreamTrackMetricsHost {
 public:
  using InterfaceType = MediaStreamTrackMetricsHost;

  explicit MediaStreamTrackMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddTrack(uint64_t id, bool is_audio, bool is_remote) final;
  
  void RemoveTrack(uint64_t id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT MediaStreamDeviceObserverStubDispatch {
 public:
  static bool Accept(MediaStreamDeviceObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaStreamDeviceObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaStreamDeviceObserver>>
class MediaStreamDeviceObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaStreamDeviceObserverStub() {}
  ~MediaStreamDeviceObserverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDeviceObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDeviceObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaStreamDispatcherHostStubDispatch {
 public:
  static bool Accept(MediaStreamDispatcherHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaStreamDispatcherHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaStreamDispatcherHost>>
class MediaStreamDispatcherHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaStreamDispatcherHostStub() {}
  ~MediaStreamDispatcherHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDispatcherHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamDispatcherHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaStreamTrackMetricsHostStubDispatch {
 public:
  static bool Accept(MediaStreamTrackMetricsHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaStreamTrackMetricsHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaStreamTrackMetricsHost>>
class MediaStreamTrackMetricsHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaStreamTrackMetricsHostStub() {}
  ~MediaStreamTrackMetricsHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamTrackMetricsHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaStreamTrackMetricsHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT MediaStreamDeviceObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaStreamDispatcherHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaStreamTrackMetricsHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT MediaStreamDispatcherHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class PLATFORM_EXPORT TrackControls {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrackControls, T>::value>;
  using DataView = TrackControlsDataView;
  using Data_ = internal::TrackControls_Data;

  template <typename... Args>
  static TrackControlsPtr New(Args&&... args) {
    return TrackControlsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrackControlsPtr From(const U& u) {
    return mojo::TypeConverter<TrackControlsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrackControls>::Convert(*this);
  }


  TrackControls();

  TrackControls(
      bool requested,
      MediaStreamType stream_type,
      const WTF::String& device_id);

  ~TrackControls();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrackControlsPtr>
  TrackControlsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrackControls::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrackControls::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrackControls_UnserializedMessageContext<
            UserType, TrackControls::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TrackControls::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TrackControls::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrackControls_UnserializedMessageContext<
            UserType, TrackControls::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrackControls::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool requested;
  
  MediaStreamType stream_type;
  
  WTF::String device_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrackControls::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT StreamSelectionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StreamSelectionInfo, T>::value>;
  using DataView = StreamSelectionInfoDataView;
  using Data_ = internal::StreamSelectionInfo_Data;

  template <typename... Args>
  static StreamSelectionInfoPtr New(Args&&... args) {
    return StreamSelectionInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StreamSelectionInfoPtr From(const U& u) {
    return mojo::TypeConverter<StreamSelectionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamSelectionInfo>::Convert(*this);
  }


  StreamSelectionInfo();

  StreamSelectionInfo(
      StreamSelectionStrategy strategy,
      const base::Optional<::base::UnguessableToken>& session_id);

  ~StreamSelectionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StreamSelectionInfoPtr>
  StreamSelectionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StreamSelectionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamSelectionInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamSelectionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StreamSelectionInfo_UnserializedMessageContext<
            UserType, StreamSelectionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<StreamSelectionInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return StreamSelectionInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StreamSelectionInfo_UnserializedMessageContext<
            UserType, StreamSelectionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StreamSelectionInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  StreamSelectionStrategy strategy;
  
  base::Optional<::base::UnguessableToken> session_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StreamSelectionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StreamSelectionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StreamSelectionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StreamSelectionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT MediaStreamDevice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaStreamDevice, T>::value>;
  using DataView = MediaStreamDeviceDataView;
  using Data_ = internal::MediaStreamDevice_Data;

  template <typename... Args>
  static MediaStreamDevicePtr New(Args&&... args) {
    return MediaStreamDevicePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaStreamDevicePtr From(const U& u) {
    return mojo::TypeConverter<MediaStreamDevicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaStreamDevice>::Convert(*this);
  }


  MediaStreamDevice();

  MediaStreamDevice(
      MediaStreamType type,
      const WTF::String& id,
      ::media::VideoFacingMode video_facing,
      const WTF::String& group_id,
      const WTF::String& matched_output_device_id,
      const WTF::String& name,
      const ::media::AudioParameters& input,
      const base::Optional<::base::UnguessableToken>& session_id,
      ::media::mojom::blink::DisplayMediaInformationPtr display_media_info);

  ~MediaStreamDevice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaStreamDevicePtr>
  MediaStreamDevicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaStreamDevice::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaStreamDevice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaStreamDevice_UnserializedMessageContext<
            UserType, MediaStreamDevice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaStreamDevice::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return MediaStreamDevice::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaStreamDevice_UnserializedMessageContext<
            UserType, MediaStreamDevice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaStreamDevice::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  MediaStreamType type;
  
  WTF::String id;
  
  ::media::VideoFacingMode video_facing;
  
  WTF::String group_id;
  
  WTF::String matched_output_device_id;
  
  WTF::String name;
  
  ::media::AudioParameters input;
  
  base::Optional<::base::UnguessableToken> session_id;
  
  ::media::mojom::blink::DisplayMediaInformationPtr display_media_info;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(MediaStreamDevice);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaStreamDevice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT StreamControls {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StreamControls, T>::value>;
  using DataView = StreamControlsDataView;
  using Data_ = internal::StreamControls_Data;

  template <typename... Args>
  static StreamControlsPtr New(Args&&... args) {
    return StreamControlsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StreamControlsPtr From(const U& u) {
    return mojo::TypeConverter<StreamControlsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamControls>::Convert(*this);
  }


  StreamControls();

  StreamControls(
      const ::blink::TrackControls& audio,
      const ::blink::TrackControls& video,
      bool hotword_enabled,
      bool disable_local_echo,
      bool request_pan_tilt_zoom_permission);

  ~StreamControls();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StreamControlsPtr>
  StreamControlsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamControls::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamControls::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StreamControls_UnserializedMessageContext<
            UserType, StreamControls::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<StreamControls::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return StreamControls::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StreamControls_UnserializedMessageContext<
            UserType, StreamControls::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StreamControls::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::TrackControls audio;
  
  ::blink::TrackControls video;
  
  bool hotword_enabled;
  
  bool disable_local_echo;
  
  bool request_pan_tilt_zoom_permission;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StreamControls::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StreamSelectionInfoPtr StreamSelectionInfo::Clone() const {
  return New(
      mojo::Clone(strategy),
      mojo::Clone(session_id)
  );
}

template <typename T, StreamSelectionInfo::EnableIfSame<T>*>
bool StreamSelectionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->strategy, other_struct.strategy))
    return false;
  if (!mojo::Equals(this->session_id, other_struct.session_id))
    return false;
  return true;
}

template <typename T, StreamSelectionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.strategy, rhs.strategy))
    return true;
  if (std::less<>{}(rhs.strategy, lhs.strategy))
    return false;
  if (std::less<>{}(lhs.session_id, rhs.session_id))
    return true;
  if (std::less<>{}(rhs.session_id, lhs.session_id))
    return false;
  return false;
}
template <typename StructPtrType>
MediaStreamDevicePtr MediaStreamDevice::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(id),
      mojo::Clone(video_facing),
      mojo::Clone(group_id),
      mojo::Clone(matched_output_device_id),
      mojo::Clone(name),
      mojo::Clone(input),
      mojo::Clone(session_id),
      mojo::Clone(display_media_info)
  );
}

template <typename T, MediaStreamDevice::EnableIfSame<T>*>
bool MediaStreamDevice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->video_facing, other_struct.video_facing))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->matched_output_device_id, other_struct.matched_output_device_id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  if (!mojo::Equals(this->session_id, other_struct.session_id))
    return false;
  if (!mojo::Equals(this->display_media_info, other_struct.display_media_info))
    return false;
  return true;
}

template <typename T, MediaStreamDevice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.video_facing, rhs.video_facing))
    return true;
  if (std::less<>{}(rhs.video_facing, lhs.video_facing))
    return false;
  if (std::less<>{}(lhs.group_id, rhs.group_id))
    return true;
  if (std::less<>{}(rhs.group_id, lhs.group_id))
    return false;
  if (std::less<>{}(lhs.matched_output_device_id, rhs.matched_output_device_id))
    return true;
  if (std::less<>{}(rhs.matched_output_device_id, lhs.matched_output_device_id))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.input, rhs.input))
    return true;
  if (std::less<>{}(rhs.input, lhs.input))
    return false;
  if (std::less<>{}(lhs.session_id, rhs.session_id))
    return true;
  if (std::less<>{}(rhs.session_id, lhs.session_id))
    return false;
  if (std::less<>{}(lhs.display_media_info, rhs.display_media_info))
    return true;
  if (std::less<>{}(rhs.display_media_info, lhs.display_media_info))
    return false;
  return false;
}
template <typename StructPtrType>
TrackControlsPtr TrackControls::Clone() const {
  return New(
      mojo::Clone(requested),
      mojo::Clone(stream_type),
      mojo::Clone(device_id)
  );
}

template <typename T, TrackControls::EnableIfSame<T>*>
bool TrackControls::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->requested, other_struct.requested))
    return false;
  if (!mojo::Equals(this->stream_type, other_struct.stream_type))
    return false;
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  return true;
}

template <typename T, TrackControls::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.requested, rhs.requested))
    return true;
  if (std::less<>{}(rhs.requested, lhs.requested))
    return false;
  if (std::less<>{}(lhs.stream_type, rhs.stream_type))
    return true;
  if (std::less<>{}(rhs.stream_type, lhs.stream_type))
    return false;
  if (std::less<>{}(lhs.device_id, rhs.device_id))
    return true;
  if (std::less<>{}(rhs.device_id, lhs.device_id))
    return false;
  return false;
}
template <typename StructPtrType>
StreamControlsPtr StreamControls::Clone() const {
  return New(
      mojo::Clone(audio),
      mojo::Clone(video),
      mojo::Clone(hotword_enabled),
      mojo::Clone(disable_local_echo),
      mojo::Clone(request_pan_tilt_zoom_permission)
  );
}

template <typename T, StreamControls::EnableIfSame<T>*>
bool StreamControls::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio, other_struct.audio))
    return false;
  if (!mojo::Equals(this->video, other_struct.video))
    return false;
  if (!mojo::Equals(this->hotword_enabled, other_struct.hotword_enabled))
    return false;
  if (!mojo::Equals(this->disable_local_echo, other_struct.disable_local_echo))
    return false;
  if (!mojo::Equals(this->request_pan_tilt_zoom_permission, other_struct.request_pan_tilt_zoom_permission))
    return false;
  return true;
}

template <typename T, StreamControls::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.audio, rhs.audio))
    return true;
  if (std::less<>{}(rhs.audio, lhs.audio))
    return false;
  if (std::less<>{}(lhs.video, rhs.video))
    return true;
  if (std::less<>{}(rhs.video, lhs.video))
    return false;
  if (std::less<>{}(lhs.hotword_enabled, rhs.hotword_enabled))
    return true;
  if (std::less<>{}(rhs.hotword_enabled, lhs.hotword_enabled))
    return false;
  if (std::less<>{}(lhs.disable_local_echo, rhs.disable_local_echo))
    return true;
  if (std::less<>{}(rhs.disable_local_echo, lhs.disable_local_echo))
    return false;
  if (std::less<>{}(lhs.request_pan_tilt_zoom_permission, rhs.request_pan_tilt_zoom_permission))
    return true;
  if (std::less<>{}(rhs.request_pan_tilt_zoom_permission, lhs.request_pan_tilt_zoom_permission))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::StreamSelectionInfo::DataView,
                                         ::blink::mojom::blink::StreamSelectionInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::StreamSelectionInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StreamSelectionInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::StreamSelectionInfo::strategy) strategy(
      const ::blink::mojom::blink::StreamSelectionInfoPtr& input) {
    return input->strategy;
  }

  static const decltype(::blink::mojom::blink::StreamSelectionInfo::session_id)& session_id(
      const ::blink::mojom::blink::StreamSelectionInfoPtr& input) {
    return input->session_id;
  }

  static bool Read(::blink::mojom::blink::StreamSelectionInfo::DataView input, ::blink::mojom::blink::StreamSelectionInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MediaStreamDevice::DataView,
                                         ::blink::mojom::blink::MediaStreamDevicePtr> {
  static bool IsNull(const ::blink::mojom::blink::MediaStreamDevicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MediaStreamDevicePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::MediaStreamDevice::type) type(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::id)& id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->id;
  }

  static decltype(::blink::mojom::blink::MediaStreamDevice::video_facing) video_facing(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->video_facing;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::group_id)& group_id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->group_id;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::matched_output_device_id)& matched_output_device_id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->matched_output_device_id;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::name)& name(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::input)& input(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->input;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::session_id)& session_id(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->session_id;
  }

  static const decltype(::blink::mojom::blink::MediaStreamDevice::display_media_info)& display_media_info(
      const ::blink::mojom::blink::MediaStreamDevicePtr& input) {
    return input->display_media_info;
  }

  static bool Read(::blink::mojom::blink::MediaStreamDevice::DataView input, ::blink::mojom::blink::MediaStreamDevicePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TrackControls::DataView,
                                         ::blink::mojom::blink::TrackControlsPtr> {
  static bool IsNull(const ::blink::mojom::blink::TrackControlsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TrackControlsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::TrackControls::requested) requested(
      const ::blink::mojom::blink::TrackControlsPtr& input) {
    return input->requested;
  }

  static decltype(::blink::mojom::blink::TrackControls::stream_type) stream_type(
      const ::blink::mojom::blink::TrackControlsPtr& input) {
    return input->stream_type;
  }

  static const decltype(::blink::mojom::blink::TrackControls::device_id)& device_id(
      const ::blink::mojom::blink::TrackControlsPtr& input) {
    return input->device_id;
  }

  static bool Read(::blink::mojom::blink::TrackControls::DataView input, ::blink::mojom::blink::TrackControlsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::StreamControls::DataView,
                                         ::blink::mojom::blink::StreamControlsPtr> {
  static bool IsNull(const ::blink::mojom::blink::StreamControlsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::StreamControlsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::StreamControls::audio)& audio(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->audio;
  }

  static const decltype(::blink::mojom::blink::StreamControls::video)& video(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->video;
  }

  static decltype(::blink::mojom::blink::StreamControls::hotword_enabled) hotword_enabled(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->hotword_enabled;
  }

  static decltype(::blink::mojom::blink::StreamControls::disable_local_echo) disable_local_echo(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->disable_local_echo;
  }

  static decltype(::blink::mojom::blink::StreamControls::request_pan_tilt_zoom_permission) request_pan_tilt_zoom_permission(
      const ::blink::mojom::blink::StreamControlsPtr& input) {
    return input->request_pan_tilt_zoom_permission;
  }

  static bool Read(::blink::mojom::blink::StreamControls::DataView input, ::blink::mojom::blink::StreamControlsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_H_