// third_party/blink/public/mojom/frame/frame_owner_properties.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
FrameOwnerProperties::FrameOwnerProperties()
    : name(),
      scrollbar_mode(),
      margin_width(),
      margin_height(),
      allow_fullscreen(),
      allow_payment_request(),
      is_display_none(),
      color_scheme(mojo::internal::ConvertEnumValue<ColorScheme, ::blink::ColorScheme>(ColorScheme::kLight)),
      required_csp() {}

FrameOwnerProperties::FrameOwnerProperties(
    const std::string& name_in,
    ::blink::mojom::ScrollbarMode scrollbar_mode_in,
    int32_t margin_width_in,
    int32_t margin_height_in,
    bool allow_fullscreen_in,
    bool allow_payment_request_in,
    bool is_display_none_in,
    ::blink::ColorScheme color_scheme_in,
    const std::string& required_csp_in)
    : name(std::move(name_in)),
      scrollbar_mode(std::move(scrollbar_mode_in)),
      margin_width(std::move(margin_width_in)),
      margin_height(std::move(margin_height_in)),
      allow_fullscreen(std::move(allow_fullscreen_in)),
      allow_payment_request(std::move(allow_payment_request_in)),
      is_display_none(std::move(is_display_none_in)),
      color_scheme(std::move(color_scheme_in)),
      required_csp(std::move(required_csp_in)) {}

FrameOwnerProperties::~FrameOwnerProperties() = default;

void FrameOwnerProperties::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", this->name);
  value->SetString("scrollbar_mode", base::trace_event::ValueToString(this->scrollbar_mode));
  value->SetInteger("margin_width", this->margin_width);
  value->SetInteger("margin_height", this->margin_height);
  value->SetBoolean("allow_fullscreen", this->allow_fullscreen);
  value->SetBoolean("allow_payment_request", this->allow_payment_request);
  value->SetBoolean("is_display_none", this->is_display_none);
  value->SetInteger("color_scheme", static_cast<int>(this->color_scheme));
  value->SetString("required_csp", this->required_csp);
}

bool FrameOwnerProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FrameOwnerProperties::DataView, ::blink::mojom::FrameOwnerPropertiesPtr>::Read(
    ::blink::mojom::FrameOwnerProperties::DataView input,
    ::blink::mojom::FrameOwnerPropertiesPtr* output) {
  bool success = true;
  ::blink::mojom::FrameOwnerPropertiesPtr result(::blink::mojom::FrameOwnerProperties::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadScrollbarMode(&result->scrollbar_mode))
        success = false;
      if (success)
        result->margin_width = input.margin_width();
      if (success)
        result->margin_height = input.margin_height();
      if (success)
        result->allow_fullscreen = input.allow_fullscreen();
      if (success)
        result->allow_payment_request = input.allow_payment_request();
      if (success)
        result->is_display_none = input.is_display_none();
      if (success && !input.ReadColorScheme(&result->color_scheme))
        success = false;
      if (success && !input.ReadRequiredCsp(&result->required_csp))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif