// third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/scroll/scrollbar_mode.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class FrameOwnerPropertiesDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FrameOwnerPropertiesDataView> {
  using Data = ::blink::mojom::internal::FrameOwnerProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class ColorScheme : int32_t {
  
  kLight = 0,
  
  kDark = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ColorScheme value);
inline bool IsKnownEnumValue(ColorScheme value) {
  return internal::ColorScheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FrameOwnerPropertiesDataView {
 public:
  FrameOwnerPropertiesDataView() {}

  FrameOwnerPropertiesDataView(
      internal::FrameOwnerProperties_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScrollbarMode(UserType* output) const {
    auto data_value = data_->scrollbar_mode;
    return mojo::internal::Deserialize<::blink::mojom::ScrollbarMode>(
        data_value, output);
  }

  ::blink::mojom::ScrollbarMode scrollbar_mode() const {
    return static_cast<::blink::mojom::ScrollbarMode>(data_->scrollbar_mode);
  }
  int32_t margin_width() const {
    return data_->margin_width;
  }
  int32_t margin_height() const {
    return data_->margin_height;
  }
  bool allow_fullscreen() const {
    return data_->allow_fullscreen;
  }
  bool allow_payment_request() const {
    return data_->allow_payment_request;
  }
  bool is_display_none() const {
    return data_->is_display_none;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadColorScheme(UserType* output) const {
    auto data_value = data_->color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::ColorScheme>(
        data_value, output);
  }

  ColorScheme color_scheme() const {
    return static_cast<ColorScheme>(data_->color_scheme);
  }
  inline void GetRequiredCspDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequiredCsp(UserType* output) {
    
    auto* pointer = data_->required_csp.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameOwnerProperties_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::ColorScheme>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ColorScheme> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::ColorScheme, ::blink::mojom::ColorScheme> {
  static ::blink::mojom::ColorScheme ToMojom(::blink::mojom::ColorScheme input) { return input; }
  static bool FromMojom(::blink::mojom::ColorScheme input, ::blink::mojom::ColorScheme* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ColorScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ColorScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ColorScheme>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameOwnerPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FrameOwnerPropertiesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FrameOwnerProperties_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FrameOwnerProperties struct");
    mojo::internal::Serialize<::blink::mojom::ScrollbarMode>(
        Traits::scrollbar_mode(input), &(*output)->scrollbar_mode);
    (*output)->margin_width = Traits::margin_width(input);
    (*output)->margin_height = Traits::margin_height(input);
    (*output)->allow_fullscreen = Traits::allow_fullscreen(input);
    (*output)->allow_payment_request = Traits::allow_payment_request(input);
    (*output)->is_display_none = Traits::is_display_none(input);
    mojo::internal::Serialize<::blink::mojom::ColorScheme>(
        Traits::color_scheme(input), &(*output)->color_scheme);
    decltype(Traits::required_csp(input)) in_required_csp = Traits::required_csp(input);
    typename decltype((*output)->required_csp)::BaseType::BufferWriter
        required_csp_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_required_csp, buffer, &required_csp_writer, context);
    (*output)->required_csp.Set(
        required_csp_writer.is_null() ? nullptr : required_csp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->required_csp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_csp in FrameOwnerProperties struct");
  }

  static bool Deserialize(::blink::mojom::internal::FrameOwnerProperties_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FrameOwnerPropertiesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void FrameOwnerPropertiesDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void FrameOwnerPropertiesDataView::GetRequiredCspDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->required_csp.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_OWNER_PROPERTIES_MOJOM_SHARED_H_