// third_party/blink/public/mojom/frame/find_in_page.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/find_in_page.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/find_in_page.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/find_in_page.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/find_in_page.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FIND_IN_PAGE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FIND_IN_PAGE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
FindOptions::FindOptions()
    : forward(true),
      match_case(false),
      new_session(true),
      find_match(true),
      force(false),
      run_synchronously_for_testing(false) {}

FindOptions::FindOptions(
    bool forward_in,
    bool match_case_in,
    bool new_session_in,
    bool find_match_in,
    bool force_in,
    bool run_synchronously_for_testing_in)
    : forward(std::move(forward_in)),
      match_case(std::move(match_case_in)),
      new_session(std::move(new_session_in)),
      find_match(std::move(find_match_in)),
      force(std::move(force_in)),
      run_synchronously_for_testing(std::move(run_synchronously_for_testing_in)) {}

FindOptions::~FindOptions() = default;
size_t FindOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->forward);
  seed = mojo::internal::Hash(seed, this->match_case);
  seed = mojo::internal::Hash(seed, this->new_session);
  seed = mojo::internal::Hash(seed, this->find_match);
  seed = mojo::internal::Hash(seed, this->force);
  seed = mojo::internal::Hash(seed, this->run_synchronously_for_testing);
  return seed;
}

void FindOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("forward", this->forward);
  value->SetBoolean("match_case", this->match_case);
  value->SetBoolean("new_session", this->new_session);
  value->SetBoolean("find_match", this->find_match);
  value->SetBoolean("force", this->force);
  value->SetBoolean("run_synchronously_for_testing", this->run_synchronously_for_testing);
}

bool FindOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char FindInPage::Name_[] = "blink.mojom.FindInPage";

class FindInPage_GetNearestFindResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FindInPage_GetNearestFindResult_ForwardToCallback(
      FindInPage::GetNearestFindResultCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FindInPage::GetNearestFindResultCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FindInPage_GetNearestFindResult_ForwardToCallback);
};

class FindInPage_FindMatchRects_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FindInPage_FindMatchRects_ForwardToCallback(
      FindInPage::FindMatchRectsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FindInPage::FindMatchRectsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FindInPage_FindMatchRects_ForwardToCallback);
};

FindInPageProxy::FindInPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FindInPageProxy::Find(
    int32_t in_request_id, const std::string& in_search_text, FindOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPage::Find", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("request_id", in_request_id);
      raw_value->SetString("search_text", in_search_text);
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_Find_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_Find_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->request_id = in_request_id;
  typename decltype(params->search_text)::BaseType::BufferWriter
      search_text_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_search_text, buffer, &search_text_writer, &serialization_context);
  params->search_text.Set(
      search_text_writer.is_null() ? nullptr : search_text_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->search_text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null search_text in FindInPage.Find request");
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::blink::mojom::FindOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in FindInPage.Find request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("Find");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FindInPageProxy::StopFinding(
    StopFindAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPage::StopFinding", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("action", base::trace_event::ValueToString(in_action));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_StopFinding_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_StopFinding_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::StopFindAction>(
      in_action, &params->action);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("StopFinding");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FindInPageProxy::ClearActiveFindMatch(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FindInPage::ClearActiveFindMatch");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_ClearActiveFindMatch_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_ClearActiveFindMatch_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("ClearActiveFindMatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FindInPageProxy::GetNearestFindResult(
    const ::gfx::PointF& in_point, GetNearestFindResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPage::GetNearestFindResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("point", base::trace_event::ValueToString(in_point, "<value of type const ::gfx::PointF&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_GetNearestFindResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_GetNearestFindResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->point)::BaseType::BufferWriter
      point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_point, buffer, &point_writer, &serialization_context);
  params->point.Set(
      point_writer.is_null() ? nullptr : point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in FindInPage.GetNearestFindResult request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("GetNearestFindResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FindInPage_GetNearestFindResult_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FindInPageProxy::ActivateNearestFindResult(
    int32_t in_request_id, const ::gfx::PointF& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPage::ActivateNearestFindResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("request_id", in_request_id);
      raw_value->SetString("point", base::trace_event::ValueToString(in_point, "<value of type const ::gfx::PointF&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_ActivateNearestFindResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_ActivateNearestFindResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->request_id = in_request_id;
  typename decltype(params->point)::BaseType::BufferWriter
      point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_point, buffer, &point_writer, &serialization_context);
  params->point.Set(
      point_writer.is_null() ? nullptr : point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in FindInPage.ActivateNearestFindResult request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("ActivateNearestFindResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FindInPageProxy::SetClient(
    ::mojo::PendingRemote<FindInPageClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPage::SetClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_SetClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_SetClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FindInPageClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in FindInPage.SetClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FindInPageProxy::FindMatchRects(
    int32_t in_current_version, FindMatchRectsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPage::FindMatchRects", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("current_version", in_current_version);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_FindMatchRects_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_FindMatchRects_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->current_version = in_current_version;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("FindMatchRects");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FindInPage_FindMatchRects_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FindInPage_GetNearestFindResult_ProxyToResponder {
 public:
  static FindInPage::GetNearestFindResultCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FindInPage_GetNearestFindResult_ProxyToResponder> proxy(
        new FindInPage_GetNearestFindResult_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FindInPage_GetNearestFindResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FindInPage_GetNearestFindResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FindInPage_GetNearestFindResult_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FindInPage::GetNearestFindResultCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      float in_distance);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FindInPage_GetNearestFindResult_ProxyToResponder);
};

bool FindInPage_GetNearestFindResult_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FindInPage::GetNearestFindResultCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FindInPage_GetNearestFindResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FindInPage_GetNearestFindResult_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  float p_distance{};
  FindInPage_GetNearestFindResult_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_distance = input_data_view.distance();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FindInPage::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_distance));
  return true;
}

void FindInPage_GetNearestFindResult_ProxyToResponder::Run(
    float in_distance) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FindInPage::GetNearestFindResultCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetDouble("distance", in_distance);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_GetNearestFindResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_GetNearestFindResult_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->distance = in_distance;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FindInPage::GetNearestFindResultCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("GetNearestFindResult");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FindInPage_FindMatchRects_ProxyToResponder {
 public:
  static FindInPage::FindMatchRectsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FindInPage_FindMatchRects_ProxyToResponder> proxy(
        new FindInPage_FindMatchRects_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FindInPage_FindMatchRects_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FindInPage_FindMatchRects_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FindInPage_FindMatchRects_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FindInPage::FindMatchRectsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_version, const std::vector<::gfx::RectF>& in_rects, const ::gfx::RectF& in_active_match_rect);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FindInPage_FindMatchRects_ProxyToResponder);
};

bool FindInPage_FindMatchRects_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FindInPage::FindMatchRectsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FindInPage_FindMatchRects_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FindInPage_FindMatchRects_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_version{};
  std::vector<::gfx::RectF> p_rects{};
  ::gfx::RectF p_active_match_rect{};
  FindInPage_FindMatchRects_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_version = input_data_view.version();
  if (success && !input_data_view.ReadRects(&p_rects))
    success = false;
  if (success && !input_data_view.ReadActiveMatchRect(&p_active_match_rect))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FindInPage::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_version), 
std::move(p_rects), 
std::move(p_active_match_rect));
  return true;
}

void FindInPage_FindMatchRects_ProxyToResponder::Run(
    int32_t in_version, const std::vector<::gfx::RectF>& in_rects, const ::gfx::RectF& in_active_match_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FindInPage::FindMatchRectsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("version", in_version);
      raw_value->BeginArray("rects");
      for (const auto& item0 : in_rects) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::gfx::RectF&>"));
      }
      raw_value->EndArray();
      raw_value->SetString("active_match_rect", base::trace_event::ValueToString(in_active_match_rect, "<value of type const ::gfx::RectF&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPage_FindMatchRects_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPage_FindMatchRects_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->version = in_version;
  typename decltype(params->rects)::BaseType::BufferWriter
      rects_writer;
  const mojo::internal::ContainerValidateParams rects_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectFDataView>>(
      in_rects, buffer, &rects_writer, &rects_validate_params,
      &serialization_context);
  params->rects.Set(
      rects_writer.is_null() ? nullptr : rects_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rects.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rects in ");
  typename decltype(params->active_match_rect)::BaseType::BufferWriter
      active_match_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_active_match_rect, buffer, &active_match_rect_writer, &serialization_context);
  params->active_match_rect.Set(
      active_match_rect_writer.is_null() ? nullptr : active_match_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->active_match_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null active_match_rect in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FindInPage::FindMatchRectsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("FindMatchRects");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FindInPageStubDispatch::Accept(
    FindInPage* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFindInPage_Find_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPage::Find",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPage::Find");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FindInPage_Find_Params_Data* params =
          reinterpret_cast<internal::FindInPage_Find_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      std::string p_search_text{};
      FindOptionsPtr p_options{};
      FindInPage_Find_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadSearchText(&p_search_text))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Find(
std::move(p_request_id), 
std::move(p_search_text), 
std::move(p_options));
      return true;
    }
    case internal::kFindInPage_StopFinding_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPage::StopFinding",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPage::StopFinding");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FindInPage_StopFinding_Params_Data* params =
          reinterpret_cast<internal::FindInPage_StopFinding_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      StopFindAction p_action{};
      FindInPage_StopFinding_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopFinding(
std::move(p_action));
      return true;
    }
    case internal::kFindInPage_ClearActiveFindMatch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPage::ClearActiveFindMatch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPage::ClearActiveFindMatch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FindInPage_ClearActiveFindMatch_Params_Data* params =
          reinterpret_cast<internal::FindInPage_ClearActiveFindMatch_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FindInPage_ClearActiveFindMatch_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearActiveFindMatch();
      return true;
    }
    case internal::kFindInPage_GetNearestFindResult_Name: {
      break;
    }
    case internal::kFindInPage_ActivateNearestFindResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPage::ActivateNearestFindResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPage::ActivateNearestFindResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FindInPage_ActivateNearestFindResult_Params_Data* params =
          reinterpret_cast<internal::FindInPage_ActivateNearestFindResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      ::gfx::PointF p_point{};
      FindInPage_ActivateNearestFindResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateNearestFindResult(
std::move(p_request_id), 
std::move(p_point));
      return true;
    }
    case internal::kFindInPage_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPage::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPage::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FindInPage_SetClient_Params_Data* params =
          reinterpret_cast<internal::FindInPage_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<FindInPageClient> p_client{};
      FindInPage_SetClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kFindInPage_FindMatchRects_Name: {
      break;
    }
  }
  return false;
}

// static
bool FindInPageStubDispatch::AcceptWithResponder(
    FindInPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFindInPage_Find_Name: {
      break;
    }
    case internal::kFindInPage_StopFinding_Name: {
      break;
    }
    case internal::kFindInPage_ClearActiveFindMatch_Name: {
      break;
    }
    case internal::kFindInPage_GetNearestFindResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPage::GetNearestFindResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPage::GetNearestFindResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FindInPage_GetNearestFindResult_Params_Data* params =
          reinterpret_cast<
              internal::FindInPage_GetNearestFindResult_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_point{};
      FindInPage_GetNearestFindResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 3, false);
        return false;
      }
      FindInPage::GetNearestFindResultCallback callback =
          FindInPage_GetNearestFindResult_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNearestFindResult(
std::move(p_point), std::move(callback));
      return true;
    }
    case internal::kFindInPage_ActivateNearestFindResult_Name: {
      break;
    }
    case internal::kFindInPage_SetClient_Name: {
      break;
    }
    case internal::kFindInPage_FindMatchRects_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPage::FindMatchRects",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPage::FindMatchRects");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FindInPage_FindMatchRects_Params_Data* params =
          reinterpret_cast<
              internal::FindInPage_FindMatchRects_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_current_version{};
      FindInPage_FindMatchRects_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_current_version = input_data_view.current_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 6, false);
        return false;
      }
      FindInPage::FindMatchRectsCallback callback =
          FindInPage_FindMatchRects_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindMatchRects(
std::move(p_current_version), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFindInPageValidationInfo[] = {
    {internal::kFindInPage_Find_Name,
     {&internal::FindInPage_Find_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFindInPage_StopFinding_Name,
     {&internal::FindInPage_StopFinding_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFindInPage_ClearActiveFindMatch_Name,
     {&internal::FindInPage_ClearActiveFindMatch_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFindInPage_GetNearestFindResult_Name,
     {&internal::FindInPage_GetNearestFindResult_Params_Data::Validate,
      &internal::FindInPage_GetNearestFindResult_ResponseParams_Data::Validate}},
    {internal::kFindInPage_ActivateNearestFindResult_Name,
     {&internal::FindInPage_ActivateNearestFindResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFindInPage_SetClient_Name,
     {&internal::FindInPage_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFindInPage_FindMatchRects_Name,
     {&internal::FindInPage_FindMatchRects_Params_Data::Validate,
      &internal::FindInPage_FindMatchRects_ResponseParams_Data::Validate}},
};

bool FindInPageRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FindInPage::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFindInPageValidationInfo);
}

bool FindInPageResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FindInPage::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFindInPageValidationInfo);

}
const char FindInPageClient::Name_[] = "blink.mojom.FindInPageClient";

FindInPageClientProxy::FindInPageClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FindInPageClientProxy::SetNumberOfMatches(
    int32_t in_request_id, uint32_t in_number_of_matches, FindMatchUpdateType in_update_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPageClient::SetNumberOfMatches", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("request_id", in_request_id);
      raw_value->SetString("number_of_matches", base::NumberToString(in_number_of_matches));
      raw_value->SetString("update_type", base::trace_event::ValueToString(in_update_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPageClient_SetNumberOfMatches_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPageClient_SetNumberOfMatches_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->request_id = in_request_id;
  params->number_of_matches = in_number_of_matches;
  mojo::internal::Serialize<::blink::mojom::FindMatchUpdateType>(
      in_update_type, &params->update_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPageClient::Name_);
  message.set_method_name("SetNumberOfMatches");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FindInPageClientProxy::SetActiveMatch(
    int32_t in_request_id, const ::gfx::Rect& in_active_match_rect, int32_t in_active_match_ordinal, FindMatchUpdateType in_update_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FindInPageClient::SetActiveMatch", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("request_id", in_request_id);
      raw_value->SetString("active_match_rect", base::trace_event::ValueToString(in_active_match_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetInteger("active_match_ordinal", in_active_match_ordinal);
      raw_value->SetString("update_type", base::trace_event::ValueToString(in_update_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFindInPageClient_SetActiveMatch_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FindInPageClient_SetActiveMatch_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->request_id = in_request_id;
  typename decltype(params->active_match_rect)::BaseType::BufferWriter
      active_match_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_active_match_rect, buffer, &active_match_rect_writer, &serialization_context);
  params->active_match_rect.Set(
      active_match_rect_writer.is_null() ? nullptr : active_match_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->active_match_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null active_match_rect in FindInPageClient.SetActiveMatch request");
  params->active_match_ordinal = in_active_match_ordinal;
  mojo::internal::Serialize<::blink::mojom::FindMatchUpdateType>(
      in_update_type, &params->update_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPageClient::Name_);
  message.set_method_name("SetActiveMatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FindInPageClientStubDispatch::Accept(
    FindInPageClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFindInPageClient_SetNumberOfMatches_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPageClient::SetNumberOfMatches",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPageClient::SetNumberOfMatches");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FindInPageClient_SetNumberOfMatches_Params_Data* params =
          reinterpret_cast<internal::FindInPageClient_SetNumberOfMatches_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      uint32_t p_number_of_matches{};
      FindMatchUpdateType p_update_type{};
      FindInPageClient_SetNumberOfMatches_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_number_of_matches = input_data_view.number_of_matches();
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPageClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNumberOfMatches(
std::move(p_request_id), 
std::move(p_number_of_matches), 
std::move(p_update_type));
      return true;
    }
    case internal::kFindInPageClient_SetActiveMatch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FindInPageClient::SetActiveMatch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FindInPageClient::SetActiveMatch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FindInPageClient_SetActiveMatch_Params_Data* params =
          reinterpret_cast<internal::FindInPageClient_SetActiveMatch_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      ::gfx::Rect p_active_match_rect{};
      int32_t p_active_match_ordinal{};
      FindMatchUpdateType p_update_type{};
      FindInPageClient_SetActiveMatch_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadActiveMatchRect(&p_active_match_rect))
        success = false;
      if (success)
        p_active_match_ordinal = input_data_view.active_match_ordinal();
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPageClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActiveMatch(
std::move(p_request_id), 
std::move(p_active_match_rect), 
std::move(p_active_match_ordinal), 
std::move(p_update_type));
      return true;
    }
  }
  return false;
}

// static
bool FindInPageClientStubDispatch::AcceptWithResponder(
    FindInPageClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFindInPageClient_SetNumberOfMatches_Name: {
      break;
    }
    case internal::kFindInPageClient_SetActiveMatch_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFindInPageClientValidationInfo[] = {
    {internal::kFindInPageClient_SetNumberOfMatches_Name,
     {&internal::FindInPageClient_SetNumberOfMatches_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFindInPageClient_SetActiveMatch_Name,
     {&internal::FindInPageClient_SetActiveMatch_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FindInPageClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FindInPageClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFindInPageClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FindOptions::DataView, ::blink::mojom::FindOptionsPtr>::Read(
    ::blink::mojom::FindOptions::DataView input,
    ::blink::mojom::FindOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::FindOptionsPtr result(::blink::mojom::FindOptions::New());
  
      if (success)
        result->forward = input.forward();
      if (success)
        result->match_case = input.match_case();
      if (success)
        result->new_session = input.new_session();
      if (success)
        result->find_match = input.find_match();
      if (success)
        result->force = input.force();
      if (success)
        result->run_synchronously_for_testing = input.run_synchronously_for_testing();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif