// third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_DIRECTORY_HANDLE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_DIRECTORY_HANDLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom-forward.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_error.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class NativeFileSystemDirectoryEntriesListenerProxy;

template <typename ImplRefTraits>
class NativeFileSystemDirectoryEntriesListenerStub;

class NativeFileSystemDirectoryEntriesListenerRequestValidator;


class BLINK_COMMON_EXPORT NativeFileSystemDirectoryEntriesListener
    : public NativeFileSystemDirectoryEntriesListenerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NativeFileSystemDirectoryEntriesListenerInterfaceBase;
  using Proxy_ = NativeFileSystemDirectoryEntriesListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeFileSystemDirectoryEntriesListenerStub<ImplRefTraits>;

  using RequestValidator_ = NativeFileSystemDirectoryEntriesListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReadDirectoryMinVersion = 0,
  };
  virtual ~NativeFileSystemDirectoryEntriesListener() {}

  
  virtual void DidReadDirectory(::blink::mojom::NativeFileSystemErrorPtr result, std::vector<NativeFileSystemEntryPtr> entries, bool has_more_entries) = 0;
};

class NativeFileSystemDirectoryHandleProxy;

template <typename ImplRefTraits>
class NativeFileSystemDirectoryHandleStub;

class NativeFileSystemDirectoryHandleRequestValidator;
class NativeFileSystemDirectoryHandleResponseValidator;


class BLINK_COMMON_EXPORT NativeFileSystemDirectoryHandle
    : public NativeFileSystemDirectoryHandleInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NativeFileSystemDirectoryHandleInterfaceBase;
  using Proxy_ = NativeFileSystemDirectoryHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeFileSystemDirectoryHandleStub<ImplRefTraits>;

  using RequestValidator_ = NativeFileSystemDirectoryHandleRequestValidator;
  using ResponseValidator_ = NativeFileSystemDirectoryHandleResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPermissionStatusMinVersion = 0,
    kRequestPermissionMinVersion = 0,
    kGetFileMinVersion = 0,
    kGetDirectoryMinVersion = 0,
    kGetEntriesMinVersion = 0,
    kRemoveEntryMinVersion = 0,
    kResolveMinVersion = 0,
    kTransferMinVersion = 0,
  };
  virtual ~NativeFileSystemDirectoryHandle() {}


  using GetPermissionStatusCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;
  
  virtual void GetPermissionStatus(bool writable, GetPermissionStatusCallback callback) = 0;


  using RequestPermissionCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, ::blink::mojom::PermissionStatus)>;
  
  virtual void RequestPermission(bool writable, RequestPermissionCallback callback) = 0;


  using GetFileCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle>)>;
  
  virtual void GetFile(const std::string& basename, bool create, GetFileCallback callback) = 0;


  using GetDirectoryCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, ::mojo::PendingRemote<NativeFileSystemDirectoryHandle>)>;
  
  virtual void GetDirectory(const std::string& basename, bool create, GetDirectoryCallback callback) = 0;

  
  virtual void GetEntries(::mojo::PendingRemote<NativeFileSystemDirectoryEntriesListener> listener) = 0;


  using RemoveEntryCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr)>;
  
  virtual void RemoveEntry(const std::string& basename, bool recurse, RemoveEntryCallback callback) = 0;


  using ResolveCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, const base::Optional<std::vector<std::string>>&)>;
  
  virtual void Resolve(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> possible_child, ResolveCallback callback) = 0;

  
  virtual void Transfer(::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> token) = 0;
};



class BLINK_COMMON_EXPORT NativeFileSystemDirectoryEntriesListenerProxy
    : public NativeFileSystemDirectoryEntriesListener {
 public:
  using InterfaceType = NativeFileSystemDirectoryEntriesListener;

  explicit NativeFileSystemDirectoryEntriesListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReadDirectory(::blink::mojom::NativeFileSystemErrorPtr result, std::vector<NativeFileSystemEntryPtr> entries, bool has_more_entries) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT NativeFileSystemDirectoryHandleProxy
    : public NativeFileSystemDirectoryHandle {
 public:
  using InterfaceType = NativeFileSystemDirectoryHandle;

  explicit NativeFileSystemDirectoryHandleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPermissionStatus(bool writable, GetPermissionStatusCallback callback) final;
  
  void RequestPermission(bool writable, RequestPermissionCallback callback) final;
  
  void GetFile(const std::string& basename, bool create, GetFileCallback callback) final;
  
  void GetDirectory(const std::string& basename, bool create, GetDirectoryCallback callback) final;
  
  void GetEntries(::mojo::PendingRemote<NativeFileSystemDirectoryEntriesListener> listener) final;
  
  void RemoveEntry(const std::string& basename, bool recurse, RemoveEntryCallback callback) final;
  
  void Resolve(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> possible_child, ResolveCallback callback) final;
  
  void Transfer(::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT NativeFileSystemDirectoryEntriesListenerStubDispatch {
 public:
  static bool Accept(NativeFileSystemDirectoryEntriesListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeFileSystemDirectoryEntriesListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeFileSystemDirectoryEntriesListener>>
class NativeFileSystemDirectoryEntriesListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeFileSystemDirectoryEntriesListenerStub() {}
  ~NativeFileSystemDirectoryEntriesListenerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemDirectoryEntriesListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemDirectoryEntriesListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT NativeFileSystemDirectoryHandleStubDispatch {
 public:
  static bool Accept(NativeFileSystemDirectoryHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeFileSystemDirectoryHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeFileSystemDirectoryHandle>>
class NativeFileSystemDirectoryHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeFileSystemDirectoryHandleStub() {}
  ~NativeFileSystemDirectoryHandleStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemDirectoryHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemDirectoryHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT NativeFileSystemDirectoryEntriesListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT NativeFileSystemDirectoryHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT NativeFileSystemDirectoryHandleResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_COMMON_EXPORT NativeFileSystemHandle {
 public:
  using DataView = NativeFileSystemHandleDataView;
  using Data_ = internal::NativeFileSystemHandle_Data;
  using Tag = Data_::NativeFileSystemHandle_Tag;

  static NativeFileSystemHandlePtr New() {
    return NativeFileSystemHandlePtr(base::in_place);
  }
  // Construct an instance holding |file|.
  static NativeFileSystemHandlePtr
  NewFile(
      ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle> file) {
    auto result = NativeFileSystemHandlePtr(base::in_place);
    result->set_file(std::move(file));
    return result;
  }
  // Construct an instance holding |directory|.
  static NativeFileSystemHandlePtr
  NewDirectory(
      ::mojo::PendingRemote<NativeFileSystemDirectoryHandle> directory) {
    auto result = NativeFileSystemHandlePtr(base::in_place);
    result->set_directory(std::move(directory));
    return result;
  }

  template <typename U>
  static NativeFileSystemHandlePtr From(const U& u) {
    return mojo::TypeConverter<NativeFileSystemHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativeFileSystemHandle>::Convert(*this);
  }

  NativeFileSystemHandle();
  ~NativeFileSystemHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = NativeFileSystemHandlePtr>
  NativeFileSystemHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, NativeFileSystemHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_file() const { return tag_ == Tag::FILE; }

  
  ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle>& get_file() const {
    DCHECK(tag_ == Tag::FILE);
    return *(data_.file);
  }

  
  void set_file(
      ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle> file);
  
  bool is_directory() const { return tag_ == Tag::DIRECTORY; }

  
  ::mojo::PendingRemote<NativeFileSystemDirectoryHandle>& get_directory() const {
    DCHECK(tag_ == Tag::DIRECTORY);
    return *(data_.directory);
  }

  
  void set_directory(
      ::mojo::PendingRemote<NativeFileSystemDirectoryHandle> directory);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativeFileSystemHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<NativeFileSystemHandle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle>* file;
    ::mojo::PendingRemote<NativeFileSystemDirectoryHandle>* directory;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT NativeFileSystemEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativeFileSystemEntry, T>::value>;
  using DataView = NativeFileSystemEntryDataView;
  using Data_ = internal::NativeFileSystemEntry_Data;

  template <typename... Args>
  static NativeFileSystemEntryPtr New(Args&&... args) {
    return NativeFileSystemEntryPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativeFileSystemEntryPtr From(const U& u) {
    return mojo::TypeConverter<NativeFileSystemEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativeFileSystemEntry>::Convert(*this);
  }


  NativeFileSystemEntry();

  NativeFileSystemEntry(
      NativeFileSystemHandlePtr entry_handle,
      const std::string& name);

  ~NativeFileSystemEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativeFileSystemEntryPtr>
  NativeFileSystemEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativeFileSystemEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NativeFileSystemEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativeFileSystemEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativeFileSystemEntry_UnserializedMessageContext<
            UserType, NativeFileSystemEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NativeFileSystemEntry::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NativeFileSystemEntry::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativeFileSystemEntry_UnserializedMessageContext<
            UserType, NativeFileSystemEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativeFileSystemEntry::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  NativeFileSystemHandlePtr entry_handle;
  
  std::string name;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemEntry);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativeFileSystemEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativeFileSystemEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativeFileSystemEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativeFileSystemEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
NativeFileSystemHandlePtr NativeFileSystemHandle::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::FILE:
      rv->set_file(mojo::Clone(*data_.file));
      break;
    case Tag::DIRECTORY:
      rv->set_directory(mojo::Clone(*data_.directory));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, NativeFileSystemHandle>::value>::type*>
bool NativeFileSystemHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::FILE:
      return mojo::Equals(*(data_.file), *(other.data_.file));
    case Tag::DIRECTORY:
      return mojo::Equals(*(data_.directory), *(other.data_.directory));
  }

  return false;
}
template <typename StructPtrType>
NativeFileSystemEntryPtr NativeFileSystemEntry::Clone() const {
  return New(
      mojo::Clone(entry_handle),
      mojo::Clone(name)
  );
}

template <typename T, NativeFileSystemEntry::EnableIfSame<T>*>
bool NativeFileSystemEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->entry_handle, other_struct.entry_handle))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, NativeFileSystemEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.entry_handle, rhs.entry_handle))
    return true;
  if (std::less<>{}(rhs.entry_handle, lhs.entry_handle))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::NativeFileSystemEntry::DataView,
                                         ::blink::mojom::NativeFileSystemEntryPtr> {
  static bool IsNull(const ::blink::mojom::NativeFileSystemEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::NativeFileSystemEntryPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::NativeFileSystemEntry::entry_handle)& entry_handle(
       ::blink::mojom::NativeFileSystemEntryPtr& input) {
    return input->entry_handle;
  }

  static const decltype(::blink::mojom::NativeFileSystemEntry::name)& name(
      const ::blink::mojom::NativeFileSystemEntryPtr& input) {
    return input->name;
  }

  static bool Read(::blink::mojom::NativeFileSystemEntry::DataView input, ::blink::mojom::NativeFileSystemEntryPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::NativeFileSystemHandle::DataView,
                                        ::blink::mojom::NativeFileSystemHandlePtr> {
  static bool IsNull(const ::blink::mojom::NativeFileSystemHandlePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::NativeFileSystemHandlePtr* output) { output->reset(); }

  static ::blink::mojom::NativeFileSystemHandle::Tag GetTag(const ::blink::mojom::NativeFileSystemHandlePtr& input) {
    return input->which();
  }

  static  ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle>& file( ::blink::mojom::NativeFileSystemHandlePtr& input) {
    return input->get_file();
  }

  static  ::mojo::PendingRemote<::blink::mojom::NativeFileSystemDirectoryHandle>& directory( ::blink::mojom::NativeFileSystemHandlePtr& input) {
    return input->get_directory();
  }

  static bool Read(::blink::mojom::NativeFileSystemHandle::DataView input, ::blink::mojom::NativeFileSystemHandlePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_DIRECTORY_HANDLE_MOJOM_H_