// third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-params-data.h"
#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_BLINK_JUMBO_H_
#endif
namespace payments {
namespace mojom {
namespace blink {
ItemDetails::ItemDetails()
    : item_id(),
      title(),
      description(),
      price() {}

ItemDetails::ItemDetails(
    const WTF::String& item_id_in,
    const WTF::String& title_in,
    const WTF::String& description_in,
    ::payments::mojom::blink::PaymentCurrencyAmountPtr price_in)
    : item_id(std::move(item_id_in)),
      title(std::move(title_in)),
      description(std::move(description_in)),
      price(std::move(price_in)) {}

ItemDetails::~ItemDetails() = default;
size_t ItemDetails::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->item_id);
  seed = mojo::internal::WTFHash(seed, this->title);
  seed = mojo::internal::WTFHash(seed, this->description);
  seed = mojo::internal::WTFHash(seed, this->price);
  return seed;
}

void ItemDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("item_id", this->item_id.Utf8());
  value->SetString("title", this->title.Utf8());
  value->SetString("description", this->description.Utf8());
  if (this->price.is_null()) {
    value->SetString("price", "nullptr");
  } else {
    value->BeginDictionary("price");
    this->price->AsValueInto(value);
    value->EndDictionary();
  }
}

bool ItemDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DigitalGoods::Name_[] = "payments.mojom.DigitalGoods";

class DigitalGoods_GetDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_GetDetails_ForwardToCallback(
      DigitalGoods::GetDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::GetDetailsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_GetDetails_ForwardToCallback);
};

class DigitalGoods_Acknowledge_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_Acknowledge_ForwardToCallback(
      DigitalGoods::AcknowledgeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::AcknowledgeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_Acknowledge_ForwardToCallback);
};

DigitalGoodsProxy::DigitalGoodsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DigitalGoodsProxy::GetDetails(
    const WTF::Vector<WTF::String>& in_item_ids, GetDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::DigitalGoods::GetDetails", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("item_ids");
      for (const auto& item0 : in_item_ids) {
        raw_value->AppendString(item0.Utf8());
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDigitalGoods_GetDetails_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::DigitalGoods_GetDetails_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->item_ids)::BaseType::BufferWriter
      item_ids_writer;
  const mojo::internal::ContainerValidateParams item_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_item_ids, buffer, &item_ids_writer, &item_ids_validate_params,
      &serialization_context);
  params->item_ids.Set(
      item_ids_writer.is_null() ? nullptr : item_ids_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->item_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_ids in DigitalGoods.GetDetails request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("GetDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_GetDetails_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DigitalGoodsProxy::Acknowledge(
    const WTF::String& in_purchase_token, bool in_make_available_again, AcknowledgeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::DigitalGoods::Acknowledge", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("purchase_token", in_purchase_token.Utf8());
      raw_value->SetBoolean("make_available_again", in_make_available_again);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDigitalGoods_Acknowledge_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::DigitalGoods_Acknowledge_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->purchase_token)::BaseType::BufferWriter
      purchase_token_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_purchase_token, buffer, &purchase_token_writer, &serialization_context);
  params->purchase_token.Set(
      purchase_token_writer.is_null() ? nullptr : purchase_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->purchase_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purchase_token in DigitalGoods.Acknowledge request");
  params->make_available_again = in_make_available_again;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("Acknowledge");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_Acknowledge_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DigitalGoods_GetDetails_ProxyToResponder {
 public:
  static DigitalGoods::GetDetailsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DigitalGoods_GetDetails_ProxyToResponder> proxy(
        new DigitalGoods_GetDetails_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DigitalGoods_GetDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_GetDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DigitalGoods_GetDetails_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::GetDetailsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BillingResponseCode in_code, WTF::Vector<ItemDetailsPtr> in_item_details_list);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_GetDetails_ProxyToResponder);
};

bool DigitalGoods_GetDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::DigitalGoods::GetDetailsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::DigitalGoods_GetDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_GetDetails_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  BillingResponseCode p_code{};
  WTF::Vector<ItemDetailsPtr> p_item_details_list{};
  DigitalGoods_GetDetails_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success && !input_data_view.ReadItemDetailsList(&p_item_details_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_item_details_list));
  return true;
}

void DigitalGoods_GetDetails_ProxyToResponder::Run(
    BillingResponseCode in_code, WTF::Vector<ItemDetailsPtr> in_item_details_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::DigitalGoods::GetDetailsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("code", base::trace_event::ValueToString(in_code));
      raw_value->BeginArray("item_details_list");
      for (const auto& item0 : in_item_details_list) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDigitalGoods_GetDetails_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::DigitalGoods_GetDetails_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);
  typename decltype(params->item_details_list)::BaseType::BufferWriter
      item_details_list_writer;
  const mojo::internal::ContainerValidateParams item_details_list_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::ItemDetailsDataView>>(
      in_item_details_list, buffer, &item_details_list_writer, &item_details_list_validate_params,
      &serialization_context);
  params->item_details_list.Set(
      item_details_list_writer.is_null() ? nullptr : item_details_list_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->item_details_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_details_list in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::DigitalGoods::GetDetailsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("GetDetails");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DigitalGoods_Acknowledge_ProxyToResponder {
 public:
  static DigitalGoods::AcknowledgeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DigitalGoods_Acknowledge_ProxyToResponder> proxy(
        new DigitalGoods_Acknowledge_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DigitalGoods_Acknowledge_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_Acknowledge_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DigitalGoods_Acknowledge_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::AcknowledgeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BillingResponseCode in_code);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_Acknowledge_ProxyToResponder);
};

bool DigitalGoods_Acknowledge_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::DigitalGoods::AcknowledgeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::DigitalGoods_Acknowledge_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_Acknowledge_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  BillingResponseCode p_code{};
  DigitalGoods_Acknowledge_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code));
  return true;
}

void DigitalGoods_Acknowledge_ProxyToResponder::Run(
    BillingResponseCode in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::DigitalGoods::AcknowledgeCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("code", base::trace_event::ValueToString(in_code));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDigitalGoods_Acknowledge_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::DigitalGoods_Acknowledge_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::DigitalGoods::AcknowledgeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("Acknowledge");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DigitalGoodsStubDispatch::Accept(
    DigitalGoods* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kDigitalGoods_GetDetails_Name: {
      break;
    }
    case internal::kDigitalGoods_Acknowledge_Name: {
      break;
    }
  }
  return false;
}

// static
bool DigitalGoodsStubDispatch::AcceptWithResponder(
    DigitalGoods* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDigitalGoods_GetDetails_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::DigitalGoods::GetDetails",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::DigitalGoods::GetDetails");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DigitalGoods_GetDetails_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_GetDetails_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<WTF::String> p_item_ids{};
      DigitalGoods_GetDetails_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadItemIds(&p_item_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 0, false);
        return false;
      }
      DigitalGoods::GetDetailsCallback callback =
          DigitalGoods_GetDetails_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDetails(
std::move(p_item_ids), std::move(callback));
      return true;
    }
    case internal::kDigitalGoods_Acknowledge_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::DigitalGoods::Acknowledge",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::DigitalGoods::Acknowledge");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DigitalGoods_Acknowledge_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_Acknowledge_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_purchase_token{};
      bool p_make_available_again{};
      DigitalGoods_Acknowledge_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPurchaseToken(&p_purchase_token))
        success = false;
      if (success)
        p_make_available_again = input_data_view.make_available_again();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 1, false);
        return false;
      }
      DigitalGoods::AcknowledgeCallback callback =
          DigitalGoods_Acknowledge_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Acknowledge(
std::move(p_purchase_token), 
std::move(p_make_available_again), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDigitalGoodsValidationInfo[] = {
    {&internal::DigitalGoods_GetDetails_Params_Data::Validate,
     &internal::DigitalGoods_GetDetails_ResponseParams_Data::Validate},
    {&internal::DigitalGoods_Acknowledge_Params_Data::Validate,
     &internal::DigitalGoods_Acknowledge_ResponseParams_Data::Validate},
};

bool DigitalGoodsRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoods::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDigitalGoodsValidationInfo);
}

bool DigitalGoodsResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoods::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDigitalGoodsValidationInfo);
}
const char DigitalGoodsFactory::Name_[] = "payments.mojom.DigitalGoodsFactory";

class DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback(
      DigitalGoodsFactory::CreateDigitalGoodsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoodsFactory::CreateDigitalGoodsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback);
};

DigitalGoodsFactoryProxy::DigitalGoodsFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DigitalGoodsFactoryProxy::CreateDigitalGoods(
    const WTF::String& in_payment_method, CreateDigitalGoodsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::DigitalGoodsFactory::CreateDigitalGoods", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("payment_method", in_payment_method.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDigitalGoodsFactory_CreateDigitalGoods_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->payment_method)::BaseType::BufferWriter
      payment_method_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_payment_method, buffer, &payment_method_writer, &serialization_context);
  params->payment_method.Set(
      payment_method_writer.is_null() ? nullptr : payment_method_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->payment_method.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payment_method in DigitalGoodsFactory.CreateDigitalGoods request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoodsFactory::Name_);
  message.set_method_name("CreateDigitalGoods");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder {
 public:
  static DigitalGoodsFactory::CreateDigitalGoodsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder> proxy(
        new DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoodsFactory::CreateDigitalGoodsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateDigitalGoodsResponseCode in_code, ::mojo::PendingRemote<DigitalGoods> in_digital_goods);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder);
};

bool DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::DigitalGoodsFactory::CreateDigitalGoodsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CreateDigitalGoodsResponseCode p_code{};
  ::mojo::PendingRemote<DigitalGoods> p_digital_goods{};
  DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success) {
    p_digital_goods =
        input_data_view.TakeDigitalGoods<decltype(p_digital_goods)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoodsFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_digital_goods));
  return true;
}

void DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::Run(
    CreateDigitalGoodsResponseCode in_code, ::mojo::PendingRemote<DigitalGoods> in_digital_goods) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoodsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("code", base::trace_event::ValueToString(in_code));
      raw_value->SetBoolean("digital_goods", in_digital_goods.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDigitalGoodsFactory_CreateDigitalGoods_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::CreateDigitalGoodsResponseCode>(
      in_code, &params->code);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::DigitalGoodsInterfaceBase>>(
      in_digital_goods, &params->digital_goods, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoodsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoodsFactory::Name_);
  message.set_method_name("CreateDigitalGoods");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DigitalGoodsFactoryStubDispatch::Accept(
    DigitalGoodsFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kDigitalGoodsFactory_CreateDigitalGoods_Name: {
      break;
    }
  }
  return false;
}

// static
bool DigitalGoodsFactoryStubDispatch::AcceptWithResponder(
    DigitalGoodsFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDigitalGoodsFactory_CreateDigitalGoods_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoods",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoods");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_payment_method{};
      DigitalGoodsFactory_CreateDigitalGoods_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPaymentMethod(&p_payment_method))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoodsFactory::Name_, 0, false);
        return false;
      }
      DigitalGoodsFactory::CreateDigitalGoodsCallback callback =
          DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDigitalGoods(
std::move(p_payment_method), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDigitalGoodsFactoryValidationInfo[] = {
    {&internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data::Validate,
     &internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::Validate},
};

bool DigitalGoodsFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoodsFactory::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDigitalGoodsFactoryValidationInfo);
}

bool DigitalGoodsFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoodsFactory::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDigitalGoodsFactoryValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::blink::ItemDetails::DataView, ::payments::mojom::blink::ItemDetailsPtr>::Read(
    ::payments::mojom::blink::ItemDetails::DataView input,
    ::payments::mojom::blink::ItemDetailsPtr* output) {
  bool success = true;
  ::payments::mojom::blink::ItemDetailsPtr result(::payments::mojom::blink::ItemDetails::New());
  
      if (success && !input.ReadItemId(&result->item_id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadPrice(&result->price))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif