// third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, MenuItem_Type value) {
  switch(value) {
    case MenuItem_Type::kOption:
      return os << "MenuItem_Type::kOption";
    case MenuItem_Type::kCheckableOption:
      return os << "MenuItem_Type::kCheckableOption";
    case MenuItem_Type::kGroup:
      return os << "MenuItem_Type::kGroup";
    case MenuItem_Type::kSeparator:
      return os << "MenuItem_Type::kSeparator";
    case MenuItem_Type::kSubMenu:
      return os << "MenuItem_Type::kSubMenu";
    default:
      return os << "Unknown MenuItem_Type value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool MenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MenuItem_Data* object = static_cast<const MenuItem_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  const mojo::internal::ContainerValidateParams label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams tool_tip_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->tool_tip, validation_context,
                                         &tool_tip_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::MenuItem_Type_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  return true;
}

MenuItem_Data::MenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PopupMenuClient_DidAcceptIndices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PopupMenuClient_DidAcceptIndices_Params_Data* object = static_cast<const PopupMenuClient_DidAcceptIndices_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams indices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->indices, validation_context,
                                         &indices_validate_params)) {
    return false;
  }

  return true;
}

PopupMenuClient_DidAcceptIndices_Params_Data::PopupMenuClient_DidAcceptIndices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PopupMenuClient_DidCancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PopupMenuClient_DidCancel_Params_Data* object = static_cast<const PopupMenuClient_DidCancel_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

PopupMenuClient_DidCancel_Params_Data::PopupMenuClient_DidCancel_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink