// third_party/blink/public/mojom/badging/badging.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/badging/badging.mojom-shared.h"
#include "third_party/blink/public/mojom/badging/badging.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class BadgeServiceProxy;

template <typename ImplRefTraits>
class BadgeServiceStub;

class BadgeServiceRequestValidator;


class PLATFORM_EXPORT BadgeService
    : public BadgeServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BadgeServiceInterfaceBase;
  using Proxy_ = BadgeServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BadgeServiceStub<ImplRefTraits>;

  using RequestValidator_ = BadgeServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetBadgeMinVersion = 0,
    kClearBadgeMinVersion = 0,
  };
  virtual ~BadgeService() {}

  
  virtual void SetBadge(BadgeValuePtr value) = 0;

  
  virtual void ClearBadge() = 0;
};



class PLATFORM_EXPORT BadgeServiceProxy
    : public BadgeService {
 public:
  using InterfaceType = BadgeService;

  explicit BadgeServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetBadge(BadgeValuePtr value) final;
  
  void ClearBadge() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT BadgeServiceStubDispatch {
 public:
  static bool Accept(BadgeService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BadgeService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BadgeService>>
class BadgeServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BadgeServiceStub() {}
  ~BadgeServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BadgeServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BadgeServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BadgeServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT BadgeValue {
 public:
  using DataView = BadgeValueDataView;
  using Data_ = internal::BadgeValue_Data;
  using Tag = Data_::BadgeValue_Tag;

  static BadgeValuePtr New() {
    return BadgeValuePtr(base::in_place);
  }
  // Construct an instance holding |flag|.
  static BadgeValuePtr
  NewFlag(
      uint8_t flag) {
    auto result = BadgeValuePtr(base::in_place);
    result->set_flag(std::move(flag));
    return result;
  }
  // Construct an instance holding |number|.
  static BadgeValuePtr
  NewNumber(
      uint64_t number) {
    auto result = BadgeValuePtr(base::in_place);
    result->set_number(std::move(number));
    return result;
  }

  template <typename U>
  static BadgeValuePtr From(const U& u) {
    return mojo::TypeConverter<BadgeValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BadgeValue>::Convert(*this);
  }

  BadgeValue();
  ~BadgeValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = BadgeValuePtr>
  BadgeValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, BadgeValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_flag() const { return tag_ == Tag::FLAG; }

  
  uint8_t get_flag() const {
    DCHECK(tag_ == Tag::FLAG);
    return data_.flag;
  }

  
  void set_flag(
      uint8_t flag);
  
  bool is_number() const { return tag_ == Tag::NUMBER; }

  
  uint64_t get_number() const {
    DCHECK(tag_ == Tag::NUMBER);
    return data_.number;
  }

  
  void set_number(
      uint64_t number);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BadgeValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<BadgeValue::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    uint8_t flag;
    uint64_t number;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
BadgeValuePtr BadgeValue::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::FLAG:
      rv->set_flag(mojo::Clone(data_.flag));
      break;
    case Tag::NUMBER:
      rv->set_number(mojo::Clone(data_.number));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, BadgeValue>::value>::type*>
bool BadgeValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::FLAG:
      return mojo::Equals(data_.flag, other.data_.flag);
    case Tag::NUMBER:
      return mojo::Equals(data_.number, other.data_.number);
  }

  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::BadgeValue::DataView,
                                        ::blink::mojom::blink::BadgeValuePtr> {
  static bool IsNull(const ::blink::mojom::blink::BadgeValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BadgeValuePtr* output) { output->reset(); }

  static ::blink::mojom::blink::BadgeValue::Tag GetTag(const ::blink::mojom::blink::BadgeValuePtr& input) {
    return input->which();
  }

  static  uint8_t flag(const ::blink::mojom::blink::BadgeValuePtr& input) {
    return input->get_flag();
  }

  static  uint64_t number(const ::blink::mojom::blink::BadgeValuePtr& input) {
    return input->get_number();
  }

  static bool Read(::blink::mojom::blink::BadgeValue::DataView input, ::blink::mojom::blink::BadgeValuePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_BLINK_H_