// services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/mojom/presentation_feedback.mojom-shared.h"
#include "ui/gfx/mojom/swap_timings.mojom-shared.h"







namespace viz {
namespace mojom {
class FrameTimingDetailsDataView;



}  // namespace mojom
}  // namespace viz

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FrameTimingDetailsDataView> {
  using Data = ::viz::mojom::internal::FrameTimingDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz {
namespace mojom {


class FrameTimingDetailsDataView {
 public:
  FrameTimingDetailsDataView() {}

  FrameTimingDetailsDataView(
      internal::FrameTimingDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetReceivedCompositorFrameTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReceivedCompositorFrameTimestamp(UserType* output) {
    
    auto* pointer = data_->received_compositor_frame_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetDrawStartTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDrawStartTimestamp(UserType* output) {
    
    auto* pointer = data_->draw_start_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetSwapTimingsDataView(
      ::gfx::mojom::SwapTimingsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSwapTimings(UserType* output) {
    
    auto* pointer = data_->swap_timings.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SwapTimingsDataView>(
        pointer, output, context_);
  }
  inline void GetPresentationFeedbackDataView(
      ::gfx::mojom::PresentationFeedbackDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPresentationFeedback(UserType* output) {
    
    auto* pointer = data_->presentation_feedback.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PresentationFeedbackDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameTimingDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace viz

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FrameTimingDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameTimingDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::FrameTimingDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::received_compositor_frame_timestamp(input)) in_received_compositor_frame_timestamp = Traits::received_compositor_frame_timestamp(input);
    typename decltype((*output)->received_compositor_frame_timestamp)::BaseType::BufferWriter
        received_compositor_frame_timestamp_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_received_compositor_frame_timestamp, buffer, &received_compositor_frame_timestamp_writer, context);
    (*output)->received_compositor_frame_timestamp.Set(
        received_compositor_frame_timestamp_writer.is_null() ? nullptr : received_compositor_frame_timestamp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->received_compositor_frame_timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null received_compositor_frame_timestamp in FrameTimingDetails struct");
    decltype(Traits::draw_start_timestamp(input)) in_draw_start_timestamp = Traits::draw_start_timestamp(input);
    typename decltype((*output)->draw_start_timestamp)::BaseType::BufferWriter
        draw_start_timestamp_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_draw_start_timestamp, buffer, &draw_start_timestamp_writer, context);
    (*output)->draw_start_timestamp.Set(
        draw_start_timestamp_writer.is_null() ? nullptr : draw_start_timestamp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->draw_start_timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null draw_start_timestamp in FrameTimingDetails struct");
    decltype(Traits::swap_timings(input)) in_swap_timings = Traits::swap_timings(input);
    typename decltype((*output)->swap_timings)::BaseType::BufferWriter
        swap_timings_writer;
    mojo::internal::Serialize<::gfx::mojom::SwapTimingsDataView>(
        in_swap_timings, buffer, &swap_timings_writer, context);
    (*output)->swap_timings.Set(
        swap_timings_writer.is_null() ? nullptr : swap_timings_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->swap_timings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null swap_timings in FrameTimingDetails struct");
    decltype(Traits::presentation_feedback(input)) in_presentation_feedback = Traits::presentation_feedback(input);
    typename decltype((*output)->presentation_feedback)::BaseType::BufferWriter
        presentation_feedback_writer;
    mojo::internal::Serialize<::gfx::mojom::PresentationFeedbackDataView>(
        in_presentation_feedback, buffer, &presentation_feedback_writer, context);
    (*output)->presentation_feedback.Set(
        presentation_feedback_writer.is_null() ? nullptr : presentation_feedback_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->presentation_feedback.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null presentation_feedback in FrameTimingDetails struct");
  }

  static bool Deserialize(::viz::mojom::internal::FrameTimingDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FrameTimingDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz {
namespace mojom {

inline void FrameTimingDetailsDataView::GetReceivedCompositorFrameTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->received_compositor_frame_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void FrameTimingDetailsDataView::GetDrawStartTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->draw_start_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void FrameTimingDetailsDataView::GetSwapTimingsDataView(
    ::gfx::mojom::SwapTimingsDataView* output) {
  auto pointer = data_->swap_timings.Get();
  *output = ::gfx::mojom::SwapTimingsDataView(pointer, context_);
}
inline void FrameTimingDetailsDataView::GetPresentationFeedbackDataView(
    ::gfx::mojom::PresentationFeedbackDataView* output) {
  auto pointer = data_->presentation_feedback.Get();
  *output = ::gfx::mojom::PresentationFeedbackDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace viz

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_SHARED_H_