// services/viz/public/mojom/compositing/delegated_ink_point.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_POINT_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_POINT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/public/mojom/compositing/delegated_ink_point.mojom-shared.h"
#include "services/viz/public/mojom/compositing/delegated_ink_point.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/viz/public/cpp/compositing/delegated_ink_point_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class DelegatedInkPointRendererProxy;

template <typename ImplRefTraits>
class DelegatedInkPointRendererStub;

class DelegatedInkPointRendererRequestValidator;


class  DelegatedInkPointRenderer
    : public DelegatedInkPointRendererInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DelegatedInkPointRendererInterfaceBase;
  using Proxy_ = DelegatedInkPointRendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = DelegatedInkPointRendererStub<ImplRefTraits>;

  using RequestValidator_ = DelegatedInkPointRendererRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStoreDelegatedInkPointMinVersion = 0,
  };
  virtual ~DelegatedInkPointRenderer() {}

  
  virtual void StoreDelegatedInkPoint(const ::viz::DelegatedInkPoint& point) = 0;
};



class  DelegatedInkPointRendererProxy
    : public DelegatedInkPointRenderer {
 public:
  using InterfaceType = DelegatedInkPointRenderer;

  explicit DelegatedInkPointRendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StoreDelegatedInkPoint(const ::viz::DelegatedInkPoint& point) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DelegatedInkPointRendererStubDispatch {
 public:
  static bool Accept(DelegatedInkPointRenderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DelegatedInkPointRenderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DelegatedInkPointRenderer>>
class DelegatedInkPointRendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DelegatedInkPointRendererStub() {}
  ~DelegatedInkPointRendererStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DelegatedInkPointRendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DelegatedInkPointRendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DelegatedInkPointRendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  DelegatedInkPoint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DelegatedInkPoint, T>::value>;
  using DataView = DelegatedInkPointDataView;
  using Data_ = internal::DelegatedInkPoint_Data;

  template <typename... Args>
  static DelegatedInkPointPtr New(Args&&... args) {
    return DelegatedInkPointPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DelegatedInkPointPtr From(const U& u) {
    return mojo::TypeConverter<DelegatedInkPointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DelegatedInkPoint>::Convert(*this);
  }


  DelegatedInkPoint();

  DelegatedInkPoint(
      const ::gfx::PointF& point,
      ::base::TimeTicks timestamp);

  ~DelegatedInkPoint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DelegatedInkPointPtr>
  DelegatedInkPointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DelegatedInkPoint::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DelegatedInkPoint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DelegatedInkPoint_UnserializedMessageContext<
            UserType, DelegatedInkPoint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DelegatedInkPoint::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DelegatedInkPoint::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DelegatedInkPoint_UnserializedMessageContext<
            UserType, DelegatedInkPoint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DelegatedInkPoint::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::PointF point;
  
  ::base::TimeTicks timestamp;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DelegatedInkPointPtr DelegatedInkPoint::Clone() const {
  return New(
      mojo::Clone(point),
      mojo::Clone(timestamp)
  );
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>*>
bool DelegatedInkPoint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->point, other_struct.point))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  return true;
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.point, rhs.point))
    return true;
  if (std::less<>{}(rhs.point, lhs.point))
    return false;
  if (std::less<>{}(lhs.timestamp, rhs.timestamp))
    return true;
  if (std::less<>{}(rhs.timestamp, lhs.timestamp))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace viz

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::DelegatedInkPoint::DataView,
                                         ::viz::mojom::DelegatedInkPointPtr> {
  static bool IsNull(const ::viz::mojom::DelegatedInkPointPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::DelegatedInkPointPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::DelegatedInkPoint::point)& point(
      const ::viz::mojom::DelegatedInkPointPtr& input) {
    return input->point;
  }

  static const decltype(::viz::mojom::DelegatedInkPoint::timestamp)& timestamp(
      const ::viz::mojom::DelegatedInkPointPtr& input) {
    return input->timestamp;
  }

  static bool Read(::viz::mojom::DelegatedInkPoint::DataView input, ::viz::mojom::DelegatedInkPointPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_DELEGATED_INK_POINT_MOJOM_H_