// services/viz/privileged/mojom/viz_main.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace viz {
namespace mojom {
namespace internal {
class  VizMain_CreateFrameSinkManager_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VizMain_CreateFrameSinkManager_Params_Data));
      new (data()) VizMain_CreateFrameSinkManager_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VizMain_CreateFrameSinkManager_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VizMain_CreateFrameSinkManager_Params_Data>(index_);
    }
    VizMain_CreateFrameSinkManager_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::FrameSinkManagerParams_Data> params;

 private:
  VizMain_CreateFrameSinkManager_Params_Data();
  ~VizMain_CreateFrameSinkManager_Params_Data() = delete;
};
static_assert(sizeof(VizMain_CreateFrameSinkManager_Params_Data) == 16,
              "Bad sizeof(VizMain_CreateFrameSinkManager_Params_Data)");
class  VizMain_CreateGpuService_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VizMain_CreateGpuService_Params_Data));
      new (data()) VizMain_CreateGpuService_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VizMain_CreateGpuService_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VizMain_CreateGpuService_Params_Data>(index_);
    }
    VizMain_CreateGpuService_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data gpu_service;
  mojo::internal::Interface_Data gpu_host;
  mojo::internal::Interface_Data discardable_memory_manager;
  mojo::internal::Handle_Data activity_flags;
  int32_t subpixel_rendering;
  uint8_t padfinal_[4];

 private:
  VizMain_CreateGpuService_Params_Data();
  ~VizMain_CreateGpuService_Params_Data() = delete;
};
static_assert(sizeof(VizMain_CreateGpuService_Params_Data) == 40,
              "Bad sizeof(VizMain_CreateGpuService_Params_Data)");
class  VizMain_CreateVizDevTools_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VizMain_CreateVizDevTools_Params_Data));
      new (data()) VizMain_CreateVizDevTools_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VizMain_CreateVizDevTools_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VizMain_CreateVizDevTools_Params_Data>(index_);
    }
    VizMain_CreateVizDevTools_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::VizDevToolsParams_Data> params;

 private:
  VizMain_CreateVizDevTools_Params_Data();
  ~VizMain_CreateVizDevTools_Params_Data() = delete;
};
static_assert(sizeof(VizMain_CreateVizDevTools_Params_Data) == 16,
              "Bad sizeof(VizMain_CreateVizDevTools_Params_Data)");

}  // namespace internal


class VizMain_CreateFrameSinkManager_ParamsDataView {
 public:
  VizMain_CreateFrameSinkManager_ParamsDataView() {}

  VizMain_CreateFrameSinkManager_ParamsDataView(
      internal::VizMain_CreateFrameSinkManager_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      FrameSinkManagerParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkManagerParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::VizMain_CreateFrameSinkManager_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VizMain_CreateGpuService_ParamsDataView {
 public:
  VizMain_CreateGpuService_ParamsDataView() {}

  VizMain_CreateGpuService_ParamsDataView(
      internal::VizMain_CreateGpuService_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeGpuService() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::viz::mojom::GpuServiceInterfaceBase>>(
            &data_->gpu_service, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeGpuHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::GpuHostInterfaceBase>>(
            &data_->gpu_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDiscardableMemoryManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::discardable_memory::mojom::DiscardableSharedMemoryManagerInterfaceBase>>(
            &data_->discardable_memory_manager, &result, context_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedSharedBufferHandle TakeActivityFlags() {
    mojo::ScopedSharedBufferHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedSharedBufferHandle>(
            &data_->activity_flags, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubpixelRendering(UserType* output) const {
    auto data_value = data_->subpixel_rendering;
    return mojo::internal::Deserialize<::gfx::mojom::SubpixelRendering>(
        data_value, output);
  }

  ::gfx::mojom::SubpixelRendering subpixel_rendering() const {
    return static_cast<::gfx::mojom::SubpixelRendering>(data_->subpixel_rendering);
  }
 private:
  internal::VizMain_CreateGpuService_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VizMain_CreateVizDevTools_ParamsDataView {
 public:
  VizMain_CreateVizDevTools_ParamsDataView() {}

  VizMain_CreateVizDevTools_ParamsDataView(
      internal::VizMain_CreateVizDevTools_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      VizDevToolsParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::viz::mojom::VizDevToolsParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::VizMain_CreateVizDevTools_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void VizMain_CreateFrameSinkManager_ParamsDataView::GetParamsDataView(
    FrameSinkManagerParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = FrameSinkManagerParamsDataView(pointer, context_);
}




inline void VizMain_CreateVizDevTools_ParamsDataView::GetParamsDataView(
    VizDevToolsParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = VizDevToolsParamsDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_PARAMS_DATA_H_