// services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared-internal.h"
#include "services/viz/privileged/mojom/compositing/overlay_strategy.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"







namespace viz {
namespace mojom {
class RendererSettingsDataView;

class DebugRendererSettingsDataView;



}  // namespace mojom
}  // namespace viz

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::RendererSettingsDataView> {
  using Data = ::viz::mojom::internal::RendererSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::DebugRendererSettingsDataView> {
  using Data = ::viz::mojom::internal::DebugRendererSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz {
namespace mojom {


class RendererSettingsDataView {
 public:
  RendererSettingsDataView() {}

  RendererSettingsDataView(
      internal::RendererSettings_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool allow_antialiasing() const {
    return data_->allow_antialiasing;
  }
  bool force_antialiasing() const {
    return data_->force_antialiasing;
  }
  bool force_blending_with_shaders() const {
    return data_->force_blending_with_shaders;
  }
  int32_t highp_threshold_min() const {
    return data_->highp_threshold_min;
  }
  bool partial_swap_enabled() const {
    return data_->partial_swap_enabled;
  }
  bool release_overlay_resources_after_gpu_query() const {
    return data_->release_overlay_resources_after_gpu_query;
  }
  bool should_clear_root_render_pass() const {
    return data_->should_clear_root_render_pass;
  }
  int32_t slow_down_compositing_scale_factor() const {
    return data_->slow_down_compositing_scale_factor;
  }
  bool use_skia_renderer() const {
    return data_->use_skia_renderer;
  }
  bool allow_overlays() const {
    return data_->allow_overlays;
  }
  bool auto_resize_output_surface() const {
    return data_->auto_resize_output_surface;
  }
  bool requires_alpha_channel() const {
    return data_->requires_alpha_channel;
  }
  inline void GetOverlayStrategiesDataView(
      mojo::ArrayDataView<::viz::mojom::OverlayStrategy>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOverlayStrategies(UserType* output) {
    
    auto* pointer = data_->overlay_strategies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::OverlayStrategy>>(
        pointer, output, context_);
  }
 private:
  internal::RendererSettings_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DebugRendererSettingsDataView {
 public:
  DebugRendererSettingsDataView() {}

  DebugRendererSettingsDataView(
      internal::DebugRendererSettings_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool tint_composited_content() const {
    return data_->tint_composited_content;
  }
  bool show_overdraw_feedback() const {
    return data_->show_overdraw_feedback;
  }
  bool show_dc_layer_debug_borders() const {
    return data_->show_dc_layer_debug_borders;
  }
  bool show_aggregated_damage() const {
    return data_->show_aggregated_damage;
  }
 private:
  internal::DebugRendererSettings_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace viz

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::RendererSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::RendererSettingsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::RendererSettings_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->allow_antialiasing = Traits::allow_antialiasing(input);
    (*output)->force_antialiasing = Traits::force_antialiasing(input);
    (*output)->force_blending_with_shaders = Traits::force_blending_with_shaders(input);
    (*output)->highp_threshold_min = Traits::highp_threshold_min(input);
    (*output)->partial_swap_enabled = Traits::partial_swap_enabled(input);
    (*output)->release_overlay_resources_after_gpu_query = Traits::release_overlay_resources_after_gpu_query(input);
    (*output)->should_clear_root_render_pass = Traits::should_clear_root_render_pass(input);
    (*output)->slow_down_compositing_scale_factor = Traits::slow_down_compositing_scale_factor(input);
    (*output)->use_skia_renderer = Traits::use_skia_renderer(input);
    (*output)->allow_overlays = Traits::allow_overlays(input);
    (*output)->auto_resize_output_surface = Traits::auto_resize_output_surface(input);
    (*output)->requires_alpha_channel = Traits::requires_alpha_channel(input);
    decltype(Traits::overlay_strategies(input)) in_overlay_strategies = Traits::overlay_strategies(input);
    typename decltype((*output)->overlay_strategies)::BaseType::BufferWriter
        overlay_strategies_writer;
    const mojo::internal::ContainerValidateParams overlay_strategies_validate_params(
        0, ::viz::mojom::internal::OverlayStrategy_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::OverlayStrategy>>(
        in_overlay_strategies, buffer, &overlay_strategies_writer, &overlay_strategies_validate_params,
        context);
    (*output)->overlay_strategies.Set(
        overlay_strategies_writer.is_null() ? nullptr : overlay_strategies_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->overlay_strategies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null overlay_strategies in RendererSettings struct");
  }

  static bool Deserialize(::viz::mojom::internal::RendererSettings_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::RendererSettingsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::DebugRendererSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::DebugRendererSettingsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::DebugRendererSettings_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->tint_composited_content = Traits::tint_composited_content(input);
    (*output)->show_overdraw_feedback = Traits::show_overdraw_feedback(input);
    (*output)->show_dc_layer_debug_borders = Traits::show_dc_layer_debug_borders(input);
    (*output)->show_aggregated_damage = Traits::show_aggregated_damage(input);
  }

  static bool Deserialize(::viz::mojom::internal::DebugRendererSettings_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::DebugRendererSettingsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz {
namespace mojom {

inline void RendererSettingsDataView::GetOverlayStrategiesDataView(
    mojo::ArrayDataView<::viz::mojom::OverlayStrategy>* output) {
  auto pointer = data_->overlay_strategies.Get();
  *output = mojo::ArrayDataView<::viz::mojom::OverlayStrategy>(pointer, context_);
}





}  // namespace mojom
}  // namespace viz

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_SHARED_H_