// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace viz {
namespace mojom {
namespace internal {
class  FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data));
      new (data()) FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data>(index_);
    }
    FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data();
  ~FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data) == 8,
              "Bad sizeof(FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data)");
class  FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data));
      new (data()) FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data>(index_);
    }
    FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameFeedback_Data> feedback;

 private:
  FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data();
  ~FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data)");
class  FrameSinkVideoConsumer_OnFrameCaptured_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoConsumer_OnFrameCaptured_Params_Data));
      new (data()) FrameSinkVideoConsumer_OnFrameCaptured_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoConsumer_OnFrameCaptured_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoConsumer_OnFrameCaptured_Params_Data>(index_);
    }
    FrameSinkVideoConsumer_OnFrameCaptured_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> data;
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> info;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> content_rect;
  mojo::internal::Interface_Data callbacks;

 private:
  FrameSinkVideoConsumer_OnFrameCaptured_Params_Data();
  ~FrameSinkVideoConsumer_OnFrameCaptured_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoConsumer_OnFrameCaptured_Params_Data) == 40,
              "Bad sizeof(FrameSinkVideoConsumer_OnFrameCaptured_Params_Data)");
class  FrameSinkVideoConsumer_OnStopped_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoConsumer_OnStopped_Params_Data));
      new (data()) FrameSinkVideoConsumer_OnStopped_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoConsumer_OnStopped_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoConsumer_OnStopped_Params_Data>(index_);
    }
    FrameSinkVideoConsumer_OnStopped_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  FrameSinkVideoConsumer_OnStopped_Params_Data();
  ~FrameSinkVideoConsumer_OnStopped_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoConsumer_OnStopped_Params_Data) == 8,
              "Bad sizeof(FrameSinkVideoConsumer_OnStopped_Params_Data)");
class  FrameSinkVideoConsumer_OnLog_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoConsumer_OnLog_Params_Data));
      new (data()) FrameSinkVideoConsumer_OnLog_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoConsumer_OnLog_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoConsumer_OnLog_Params_Data>(index_);
    }
    FrameSinkVideoConsumer_OnLog_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  FrameSinkVideoConsumer_OnLog_Params_Data();
  ~FrameSinkVideoConsumer_OnLog_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoConsumer_OnLog_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoConsumer_OnLog_Params_Data)");
class  FrameSinkVideoCapturer_SetFormat_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_SetFormat_Params_Data));
      new (data()) FrameSinkVideoCapturer_SetFormat_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_SetFormat_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_SetFormat_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_SetFormat_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t format;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::ColorSpace_Data> color_space;

 private:
  FrameSinkVideoCapturer_SetFormat_Params_Data();
  ~FrameSinkVideoCapturer_SetFormat_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_SetFormat_Params_Data) == 24,
              "Bad sizeof(FrameSinkVideoCapturer_SetFormat_Params_Data)");
class  FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data));
      new (data()) FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> min_period;

 private:
  FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data();
  ~FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data)");
class  FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data));
      new (data()) FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> min_period;

 private:
  FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data();
  ~FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data)");
class  FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data));
      new (data()) FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> min_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> max_size;
  uint8_t use_fixed_aspect_ratio : 1;
  uint8_t padfinal_[7];

 private:
  FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data();
  ~FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data) == 32,
              "Bad sizeof(FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data)");
class  FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data));
      new (data()) FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t padfinal_[7];

 private:
  FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data();
  ~FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data)");
class  FrameSinkVideoCapturer_ChangeTarget_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_ChangeTarget_Params_Data));
      new (data()) FrameSinkVideoCapturer_ChangeTarget_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_ChangeTarget_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_ChangeTarget_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_ChangeTarget_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::viz::mojom::internal::FrameSinkId_Data> frame_sink_id;

 private:
  FrameSinkVideoCapturer_ChangeTarget_Params_Data();
  ~FrameSinkVideoCapturer_ChangeTarget_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_ChangeTarget_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoCapturer_ChangeTarget_Params_Data)");
class  FrameSinkVideoCapturer_Start_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_Start_Params_Data));
      new (data()) FrameSinkVideoCapturer_Start_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_Start_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_Start_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_Start_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data consumer;

 private:
  FrameSinkVideoCapturer_Start_Params_Data();
  ~FrameSinkVideoCapturer_Start_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_Start_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoCapturer_Start_Params_Data)");
class  FrameSinkVideoCapturer_Stop_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_Stop_Params_Data));
      new (data()) FrameSinkVideoCapturer_Stop_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_Stop_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_Stop_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_Stop_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  FrameSinkVideoCapturer_Stop_Params_Data();
  ~FrameSinkVideoCapturer_Stop_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_Stop_Params_Data) == 8,
              "Bad sizeof(FrameSinkVideoCapturer_Stop_Params_Data)");
class  FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data));
      new (data()) FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data();
  ~FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data) == 8,
              "Bad sizeof(FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data)");
class  FrameSinkVideoCapturer_CreateOverlay_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCapturer_CreateOverlay_Params_Data));
      new (data()) FrameSinkVideoCapturer_CreateOverlay_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCapturer_CreateOverlay_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCapturer_CreateOverlay_Params_Data>(index_);
    }
    FrameSinkVideoCapturer_CreateOverlay_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t stacking_index;
  mojo::internal::Handle_Data receiver;

 private:
  FrameSinkVideoCapturer_CreateOverlay_Params_Data();
  ~FrameSinkVideoCapturer_CreateOverlay_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCapturer_CreateOverlay_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoCapturer_CreateOverlay_Params_Data)");
class  FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data));
      new (data()) FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data>(index_);
    }
    FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::skia::mojom::internal::Bitmap_Data> image;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> bounds;

 private:
  FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data();
  ~FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data) == 24,
              "Bad sizeof(FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data)");
class  FrameSinkVideoCaptureOverlay_SetBounds_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkVideoCaptureOverlay_SetBounds_Params_Data));
      new (data()) FrameSinkVideoCaptureOverlay_SetBounds_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkVideoCaptureOverlay_SetBounds_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkVideoCaptureOverlay_SetBounds_Params_Data>(index_);
    }
    FrameSinkVideoCaptureOverlay_SetBounds_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> bounds;

 private:
  FrameSinkVideoCaptureOverlay_SetBounds_Params_Data();
  ~FrameSinkVideoCaptureOverlay_SetBounds_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkVideoCaptureOverlay_SetBounds_Params_Data) == 16,
              "Bad sizeof(FrameSinkVideoCaptureOverlay_SetBounds_Params_Data)");

}  // namespace internal


class FrameSinkVideoConsumerFrameCallbacks_Done_ParamsDataView {
 public:
  FrameSinkVideoConsumerFrameCallbacks_Done_ParamsDataView() {}

  FrameSinkVideoConsumerFrameCallbacks_Done_ParamsDataView(
      internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data* data_ = nullptr;
};



class FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_ParamsDataView {
 public:
  FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_ParamsDataView() {}

  FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_ParamsDataView(
      internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFeedbackDataView(
      ::media::mojom::VideoFrameFeedbackDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFeedback(UserType* output) {
    
    auto* pointer = data_->feedback.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameFeedbackDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView {
 public:
  FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView() {}

  FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView(
      internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, context_);
  }
  inline void GetInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, context_);
  }
  inline void GetContentRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentRect(UserType* output) {
    
    auto* pointer = data_->content_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeCallbacks() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkVideoConsumerFrameCallbacksInterfaceBase>>(
            &data_->callbacks, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoConsumer_OnStopped_ParamsDataView {
 public:
  FrameSinkVideoConsumer_OnStopped_ParamsDataView() {}

  FrameSinkVideoConsumer_OnStopped_ParamsDataView(
      internal::FrameSinkVideoConsumer_OnStopped_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FrameSinkVideoConsumer_OnStopped_Params_Data* data_ = nullptr;
};



class FrameSinkVideoConsumer_OnLog_ParamsDataView {
 public:
  FrameSinkVideoConsumer_OnLog_ParamsDataView() {}

  FrameSinkVideoConsumer_OnLog_ParamsDataView(
      internal::FrameSinkVideoConsumer_OnLog_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoConsumer_OnLog_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCapturer_SetFormat_ParamsDataView {
 public:
  FrameSinkVideoCapturer_SetFormat_ParamsDataView() {}

  FrameSinkVideoCapturer_SetFormat_ParamsDataView(
      internal::FrameSinkVideoCapturer_SetFormat_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::media::mojom::VideoPixelFormat>(
        data_value, output);
  }

  ::media::mojom::VideoPixelFormat format() const {
    return static_cast<::media::mojom::VideoPixelFormat>(data_->format);
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoCapturer_SetFormat_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCapturer_SetMinCapturePeriod_ParamsDataView {
 public:
  FrameSinkVideoCapturer_SetMinCapturePeriod_ParamsDataView() {}

  FrameSinkVideoCapturer_SetMinCapturePeriod_ParamsDataView(
      internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMinPeriodDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMinPeriod(UserType* output) {
    
    auto* pointer = data_->min_period.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCapturer_SetMinSizeChangePeriod_ParamsDataView {
 public:
  FrameSinkVideoCapturer_SetMinSizeChangePeriod_ParamsDataView() {}

  FrameSinkVideoCapturer_SetMinSizeChangePeriod_ParamsDataView(
      internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMinPeriodDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMinPeriod(UserType* output) {
    
    auto* pointer = data_->min_period.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCapturer_SetResolutionConstraints_ParamsDataView {
 public:
  FrameSinkVideoCapturer_SetResolutionConstraints_ParamsDataView() {}

  FrameSinkVideoCapturer_SetResolutionConstraints_ParamsDataView(
      internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMinSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMinSize(UserType* output) {
    
    auto* pointer = data_->min_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetMaxSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMaxSize(UserType* output) {
    
    auto* pointer = data_->max_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  bool use_fixed_aspect_ratio() const {
    return data_->use_fixed_aspect_ratio;
  }
 private:
  internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCapturer_SetAutoThrottlingEnabled_ParamsDataView {
 public:
  FrameSinkVideoCapturer_SetAutoThrottlingEnabled_ParamsDataView() {}

  FrameSinkVideoCapturer_SetAutoThrottlingEnabled_ParamsDataView(
      internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
 private:
  internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data* data_ = nullptr;
};



class FrameSinkVideoCapturer_ChangeTarget_ParamsDataView {
 public:
  FrameSinkVideoCapturer_ChangeTarget_ParamsDataView() {}

  FrameSinkVideoCapturer_ChangeTarget_ParamsDataView(
      internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameSinkId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::FrameSinkIdDataView, UserType>(),
    "Attempting to read the optional `frame_sink_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameSinkId` instead "
    "of `ReadFrameSinkId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCapturer_Start_ParamsDataView {
 public:
  FrameSinkVideoCapturer_Start_ParamsDataView() {}

  FrameSinkVideoCapturer_Start_ParamsDataView(
      internal::FrameSinkVideoCapturer_Start_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeConsumer() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkVideoConsumerInterfaceBase>>(
            &data_->consumer, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FrameSinkVideoCapturer_Start_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCapturer_Stop_ParamsDataView {
 public:
  FrameSinkVideoCapturer_Stop_ParamsDataView() {}

  FrameSinkVideoCapturer_Stop_ParamsDataView(
      internal::FrameSinkVideoCapturer_Stop_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FrameSinkVideoCapturer_Stop_Params_Data* data_ = nullptr;
};



class FrameSinkVideoCapturer_RequestRefreshFrame_ParamsDataView {
 public:
  FrameSinkVideoCapturer_RequestRefreshFrame_ParamsDataView() {}

  FrameSinkVideoCapturer_RequestRefreshFrame_ParamsDataView(
      internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data* data_ = nullptr;
};



class FrameSinkVideoCapturer_CreateOverlay_ParamsDataView {
 public:
  FrameSinkVideoCapturer_CreateOverlay_ParamsDataView() {}

  FrameSinkVideoCapturer_CreateOverlay_ParamsDataView(
      internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t stacking_index() const {
    return data_->stacking_index;
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkVideoCaptureOverlayInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCaptureOverlay_SetImageAndBounds_ParamsDataView {
 public:
  FrameSinkVideoCaptureOverlay_SetImageAndBounds_ParamsDataView() {}

  FrameSinkVideoCaptureOverlay_SetImageAndBounds_ParamsDataView(
      internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetImageDataView(
      ::skia::mojom::BitmapDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImage(UserType* output) {
    
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapDataView>(
        pointer, output, context_);
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkVideoCaptureOverlay_SetBounds_ParamsDataView {
 public:
  FrameSinkVideoCaptureOverlay_SetBounds_ParamsDataView() {}

  FrameSinkVideoCaptureOverlay_SetBounds_ParamsDataView(
      internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};




inline void FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_ParamsDataView::GetFeedbackDataView(
    ::media::mojom::VideoFrameFeedbackDataView* output) {
  auto pointer = data_->feedback.Get();
  *output = ::media::mojom::VideoFrameFeedbackDataView(pointer, context_);
}


inline void FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, context_);
}
inline void FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView::GetInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, context_);
}
inline void FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView::GetContentRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->content_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}




inline void FrameSinkVideoConsumer_OnLog_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void FrameSinkVideoCapturer_SetFormat_ParamsDataView::GetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, context_);
}


inline void FrameSinkVideoCapturer_SetMinCapturePeriod_ParamsDataView::GetMinPeriodDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->min_period.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}


inline void FrameSinkVideoCapturer_SetMinSizeChangePeriod_ParamsDataView::GetMinPeriodDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->min_period.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}


inline void FrameSinkVideoCapturer_SetResolutionConstraints_ParamsDataView::GetMinSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void FrameSinkVideoCapturer_SetResolutionConstraints_ParamsDataView::GetMaxSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}




inline void FrameSinkVideoCapturer_ChangeTarget_ParamsDataView::GetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, context_);
}










inline void FrameSinkVideoCaptureOverlay_SetImageAndBounds_ParamsDataView::GetImageDataView(
    ::skia::mojom::BitmapDataView* output) {
  auto pointer = data_->image.Get();
  *output = ::skia::mojom::BitmapDataView(pointer, context_);
}
inline void FrameSinkVideoCaptureOverlay_SetImageAndBounds_ParamsDataView::GetBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, context_);
}


inline void FrameSinkVideoCaptureOverlay_SetBounds_ParamsDataView::GetBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_PARAMS_DATA_H_