// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-forward.h"
#include "gpu/ipc/common/surface_handle.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-forward.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom.h"
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include "services/viz/public/mojom/compositing/video_detector_observer.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class FrameSinkManagerProxy;

template <typename ImplRefTraits>
class FrameSinkManagerStub;

class FrameSinkManagerRequestValidator;
class FrameSinkManagerResponseValidator;


class  FrameSinkManager
    : public FrameSinkManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = FrameSinkManagerInterfaceBase;
  using Proxy_ = FrameSinkManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkManagerStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkManagerRequestValidator;
  using ResponseValidator_ = FrameSinkManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterFrameSinkIdMinVersion = 0,
    kInvalidateFrameSinkIdMinVersion = 0,
    kSetFrameSinkDebugLabelMinVersion = 0,
    kCreateRootCompositorFrameSinkMinVersion = 0,
    kCreateCompositorFrameSinkMinVersion = 0,
    kDestroyCompositorFrameSinkMinVersion = 0,
    kRegisterFrameSinkHierarchyMinVersion = 0,
    kUnregisterFrameSinkHierarchyMinVersion = 0,
    kAddVideoDetectorObserverMinVersion = 0,
    kCreateVideoCapturerMinVersion = 0,
    kEvictSurfacesMinVersion = 0,
    kStartThrottlingMinVersion = 0,
    kEndThrottlingMinVersion = 0,
    kRequestCopyOfOutputMinVersion = 0,
    kSetHitTestAsyncQueriedDebugRegionsMinVersion = 0,
    kCacheBackBufferMinVersion = 0,
    kEvictBackBufferMinVersion = 0,
    kUpdateDebugRendererSettingsMinVersion = 0,
  };
  virtual ~FrameSinkManager() {}

  
  virtual void RegisterFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool report_activation) = 0;

  
  virtual void InvalidateFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) = 0;

  
  virtual void SetFrameSinkDebugLabel(const ::viz::FrameSinkId& frame_sink_id, const std::string& debug_label) = 0;

  
  virtual void CreateRootCompositorFrameSink(RootCompositorFrameSinkParamsPtr params) = 0;

  
  virtual void CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id);

  using DestroyCompositorFrameSinkCallback = base::OnceCallback<void()>;
  
  virtual void DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, DestroyCompositorFrameSinkCallback callback) = 0;

  
  virtual void RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) = 0;

  
  virtual void UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) = 0;

  
  virtual void AddVideoDetectorObserver(::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> observer) = 0;

  
  virtual void CreateVideoCapturer(::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> receiver) = 0;

  
  virtual void EvictSurfaces(const std::vector<::viz::SurfaceId>& surface_ids) = 0;

  
  virtual void StartThrottling(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) = 0;

  
  virtual void EndThrottling() = 0;

  
  virtual void RequestCopyOfOutput(const ::viz::SurfaceId& surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> request) = 0;

  
  virtual void SetHitTestAsyncQueriedDebugRegions(const ::viz::FrameSinkId& root_frame_sink_id, const std::vector<::viz::FrameSinkId>& hit_test_async_queried_debug_queue) = 0;

  
  virtual void CacheBackBuffer(uint32_t cache_id, const ::viz::FrameSinkId& root_frame_sink_id) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool EvictBackBuffer(uint32_t cache_id);

  using EvictBackBufferCallback = base::OnceCallback<void()>;
  
  virtual void EvictBackBuffer(uint32_t cache_id, EvictBackBufferCallback callback) = 0;

  
  virtual void UpdateDebugRendererSettings(const ::viz::DebugRendererSettings& debug_settings) = 0;
};

class FrameSinkManagerClientProxy;

template <typename ImplRefTraits>
class FrameSinkManagerClientStub;

class FrameSinkManagerClientRequestValidator;


class  FrameSinkManagerClient
    : public FrameSinkManagerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameSinkManagerClientInterfaceBase;
  using Proxy_ = FrameSinkManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFirstSurfaceActivationMinVersion = 0,
    kOnAggregatedHitTestRegionListUpdatedMinVersion = 0,
    kOnFrameTokenChangedMinVersion = 0,
  };
  virtual ~FrameSinkManagerClient() {}

  
  virtual void OnFirstSurfaceActivation(const ::viz::SurfaceInfo& surface_info) = 0;

  
  virtual void OnAggregatedHitTestRegionListUpdated(const ::viz::FrameSinkId& frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& hit_test_data) = 0;

  
  virtual void OnFrameTokenChanged(const ::viz::FrameSinkId& frame_sink_id, uint32_t frame_token) = 0;
};



class  FrameSinkManagerProxy
    : public FrameSinkManager {
 public:
  using InterfaceType = FrameSinkManager;

  explicit FrameSinkManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool report_activation) final;
  
  void InvalidateFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void SetFrameSinkDebugLabel(const ::viz::FrameSinkId& frame_sink_id, const std::string& debug_label) final;
  
  void CreateRootCompositorFrameSink(RootCompositorFrameSinkParamsPtr params) final;
  
  void CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client) final;
  
  bool DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, DestroyCompositorFrameSinkCallback callback) final;
  
  void RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) final;
  
  void UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) final;
  
  void AddVideoDetectorObserver(::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> observer) final;
  
  void CreateVideoCapturer(::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> receiver) final;
  
  void EvictSurfaces(const std::vector<::viz::SurfaceId>& surface_ids) final;
  
  void StartThrottling(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) final;
  
  void EndThrottling() final;
  
  void RequestCopyOfOutput(const ::viz::SurfaceId& surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> request) final;
  
  void SetHitTestAsyncQueriedDebugRegions(const ::viz::FrameSinkId& root_frame_sink_id, const std::vector<::viz::FrameSinkId>& hit_test_async_queried_debug_queue) final;
  
  void CacheBackBuffer(uint32_t cache_id, const ::viz::FrameSinkId& root_frame_sink_id) final;
  
  bool EvictBackBuffer(uint32_t cache_id) final;
  
  void EvictBackBuffer(uint32_t cache_id, EvictBackBufferCallback callback) final;
  
  void UpdateDebugRendererSettings(const ::viz::DebugRendererSettings& debug_settings) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkManagerClientProxy
    : public FrameSinkManagerClient {
 public:
  using InterfaceType = FrameSinkManagerClient;

  explicit FrameSinkManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFirstSurfaceActivation(const ::viz::SurfaceInfo& surface_info) final;
  
  void OnAggregatedHitTestRegionListUpdated(const ::viz::FrameSinkId& frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& hit_test_data) final;
  
  void OnFrameTokenChanged(const ::viz::FrameSinkId& frame_sink_id, uint32_t frame_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameSinkManagerStubDispatch {
 public:
  static bool Accept(FrameSinkManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkManager>>
class FrameSinkManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkManagerStub() {}
  ~FrameSinkManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkManagerClientStubDispatch {
 public:
  static bool Accept(FrameSinkManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkManagerClient>>
class FrameSinkManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkManagerClientStub() {}
  ~FrameSinkManagerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  RootCompositorFrameSinkParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RootCompositorFrameSinkParams, T>::value>;
  using DataView = RootCompositorFrameSinkParamsDataView;
  using Data_ = internal::RootCompositorFrameSinkParams_Data;

  template <typename... Args>
  static RootCompositorFrameSinkParamsPtr New(Args&&... args) {
    return RootCompositorFrameSinkParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RootCompositorFrameSinkParamsPtr From(const U& u) {
    return mojo::TypeConverter<RootCompositorFrameSinkParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RootCompositorFrameSinkParams>::Convert(*this);
  }


  RootCompositorFrameSinkParams();

  RootCompositorFrameSinkParams(
      const ::viz::FrameSinkId& frame_sink_id,
      ::gpu::SurfaceHandle widget,
      bool gpu_compositing,
      const ::viz::RendererSettings& renderer_settings,
      bool send_swap_size_notifications,
      bool disable_frame_rate_limit,
      bool use_preferred_interval_for_video,
      uint32_t num_of_frames_to_toggle_interval,
      ::mojo::PendingAssociatedReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink,
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client,
      ::mojo::PendingAssociatedReceiver<::viz::mojom::DisplayPrivate> display_private,
      ::mojo::PendingRemote<::viz::mojom::DisplayClient> display_client,
      ::mojo::PendingAssociatedReceiver<::viz::mojom::ExternalBeginFrameController> external_begin_frame_controller);

  ~RootCompositorFrameSinkParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RootCompositorFrameSinkParamsPtr>
  RootCompositorFrameSinkParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RootCompositorFrameSinkParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RootCompositorFrameSinkParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RootCompositorFrameSinkParams_UnserializedMessageContext<
            UserType, RootCompositorFrameSinkParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RootCompositorFrameSinkParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RootCompositorFrameSinkParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RootCompositorFrameSinkParams_UnserializedMessageContext<
            UserType, RootCompositorFrameSinkParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RootCompositorFrameSinkParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::viz::FrameSinkId frame_sink_id;
  
  ::gpu::SurfaceHandle widget;
  
  bool gpu_compositing;
  
  ::viz::RendererSettings renderer_settings;
  
  bool send_swap_size_notifications;
  
  bool disable_frame_rate_limit;
  
  bool use_preferred_interval_for_video;
  
  uint32_t num_of_frames_to_toggle_interval;
  
  ::mojo::PendingAssociatedReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink;
  
  ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client;
  
  ::mojo::PendingAssociatedReceiver<::viz::mojom::DisplayPrivate> display_private;
  
  ::mojo::PendingRemote<::viz::mojom::DisplayClient> display_client;
  
  ::mojo::PendingAssociatedReceiver<::viz::mojom::ExternalBeginFrameController> external_begin_frame_controller;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RootCompositorFrameSinkParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RootCompositorFrameSinkParamsPtr RootCompositorFrameSinkParams::Clone() const {
  return New(
      mojo::Clone(frame_sink_id),
      mojo::Clone(widget),
      mojo::Clone(gpu_compositing),
      mojo::Clone(renderer_settings),
      mojo::Clone(send_swap_size_notifications),
      mojo::Clone(disable_frame_rate_limit),
      mojo::Clone(use_preferred_interval_for_video),
      mojo::Clone(num_of_frames_to_toggle_interval),
      mojo::Clone(compositor_frame_sink),
      mojo::Clone(compositor_frame_sink_client),
      mojo::Clone(display_private),
      mojo::Clone(display_client),
      mojo::Clone(external_begin_frame_controller)
  );
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>*>
bool RootCompositorFrameSinkParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_sink_id, other_struct.frame_sink_id))
    return false;
  if (!mojo::Equals(this->widget, other_struct.widget))
    return false;
  if (!mojo::Equals(this->gpu_compositing, other_struct.gpu_compositing))
    return false;
  if (!mojo::Equals(this->renderer_settings, other_struct.renderer_settings))
    return false;
  if (!mojo::Equals(this->send_swap_size_notifications, other_struct.send_swap_size_notifications))
    return false;
  if (!mojo::Equals(this->disable_frame_rate_limit, other_struct.disable_frame_rate_limit))
    return false;
  if (!mojo::Equals(this->use_preferred_interval_for_video, other_struct.use_preferred_interval_for_video))
    return false;
  if (!mojo::Equals(this->num_of_frames_to_toggle_interval, other_struct.num_of_frames_to_toggle_interval))
    return false;
  if (!mojo::Equals(this->compositor_frame_sink, other_struct.compositor_frame_sink))
    return false;
  if (!mojo::Equals(this->compositor_frame_sink_client, other_struct.compositor_frame_sink_client))
    return false;
  if (!mojo::Equals(this->display_private, other_struct.display_private))
    return false;
  if (!mojo::Equals(this->display_client, other_struct.display_client))
    return false;
  if (!mojo::Equals(this->external_begin_frame_controller, other_struct.external_begin_frame_controller))
    return false;
  return true;
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.frame_sink_id, rhs.frame_sink_id))
    return true;
  if (std::less<>{}(rhs.frame_sink_id, lhs.frame_sink_id))
    return false;
  if (std::less<>{}(lhs.widget, rhs.widget))
    return true;
  if (std::less<>{}(rhs.widget, lhs.widget))
    return false;
  if (std::less<>{}(lhs.gpu_compositing, rhs.gpu_compositing))
    return true;
  if (std::less<>{}(rhs.gpu_compositing, lhs.gpu_compositing))
    return false;
  if (std::less<>{}(lhs.renderer_settings, rhs.renderer_settings))
    return true;
  if (std::less<>{}(rhs.renderer_settings, lhs.renderer_settings))
    return false;
  if (std::less<>{}(lhs.send_swap_size_notifications, rhs.send_swap_size_notifications))
    return true;
  if (std::less<>{}(rhs.send_swap_size_notifications, lhs.send_swap_size_notifications))
    return false;
  if (std::less<>{}(lhs.disable_frame_rate_limit, rhs.disable_frame_rate_limit))
    return true;
  if (std::less<>{}(rhs.disable_frame_rate_limit, lhs.disable_frame_rate_limit))
    return false;
  if (std::less<>{}(lhs.use_preferred_interval_for_video, rhs.use_preferred_interval_for_video))
    return true;
  if (std::less<>{}(rhs.use_preferred_interval_for_video, lhs.use_preferred_interval_for_video))
    return false;
  if (std::less<>{}(lhs.num_of_frames_to_toggle_interval, rhs.num_of_frames_to_toggle_interval))
    return true;
  if (std::less<>{}(rhs.num_of_frames_to_toggle_interval, lhs.num_of_frames_to_toggle_interval))
    return false;
  if (std::less<>{}(lhs.compositor_frame_sink, rhs.compositor_frame_sink))
    return true;
  if (std::less<>{}(rhs.compositor_frame_sink, lhs.compositor_frame_sink))
    return false;
  if (std::less<>{}(lhs.compositor_frame_sink_client, rhs.compositor_frame_sink_client))
    return true;
  if (std::less<>{}(rhs.compositor_frame_sink_client, lhs.compositor_frame_sink_client))
    return false;
  if (std::less<>{}(lhs.display_private, rhs.display_private))
    return true;
  if (std::less<>{}(rhs.display_private, lhs.display_private))
    return false;
  if (std::less<>{}(lhs.display_client, rhs.display_client))
    return true;
  if (std::less<>{}(rhs.display_client, lhs.display_client))
    return false;
  if (std::less<>{}(lhs.external_begin_frame_controller, rhs.external_begin_frame_controller))
    return true;
  if (std::less<>{}(rhs.external_begin_frame_controller, lhs.external_begin_frame_controller))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace viz

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::RootCompositorFrameSinkParams::DataView,
                                         ::viz::mojom::RootCompositorFrameSinkParamsPtr> {
  static bool IsNull(const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::RootCompositorFrameSinkParamsPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::RootCompositorFrameSinkParams::frame_sink_id)& frame_sink_id(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->frame_sink_id;
  }

  static const decltype(::viz::mojom::RootCompositorFrameSinkParams::widget)& widget(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->widget;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::gpu_compositing) gpu_compositing(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->gpu_compositing;
  }

  static const decltype(::viz::mojom::RootCompositorFrameSinkParams::renderer_settings)& renderer_settings(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->renderer_settings;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::send_swap_size_notifications) send_swap_size_notifications(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->send_swap_size_notifications;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::disable_frame_rate_limit) disable_frame_rate_limit(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->disable_frame_rate_limit;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::use_preferred_interval_for_video) use_preferred_interval_for_video(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->use_preferred_interval_for_video;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::num_of_frames_to_toggle_interval) num_of_frames_to_toggle_interval(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->num_of_frames_to_toggle_interval;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::compositor_frame_sink)& compositor_frame_sink(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->compositor_frame_sink;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::compositor_frame_sink_client)& compositor_frame_sink_client(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->compositor_frame_sink_client;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::display_private)& display_private(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->display_private;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::display_client)& display_client(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->display_client;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::external_begin_frame_controller)& external_begin_frame_controller(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->external_begin_frame_controller;
  }

  static bool Read(::viz::mojom::RootCompositorFrameSinkParams::DataView input, ::viz::mojom::RootCompositorFrameSinkParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_H_