// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
RootCompositorFrameSinkParams::RootCompositorFrameSinkParams()
    : frame_sink_id(),
      widget(),
      gpu_compositing(true),
      renderer_settings(),
      send_swap_size_notifications(false),
      disable_frame_rate_limit(false),
      use_preferred_interval_for_video(false),
      num_of_frames_to_toggle_interval(60U),
      compositor_frame_sink(),
      compositor_frame_sink_client(),
      display_private(),
      display_client(),
      external_begin_frame_controller() {}

RootCompositorFrameSinkParams::RootCompositorFrameSinkParams(
    const ::viz::FrameSinkId& frame_sink_id_in,
    ::gpu::SurfaceHandle widget_in,
    bool gpu_compositing_in,
    const ::viz::RendererSettings& renderer_settings_in,
    bool send_swap_size_notifications_in,
    bool disable_frame_rate_limit_in,
    bool use_preferred_interval_for_video_in,
    uint32_t num_of_frames_to_toggle_interval_in,
    ::mojo::PendingAssociatedReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink_in,
    ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client_in,
    ::mojo::PendingAssociatedReceiver<::viz::mojom::DisplayPrivate> display_private_in,
    ::mojo::PendingRemote<::viz::mojom::DisplayClient> display_client_in,
    ::mojo::PendingAssociatedReceiver<::viz::mojom::ExternalBeginFrameController> external_begin_frame_controller_in)
    : frame_sink_id(std::move(frame_sink_id_in)),
      widget(std::move(widget_in)),
      gpu_compositing(std::move(gpu_compositing_in)),
      renderer_settings(std::move(renderer_settings_in)),
      send_swap_size_notifications(std::move(send_swap_size_notifications_in)),
      disable_frame_rate_limit(std::move(disable_frame_rate_limit_in)),
      use_preferred_interval_for_video(std::move(use_preferred_interval_for_video_in)),
      num_of_frames_to_toggle_interval(std::move(num_of_frames_to_toggle_interval_in)),
      compositor_frame_sink(std::move(compositor_frame_sink_in)),
      compositor_frame_sink_client(std::move(compositor_frame_sink_client_in)),
      display_private(std::move(display_private_in)),
      display_client(std::move(display_client_in)),
      external_begin_frame_controller(std::move(external_begin_frame_controller_in)) {}

RootCompositorFrameSinkParams::~RootCompositorFrameSinkParams() = default;

void RootCompositorFrameSinkParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("frame_sink_id", base::trace_event::ValueToString(this->frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
  value->SetString("widget", base::trace_event::ValueToString(this->widget, "<value of type ::gpu::SurfaceHandle>"));
  value->SetBoolean("gpu_compositing", this->gpu_compositing);
  value->SetString("renderer_settings", base::trace_event::ValueToString(this->renderer_settings, "<value of type const ::viz::RendererSettings&>"));
  value->SetBoolean("send_swap_size_notifications", this->send_swap_size_notifications);
  value->SetBoolean("disable_frame_rate_limit", this->disable_frame_rate_limit);
  value->SetBoolean("use_preferred_interval_for_video", this->use_preferred_interval_for_video);
  value->SetString("num_of_frames_to_toggle_interval", base::NumberToString(this->num_of_frames_to_toggle_interval));
  value->SetBoolean("compositor_frame_sink", this->compositor_frame_sink.is_valid());
  value->SetBoolean("compositor_frame_sink_client", this->compositor_frame_sink_client.is_valid());
  value->SetBoolean("display_private", this->display_private.is_valid());
  value->SetBoolean("display_client", this->display_client.is_valid());
  value->SetBoolean("external_begin_frame_controller", this->external_begin_frame_controller.is_valid());
}

bool RootCompositorFrameSinkParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char FrameSinkManager::Name_[] = "viz.mojom.FrameSinkManager";
bool FrameSinkManager::DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id) {
  NOTREACHED();
  return false;
}
bool FrameSinkManager::EvictBackBuffer(uint32_t cache_id) {
  NOTREACHED();
  return false;
}
class FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse);
};

class FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback(
      FrameSinkManager::DestroyCompositorFrameSinkCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManager::DestroyCompositorFrameSinkCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback);
};
class FrameSinkManager_EvictBackBuffer_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameSinkManager_EvictBackBuffer_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(FrameSinkManager_EvictBackBuffer_HandleSyncResponse);
};

class FrameSinkManager_EvictBackBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManager_EvictBackBuffer_ForwardToCallback(
      FrameSinkManager::EvictBackBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManager::EvictBackBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameSinkManager_EvictBackBuffer_ForwardToCallback);
};

FrameSinkManagerProxy::FrameSinkManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkManagerProxy::RegisterFrameSinkId(
    const ::viz::FrameSinkId& in_frame_sink_id, bool in_report_activation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::RegisterFrameSinkId", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->SetBoolean("report_activation", in_report_activation);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_RegisterFrameSinkId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_RegisterFrameSinkId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManager.RegisterFrameSinkId request");
  params->report_activation = in_report_activation;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("RegisterFrameSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::InvalidateFrameSinkId(
    const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::InvalidateFrameSinkId", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_InvalidateFrameSinkId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManager.InvalidateFrameSinkId request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("InvalidateFrameSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::SetFrameSinkDebugLabel(
    const ::viz::FrameSinkId& in_frame_sink_id, const std::string& in_debug_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::SetFrameSinkDebugLabel", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->SetString("debug_label", in_debug_label);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_SetFrameSinkDebugLabel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManager.SetFrameSinkDebugLabel request");
  typename decltype(params->debug_label)::BaseType::BufferWriter
      debug_label_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_debug_label, buffer, &debug_label_writer, &serialization_context);
  params->debug_label.Set(
      debug_label_writer.is_null() ? nullptr : debug_label_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->debug_label.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_label in FrameSinkManager.SetFrameSinkDebugLabel request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("SetFrameSinkDebugLabel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::CreateRootCompositorFrameSink(
    RootCompositorFrameSinkParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::CreateRootCompositorFrameSink", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_CreateRootCompositorFrameSink_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::viz::mojom::RootCompositorFrameSinkParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in FrameSinkManager.CreateRootCompositorFrameSink request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateRootCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::CreateCompositorFrameSink(
    const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> in_compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> in_compositor_frame_sink_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::CreateCompositorFrameSink", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->SetBoolean("compositor_frame_sink", in_compositor_frame_sink.is_valid());
      raw_value->SetBoolean("compositor_frame_sink_client", in_compositor_frame_sink_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_CreateCompositorFrameSink_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManager.CreateCompositorFrameSink request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
      in_compositor_frame_sink, &params->compositor_frame_sink, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid compositor_frame_sink in FrameSinkManager.CreateCompositorFrameSink request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
      in_compositor_frame_sink_client, &params->compositor_frame_sink_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid compositor_frame_sink_client in FrameSinkManager.CreateCompositorFrameSink request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool FrameSinkManagerProxy::DestroyCompositorFrameSink(
    const ::viz::FrameSinkId& param_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "viz::mojom::FrameSinkManager::DestroyCompositorFrameSink", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(param_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_DestroyCompositorFrameSink_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      param_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManager.DestroyCompositorFrameSink request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("DestroyCompositorFrameSink");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "viz::mojom::FrameSinkManager::DestroyCompositorFrameSink");
#endif
  return result;
}

void FrameSinkManagerProxy::DestroyCompositorFrameSink(
    const ::viz::FrameSinkId& in_frame_sink_id, DestroyCompositorFrameSinkCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::DestroyCompositorFrameSink", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_DestroyCompositorFrameSink_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManager.DestroyCompositorFrameSink request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("DestroyCompositorFrameSink");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameSinkManagerProxy::RegisterFrameSinkHierarchy(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_child_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::RegisterFrameSinkHierarchy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("parent_frame_sink_id", base::trace_event::ValueToString(in_parent_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->SetString("child_frame_sink_id", base::trace_event::ValueToString(in_child_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_RegisterFrameSinkHierarchy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->parent_frame_sink_id)::BaseType::BufferWriter
      parent_frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_parent_frame_sink_id, buffer, &parent_frame_sink_id_writer, &serialization_context);
  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_writer.is_null() ? nullptr : parent_frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parent_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_frame_sink_id in FrameSinkManager.RegisterFrameSinkHierarchy request");
  typename decltype(params->child_frame_sink_id)::BaseType::BufferWriter
      child_frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_child_frame_sink_id, buffer, &child_frame_sink_id_writer, &serialization_context);
  params->child_frame_sink_id.Set(
      child_frame_sink_id_writer.is_null() ? nullptr : child_frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_sink_id in FrameSinkManager.RegisterFrameSinkHierarchy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("RegisterFrameSinkHierarchy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::UnregisterFrameSinkHierarchy(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_child_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::UnregisterFrameSinkHierarchy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("parent_frame_sink_id", base::trace_event::ValueToString(in_parent_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->SetString("child_frame_sink_id", base::trace_event::ValueToString(in_child_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_UnregisterFrameSinkHierarchy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->parent_frame_sink_id)::BaseType::BufferWriter
      parent_frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_parent_frame_sink_id, buffer, &parent_frame_sink_id_writer, &serialization_context);
  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_writer.is_null() ? nullptr : parent_frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parent_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_frame_sink_id in FrameSinkManager.UnregisterFrameSinkHierarchy request");
  typename decltype(params->child_frame_sink_id)::BaseType::BufferWriter
      child_frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_child_frame_sink_id, buffer, &child_frame_sink_id_writer, &serialization_context);
  params->child_frame_sink_id.Set(
      child_frame_sink_id_writer.is_null() ? nullptr : child_frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_sink_id in FrameSinkManager.UnregisterFrameSinkHierarchy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("UnregisterFrameSinkHierarchy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::AddVideoDetectorObserver(
    ::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::AddVideoDetectorObserver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("observer", in_observer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_AddVideoDetectorObserver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::VideoDetectorObserverInterfaceBase>>(
      in_observer, &params->observer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in FrameSinkManager.AddVideoDetectorObserver request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("AddVideoDetectorObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::CreateVideoCapturer(
    ::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::CreateVideoCapturer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_CreateVideoCapturer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_CreateVideoCapturer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkVideoCapturerInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in FrameSinkManager.CreateVideoCapturer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateVideoCapturer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::EvictSurfaces(
    const std::vector<::viz::SurfaceId>& in_surface_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::EvictSurfaces", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("surface_ids");
      for (const auto& item0 : in_surface_ids) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::SurfaceId&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_EvictSurfaces_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_EvictSurfaces_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->surface_ids)::BaseType::BufferWriter
      surface_ids_writer;
  const mojo::internal::ContainerValidateParams surface_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::SurfaceIdDataView>>(
      in_surface_ids, buffer, &surface_ids_writer, &surface_ids_validate_params,
      &serialization_context);
  params->surface_ids.Set(
      surface_ids_writer.is_null() ? nullptr : surface_ids_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->surface_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_ids in FrameSinkManager.EvictSurfaces request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("EvictSurfaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::StartThrottling(
    const std::vector<::viz::FrameSinkId>& in_frame_sink_ids, ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::StartThrottling", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("frame_sink_ids");
      for (const auto& item0 : in_frame_sink_ids) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::FrameSinkId&>"));
      }
      raw_value->EndArray();
      raw_value->SetString("interval", base::trace_event::ValueToString(in_interval, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_StartThrottling_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_StartThrottling_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_ids)::BaseType::BufferWriter
      frame_sink_ids_writer;
  const mojo::internal::ContainerValidateParams frame_sink_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>>(
      in_frame_sink_ids, buffer, &frame_sink_ids_writer, &frame_sink_ids_validate_params,
      &serialization_context);
  params->frame_sink_ids.Set(
      frame_sink_ids_writer.is_null() ? nullptr : frame_sink_ids_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_ids in FrameSinkManager.StartThrottling request");
  typename decltype(params->interval)::BaseType::BufferWriter
      interval_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_interval, buffer, &interval_writer, &serialization_context);
  params->interval.Set(
      interval_writer.is_null() ? nullptr : interval_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->interval.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interval in FrameSinkManager.StartThrottling request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("StartThrottling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::EndThrottling(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::FrameSinkManager::EndThrottling");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_EndThrottling_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_EndThrottling_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("EndThrottling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::RequestCopyOfOutput(
    const ::viz::SurfaceId& in_surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::RequestCopyOfOutput", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("surface_id", base::trace_event::ValueToString(in_surface_id, "<value of type const ::viz::SurfaceId&>"));
      raw_value->SetString("request", base::trace_event::ValueToString(in_request, "<value of type ::std::unique_ptr<::viz::CopyOutputRequest>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_RequestCopyOfOutput_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_RequestCopyOfOutput_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->surface_id)::BaseType::BufferWriter
      surface_id_writer;
  mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
      in_surface_id, buffer, &surface_id_writer, &serialization_context);
  params->surface_id.Set(
      surface_id_writer.is_null() ? nullptr : surface_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_id in FrameSinkManager.RequestCopyOfOutput request");
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::viz::mojom::CopyOutputRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in FrameSinkManager.RequestCopyOfOutput request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("RequestCopyOfOutput");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::SetHitTestAsyncQueriedDebugRegions(
    const ::viz::FrameSinkId& in_root_frame_sink_id, const std::vector<::viz::FrameSinkId>& in_hit_test_async_queried_debug_queue) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::SetHitTestAsyncQueriedDebugRegions", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("root_frame_sink_id", base::trace_event::ValueToString(in_root_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->BeginArray("hit_test_async_queried_debug_queue");
      for (const auto& item0 : in_hit_test_async_queried_debug_queue) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::FrameSinkId&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->root_frame_sink_id)::BaseType::BufferWriter
      root_frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_root_frame_sink_id, buffer, &root_frame_sink_id_writer, &serialization_context);
  params->root_frame_sink_id.Set(
      root_frame_sink_id_writer.is_null() ? nullptr : root_frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->root_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_frame_sink_id in FrameSinkManager.SetHitTestAsyncQueriedDebugRegions request");
  typename decltype(params->hit_test_async_queried_debug_queue)::BaseType::BufferWriter
      hit_test_async_queried_debug_queue_writer;
  const mojo::internal::ContainerValidateParams hit_test_async_queried_debug_queue_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>>(
      in_hit_test_async_queried_debug_queue, buffer, &hit_test_async_queried_debug_queue_writer, &hit_test_async_queried_debug_queue_validate_params,
      &serialization_context);
  params->hit_test_async_queried_debug_queue.Set(
      hit_test_async_queried_debug_queue_writer.is_null() ? nullptr : hit_test_async_queried_debug_queue_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hit_test_async_queried_debug_queue.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hit_test_async_queried_debug_queue in FrameSinkManager.SetHitTestAsyncQueriedDebugRegions request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("SetHitTestAsyncQueriedDebugRegions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerProxy::CacheBackBuffer(
    uint32_t in_cache_id, const ::viz::FrameSinkId& in_root_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::CacheBackBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_id", base::NumberToString(in_cache_id));
      raw_value->SetString("root_frame_sink_id", base::trace_event::ValueToString(in_root_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_CacheBackBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_CacheBackBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->cache_id = in_cache_id;
  typename decltype(params->root_frame_sink_id)::BaseType::BufferWriter
      root_frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_root_frame_sink_id, buffer, &root_frame_sink_id_writer, &serialization_context);
  params->root_frame_sink_id.Set(
      root_frame_sink_id_writer.is_null() ? nullptr : root_frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->root_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_frame_sink_id in FrameSinkManager.CacheBackBuffer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CacheBackBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool FrameSinkManagerProxy::EvictBackBuffer(
    uint32_t param_cache_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "viz::mojom::FrameSinkManager::EvictBackBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_id", base::NumberToString(param_cache_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_EvictBackBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_EvictBackBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->cache_id = param_cache_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("EvictBackBuffer");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManager_EvictBackBuffer_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "viz::mojom::FrameSinkManager::EvictBackBuffer");
#endif
  return result;
}

void FrameSinkManagerProxy::EvictBackBuffer(
    uint32_t in_cache_id, EvictBackBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::EvictBackBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_id", base::NumberToString(in_cache_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_EvictBackBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_EvictBackBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->cache_id = in_cache_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("EvictBackBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManager_EvictBackBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameSinkManagerProxy::UpdateDebugRendererSettings(
    const ::viz::DebugRendererSettings& in_debug_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManager::UpdateDebugRendererSettings", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("debug_settings", base::trace_event::ValueToString(in_debug_settings, "<value of type const ::viz::DebugRendererSettings&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_UpdateDebugRendererSettings_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->debug_settings)::BaseType::BufferWriter
      debug_settings_writer;
  mojo::internal::Serialize<::viz::mojom::DebugRendererSettingsDataView>(
      in_debug_settings, buffer, &debug_settings_writer, &serialization_context);
  params->debug_settings.Set(
      debug_settings_writer.is_null() ? nullptr : debug_settings_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->debug_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_settings in FrameSinkManager.UpdateDebugRendererSettings request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("UpdateDebugRendererSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder {
 public:
  static FrameSinkManager::DestroyCompositorFrameSinkCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder> proxy(
        new FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinkManager::DestroyCompositorFrameSinkCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder);
};

bool FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::FrameSinkManager::DestroyCompositorFrameSinkCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  FrameSinkManager_DestroyCompositorFrameSink_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)viz::mojom::FrameSinkManager::DestroyCompositorFrameSinkCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_DestroyCompositorFrameSink_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::FrameSinkManager::DestroyCompositorFrameSinkCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("DestroyCompositorFrameSink");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  FrameSinkManager_DestroyCompositorFrameSink_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManager::Name_, 5, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class FrameSinkManager_EvictBackBuffer_ProxyToResponder {
 public:
  static FrameSinkManager::EvictBackBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameSinkManager_EvictBackBuffer_ProxyToResponder> proxy(
        new FrameSinkManager_EvictBackBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameSinkManager_EvictBackBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManager_EvictBackBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameSinkManager_EvictBackBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinkManager::EvictBackBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameSinkManager_EvictBackBuffer_ProxyToResponder);
};

bool FrameSinkManager_EvictBackBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::FrameSinkManager::EvictBackBufferCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameSinkManager_EvictBackBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManager_EvictBackBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  FrameSinkManager_EvictBackBuffer_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManager::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void FrameSinkManager_EvictBackBuffer_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)viz::mojom::FrameSinkManager::EvictBackBufferCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManager_EvictBackBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManager_EvictBackBuffer_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::FrameSinkManager::EvictBackBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("EvictBackBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameSinkManager_EvictBackBuffer_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameSinkManager_EvictBackBuffer_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameSinkManager_EvictBackBuffer_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  FrameSinkManager_EvictBackBuffer_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManager::Name_, 16, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool FrameSinkManagerStubDispatch::Accept(
    FrameSinkManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameSinkManager_RegisterFrameSinkId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::RegisterFrameSinkId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::RegisterFrameSinkId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_RegisterFrameSinkId_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_RegisterFrameSinkId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      bool p_report_activation{};
      FrameSinkManager_RegisterFrameSinkId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success)
        p_report_activation = input_data_view.report_activation();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFrameSinkId(
std::move(p_frame_sink_id), 
std::move(p_report_activation));
      return true;
    }
    case internal::kFrameSinkManager_InvalidateFrameSinkId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::InvalidateFrameSinkId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::InvalidateFrameSinkId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      FrameSinkManager_InvalidateFrameSinkId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InvalidateFrameSinkId(
std::move(p_frame_sink_id));
      return true;
    }
    case internal::kFrameSinkManager_SetFrameSinkDebugLabel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::SetFrameSinkDebugLabel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::SetFrameSinkDebugLabel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      std::string p_debug_label{};
      FrameSinkManager_SetFrameSinkDebugLabel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadDebugLabel(&p_debug_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameSinkDebugLabel(
std::move(p_frame_sink_id), 
std::move(p_debug_label));
      return true;
    }
    case internal::kFrameSinkManager_CreateRootCompositorFrameSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::CreateRootCompositorFrameSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::CreateRootCompositorFrameSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RootCompositorFrameSinkParamsPtr p_params{};
      FrameSinkManager_CreateRootCompositorFrameSink_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRootCompositorFrameSink(
std::move(p_params));
      return true;
    }
    case internal::kFrameSinkManager_CreateCompositorFrameSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::CreateCompositorFrameSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::CreateCompositorFrameSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> p_compositor_frame_sink{};
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> p_compositor_frame_sink_client{};
      FrameSinkManager_CreateCompositorFrameSink_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_compositor_frame_sink =
            input_data_view.TakeCompositorFrameSink<decltype(p_compositor_frame_sink)>();
      }
      if (success) {
        p_compositor_frame_sink_client =
            input_data_view.TakeCompositorFrameSinkClient<decltype(p_compositor_frame_sink_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCompositorFrameSink(
std::move(p_frame_sink_id), 
std::move(p_compositor_frame_sink), 
std::move(p_compositor_frame_sink_client));
      return true;
    }
    case internal::kFrameSinkManager_DestroyCompositorFrameSink_Name: {
      break;
    }
    case internal::kFrameSinkManager_RegisterFrameSinkHierarchy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::RegisterFrameSinkHierarchy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::RegisterFrameSinkHierarchy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_child_frame_sink_id{};
      FrameSinkManager_RegisterFrameSinkHierarchy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadChildFrameSinkId(&p_child_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFrameSinkHierarchy(
std::move(p_parent_frame_sink_id), 
std::move(p_child_frame_sink_id));
      return true;
    }
    case internal::kFrameSinkManager_UnregisterFrameSinkHierarchy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::UnregisterFrameSinkHierarchy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::UnregisterFrameSinkHierarchy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_child_frame_sink_id{};
      FrameSinkManager_UnregisterFrameSinkHierarchy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadChildFrameSinkId(&p_child_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterFrameSinkHierarchy(
std::move(p_parent_frame_sink_id), 
std::move(p_child_frame_sink_id));
      return true;
    }
    case internal::kFrameSinkManager_AddVideoDetectorObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::AddVideoDetectorObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::AddVideoDetectorObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> p_observer{};
      FrameSinkManager_AddVideoDetectorObserver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVideoDetectorObserver(
std::move(p_observer));
      return true;
    }
    case internal::kFrameSinkManager_CreateVideoCapturer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::CreateVideoCapturer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::CreateVideoCapturer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateVideoCapturer_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateVideoCapturer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> p_receiver{};
      FrameSinkManager_CreateVideoCapturer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoCapturer(
std::move(p_receiver));
      return true;
    }
    case internal::kFrameSinkManager_EvictSurfaces_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::EvictSurfaces",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::EvictSurfaces");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_EvictSurfaces_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_EvictSurfaces_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::viz::SurfaceId> p_surface_ids{};
      FrameSinkManager_EvictSurfaces_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSurfaceIds(&p_surface_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EvictSurfaces(
std::move(p_surface_ids));
      return true;
    }
    case internal::kFrameSinkManager_StartThrottling_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::StartThrottling",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::StartThrottling");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_StartThrottling_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_StartThrottling_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::viz::FrameSinkId> p_frame_sink_ids{};
      ::base::TimeDelta p_interval{};
      FrameSinkManager_StartThrottling_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkIds(&p_frame_sink_ids))
        success = false;
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartThrottling(
std::move(p_frame_sink_ids), 
std::move(p_interval));
      return true;
    }
    case internal::kFrameSinkManager_EndThrottling_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::EndThrottling",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::EndThrottling");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_EndThrottling_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_EndThrottling_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameSinkManager_EndThrottling_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndThrottling();
      return true;
    }
    case internal::kFrameSinkManager_RequestCopyOfOutput_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::RequestCopyOfOutput",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::RequestCopyOfOutput");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_RequestCopyOfOutput_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_RequestCopyOfOutput_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::SurfaceId p_surface_id{};
      ::std::unique_ptr<::viz::CopyOutputRequest> p_request{};
      FrameSinkManager_RequestCopyOfOutput_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSurfaceId(&p_surface_id))
        success = false;
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestCopyOfOutput(
std::move(p_surface_id), 
std::move(p_request));
      return true;
    }
    case internal::kFrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::SetHitTestAsyncQueriedDebugRegions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::SetHitTestAsyncQueriedDebugRegions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_root_frame_sink_id{};
      std::vector<::viz::FrameSinkId> p_hit_test_async_queried_debug_queue{};
      FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRootFrameSinkId(&p_root_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadHitTestAsyncQueriedDebugQueue(&p_hit_test_async_queried_debug_queue))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHitTestAsyncQueriedDebugRegions(
std::move(p_root_frame_sink_id), 
std::move(p_hit_test_async_queried_debug_queue));
      return true;
    }
    case internal::kFrameSinkManager_CacheBackBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::CacheBackBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::CacheBackBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CacheBackBuffer_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CacheBackBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_cache_id{};
      ::viz::FrameSinkId p_root_frame_sink_id{};
      FrameSinkManager_CacheBackBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_cache_id = input_data_view.cache_id();
      if (success && !input_data_view.ReadRootFrameSinkId(&p_root_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CacheBackBuffer(
std::move(p_cache_id), 
std::move(p_root_frame_sink_id));
      return true;
    }
    case internal::kFrameSinkManager_EvictBackBuffer_Name: {
      break;
    }
    case internal::kFrameSinkManager_UpdateDebugRendererSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::UpdateDebugRendererSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::UpdateDebugRendererSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::DebugRendererSettings p_debug_settings{};
      FrameSinkManager_UpdateDebugRendererSettings_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDebugSettings(&p_debug_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDebugRendererSettings(
std::move(p_debug_settings));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkManagerStubDispatch::AcceptWithResponder(
    FrameSinkManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkManager_RegisterFrameSinkId_Name: {
      break;
    }
    case internal::kFrameSinkManager_InvalidateFrameSinkId_Name: {
      break;
    }
    case internal::kFrameSinkManager_SetFrameSinkDebugLabel_Name: {
      break;
    }
    case internal::kFrameSinkManager_CreateRootCompositorFrameSink_Name: {
      break;
    }
    case internal::kFrameSinkManager_CreateCompositorFrameSink_Name: {
      break;
    }
    case internal::kFrameSinkManager_DestroyCompositorFrameSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::DestroyCompositorFrameSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::DestroyCompositorFrameSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      FrameSinkManager_DestroyCompositorFrameSink_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 5, false);
        return false;
      }
      FrameSinkManager::DestroyCompositorFrameSinkCallback callback =
          FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyCompositorFrameSink(
std::move(p_frame_sink_id), std::move(callback));
      return true;
    }
    case internal::kFrameSinkManager_RegisterFrameSinkHierarchy_Name: {
      break;
    }
    case internal::kFrameSinkManager_UnregisterFrameSinkHierarchy_Name: {
      break;
    }
    case internal::kFrameSinkManager_AddVideoDetectorObserver_Name: {
      break;
    }
    case internal::kFrameSinkManager_CreateVideoCapturer_Name: {
      break;
    }
    case internal::kFrameSinkManager_EvictSurfaces_Name: {
      break;
    }
    case internal::kFrameSinkManager_StartThrottling_Name: {
      break;
    }
    case internal::kFrameSinkManager_EndThrottling_Name: {
      break;
    }
    case internal::kFrameSinkManager_RequestCopyOfOutput_Name: {
      break;
    }
    case internal::kFrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Name: {
      break;
    }
    case internal::kFrameSinkManager_CacheBackBuffer_Name: {
      break;
    }
    case internal::kFrameSinkManager_EvictBackBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManager::EvictBackBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManager::EvictBackBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameSinkManager_EvictBackBuffer_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManager_EvictBackBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_cache_id{};
      FrameSinkManager_EvictBackBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_cache_id = input_data_view.cache_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 16, false);
        return false;
      }
      FrameSinkManager::EvictBackBufferCallback callback =
          FrameSinkManager_EvictBackBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EvictBackBuffer(
std::move(p_cache_id), std::move(callback));
      return true;
    }
    case internal::kFrameSinkManager_UpdateDebugRendererSettings_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkManagerValidationInfo[] = {
    {internal::kFrameSinkManager_RegisterFrameSinkId_Name,
     {&internal::FrameSinkManager_RegisterFrameSinkId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_InvalidateFrameSinkId_Name,
     {&internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_SetFrameSinkDebugLabel_Name,
     {&internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_CreateRootCompositorFrameSink_Name,
     {&internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_CreateCompositorFrameSink_Name,
     {&internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_DestroyCompositorFrameSink_Name,
     {&internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data::Validate,
      &internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data::Validate}},
    {internal::kFrameSinkManager_RegisterFrameSinkHierarchy_Name,
     {&internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_UnregisterFrameSinkHierarchy_Name,
     {&internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_AddVideoDetectorObserver_Name,
     {&internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_CreateVideoCapturer_Name,
     {&internal::FrameSinkManager_CreateVideoCapturer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_EvictSurfaces_Name,
     {&internal::FrameSinkManager_EvictSurfaces_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_StartThrottling_Name,
     {&internal::FrameSinkManager_StartThrottling_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_EndThrottling_Name,
     {&internal::FrameSinkManager_EndThrottling_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_RequestCopyOfOutput_Name,
     {&internal::FrameSinkManager_RequestCopyOfOutput_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Name,
     {&internal::FrameSinkManager_SetHitTestAsyncQueriedDebugRegions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_CacheBackBuffer_Name,
     {&internal::FrameSinkManager_CacheBackBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManager_EvictBackBuffer_Name,
     {&internal::FrameSinkManager_EvictBackBuffer_Params_Data::Validate,
      &internal::FrameSinkManager_EvictBackBuffer_ResponseParams_Data::Validate}},
    {internal::kFrameSinkManager_UpdateDebugRendererSettings_Name,
     {&internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkManagerValidationInfo);
}

bool FrameSinkManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameSinkManagerValidationInfo);

}
const char FrameSinkManagerClient::Name_[] = "viz.mojom.FrameSinkManagerClient";

FrameSinkManagerClientProxy::FrameSinkManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkManagerClientProxy::OnFirstSurfaceActivation(
    const ::viz::SurfaceInfo& in_surface_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManagerClient::OnFirstSurfaceActivation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("surface_info", base::trace_event::ValueToString(in_surface_info, "<value of type const ::viz::SurfaceInfo&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManagerClient_OnFirstSurfaceActivation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->surface_info)::BaseType::BufferWriter
      surface_info_writer;
  mojo::internal::Serialize<::viz::mojom::SurfaceInfoDataView>(
      in_surface_info, buffer, &surface_info_writer, &serialization_context);
  params->surface_info.Set(
      surface_info_writer.is_null() ? nullptr : surface_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->surface_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_info in FrameSinkManagerClient.OnFirstSurfaceActivation request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnFirstSurfaceActivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerClientProxy::OnAggregatedHitTestRegionListUpdated(
    const ::viz::FrameSinkId& in_frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& in_hit_test_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->BeginArray("hit_test_data");
      for (const auto& item0 : in_hit_test_data) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::AggregatedHitTestRegion&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManagerClient.OnAggregatedHitTestRegionListUpdated request");
  typename decltype(params->hit_test_data)::BaseType::BufferWriter
      hit_test_data_writer;
  const mojo::internal::ContainerValidateParams hit_test_data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AggregatedHitTestRegionDataView>>(
      in_hit_test_data, buffer, &hit_test_data_writer, &hit_test_data_validate_params,
      &serialization_context);
  params->hit_test_data.Set(
      hit_test_data_writer.is_null() ? nullptr : hit_test_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hit_test_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hit_test_data in FrameSinkManagerClient.OnAggregatedHitTestRegionListUpdated request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnAggregatedHitTestRegionListUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkManagerClientProxy::OnFrameTokenChanged(
    const ::viz::FrameSinkId& in_frame_sink_id, uint32_t in_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkManagerClient::OnFrameTokenChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_sink_id", base::trace_event::ValueToString(in_frame_sink_id, "<value of type const ::viz::FrameSinkId&>"));
      raw_value->SetString("frame_token", base::NumberToString(in_frame_token));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkManagerClient_OnFrameTokenChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_sink_id)::BaseType::BufferWriter
      frame_sink_id_writer;
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, buffer, &frame_sink_id_writer, &serialization_context);
  params->frame_sink_id.Set(
      frame_sink_id_writer.is_null() ? nullptr : frame_sink_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in FrameSinkManagerClient.OnFrameTokenChanged request");
  params->frame_token = in_frame_token;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnFrameTokenChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkManagerClientStubDispatch::Accept(
    FrameSinkManagerClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameSinkManagerClient_OnFirstSurfaceActivation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManagerClient::OnFirstSurfaceActivation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManagerClient::OnFirstSurfaceActivation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::SurfaceInfo p_surface_info{};
      FrameSinkManagerClient_OnFirstSurfaceActivation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSurfaceInfo(&p_surface_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFirstSurfaceActivation(
std::move(p_surface_info));
      return true;
    }
    case internal::kFrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      std::vector<::viz::AggregatedHitTestRegion> p_hit_test_data{};
      FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadHitTestData(&p_hit_test_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAggregatedHitTestRegionListUpdated(
std::move(p_frame_sink_id), 
std::move(p_hit_test_data));
      return true;
    }
    case internal::kFrameSinkManagerClient_OnFrameTokenChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkManagerClient::OnFrameTokenChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkManagerClient::OnFrameTokenChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      uint32_t p_frame_token{};
      FrameSinkManagerClient_OnFrameTokenChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success)
        p_frame_token = input_data_view.frame_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameTokenChanged(
std::move(p_frame_sink_id), 
std::move(p_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkManagerClientStubDispatch::AcceptWithResponder(
    FrameSinkManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkManagerClient_OnFirstSurfaceActivation_Name: {
      break;
    }
    case internal::kFrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Name: {
      break;
    }
    case internal::kFrameSinkManagerClient_OnFrameTokenChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkManagerClientValidationInfo[] = {
    {internal::kFrameSinkManagerClient_OnFirstSurfaceActivation_Name,
     {&internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Name,
     {&internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkManagerClient_OnFrameTokenChanged_Name,
     {&internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkManagerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkManagerClientValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::RootCompositorFrameSinkParams::DataView, ::viz::mojom::RootCompositorFrameSinkParamsPtr>::Read(
    ::viz::mojom::RootCompositorFrameSinkParams::DataView input,
    ::viz::mojom::RootCompositorFrameSinkParamsPtr* output) {
  bool success = true;
  ::viz::mojom::RootCompositorFrameSinkParamsPtr result(::viz::mojom::RootCompositorFrameSinkParams::New());
  
      if (success && !input.ReadFrameSinkId(&result->frame_sink_id))
        success = false;
      if (success && !input.ReadWidget(&result->widget))
        success = false;
      if (success)
        result->gpu_compositing = input.gpu_compositing();
      if (success && !input.ReadRendererSettings(&result->renderer_settings))
        success = false;
      if (success)
        result->send_swap_size_notifications = input.send_swap_size_notifications();
      if (success)
        result->disable_frame_rate_limit = input.disable_frame_rate_limit();
      if (success)
        result->use_preferred_interval_for_video = input.use_preferred_interval_for_video();
      if (success)
        result->num_of_frames_to_toggle_interval = input.num_of_frames_to_toggle_interval();
      if (success) {
        result->compositor_frame_sink =
            input.TakeCompositorFrameSink<decltype(result->compositor_frame_sink)>();
      }
      if (success) {
        result->compositor_frame_sink_client =
            input.TakeCompositorFrameSinkClient<decltype(result->compositor_frame_sink_client)>();
      }
      if (success) {
        result->display_private =
            input.TakeDisplayPrivate<decltype(result->display_private)>();
      }
      if (success) {
        result->display_client =
            input.TakeDisplayClient<decltype(result->display_client)>();
      }
      if (success) {
        result->external_begin_frame_controller =
            input.TakeExternalBeginFrameController<decltype(result->external_begin_frame_controller)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif