// services/video_capture/public/mojom/device.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace video_capture {
namespace mojom {
namespace internal {
class  Device_Start_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_Start_Params_Data));
      new (data()) Device_Start_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_Start_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_Start_Params_Data>(index_);
    }
    Device_Start_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoCaptureParams_Data> requested_settings;
  mojo::internal::Interface_Data handler;

 private:
  Device_Start_Params_Data();
  ~Device_Start_Params_Data() = delete;
};
static_assert(sizeof(Device_Start_Params_Data) == 24,
              "Bad sizeof(Device_Start_Params_Data)");
class  Device_MaybeSuspend_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_MaybeSuspend_Params_Data));
      new (data()) Device_MaybeSuspend_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_MaybeSuspend_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_MaybeSuspend_Params_Data>(index_);
    }
    Device_MaybeSuspend_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  Device_MaybeSuspend_Params_Data();
  ~Device_MaybeSuspend_Params_Data() = delete;
};
static_assert(sizeof(Device_MaybeSuspend_Params_Data) == 8,
              "Bad sizeof(Device_MaybeSuspend_Params_Data)");
class  Device_Resume_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_Resume_Params_Data));
      new (data()) Device_Resume_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_Resume_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_Resume_Params_Data>(index_);
    }
    Device_Resume_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  Device_Resume_Params_Data();
  ~Device_Resume_Params_Data() = delete;
};
static_assert(sizeof(Device_Resume_Params_Data) == 8,
              "Bad sizeof(Device_Resume_Params_Data)");
class  Device_GetPhotoState_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_GetPhotoState_Params_Data));
      new (data()) Device_GetPhotoState_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_GetPhotoState_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_GetPhotoState_Params_Data>(index_);
    }
    Device_GetPhotoState_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  Device_GetPhotoState_Params_Data();
  ~Device_GetPhotoState_Params_Data() = delete;
};
static_assert(sizeof(Device_GetPhotoState_Params_Data) == 8,
              "Bad sizeof(Device_GetPhotoState_Params_Data)");
class  Device_GetPhotoState_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_GetPhotoState_ResponseParams_Data));
      new (data()) Device_GetPhotoState_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_GetPhotoState_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_GetPhotoState_ResponseParams_Data>(index_);
    }
    Device_GetPhotoState_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PhotoState_Data> capabilities;

 private:
  Device_GetPhotoState_ResponseParams_Data();
  ~Device_GetPhotoState_ResponseParams_Data() = delete;
};
static_assert(sizeof(Device_GetPhotoState_ResponseParams_Data) == 16,
              "Bad sizeof(Device_GetPhotoState_ResponseParams_Data)");
class  Device_SetPhotoOptions_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_SetPhotoOptions_Params_Data));
      new (data()) Device_SetPhotoOptions_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_SetPhotoOptions_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_SetPhotoOptions_Params_Data>(index_);
    }
    Device_SetPhotoOptions_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PhotoSettings_Data> settings;

 private:
  Device_SetPhotoOptions_Params_Data();
  ~Device_SetPhotoOptions_Params_Data() = delete;
};
static_assert(sizeof(Device_SetPhotoOptions_Params_Data) == 16,
              "Bad sizeof(Device_SetPhotoOptions_Params_Data)");
class  Device_SetPhotoOptions_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_SetPhotoOptions_ResponseParams_Data));
      new (data()) Device_SetPhotoOptions_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_SetPhotoOptions_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_SetPhotoOptions_ResponseParams_Data>(index_);
    }
    Device_SetPhotoOptions_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  Device_SetPhotoOptions_ResponseParams_Data();
  ~Device_SetPhotoOptions_ResponseParams_Data() = delete;
};
static_assert(sizeof(Device_SetPhotoOptions_ResponseParams_Data) == 16,
              "Bad sizeof(Device_SetPhotoOptions_ResponseParams_Data)");
class  Device_TakePhoto_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_TakePhoto_Params_Data));
      new (data()) Device_TakePhoto_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_TakePhoto_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_TakePhoto_Params_Data>(index_);
    }
    Device_TakePhoto_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  Device_TakePhoto_Params_Data();
  ~Device_TakePhoto_Params_Data() = delete;
};
static_assert(sizeof(Device_TakePhoto_Params_Data) == 8,
              "Bad sizeof(Device_TakePhoto_Params_Data)");
class  Device_TakePhoto_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Device_TakePhoto_ResponseParams_Data));
      new (data()) Device_TakePhoto_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Device_TakePhoto_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Device_TakePhoto_ResponseParams_Data>(index_);
    }
    Device_TakePhoto_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::Blob_Data> blob;

 private:
  Device_TakePhoto_ResponseParams_Data();
  ~Device_TakePhoto_ResponseParams_Data() = delete;
};
static_assert(sizeof(Device_TakePhoto_ResponseParams_Data) == 16,
              "Bad sizeof(Device_TakePhoto_ResponseParams_Data)");

}  // namespace internal


class Device_Start_ParamsDataView {
 public:
  Device_Start_ParamsDataView() {}

  Device_Start_ParamsDataView(
      internal::Device_Start_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRequestedSettingsDataView(
      ::media::mojom::VideoCaptureParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestedSettings(UserType* output) {
    
    auto* pointer = data_->requested_settings.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureParamsDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameHandlerInterfaceBase>>(
            &data_->handler, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Device_Start_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Device_MaybeSuspend_ParamsDataView {
 public:
  Device_MaybeSuspend_ParamsDataView() {}

  Device_MaybeSuspend_ParamsDataView(
      internal::Device_MaybeSuspend_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_MaybeSuspend_Params_Data* data_ = nullptr;
};



class Device_Resume_ParamsDataView {
 public:
  Device_Resume_ParamsDataView() {}

  Device_Resume_ParamsDataView(
      internal::Device_Resume_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_Resume_Params_Data* data_ = nullptr;
};



class Device_GetPhotoState_ParamsDataView {
 public:
  Device_GetPhotoState_ParamsDataView() {}

  Device_GetPhotoState_ParamsDataView(
      internal::Device_GetPhotoState_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_GetPhotoState_Params_Data* data_ = nullptr;
};



class Device_GetPhotoState_ResponseParamsDataView {
 public:
  Device_GetPhotoState_ResponseParamsDataView() {}

  Device_GetPhotoState_ResponseParamsDataView(
      internal::Device_GetPhotoState_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCapabilitiesDataView(
      ::media::mojom::PhotoStateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCapabilities(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::PhotoStateDataView, UserType>(),
    "Attempting to read the optional `capabilities` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCapabilities` instead "
    "of `ReadCapabilities if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->capabilities.Get();
    return mojo::internal::Deserialize<::media::mojom::PhotoStateDataView>(
        pointer, output, context_);
  }
 private:
  internal::Device_GetPhotoState_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Device_SetPhotoOptions_ParamsDataView {
 public:
  Device_SetPhotoOptions_ParamsDataView() {}

  Device_SetPhotoOptions_ParamsDataView(
      internal::Device_SetPhotoOptions_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSettingsDataView(
      ::media::mojom::PhotoSettingsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<::media::mojom::PhotoSettingsDataView>(
        pointer, output, context_);
  }
 private:
  internal::Device_SetPhotoOptions_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Device_SetPhotoOptions_ResponseParamsDataView {
 public:
  Device_SetPhotoOptions_ResponseParamsDataView() {}

  Device_SetPhotoOptions_ResponseParamsDataView(
      internal::Device_SetPhotoOptions_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Device_SetPhotoOptions_ResponseParams_Data* data_ = nullptr;
};



class Device_TakePhoto_ParamsDataView {
 public:
  Device_TakePhoto_ParamsDataView() {}

  Device_TakePhoto_ParamsDataView(
      internal::Device_TakePhoto_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Device_TakePhoto_Params_Data* data_ = nullptr;
};



class Device_TakePhoto_ResponseParamsDataView {
 public:
  Device_TakePhoto_ResponseParamsDataView() {}

  Device_TakePhoto_ResponseParamsDataView(
      internal::Device_TakePhoto_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBlobDataView(
      ::media::mojom::BlobDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::BlobDataView, UserType>(),
    "Attempting to read the optional `blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlob` instead "
    "of `ReadBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blob.Get();
    return mojo::internal::Deserialize<::media::mojom::BlobDataView>(
        pointer, output, context_);
  }
 private:
  internal::Device_TakePhoto_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void Device_Start_ParamsDataView::GetRequestedSettingsDataView(
    ::media::mojom::VideoCaptureParamsDataView* output) {
  auto pointer = data_->requested_settings.Get();
  *output = ::media::mojom::VideoCaptureParamsDataView(pointer, context_);
}








inline void Device_GetPhotoState_ResponseParamsDataView::GetCapabilitiesDataView(
    ::media::mojom::PhotoStateDataView* output) {
  auto pointer = data_->capabilities.Get();
  *output = ::media::mojom::PhotoStateDataView(pointer, context_);
}


inline void Device_SetPhotoOptions_ParamsDataView::GetSettingsDataView(
    ::media::mojom::PhotoSettingsDataView* output) {
  auto pointer = data_->settings.Get();
  *output = ::media::mojom::PhotoSettingsDataView(pointer, context_);
}






inline void Device_TakePhoto_ResponseParamsDataView::GetBlobDataView(
    ::media::mojom::BlobDataView* output) {
  auto pointer = data_->blob.Get();
  *output = ::media::mojom::BlobDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_PARAMS_DATA_H_