// services/tracing/public/mojom/traced_process.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/tracing/public/mojom/traced_process.mojom-shared.h"
#include "services/tracing/public/mojom/traced_process.mojom-forward.h"
#include "services/tracing/public/mojom/perfetto_service.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace tracing {
namespace mojom {

class TracedProcessProxy;

template <typename ImplRefTraits>
class TracedProcessStub;

class TracedProcessRequestValidator;
class TracedProcessResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) TracedProcess
    : public TracedProcessInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = TracedProcessInterfaceBase;
  using Proxy_ = TracedProcessProxy;

  template <typename ImplRefTraits>
  using Stub_ = TracedProcessStub<ImplRefTraits>;

  using RequestValidator_ = TracedProcessRequestValidator;
  using ResponseValidator_ = TracedProcessResponseValidator;
  enum MethodMinVersions : uint32_t {
    kConnectToTracingServiceMinVersion = 0,
  };
  virtual ~TracedProcess() {}


  using ConnectToTracingServiceCallback = base::OnceCallback<void()>;
  
  virtual void ConnectToTracingService(ConnectToTracingRequestPtr request, ConnectToTracingServiceCallback callback) = 0;
};



class COMPONENT_EXPORT(TRACING_MOJOM) TracedProcessProxy
    : public TracedProcess {
 public:
  using InterfaceType = TracedProcess;

  explicit TracedProcessProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ConnectToTracingService(ConnectToTracingRequestPtr request, ConnectToTracingServiceCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracedProcessStubDispatch {
 public:
  static bool Accept(TracedProcess* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TracedProcess* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TracedProcess>>
class TracedProcessStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TracedProcessStub() {}
  ~TracedProcessStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracedProcessStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TracedProcessStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracedProcessRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracedProcessResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(TRACING_MOJOM) ConnectToTracingRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConnectToTracingRequest, T>::value>;
  using DataView = ConnectToTracingRequestDataView;
  using Data_ = internal::ConnectToTracingRequest_Data;

  template <typename... Args>
  static ConnectToTracingRequestPtr New(Args&&... args) {
    return ConnectToTracingRequestPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConnectToTracingRequestPtr From(const U& u) {
    return mojo::TypeConverter<ConnectToTracingRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConnectToTracingRequest>::Convert(*this);
  }


  ConnectToTracingRequest();

  explicit ConnectToTracingRequest(
      ::mojo::PendingRemote<::tracing::mojom::PerfettoService> perfetto_service);

  ~ConnectToTracingRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConnectToTracingRequestPtr>
  ConnectToTracingRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConnectToTracingRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectToTracingRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConnectToTracingRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConnectToTracingRequest_UnserializedMessageContext<
            UserType, ConnectToTracingRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ConnectToTracingRequest::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ConnectToTracingRequest::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConnectToTracingRequest_UnserializedMessageContext<
            UserType, ConnectToTracingRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConnectToTracingRequest::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<::tracing::mojom::PerfettoService> perfetto_service;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ConnectToTracingRequest);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConnectToTracingRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConnectToTracingRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConnectToTracingRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConnectToTracingRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ConnectToTracingRequestPtr ConnectToTracingRequest::Clone() const {
  return New(
      mojo::Clone(perfetto_service)
  );
}

template <typename T, ConnectToTracingRequest::EnableIfSame<T>*>
bool ConnectToTracingRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->perfetto_service, other_struct.perfetto_service))
    return false;
  return true;
}

template <typename T, ConnectToTracingRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.perfetto_service, rhs.perfetto_service))
    return true;
  if (std::less<>{}(rhs.perfetto_service, lhs.perfetto_service))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace tracing

namespace mojo {


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::ConnectToTracingRequest::DataView,
                                         ::tracing::mojom::ConnectToTracingRequestPtr> {
  static bool IsNull(const ::tracing::mojom::ConnectToTracingRequestPtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::ConnectToTracingRequestPtr* output) { output->reset(); }

  static  decltype(::tracing::mojom::ConnectToTracingRequest::perfetto_service)& perfetto_service(
       ::tracing::mojom::ConnectToTracingRequestPtr& input) {
    return input->perfetto_service;
  }

  static bool Read(::tracing::mojom::ConnectToTracingRequest::DataView input, ::tracing::mojom::ConnectToTracingRequestPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_H_