// services/shape_detection/public/mojom/shape_detection_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_SHAPE_DETECTION_SERVICE_MOJOM_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_SHAPE_DETECTION_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/shape_detection/public/mojom/shape_detection_service.mojom-shared.h"
#include "services/shape_detection/public/mojom/shape_detection_service.mojom-forward.h"
#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom.h"
#include "services/shape_detection/public/mojom/facedetection_provider.mojom.h"
#include "services/shape_detection/public/mojom/textdetection.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace shape_detection {
namespace mojom {

class ShapeDetectionServiceProxy;

template <typename ImplRefTraits>
class ShapeDetectionServiceStub;

class ShapeDetectionServiceRequestValidator;


class  ShapeDetectionService
    : public ShapeDetectionServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ShapeDetectionServiceInterfaceBase;
  using Proxy_ = ShapeDetectionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ShapeDetectionServiceStub<ImplRefTraits>;

  using RequestValidator_ = ShapeDetectionServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindBarcodeDetectionProviderMinVersion = 0,
    kBindFaceDetectionProviderMinVersion = 0,
    kBindTextDetectionMinVersion = 0,
  };
  virtual ~ShapeDetectionService() {}

  
  virtual void BindBarcodeDetectionProvider(::mojo::PendingReceiver<::shape_detection::mojom::BarcodeDetectionProvider> receiver) = 0;

  
  virtual void BindFaceDetectionProvider(::mojo::PendingReceiver<::shape_detection::mojom::FaceDetectionProvider> receiver) = 0;

  
  virtual void BindTextDetection(::mojo::PendingReceiver<::shape_detection::mojom::TextDetection> receiver) = 0;
};



class  ShapeDetectionServiceProxy
    : public ShapeDetectionService {
 public:
  using InterfaceType = ShapeDetectionService;

  explicit ShapeDetectionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindBarcodeDetectionProvider(::mojo::PendingReceiver<::shape_detection::mojom::BarcodeDetectionProvider> receiver) final;
  
  void BindFaceDetectionProvider(::mojo::PendingReceiver<::shape_detection::mojom::FaceDetectionProvider> receiver) final;
  
  void BindTextDetection(::mojo::PendingReceiver<::shape_detection::mojom::TextDetection> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ShapeDetectionServiceStubDispatch {
 public:
  static bool Accept(ShapeDetectionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ShapeDetectionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ShapeDetectionService>>
class ShapeDetectionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ShapeDetectionServiceStub() {}
  ~ShapeDetectionServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ShapeDetectionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ShapeDetectionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ShapeDetectionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace shape_detection

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_SHAPE_DETECTION_SERVICE_MOJOM_H_