// services/network/public/mojom/websocket.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/websocket.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/websocket.mojom-params-data.h"
#include "services/network/public/mojom/websocket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/websocket.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
HttpHeader::HttpHeader()
    : name(),
      value() {}

HttpHeader::HttpHeader(
    const WTF::String& name_in,
    const WTF::String& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

HttpHeader::~HttpHeader() = default;
size_t HttpHeader::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void HttpHeader::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", this->name.Utf8());
  value->SetString("value", this->value.Utf8());
}

bool HttpHeader::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebSocketHandshakeRequest::WebSocketHandshakeRequest()
    : url(),
      headers(),
      headers_text() {}

WebSocketHandshakeRequest::WebSocketHandshakeRequest(
    const ::blink::KURL& url_in,
    WTF::Vector<HttpHeaderPtr> headers_in,
    const WTF::String& headers_text_in)
    : url(std::move(url_in)),
      headers(std::move(headers_in)),
      headers_text(std::move(headers_text_in)) {}

WebSocketHandshakeRequest::~WebSocketHandshakeRequest() = default;

void WebSocketHandshakeRequest::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::blink::KURL&>"));
  value->BeginArray("headers");
  for (const auto& item0 : this->headers) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetString("headers_text", this->headers_text.Utf8());
}

bool WebSocketHandshakeRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebSocketHandshakeResponse::WebSocketHandshakeResponse()
    : url(),
      http_version(),
      status_code(),
      status_text(),
      remote_endpoint(),
      headers(),
      headers_text(),
      selected_protocol(),
      extensions() {}

WebSocketHandshakeResponse::WebSocketHandshakeResponse(
    const ::blink::KURL& url_in,
    ::network::mojom::blink::HttpVersionPtr http_version_in,
    int32_t status_code_in,
    const WTF::String& status_text_in,
    const ::net::IPEndPoint& remote_endpoint_in,
    WTF::Vector<HttpHeaderPtr> headers_in,
    const WTF::String& headers_text_in,
    const WTF::String& selected_protocol_in,
    const WTF::String& extensions_in)
    : url(std::move(url_in)),
      http_version(std::move(http_version_in)),
      status_code(std::move(status_code_in)),
      status_text(std::move(status_text_in)),
      remote_endpoint(std::move(remote_endpoint_in)),
      headers(std::move(headers_in)),
      headers_text(std::move(headers_text_in)),
      selected_protocol(std::move(selected_protocol_in)),
      extensions(std::move(extensions_in)) {}

WebSocketHandshakeResponse::~WebSocketHandshakeResponse() = default;

void WebSocketHandshakeResponse::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::blink::KURL&>"));
  if (this->http_version.is_null()) {
    value->SetString("http_version", "nullptr");
  } else {
    value->BeginDictionary("http_version");
    this->http_version->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("status_code", this->status_code);
  value->SetString("status_text", this->status_text.Utf8());
  value->SetString("remote_endpoint", base::trace_event::ValueToString(this->remote_endpoint, "<value of type const ::net::IPEndPoint&>"));
  value->BeginArray("headers");
  for (const auto& item0 : this->headers) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetString("headers_text", this->headers_text.Utf8());
  value->SetString("selected_protocol", this->selected_protocol.Utf8());
  value->SetString("extensions", this->extensions.Utf8());
}

bool WebSocketHandshakeResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AuthenticationHandler::Name_[] = "network.mojom.AuthenticationHandler";

class AuthenticationHandler_OnAuthRequired_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AuthenticationHandler_OnAuthRequired_ForwardToCallback(
      AuthenticationHandler::OnAuthRequiredCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AuthenticationHandler::OnAuthRequiredCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AuthenticationHandler_OnAuthRequired_ForwardToCallback);
};

AuthenticationHandlerProxy::AuthenticationHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuthenticationHandlerProxy::OnAuthRequired(
    ::network::mojom::blink::AuthChallengeInfoPtr in_info, ::network::mojom::blink::HttpResponseHeadersPtr in_headers, const ::net::IPEndPoint& in_remote_endpoint, OnAuthRequiredCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::AuthenticationHandler::OnAuthRequired", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("info", base::trace_event::ValueToString(in_info, "<value of type ::network::mojom::blink::AuthChallengeInfoPtr>"));
      raw_value->SetString("headers", base::trace_event::ValueToString(in_headers, "<value of type ::network::mojom::blink::HttpResponseHeadersPtr>"));
      raw_value->SetString("remote_endpoint", base::trace_event::ValueToString(in_remote_endpoint, "<value of type const ::net::IPEndPoint&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticationHandler_OnAuthRequired_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::AuthenticationHandler_OnAuthRequired_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->info)::BaseType::BufferWriter
      info_writer;
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
      in_info, buffer, &info_writer, &serialization_context);
  params->info.Set(
      info_writer.is_null() ? nullptr : info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in AuthenticationHandler.OnAuthRequired request");
  typename decltype(params->headers)::BaseType::BufferWriter
      headers_writer;
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_headers, buffer, &headers_writer, &serialization_context);
  params->headers.Set(
      headers_writer.is_null() ? nullptr : headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in AuthenticationHandler.OnAuthRequired request");
  typename decltype(params->remote_endpoint)::BaseType::BufferWriter
      remote_endpoint_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_endpoint, buffer, &remote_endpoint_writer, &serialization_context);
  params->remote_endpoint.Set(
      remote_endpoint_writer.is_null() ? nullptr : remote_endpoint_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_endpoint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_endpoint in AuthenticationHandler.OnAuthRequired request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuthenticationHandler::Name_);
  message.set_method_name("OnAuthRequired");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AuthenticationHandler_OnAuthRequired_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class AuthenticationHandler_OnAuthRequired_ProxyToResponder {
 public:
  static AuthenticationHandler::OnAuthRequiredCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AuthenticationHandler_OnAuthRequired_ProxyToResponder> proxy(
        new AuthenticationHandler_OnAuthRequired_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AuthenticationHandler_OnAuthRequired_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AuthenticationHandler_OnAuthRequired_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AuthenticationHandler_OnAuthRequired_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AuthenticationHandler::OnAuthRequiredCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::blink::AuthCredentialsPtr in_credentials);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AuthenticationHandler_OnAuthRequired_ProxyToResponder);
};

bool AuthenticationHandler_OnAuthRequired_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::AuthenticationHandler::OnAuthRequiredCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::AuthenticationHandler_OnAuthRequired_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AuthenticationHandler_OnAuthRequired_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::network::mojom::blink::AuthCredentialsPtr p_credentials{};
  AuthenticationHandler_OnAuthRequired_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCredentials(&p_credentials))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AuthenticationHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_credentials));
  return true;
}

void AuthenticationHandler_OnAuthRequired_ProxyToResponder::Run(
    ::network::mojom::blink::AuthCredentialsPtr in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::AuthenticationHandler::OnAuthRequiredCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("credentials", base::trace_event::ValueToString(in_credentials, "<value of type ::network::mojom::blink::AuthCredentialsPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticationHandler_OnAuthRequired_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::AuthenticationHandler_OnAuthRequired_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->credentials)::BaseType::BufferWriter
      credentials_writer;
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
      in_credentials, buffer, &credentials_writer, &serialization_context);
  params->credentials.Set(
      credentials_writer.is_null() ? nullptr : credentials_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::AuthenticationHandler::OnAuthRequiredCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuthenticationHandler::Name_);
  message.set_method_name("OnAuthRequired");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AuthenticationHandlerStubDispatch::Accept(
    AuthenticationHandler* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAuthenticationHandler_OnAuthRequired_Name: {
      break;
    }
  }
  return false;
}

// static
bool AuthenticationHandlerStubDispatch::AcceptWithResponder(
    AuthenticationHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAuthenticationHandler_OnAuthRequired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::AuthenticationHandler::OnAuthRequired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::AuthenticationHandler::OnAuthRequired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AuthenticationHandler_OnAuthRequired_Params_Data* params =
          reinterpret_cast<
              internal::AuthenticationHandler_OnAuthRequired_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::AuthChallengeInfoPtr p_info{};
      ::network::mojom::blink::HttpResponseHeadersPtr p_headers{};
      ::net::IPEndPoint p_remote_endpoint{};
      AuthenticationHandler_OnAuthRequired_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRemoteEndpoint(&p_remote_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuthenticationHandler::Name_, 0, false);
        return false;
      }
      AuthenticationHandler::OnAuthRequiredCallback callback =
          AuthenticationHandler_OnAuthRequired_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthRequired(
std::move(p_info), 
std::move(p_headers), 
std::move(p_remote_endpoint), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAuthenticationHandlerValidationInfo[] = {
    {internal::kAuthenticationHandler_OnAuthRequired_Name,
     {&internal::AuthenticationHandler_OnAuthRequired_Params_Data::Validate,
      &internal::AuthenticationHandler_OnAuthRequired_ResponseParams_Data::Validate}},
};

bool AuthenticationHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::AuthenticationHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAuthenticationHandlerValidationInfo);
}

bool AuthenticationHandlerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::AuthenticationHandler::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kAuthenticationHandlerValidationInfo);

}
const char WebSocketHandshakeClient::Name_[] = "network.mojom.WebSocketHandshakeClient";

WebSocketHandshakeClientProxy::WebSocketHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketHandshakeClientProxy::OnOpeningHandshakeStarted(
    WebSocketHandshakeRequestPtr in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_request.is_null()) {
        raw_value->SetString("request", "nullptr");
      } else {
        raw_value->BeginDictionary("request");
        in_request->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::network::mojom::WebSocketHandshakeRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in WebSocketHandshakeClient.OnOpeningHandshakeStarted request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnOpeningHandshakeStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketHandshakeClientProxy::OnConnectionEstablished(
    ::mojo::PendingRemote<WebSocket> in_socket, ::mojo::PendingReceiver<WebSocketClient> in_client_receiver, WebSocketHandshakeResponsePtr in_response, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketHandshakeClient::OnConnectionEstablished", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("socket", in_socket.is_valid());
      raw_value->SetBoolean("client_receiver", in_client_receiver.is_valid());
      if (in_response.is_null()) {
        raw_value->SetString("response", "nullptr");
      } else {
        raw_value->BeginDictionary("response");
        in_response->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("readable", in_readable.is_valid());
      raw_value->SetBoolean("writable", in_writable.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketInterfaceBase>>(
      in_socket, &params->socket, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::WebSocketClientInterfaceBase>>(
      in_client_receiver, &params->client_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client_receiver in WebSocketHandshakeClient.OnConnectionEstablished request");
  typename decltype(params->response)::BaseType::BufferWriter
      response_writer;
  mojo::internal::Serialize<::network::mojom::WebSocketHandshakeResponseDataView>(
      in_response, buffer, &response_writer, &serialization_context);
  params->response.Set(
      response_writer.is_null() ? nullptr : response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_writable, &params->writable, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->writable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid writable in WebSocketHandshakeClient.OnConnectionEstablished request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnConnectionEstablished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketHandshakeClientStubDispatch::Accept(
    WebSocketHandshakeClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocketHandshakeRequestPtr p_request{};
      WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOpeningHandshakeStarted(
std::move(p_request));
      return true;
    }
    case internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketHandshakeClient::OnConnectionEstablished",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketHandshakeClient::OnConnectionEstablished");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<WebSocket> p_socket{};
      ::mojo::PendingReceiver<WebSocketClient> p_client_receiver{};
      WebSocketHandshakeResponsePtr p_response{};
      ::mojo::ScopedDataPipeConsumerHandle p_readable{};
      ::mojo::ScopedDataPipeProducerHandle p_writable{};
      WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_client_receiver =
            input_data_view.TakeClientReceiver<decltype(p_client_receiver)>();
      }
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (success)
        p_readable = input_data_view.TakeReadable();
      if (success)
        p_writable = input_data_view.TakeWritable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionEstablished(
std::move(p_socket), 
std::move(p_client_receiver), 
std::move(p_response), 
std::move(p_readable), 
std::move(p_writable));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketHandshakeClientStubDispatch::AcceptWithResponder(
    WebSocketHandshakeClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name: {
      break;
    }
    case internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketHandshakeClientValidationInfo[] = {
    {internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name,
     {&internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name,
     {&internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketHandshakeClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocketHandshakeClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebSocketHandshakeClientValidationInfo);
}

const char WebSocketClient::Name_[] = "network.mojom.WebSocketClient";

WebSocketClientProxy::WebSocketClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketClientProxy::OnDataFrame(
    bool in_fin, WebSocketMessageType in_type, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketClient::OnDataFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("fin", in_fin);
      raw_value->SetString("type", base::trace_event::ValueToString(in_type));
      raw_value->SetString("data_length", base::NumberToString(in_data_length));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocketClient_OnDataFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocketClient_OnDataFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->fin = in_fin;
  mojo::internal::Serialize<::network::mojom::WebSocketMessageType>(
      in_type, &params->type);
  params->data_length = in_data_length;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnDataFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketClientProxy::OnDropChannel(
    bool in_was_clean, uint16_t in_code, const WTF::String& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketClient::OnDropChannel", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("was_clean", in_was_clean);
      raw_value->SetInteger("code", in_code);
      raw_value->SetString("reason", in_reason.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocketClient_OnDropChannel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocketClient_OnDropChannel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->was_clean = in_was_clean;
  params->code = in_code;
  typename decltype(params->reason)::BaseType::BufferWriter
      reason_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reason, buffer, &reason_writer, &serialization_context);
  params->reason.Set(
      reason_writer.is_null() ? nullptr : reason_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reason.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reason in WebSocketClient.OnDropChannel request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnDropChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketClientProxy::OnClosingHandshake(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::WebSocketClient::OnClosingHandshake");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocketClient_OnClosingHandshake_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocketClient_OnClosingHandshake_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnClosingHandshake");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketClientStubDispatch::Accept(
    WebSocketClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebSocketClient_OnDataFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketClient::OnDataFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketClient::OnDataFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnDataFrame_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnDataFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_fin{};
      WebSocketMessageType p_type{};
      uint64_t p_data_length{};
      WebSocketClient_OnDataFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_fin = input_data_view.fin();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDataFrame(
std::move(p_fin), 
std::move(p_type), 
std::move(p_data_length));
      return true;
    }
    case internal::kWebSocketClient_OnDropChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketClient::OnDropChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketClient::OnDropChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnDropChannel_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnDropChannel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_was_clean{};
      uint16_t p_code{};
      WTF::String p_reason{};
      WebSocketClient_OnDropChannel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_was_clean = input_data_view.was_clean();
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDropChannel(
std::move(p_was_clean), 
std::move(p_code), 
std::move(p_reason));
      return true;
    }
    case internal::kWebSocketClient_OnClosingHandshake_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketClient::OnClosingHandshake",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketClient::OnClosingHandshake");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnClosingHandshake_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnClosingHandshake_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocketClient_OnClosingHandshake_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClosingHandshake();
      return true;
    }
  }
  return false;
}

// static
bool WebSocketClientStubDispatch::AcceptWithResponder(
    WebSocketClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocketClient_OnDataFrame_Name: {
      break;
    }
    case internal::kWebSocketClient_OnDropChannel_Name: {
      break;
    }
    case internal::kWebSocketClient_OnClosingHandshake_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketClientValidationInfo[] = {
    {internal::kWebSocketClient_OnDataFrame_Name,
     {&internal::WebSocketClient_OnDataFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocketClient_OnDropChannel_Name,
     {&internal::WebSocketClient_OnDropChannel_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocketClient_OnClosingHandshake_Name,
     {&internal::WebSocketClient_OnClosingHandshake_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocketClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebSocketClientValidationInfo);
}

const char WebSocket::Name_[] = "network.mojom.WebSocket";
constexpr uint32_t WebSocket::kInsufficientResources;
constexpr uint32_t WebSocket::kInternalFailure;

WebSocketProxy::WebSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketProxy::SendMessage(
    WebSocketMessageType in_type, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocket::SendMessage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("type", base::trace_event::ValueToString(in_type));
      raw_value->SetString("data_length", base::NumberToString(in_data_length));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocket_SendMessage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocket_SendMessage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::WebSocketMessageType>(
      in_type, &params->type);
  params->data_length = in_data_length;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("SendMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketProxy::StartReceiving(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::WebSocket::StartReceiving");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocket_StartReceiving_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocket_StartReceiving_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("StartReceiving");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketProxy::StartClosingHandshake(
    uint16_t in_code, const WTF::String& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocket::StartClosingHandshake", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("code", in_code);
      raw_value->SetString("reason", in_reason.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocket_StartClosingHandshake_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::WebSocket_StartClosingHandshake_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->code = in_code;
  typename decltype(params->reason)::BaseType::BufferWriter
      reason_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reason, buffer, &reason_writer, &serialization_context);
  params->reason.Set(
      reason_writer.is_null() ? nullptr : reason_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reason.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reason in WebSocket.StartClosingHandshake request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("StartClosingHandshake");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketStubDispatch::Accept(
    WebSocket* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebSocket_SendMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocket::SendMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocket::SendMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocket_SendMessage_Params_Data* params =
          reinterpret_cast<internal::WebSocket_SendMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocketMessageType p_type{};
      uint64_t p_data_length{};
      WebSocket_SendMessage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessage(
std::move(p_type), 
std::move(p_data_length));
      return true;
    }
    case internal::kWebSocket_StartReceiving_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocket::StartReceiving",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocket::StartReceiving");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocket_StartReceiving_Params_Data* params =
          reinterpret_cast<internal::WebSocket_StartReceiving_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocket_StartReceiving_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartReceiving();
      return true;
    }
    case internal::kWebSocket_StartClosingHandshake_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocket::StartClosingHandshake",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocket::StartClosingHandshake");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocket_StartClosingHandshake_Params_Data* params =
          reinterpret_cast<internal::WebSocket_StartClosingHandshake_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint16_t p_code{};
      WTF::String p_reason{};
      WebSocket_StartClosingHandshake_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartClosingHandshake(
std::move(p_code), 
std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketStubDispatch::AcceptWithResponder(
    WebSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocket_SendMessage_Name: {
      break;
    }
    case internal::kWebSocket_StartReceiving_Name: {
      break;
    }
    case internal::kWebSocket_StartClosingHandshake_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketValidationInfo[] = {
    {internal::kWebSocket_SendMessage_Name,
     {&internal::WebSocket_SendMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocket_StartReceiving_Name,
     {&internal::WebSocket_StartReceiving_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocket_StartClosingHandshake_Name,
     {&internal::WebSocket_StartClosingHandshake_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebSocketValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::HttpHeader::DataView, ::network::mojom::blink::HttpHeaderPtr>::Read(
    ::network::mojom::blink::HttpHeader::DataView input,
    ::network::mojom::blink::HttpHeaderPtr* output) {
  bool success = true;
  ::network::mojom::blink::HttpHeaderPtr result(::network::mojom::blink::HttpHeader::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebSocketHandshakeRequest::DataView, ::network::mojom::blink::WebSocketHandshakeRequestPtr>::Read(
    ::network::mojom::blink::WebSocketHandshakeRequest::DataView input,
    ::network::mojom::blink::WebSocketHandshakeRequestPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebSocketHandshakeRequestPtr result(::network::mojom::blink::WebSocketHandshakeRequest::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadHeadersText(&result->headers_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebSocketHandshakeResponse::DataView, ::network::mojom::blink::WebSocketHandshakeResponsePtr>::Read(
    ::network::mojom::blink::WebSocketHandshakeResponse::DataView input,
    ::network::mojom::blink::WebSocketHandshakeResponsePtr* output) {
  bool success = true;
  ::network::mojom::blink::WebSocketHandshakeResponsePtr result(::network::mojom::blink::WebSocketHandshakeResponse::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHttpVersion(&result->http_version))
        success = false;
      if (success)
        result->status_code = input.status_code();
      if (success && !input.ReadStatusText(&result->status_text))
        success = false;
      if (success && !input.ReadRemoteEndpoint(&result->remote_endpoint))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadHeadersText(&result->headers_text))
        success = false;
      if (success && !input.ReadSelectedProtocol(&result->selected_protocol))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif