// services/network/public/mojom/isolation_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/isolation_info.mojom-shared-internal.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"







namespace network {
namespace mojom {
class IsolationInfoDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::IsolationInfoDataView> {
  using Data = ::network::mojom::internal::IsolationInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


enum class IsolationInfoRedirectMode : int32_t {
  
  kUpdateTopFrame = 0,
  
  kUpdateFrameOnly = 1,
  
  kUpdateNothing = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, IsolationInfoRedirectMode value);
inline bool IsKnownEnumValue(IsolationInfoRedirectMode value) {
  return internal::IsolationInfoRedirectMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class IsolationInfoDataView {
 public:
  IsolationInfoDataView() {}

  IsolationInfoDataView(
      internal::IsolationInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirectMode(UserType* output) const {
    auto data_value = data_->redirect_mode;
    return mojo::internal::Deserialize<::network::mojom::IsolationInfoRedirectMode>(
        data_value, output);
  }

  IsolationInfoRedirectMode redirect_mode() const {
    return static_cast<IsolationInfoRedirectMode>(data_->redirect_mode);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTopFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `top_frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopFrameOrigin` instead "
    "of `ReadTopFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameOrigin` instead "
    "of `ReadFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  bool opaque_and_non_transient() const {
    return data_->opaque_and_non_transient;
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, context_);
  }
 private:
  internal::IsolationInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

template <>
struct hash<::network::mojom::IsolationInfoRedirectMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::IsolationInfoRedirectMode> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::network::mojom::IsolationInfoRedirectMode, ::network::mojom::IsolationInfoRedirectMode> {
  static ::network::mojom::IsolationInfoRedirectMode ToMojom(::network::mojom::IsolationInfoRedirectMode input) { return input; }
  static bool FromMojom(::network::mojom::IsolationInfoRedirectMode input, ::network::mojom::IsolationInfoRedirectMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IsolationInfoRedirectMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::IsolationInfoRedirectMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::IsolationInfoRedirectMode>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IsolationInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::IsolationInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::IsolationInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::IsolationInfoRedirectMode>(
        Traits::redirect_mode(input), &(*output)->redirect_mode);
    decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
    typename decltype((*output)->top_frame_origin)::BaseType::BufferWriter
        top_frame_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_top_frame_origin, buffer, &top_frame_origin_writer, context);
    (*output)->top_frame_origin.Set(
        top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
    decltype(Traits::frame_origin(input)) in_frame_origin = Traits::frame_origin(input);
    typename decltype((*output)->frame_origin)::BaseType::BufferWriter
        frame_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_frame_origin, buffer, &frame_origin_writer, context);
    (*output)->frame_origin.Set(
        frame_origin_writer.is_null() ? nullptr : frame_origin_writer.data());
    (*output)->opaque_and_non_transient = Traits::opaque_and_non_transient(input);
    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    typename decltype((*output)->site_for_cookies)::BaseType::BufferWriter
        site_for_cookies_writer;
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
        in_site_for_cookies, buffer, &site_for_cookies_writer, context);
    (*output)->site_for_cookies.Set(
        site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->site_for_cookies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_for_cookies in IsolationInfo struct");
  }

  static bool Deserialize(::network::mojom::internal::IsolationInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::IsolationInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void IsolationInfoDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void IsolationInfoDataView::GetFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void IsolationInfoDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SHARED_H_