// services/network/public/mojom/ct_log_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"
#include "services/network/public/mojom/ct_log_info.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {
namespace blink {








class BLINK_PLATFORM_EXPORT CTLogInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CTLogInfo, T>::value>;
  using DataView = CTLogInfoDataView;
  using Data_ = internal::CTLogInfo_Data;

  template <typename... Args>
  static CTLogInfoPtr New(Args&&... args) {
    return CTLogInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CTLogInfoPtr From(const U& u) {
    return mojo::TypeConverter<CTLogInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CTLogInfo>::Convert(*this);
  }


  CTLogInfo();

  CTLogInfo(
      const WTF::String& public_key,
      const WTF::String& name,
      bool operated_by_google,
      base::Optional<::base::TimeDelta> disqualified_at);

  ~CTLogInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CTLogInfoPtr>
  CTLogInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CTLogInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CTLogInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CTLogInfo_UnserializedMessageContext<
            UserType, CTLogInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CTLogInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return CTLogInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CTLogInfo_UnserializedMessageContext<
            UserType, CTLogInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CTLogInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String public_key;
  
  WTF::String name;
  
  bool operated_by_google;
  
  base::Optional<::base::TimeDelta> disqualified_at;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CTLogInfoPtr CTLogInfo::Clone() const {
  return New(
      mojo::Clone(public_key),
      mojo::Clone(name),
      mojo::Clone(operated_by_google),
      mojo::Clone(disqualified_at)
  );
}

template <typename T, CTLogInfo::EnableIfSame<T>*>
bool CTLogInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->public_key, other_struct.public_key))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->operated_by_google, other_struct.operated_by_google))
    return false;
  if (!mojo::Equals(this->disqualified_at, other_struct.disqualified_at))
    return false;
  return true;
}

template <typename T, CTLogInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.public_key, rhs.public_key))
    return true;
  if (std::less<>{}(rhs.public_key, lhs.public_key))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.operated_by_google, rhs.operated_by_google))
    return true;
  if (std::less<>{}(rhs.operated_by_google, lhs.operated_by_google))
    return false;
  if (std::less<>{}(lhs.disqualified_at, rhs.disqualified_at))
    return true;
  if (std::less<>{}(rhs.disqualified_at, lhs.disqualified_at))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CTLogInfo::DataView,
                                         ::network::mojom::blink::CTLogInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::CTLogInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CTLogInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::CTLogInfo::public_key)& public_key(
      const ::network::mojom::blink::CTLogInfoPtr& input) {
    return input->public_key;
  }

  static const decltype(::network::mojom::blink::CTLogInfo::name)& name(
      const ::network::mojom::blink::CTLogInfoPtr& input) {
    return input->name;
  }

  static decltype(::network::mojom::blink::CTLogInfo::operated_by_google) operated_by_google(
      const ::network::mojom::blink::CTLogInfoPtr& input) {
    return input->operated_by_google;
  }

  static const decltype(::network::mojom::blink::CTLogInfo::disqualified_at)& disqualified_at(
      const ::network::mojom::blink::CTLogInfoPtr& input) {
    return input->disqualified_at;
  }

  static bool Read(::network::mojom::blink::CTLogInfo::DataView input, ::network::mojom::blink::CTLogInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_BLINK_H_