// services/network/public/mojom/content_security_policy.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/source_location.mojom.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include <string>
#include <vector>







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {





class  ContentSecurityPolicyHeader {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSecurityPolicyHeader, T>::value>;
  using DataView = ContentSecurityPolicyHeaderDataView;
  using Data_ = internal::ContentSecurityPolicyHeader_Data;

  template <typename... Args>
  static ContentSecurityPolicyHeaderPtr New(Args&&... args) {
    return ContentSecurityPolicyHeaderPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSecurityPolicyHeaderPtr From(const U& u) {
    return mojo::TypeConverter<ContentSecurityPolicyHeaderPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSecurityPolicyHeader>::Convert(*this);
  }


  ContentSecurityPolicyHeader();

  ContentSecurityPolicyHeader(
      const std::string& header_value,
      ContentSecurityPolicyType type,
      ContentSecurityPolicySource source);

  ~ContentSecurityPolicyHeader();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSecurityPolicyHeaderPtr>
  ContentSecurityPolicyHeaderPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicyHeader::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSecurityPolicyHeader::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSecurityPolicyHeader_UnserializedMessageContext<
            UserType, ContentSecurityPolicyHeader::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyHeader::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ContentSecurityPolicyHeader::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSecurityPolicyHeader_UnserializedMessageContext<
            UserType, ContentSecurityPolicyHeader::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyHeader::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string header_value;
  
  ContentSecurityPolicyType type;
  
  ContentSecurityPolicySource source;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CSPHashSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPHashSource, T>::value>;
  using DataView = CSPHashSourceDataView;
  using Data_ = internal::CSPHashSource_Data;

  template <typename... Args>
  static CSPHashSourcePtr New(Args&&... args) {
    return CSPHashSourcePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPHashSourcePtr From(const U& u) {
    return mojo::TypeConverter<CSPHashSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPHashSource>::Convert(*this);
  }


  CSPHashSource();

  CSPHashSource(
      CSPHashAlgorithm algorithm,
      const std::string& value);

  ~CSPHashSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPHashSourcePtr>
  CSPHashSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPHashSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPHashSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPHashSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPHashSource_UnserializedMessageContext<
            UserType, CSPHashSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CSPHashSource::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CSPHashSource::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPHashSource_UnserializedMessageContext<
            UserType, CSPHashSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPHashSource::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  CSPHashAlgorithm algorithm;
  
  std::string value;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPHashSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPHashSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPHashSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPHashSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  AllowCSPFromHeaderValue {
 public:
  using DataView = AllowCSPFromHeaderValueDataView;
  using Data_ = internal::AllowCSPFromHeaderValue_Data;
  using Tag = Data_::AllowCSPFromHeaderValue_Tag;

  static AllowCSPFromHeaderValuePtr New() {
    return AllowCSPFromHeaderValuePtr(base::in_place);
  }
  // Construct an instance holding |allow_star|.
  static AllowCSPFromHeaderValuePtr
  NewAllowStar(
      bool allow_star) {
    auto result = AllowCSPFromHeaderValuePtr(base::in_place);
    result->set_allow_star(std::move(allow_star));
    return result;
  }
  // Construct an instance holding |origin|.
  static AllowCSPFromHeaderValuePtr
  NewOrigin(
      const ::url::Origin& origin) {
    auto result = AllowCSPFromHeaderValuePtr(base::in_place);
    result->set_origin(std::move(origin));
    return result;
  }
  // Construct an instance holding |error_message|.
  static AllowCSPFromHeaderValuePtr
  NewErrorMessage(
      const std::string& error_message) {
    auto result = AllowCSPFromHeaderValuePtr(base::in_place);
    result->set_error_message(std::move(error_message));
    return result;
  }

  template <typename U>
  static AllowCSPFromHeaderValuePtr From(const U& u) {
    return mojo::TypeConverter<AllowCSPFromHeaderValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AllowCSPFromHeaderValue>::Convert(*this);
  }

  AllowCSPFromHeaderValue();
  ~AllowCSPFromHeaderValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AllowCSPFromHeaderValuePtr>
  AllowCSPFromHeaderValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AllowCSPFromHeaderValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_allow_star() const { return tag_ == Tag::ALLOW_STAR; }

  
  bool get_allow_star() const {
    DCHECK(tag_ == Tag::ALLOW_STAR);
    return data_.allow_star;
  }

  
  void set_allow_star(
      bool allow_star);
  
  bool is_origin() const { return tag_ == Tag::ORIGIN; }

  
  ::url::Origin& get_origin() const {
    DCHECK(tag_ == Tag::ORIGIN);
    return *(data_.origin);
  }

  
  void set_origin(
      const ::url::Origin& origin);
  
  bool is_error_message() const { return tag_ == Tag::ERROR_MESSAGE; }

  
  std::string& get_error_message() const {
    DCHECK(tag_ == Tag::ERROR_MESSAGE);
    return *(data_.error_message);
  }

  
  void set_error_message(
      const std::string& error_message);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AllowCSPFromHeaderValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AllowCSPFromHeaderValue::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    bool allow_star;
    ::url::Origin* origin;
    std::string* error_message;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  CSPSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPSource, T>::value>;
  using DataView = CSPSourceDataView;
  using Data_ = internal::CSPSource_Data;

  template <typename... Args>
  static CSPSourcePtr New(Args&&... args) {
    return CSPSourcePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPSourcePtr From(const U& u) {
    return mojo::TypeConverter<CSPSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPSource>::Convert(*this);
  }


  CSPSource();

  CSPSource(
      const std::string& scheme,
      const std::string& host,
      int32_t port,
      const std::string& path,
      bool is_host_wildcard,
      bool is_port_wildcard);

  ~CSPSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPSourcePtr>
  CSPSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPSource_UnserializedMessageContext<
            UserType, CSPSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CSPSource::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CSPSource::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPSource_UnserializedMessageContext<
            UserType, CSPSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPSource::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string scheme;
  
  std::string host;
  
  int32_t port;
  
  std::string path;
  
  bool is_host_wildcard;
  
  bool is_port_wildcard;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CSPSourceList {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPSourceList, T>::value>;
  using DataView = CSPSourceListDataView;
  using Data_ = internal::CSPSourceList_Data;

  template <typename... Args>
  static CSPSourceListPtr New(Args&&... args) {
    return CSPSourceListPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPSourceListPtr From(const U& u) {
    return mojo::TypeConverter<CSPSourceListPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPSourceList>::Convert(*this);
  }


  CSPSourceList();

  CSPSourceList(
      std::vector<CSPSourcePtr> sources,
      std::vector<std::string> nonces,
      std::vector<CSPHashSourcePtr> hashes,
      bool allow_self,
      bool allow_star,
      bool allow_response_redirects,
      bool allow_inline,
      bool allow_eval,
      bool allow_wasm_eval,
      bool allow_dynamic,
      bool allow_unsafe_hashes,
      bool report_sample);

  ~CSPSourceList();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPSourceListPtr>
  CSPSourceListPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPSourceList::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPSourceList::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPSourceList_UnserializedMessageContext<
            UserType, CSPSourceList::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CSPSourceList::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CSPSourceList::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPSourceList_UnserializedMessageContext<
            UserType, CSPSourceList::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPSourceList::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<CSPSourcePtr> sources;
  
  std::vector<std::string> nonces;
  
  std::vector<CSPHashSourcePtr> hashes;
  
  bool allow_self;
  
  bool allow_star;
  
  bool allow_response_redirects;
  
  bool allow_inline;
  
  bool allow_eval;
  
  bool allow_wasm_eval;
  
  bool allow_dynamic;
  
  bool allow_unsafe_hashes;
  
  bool report_sample;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CSPSourceList);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ContentSecurityPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSecurityPolicy, T>::value>;
  using DataView = ContentSecurityPolicyDataView;
  using Data_ = internal::ContentSecurityPolicy_Data;

  template <typename... Args>
  static ContentSecurityPolicyPtr New(Args&&... args) {
    return ContentSecurityPolicyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSecurityPolicyPtr From(const U& u) {
    return mojo::TypeConverter<ContentSecurityPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSecurityPolicy>::Convert(*this);
  }


  ContentSecurityPolicy();

  ContentSecurityPolicy(
      base::flat_map<CSPDirectiveName, CSPSourceListPtr> directives,
      bool upgrade_insecure_requests,
      bool treat_as_public_address,
      ::network::mojom::WebSandboxFlags sandbox,
      ContentSecurityPolicyHeaderPtr header,
      bool use_reporting_api,
      std::vector<std::string> report_endpoints,
      base::Optional<std::vector<std::string>> plugin_types,
      std::vector<std::string> parsing_errors);

  ~ContentSecurityPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSecurityPolicyPtr>
  ContentSecurityPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicy::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSecurityPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSecurityPolicy_UnserializedMessageContext<
            UserType, ContentSecurityPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ContentSecurityPolicy::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ContentSecurityPolicy::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSecurityPolicy_UnserializedMessageContext<
            UserType, ContentSecurityPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSecurityPolicy::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::flat_map<CSPDirectiveName, CSPSourceListPtr> directives;
  
  bool upgrade_insecure_requests;
  
  bool treat_as_public_address;
  
  ::network::mojom::WebSandboxFlags sandbox;
  
  ContentSecurityPolicyHeaderPtr header;
  
  bool use_reporting_api;
  
  std::vector<std::string> report_endpoints;
  
  base::Optional<std::vector<std::string>> plugin_types;
  
  std::vector<std::string> parsing_errors;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ContentSecurityPolicy);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CSPViolation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPViolation, T>::value>;
  using DataView = CSPViolationDataView;
  using Data_ = internal::CSPViolation_Data;

  template <typename... Args>
  static CSPViolationPtr New(Args&&... args) {
    return CSPViolationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPViolationPtr From(const U& u) {
    return mojo::TypeConverter<CSPViolationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPViolation>::Convert(*this);
  }


  CSPViolation();

  CSPViolation(
      const std::string& directive,
      const std::string& effective_directive,
      const std::string& console_message,
      const ::GURL& blocked_url,
      std::vector<std::string> report_endpoints,
      bool use_reporting_api,
      const std::string& header,
      ContentSecurityPolicyType type,
      bool after_redirect,
      ::network::mojom::SourceLocationPtr source_location);

  ~CSPViolation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPViolationPtr>
  CSPViolationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPViolation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPViolation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPViolation_UnserializedMessageContext<
            UserType, CSPViolation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CSPViolation::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CSPViolation::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPViolation_UnserializedMessageContext<
            UserType, CSPViolation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPViolation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string directive;
  
  std::string effective_directive;
  
  std::string console_message;
  
  ::GURL blocked_url;
  
  std::vector<std::string> report_endpoints;
  
  bool use_reporting_api;
  
  std::string header;
  
  ContentSecurityPolicyType type;
  
  bool after_redirect;
  
  ::network::mojom::SourceLocationPtr source_location;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CSPViolation);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
AllowCSPFromHeaderValuePtr AllowCSPFromHeaderValue::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::ALLOW_STAR:
      rv->set_allow_star(mojo::Clone(data_.allow_star));
      break;
    case Tag::ORIGIN:
      rv->set_origin(mojo::Clone(*data_.origin));
      break;
    case Tag::ERROR_MESSAGE:
      rv->set_error_message(mojo::Clone(*data_.error_message));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AllowCSPFromHeaderValue>::value>::type*>
bool AllowCSPFromHeaderValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::ALLOW_STAR:
      return mojo::Equals(data_.allow_star, other.data_.allow_star);
    case Tag::ORIGIN:
      return mojo::Equals(*(data_.origin), *(other.data_.origin));
    case Tag::ERROR_MESSAGE:
      return mojo::Equals(*(data_.error_message), *(other.data_.error_message));
  }

  return false;
}
template <typename StructPtrType>
ContentSecurityPolicyHeaderPtr ContentSecurityPolicyHeader::Clone() const {
  return New(
      mojo::Clone(header_value),
      mojo::Clone(type),
      mojo::Clone(source)
  );
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>*>
bool ContentSecurityPolicyHeader::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->header_value, other_struct.header_value))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  return true;
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.header_value, rhs.header_value))
    return true;
  if (std::less<>{}(rhs.header_value, lhs.header_value))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.source, rhs.source))
    return true;
  if (std::less<>{}(rhs.source, lhs.source))
    return false;
  return false;
}
template <typename StructPtrType>
CSPSourcePtr CSPSource::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(host),
      mojo::Clone(port),
      mojo::Clone(path),
      mojo::Clone(is_host_wildcard),
      mojo::Clone(is_port_wildcard)
  );
}

template <typename T, CSPSource::EnableIfSame<T>*>
bool CSPSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->is_host_wildcard, other_struct.is_host_wildcard))
    return false;
  if (!mojo::Equals(this->is_port_wildcard, other_struct.is_port_wildcard))
    return false;
  return true;
}

template <typename T, CSPSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.scheme, rhs.scheme))
    return true;
  if (std::less<>{}(rhs.scheme, lhs.scheme))
    return false;
  if (std::less<>{}(lhs.host, rhs.host))
    return true;
  if (std::less<>{}(rhs.host, lhs.host))
    return false;
  if (std::less<>{}(lhs.port, rhs.port))
    return true;
  if (std::less<>{}(rhs.port, lhs.port))
    return false;
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  if (std::less<>{}(lhs.is_host_wildcard, rhs.is_host_wildcard))
    return true;
  if (std::less<>{}(rhs.is_host_wildcard, lhs.is_host_wildcard))
    return false;
  if (std::less<>{}(lhs.is_port_wildcard, rhs.is_port_wildcard))
    return true;
  if (std::less<>{}(rhs.is_port_wildcard, lhs.is_port_wildcard))
    return false;
  return false;
}
template <typename StructPtrType>
CSPHashSourcePtr CSPHashSource::Clone() const {
  return New(
      mojo::Clone(algorithm),
      mojo::Clone(value)
  );
}

template <typename T, CSPHashSource::EnableIfSame<T>*>
bool CSPHashSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->algorithm, other_struct.algorithm))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, CSPHashSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.algorithm, rhs.algorithm))
    return true;
  if (std::less<>{}(rhs.algorithm, lhs.algorithm))
    return false;
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  return false;
}
template <typename StructPtrType>
CSPSourceListPtr CSPSourceList::Clone() const {
  return New(
      mojo::Clone(sources),
      mojo::Clone(nonces),
      mojo::Clone(hashes),
      mojo::Clone(allow_self),
      mojo::Clone(allow_star),
      mojo::Clone(allow_response_redirects),
      mojo::Clone(allow_inline),
      mojo::Clone(allow_eval),
      mojo::Clone(allow_wasm_eval),
      mojo::Clone(allow_dynamic),
      mojo::Clone(allow_unsafe_hashes),
      mojo::Clone(report_sample)
  );
}

template <typename T, CSPSourceList::EnableIfSame<T>*>
bool CSPSourceList::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  if (!mojo::Equals(this->nonces, other_struct.nonces))
    return false;
  if (!mojo::Equals(this->hashes, other_struct.hashes))
    return false;
  if (!mojo::Equals(this->allow_self, other_struct.allow_self))
    return false;
  if (!mojo::Equals(this->allow_star, other_struct.allow_star))
    return false;
  if (!mojo::Equals(this->allow_response_redirects, other_struct.allow_response_redirects))
    return false;
  if (!mojo::Equals(this->allow_inline, other_struct.allow_inline))
    return false;
  if (!mojo::Equals(this->allow_eval, other_struct.allow_eval))
    return false;
  if (!mojo::Equals(this->allow_wasm_eval, other_struct.allow_wasm_eval))
    return false;
  if (!mojo::Equals(this->allow_dynamic, other_struct.allow_dynamic))
    return false;
  if (!mojo::Equals(this->allow_unsafe_hashes, other_struct.allow_unsafe_hashes))
    return false;
  if (!mojo::Equals(this->report_sample, other_struct.report_sample))
    return false;
  return true;
}

template <typename T, CSPSourceList::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.sources, rhs.sources))
    return true;
  if (std::less<>{}(rhs.sources, lhs.sources))
    return false;
  if (std::less<>{}(lhs.nonces, rhs.nonces))
    return true;
  if (std::less<>{}(rhs.nonces, lhs.nonces))
    return false;
  if (std::less<>{}(lhs.hashes, rhs.hashes))
    return true;
  if (std::less<>{}(rhs.hashes, lhs.hashes))
    return false;
  if (std::less<>{}(lhs.allow_self, rhs.allow_self))
    return true;
  if (std::less<>{}(rhs.allow_self, lhs.allow_self))
    return false;
  if (std::less<>{}(lhs.allow_star, rhs.allow_star))
    return true;
  if (std::less<>{}(rhs.allow_star, lhs.allow_star))
    return false;
  if (std::less<>{}(lhs.allow_response_redirects, rhs.allow_response_redirects))
    return true;
  if (std::less<>{}(rhs.allow_response_redirects, lhs.allow_response_redirects))
    return false;
  if (std::less<>{}(lhs.allow_inline, rhs.allow_inline))
    return true;
  if (std::less<>{}(rhs.allow_inline, lhs.allow_inline))
    return false;
  if (std::less<>{}(lhs.allow_eval, rhs.allow_eval))
    return true;
  if (std::less<>{}(rhs.allow_eval, lhs.allow_eval))
    return false;
  if (std::less<>{}(lhs.allow_wasm_eval, rhs.allow_wasm_eval))
    return true;
  if (std::less<>{}(rhs.allow_wasm_eval, lhs.allow_wasm_eval))
    return false;
  if (std::less<>{}(lhs.allow_dynamic, rhs.allow_dynamic))
    return true;
  if (std::less<>{}(rhs.allow_dynamic, lhs.allow_dynamic))
    return false;
  if (std::less<>{}(lhs.allow_unsafe_hashes, rhs.allow_unsafe_hashes))
    return true;
  if (std::less<>{}(rhs.allow_unsafe_hashes, lhs.allow_unsafe_hashes))
    return false;
  if (std::less<>{}(lhs.report_sample, rhs.report_sample))
    return true;
  if (std::less<>{}(rhs.report_sample, lhs.report_sample))
    return false;
  return false;
}
template <typename StructPtrType>
ContentSecurityPolicyPtr ContentSecurityPolicy::Clone() const {
  return New(
      mojo::Clone(directives),
      mojo::Clone(upgrade_insecure_requests),
      mojo::Clone(treat_as_public_address),
      mojo::Clone(sandbox),
      mojo::Clone(header),
      mojo::Clone(use_reporting_api),
      mojo::Clone(report_endpoints),
      mojo::Clone(plugin_types),
      mojo::Clone(parsing_errors)
  );
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>*>
bool ContentSecurityPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->directives, other_struct.directives))
    return false;
  if (!mojo::Equals(this->upgrade_insecure_requests, other_struct.upgrade_insecure_requests))
    return false;
  if (!mojo::Equals(this->treat_as_public_address, other_struct.treat_as_public_address))
    return false;
  if (!mojo::Equals(this->sandbox, other_struct.sandbox))
    return false;
  if (!mojo::Equals(this->header, other_struct.header))
    return false;
  if (!mojo::Equals(this->use_reporting_api, other_struct.use_reporting_api))
    return false;
  if (!mojo::Equals(this->report_endpoints, other_struct.report_endpoints))
    return false;
  if (!mojo::Equals(this->plugin_types, other_struct.plugin_types))
    return false;
  if (!mojo::Equals(this->parsing_errors, other_struct.parsing_errors))
    return false;
  return true;
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.directives, rhs.directives))
    return true;
  if (std::less<>{}(rhs.directives, lhs.directives))
    return false;
  if (std::less<>{}(lhs.upgrade_insecure_requests, rhs.upgrade_insecure_requests))
    return true;
  if (std::less<>{}(rhs.upgrade_insecure_requests, lhs.upgrade_insecure_requests))
    return false;
  if (std::less<>{}(lhs.treat_as_public_address, rhs.treat_as_public_address))
    return true;
  if (std::less<>{}(rhs.treat_as_public_address, lhs.treat_as_public_address))
    return false;
  if (std::less<>{}(lhs.sandbox, rhs.sandbox))
    return true;
  if (std::less<>{}(rhs.sandbox, lhs.sandbox))
    return false;
  if (std::less<>{}(lhs.header, rhs.header))
    return true;
  if (std::less<>{}(rhs.header, lhs.header))
    return false;
  if (std::less<>{}(lhs.use_reporting_api, rhs.use_reporting_api))
    return true;
  if (std::less<>{}(rhs.use_reporting_api, lhs.use_reporting_api))
    return false;
  if (std::less<>{}(lhs.report_endpoints, rhs.report_endpoints))
    return true;
  if (std::less<>{}(rhs.report_endpoints, lhs.report_endpoints))
    return false;
  if (std::less<>{}(lhs.plugin_types, rhs.plugin_types))
    return true;
  if (std::less<>{}(rhs.plugin_types, lhs.plugin_types))
    return false;
  if (std::less<>{}(lhs.parsing_errors, rhs.parsing_errors))
    return true;
  if (std::less<>{}(rhs.parsing_errors, lhs.parsing_errors))
    return false;
  return false;
}
template <typename StructPtrType>
CSPViolationPtr CSPViolation::Clone() const {
  return New(
      mojo::Clone(directive),
      mojo::Clone(effective_directive),
      mojo::Clone(console_message),
      mojo::Clone(blocked_url),
      mojo::Clone(report_endpoints),
      mojo::Clone(use_reporting_api),
      mojo::Clone(header),
      mojo::Clone(type),
      mojo::Clone(after_redirect),
      mojo::Clone(source_location)
  );
}

template <typename T, CSPViolation::EnableIfSame<T>*>
bool CSPViolation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->directive, other_struct.directive))
    return false;
  if (!mojo::Equals(this->effective_directive, other_struct.effective_directive))
    return false;
  if (!mojo::Equals(this->console_message, other_struct.console_message))
    return false;
  if (!mojo::Equals(this->blocked_url, other_struct.blocked_url))
    return false;
  if (!mojo::Equals(this->report_endpoints, other_struct.report_endpoints))
    return false;
  if (!mojo::Equals(this->use_reporting_api, other_struct.use_reporting_api))
    return false;
  if (!mojo::Equals(this->header, other_struct.header))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->after_redirect, other_struct.after_redirect))
    return false;
  if (!mojo::Equals(this->source_location, other_struct.source_location))
    return false;
  return true;
}

template <typename T, CSPViolation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.directive, rhs.directive))
    return true;
  if (std::less<>{}(rhs.directive, lhs.directive))
    return false;
  if (std::less<>{}(lhs.effective_directive, rhs.effective_directive))
    return true;
  if (std::less<>{}(rhs.effective_directive, lhs.effective_directive))
    return false;
  if (std::less<>{}(lhs.console_message, rhs.console_message))
    return true;
  if (std::less<>{}(rhs.console_message, lhs.console_message))
    return false;
  if (std::less<>{}(lhs.blocked_url, rhs.blocked_url))
    return true;
  if (std::less<>{}(rhs.blocked_url, lhs.blocked_url))
    return false;
  if (std::less<>{}(lhs.report_endpoints, rhs.report_endpoints))
    return true;
  if (std::less<>{}(rhs.report_endpoints, lhs.report_endpoints))
    return false;
  if (std::less<>{}(lhs.use_reporting_api, rhs.use_reporting_api))
    return true;
  if (std::less<>{}(rhs.use_reporting_api, lhs.use_reporting_api))
    return false;
  if (std::less<>{}(lhs.header, rhs.header))
    return true;
  if (std::less<>{}(rhs.header, lhs.header))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.after_redirect, rhs.after_redirect))
    return true;
  if (std::less<>{}(rhs.after_redirect, lhs.after_redirect))
    return false;
  if (std::less<>{}(lhs.source_location, rhs.source_location))
    return true;
  if (std::less<>{}(rhs.source_location, lhs.source_location))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ContentSecurityPolicyHeader::DataView,
                                         ::network::mojom::ContentSecurityPolicyHeaderPtr> {
  static bool IsNull(const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ContentSecurityPolicyHeaderPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ContentSecurityPolicyHeader::header_value)& header_value(
      const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) {
    return input->header_value;
  }

  static decltype(::network::mojom::ContentSecurityPolicyHeader::type) type(
      const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) {
    return input->type;
  }

  static decltype(::network::mojom::ContentSecurityPolicyHeader::source) source(
      const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) {
    return input->source;
  }

  static bool Read(::network::mojom::ContentSecurityPolicyHeader::DataView input, ::network::mojom::ContentSecurityPolicyHeaderPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPSource::DataView,
                                         ::network::mojom::CSPSourcePtr> {
  static bool IsNull(const ::network::mojom::CSPSourcePtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPSourcePtr* output) { output->reset(); }

  static const decltype(::network::mojom::CSPSource::scheme)& scheme(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->scheme;
  }

  static const decltype(::network::mojom::CSPSource::host)& host(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->host;
  }

  static decltype(::network::mojom::CSPSource::port) port(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->port;
  }

  static const decltype(::network::mojom::CSPSource::path)& path(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->path;
  }

  static decltype(::network::mojom::CSPSource::is_host_wildcard) is_host_wildcard(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->is_host_wildcard;
  }

  static decltype(::network::mojom::CSPSource::is_port_wildcard) is_port_wildcard(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->is_port_wildcard;
  }

  static bool Read(::network::mojom::CSPSource::DataView input, ::network::mojom::CSPSourcePtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPHashSource::DataView,
                                         ::network::mojom::CSPHashSourcePtr> {
  static bool IsNull(const ::network::mojom::CSPHashSourcePtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPHashSourcePtr* output) { output->reset(); }

  static decltype(::network::mojom::CSPHashSource::algorithm) algorithm(
      const ::network::mojom::CSPHashSourcePtr& input) {
    return input->algorithm;
  }

  static const decltype(::network::mojom::CSPHashSource::value)& value(
      const ::network::mojom::CSPHashSourcePtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::CSPHashSource::DataView input, ::network::mojom::CSPHashSourcePtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPSourceList::DataView,
                                         ::network::mojom::CSPSourceListPtr> {
  static bool IsNull(const ::network::mojom::CSPSourceListPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPSourceListPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CSPSourceList::sources)& sources(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->sources;
  }

  static const decltype(::network::mojom::CSPSourceList::nonces)& nonces(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->nonces;
  }

  static const decltype(::network::mojom::CSPSourceList::hashes)& hashes(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->hashes;
  }

  static decltype(::network::mojom::CSPSourceList::allow_self) allow_self(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_self;
  }

  static decltype(::network::mojom::CSPSourceList::allow_star) allow_star(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_star;
  }

  static decltype(::network::mojom::CSPSourceList::allow_response_redirects) allow_response_redirects(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_response_redirects;
  }

  static decltype(::network::mojom::CSPSourceList::allow_inline) allow_inline(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_inline;
  }

  static decltype(::network::mojom::CSPSourceList::allow_eval) allow_eval(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_eval;
  }

  static decltype(::network::mojom::CSPSourceList::allow_wasm_eval) allow_wasm_eval(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_wasm_eval;
  }

  static decltype(::network::mojom::CSPSourceList::allow_dynamic) allow_dynamic(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_dynamic;
  }

  static decltype(::network::mojom::CSPSourceList::allow_unsafe_hashes) allow_unsafe_hashes(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_unsafe_hashes;
  }

  static decltype(::network::mojom::CSPSourceList::report_sample) report_sample(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->report_sample;
  }

  static bool Read(::network::mojom::CSPSourceList::DataView input, ::network::mojom::CSPSourceListPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ContentSecurityPolicy::DataView,
                                         ::network::mojom::ContentSecurityPolicyPtr> {
  static bool IsNull(const ::network::mojom::ContentSecurityPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ContentSecurityPolicyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ContentSecurityPolicy::directives)& directives(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->directives;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::upgrade_insecure_requests) upgrade_insecure_requests(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->upgrade_insecure_requests;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::treat_as_public_address) treat_as_public_address(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->treat_as_public_address;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::sandbox) sandbox(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->sandbox;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::header)& header(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->header;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::use_reporting_api) use_reporting_api(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->use_reporting_api;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::report_endpoints)& report_endpoints(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->report_endpoints;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::plugin_types)& plugin_types(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->plugin_types;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::parsing_errors)& parsing_errors(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->parsing_errors;
  }

  static bool Read(::network::mojom::ContentSecurityPolicy::DataView input, ::network::mojom::ContentSecurityPolicyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPViolation::DataView,
                                         ::network::mojom::CSPViolationPtr> {
  static bool IsNull(const ::network::mojom::CSPViolationPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPViolationPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CSPViolation::directive)& directive(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->directive;
  }

  static const decltype(::network::mojom::CSPViolation::effective_directive)& effective_directive(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->effective_directive;
  }

  static const decltype(::network::mojom::CSPViolation::console_message)& console_message(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->console_message;
  }

  static const decltype(::network::mojom::CSPViolation::blocked_url)& blocked_url(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->blocked_url;
  }

  static const decltype(::network::mojom::CSPViolation::report_endpoints)& report_endpoints(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->report_endpoints;
  }

  static decltype(::network::mojom::CSPViolation::use_reporting_api) use_reporting_api(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->use_reporting_api;
  }

  static const decltype(::network::mojom::CSPViolation::header)& header(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->header;
  }

  static decltype(::network::mojom::CSPViolation::type) type(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->type;
  }

  static decltype(::network::mojom::CSPViolation::after_redirect) after_redirect(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->after_redirect;
  }

  static const decltype(::network::mojom::CSPViolation::source_location)& source_location(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->source_location;
  }

  static bool Read(::network::mojom::CSPViolation::DataView input, ::network::mojom::CSPViolationPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::AllowCSPFromHeaderValue::DataView,
                                        ::network::mojom::AllowCSPFromHeaderValuePtr> {
  static bool IsNull(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) { return !input; }
  static void SetToNull(::network::mojom::AllowCSPFromHeaderValuePtr* output) { output->reset(); }

  static ::network::mojom::AllowCSPFromHeaderValue::Tag GetTag(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->which();
  }

  static  bool allow_star(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->get_allow_star();
  }

  static const ::url::Origin& origin(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->get_origin();
  }

  static const std::string& error_message(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->get_error_message();
  }

  static bool Read(::network::mojom::AllowCSPFromHeaderValue::DataView input, ::network::mojom::AllowCSPFromHeaderValuePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_H_